/*
 * Decompiled with CFR 0.152.
 */
package xeij;

public class ByteQueue {
    private volatile Block h;
    private volatile Block t;
    private static final int s = Integer.MAX_VALUE;
    private volatile long w;
    private volatile long r;
    private volatile Thread waitThread;
    private volatile int waitNumber;
    private volatile int cancelNumber;

    public ByteQueue() {
        this.t = this.h = new Block();
        this.r = this.w = 0L;
        this.waitThread = null;
    }

    protected int clear() {
        return this.skip(this.used());
    }

    protected int read() {
        int n = this.h.read();
        if (n < 0) {
            if (this.h == this.t) {
                return n;
            }
            Block block = this.h.n;
            block.p = null;
            this.h.n = null;
            this.h = block;
            n = this.h.read();
        }
        ++this.r;
        return n;
    }

    protected int read(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        long l = this.r;
        int n3 = this.h.read(byArray, n, n2);
        this.r += (long)n3;
        n += n3;
        n2 -= n3;
        while (n2 != 0) {
            if (this.h == this.t) {
                return (int)(this.r - l);
            }
            Block block = this.h.n;
            block.p = null;
            this.h.n = null;
            this.h = block;
            n3 = this.h.read(byArray, n, n2);
            this.r += (long)n3;
            n += n3;
            n2 -= n3;
        }
        return (int)(this.r - l);
    }

    protected int skip(int n) {
        if (n == 0) {
            return 0;
        }
        long l = this.r;
        int n2 = this.h.skip(n);
        this.r += (long)n2;
        n -= n2;
        while (n != 0) {
            if (this.h == this.t) {
                return (int)(this.r - l);
            }
            Block block = this.h.n;
            block.p = null;
            this.h.n = null;
            this.h = block;
            n2 = this.h.skip(n);
            this.r += (long)n2;
            n -= n2;
        }
        return (int)(this.r - l);
    }

    protected int unused() {
        return (int)(this.r + Integer.MAX_VALUE - this.w);
    }

    protected int used() {
        return (int)(this.w - this.r);
    }

    protected int write(int n) {
        Object object;
        if (this.w == this.r + Integer.MAX_VALUE) {
            return 0;
        }
        if (this.t.write(n) == 0) {
            object = new Block();
            ((Block)object).p = this.t;
            this.t.n = object;
            this.t = object;
            this.t.write(n);
        }
        ++this.w;
        object = this.waitThread;
        if (object != null) {
            ((Thread)object).interrupt();
        }
        return 1;
    }

    protected int write(byte[] byArray, int n, int n2) {
        Object object;
        if (n2 == 0) {
            return 0;
        }
        n2 = Math.min(n2, (int)(this.r + Integer.MAX_VALUE - this.w));
        long l = this.w;
        int n3 = this.t.write(byArray, n, n2);
        this.w += (long)n3;
        n += n3;
        n2 -= n3;
        while (n2 != 0) {
            object = new Block();
            ((Block)object).p = this.t;
            this.t.n = object;
            this.t = object;
            n3 = this.t.write(byArray, n, n2);
            this.w += (long)n3;
            n += n3;
            n2 -= n3;
        }
        object = this.waitThread;
        if (object != null) {
            ((Thread)object).interrupt();
        }
        return (int)(this.w - l);
    }

    protected void cancel() {
        Thread thread = this.waitThread;
        if (thread != null) {
            this.cancelNumber = this.waitNumber;
            thread.interrupt();
        }
    }

    protected int waitAndRead() {
        int n = -1;
        this.waitThread = Thread.currentThread();
        ++this.waitNumber;
        while (this.waitNumber != this.cancelNumber && 0 > (n = this.read()) && this.waitNumber != this.cancelNumber) {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.waitThread = null;
        return n;
    }

    protected int waitAndRead(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.waitAndRead();
        if (n3 < 0) {
            return -1;
        }
        byArray[n] = (byte)n3;
        return 1 + this.read(byArray, n + 1, Math.min(n2 - 1, this.used()));
    }

    private static final class Block {
        private volatile Block p = null;
        private volatile Block n = null;
        private static final int s = 65536;
        private static final byte[] a = new byte[65536];
        private volatile long w;
        private volatile long r = this.w = 0L;

        private Block() {
        }

        private int clear() {
            return this.skip(this.used());
        }

        private int read() {
            return this.r != this.w ? a[(int)this.r++ & 0xFFFF] & 0xFF : -1;
        }

        private int read(byte[] byArray, int n, int n2) {
            n2 = Math.min(n2, (int)(this.w - this.r));
            int n3 = n;
            int n4;
            while ((n4 = Math.min(n2, 65536 - ((int)this.r & 0xFFFF))) != 0) {
                System.arraycopy(a, (int)this.r & 0xFFFF, byArray, n, n4);
                this.r += (long)n4;
                n += n4;
                n2 -= n4;
            }
            return n - n3;
        }

        private int skip(int n) {
            n = Math.min(n, (int)(this.w - this.r));
            this.r += (long)n;
            return n;
        }

        private int unused() {
            return (int)(this.r + 65536L - this.w);
        }

        private int used() {
            return (int)(this.w - this.r);
        }

        private int write(int n) {
            if (this.w == this.r + 65536L) {
                return 0;
            }
            Block.a[(int)this.w++ & 0xFFFF] = (byte)n;
            return 1;
        }

        private int write(byte[] byArray, int n, int n2) {
            n2 = Math.min(n2, (int)(this.r + 65536L - this.w));
            int n3 = n;
            int n4;
            while ((n4 = Math.min(n2, 65536 - ((int)this.w & 0xFFFF))) != 0) {
                System.arraycopy(byArray, n, a, (int)this.w & 0xFFFF, n4);
                this.w += (long)n4;
                n += n4;
                n2 -= n4;
            }
            return n - n3;
        }
    }
}

