/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xeij.ComponentFactory;
import xeij.DisassembleList;
import xeij.Disassembler;
import xeij.LabeledAddress;
import xeij.LnF;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.ReverseLongModel;
import xeij.ScrollTextArea;
import xeij.XEiJ;

public class BranchLog {
    public static final boolean BLG_ON = true;
    public static final int BLG_RECORD_SHIFT = 1;
    public static final int[] blgArray = new int[131072];
    public static long blgNewestRecord;
    public static int blgPrevHeadSuper;
    public static int blgPrevTailInt;
    public static int blgHead;
    public static int blgSuper;
    public static int blgInt;
    public static JFrame blgFrame;
    public static SpinnerNumberModel blgModel;
    public static JSpinner blgSpinner;
    public static final int BLG_TEXT_AREA_WIDTH = 400;
    public static final int BLG_TEXT_AREA_HEIGHT = 400;
    public static ScrollTextArea blgScrollTextArea;
    public static JTextArea blgTextArea;
    public static boolean blgLock;
    public static final long BLG_SELECT_OLDEST = -3L;
    public static final long BLG_SELECT_NEWEST = -2L;
    public static final long BLG_SELECT_NONE = -1L;
    public static final int BLG_RECORDS_PER_PAGE = 1000;
    public static int blgNumberOfRecords;
    public static long blgFirstRecord;
    public static long blgLastRecord;
    public static long blgSelectedRecord;
    public static int blgNumberOfItems;
    public static int blgSelectedItem;
    public static final long[] blgRecordArray;
    public static final int[] blgPositionArray;
    public static boolean blgShowUser;
    public static boolean blgShowSupervisor;
    public static boolean blgShowNormal;
    public static boolean blgShowInterrupt;

    public static void blgInit() {
        blgNewestRecord = 0L;
        blgPrevHeadSuper = 0;
        blgPrevTailInt = 0;
        blgHead = 0;
        blgSuper = 0;
        blgInt = 0;
        blgFrame = null;
        blgModel = null;
        blgSpinner = null;
        blgScrollTextArea = null;
        blgTextArea = null;
        blgLock = false;
        blgNumberOfRecords = 0;
        blgFirstRecord = -1L;
        blgLastRecord = -1L;
        blgSelectedRecord = -1L;
        blgNumberOfItems = 0;
        blgSelectedItem = -1;
        blgShowUser = true;
        blgShowSupervisor = true;
        blgShowNormal = true;
        blgShowInterrupt = true;
    }

    public static void blgReset() {
        blgNewestRecord = 0L;
        blgPrevHeadSuper = 0;
        blgPrevTailInt = 0;
        blgHead = XEiJ.regPC;
        blgSuper = XEiJ.regSRS >>> 13;
        blgInt = XEiJ.mpuISR == 0 ? 0 : 1;
        blgNumberOfRecords = 0;
        blgFirstRecord = -1L;
        blgLastRecord = -1L;
        blgSelectedRecord = -1L;
        blgNumberOfItems = 0;
        blgSelectedItem = -1;
        DisassembleList.ddpBacktraceRecord = -1L;
    }

    public static void blgStop() {
        int n = (char)blgNewestRecord << 1;
        BranchLog.blgArray[n] = blgHead | blgSuper;
        BranchLog.blgArray[n + 1] = XEiJ.regPC | blgInt;
    }

    public static void blgJump(int n) {
        if (blgPrevHeadSuper != (blgHead | blgSuper) || blgPrevTailInt != (XEiJ.regPC0 | blgInt)) {
            int n2 = (char)blgNewestRecord++ << 1;
            BranchLog.blgArray[n2] = blgPrevHeadSuper = blgHead | blgSuper;
            BranchLog.blgArray[n2 + 1] = blgPrevTailInt = XEiJ.regPC0 | blgInt;
        }
        blgHead = XEiJ.regPC = n;
        blgSuper = XEiJ.regSRS >>> 13;
        blgInt = XEiJ.mpuISR == 0 ? 0 : 1;
    }

    public static void blgMakeFrame() {
        blgScrollTextArea = ComponentFactory.setPreferredSize(ComponentFactory.setFont(new ScrollTextArea(), LnF.lnfMonospacedFont), 400, 400);
        blgScrollTextArea.setMargin(new Insets(2, 4, 2, 4));
        blgScrollTextArea.setHighlightCursorOn(true);
        blgTextArea = blgScrollTextArea.getTextArea();
        blgTextArea.setEditable(false);
        blgTextArea.setText(Multilingual.mlnJapanese ? "MPU \u304c\u52d5\u4f5c\u4e2d\u3067\u3059" : "MPU is running");
        blgTextArea.setCaretPosition(0);
        blgTextArea.addMouseWheelListener(mouseWheelEvent -> {
            int n = mouseWheelEvent.getWheelRotation();
            JViewport jViewport = blgScrollTextArea.getViewport();
            Point point = jViewport.getViewPosition();
            jViewport.setViewPosition(new Point(point.x, Math.max(0, Math.min(BranchLog.blgTextArea.getSize().height - jViewport.getExtentSize().height, point.y + n * blgTextArea.getFont().getSize() * 5))));
        });
        ComponentFactory.addListener(blgTextArea, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, blgTextArea, false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, blgTextArea, false);
                }
            }
        });
        ComponentFactory.addListener(blgTextArea, new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                int n;
                if (blgSelectedRecord >= 0L && !blgLock && XEiJ.dbgEventMask == 0 && (n = caretEvent.getDot()) == caretEvent.getMark()) {
                    int n2 = Arrays.binarySearch(blgPositionArray, 1, blgNumberOfItems, n + 1);
                    if (blgSelectedItem != (n2 = (n2 >> 31 ^ n2) - 1)) {
                        if (n2 == 0) {
                            BranchLog.blgUpdate(Math.max(0L, blgFirstRecord - 1L));
                        } else if (n2 <= blgNumberOfRecords) {
                            long l;
                            blgLock = true;
                            blgSelectedRecord = l = blgRecordArray[n2];
                            blgSelectedItem = n2;
                            if (blgModel.getNumber().longValue() != l) {
                                blgModel.setValue(l);
                            }
                            blgLock = false;
                        } else {
                            BranchLog.blgUpdate(blgLastRecord + 1L);
                        }
                    }
                }
            }
        });
        blgModel = new ReverseLongModel(0L, 0L, Long.MAX_VALUE, 1L);
        blgSpinner = ComponentFactory.createNumberSpinner(blgModel, 10, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!blgLock) {
                    BranchLog.blgUpdate(blgModel.getNumber().longValue());
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                switch (actionEvent.getActionCommand()) {
                    case "Clear": {
                        BranchLog.blgReset();
                        BranchLog.blgArray[0] = XEiJ.regPC | XEiJ.regSRS >>> 13;
                        BranchLog.blgArray[1] = XEiJ.regPC | (XEiJ.mpuISR == 0 ? 0 : 1);
                        BranchLog.blgUpdate(-2L);
                        break;
                    }
                    case "Oldest record": {
                        if (blgSelectedRecord < 0L) break;
                        BranchLog.blgUpdate(-3L);
                        break;
                    }
                    case "Previous page": {
                        if (blgSelectedRecord < 0L) break;
                        BranchLog.blgUpdate(blgFirstRecord < blgSelectedRecord ? blgFirstRecord : Math.max(0L, blgFirstRecord - 1000L));
                        break;
                    }
                    case "Previous record": {
                        if (blgSelectedRecord <= 0L) break;
                        if (blgTextArea.getCaretPosition() != blgPositionArray[blgSelectedItem]) {
                            blgTextArea.setCaretPosition(blgPositionArray[blgSelectedItem]);
                            break;
                        }
                        BranchLog.blgUpdate(blgSelectedRecord - 1L);
                        break;
                    }
                    case "Next record": {
                        if (blgSelectedRecord < 0L) break;
                        BranchLog.blgUpdate(blgSelectedRecord + 1L);
                        break;
                    }
                    case "Next page": {
                        if (blgSelectedRecord < 0L) break;
                        BranchLog.blgUpdate(blgSelectedRecord < blgLastRecord ? blgLastRecord : blgLastRecord + 1000L);
                        break;
                    }
                    case "Newest record": {
                        if (blgSelectedRecord < 0L) break;
                        BranchLog.blgUpdate(-2L);
                        break;
                    }
                    case "User": {
                        blgShowUser = ((JCheckBox)object).isSelected();
                        BranchLog.blgUpdate(-1L);
                        break;
                    }
                    case "Supervisor": {
                        blgShowSupervisor = ((JCheckBox)object).isSelected();
                        BranchLog.blgUpdate(-1L);
                        break;
                    }
                    case "Normal": {
                        blgShowNormal = ((JCheckBox)object).isSelected();
                        BranchLog.blgUpdate(-1L);
                        break;
                    }
                    case "Interrupt": {
                        blgShowInterrupt = ((JCheckBox)object).isSelected();
                        BranchLog.blgUpdate(-1L);
                    }
                }
            }
        };
        JButton jButton = XEiJ.mpuAddButtonStopped(Multilingual.mlnToolTipText(ComponentFactory.createImageButton(LnF.LNF_CLEAR_IMAGE, LnF.LNF_CLEAR_DISABLED_IMAGE, "Clear", actionListener), "ja", "\u30af\u30ea\u30a2"));
        JButton jButton2 = XEiJ.mpuAddButtonStopped(Multilingual.mlnToolTipText(ComponentFactory.createImageButton(LnF.LNF_OLDEST_IMAGE, LnF.LNF_OLDEST_DISABLED_IMAGE, "Oldest record", actionListener), "ja", "\u6700\u53e4\u306e\u30ec\u30b3\u30fc\u30c9"));
        JButton jButton3 = XEiJ.mpuAddButtonStopped(Multilingual.mlnToolTipText(ComponentFactory.createImageButton(LnF.LNF_OLDER_IMAGE, LnF.LNF_OLDER_DISABLED_IMAGE, "Previous page", actionListener), "ja", "\u524d\u306e\u30da\u30fc\u30b8"));
        JButton jButton4 = XEiJ.mpuAddButtonStopped(Multilingual.mlnToolTipText(ComponentFactory.createImageButton(LnF.LNF_PREVIOUS_IMAGE, LnF.LNF_PREVIOUS_DISABLED_IMAGE, "Previous record", actionListener), "ja", "\u524d\u306e\u30ec\u30b3\u30fc\u30c9"));
        JButton jButton5 = XEiJ.mpuAddButtonStopped(Multilingual.mlnToolTipText(ComponentFactory.createImageButton(LnF.LNF_NEXT_IMAGE, LnF.LNF_NEXT_DISABLED_IMAGE, "Next record", actionListener), "ja", "\u6b21\u306e\u30ec\u30b3\u30fc\u30c9"));
        JButton jButton6 = XEiJ.mpuAddButtonStopped(Multilingual.mlnToolTipText(ComponentFactory.createImageButton(LnF.LNF_NEWER_IMAGE, LnF.LNF_NEWER_DISABLED_IMAGE, "Next page", actionListener), "ja", "\u6b21\u306e\u30da\u30fc\u30b8"));
        JButton jButton7 = XEiJ.mpuAddButtonStopped(Multilingual.mlnToolTipText(ComponentFactory.createImageButton(LnF.LNF_NEWEST_IMAGE, LnF.LNF_NEWEST_DISABLED_IMAGE, "Newest record", actionListener), "ja", "\u6700\u65b0\u306e\u30ec\u30b3\u30fc\u30c9"));
        JCheckBox jCheckBox = ComponentFactory.createIconCheckBox(blgShowUser, LnF.LNF_USER_IMAGE, LnF.LNF_USER_SELECTED_IMAGE, "User", actionListener);
        JCheckBox jCheckBox2 = ComponentFactory.createIconCheckBox(blgShowSupervisor, LnF.LNF_SUPERVISOR_IMAGE, LnF.LNF_SUPERVISOR_SELECTED_IMAGE, "Supervisor", actionListener);
        JCheckBox jCheckBox3 = ComponentFactory.createIconCheckBox(blgShowNormal, LnF.LNF_NORMAL_IMAGE, LnF.LNF_NORMAL_SELECTED_IMAGE, "Normal", actionListener);
        JCheckBox jCheckBox4 = ComponentFactory.createIconCheckBox(blgShowInterrupt, LnF.LNF_INTERRUPT_IMAGE, LnF.LNF_INTERRUPT_SELECTED_IMAGE, "Interrupt", actionListener);
        blgFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("blg", "Branch log", null, ComponentFactory.createBorderPanel(blgScrollTextArea, ComponentFactory.createVerticalBox(ComponentFactory.createHorizontalBox(jButton, Box.createHorizontalGlue(), Box.createHorizontalStrut(12), XEiJ.mpuMakeOriIllegalCheckBox(), XEiJ.mpuMakeStopOnErrorCheckBox(), XEiJ.mpuMakeStopAtStartCheckBox(), Box.createHorizontalStrut(12), XEiJ.mpuMakeBreakButton(), XEiJ.mpuMakeTraceButton(), XEiJ.mpuMakeTrace10Button(), XEiJ.mpuMakeTrace100Button(), XEiJ.mpuMakeStepButton(), XEiJ.mpuMakeStep10Button(), XEiJ.mpuMakeStep100Button(), XEiJ.mpuMakeReturnButton(), XEiJ.mpuMakeRunButton()), ComponentFactory.createHorizontalBox(blgSpinner, Box.createHorizontalStrut(12), jButton2, jButton3, jButton4, jButton5, jButton6, jButton7, Box.createHorizontalStrut(12), jCheckBox, jCheckBox2, jCheckBox3, jCheckBox4, Box.createHorizontalGlue())))), "ja", "\u5206\u5c90\u30ed\u30b0");
        ComponentFactory.addListener(blgFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFFFF7;
            }
        });
    }

    public static void blgStart() {
        if (RestorableFrame.rfmGetOpened("blg")) {
            BranchLog.blgOpen(-1L);
        }
    }

    public static void blgOpen(long l) {
        if (blgFrame == null) {
            BranchLog.blgMakeFrame();
        }
        XEiJ.dbgVisibleMask |= 8;
        BranchLog.blgUpdate(l);
        XEiJ.pnlExitFullScreen(false);
        blgFrame.setVisible(true);
    }

    public static void blgUpdate(long l) {
        if (XEiJ.mpuTask != null) {
            blgLock = true;
            blgTextArea.setText(Multilingual.mlnJapanese ? "MPU \u304c\u52d5\u4f5c\u4e2d\u3067\u3059" : "MPU is running");
            blgTextArea.setCaretPosition(0);
            blgLock = false;
            return;
        }
        if (blgLock) {
            return;
        }
        blgLock = true;
        BranchLog.blgStop();
        long l2 = blgNewestRecord;
        long l3 = Math.max(0L, l2 - 65535L);
        if (l < 0L) {
            if (l == -1L) {
                l = blgSelectedRecord < 0L ? l2 : blgSelectedRecord;
            } else if (l == -2L) {
                l = l2;
            } else if (l == -3L) {
                l = l3;
            }
        }
        if (l < l3) {
            l = l3;
        } else if (l > l2) {
            l = l2;
        }
        long l4 = l / 1000L * 1000L;
        long l5 = l4 + 999L;
        if (l4 < l3) {
            l4 = l3;
        }
        if (l5 > l2) {
            l5 = l2;
        }
        if (blgFirstRecord != l4 || blgLastRecord != l5 || blgLastRecord == blgNewestRecord) {
            blgFirstRecord = l4;
            blgLastRecord = l5;
            blgSelectedRecord = l;
            int n = -1;
            BranchLog.blgRecordArray[0] = l4 - 1L;
            BranchLog.blgPositionArray[0] = 0;
            StringBuilder stringBuilder = new StringBuilder(l4 == l3 ? (Multilingual.mlnJapanese ? "\u2500\u2500\u2500\u2500\u2500 \u5206\u5c90\u30ed\u30b0\u306e\u5148\u982d \u2500\u2500\u2500\u2500\u2500\n" : "\u2500\u2500\u2500\u2500\u2500 Top of the branch log \u2500\u2500\u2500\u2500\u2500\n") : (Multilingual.mlnJapanese ? "\u2191\u2191\u2191\u2191\u2191 \u624b\u524d\u306e\u30da\u30fc\u30b8 \u2191\u2191\u2191\u2191\u2191\n" : "\u2191\u2191\u2191\u2191\u2191 Previous page \u2191\u2191\u2191\u2191\u2191\n"));
            int n2 = 1;
            for (long i = l4; i <= l5; ++i) {
                int n3 = (char)i << 1;
                int n4 = blgArray[n3] & 0xFFFFFFFE;
                int n5 = blgArray[n3] & 1;
                int n6 = blgArray[n3 + 1] & 0xFFFFFFFE;
                int n7 = blgArray[n3 + 1] & 1;
                if (i == l) {
                    blgSelectedItem = n2;
                }
                BranchLog.blgRecordArray[n2] = i;
                BranchLog.blgPositionArray[n2] = stringBuilder.length();
                stringBuilder.append(i);
                stringBuilder.append(n5 == 0 ? "[U" : "[S");
                stringBuilder.append(n7 == 0 ? "N]  " : "I]  ");
                XEiJ.fmtHex8(stringBuilder, n4);
                LabeledAddress.lblSearch(stringBuilder, n4);
                stringBuilder.append('\n');
                if ((n5 == 0 ? blgShowUser : blgShowSupervisor) && (n7 == 0 ? blgShowNormal : blgShowInterrupt)) {
                    Disassembler.disPC = n4;
                    while (Disassembler.disPC <= n6) {
                        if (i == l && Disassembler.disPC == XEiJ.regPC) {
                            n = stringBuilder.length();
                        }
                        Disassembler.disDisassemble(XEiJ.fmtHex8(stringBuilder.append("  "), Disassembler.disPC).append("  "), Disassembler.disPC, n5).append('\n');
                        if ((Disassembler.disStatus & 1) == 0) continue;
                        stringBuilder.append('\n');
                    }
                }
                ++n2;
            }
            BranchLog.blgRecordArray[n2] = l5 + 1L;
            BranchLog.blgPositionArray[n2] = stringBuilder.length();
            stringBuilder.append(l5 == l2 ? (Multilingual.mlnJapanese ? "\u2500\u2500\u2500\u2500\u2500 \u5206\u5c90\u30ed\u30b0\u306e\u672b\u5c3e \u2500\u2500\u2500\u2500\u2500" : "\u2500\u2500\u2500\u2500\u2500 Bottom of the branch log \u2500\u2500\u2500\u2500\u2500") : (Multilingual.mlnJapanese ? "\u2193\u2193\u2193\u2193\u2193 \u6b21\u306e\u30da\u30fc\u30b8 \u2193\u2193\u2193\u2193\u2193" : "\u2193\u2193\u2193\u2193\u2193 Next page \u2193\u2193\u2193\u2193\u2193"));
            BranchLog.blgPositionArray[++n2] = stringBuilder.length();
            blgNumberOfRecords = n2 - 2;
            blgNumberOfItems = n2;
            blgTextArea.setText(stringBuilder.toString());
            blgTextArea.setCaretPosition(n >= 0 ? n : blgPositionArray[blgSelectedItem]);
        } else if (blgSelectedRecord != l) {
            blgSelectedRecord = l;
            blgSelectedItem = (int)(blgSelectedRecord - blgFirstRecord) + 1;
            blgTextArea.setCaretPosition(blgPositionArray[blgSelectedItem]);
        }
        if (blgModel.getNumber().longValue() != l) {
            blgModel.setValue(l);
        }
        blgLock = false;
    }

    static {
        blgRecordArray = new long[1002];
        blgPositionArray = new int[1003];
    }
}

