;========================================================================================
;  bgcstest.s
;  Copyright (C) 2003-2026 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

	.include	control2.mac
	.include	doscall.mac
	.include	iocscall.mac
	.include	misc.mac
	.include	sprc.equ
	.include	vicon.equ

dPARAM	reg	d7			;

;ǂݎ
	addq.l	#1,a2
	moveq.l	#0,dPARAM
	moveq.l	#7-1,d1
	for	d1
		do
			move.b	(a2)+,d0
			if	eq
				pea.l	usage
				DOS	_PRINT
				addq.l	#4,sp
				goto	exit
			endif
		whileor	<cmp.b #'0',d0>,lo,<cmp.b #'1',d0>,hi
		if	<cmp.b #'1',d0>,eq
			bset.l	d1,dPARAM
		endif
	next

;sizeɉăXvCgʂ
	if	<btst.l #6,dPARAM>,eq	;8x8
		moveq.l	#2,d1			;256x256 1024x1024x16
	else				;16x16
		moveq.l	#0,d1			;512x512 1024x1024x16
	endif
	IOCS	_CRTMOD
	IOCS	_SP_INIT
	IOCS	_SP_ON
;		  SP TX GR G4 G3 G2 G1
	move.w	#%01_00_10_11_10_01_00,d1	;TX>SP>GR
	IOCS	_PRIORITY

;X[p[oCU[h
	supervisormode

;cs0text0$0FFBŖߐs
	andi.w	#.notw.$0400,SPRC_CONTROL	;mpucs=0
	lea.l	SPRC_TEXT_0,a0
	move.w	#$0FFB,d0
	move.w	#64*64-1,d1
	for	d1
		move.w	d0,(a0)+
	next

;cs0text1$0FFCŖߐs
	andi.w	#.notw.$0400,SPRC_CONTROL	;mpucs=0
	lea.l	SPRC_TEXT_1,a0
	move.w	#$0FFC,d0
	move.w	#64*64-1,d1
	for	d1
		move.w	d0,(a0)+
	next

;cs1text0$0FFDŖߐs
	ori.w	#$0400,SPRC_CONTROL	;mpucs=1
	lea.l	SPRC_TEXT_0,a0
	move.w	#$0FFD,d0
	move.w	#64*64-1,d1
	for	d1
		move.w	d0,(a0)+
	next

;cs1text1$0FFEŖߐs
	ori.w	#$0400,SPRC_CONTROL	;mpucs=1
	lea.l	SPRC_TEXT_1,a0
	move.w	#$0FFE,d0
	move.w	#64*64-1,d1
	for	d1
		move.w	d0,(a0)+
	next

;sizeɉcs0̃p^[$FB`$FFɈقȂp^[ݒ肷
	andi.w	#.notw.$0400,SPRC_CONTROL	;mpucs=0
	if	<btst.l #6,dPARAM>,eq	;8x8
		lea.l	SPRC_PATTERN+4*8*$FB,a0
		lea.l	pattern_8x8_FB,a1
		moveq.l	#8*5-1,d1
		for	d1
			move.l	(a1)+,(a0)+
		next
	else				;16x16
		lea.l	SPRC_PATTERN+4*32*$FB,a0
		lea.l	pattern_16x16_FB,a1
		move.w	#32*5-1,d1
		for	d1
			move.l	(a1)+,(a0)+
		next
	endif

;pbgubN$Fݒ肷
	lea.l	VICON_TSPALET+2*16*$F,a0
	lea.l	palet,a1
	moveq.l	#16-1,d1
	for	d1
		move.w	(a1)+,(a0)+
	next

;$00EB0808 bit5-0b1cs b1tx b1on b0cs b0tx b0onݒ肷
	moveq.l	#63,d0
	and.w	dPARAM,d0
	or.w	#SPRC_SPRITE_ON,d0
	move.w	d0,SPRC_CONTROL

;[U[[h
	usermode

;\
	lea.l	-16(sp),sp
	movea.l	sp,a0
	moveq.l	#7-1,d1
	for	d1
		moveq.l	#'0',d0
		if	<btst.l d1,d7>,ne
			moveq.l	#'1',d0
		endif
		move.b	d0,(a0)+
	next
	move.b	#13,(a0)+
	move.b	#10,(a0)+
	clr.b	(a0)
	move.l	sp,-(sp)
	DOS	_PRINT
	lea.l	4+16(sp),sp

;I
exit:
	DOS	_EXIT

;p^[8x8
pattern_8x8_FB:
;8x8 $FB
	.dc.l	$BBBBBBBB
	.dc.l	$BBBBBBB0
	.dc.l	$BBBBBB00
	.dc.l	$BBBBB000
	.dc.l	$BBBB0000
	.dc.l	$BBB00000
	.dc.l	$BB000000
	.dc.l	$B0000000
;8x8 $FC
	.dc.l	$CCCCCCCC
	.dc.l	$0CCCCCCC
	.dc.l	$00CCCCCC
	.dc.l	$000CCCCC
	.dc.l	$0000CCCC
	.dc.l	$00000CCC
	.dc.l	$000000CC
	.dc.l	$0000000C
;8x8 $FD
	.dc.l	$D0000000
	.dc.l	$DD000000
	.dc.l	$DDD00000
	.dc.l	$DDDD0000
	.dc.l	$DDDDD000
	.dc.l	$DDDDDD00
	.dc.l	$DDDDDDD0
	.dc.l	$DDDDDDDD
;8x8 $FE
	.dc.l	$0000000E
	.dc.l	$000000EE
	.dc.l	$00000EEE
	.dc.l	$0000EEEE
	.dc.l	$000EEEEE
	.dc.l	$00EEEEEE
	.dc.l	$0EEEEEEE
	.dc.l	$EEEEEEEE
;8x8 $FF
	.dc.l	$00000000
	.dc.l	$0F000F00
	.dc.l	$00F0F000
	.dc.l	$000F0000
	.dc.l	$00F0F000
	.dc.l	$0F000F00
	.dc.l	$00000000
	.dc.l	$00000000

;p^[16x16
pattern_16x16_FB:
;16x16 $FB
;
  .rept 8
	.dc.l	$BBBBBBBB
  .endm
	.dc.l	$BBBBBBBB
	.dc.l	$BBBBBBB0
	.dc.l	$BBBBBB00
	.dc.l	$BBBBB000
	.dc.l	$BBBB0000
	.dc.l	$BBB00000
	.dc.l	$BB000000
	.dc.l	$B0000000
;E
	.dc.l	$BBBBBBBB
	.dc.l	$BBBBBBB0
	.dc.l	$BBBBBB00
	.dc.l	$BBBBB000
	.dc.l	$BBBB0000
	.dc.l	$BBB00000
	.dc.l	$BB000000
	.dc.l	$B0000000
  .rept 8
	.dc.l	$00000000
  .endm
;16x16 $FC
;
	.dc.l	$CCCCCCCC
	.dc.l	$0CCCCCCC
	.dc.l	$00CCCCCC
	.dc.l	$000CCCCC
	.dc.l	$0000CCCC
	.dc.l	$00000CCC
	.dc.l	$000000CC
	.dc.l	$0000000C
  .rept 8
	.dc.l	$00000000
  .endm
;E
  .rept 8
	.dc.l	$CCCCCCCC
  .endm
	.dc.l	$CCCCCCCC
	.dc.l	$0CCCCCCC
	.dc.l	$00CCCCCC
	.dc.l	$000CCCCC
	.dc.l	$0000CCCC
	.dc.l	$00000CCC
	.dc.l	$000000CC
	.dc.l	$0000000C
;16x16 $FD
;
	.dc.l	$D0000000
	.dc.l	$DD000000
	.dc.l	$DDD00000
	.dc.l	$DDDD0000
	.dc.l	$DDDDD000
	.dc.l	$DDDDDD00
	.dc.l	$DDDDDDD0
	.dc.l	$DDDDDDDD
  .rept 8
	.dc.l	$DDDDDDDD
  .endm
;E
  .rept 8
	.dc.l	$00000000
  .endm
	.dc.l	$D0000000
	.dc.l	$DD000000
	.dc.l	$DDD00000
	.dc.l	$DDDD0000
	.dc.l	$DDDDD000
	.dc.l	$DDDDDD00
	.dc.l	$DDDDDDD0
	.dc.l	$DDDDDDDD
;16x16 $FE
;
  .rept 8
	.dc.l	$00000000
  .endm
	.dc.l	$0000000E
	.dc.l	$000000EE
	.dc.l	$00000EEE
	.dc.l	$0000EEEE
	.dc.l	$000EEEEE
	.dc.l	$00EEEEEE
	.dc.l	$0EEEEEEE
	.dc.l	$EEEEEEEE
;E
	.dc.l	$0000000E
	.dc.l	$000000EE
	.dc.l	$00000EEE
	.dc.l	$0000EEEE
	.dc.l	$000EEEEE
	.dc.l	$00EEEEEE
	.dc.l	$0EEEEEEE
	.dc.l	$EEEEEEEE
  .rept 8
	.dc.l	$EEEEEEEE
  .endm
;16x16 $FF
;
	.dc.l	$00000000
	.dc.l	$00F00000
	.dc.l	$0FFF0000
	.dc.l	$00FFF000
	.dc.l	$000FFF00
	.dc.l	$0000FFF0
	.dc.l	$00000FFF
	.dc.l	$000000FF
	.dc.l	$00000FFF
	.dc.l	$0000FFF0
	.dc.l	$000FFF00
	.dc.l	$00FFF000
	.dc.l	$0FFF0000
	.dc.l	$00F00000
	.dc.l	$00000000
	.dc.l	$00000000
;E
	.dc.l	$00000000
	.dc.l	$0000F000
	.dc.l	$000FFF00
	.dc.l	$00FFF000
	.dc.l	$0FFF0000
	.dc.l	$FFF00000
	.dc.l	$FF000000
	.dc.l	$F0000000
	.dc.l	$FF000000
	.dc.l	$FFF00000
	.dc.l	$0FFF0000
	.dc.l	$00FFF000
	.dc.l	$000FFF00
	.dc.l	$0000F000
	.dc.l	$00000000
	.dc.l	$00000000

;pbg
palet:
	dchsv	0,0,0			;$0
	dchsv	0,0,0			;$1
	dchsv	0,0,0			;$2
	dchsv	0,0,0			;$3
	dchsv	0,0,0			;$4
	dchsv	0,0,0			;$5
	dchsv	0,0,0			;$6
	dchsv	0,0,0			;$7
	dchsv	0,0,0			;$8
	dchsv	0,0,0			;$9
	dchsv	0,0,0			;$A
	dchsv	128,31,16		;$B 
	dchsv	96,31,16		;$C 
	dchsv	64,31,16		;$D 
	dchsv	32,31,16		;$E 
	dchsv	0,31,16			;$F 

;gp@
usage:
	.dc.b	'BG chip select test',13,10
	.dc.b	'usage: bgcstest.x size b1cs b1tx b1on b0cs b0tx b0on',13,10
	.dc.b	'  size  0=8x8    1=16x16  pattern size',13,10
	.dc.b	'  b1cs  0=PCS0   1=PCS1   chip select for text used by BG1',13,10
	.dc.b	'  b1tx  0=TEXT0  1=TEXT1  text used by BG1',13,10
	.dc.b	'  b1on  0=OFF    1=ON     whether to display BG1',13,10
	.dc.b	'  b0cs  0=PCS0   1=PCS1   chip select for text used by BG0',13,10
	.dc.b	'  b0tx  0=TEXT0  1=TEXT1  text used by BG0',13,10
	.dc.b	'  b0on  0=OFF    1=ON     whether to display BG0',13,10
	.dc.b	'colors:',13,10
	.dc.b	'  blue    PCS0 TEXT0',13,10
	.dc.b	'  cyan    PCS0 TEXT1',13,10
	.dc.b	'  green   PCS1 TEXT0',13,10
	.dc.b	'  yellow  PCS1 TEXT1',13,10
	.dc.b	'  red     full pattern memory is not available',13,10
	.dc.b	0
