/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;

public final class ZKeyLEDPort
implements AutoCloseable {
    private boolean debugFlag;
    private static final MemoryLayout GUID = MemoryLayout.structLayout(ValueLayout.JAVA_INT.withName("Data1"), ValueLayout.JAVA_SHORT.withName("Data2"), ValueLayout.JAVA_SHORT.withName("Data3"), MemoryLayout.sequenceLayout(8L, ValueLayout.JAVA_BYTE).withName("Data4"));
    private static final MemoryLayout HIDD_ATTRIBUTES = MemoryLayout.structLayout(ValueLayout.JAVA_INT.withName("Size"), ValueLayout.JAVA_SHORT.withName("VendorID"), ValueLayout.JAVA_SHORT.withName("ProductID"), ValueLayout.JAVA_SHORT.withName("VersionNumber"), MemoryLayout.paddingLayout(2L));
    private static final MemoryLayout HIDP_CAPS = MemoryLayout.structLayout(ValueLayout.JAVA_SHORT.withName("Usage"), ValueLayout.JAVA_SHORT.withName("UsagePage"), ValueLayout.JAVA_SHORT.withName("InputReportByteLength"), ValueLayout.JAVA_SHORT.withName("OutputReportByteLength"), ValueLayout.JAVA_SHORT.withName("FeatureReportByteLength"), MemoryLayout.sequenceLayout(17L, ValueLayout.JAVA_SHORT).withName("Reserved"), ValueLayout.JAVA_SHORT.withName("NumberLinkCollectionNodes"), ValueLayout.JAVA_SHORT.withName("NumberInputButtonCaps"), ValueLayout.JAVA_SHORT.withName("NumberInputValueCaps"), ValueLayout.JAVA_SHORT.withName("NumberInputDataIndices"), ValueLayout.JAVA_SHORT.withName("NumberOutputButtonCaps"), ValueLayout.JAVA_SHORT.withName("NumberOutputValueCaps"), ValueLayout.JAVA_SHORT.withName("NumberOutputDataIndices"), ValueLayout.JAVA_SHORT.withName("NumberFeatureButtonCaps"), ValueLayout.JAVA_SHORT.withName("NumberFeatureValueCaps"), ValueLayout.JAVA_SHORT.withName("NumberFeatureDataIndices"));
    private static final int INPUT_KEYBOARD = 1;
    private static final int KEYEVENTF_KEYUP = 2;
    private static final MemoryLayout INPUT = MemoryLayout.structLayout(ValueLayout.JAVA_INT.withName("type"), MemoryLayout.paddingLayout(4L), MemoryLayout.unionLayout(MemoryLayout.structLayout(ValueLayout.JAVA_INT.withName("dx"), ValueLayout.JAVA_INT.withName("dy"), ValueLayout.JAVA_INT.withName("mouseData"), ValueLayout.JAVA_INT.withName("dwFlags"), ValueLayout.JAVA_INT.withName("time"), MemoryLayout.paddingLayout(4L), ValueLayout.ADDRESS.withName("dwExtraInfo")).withName("mi"), MemoryLayout.structLayout(ValueLayout.JAVA_SHORT.withName("wVk"), ValueLayout.JAVA_SHORT.withName("wScan"), ValueLayout.JAVA_INT.withName("dwFlags"), ValueLayout.JAVA_INT.withName("time"), MemoryLayout.paddingLayout(4L), ValueLayout.ADDRESS.withName("dwExtraInfo")).withName("ki"), MemoryLayout.structLayout(ValueLayout.JAVA_INT.withName("uMsg"), ValueLayout.JAVA_SHORT.withName("wParamL"), ValueLayout.JAVA_SHORT.withName("wParamH")).withName("hi")).withName("DUMMYUNIONNAME"));
    private static final MemoryLayout SP_DEVICE_INTERFACE_DATA = MemoryLayout.structLayout(ValueLayout.JAVA_INT.withName("cbSize"), GUID.withName("InterfaceClassGuid"), ValueLayout.JAVA_INT.withName("Flags"), ValueLayout.ADDRESS.withName("Reserved"));
    private static final int ANYSIZE_ARRAY = 1;
    private static final MemoryLayout SP_DEVICE_INTERFACE_DETAIL_DATA_W = MemoryLayout.structLayout(ValueLayout.JAVA_INT.withName("cbSize"), MemoryLayout.sequenceLayout(1L, ValueLayout.JAVA_SHORT).withName("DevicePath"), MemoryLayout.paddingLayout(2L));
    private final int ERROR_INSUFFICIENT_BUFFER = 122;
    private final int ERROR_NO_MORE_ITEMS = 259;
    private Linker linker;
    private Arena arena;
    private MethodHandle CloseHandle;
    private static final int FILE_SHARE_READ = 1;
    private static final int FILE_SHARE_WRITE = 2;
    private static final int OPEN_EXISTING = 3;
    private static final long INVALID_HANDLE_VALUE = -1L;
    private MethodHandle CreateFileW;
    private MethodHandle GetKeyState;
    private MethodHandle GetLastError;
    private MethodHandle HidD_FreePreparsedData;
    private MethodHandle HidD_GetAttributes;
    private MethodHandle HidD_GetHidGuid;
    private MethodHandle HidD_GetPreparsedData;
    private MethodHandle HidD_SetFeature;
    private static final int HIDP_STATUS_SUCCESS = 0x110000;
    private MethodHandle HidP_GetCaps;
    private MethodHandle SendInput;
    private MethodHandle SetupDiDestroyDeviceInfoList;
    private MethodHandle SetupDiEnumDeviceInterfaces;
    private static final int DIGCF_PRESENT = 2;
    private static final int DIGCF_DEVICEINTERFACE = 16;
    private MethodHandle SetupDiGetClassDevsA;
    private MethodHandle SetupDiGetDeviceInterfaceDetailW;
    private MemorySegment handle;
    private static final int[] indexes = new int[]{7, 8, 9, 10, 11, 13, 14};

    public void setDebugFlag(boolean bl) {
        this.debugFlag = bl;
    }

    private MethodHandle downcallHandle(MemorySegment memorySegment, FunctionDescriptor functionDescriptor) {
        return this.linker.downcallHandle(memorySegment, functionDescriptor, new Linker.Option[0]);
    }

    public ZKeyLEDPort(boolean bl) throws IOException {
        this.debugFlag = bl;
        if (bl) {
            System.out.println("ZKeyLEDPort(\"" + bl + "\")");
        }
        this.linker = Linker.nativeLinker();
        this.arena = Arena.ofAuto();
        SymbolLookup symbolLookup = SymbolLookup.libraryLookup("hid", this.arena);
        SymbolLookup symbolLookup2 = SymbolLookup.libraryLookup("kernel32", this.arena);
        SymbolLookup symbolLookup3 = SymbolLookup.libraryLookup("setupapi", this.arena);
        SymbolLookup symbolLookup4 = SymbolLookup.libraryLookup("user32", this.arena);
        try {
            this.CloseHandle = this.downcallHandle(symbolLookup2.findOrThrow("CloseHandle"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
            this.CreateFileW = this.downcallHandle(symbolLookup2.findOrThrow("CreateFileW"), FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
            this.GetKeyState = this.downcallHandle(symbolLookup4.findOrThrow("GetKeyState"), FunctionDescriptor.of(ValueLayout.JAVA_SHORT, ValueLayout.JAVA_INT));
            this.GetLastError = this.downcallHandle(symbolLookup2.findOrThrow("GetLastError"), FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]));
            this.HidD_FreePreparsedData = this.downcallHandle(symbolLookup.findOrThrow("HidD_FreePreparsedData"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
            this.HidD_GetAttributes = this.downcallHandle(symbolLookup.findOrThrow("HidD_GetAttributes"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
            this.HidD_GetHidGuid = this.downcallHandle(symbolLookup.findOrThrow("HidD_GetHidGuid"), FunctionDescriptor.ofVoid(ValueLayout.ADDRESS));
            this.HidD_GetPreparsedData = this.downcallHandle(symbolLookup.findOrThrow("HidD_GetPreparsedData"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
            this.HidD_SetFeature = this.downcallHandle(symbolLookup.findOrThrow("HidD_SetFeature"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
            this.HidP_GetCaps = this.downcallHandle(symbolLookup.findOrThrow("HidP_GetCaps"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
            this.SendInput = this.downcallHandle(symbolLookup4.findOrThrow("SendInput"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
            this.SetupDiDestroyDeviceInfoList = this.downcallHandle(symbolLookup3.findOrThrow("SetupDiDestroyDeviceInfoList"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
            this.SetupDiEnumDeviceInterfaces = this.downcallHandle(symbolLookup3.findOrThrow("SetupDiEnumDeviceInterfaces"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
            this.SetupDiGetClassDevsA = this.downcallHandle(symbolLookup3.findOrThrow("SetupDiGetClassDevsA"), FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT));
            this.SetupDiGetDeviceInterfaceDetailW = this.downcallHandle(symbolLookup3.findOrThrow("SetupDiGetDeviceInterfaceDetailW"), FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.ADDRESS, ValueLayout.ADDRESS));
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
        }
        this.handle = null;
        this.open();
    }

    @Override
    public void close() {
        block4: {
            if (this.handle == null || this.handle.address() == -1L) {
                return;
            }
            try {
                int n;
                if (this.CloseHandle.invoke(this.handle) == 0 && (n = this.GetLastError.invoke()) != -1 && this.debugFlag) {
                    System.out.printf("close: CloseHandle failed (%d)\n", n);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (!this.debugFlag) break block4;
                System.out.printf("close: CloseHandle invocation failed\n", new Object[0]);
            }
        }
        this.handle = null;
    }

    public void hitKey(int n) {
        block3: {
            MemorySegment memorySegment = this.arena.allocate(INPUT.byteSize() * 2L, INPUT.byteAlignment());
            memorySegment.fill((byte)0);
            memorySegment.set(ValueLayout.JAVA_INT, INPUT.byteOffset(MemoryLayout.PathElement.groupElement("type")), 1);
            memorySegment.set(ValueLayout.JAVA_SHORT, INPUT.byteOffset(MemoryLayout.PathElement.groupElement("DUMMYUNIONNAME"), MemoryLayout.PathElement.groupElement("ki"), MemoryLayout.PathElement.groupElement("wVk")), (short)n);
            memorySegment.set(ValueLayout.JAVA_INT, INPUT.byteSize() + INPUT.byteOffset(MemoryLayout.PathElement.groupElement("type")), 1);
            memorySegment.set(ValueLayout.JAVA_SHORT, INPUT.byteSize() + INPUT.byteOffset(MemoryLayout.PathElement.groupElement("DUMMYUNIONNAME"), MemoryLayout.PathElement.groupElement("ki"), MemoryLayout.PathElement.groupElement("wVk")), (short)n);
            memorySegment.set(ValueLayout.JAVA_INT, INPUT.byteSize() + INPUT.byteOffset(MemoryLayout.PathElement.groupElement("DUMMYUNIONNAME"), MemoryLayout.PathElement.groupElement("ki"), MemoryLayout.PathElement.groupElement("dwFlags")), 2);
            try {
                int n2;
                if (this.SendInput.invoke(2, memorySegment, (int)INPUT.byteSize()) == 0 && (n2 = this.GetLastError.invoke()) != -1 && this.debugFlag) {
                    System.out.printf("hitKey: SendInput failed (%d)\n", n2);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (!this.debugFlag) break block3;
                System.out.printf("hitKey: SendInput invocation failed\n", new Object[0]);
            }
        }
    }

    public boolean isKeyPressed(int n) {
        try {
            return (this.GetKeyState.invoke(n) & 0x80) != 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.debugFlag) {
                System.out.printf("isKeyPressed: GetKeyState invocation failed\n", new Object[0]);
            }
            return false;
        }
    }

    public boolean isKeyToggled(int n) {
        try {
            return (this.GetKeyState.invoke(n) & 1) != 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.debugFlag) {
                System.out.printf("isKeyToggled: GetKeyState invocation failed\n", new Object[0]);
            }
            return false;
        }
    }

    private void printCaps(String string) {
        block25: {
            MemorySegment memorySegment;
            block24: {
                int n;
                MemorySegment memorySegment2;
                block23: {
                    block22: {
                        System.out.printf("--------------------------------------\n", new Object[0]);
                        System.out.printf("%s\n", string);
                        System.out.printf("--------------------------------------\n", new Object[0]);
                        try {
                            int n2;
                            memorySegment = this.CreateFileW.invoke(this.arena.allocateFrom(string, StandardCharsets.UTF_16LE), 0, 3, MemorySegment.NULL, 3, 0, MemorySegment.NULL);
                            if (memorySegment.address() == -1L && (n2 = this.GetLastError.invoke()) != -1) {
                                System.out.printf("printCaps: CreateFileW %s failed (%d)\n", string, n2);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            if (this.debugFlag) {
                                System.out.printf("printCaps: CreateFileW invocation failed\n", new Object[0]);
                            }
                            return;
                        }
                        MemorySegment memorySegment3 = this.arena.allocate(HIDD_ATTRIBUTES);
                        memorySegment3.fill((byte)0);
                        try {
                            int n3;
                            if (this.HidD_GetAttributes.invoke(memorySegment, memorySegment3) == 0 && (n3 = this.GetLastError.invoke()) != -1) {
                                System.out.printf("printCaps: HidD_GetAttributes failed (%d)\n", n3);
                            } else {
                                System.out.printf("VendorID\t\t\t0x%04x\n", 0xFFFF & memorySegment3.get(ValueLayout.JAVA_SHORT, HIDD_ATTRIBUTES.byteOffset(MemoryLayout.PathElement.groupElement("VendorID"))));
                                System.out.printf("ProductID\t\t\t0x%04x\n", 0xFFFF & memorySegment3.get(ValueLayout.JAVA_SHORT, HIDD_ATTRIBUTES.byteOffset(MemoryLayout.PathElement.groupElement("ProductID"))));
                                System.out.printf("VersionNumber\t\t\t0x%04x\n", 0xFFFF & memorySegment3.get(ValueLayout.JAVA_SHORT, HIDD_ATTRIBUTES.byteOffset(MemoryLayout.PathElement.groupElement("VersionNumber"))));
                                System.out.printf("--------------------------------------\n", new Object[0]);
                            }
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            if (!this.debugFlag) break block22;
                            System.out.printf("printCaps: HidD_GetAttributes invocation failed\n", new Object[0]);
                        }
                    }
                    MemorySegment memorySegment4 = this.arena.allocate(ValueLayout.ADDRESS);
                    memorySegment4.fill((byte)0);
                    try {
                        int n4;
                        if (this.HidD_GetPreparsedData.invoke(memorySegment, memorySegment4) == 0 && (n4 = this.GetLastError.invoke()) != -1) {
                            System.out.printf("printCaps: HidD_GetPreparsedData failed (%d)\n", n4);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        if (this.debugFlag) {
                            System.out.printf("printCaps: HidD_GetPreparsedData invocation failed\n", new Object[0]);
                        }
                        return;
                    }
                    memorySegment2 = memorySegment4.get(ValueLayout.ADDRESS, 0L);
                    MemorySegment memorySegment5 = this.arena.allocate(HIDP_CAPS);
                    memorySegment5.fill((byte)0);
                    try {
                        n = this.HidP_GetCaps.invoke(memorySegment2, memorySegment5);
                        if (n != 0x110000) {
                            System.out.printf("printCaps: HidP_GetCaps failed (0x%08x)\n", n);
                        } else {
                            System.out.printf("Usage\t\t\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("Usage"))));
                            System.out.printf("UsagePage\t\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("UsagePage"))));
                            System.out.printf("InputReportByteLength\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("InputReportByteLength"))));
                            System.out.printf("OutputReportByteLength\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("OutputReportByteLength"))));
                            System.out.printf("FeatureReportByteLength\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("FeatureReportByteLength"))));
                            System.out.printf("NumberLinkCollectionNodes\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("NumberLinkCollectionNodes"))));
                            System.out.printf("NumberInputButtonCaps\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("NumberInputButtonCaps"))));
                            System.out.printf("NumberInputValueCaps\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("NumberInputValueCaps"))));
                            System.out.printf("NumberInputDataIndices\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("NumberInputDataIndices"))));
                            System.out.printf("NumberOutputButtonCaps\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("NumberOutputButtonCaps"))));
                            System.out.printf("NumberOutputValueCaps\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("NumberOutputValueCaps"))));
                            System.out.printf("NumberOutputDataIndices\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("NumberOutputDataIndices"))));
                            System.out.printf("NumberFeatureButtonCaps\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("NumberFeatureButtonCaps"))));
                            System.out.printf("NumberFeatureValueCaps\t\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("NumberFeatureValueCaps"))));
                            System.out.printf("NumberFeatureDataIndices\t0x%04x\n", 0xFFFF & memorySegment5.get(ValueLayout.JAVA_SHORT, HIDP_CAPS.byteOffset(MemoryLayout.PathElement.groupElement("NumberFeatureDataIndices"))));
                            System.out.printf("--------------------------------------\n", new Object[0]);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        if (!this.debugFlag) break block23;
                        System.out.printf("printCaps: HidP_GetCaps invocation failed\n", new Object[0]);
                    }
                }
                try {
                    if (this.HidD_FreePreparsedData.invoke(memorySegment2) == 0 && (n = this.GetLastError.invoke()) != -1) {
                        System.out.printf("printCaps: HidD_FreePreparsedData failed (%d)\n", n);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    if (!this.debugFlag) break block24;
                    System.out.printf("printCaps: HidD_FreePreparsedData invocation failed\n", new Object[0]);
                }
            }
            try {
                int n;
                if (this.CloseHandle.invoke(memorySegment) == 0 && (n = this.GetLastError.invoke()) != -1) {
                    System.out.printf("printCaps: CloseHandle failed (%d)\n", n);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (!this.debugFlag) break block25;
                System.out.printf("printCaps: CloseHandle invocation failed\n", new Object[0]);
            }
        }
    }

    public void open() throws IOException {
        MemorySegment memorySegment;
        block51: {
            if (this.handle != null && this.handle.address() != -1L) {
                if (this.debugFlag) {
                    System.out.printf("open: already open\n", new Object[0]);
                }
                throw new IOException("already open");
            }
            memorySegment = this.arena.allocate(GUID);
            memorySegment.fill((byte)0);
            try {
                this.HidD_GetHidGuid.invoke(memorySegment);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                if (!this.debugFlag) break block51;
                System.out.printf("open: HidD_GetHidGuid invocation failed\n", new Object[0]);
            }
        }
        MemorySegment memorySegment2 = this.arena.allocate(ValueLayout.ADDRESS);
        try {
            int n;
            memorySegment2 = this.SetupDiGetClassDevsA.invoke(memorySegment, MemorySegment.NULL, MemorySegment.NULL, 18);
            if (memorySegment2.address() == -1L && (n = this.GetLastError.invoke()) != -1) {
                if (this.debugFlag) {
                    System.out.printf("open: SetupDiGetClassDevsA failed (%d)\n", n);
                }
                throw new IOException("SetupDiGetClassDevsA failed");
            }
            if (this.debugFlag) {
                System.out.printf("open: SetupDiGetClassDevsA success\n", new Object[0]);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.debugFlag) {
                System.out.printf("open: SetupDiGetClassDevsA invocation failed\n", new Object[0]);
            }
            return;
        }
        String string = "";
        MemorySegment memorySegment3 = this.arena.allocate(SP_DEVICE_INTERFACE_DATA);
        int n = 0;
        while (true) {
            block53: {
                MemorySegment memorySegment4;
                block55: {
                    int n2;
                    block54: {
                        block52: {
                            memorySegment3.fill((byte)0);
                            memorySegment3.set(ValueLayout.JAVA_INT, SP_DEVICE_INTERFACE_DATA.byteOffset(MemoryLayout.PathElement.groupElement("cbSize")), (int)SP_DEVICE_INTERFACE_DATA.byteSize());
                            try {
                                int n3;
                                if (this.SetupDiEnumDeviceInterfaces.invoke(memorySegment2, MemorySegment.NULL, memorySegment, n, memorySegment3) == 0 && (n3 = this.GetLastError.invoke()) != -1) {
                                    if (n3 != 0 && n3 != 259) {
                                        if (!this.debugFlag) break;
                                        System.out.printf("open: index %d, SetupDiEnumDeviceInterfaces failed (%d)\n", n, n3);
                                        break;
                                    }
                                    if (!this.debugFlag) break;
                                    System.out.printf("open: index %d, no more items\n", n);
                                }
                                break block52;
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                                if (!this.debugFlag) break;
                                System.out.printf("open: index %d, SetupDiEnumDeviceInterfaces invocation failed\n", n);
                            }
                            break;
                        }
                        if (this.debugFlag) {
                            System.out.printf("open: index %d, SetupDiEnumDeviceInterfaces success\n", n);
                        }
                        MemorySegment memorySegment5 = this.arena.allocate(ValueLayout.JAVA_INT);
                        try {
                            int n4;
                            if (this.SetupDiGetDeviceInterfaceDetailW.invoke(memorySegment2, memorySegment3, MemorySegment.NULL, 0, memorySegment5, MemorySegment.NULL) == 0 && (n4 = this.GetLastError.invoke()) != -1) {
                                if (n4 != 0 && n4 != 122) {
                                    if (this.debugFlag) {
                                        System.out.printf("open: index %d, SetupDiGetDeviceInterfaceDetail failed (%d)\n", n, n4);
                                    }
                                    break block53;
                                }
                                n2 = memorySegment5.get(ValueLayout.JAVA_INT, 0L);
                                if (!this.debugFlag) break block54;
                                System.out.printf("open: index %d, SetupDiGetDeviceInterfaceDetail insufficient buffer, detailSize %d\n", n, n2);
                                break block54;
                            }
                            if (this.debugFlag) {
                                System.out.printf("open: index %d, SetupDiGetDeviceInterfaceDetail unexpected success\n", n);
                            }
                            break block53;
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                            if (this.debugFlag) {
                                System.out.printf("open: index %d, SetupDiGetDeviceInterfaceDetailW invocation failed\n", n);
                            }
                            break block53;
                        }
                    }
                    memorySegment4 = this.arena.allocate(n2, 4L);
                    memorySegment4.fill((byte)0);
                    memorySegment4.set(ValueLayout.JAVA_INT, SP_DEVICE_INTERFACE_DETAIL_DATA_W.byteOffset(MemoryLayout.PathElement.groupElement("cbSize")), (int)SP_DEVICE_INTERFACE_DETAIL_DATA_W.byteSize());
                    try {
                        int n5;
                        if (this.SetupDiGetDeviceInterfaceDetailW.invoke(memorySegment2, memorySegment3, memorySegment4, n2, MemorySegment.NULL, MemorySegment.NULL) == 0 && (n5 = this.GetLastError.invoke()) != -1) {
                            if (this.debugFlag) {
                                System.out.printf("open: index %d, SetupDiGetDeviceInterfaceDetail failed (%d)\n", n, n5);
                            }
                            break block53;
                        }
                        if (!this.debugFlag) break block55;
                        System.out.printf("open: index %d, SetupDiGetDeviceInterfaceDetail success\n", n);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                        if (this.debugFlag) {
                            System.out.printf("open: index %d, SetupDiGetDeviceInterfaceDetailW invocation failed\n", n);
                        }
                        break block53;
                    }
                }
                String string2 = memorySegment4.getString(SP_DEVICE_INTERFACE_DETAIL_DATA_W.byteOffset(MemoryLayout.PathElement.groupElement("DevicePath")), StandardCharsets.UTF_16LE);
                String string3 = string2.toLowerCase();
                if (this.debugFlag) {
                    this.printCaps(string2);
                }
                if (string3.indexOf("vid_33dd&pid_0011&mi_01&col05") == -1) {
                    if (this.debugFlag) {
                        System.out.printf("open: index %d, mismatch\n", n);
                    }
                } else {
                    if (this.debugFlag) {
                        System.out.printf("open: index %d, match\n", n);
                    }
                    string = string2;
                }
            }
            ++n;
        }
        try {
            if (this.SetupDiDestroyDeviceInfoList.invoke(memorySegment2) == 0 && (n = this.GetLastError.invoke()) != -1) {
                if (this.debugFlag) {
                    System.out.printf("open: SetupDiDestroyDeviceInfoList failed (%d)\n", n);
                }
                throw new IOException("SetupDiDestroyDeviceInfoList failed");
            }
            if (this.debugFlag) {
                System.out.printf("open: SetupDiDestroyDeviceInfoList success\n", new Object[0]);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.debugFlag) {
                System.out.printf("open: SetupDiDestroyDeviceInfoList invocation failed\n", new Object[0]);
            }
            return;
        }
        if (string.equals("")) {
            if (this.debugFlag) {
                System.out.printf("open: device not found\n", new Object[0]);
            }
            throw new IOException("device not found");
        }
        if (this.debugFlag) {
            System.out.printf("open: device found\n", new Object[0]);
        }
        try {
            this.handle = this.CreateFileW.invoke(this.arena.allocateFrom(string, StandardCharsets.UTF_16LE), 0, 3, MemorySegment.NULL, 3, 0, MemorySegment.NULL);
            if (this.handle.address() == -1L && (n = this.GetLastError.invoke()) != -1) {
                if (this.debugFlag) {
                    System.out.printf("open: CreateFile %s failed (%d)\n", string, n);
                    System.out.printf("open: device not available\n", new Object[0]);
                }
                throw new IOException("device not available");
            }
            if (this.debugFlag) {
                System.out.printf("open: CreateFile %s success\n", string);
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.debugFlag) {
                System.out.printf("open: CreateFileW invocation failed\n", new Object[0]);
            }
            return;
        }
    }

    public boolean send(long l) {
        int n;
        if (this.handle == null || this.handle.address() == -1L) {
            return false;
        }
        MemorySegment memorySegment = this.arena.allocate(65L);
        memorySegment.fill((byte)0);
        memorySegment.set(ValueLayout.JAVA_BYTE, 0L, (byte)10);
        memorySegment.set(ValueLayout.JAVA_BYTE, 1L, (byte)-8);
        for (n = 0; n < 7; ++n) {
            memorySegment.set(ValueLayout.JAVA_BYTE, (long)indexes[n], (byte)(l >> 8 * n));
        }
        try {
            if (this.HidD_SetFeature.invoke(this.handle, memorySegment, 65) == 0 && (n = this.GetLastError.invoke()) != -1) {
                if (this.debugFlag) {
                    System.out.printf("send: HidD_SetFeature failed (%d)\n", n);
                }
                return false;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.debugFlag) {
                System.out.printf("send: HidD_SetFeature invocation failed\n", new Object[0]);
            }
            return false;
        }
        return true;
    }
}

