/*
 * Decompiled with CFR 0.152.
 */
package xeij;

public class TickerQueue {
    static final int TKQ_S = 256;
    static final Ticker[] tkqArray = new Ticker[256];
    static int tkqR;
    static int tkqW;
    static final boolean TKQ_NULL = true;

    public static void tkqInit() {
        tkqR = 0;
        tkqW = 0;
    }

    public static void tkqRun(long l) {
        while (tkqR != tkqW) {
            Ticker ticker = tkqArray[tkqR & 0xFF];
            if (ticker.time > l) break;
            ticker.time = Long.MAX_VALUE;
            TickerQueue.tkqArray[TickerQueue.tkqR & 0xFF] = null;
            ++tkqR;
            ticker.tick();
        }
    }

    public static void tkqAdd(Ticker ticker, long l) {
        TickerQueue.tkqRemove(ticker);
        if (tkqW - tkqR == 256) {
            throw new Error("tkqAdd: overflow");
        }
        ticker.time = l;
        for (int i = tkqW; tkqR < i; --i) {
            Ticker ticker2 = tkqArray[i - 1 & 0xFF];
            if (l >= ticker2.time) break;
            TickerQueue.tkqArray[i & 0xFF] = ticker2;
        }
        TickerQueue.tkqArray[i & 0xFF] = ticker;
        ++tkqW;
    }

    public static void tkqRemove(Ticker ticker) {
        if (ticker.time == Long.MAX_VALUE) {
            return;
        }
        ticker.time = Long.MAX_VALUE;
        int n = tkqR;
        while (tkqArray[n & 0xFF] != ticker) {
            ++n;
        }
        while (tkqR < n) {
            TickerQueue.tkqArray[n & 0xFF] = tkqArray[n - 1 & 0xFF];
            --n;
        }
        TickerQueue.tkqArray[n & 0xFF] = null;
        ++tkqR;
    }

    static void tkqTest() {
        int n;
        int n2 = 200;
        Ticker[] tickerArray = new Ticker[n2];
        for (n = 0; n < n2; ++n) {
            tickerArray[n] = new Ticker(){

                @Override
                void tick() {
                }
            };
        }
        for (n = 0; n < n2; ++n) {
            TickerQueue.tkqAdd(tickerArray[n], n);
        }
        if (tkqW - tkqR != n2) {
            System.out.println("tkqTest: error 1");
            return;
        }
        for (n = 0; n < n2; ++n) {
            if (tkqArray[tkqR + n & 0xFF] == tickerArray[n]) continue;
            System.out.println("tkqTest: error 2");
            return;
        }
        for (n = 0; n < n2; ++n) {
            TickerQueue.tkqRemove(tickerArray[n]);
        }
        if (tkqW - tkqR != 0) {
            System.out.println("tkqTest: error 3");
            return;
        }
        for (n = 0; n < n2; ++n) {
            TickerQueue.tkqAdd(tickerArray[n], n);
        }
        if (tkqW - tkqR != n2) {
            System.out.println("tkqTest: error 4");
            return;
        }
        for (n = 0; n < n2; ++n) {
            if (tkqArray[tkqR + n & 0xFF] == tickerArray[n]) continue;
            System.out.println("tkqTest: error 5");
            return;
        }
        for (n = 0; n < n2; ++n) {
            TickerQueue.tkqRemove(tickerArray[n2 - 1 - n]);
        }
        if (tkqW - tkqR != 0) {
            System.out.println("tkqTest: error 6");
            return;
        }
        for (n = 0; n < n2; ++n) {
            TickerQueue.tkqAdd(tickerArray[n2 - 1 - n], n2 - 1 - n);
        }
        if (tkqW - tkqR != n2) {
            System.out.println("tkqTest: error 7");
            return;
        }
        for (n = 0; n < n2; ++n) {
            if (tkqArray[tkqR + n & 0xFF] == tickerArray[n]) continue;
            System.out.println("tkqTest: error 8");
            return;
        }
        for (n = 0; n < n2; ++n) {
            TickerQueue.tkqRemove(tickerArray[n]);
        }
        if (tkqW - tkqR != 0) {
            System.out.println("tkqTest: error 9");
            return;
        }
        for (n = 0; n < n2; ++n) {
            TickerQueue.tkqAdd(tickerArray[n2 - 1 - n], n2 - 1 - n);
        }
        if (tkqW - tkqR != n2) {
            System.out.println("tkqTest: error 10");
            return;
        }
        for (n = 0; n < n2; ++n) {
            if (tkqArray[tkqR + n & 0xFF] == tickerArray[n]) continue;
            System.out.println("tkqTest: error 11");
            return;
        }
        for (n = 0; n < n2; ++n) {
            TickerQueue.tkqRemove(tickerArray[n2 - 1 - n]);
        }
        if (tkqW - tkqR != 0) {
            System.out.println("tkqTest: error 12");
            return;
        }
    }

    public static abstract class Ticker {
        long time = Long.MAX_VALUE;

        Ticker() {
        }

        abstract void tick();
    }
}

