/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import xeij.ComponentFactory;
import xeij.MouseEvent2D;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.ScrollCanvas;
import xeij.Settings;
import xeij.SpriteScreen;
import xeij.VideoController;
import xeij.XEiJ;

public class SpritePatternViewer {
    public static final boolean SPV_ON = true;
    static final int SPV_CELL_WIDTH = 36;
    static final int SPV_CELL_HEIGHT = 36;
    static final int SPV_GROUP_GAP = 4;
    static final String SPV_FONT_NAME = "Dialog";
    static final int SPV_FONT_STYLE = 1;
    static final int SPV_FONT_SIZE = 16;
    static final int SPV_HEADER_WIDTH = 48;
    static final int SPV_HEADER_HEIGHT = 16;
    static int spvImageWidth;
    static int spvImageHeight;
    static BufferedImage spvBufferedImage;
    static int[] spvBitmap;
    static ScrollCanvas spvCanvas;
    static final int SPV_BACKGROUND_RGB = -13421773;
    static final int SPV_FOREGROUND_RGB = -3355444;
    static final int SPV_GRAY_LINE_RGB = -6710887;
    static final int SPV_BLOCK_DOT_RGB = -1;
    static final int SPV_DEF_BANK = 0;
    static final int SPV_MIN_BANK = 0;
    static final int SPV_MAX_BANK = 20;
    static int spvBankNumber;
    static JComboBox<String> spvBankComboBox;
    static int spvCellOffset;
    static int spvColsBit;
    static int spvRowsBit;
    static int spvColsMask;
    static int spvRowsMask;
    static int spvWidth;
    static int spvHeight;
    static final int SPV_DEF_SIZE = -1;
    static final int SPV_MIN_SIZE = -1;
    static final int SPV_MAX_SIZE = 1;
    static final int SPV_LAST_SIZE = 1;
    static int spvSizeNumber;
    static JComboBox<String> spvSizeComboBox;
    static final int[] spvLastSizeArray;
    static final int[] spvSizeArray;
    static final int SPV_DEF_BLOCK = -1;
    static final int SPV_MIN_BLOCK = -1;
    static final int SPV_MAX_BLOCK = 15;
    static final int SPV_LAST_BLOCK = 1;
    static int spvBlockNumber;
    static JComboBox<String> spvBlockComboBox;
    static final int[] spvLastBlockArray;
    static final int[] spvBlockArray;
    static final int SPV_DEF_FLIP = -1;
    static final int SPV_MIN_FLIP = -1;
    static final int SPV_MAX_FLIP = 3;
    static final int SPV_LAST_FLIP = 0;
    static int spvFlipNumber;
    static JComboBox<String> spvFlipComboBox;
    static final int[] spvLastFlipArray;
    static final int[] spvFlipArray;
    static final int SPV_DEF_SCALE = 0;
    static final int SPV_MIN_SCALE = -1;
    static final int SPV_MAX_SCALE = 4;
    static int spvScaleNumber;
    static JComboBox<String> spvScaleComboBox;
    static final boolean SPV_DEF_HEX = false;
    static boolean spvHex;
    static boolean spvStopped;
    static boolean spvStoppedRequest;
    static final short[] spvCopiedNum;
    static final short[] spvCopiedCol;
    static final byte[] spvCopiedPrw;
    static final boolean[] spvCopiedH;
    static final boolean[] spvCopiedV;
    static final int[] spvCopiedPat;
    static final short[] spvCopiedTNum;
    static final short[] spvCopiedTCol;
    static final boolean[] spvCopiedTH;
    static final boolean[] spvCopiedTV;
    static final int[] spvCopiedPalTbl;
    static final int[] spvCopiedPal16TS;
    static short[] spvNum;
    static short[] spvCol;
    static byte[] spvPrw;
    static boolean[] spvH;
    static boolean[] spvV;
    static int[] spvPat;
    static short[] spvTNum;
    static short[] spvTCol;
    static boolean[] spvTH;
    static boolean[] spvTV;
    static int[] spvPalTbl;
    static int[] spvPal16TS;
    static final int[] spvPal32TS;
    static JTextField spvTextField;
    static boolean spvTextLocked;
    static JFrame spvFrame;
    static JPopupMenu spvPopupMenu;
    static int spvOffsetToCopy;
    static int spvLengthToCopy;
    public static final int SPV_INTERVAL = 10;
    public static int spvTimer;

    public static void spvInit() {
        spvBankNumber = Settings.sgsGetInt("spvbank", 0, 0, 20);
        spvBlockNumber = Settings.sgsGetInt("spvblock", -1, -1, 15);
        spvFlipNumber = Settings.sgsGetInt("spvflip", -1, -1, 3);
        spvHex = Settings.sgsGetOnOff("spvhex", false);
        spvScaleNumber = Settings.sgsGetInt("spvscale", 0, -1, 4);
        spvSizeNumber = Settings.sgsGetInt("spvsize", -1, -1, 1);
        spvImageWidth = 2412;
        spvImageHeight = 2380;
        SpritePatternViewer.spvSetBankNumber(spvBankNumber);
        Arrays.fill(spvLastSizeArray, 1);
        Arrays.fill(spvLastBlockArray, 1);
        Arrays.fill(spvLastFlipArray, 0);
        SpritePatternViewer.spvSetStoppedOff();
        spvFrame = null;
        spvTimer = 0;
    }

    public static void spvTini() {
        Settings.sgsPutInt("spvbank", spvBankNumber);
        Settings.sgsPutInt("spvblock", spvBlockNumber);
        Settings.sgsPutInt("spvflip", spvFlipNumber);
        Settings.sgsPutOnOff("spvhex", spvHex);
        Settings.sgsPutInt("spvscale", spvScaleNumber);
        Settings.sgsPutInt("spvsize", spvSizeNumber);
    }

    static void spvSetBankNumber(int n) {
        spvBankNumber = n;
        int n2 = spvBankNumber < 16 ? spvBankNumber << 8 : (spvCellOffset = spvBankNumber < 20 ? spvBankNumber - 16 << 10 : 0);
        spvRowsBit = spvBankNumber < 16 ? 4 : (spvBankNumber < 20 ? 5 : 6);
        spvColsBit = spvRowsBit;
        spvColsMask = spvRowsMask = (1 << spvRowsBit) - 1;
        spvWidth = 48 + (36 << spvColsBit) + (4 << spvColsBit - 2) - 4;
        spvHeight = 16 + (36 << spvRowsBit) + (4 << spvRowsBit - 2) - 4;
        if (spvCanvas != null) {
            SpritePatternViewer.spvDrawHeader();
            spvCanvas.setImage(spvWidth, spvHeight);
        }
    }

    static int spvColToX(int n) {
        int n2 = n >> 2;
        return 48 + 148 * n2 + 36 * (n &= 3);
    }

    static int spvRowToY(int n) {
        int n2 = n >> 2;
        return 16 + 148 * n2 + 36 * (n &= 3);
    }

    static int spvXToXCol(int n) {
        int n2;
        if (n < 0 || spvWidth <= n) {
            return -1;
        }
        if (n < 48) {
            return -1;
        }
        n -= 48;
        if (144 <= (n -= 148 * (n2 = n / 148))) {
            return -1;
        }
        int n3 = n / 36;
        return (n -= 36 * n3) << 16 | (n2 << 2) + n3;
    }

    static int spvYToYRow(int n) {
        int n2;
        if (n < 0 || spvHeight <= n) {
            return -1;
        }
        if (n < 16) {
            return -1;
        }
        n -= 16;
        if (144 <= (n -= 148 * (n2 = n / 148))) {
            return -1;
        }
        int n3 = n / 36;
        return (n -= 36 * n3) << 16 | (n2 << 2) + n3;
    }

    public static void spvStart() {
        if (RestorableFrame.rfmGetOpened("spv")) {
            SpritePatternViewer.spvOpen();
        }
    }

    public static void spvOpen() {
        if (spvFrame == null) {
            SpritePatternViewer.spvMakeFrame();
        } else {
            SpritePatternViewer.spvUpdateFrame();
        }
        XEiJ.dbgVisibleMask |= 0x800;
        XEiJ.pnlExitFullScreen(false);
        spvFrame.setVisible(true);
    }

    static void spvMakeFrame() {
        spvBufferedImage = new BufferedImage(spvImageWidth, spvImageHeight, 2);
        SpritePatternViewer.spvDrawHeader();
        spvBitmap = ((DataBufferInt)spvBufferedImage.getRaster().getDataBuffer()).getData();
        spvCanvas = new ScrollCanvas(spvBufferedImage, spvWidth, spvHeight);
        spvCanvas.setMatColor(new Color(-13421773));
        spvCanvas.setMinScaleShift(-1);
        spvCanvas.setMaxScaleShift(4);
        spvCanvas.setScaleShift(spvScaleNumber);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                switch (string = actionEvent.getActionCommand()) {
                    case "Bank": {
                        SpritePatternViewer.spvSetBankNumber(spvBankComboBox.getSelectedIndex() + 0);
                        if (XEiJ.mpuTask != null) break;
                        SpritePatternViewer.spvUpdateFrame();
                        break;
                    }
                    case "Size": {
                        spvSizeNumber = spvSizeComboBox.getSelectedIndex() + -1;
                        if (XEiJ.mpuTask != null) break;
                        SpritePatternViewer.spvUpdateFrame();
                        break;
                    }
                    case "Block": {
                        spvBlockNumber = spvBlockComboBox.getSelectedIndex() + -1;
                        if (XEiJ.mpuTask != null) break;
                        SpritePatternViewer.spvUpdateFrame();
                        break;
                    }
                    case "Flip": {
                        spvFlipNumber = spvFlipComboBox.getSelectedIndex() + -1;
                        if (XEiJ.mpuTask != null) break;
                        SpritePatternViewer.spvUpdateFrame();
                        break;
                    }
                    case "Hex": {
                        spvHex = ((JCheckBox)object).isSelected();
                        SpritePatternViewer.spvDrawHeader();
                        SpritePatternViewer.spvUpdateFrame();
                        break;
                    }
                    case "Stop": {
                        spvStoppedRequest = ((JCheckBox)object).isSelected();
                        if (XEiJ.mpuTask != null) break;
                        SpritePatternViewer.spvUpdateFrame();
                        break;
                    }
                    case "Scale": {
                        spvCanvas.setScaleShift(spvScaleComboBox.getSelectedIndex() + -1);
                        break;
                    }
                    case "Copy as hexadecimal": {
                        SpritePatternViewer.spvCopyPattern();
                        break;
                    }
                    default: {
                        System.out.println("unknown action command " + string);
                    }
                }
            }
        };
        spvTextField = new JTextField();
        spvTextField.setEditable(false);
        spvTextField.setHorizontalAlignment(0);
        JComponent[] jComponentArray = new JComponent[2];
        jComponentArray[0] = spvCanvas;
        Component[] componentArray = new Component[2];
        Component[] componentArray2 = new Component[12];
        componentArray2[0] = Box.createHorizontalGlue();
        componentArray2[1] = Multilingual.mlnText(ComponentFactory.createLabel("Bank "), "ja", "\u30d0\u30f3\u30af ");
        spvBankComboBox = ComponentFactory.createComboBox(spvBankNumber - 0, "Bank", actionListener, "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "0-3", "4-7", "8-11", "12-15", "0-15");
        componentArray2[2] = spvBankComboBox;
        componentArray2[3] = Multilingual.mlnText(ComponentFactory.createLabel("Size "), "ja", "\u30b5\u30a4\u30ba ");
        spvSizeComboBox = ComponentFactory.createComboBox(spvSizeNumber - -1, "Size", actionListener, 4, Multilingual.mlnJapanese ? "\u81ea\u52d5" : "Auto", "8x8", "16x16");
        componentArray2[4] = spvSizeComboBox;
        componentArray2[5] = Multilingual.mlnText(ComponentFactory.createLabel("Block "), "ja", "\u30d6\u30ed\u30c3\u30af ");
        spvBlockComboBox = ComponentFactory.createComboBox(spvBlockNumber - -1, "Block", actionListener, 4, Multilingual.mlnJapanese ? "\u81ea\u52d5" : "Auto", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15");
        componentArray2[6] = spvBlockComboBox;
        componentArray2[7] = Multilingual.mlnText(ComponentFactory.createLabel("Flip "), "ja", "\u53cd\u8ee2 ");
        spvFlipComboBox = ComponentFactory.createComboBox(spvFlipNumber - -1, "Flip", actionListener, 4, Multilingual.mlnJapanese ? "\u81ea\u52d5" : "Auto", Multilingual.mlnJapanese ? "\u306a\u3057" : "-", Multilingual.mlnJapanese ? "\u5de6\u53f3" : "H", Multilingual.mlnJapanese ? "\u4e0a\u4e0b" : "V", Multilingual.mlnJapanese ? "\u4e0a\u4e0b\u5de6\u53f3" : "H&V");
        componentArray2[8] = spvFlipComboBox;
        componentArray2[9] = Box.createHorizontalStrut(5);
        componentArray2[10] = ComponentFactory.createCheckBox(spvHex, "Hex", actionListener);
        componentArray2[11] = Box.createHorizontalGlue();
        componentArray[0] = ComponentFactory.createHorizontalBox(componentArray2);
        Component[] componentArray3 = new Component[5];
        componentArray3[0] = spvTextField;
        componentArray3[1] = Multilingual.mlnText(ComponentFactory.createLabel("Scale "), "ja", "\u500d\u7387 ");
        spvScaleComboBox = ComponentFactory.createComboBox(spvCanvas.getScaleShift() - -1, "Scale", actionListener, "1", "2", "4", "8", "16", "32");
        componentArray3[2] = spvScaleComboBox;
        componentArray3[3] = Box.createHorizontalStrut(5);
        componentArray3[4] = Multilingual.mlnText(ComponentFactory.createCheckBox(spvStoppedRequest, "Stop", actionListener), "ja", "\u505c\u6b62");
        componentArray[1] = ComponentFactory.createHorizontalBox(componentArray3);
        jComponentArray[1] = ComponentFactory.createVerticalBox(componentArray);
        spvFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("spv", "Sprite Pattern Viewer", null, ComponentFactory.createBorderPanel(0, 0, jComponentArray)), "ja", "\u30b9\u30d7\u30e9\u30a4\u30c8\u30d1\u30bf\u30fc\u30f3\u30d3\u30e5\u30a2");
        spvCanvas.addScaleShiftListener(new ScrollCanvas.ScaleShiftListener(){

            @Override
            public void scaleShiftChanged(int n) {
                spvScaleComboBox.setSelectedIndex(n - -1);
            }
        });
        ComponentFactory.addListener(spvFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFF7FF;
            }
        });
        spvPopupMenu = ComponentFactory.createPopupMenu(Multilingual.mlnText(ComponentFactory.createMenuItem("Copy as hexadecimal", 67, actionListener), "ja", "16\u9032\u6570\u3067\u30b3\u30d4\u30fc"));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                spvTextLocked = !spvTextLocked;
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                if (!spvTextLocked) {
                    int n;
                    MouseEvent2D mouseEvent2D = (MouseEvent2D)mouseEvent;
                    int n2 = (int)mouseEvent2D.getX2D();
                    String string = SpritePatternViewer.spvGetPixel(n2, n = (int)mouseEvent2D.getY2D());
                    spvTextField.setText(string == null ? "" : string);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                SpritePatternViewer.spvShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                SpritePatternViewer.spvShowPopup(mouseEvent);
            }
        };
        spvCanvas.addMouseListener(mouseAdapter);
        spvCanvas.addMouseMotionListener(mouseAdapter);
    }

    static void spvDrawHeader() {
        int n;
        Graphics2D graphics2D = spvBufferedImage.createGraphics();
        graphics2D.setColor(new Color(-13421773));
        graphics2D.fillRect(0, 0, spvWidth, spvHeight);
        graphics2D.setColor(new Color(-3355444));
        graphics2D.setFont(new Font(SPV_FONT_NAME, 1, 16));
        for (n = 0; n <= spvColsMask; ++n) {
            SpritePatternViewer.spvDrawString(graphics2D, SpritePatternViewer.spvColToX(n) + 18, SpritePatternViewer.spvRowToY(0) - 1, String.format(spvHex ? "%X" : "%d", n & spvColsMask), 5);
        }
        for (n = 0; n <= spvRowsMask; ++n) {
            SpritePatternViewer.spvDrawString(graphics2D, SpritePatternViewer.spvColToX(0) - 2, SpritePatternViewer.spvRowToY(n) + 18, String.format(spvHex ? "%X" : "%d", spvCellOffset + ((n & spvRowsMask) << spvColsBit)), 3);
        }
    }

    static void spvDrawString(Graphics2D graphics2D, int n, int n2, String string, int n3) {
        Font font = graphics2D.getFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Rectangle2D rectangle2D = textLayout.getBounds();
        int n4 = (int)Math.round(rectangle2D.getX());
        int n5 = (int)Math.round(rectangle2D.getY());
        int n6 = (int)Math.round(rectangle2D.getWidth());
        int n7 = (int)Math.round(rectangle2D.getHeight());
        switch (n3) {
            case 8: {
                graphics2D.drawString(string, n - n4, n2 - n5);
                break;
            }
            case 1: {
                graphics2D.drawString(string, n - (n4 + (n6 >> 1)), n2 - n5);
                break;
            }
            case 2: {
                graphics2D.drawString(string, n - (n4 + n6), n2 - n5);
                break;
            }
            case 7: {
                graphics2D.drawString(string, n - n4, n2 - (n5 + (n7 >> 1)));
                break;
            }
            case 0: {
                graphics2D.drawString(string, n - (n4 + (n6 >> 1)), n2 - (n5 + (n7 >> 1)));
                break;
            }
            case 3: {
                graphics2D.drawString(string, n - (n4 + n6), n2 - (n5 + (n7 >> 1)));
                break;
            }
            case 6: {
                graphics2D.drawString(string, n - n4, n2 - (n5 + n7));
                break;
            }
            case 5: {
                graphics2D.drawString(string, n - (n4 + (n6 >> 1)), n2 - (n5 + n7));
                break;
            }
            case 4: {
                graphics2D.drawString(string, n - (n4 + n6), n2 - (n5 + n7));
            }
        }
    }

    static void spvShowPopup(MouseEvent mouseEvent) {
        int n;
        MouseEvent2D mouseEvent2D;
        int n2;
        if (mouseEvent.isPopupTrigger() && SpritePatternViewer.spvGetPatternToCopy(n2 = (int)(mouseEvent2D = (MouseEvent2D)mouseEvent).getX2D(), n = (int)mouseEvent2D.getY2D())) {
            Point point = spvCanvas.getPopupPoint(mouseEvent2D);
            spvPopupMenu.show(spvCanvas, point.x, point.y);
        }
    }

    static boolean spvGetPatternToCopy(int n, int n2) {
        int n3 = SpritePatternViewer.spvXToXCol(n);
        int n4 = SpritePatternViewer.spvYToYRow(n2);
        if (n3 < 0 || n4 < 0) {
            spvOffsetToCopy = 0;
            spvLengthToCopy = 0;
            return false;
        }
        n = n3 >> 16;
        n2 = n4 >> 16;
        int n5 = spvCellOffset + (n3 = (int)((char)n3)) + ((n4 = (int)((char)n4)) << spvColsBit) << 2;
        int n6 = spvSizeArray[n5 >> 2];
        if (n6 < 0) {
            n6 = spvLastSizeArray[n5 >> 2];
        }
        if (n6 == 0) {
            int n7 = n / 18;
            int n8 = n2 / 18;
            n5 += n8 + (n7 << 1);
            spvLengthToCopy = 8;
        } else {
            spvLengthToCopy = 32;
        }
        spvOffsetToCopy = n5 << 3;
        return true;
    }

    static void spvCopyPattern() {
        if (spvLengthToCopy != 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < spvLengthToCopy; ++i) {
                stringBuilder.append(String.format("%08X\n", spvPat[spvOffsetToCopy + i]));
            }
            XEiJ.clpCopy(stringBuilder.toString());
        }
    }

    static String spvGetPixel(int n, int n2) {
        int n3;
        int n4 = SpritePatternViewer.spvXToXCol(n);
        int n5 = SpritePatternViewer.spvYToYRow(n2);
        if (n4 < 0 || n5 < 0) {
            return null;
        }
        n = n4 >> 16;
        n2 = n5 >> 16;
        int n6 = spvCellOffset + (n4 = (int)((char)n4)) + ((n5 = (int)((char)n5)) << spvColsBit) << 2;
        int n7 = spvSizeArray[n6 >> 2];
        if (n7 < 0) {
            n7 = spvLastSizeArray[n6 >> 2];
        }
        if (n7 == 0) {
            int n8;
            int n9 = n / 18;
            int n10 = n2 / 18;
            n6 += n10 + (n9 << 1);
            n -= 18 * n9;
            n2 -= 18 * n10;
            if (--n < 0 || 16 <= n || --n2 < 0 || 16 <= n2) {
                return null;
            }
            n >>= 1;
            n2 >>= 1;
            int n11 = spvBlockArray[n6];
            if (n11 < 0) {
                n11 = spvLastBlockArray[n6];
            }
            if ((n8 = spvFlipArray[n6]) < 0) {
                n8 = spvLastFlipArray[n6];
            }
            int n12 = n8 >> 1;
            int n13 = n8 & 1;
            if (n13 != 0) {
                n ^= 7;
            }
            if (n12 != 0) {
                n2 ^= 7;
            }
            int n14 = spvPat[(n6 << 3) + n2] >> (7 - n << 2) & 0xF;
            int n15 = n11 << 4 | n14;
            int n16 = spvPal16TS[n15];
            return String.format("8x8 n=%d x=%d y=%d p=0x%02X c=0x%04X(%d,%d,%d,%d)", n6, n, n2, n15, n16, n16 >> 11, n16 >> 6 & 0x1F, n16 >> 1 & 0x1F, n16 & 1);
        }
        if ((n -= 2) < 0 || 32 <= n || (n2 -= 2) < 0 || 32 <= n2) {
            return null;
        }
        n >>= 1;
        n2 >>= 1;
        int n17 = spvBlockArray[n6];
        if (n17 < 0) {
            n17 = spvLastBlockArray[n6];
        }
        if ((n3 = spvFlipArray[n6]) < 0) {
            n3 = spvLastFlipArray[n6];
        }
        int n18 = n3 >> 1;
        int n19 = n3 & 1;
        if ((n3 & 1) != 0) {
            n ^= 0xF;
        }
        if ((n3 & 2) != 0) {
            n2 ^= 0xF;
        }
        int n20 = spvPat[(n6 << 3) + n2 + ((n & 8) << 1)] >> (7 - (n & 7) << 2) & 0xF;
        int n21 = n17 << 4 | n20;
        int n22 = spvPal16TS[n21];
        return String.format("16x16 n=%d x=%d y=%d p=0x%02X c=0x%04X(%d,%d,%d,%d)", n6 >> 2, n, n2, n21, n22, n22 >> 11, n22 >> 6 & 0x1F, n22 >> 1 & 0x1F, n22 & 1);
    }

    static void spvUpdateFrame() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        if (spvFrame == null) {
            return;
        }
        if (spvStopped != spvStoppedRequest) {
            if (spvStoppedRequest) {
                SpritePatternViewer.spvSetStoppedOn();
            } else {
                SpritePatternViewer.spvSetStoppedOff();
            }
        }
        for (n8 = 0; n8 < 256; ++n8) {
            SpritePatternViewer.spvPal32TS[n8] = spvPalTbl[spvPal16TS[n8]];
        }
        Arrays.fill(spvSizeArray, spvSizeNumber);
        Arrays.fill(spvBlockArray, spvBlockNumber);
        Arrays.fill(spvFlipArray, spvFlipNumber);
        if (spvSizeNumber < 0 || spvBlockNumber < 0 || spvFlipNumber < 0) {
            for (n8 = 0; n8 < SpriteScreen.sprNumberOfSprites; ++n8) {
                if (256 <= n8 && n8 < 264 || spvPrw[n8] == 0) continue;
                n7 = spvNum[n8] << 2;
                if (spvSizeArray[n7 >> 2] < 0) {
                    SpritePatternViewer.spvLastSizeArray[n7 >> 2] = 1;
                    SpritePatternViewer.spvSizeArray[n7 >> 2] = 1;
                }
                n6 = spvCol[n8] >> 4;
                n5 = (spvV[n8] ? 2 : 0) | (spvH[n8] ? 1 : 0);
                for (n4 = 0; n4 < 4; ++n4) {
                    if (spvBlockArray[n7 + n4] < 0) {
                        int n9 = n6;
                        SpritePatternViewer.spvLastBlockArray[n7 + n4] = n9;
                        SpritePatternViewer.spvBlockArray[n7 + n4] = n9;
                    }
                    if (spvFlipArray[n7 + n4] >= 0) continue;
                    int n10 = n5;
                    SpritePatternViewer.spvLastFlipArray[n7 + n4] = n10;
                    SpritePatternViewer.spvFlipArray[n7 + n4] = n10;
                }
            }
            n8 = 0;
            if ((SpriteScreen.sprReg4BgCtrlPort & 1) != 0) {
                n8 |= 1 << (SpriteScreen.sprReg4BgCtrlPort >> 1 & 3);
            }
            if (((SpriteScreen.sprReg8ResoPort & 3) == 0 || SpriteScreen.spr512bg1) && (SpriteScreen.sprReg4BgCtrlPort & 8) != 0) {
                n8 |= 1 << (SpriteScreen.sprReg4BgCtrlPort >> 4 & 3);
            }
            if ((SpriteScreen.sprReg8ResoPort & 3) == 0) {
                for (n7 = 0; n7 < 4; ++n7) {
                    if ((n8 & 1 << n7) == 0) continue;
                    n6 = 4096 * n7;
                    for (n5 = 0; n5 < 4096; ++n5) {
                        n4 = spvTNum[n6 + n5] >> 3;
                        if (spvSizeArray[n4 >> 2] < 0) {
                            SpritePatternViewer.spvLastSizeArray[n4 >> 2] = 0;
                            SpritePatternViewer.spvSizeArray[n4 >> 2] = 0;
                        }
                        n3 = spvTCol[n6 + n5] >> 4;
                        n2 = (spvTV[n6 + n5] ? 2 : 0) | (spvTH[n6 + n5] ? 1 : 0);
                        if (spvBlockArray[n4] < 0) {
                            SpritePatternViewer.spvBlockArray[n4] = SpritePatternViewer.spvLastBlockArray[n4] = n3;
                        }
                        if (spvFlipArray[n4] >= 0) continue;
                        SpritePatternViewer.spvFlipArray[n4] = SpritePatternViewer.spvLastFlipArray[n4] = n2;
                    }
                }
            } else {
                for (n7 = 0; n7 < 4; ++n7) {
                    if ((n8 & 1 << n7) == 0) continue;
                    n6 = 4096 * n7;
                    for (n5 = 0; n5 < 4096; ++n5) {
                        n4 = spvTNum[n6 + n5] >> 1;
                        if (spvSizeArray[n4 >> 2] < 0) {
                            SpritePatternViewer.spvLastSizeArray[n4 >> 2] = 1;
                            SpritePatternViewer.spvSizeArray[n4 >> 2] = 1;
                        }
                        n3 = spvTCol[n6 + n5] >> 4;
                        n2 = (spvTV[n6 + n5] ? 2 : 0) | (spvTH[n6 + n5] ? 1 : 0);
                        for (n = 0; n < 4; ++n) {
                            if (spvBlockArray[n4 + n] < 0) {
                                int n11 = n3;
                                SpritePatternViewer.spvLastBlockArray[n4 + n] = n11;
                                SpritePatternViewer.spvBlockArray[n4 + n] = n11;
                            }
                            if (spvFlipArray[n4 + n] >= 0) continue;
                            int n12 = n2;
                            SpritePatternViewer.spvLastFlipArray[n4 + n] = n12;
                            SpritePatternViewer.spvFlipArray[n4 + n] = n12;
                        }
                    }
                }
            }
            for (n7 = 0; n7 < 4096; ++n7) {
                if (spvSizeArray[n7] >= 0) continue;
                SpritePatternViewer.spvSizeArray[n7] = spvLastSizeArray[n7];
            }
            for (n7 = 0; n7 < 16384; ++n7) {
                if (spvBlockArray[n7] < 0) {
                    SpritePatternViewer.spvBlockArray[n7] = spvLastBlockArray[n7];
                }
                if (spvFlipArray[n7] >= 0) continue;
                SpritePatternViewer.spvFlipArray[n7] = spvLastFlipArray[n7];
            }
        }
        n8 = 32 * spvCellOffset;
        for (n7 = 0; n7 <= spvRowsMask; ++n7) {
            n6 = SpritePatternViewer.spvRowToY(n7);
            for (n5 = 0; n5 <= spvColsMask; ++n5) {
                int n13;
                int n14;
                int n15;
                int n16;
                int n17;
                int n18;
                int n19;
                int n20;
                n4 = SpritePatternViewer.spvColToX(n5);
                n2 = n3 = n4 + spvImageWidth * n6;
                for (n = 0; n < 36; ++n) {
                    for (n20 = 0; n20 < 36; ++n20) {
                        SpritePatternViewer.spvBitmap[n2 + n20] = -13421773;
                    }
                    n2 += spvImageWidth;
                }
                n = spvCellOffset + n5 + (n7 << spvColsBit) << 2;
                if (spvSizeArray[n >> 2] == 0) {
                    for (n20 = 0; n20 < 2; ++n20) {
                        n19 = n4 + 18 * n20;
                        for (n18 = 0; n18 < 2; ++n18) {
                            int n21;
                            n17 = n6 + 18 * n18;
                            n16 = n19 + spvImageWidth * n17;
                            n15 = spvBlockArray[n];
                            int n22 = spvFlipArray[n];
                            int n23 = (n22 & 1) != 0 ? 7 : 0;
                            n14 = (n22 & 2) != 0 ? 15 : 0;
                            n2 = n16 + (n23 == 0 ? 0 + spvImageWidth * 1 : 17 + spvImageWidth * 1);
                            for (n13 = 0; n13 <= 15; ++n13) {
                                n21 = n13 ^ n14;
                                if (n21 == n15) {
                                    SpritePatternViewer.spvBitmap[n2] = -1;
                                } else if (n21 < 8) {
                                    SpritePatternViewer.spvBitmap[n2] = -6710887;
                                }
                                n2 += spvImageWidth * 1;
                            }
                            n15 <<= 4;
                            n14 >>= 1;
                            n2 = n16 + 1 + spvImageWidth * 1;
                            for (n13 = 0; n13 <= 7; ++n13) {
                                n21 = n13 ^ n14;
                                int n24 = spvPat[n8 + n21];
                                for (int i = 7; 0 <= i; --i) {
                                    int n25 = i ^ n23;
                                    int n26 = spvPal32TS[n15 + (n24 >> (n25 << 2) & 0xF)];
                                    SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth + 1] = n26;
                                    SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth] = n26;
                                    SpritePatternViewer.spvBitmap[n2 + 1] = n26;
                                    SpritePatternViewer.spvBitmap[n2] = n26;
                                    n2 += 2;
                                }
                                n2 += spvImageWidth * 2 - 16;
                            }
                            n8 += 8;
                            ++n;
                        }
                    }
                    continue;
                }
                n20 = spvBlockArray[n];
                n19 = spvFlipArray[n];
                n18 = (n19 & 1) != 0 ? 15 : 0;
                n17 = (n19 & 2) != 0 ? 15 : 0;
                n2 = n3 + (n18 == 0 ? 0 + spvImageWidth * 2 : 34 + spvImageWidth * 2);
                for (n16 = 0; n16 <= 15; ++n16) {
                    n15 = n16 ^ n17;
                    if (n15 == n20) {
                        SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth + 1] = -1;
                        SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth] = -1;
                        SpritePatternViewer.spvBitmap[n2 + 1] = -1;
                        SpritePatternViewer.spvBitmap[n2] = -1;
                    } else if (n15 < 8) {
                        SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth + 1] = -6710887;
                        SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth] = -6710887;
                        SpritePatternViewer.spvBitmap[n2 + 1] = -6710887;
                        SpritePatternViewer.spvBitmap[n2] = -6710887;
                    }
                    n2 += spvImageWidth * 2;
                }
                n20 <<= 4;
                n2 = n3 + 2 + spvImageWidth * 2;
                for (n16 = 0; n16 <= 15; ++n16) {
                    n15 = n16 ^ n17;
                    long l = (long)spvPat[n8 + n15] << 32 | (long)spvPat[n8 + n15 + 16] & 0xFFFFFFFFL;
                    for (n14 = 15; 0 <= n14; --n14) {
                        n13 = n14 ^ n18;
                        int n27 = spvPal32TS[n20 + ((int)(l >> (n13 << 2)) & 0xF)];
                        SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth + 1] = n27;
                        SpritePatternViewer.spvBitmap[n2 + SpritePatternViewer.spvImageWidth] = n27;
                        SpritePatternViewer.spvBitmap[n2 + 1] = n27;
                        SpritePatternViewer.spvBitmap[n2] = n27;
                        n2 += 2;
                    }
                    n2 += spvImageWidth * 2 - 32;
                }
                n8 += 32;
            }
        }
        spvCanvas.repaint();
    }

    static void spvSetStoppedOn() {
        spvStopped = true;
        spvStoppedRequest = true;
        System.arraycopy(SpriteScreen.sprNumPort, 0, spvCopiedNum, 0, 1024);
        System.arraycopy(SpriteScreen.sprColPort, 0, spvCopiedCol, 0, 1024);
        System.arraycopy(SpriteScreen.sprPrw, 0, spvCopiedPrw, 0, 1024);
        System.arraycopy(SpriteScreen.sprH, 0, spvCopiedH, 0, 1024);
        System.arraycopy(SpriteScreen.sprV, 0, spvCopiedV, 0, 1024);
        System.arraycopy(SpriteScreen.sprPatPort, 0, spvCopiedPat, 0, 131072);
        System.arraycopy(SpriteScreen.sprTNum, 0, spvCopiedTNum, 0, 16384);
        System.arraycopy(SpriteScreen.sprTColPort, 0, spvCopiedTCol, 0, 16384);
        System.arraycopy(SpriteScreen.sprTH, 0, spvCopiedTH, 0, 16384);
        System.arraycopy(SpriteScreen.sprTV, 0, spvCopiedTV, 0, 16384);
        System.arraycopy(VideoController.vcnPalBase[45], 0, spvCopiedPalTbl, 0, 65536);
        System.arraycopy(VideoController.vcnPal16TSPort, 0, spvCopiedPal16TS, 0, 256);
        spvNum = spvCopiedNum;
        spvCol = spvCopiedCol;
        spvPrw = spvCopiedPrw;
        spvH = spvCopiedH;
        spvV = spvCopiedV;
        spvPat = spvCopiedPat;
        spvTNum = spvCopiedTNum;
        spvTCol = spvCopiedTCol;
        spvTH = spvCopiedTH;
        spvTV = spvCopiedTV;
        spvPalTbl = spvCopiedPalTbl;
        spvPal16TS = spvCopiedPal16TS;
    }

    static void spvSetStoppedOff() {
        spvStopped = false;
        spvStoppedRequest = false;
        spvNum = SpriteScreen.sprNumPort;
        spvCol = SpriteScreen.sprColPort;
        spvPrw = SpriteScreen.sprPrw;
        spvH = SpriteScreen.sprH;
        spvV = SpriteScreen.sprV;
        spvPat = SpriteScreen.sprPatPort;
        spvTNum = SpriteScreen.sprTNum;
        spvTCol = SpriteScreen.sprTColPort;
        spvTH = SpriteScreen.sprTH;
        spvTV = SpriteScreen.sprTV;
        spvPalTbl = VideoController.vcnPalBase[45];
        spvPal16TS = VideoController.vcnPal16TSPort;
    }

    static {
        spvLastSizeArray = new int[4096];
        spvSizeArray = new int[4096];
        spvLastBlockArray = new int[16384];
        spvBlockArray = new int[16384];
        spvLastFlipArray = new int[16384];
        spvFlipArray = new int[16384];
        spvCopiedNum = new short[1024];
        spvCopiedCol = new short[1024];
        spvCopiedPrw = new byte[1024];
        spvCopiedH = new boolean[1024];
        spvCopiedV = new boolean[1024];
        spvCopiedPat = new int[131072];
        spvCopiedTNum = new short[16384];
        spvCopiedTCol = new short[16384];
        spvCopiedTH = new boolean[16384];
        spvCopiedTV = new boolean[16384];
        spvCopiedPalTbl = new int[65536];
        spvCopiedPal16TS = new int[256];
        spvPal32TS = new int[256];
    }
}

