/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import xeij.ComponentFactory;
import xeij.FontPage;
import xeij.IOInterrupt;
import xeij.JFileChooser2;
import xeij.LnF;
import xeij.Multilingual;
import xeij.NumberSpinner;
import xeij.RestorableFrame;
import xeij.ScrollCanvas;
import xeij.Settings;
import xeij.TickerQueue;
import xeij.XEiJ;

public class PrinterPort {
    public static final int PRN_DATA = 15253505;
    public static final int PRN_STROBE = 15253507;
    public static int prnData;
    public static int prnStrobe;
    public static final boolean PRN_USE_ADAPTER = true;
    public static final int PRN_ADAPTER_CAPACITY = 1024;
    public static final long PRN_ADAPTER_DELAY = 10000000000L;
    public static byte[] prnAdapterBuffer;
    public static int prnAdapterPointer;
    public static TickerQueue.Ticker prnAdapterTicker;
    public static Timer prnAdapterTimer;
    public static IndexColorModel prnImageColorModel;
    public static IndexColorModel prnDarkImageColorModel;
    public static final int PRN_MAX_WIDTH_DOT = 17280;
    public static final int PRN_MAX_HEIGHT_DOT = 23760;
    public static final int PRN_MAX_WIDTH_MM;
    public static final int PRN_MAX_HEIGHT_MM;
    public static final int PRN_A_SERIES = 0;
    public static final int PRN_B_SERIES = 1;
    public static final int PRN_POSTCARD = 2;
    public static final int PRN_PORTRAIT = 0;
    public static final int PRN_LANDSCAPE = 1;
    public static Paper[] prnPaperArray;
    public static Paper prnNextPaper;
    public static Paper prnCurrentPaper;
    public static int prnNextRotation;
    public static int prnRotation;
    public static int prnRotatedWidthDot;
    public static int prnRotatedHeightDot;
    public static int prnM11;
    public static int prnM12;
    public static int prnM13;
    public static int prnM21;
    public static int prnM22;
    public static int prnM23;
    public static int prnIncrementX;
    public static int prnIncrementY;
    public static boolean prnNextDarkMode;
    public static boolean prnDarkMode;
    public static boolean prnOnlineOn;
    public static int prnSingleColor;
    public static int prnScaleShift;
    public static BufferedImage prnImage;
    public static byte[] prnBitmap;
    public static boolean prnPrinted;
    public static int prnMarginLeftX;
    public static int prnMarginRightX;
    public static int prnMarginBottomHeight;
    public static int prnDefaultLineHeight;
    public static int prnLineHeight;
    public static final int PRN_PICA = 0;
    public static final int PRN_ELITE = 1;
    public static final int PRN_SMALL = 2;
    public static int prnCharacterType;
    public static boolean prnHiraganaMode;
    public static final int PRN_NO_SCRIPT = 0;
    public static final int PRN_SUPER_SCRIPT = 1;
    public static final int PRN_SUB_SCRIPT = 2;
    public static int prnScriptMode;
    public static boolean prnStrongMode;
    public static boolean prnUnderlineMode;
    public static final int PRN_NORMAL_STYLE = 0;
    public static final int PRN_OPEN_STYLE = 1;
    public static final int PRN_SHADOW_STYLE = 2;
    public static final int PRN_OPEN_SHADOW_STYLE = 3;
    public static int prnCharacterStyle;
    public static boolean prnKanjiMode;
    public static byte[] prnGaijiData;
    public static boolean prnVerticalWritingMode;
    public static int prnFullWidthLeftSpace;
    public static int prnFullWidthRightSpace;
    public static int prnHalfWidthLeftSpace;
    public static int prnHalfWidthRightSpace;
    public static boolean prnHorizontalDoubleSizeMode;
    public static boolean prnVerticalDoubleSizeMode;
    public static boolean prnKanjiHorizontalDoubleSizeMode;
    public static final int PRN_HORIZONTAL_ANCHOR_LIMIT = 16;
    public static final int[] prnHorizontalTabAnchor;
    public static final int PRN_VERTICAL_ANCHOR_LIMIT = 128;
    public static final int[] prnVerticalTabAnchor;
    public static boolean prnColorMode;
    public static int prnCurrentColor;
    public static int prnHalfWidthFont;
    public static int prnFullWidthFont;
    public static int prnNextDeadTopMm;
    public static int prnNextDeadLeftMm;
    public static int prnNextDeadRightMm;
    public static int prnNextDeadBottomMm;
    public static int prnDeadTopMm;
    public static int prnDeadLeftMm;
    public static int prnDeadRightMm;
    public static int prnDeadBottomMm;
    public static int prnAliveTopY;
    public static int prnAliveLeftX;
    public static int prnAliveRightX;
    public static int prnAliveBottomY;
    public static int prnPageStart;
    public static int prnPageLength;
    public static int prnContentTopY;
    public static int prnContentBottomY;
    public static int prnHeadX;
    public static int prnHeadY;
    public static int prnHeadLine;
    public static final byte[] prnCommandBuffer;
    public static int prnCommandLength;
    public static int prnCommandPointer;
    public static ScrollCanvas prnCanvas;
    public static JFrame prnFrame;
    public static JCheckBoxMenuItem prnOnlineMenuItem;
    public static JCheckBoxMenuItem prnAutosaveMenuItem;
    public static int prnSpinnerLocked;
    public static SpinnerNumberModel prnDeadTopModel;
    public static SpinnerNumberModel prnDeadLeftModel;
    public static SpinnerNumberModel prnDeadRightModel;
    public static SpinnerNumberModel prnDeadBottomModel;
    public static NumberSpinner prnDeadTopSpinner;
    public static NumberSpinner prnDeadLeftSpinner;
    public static NumberSpinner prnDeadRightSpinner;
    public static NumberSpinner prnDeadBottomSpinner;
    public static JRadioButtonMenuItem[] prnScaleMenuItem;
    public static boolean prnAutosaveOn;
    public static String prnSavePath;
    public static String prnSaveName;
    public static JDialog prnSaveDialog;
    public static JFileChooser2 prnSaveFileChooser;
    public static String[] prnWriterSuffixes;
    public static FileFilter prnSaveFileFilter;
    public static JCheckBox prnAutosaveCheckBox;
    public static final int PRN_DIPSW_ZERO_STYLE = 1;
    public static final int PRN_DIPSW_PRINTING_SPEED = 2;
    public static final int PRN_DIPSW_POSTCARD_MODE = 4;
    public static final int PRN_DIPSW_PAGE_LENGTH = 8;
    public static final int PRN_DIPSW_FEEDING_POSITION = 32;
    public static final int PRN_DIPSW_FONT_STYLE = 128;
    public static final int PRN_DIPSW_MASK = 175;
    public static int prnDIPSW;
    public static final String FNT_EN_Zen48x48G = "Full Kanji 48x48 Gothic";
    public static final String FNT_EN_Pic36x46S = "CZ-8PC4 Pica 36x46 Sans-Serif";
    public static final String FNT_EN_Eli30x46S = "CZ-8PC4 Elite 30x46 Sans-Serif";
    public static final String FNT_EN_Sma18x46S = "CZ-8PC4 Small 18x46 Sans-Serif";
    public static final String FNT_EN_Scr28x32S = "CZ-8PC4 Script 28x32 Sans-Serif";
    public static final String FNT_EN_Pan24x48S = "CZ-8PC4 Half 24x48 Sans-Serif";
    public static final String FNT_EN_Zen48x48M = "Full Kanji 48x48 Mincho";
    public static final String FNT_EN_Pic36x46R = "CZ-8PC4 Pica 36x46 Roman";
    public static final String FNT_EN_Eli30x46R = "CZ-8PC4 Elite 30x46 Roman";
    public static final String FNT_EN_Sma18x46R = "CZ-8PC4 Small 18x46 Roman";
    public static final String FNT_EN_Scr28x32R = "CZ-8PC4 Script 28x32 Roman";
    public static final String FNT_EN_Pan24x48R = "CZ-8PC4 Half 24x48 Roman";
    public static final String FNT_JA_Zen48x48G = "\u5168\u89d2 \u6f22\u5b57 48x48 \u30b4\u30b7\u30c3\u30af\u4f53";
    public static final String FNT_JA_Pic36x46S = "CZ-8PC4 \u30d1\u30a4\u30ab 36x46 \u30b5\u30f3\u30bb\u30ea\u30d5\u4f53";
    public static final String FNT_JA_Eli30x46S = "CZ-8PC4 \u30a8\u30ea\u30fc\u30c8 30x46 \u30b5\u30f3\u30bb\u30ea\u30d5\u4f53";
    public static final String FNT_JA_Sma18x46S = "CZ-8PC4 \u7e2e\u5c0f 18x46 \u30b5\u30f3\u30bb\u30ea\u30d5\u4f53";
    public static final String FNT_JA_Scr28x32S = "CZ-8PC4 \u30b9\u30af\u30ea\u30d7\u30c8 28x32 \u30b5\u30f3\u30bb\u30ea\u30d5\u4f53";
    public static final String FNT_JA_Pan24x48S = "CZ-8PC4 \u534a\u89d2 24x48 \u30b5\u30f3\u30bb\u30ea\u30d5\u4f53";
    public static final String FNT_JA_Zen48x48M = "\u5168\u89d2 \u6f22\u5b57 48x48 \u660e\u671d\u4f53";
    public static final String FNT_JA_Pic36x46R = "CZ-8PC4 \u30d1\u30a4\u30ab 36x46 \u30ed\u30fc\u30de\u30f3\u4f53";
    public static final String FNT_JA_Eli30x46R = "CZ-8PC4 \u30a8\u30ea\u30fc\u30c8 30x46 \u30ed\u30fc\u30de\u30f3\u4f53";
    public static final String FNT_JA_Sma18x46R = "CZ-8PC4 \u7e2e\u5c0f 18x46 \u30ed\u30fc\u30de\u30f3\u4f53";
    public static final String FNT_JA_Scr28x32R = "CZ-8PC4 \u30b9\u30af\u30ea\u30d7\u30c8 28x32 \u30ed\u30fc\u30de\u30f3\u4f53";
    public static final String FNT_JA_Pan24x48R = "CZ-8PC4 \u534a\u89d2 24x48 \u30ed\u30fc\u30de\u30f3\u4f53";
    public static FontPage.Zen fntPageZen48x48G;
    public static FontPage.Prn fntPagePic36x46S;
    public static FontPage.Prn fntPageEli30x46S;
    public static FontPage.Prn fntPageSma18x46S;
    public static FontPage.Prn fntPageScr28x32S;
    public static FontPage.Prn fntPagePan24x48S;
    public static FontPage.Zen fntPageZen48x48M;
    public static FontPage.Prn fntPagePic36x46R;
    public static FontPage.Prn fntPageEli30x46R;
    public static FontPage.Prn fntPageSma18x46R;
    public static FontPage.Prn fntPageScr28x32R;
    public static FontPage.Prn fntPagePan24x48R;
    public static final String[] FNT_GOTHIC_FAMILIES;
    public static final String[] FNT_MINCHO_FAMILIES;
    public static String[] fntAvailableFamilies;
    public static String fntGothicFamily;
    public static String fntMinchoFamily;
    private static final byte[] PRN_DOUBLE_4BIT;

    public static void prnAdapterInit() {
        prnAdapterBuffer = new byte[1024];
        prnAdapterPointer = 0;
        prnAdapterTicker = new PrinterAdapterTicker();
        prnAdapterTimer = new Timer();
    }

    public static void prnAdapterOutput(int n) {
        PrinterPort.prnAdapterBuffer[PrinterPort.prnAdapterPointer++] = (byte)n;
        if (prnAdapterPointer < 1024) {
            TickerQueue.tkqAdd(prnAdapterTicker, XEiJ.mpuClockTime + 10000000000L);
        } else {
            TickerQueue.tkqRemove(prnAdapterTicker);
            PrinterPort.prnAdapterTaskLauncher();
        }
    }

    public static void prnAdapterTaskLauncher() {
        byte[] byArray = Arrays.copyOf(prnAdapterBuffer, prnAdapterPointer);
        prnAdapterPointer = 0;
        prnAdapterTimer.schedule((TimerTask)new PrinterAdapterTask(byArray), 100L);
    }

    public static void prnInit() {
        fntPageZen48x48G = new FontPage.Zen(48, 48, FNT_EN_Zen48x48G, FNT_JA_Zen48x48G, "./zen48x48g.f48", "./zen48x48g.png");
        fntPagePic36x46S = new FontPage.Prn(36, 46, FNT_EN_Pic36x46S, FNT_JA_Pic36x46S, "./pic36x46s.dat", "./pic36x46s.png");
        fntPageEli30x46S = new FontPage.Prn(30, 46, FNT_EN_Eli30x46S, FNT_JA_Eli30x46S, "./eli30x46s.dat", "./eli30x46s.png");
        fntPageSma18x46S = new FontPage.Prn(18, 46, FNT_EN_Sma18x46S, FNT_JA_Sma18x46S, "./sma18x46s.dat", "./sma18x46s.png");
        fntPageScr28x32S = new FontPage.Prn(28, 32, FNT_EN_Scr28x32S, FNT_JA_Scr28x32S, "./scr28x32s.dat", "./scr28x32s.png");
        fntPagePan24x48S = new FontPage.Prn(24, 48, FNT_EN_Pan24x48S, FNT_JA_Pan24x48S, "./pan24x48s.dat", "./pan24x48s.png");
        fntPageZen48x48M = new FontPage.Zen(48, 48, FNT_EN_Zen48x48M, FNT_JA_Zen48x48M, "./zen48x48m.f48", "./zen48x48m.png");
        fntPagePic36x46R = new FontPage.Prn(36, 46, FNT_EN_Pic36x46R, FNT_JA_Pic36x46R, "./pic36x46r.dat", "./pic36x46r.png");
        fntPageEli30x46R = new FontPage.Prn(30, 46, FNT_EN_Eli30x46R, FNT_JA_Eli30x46R, "./eli30x46r.dat", "./eli30x46r.png");
        fntPageSma18x46R = new FontPage.Prn(18, 46, FNT_EN_Sma18x46R, FNT_JA_Sma18x46R, "./sma18x46r.dat", "./sma18x46r.png");
        fntPageScr28x32R = new FontPage.Prn(28, 32, FNT_EN_Scr28x32R, FNT_JA_Scr28x32R, "./scr28x32r.dat", "./scr28x32r.png");
        fntPagePan24x48R = new FontPage.Prn(24, 48, FNT_EN_Pan24x48R, FNT_JA_Pan24x48R, "./pan24x48r.dat", "./pan24x48r.png");
        prnImageColorModel = new IndexColorModel(8, 8, new byte[]{0, 0, 0, 0, -1, -1, -1, -1}, new byte[]{0, 0, -1, -1, 0, 0, -1, -1}, new byte[]{0, -1, 0, -1, 0, -1, 0, -1});
        prnDarkImageColorModel = new IndexColorModel(8, 8, new byte[]{-1, 0, 0, 0, -1, -1, -1, 0}, new byte[]{-1, 0, -1, -1, 0, 0, -1, 0}, new byte[]{-1, -1, 0, -1, 0, -1, 0, 0});
        prnPaperArray = new Paper[]{new Paper(0, 3, 0), new Paper(0, 4, 0), new Paper(0, 5, 0), new Paper(0, 6, 0), new Paper(1, 3, 0), new Paper(1, 4, 0), new Paper(1, 5, 0), new Paper(1, 6, 0), new Paper(2, 0, 0), new Paper(0, 3, 1), new Paper(0, 4, 1), new Paper(0, 5, 1), new Paper(0, 6, 1), new Paper(1, 3, 1), new Paper(1, 4, 1), new Paper(1, 5, 1), new Paper(1, 6, 1), new Paper(2, 0, 1)};
        prnAutosaveOn = Settings.sgsGetOnOff("prnauto");
        prnSavePath = Settings.sgsGetString("prnpath");
        prnDIPSW = Settings.sgsGetInt("prndipsw") & 0xAF;
        String string = Settings.sgsGetString("prnsize");
        String string2 = Settings.sgsGetString("prnorientation");
        prnNextPaper = prnPaperArray[1];
        for (Paper paper : prnPaperArray) {
            if (!string.equalsIgnoreCase(paper.sizeEn) || !string2.equalsIgnoreCase(paper.orientationEn)) continue;
            prnNextPaper = paper;
            break;
        }
        prnCurrentPaper = null;
        prnNextDeadTopMm = Math.max(0, Math.min(Settings.sgsGetInt("prntopmargin"), PrinterPort.prnNextPaper.paperHeightMm - 1));
        prnNextDeadLeftMm = Math.max(0, Math.min(Settings.sgsGetInt("prnleftmargin"), PrinterPort.prnNextPaper.paperWidthMm - 1));
        prnNextDeadRightMm = Math.max(0, Math.min(Settings.sgsGetInt("prnrightmargin"), PrinterPort.prnNextPaper.paperWidthMm - 1 - prnNextDeadLeftMm));
        prnNextDeadBottomMm = Math.max(0, Math.min(Settings.sgsGetInt("prnbottommargin"), PrinterPort.prnNextPaper.paperHeightMm - 1 - prnNextDeadTopMm));
        prnNextRotation = Math.max(0, Math.min(Settings.sgsGetInt("prnrotation"), 3));
        prnRotation = 0;
        prnRotatedWidthDot = 0;
        prnRotatedHeightDot = 0;
        prnM11 = 0;
        prnM12 = 0;
        prnM13 = 0;
        prnM21 = 0;
        prnM22 = 0;
        prnM23 = 0;
        prnIncrementX = 0;
        prnIncrementY = 0;
        prnNextDarkMode = Settings.sgsGetOnOff("prndarkmode");
        prnDarkMode = false;
        prnOnlineOn = Settings.sgsGetOnOff("prnonline");
        prnSingleColor = Math.max(0, Math.min(Settings.sgsGetInt("prnsinglecolor"), 7));
        prnScaleShift = Math.max(-4, Math.min(Settings.sgsGetInt("prnscalefactor"), 4));
        PrinterPort.prnReset();
        PrinterPort.prnAdapterInit();
        prnImage = null;
        prnBitmap = null;
        prnPrinted = false;
        PrinterPort.prnResetSettings();
        prnSaveName = "1.png";
    }

    public static void prnTini() {
        Settings.sgsPutOnOff("prnauto", prnAutosaveOn);
        Settings.sgsPutString("prnpath", prnSavePath);
        Settings.sgsPutInt("prndipsw", prnDIPSW);
        Settings.sgsPutString("prnsize", PrinterPort.prnNextPaper.sizeEn);
        Settings.sgsPutString("prnorientation", PrinterPort.prnNextPaper.orientationEn);
        Settings.sgsPutInt("prntopmargin", prnNextDeadTopMm);
        Settings.sgsPutInt("prnleftmargin", prnNextDeadLeftMm);
        Settings.sgsPutInt("prnrightmargin", prnNextDeadRightMm);
        Settings.sgsPutInt("prnbottommargin", prnNextDeadBottomMm);
        Settings.sgsPutInt("prnrotation", prnNextRotation);
        Settings.sgsPutOnOff("prndarkmode", prnNextDarkMode);
        Settings.sgsPutOnOff("prnonline", prnOnlineOn);
        Settings.sgsPutInt("prnsinglecolor", prnSingleColor);
        Settings.sgsPutInt("prnscalefactor", prnScaleShift);
        prnAdapterTimer.cancel();
    }

    public static String[] fntGetAvailableFamilies() {
        if (fntAvailableFamilies == null) {
            fntAvailableFamilies = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            Arrays.sort(fntAvailableFamilies, null);
        }
        return fntAvailableFamilies;
    }

    public static String fntGetGothicFamily() {
        if (fntGothicFamily == null) {
            fntGothicFamily = "Monospaced";
            String[] stringArray = PrinterPort.fntGetAvailableFamilies();
            for (String string : FNT_GOTHIC_FAMILIES) {
                if (0 > Arrays.binarySearch(stringArray, string, null)) continue;
                fntGothicFamily = string;
                break;
            }
            System.out.println((Multilingual.mlnJapanese ? "\u30b4\u30b7\u30c3\u30af\u4f53\u306e\u30d5\u30a9\u30f3\u30c8: " : "Gothic font: ") + fntGothicFamily);
        }
        return fntGothicFamily;
    }

    public static String fntGetMinchoFamily() {
        if (fntMinchoFamily == null) {
            fntMinchoFamily = "Monospaced";
            String[] stringArray = PrinterPort.fntGetAvailableFamilies();
            for (String string : FNT_MINCHO_FAMILIES) {
                if (0 > Arrays.binarySearch(stringArray, string, null)) continue;
                fntMinchoFamily = string;
                break;
            }
            System.out.println((Multilingual.mlnJapanese ? "\u660e\u671d\u4f53\u306e\u30d5\u30a9\u30f3\u30c8: " : "Mincho font: ") + fntMinchoFamily);
        }
        return fntMinchoFamily;
    }

    public static byte[] prnGetGaijiData() {
        if (prnGaijiData == null) {
            prnGaijiData = new byte[28800];
        }
        return prnGaijiData;
    }

    public static void prnStart() {
        if (RestorableFrame.rfmGetOpened("prn")) {
            PrinterPort.prnOpen();
        }
    }

    public static void prnOpen() {
        if (prnFrame == null) {
            PrinterPort.prnMakeFrame();
        }
        XEiJ.pnlExitFullScreen(false);
        prnFrame.setVisible(true);
    }

    public static void prnMakeFrame() {
        Object object;
        prnCanvas = new ScrollCanvas(prnImage);
        prnCanvas.setMargin(10, 10);
        prnCanvas.setMatColor(new Color(LnF.lnfRGB[4]));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                Object object = actionEvent.getSource();
                block34 : switch (string = actionEvent.getActionCommand()) {
                    case "Online": {
                        PrinterPort.prnSetOnlineOn(((JCheckBoxMenuItem)object).isSelected());
                        break;
                    }
                    case "Eject": {
                        prnAdapterTimer.schedule((TimerTask)new PrinterAdapterTask(new byte[]{26, 12}), 0L);
                        break;
                    }
                    case "Destroy": {
                        prnAdapterTimer.schedule((TimerTask)new PrinterAdapterTask(new byte[]{26, 26, 26, 12}), 0L);
                        break;
                    }
                    case "Reset": {
                        prnAdapterTimer.schedule((TimerTask)new PrinterAdapterTask(new byte[]{26, 26, 27, 99, 49}), 0L);
                        break;
                    }
                    case "Autosave": {
                        PrinterPort.prnSetAutosaveOn(((JCheckBoxMenuItem)object).isSelected());
                        break;
                    }
                    case "Close": {
                        prnFrame.setVisible(false);
                        break;
                    }
                    case "No margins": {
                        prnNextDeadTopMm = 0;
                        prnNextDeadLeftMm = 0;
                        prnNextDeadRightMm = 0;
                        prnNextDeadBottomMm = 0;
                        ++prnSpinnerLocked;
                        prnDeadTopModel.setValue(prnNextDeadTopMm);
                        prnDeadLeftModel.setValue(prnNextDeadLeftMm);
                        prnDeadRightModel.setValue(prnNextDeadRightMm);
                        prnDeadBottomModel.setValue(prnNextDeadBottomMm);
                        --prnSpinnerLocked;
                        break;
                    }
                    case "Reset margins": {
                        prnNextDeadTopMm = PrinterPort.prnNextPaper.initialDeadTopMm;
                        prnNextDeadLeftMm = PrinterPort.prnNextPaper.initialDeadLeftMm;
                        prnNextDeadRightMm = PrinterPort.prnNextPaper.initialDeadRightMm;
                        prnNextDeadBottomMm = PrinterPort.prnNextPaper.initialDeadBottomMm;
                        ++prnSpinnerLocked;
                        prnDeadTopModel.setValue(prnNextDeadTopMm);
                        prnDeadLeftModel.setValue(prnNextDeadLeftMm);
                        prnDeadRightModel.setValue(prnNextDeadRightMm);
                        prnDeadBottomModel.setValue(prnNextDeadBottomMm);
                        --prnSpinnerLocked;
                        break;
                    }
                    case "0\u00b0": {
                        prnNextRotation = 0;
                        break;
                    }
                    case "90\u00b0": {
                        prnNextRotation = 1;
                        break;
                    }
                    case "180\u00b0": {
                        prnNextRotation = 2;
                        break;
                    }
                    case "270\u00b0": {
                        prnNextRotation = 3;
                        break;
                    }
                    case "Dark mode": {
                        prnNextDarkMode = ((JCheckBoxMenuItem)object).isSelected();
                        break;
                    }
                    case "Black ink ribbon": {
                        PrinterPort.prnSetSingleColor(0);
                        break;
                    }
                    case "Blue ink ribbon": {
                        PrinterPort.prnSetSingleColor(1);
                        break;
                    }
                    case "Lime ink ribbon": {
                        PrinterPort.prnSetSingleColor(2);
                        break;
                    }
                    case "Cyan ink ribbon": {
                        PrinterPort.prnSetSingleColor(3);
                        break;
                    }
                    case "Red ink ribbon": {
                        PrinterPort.prnSetSingleColor(4);
                        break;
                    }
                    case "Magenta ink ribbon": {
                        PrinterPort.prnSetSingleColor(5);
                        break;
                    }
                    case "Yellow ink ribbon": {
                        PrinterPort.prnSetSingleColor(6);
                        break;
                    }
                    case "White ink ribbon": {
                        PrinterPort.prnSetSingleColor(7);
                        break;
                    }
                    case "6.25%": {
                        prnCanvas.setScaleShift(-4);
                        break;
                    }
                    case "12.5%": {
                        prnCanvas.setScaleShift(-3);
                        break;
                    }
                    case "25%": {
                        prnCanvas.setScaleShift(-2);
                        break;
                    }
                    case "50%": {
                        prnCanvas.setScaleShift(-1);
                        break;
                    }
                    case "100%": {
                        prnCanvas.setScaleShift(0);
                        break;
                    }
                    case "200%": {
                        prnCanvas.setScaleShift(1);
                        break;
                    }
                    case "400%": {
                        prnCanvas.setScaleShift(2);
                        break;
                    }
                    case "800%": {
                        prnCanvas.setScaleShift(3);
                        break;
                    }
                    case "1600%": {
                        prnCanvas.setScaleShift(4);
                        break;
                    }
                    case "Roman / Mincho": {
                        prnDIPSW &= 0xFFFFFF7F;
                        break;
                    }
                    case "Sans-Serif / Gothic": {
                        prnDIPSW |= 0x80;
                        break;
                    }
                    default: {
                        for (Paper paper : prnPaperArray) {
                            if (!paper.nameEn.equals(string)) continue;
                            prnNextPaper = paper;
                            prnNextDeadTopMm = Math.min(prnNextDeadTopMm, PrinterPort.prnNextPaper.paperHeightMm - 1);
                            prnNextDeadLeftMm = Math.min(prnNextDeadLeftMm, PrinterPort.prnNextPaper.paperWidthMm - 1);
                            prnNextDeadRightMm = Math.min(prnNextDeadRightMm, PrinterPort.prnNextPaper.paperWidthMm - 1 - prnNextDeadLeftMm);
                            prnNextDeadBottomMm = Math.min(prnNextDeadBottomMm, PrinterPort.prnNextPaper.paperHeightMm - 1 - prnNextDeadTopMm);
                            ++prnSpinnerLocked;
                            prnDeadTopModel.setMaximum(Integer.valueOf(PrinterPort.prnNextPaper.paperHeightMm - 1));
                            prnDeadLeftModel.setMaximum(Integer.valueOf(PrinterPort.prnNextPaper.paperWidthMm - 1));
                            prnDeadRightModel.setMaximum(Integer.valueOf(PrinterPort.prnNextPaper.paperWidthMm - 1 - prnNextDeadLeftMm));
                            prnDeadBottomModel.setMaximum(Integer.valueOf(PrinterPort.prnNextPaper.paperHeightMm - 1 - prnNextDeadTopMm));
                            prnDeadTopModel.setValue(prnNextDeadTopMm);
                            prnDeadLeftModel.setValue(prnNextDeadLeftMm);
                            prnDeadRightModel.setValue(prnNextDeadRightMm);
                            prnDeadBottomModel.setValue(prnNextDeadBottomMm);
                            --prnSpinnerLocked;
                            break block34;
                        }
                    }
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu = Multilingual.mlnText(ComponentFactory.createMenu("Portrait", 80, new JComponent[0]), "ja", "\u7e26\u9577");
        JMenu jMenu2 = Multilingual.mlnText(ComponentFactory.createMenu("Landscape", 76, new JComponent[0]), "ja", "\u6a2a\u9577");
        for (int i = 0; i < prnPaperArray.length; ++i) {
            object = prnPaperArray[i];
            (i < prnPaperArray.length >> 1 ? jMenu : jMenu2).add(Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup, object == prnNextPaper, ((Paper)object).nameEn, actionListener), "ja", ((Paper)object).nameJa));
        }
        prnSpinnerLocked = 0;
        prnDeadTopModel = new SpinnerNumberModel(prnNextDeadTopMm, 0, PrinterPort.prnNextPaper.paperHeightMm - 1, 1);
        prnDeadLeftModel = new SpinnerNumberModel(prnNextDeadLeftMm, 0, PrinterPort.prnNextPaper.paperWidthMm - 1, 1);
        prnDeadRightModel = new SpinnerNumberModel(prnNextDeadRightMm, 0, PrinterPort.prnNextPaper.paperWidthMm - 1 - prnNextDeadLeftMm, 1);
        prnDeadBottomModel = new SpinnerNumberModel(prnNextDeadBottomMm, 0, PrinterPort.prnNextPaper.paperHeightMm - 1 - prnNextDeadTopMm, 1);
        prnDeadTopSpinner = ComponentFactory.createNumberSpinner(prnDeadTopModel, 4, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (prnSpinnerLocked == 0) {
                    prnNextDeadTopMm = prnDeadTopModel.getNumber().intValue();
                    prnDeadBottomModel.setMaximum(Integer.valueOf(PrinterPort.prnNextPaper.paperHeightMm - 1 - prnNextDeadTopMm));
                }
            }
        });
        prnDeadLeftSpinner = ComponentFactory.createNumberSpinner(prnDeadLeftModel, 4, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (prnSpinnerLocked == 0) {
                    prnNextDeadLeftMm = prnDeadLeftModel.getNumber().intValue();
                    prnDeadRightModel.setMaximum(Integer.valueOf(PrinterPort.prnNextPaper.paperWidthMm - 1 - prnNextDeadLeftMm));
                }
            }
        });
        prnDeadRightSpinner = ComponentFactory.createNumberSpinner(prnDeadRightModel, 4, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (prnSpinnerLocked == 0) {
                    prnNextDeadRightMm = prnDeadRightModel.getNumber().intValue();
                    prnDeadLeftModel.setMaximum(Integer.valueOf(PrinterPort.prnNextPaper.paperWidthMm - 1 - prnNextDeadRightMm));
                }
            }
        });
        prnDeadBottomSpinner = ComponentFactory.createNumberSpinner(prnDeadBottomModel, 4, new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (prnSpinnerLocked == 0) {
                    prnNextDeadBottomMm = prnDeadBottomModel.getNumber().intValue();
                    prnDeadTopModel.setMaximum(Integer.valueOf(PrinterPort.prnNextPaper.paperHeightMm - 1 - prnNextDeadBottomMm));
                }
            }
        });
        ButtonGroup buttonGroup2 = new ButtonGroup();
        object = new ButtonGroup();
        prnScaleMenuItem = new JRadioButtonMenuItem[9];
        ButtonGroup buttonGroup3 = new ButtonGroup();
        ButtonGroup buttonGroup4 = new ButtonGroup();
        Component[] componentArray = new Component[5];
        JComponent[] jComponentArray = new JComponent[9];
        prnOnlineMenuItem = Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(prnOnlineOn, "Online", actionListener), "ja", "\u30aa\u30f3\u30e9\u30a4\u30f3");
        jComponentArray[0] = prnOnlineMenuItem;
        jComponentArray[1] = ComponentFactory.createHorizontalSeparator();
        jComponentArray[2] = Multilingual.mlnText(ComponentFactory.createMenuItem("Eject", 69, actionListener), "ja", "\u6392\u7d19");
        jComponentArray[3] = Multilingual.mlnText(ComponentFactory.createMenuItem("Destroy", 68, actionListener), "ja", "\u7834\u68c4");
        jComponentArray[4] = Multilingual.mlnText(ComponentFactory.createMenuItem("Reset", 82, actionListener), "ja", "\u30ea\u30bb\u30c3\u30c8");
        jComponentArray[5] = ComponentFactory.createHorizontalSeparator();
        prnAutosaveMenuItem = Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(prnAutosaveOn, "Autosave", actionListener), "ja", "\u81ea\u52d5\u4fdd\u5b58");
        jComponentArray[6] = prnAutosaveMenuItem;
        jComponentArray[7] = ComponentFactory.createHorizontalSeparator();
        jComponentArray[8] = Multilingual.mlnText(ComponentFactory.createMenuItem("Close", 67, actionListener), "ja", "\u9589\u3058\u308b");
        componentArray[0] = Multilingual.mlnText(ComponentFactory.createMenu("File", 70, jComponentArray), "ja", "\u30d5\u30a1\u30a4\u30eb");
        componentArray[1] = Multilingual.mlnText(ComponentFactory.createMenu("Paper", 80, jMenu, jMenu2, ComponentFactory.createHorizontalSeparator(), Multilingual.mlnText(ComponentFactory.createMenu("Margin", 77, ComponentFactory.createHorizontalBox(Box.createHorizontalGlue(), Multilingual.mlnText(ComponentFactory.createLabel("Top "), "ja", "\u4e0a "), prnDeadTopSpinner, ComponentFactory.createLabel(" mm"), Box.createHorizontalGlue()), ComponentFactory.createHorizontalBox(Box.createHorizontalGlue(), Multilingual.mlnText(ComponentFactory.createLabel("Left "), "ja", "\u5de6 "), prnDeadLeftSpinner, ComponentFactory.createLabel(" mm"), Box.createHorizontalStrut(20), Multilingual.mlnText(ComponentFactory.createLabel("Right "), "ja", "\u53f3 "), prnDeadRightSpinner, ComponentFactory.createLabel(" mm"), Box.createHorizontalGlue()), ComponentFactory.createHorizontalBox(Box.createHorizontalGlue(), Multilingual.mlnText(ComponentFactory.createLabel("Bottom "), "ja", "\u4e0b "), prnDeadBottomSpinner, ComponentFactory.createLabel(" mm"), Box.createHorizontalGlue()), ComponentFactory.createHorizontalSeparator(), Multilingual.mlnText(ComponentFactory.createMenuItem("No margins", actionListener), "ja", "\u4f59\u767d\u306a\u3057"), ComponentFactory.createHorizontalSeparator(), Multilingual.mlnText(ComponentFactory.createMenuItem("Reset margins", actionListener), "ja", "\u521d\u671f\u5024\u306b\u623b\u3059")), "ja", "\u4f59\u767d"), ComponentFactory.createHorizontalSeparator(), ComponentFactory.createRadioButtonMenuItem(buttonGroup3, prnNextRotation == 0, "0\u00b0", actionListener), ComponentFactory.createRadioButtonMenuItem(buttonGroup3, prnNextRotation == 1, "90\u00b0", actionListener), ComponentFactory.createRadioButtonMenuItem(buttonGroup3, prnNextRotation == 2, "180\u00b0", actionListener), ComponentFactory.createRadioButtonMenuItem(buttonGroup3, prnNextRotation == 3, "270\u00b0", actionListener), ComponentFactory.createHorizontalSeparator(), Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(prnNextDarkMode, "Dark mode", actionListener), "ja", "\u30c0\u30fc\u30af\u30e2\u30fc\u30c9")), "ja", "\u7528\u7d19");
        componentArray[2] = Multilingual.mlnText(ComponentFactory.createMenu("Ink ribbon", 82, Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup2, prnSingleColor == 0, "Black ink ribbon", 48, actionListener), "ja", "\u9ed2\u8272\u30a4\u30f3\u30af\u30ea\u30dc\u30f3"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup2, prnSingleColor == 1, "Blue ink ribbon", 49, actionListener), "ja", "\u9752\u8272\u30a4\u30f3\u30af\u30ea\u30dc\u30f3"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup2, prnSingleColor == 2, "Lime ink ribbon", 50, actionListener), "ja", "\u7dd1\u8272\u30a4\u30f3\u30af\u30ea\u30dc\u30f3"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup2, prnSingleColor == 3, "Cyan ink ribbon", 51, actionListener), "ja", "\u6c34\u8272\u30a4\u30f3\u30af\u30ea\u30dc\u30f3"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup2, prnSingleColor == 4, "Red ink ribbon", 52, actionListener), "ja", "\u8d64\u8272\u30a4\u30f3\u30af\u30ea\u30dc\u30f3"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup2, prnSingleColor == 5, "Magenta ink ribbon", 53, actionListener), "ja", "\u7d2b\u8272\u30a4\u30f3\u30af\u30ea\u30dc\u30f3"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup2, prnSingleColor == 6, "Yellow ink ribbon", 54, actionListener), "ja", "\u9ec4\u8272\u30a4\u30f3\u30af\u30ea\u30dc\u30f3"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup2, prnSingleColor == 7, "White ink ribbon", 55, actionListener), "ja", "\u767d\u8272\u30a4\u30f3\u30af\u30ea\u30dc\u30f3")), "ja", "\u30a4\u30f3\u30af\u30ea\u30dc\u30f3");
        JComponent[] jComponentArray2 = new JComponent[9];
        PrinterPort.prnScaleMenuItem[0] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object, prnScaleShift == -4, "6.25%", 49, actionListener);
        jComponentArray2[0] = PrinterPort.prnScaleMenuItem[0];
        PrinterPort.prnScaleMenuItem[1] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object, prnScaleShift == -3, "12.5%", 50, actionListener);
        jComponentArray2[1] = PrinterPort.prnScaleMenuItem[1];
        PrinterPort.prnScaleMenuItem[2] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object, prnScaleShift == -2, "25%", 51, actionListener);
        jComponentArray2[2] = PrinterPort.prnScaleMenuItem[2];
        PrinterPort.prnScaleMenuItem[3] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object, prnScaleShift == -1, "50%", 52, actionListener);
        jComponentArray2[3] = PrinterPort.prnScaleMenuItem[3];
        PrinterPort.prnScaleMenuItem[4] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object, prnScaleShift == 0, "100%", 53, actionListener);
        jComponentArray2[4] = PrinterPort.prnScaleMenuItem[4];
        PrinterPort.prnScaleMenuItem[5] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object, prnScaleShift == 1, "200%", 54, actionListener);
        jComponentArray2[5] = PrinterPort.prnScaleMenuItem[5];
        PrinterPort.prnScaleMenuItem[6] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object, prnScaleShift == 2, "400%", 55, actionListener);
        jComponentArray2[6] = PrinterPort.prnScaleMenuItem[6];
        PrinterPort.prnScaleMenuItem[7] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object, prnScaleShift == 3, "800%", 56, actionListener);
        jComponentArray2[7] = PrinterPort.prnScaleMenuItem[7];
        PrinterPort.prnScaleMenuItem[8] = ComponentFactory.createRadioButtonMenuItem((ButtonGroup)object, prnScaleShift == 4, "1600%", 57, actionListener);
        jComponentArray2[8] = PrinterPort.prnScaleMenuItem[8];
        componentArray[3] = Multilingual.mlnText(ComponentFactory.createMenu("Display", 68, jComponentArray2), "ja", "\u8868\u793a");
        componentArray[4] = ComponentFactory.createMenu("DIPSW", 83, Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup4, (prnDIPSW & 0x80) == 0, "Roman / Mincho", actionListener), "ja", "\u30ed\u30fc\u30de\u30f3\u4f53\uff0f\u660e\u671d\u4f53"), Multilingual.mlnText(ComponentFactory.createRadioButtonMenuItem(buttonGroup4, (prnDIPSW & 0x80) != 0, "Sans-Serif / Gothic", actionListener), "ja", "\u30b5\u30f3\u30bb\u30ea\u30d5\u4f53\uff0f\u30b4\u30b7\u30c3\u30af\u4f53"));
        JMenuBar jMenuBar = ComponentFactory.createMenuBar(componentArray);
        prnCanvas.addScaleShiftListener(new ScrollCanvas.ScaleShiftListener(){

            @Override
            public void scaleShiftChanged(int n) {
                if (prnScaleShift != n && -4 <= n && n <= 4) {
                    prnScaleShift = n;
                    prnScaleMenuItem[4 + n].setSelected(true);
                }
            }
        });
        prnFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("prn", "Printer", jMenuBar, ComponentFactory.createBorderPanel(ComponentFactory.setPreferredSize(prnCanvas, 600, 400), null, null, null)), "ja", "\u30d7\u30ea\u30f3\u30bf");
    }

    public static void prnMakeSaveDialog() {
        prnWriterSuffixes = ImageIO.getWriterFileSuffixes();
        if (XEiJ.prgCaseIgnored) {
            for (int i = 0; i < prnWriterSuffixes.length; ++i) {
                PrinterPort.prnWriterSuffixes[i] = prnWriterSuffixes[i].toLowerCase();
            }
        }
        prnSaveFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getName();
                if (XEiJ.prgCaseIgnored) {
                    string = string.toLowerCase();
                }
                for (String string2 : prnWriterSuffixes) {
                    if (!string.endsWith("." + string2)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getDescription() {
                return Multilingual.mlnJapanese ? "\u30d7\u30ea\u30f3\u30bf\u51fa\u529b\u30a4\u30e1\u30fc\u30b8" : "Printer Output Image";
            }
        };
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (actionEvent.getActionCommand()) {
                    case "ApproveSelection": 
                    case "Save": {
                        File file = prnSaveFileChooser.getSelectedFile().getAbsoluteFile();
                        prnSavePath = file.getParentFile().getAbsolutePath();
                        prnSaveName = file.getName();
                        if (!PrinterPort.prnSave()) break;
                        prnSaveDialog.setVisible(false);
                        break;
                    }
                    case "CancelSelection": 
                    case "Discard": {
                        prnSaveDialog.setVisible(false);
                        break;
                    }
                    case "Autosave from next time": {
                        PrinterPort.prnSetAutosaveOn(prnAutosaveCheckBox.isSelected());
                    }
                }
            }
        };
        prnSaveFileChooser = new JFileChooser2(new File(prnSavePath + File.separator + prnSaveName));
        prnSaveFileChooser.setFileFilter(prnSaveFileFilter);
        prnSaveFileChooser.setMultiSelectionEnabled(false);
        prnSaveFileChooser.setControlButtonsAreShown(false);
        prnSaveFileChooser.addActionListener(actionListener);
        JComponent[] jComponentArray = new JComponent[1];
        Component[] componentArray = new Component[3];
        componentArray[0] = prnSaveFileChooser;
        Component[] componentArray2 = new Component[9];
        componentArray2[0] = Box.createHorizontalStrut(12);
        componentArray2[1] = Box.createHorizontalGlue();
        prnAutosaveCheckBox = Multilingual.mlnText(ComponentFactory.createCheckBox(prnAutosaveOn, "Autosave from next time", actionListener), "ja", "\u6b21\u56de\u304b\u3089\u81ea\u52d5\u4fdd\u5b58");
        componentArray2[2] = prnAutosaveCheckBox;
        componentArray2[3] = Box.createHorizontalGlue();
        componentArray2[4] = Box.createHorizontalStrut(12);
        componentArray2[5] = Multilingual.mlnText(ComponentFactory.createButton("Save", 83, actionListener), "ja", "\u4fdd\u5b58");
        componentArray2[6] = Box.createHorizontalStrut(12);
        componentArray2[7] = Multilingual.mlnText(ComponentFactory.createButton("Discard", 68, actionListener), "ja", "\u7834\u68c4");
        componentArray2[8] = Box.createHorizontalStrut(12);
        componentArray[1] = ComponentFactory.createHorizontalBox(componentArray2);
        componentArray[2] = Box.createVerticalStrut(12);
        jComponentArray[0] = ComponentFactory.createVerticalBox(componentArray);
        prnSaveDialog = Multilingual.mlnTitle(ComponentFactory.createModalDialog(XEiJ.frmFrame, "Save printer output image", ComponentFactory.createBorderPanel(0, 0, jComponentArray)), "ja", "\u30d7\u30ea\u30f3\u30bf\u51fa\u529b\u30a4\u30e1\u30fc\u30b8\u306e\u4fdd\u5b58");
    }

    public static void prnSetAutosaveOn(boolean bl) {
        if (prnAutosaveOn != bl) {
            prnAutosaveOn = bl;
            if (prnAutosaveCheckBox != null && prnAutosaveCheckBox.isSelected() != prnAutosaveOn) {
                prnAutosaveCheckBox.setSelected(prnAutosaveOn);
            }
            if (prnAutosaveMenuItem != null && prnAutosaveMenuItem.isSelected() != prnAutosaveOn) {
                prnAutosaveMenuItem.setSelected(prnAutosaveOn);
            }
        }
    }

    public static void prnReset() {
        prnData = 0;
        prnStrobe = 1;
    }

    public static int prnReadData() {
        return prnData;
    }

    public static int prnReadStrobe() {
        return prnStrobe;
    }

    public static void prnWriteData(int n) {
        prnData = n & 0xFF;
    }

    public static void prnWriteStrobe(int n) {
        if (prnStrobe != (n &= 1)) {
            prnStrobe = n;
            if (prnOnlineOn && n != 0) {
                IOInterrupt.ioiPrnFall();
                PrinterPort.prnAdapterOutput(prnData);
                IOInterrupt.ioiPrnRise();
            }
        }
    }

    public static void prnSetOnlineOn(boolean bl) {
        if (prnOnlineOn != bl) {
            prnOnlineOn = bl;
            if (prnOnlineMenuItem != null) {
                prnOnlineMenuItem.setSelected(bl);
            }
            if (bl) {
                IOInterrupt.ioiPrnRise();
            } else {
                IOInterrupt.ioiPrnFall();
            }
        }
    }

    public static void prnOutput(int n) {
        block138: {
            PrinterPort.prnCommandBuffer[PrinterPort.prnCommandPointer++] = (byte)n;
            if (prnCommandPointer < prnCommandLength) {
                return;
            }
            int n2 = prnCommandBuffer[0] & 0xFF;
            block0 : switch (n2) {
                case 8: {
                    PrinterPort.prnPrintBackSpace();
                    break block138;
                }
                case 9: {
                    PrinterPort.prnPrintHorizontalTab();
                    break block138;
                }
                case 10: {
                    PrinterPort.prnPrintLineFeed(1);
                    break block138;
                }
                case 11: {
                    if (prnCommandLength < 2) {
                        prnCommandLength = 2;
                        return;
                    }
                    int n3 = prnCommandBuffer[1] & 0xFF;
                    PrinterPort.prnPrintVerticalTab(n3 & 0xF);
                    break block138;
                }
                case 12: {
                    PrinterPort.prnPrintFormFeed();
                    break block138;
                }
                case 13: {
                    PrinterPort.prnPrintCarriageReturn();
                    break block138;
                }
                case 14: {
                    PrinterPort.prnSetHorizontalDoubleSizeMode(true);
                    break block138;
                }
                case 15: {
                    PrinterPort.prnSetHorizontalDoubleSizeMode(false);
                    break block138;
                }
                case 16: {
                    if (prnCommandLength < 4) {
                        prnCommandLength = 4;
                        return;
                    }
                    int n4 = prnCommandBuffer[1] & 0xFF;
                    int n5 = prnCommandBuffer[2] & 0xFF;
                    int n6 = prnCommandBuffer[3] & 0xFF;
                    PrinterPort.prnSetStartColumn((n4 & 0xF) * 100 + (n5 & 0xF) * 10 + (n6 & 0xF));
                    break block138;
                }
                case 17: {
                    PrinterPort.prnSelect(true);
                    break block138;
                }
                case 19: {
                    PrinterPort.prnSelect(false);
                    break block138;
                }
                case 20: {
                    int n7 = prnCommandBuffer[prnCommandLength - 1] & 0xFF;
                    if (n7 != 63) {
                        if (prnCommandLength + 1 < prnCommandBuffer.length) {
                            ++prnCommandLength;
                        }
                        return;
                    }
                    PrinterPort.prnSetVerticalTabAnchor(prnCommandBuffer, 1, prnCommandLength - 1);
                    break block138;
                }
                case 24: {
                    PrinterPort.prnCancel();
                    break block138;
                }
                case 26: {
                    if (prnCommandLength < 2) {
                        prnCommandLength = 2;
                        return;
                    }
                    int n8 = prnCommandBuffer[1] & 0xFF;
                    switch (n8) {
                        case 12: {
                            PrinterPort.prnEjectPaper();
                            break block138;
                        }
                        case 26: {
                            PrinterPort.prnErasePaper();
                            break block138;
                        }
                        case 86: {
                            PrinterPort.prnSetVerticalDoubleSizeMode(true);
                            break block138;
                        }
                        case 87: {
                            PrinterPort.prnSetVerticalDoubleSizeMode(false);
                            break block138;
                        }
                    }
                    break;
                }
                case 27: {
                    if (prnCommandLength < 2) {
                        prnCommandLength = 2;
                        return;
                    }
                    int n8 = prnCommandBuffer[1] & 0xFF;
                    switch (n8) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            PrinterPort.prnHorizontalMove(n8);
                            break block138;
                        }
                        case 11: {
                            if (prnCommandLength < 4) {
                                prnCommandLength = 4;
                                return;
                            }
                            int n9 = prnCommandBuffer[2] & 0xFF;
                            int n10 = prnCommandBuffer[3] & 0xFF;
                            PrinterPort.prnPrintLineFeed((n9 & 0xF) * 10 + (n10 & 0xF));
                            break block138;
                        }
                        case 16: {
                            if (prnCommandLength < 6) {
                                prnCommandLength = 6;
                                return;
                            }
                            int n11 = prnCommandBuffer[2] & 0xFF;
                            int n12 = prnCommandBuffer[3] & 0xFF;
                            int n13 = prnCommandBuffer[4] & 0xFF;
                            int n14 = prnCommandBuffer[5] & 0xFF;
                            PrinterPort.prnSetHorizontalStartPosition((n11 & 0xF) * 1000 + (n12 & 0xF) * 100 + (n13 & 0xF) * 10 + (n14 & 0xF));
                            break block138;
                        }
                        case 25: {
                            PrinterPort.prnSetColorMode();
                            break block138;
                        }
                        case 33: {
                            PrinterPort.prnSetStrongMode(true);
                            break block138;
                        }
                        case 34: {
                            PrinterPort.prnSetStrongMode(false);
                            break block138;
                        }
                        case 36: {
                            PrinterPort.prnSetHiraganaMode(false);
                            break block138;
                        }
                        case 37: {
                            if (prnCommandLength < 3) {
                                prnCommandLength = 3;
                                return;
                            }
                            int n15 = prnCommandBuffer[2] & 0xFF;
                            switch (n15) {
                                case 50: {
                                    if (prnCommandLength < 5) {
                                        prnCommandLength = 5;
                                        return;
                                    }
                                    int n16 = prnCommandBuffer[3] & 0xFF;
                                    int n17 = prnCommandBuffer[4] & 0xFF;
                                    int n18 = n16 << 8 | n17;
                                    if (prnCommandLength < 5 + n18) {
                                        prnCommandLength = 5 + n18;
                                        return;
                                    }
                                    PrinterPort.prn8DotBitImage(prnCommandBuffer, 5, n18);
                                    break block138;
                                }
                                case 57: {
                                    if (prnCommandLength < 4) {
                                        prnCommandLength = 4;
                                        return;
                                    }
                                    int n19 = prnCommandBuffer[3] & 0xFF;
                                    PrinterPort.prnSetLineHeight(n19);
                                    break block138;
                                }
                            }
                            break block0;
                        }
                        case 38: {
                            PrinterPort.prnSetHiraganaMode(true);
                            break block138;
                        }
                        case 40: {
                            int n20 = prnCommandBuffer[prnCommandLength - 1] & 0xFF;
                            if (n20 != 46) {
                                if (prnCommandLength + 1 < prnCommandBuffer.length) {
                                    ++prnCommandLength;
                                }
                                return;
                            }
                            PrinterPort.prnSetHorizontalTabAnchor(prnCommandBuffer, 2, prnCommandLength - 2);
                            break block138;
                        }
                        case 41: {
                            int n21 = prnCommandBuffer[prnCommandLength - 1] & 0xFF;
                            if (n21 != 46) {
                                if (prnCommandLength + 1 < prnCommandBuffer.length) {
                                    ++prnCommandLength;
                                }
                                return;
                            }
                            PrinterPort.prnClearHorizontalTabAnchor(prnCommandBuffer, 2, prnCommandLength - 2);
                            break block138;
                        }
                        case 42: {
                            if (prnCommandLength < 36) {
                                prnCommandLength = 36;
                                return;
                            }
                            PrinterPort.prn16DotExtendedCharacterDefinition(prnCommandBuffer, 2, prnCommandLength - 2);
                            break block138;
                        }
                        case 43: {
                            if (prnCommandLength < 76) {
                                prnCommandLength = 76;
                                return;
                            }
                            PrinterPort.prn24DotExtendedCharacterDefinition(prnCommandBuffer, 2, prnCommandLength - 2);
                            break block138;
                        }
                        case 47: {
                            if (prnCommandLength < 5) {
                                prnCommandLength = 5;
                                return;
                            }
                            int n22 = prnCommandBuffer[2] & 0xFF;
                            int n23 = prnCommandBuffer[3] & 0xFF;
                            int n24 = prnCommandBuffer[4] & 0xFF;
                            PrinterPort.prnSetRightMargin((n22 & 0xF) * 100 + (n23 & 0xF) * 10 + (n24 & 0xF));
                            break block138;
                        }
                        case 50: {
                            PrinterPort.prnClearAllHorizontalTabAnchor();
                            break block138;
                        }
                        case 53: {
                            PrinterPort.prnSetPageStartPosition();
                            break block138;
                        }
                        case 54: {
                            PrinterPort.prnSetOneSixth();
                            break block138;
                        }
                        case 56: {
                            PrinterPort.prnSetOneEighth();
                            break block138;
                        }
                        case 67: {
                            if (prnCommandLength < 4) {
                                prnCommandLength = 4;
                                return;
                            }
                            int n25 = prnCommandBuffer[2] & 0xFF;
                            int n26 = prnCommandBuffer[3] & 0xFF;
                            PrinterPort.prnSetBottomMargin((n25 & 0xF) * 10 + (n26 & 0xF));
                            break block138;
                        }
                        case 69: {
                            PrinterPort.prnSetEliteCharacterMode();
                            break block138;
                        }
                        case 70: {
                            if (prnCommandLength < 4) {
                                prnCommandLength = 4;
                                return;
                            }
                            int n27 = prnCommandBuffer[2] & 0xFF;
                            int n28 = prnCommandBuffer[3] & 0xFF;
                            PrinterPort.prnSetPageHeight((n27 & 0xF) * 10 + (n28 & 0xF));
                            break block138;
                        }
                        case 72: {
                            PrinterPort.prnSetKanjiMode(false);
                            break block138;
                        }
                        case 73: {
                            if (prnCommandLength < 6) {
                                prnCommandLength = 6;
                                return;
                            }
                            int n29 = prnCommandBuffer[2] & 0xFF;
                            int n30 = prnCommandBuffer[3] & 0xFF;
                            int n31 = prnCommandBuffer[4] & 0xFF;
                            int n32 = prnCommandBuffer[5] & 0xFF;
                            int n33 = (n29 & 0xF) * 1000 + (n30 & 0xF) * 100 + (n31 & 0xF) * 10 + (n32 & 0xF);
                            if (prnCommandLength < 6 + 2 * n33) {
                                prnCommandLength = 6 + 2 * n33;
                                return;
                            }
                            PrinterPort.prn16DotBitImage(prnCommandBuffer, 6, n33);
                            break block138;
                        }
                        case 74: {
                            if (prnCommandLength < 4) {
                                prnCommandLength = 4;
                                return;
                            }
                            int n34 = prnCommandBuffer[2] & 0xFF;
                            int n35 = prnCommandBuffer[3] & 0xFF;
                            int n36 = n34 << 8 | n35;
                            if (prnCommandLength < 4 + 3 * n36) {
                                prnCommandLength = 4 + 3 * n36;
                                return;
                            }
                            PrinterPort.prn24DotBitImage(prnCommandBuffer, 4, n36);
                            break block138;
                        }
                        case 75: {
                            PrinterPort.prnSetKanjiMode(true);
                            break block138;
                        }
                        case 76: {
                            if (prnCommandLength < 5) {
                                prnCommandLength = 5;
                                return;
                            }
                            int n37 = prnCommandBuffer[2] & 0xFF;
                            int n38 = prnCommandBuffer[3] & 0xFF;
                            int n39 = prnCommandBuffer[4] & 0xFF;
                            PrinterPort.prnSetLeftMargin((n37 & 0xF) * 100 + (n38 & 0xF) * 10 + (n39 & 0xF));
                            break block138;
                        }
                        case 77: {
                            if (prnCommandLength < 4) {
                                prnCommandLength = 4;
                                return;
                            }
                            int n40 = prnCommandBuffer[2] & 0xFF;
                            int n41 = prnCommandBuffer[3] & 0xFF;
                            int n42 = n40 << 8 | n41;
                            if (prnCommandLength < 4 + 6 * n42) {
                                prnCommandLength = 4 + 6 * n42;
                                return;
                            }
                            PrinterPort.prn48DotBitImage(prnCommandBuffer, 4, n42);
                            break block138;
                        }
                        case 78: {
                            if (prnCommandLength < 6) {
                                prnCommandLength = 6;
                                return;
                            }
                            int n43 = prnCommandBuffer[2] & 0xFF;
                            int n44 = prnCommandBuffer[3] & 0xFF;
                            int n45 = prnCommandBuffer[4] & 0xFF;
                            int n46 = prnCommandBuffer[5] & 0xFF;
                            PrinterPort.prnRepeatCharacter((n43 & 0xF) * 100 + (n44 & 0xF) * 10 + (n45 & 0xF), n46);
                            break block138;
                        }
                        case 80: {
                            PrinterPort.prnSetKanjiMode(false);
                            break block138;
                        }
                        case 81: {
                            PrinterPort.prnSetSmallCharacterMode();
                            break block138;
                        }
                        case 82: {
                            PrinterPort.prnSetPicaCharacterMode();
                            break block138;
                        }
                        case 85: {
                            PrinterPort.prnSetHorizontalDoubleSizeMode(true);
                            break block138;
                        }
                        case 86: {
                            if (prnCommandLength < 7) {
                                prnCommandLength = 7;
                                return;
                            }
                            int n47 = prnCommandBuffer[2] & 0xFF;
                            int n48 = prnCommandBuffer[3] & 0xFF;
                            int n49 = prnCommandBuffer[4] & 0xFF;
                            int n50 = prnCommandBuffer[5] & 0xFF;
                            int n51 = prnCommandBuffer[6] & 0xFF;
                            PrinterPort.prnRepeat8DotBitImage((n47 & 0xF) * 1000 + (n48 & 0xF) * 100 + (n49 & 0xF) * 10 + (n50 & 0xF), n51);
                            break block138;
                        }
                        case 87: {
                            if (prnCommandLength < 8) {
                                prnCommandLength = 8;
                                return;
                            }
                            int n52 = prnCommandBuffer[2] & 0xFF;
                            int n53 = prnCommandBuffer[3] & 0xFF;
                            int n54 = prnCommandBuffer[4] & 0xFF;
                            int n55 = prnCommandBuffer[5] & 0xFF;
                            int n56 = prnCommandBuffer[6] & 0xFF;
                            int n57 = prnCommandBuffer[7] & 0xFF;
                            PrinterPort.prnRepeat16DotBitImage((n52 & 0xF) * 1000 + (n53 & 0xF) * 100 + (n54 & 0xF) * 10 + (n55 & 0xF), n56 << 8 | n57);
                            break block138;
                        }
                        case 88: {
                            PrinterPort.prnSetUnderlineMode(true);
                            break block138;
                        }
                        case 89: {
                            PrinterPort.prnSetUnderlineMode(false);
                            break block138;
                        }
                        case 92: {
                            if (prnCommandLength < 4) {
                                prnCommandLength = 4;
                                return;
                            }
                            int n58 = prnCommandBuffer[2] & 0xFF;
                            int n59 = prnCommandBuffer[3] & 0xFF;
                            PrinterPort.prnHorizontalMove((short)(n59 << 8 | n58));
                            break block138;
                        }
                        case 99: {
                            if (prnCommandLength < 3) {
                                prnCommandLength = 3;
                                return;
                            }
                            int n15 = prnCommandBuffer[2] & 0xFF;
                            switch (n15) {
                                case 49: {
                                    PrinterPort.prnResetSettings();
                                    break block138;
                                }
                            }
                            break block0;
                        }
                        case 107: {
                            if (prnCommandLength < 3) {
                                prnCommandLength = 3;
                                return;
                            }
                            int n60 = prnCommandBuffer[2] & 0xFF;
                            PrinterPort.prnSetHalfWidthFont(n60);
                            break block138;
                        }
                        case 112: {
                            if (prnCommandLength < 3) {
                                prnCommandLength = 3;
                                return;
                            }
                            int n15 = prnCommandBuffer[2] & 0xFF;
                            switch (n15) {
                                case 48: {
                                    PrinterPort.prnSenseOutOfPaper(false);
                                    break block138;
                                }
                                case 49: {
                                    PrinterPort.prnSenseOutOfPaper(true);
                                    break block138;
                                }
                            }
                            break block0;
                        }
                        case 113: {
                            if (prnCommandLength < 3) {
                                prnCommandLength = 3;
                                return;
                            }
                            int n61 = prnCommandBuffer[2] & 0xFF;
                            PrinterPort.prnSetCharacterStyle(n61);
                            break block138;
                        }
                        case 115: {
                            if (prnCommandLength < 3) {
                                prnCommandLength = 3;
                                return;
                            }
                            int n15 = prnCommandBuffer[2] & 0xFF;
                            switch (n15) {
                                case 48: {
                                    PrinterPort.prnSetScriptMode(0);
                                    break block138;
                                }
                                case 49: {
                                    PrinterPort.prnSetScriptMode(1);
                                    break block138;
                                }
                                case 50: {
                                    PrinterPort.prnSetScriptMode(2);
                                    break block138;
                                }
                            }
                        }
                    }
                    break;
                }
                case 28: {
                    if (prnCommandLength < 2) {
                        prnCommandLength = 2;
                        return;
                    }
                    int n8 = prnCommandBuffer[1] & 0xFF;
                    switch (n8) {
                        case 74: {
                            PrinterPort.prnSetVerticalWritingMode(true);
                            break block138;
                        }
                        case 75: {
                            PrinterPort.prnSetVerticalWritingMode(false);
                            break block138;
                        }
                        case 83: {
                            if (prnCommandLength < 4) {
                                prnCommandLength = 4;
                                return;
                            }
                            int n62 = prnCommandBuffer[2] & 0xFF;
                            int n63 = prnCommandBuffer[3] & 0xFF;
                            PrinterPort.prnSetFullWidthLeftRightSpace(n62, n63);
                            break block138;
                        }
                        case 84: {
                            if (prnCommandLength < 4) {
                                prnCommandLength = 4;
                                return;
                            }
                            int n64 = prnCommandBuffer[2] & 0xFF;
                            int n65 = prnCommandBuffer[3] & 0xFF;
                            PrinterPort.prnSetHalfWidthLeftRightSpace(n64, n65);
                            break block138;
                        }
                        case 107: {
                            if (prnCommandLength < 3) {
                                prnCommandLength = 3;
                                return;
                            }
                            int n66 = prnCommandBuffer[2] & 0xFF;
                            PrinterPort.prnSetFullWidthFont(n66);
                            break block138;
                        }
                        case 112: {
                            PrinterPort.prnSetKanjiHorizontalDoubleSizeMode(true);
                            break block138;
                        }
                        case 113: {
                            PrinterPort.prnSetKanjiHorizontalDoubleSizeMode(false);
                            break block138;
                        }
                    }
                    break;
                }
                default: {
                    if (prnKanjiMode) {
                        if (prnCommandLength < 2) {
                            prnCommandLength = 2;
                            return;
                        }
                        int n67 = prnCommandBuffer[1] & 0xFF;
                        n2 = n2 << 8 | n67;
                    }
                    if (n2 == 0) break block138;
                    PrinterPort.prnPrintCharacter(n2);
                    break block138;
                }
            }
            for (int i = 0; i < prnCommandLength; ++i) {
                PrinterPort.prnPrintCharacter(prnCommandBuffer[i] & 0xFF);
            }
        }
        prnCommandLength = 1;
        prnCommandPointer = 0;
    }

    public static void prnFeedPaper() {
        if (prnCurrentPaper != null) {
            return;
        }
        prnCurrentPaper = prnNextPaper;
        prnDeadTopMm = Math.min(prnNextDeadTopMm, PrinterPort.prnCurrentPaper.paperHeightMm - 1);
        prnDeadLeftMm = Math.min(prnNextDeadLeftMm, PrinterPort.prnCurrentPaper.paperWidthMm - 1);
        prnDeadRightMm = Math.min(prnNextDeadRightMm, PrinterPort.prnCurrentPaper.paperWidthMm - 1 - prnDeadLeftMm);
        prnDeadBottomMm = Math.min(prnNextDeadBottomMm, PrinterPort.prnCurrentPaper.paperHeightMm - 1 - prnDeadTopMm);
        prnAliveTopY = (int)Math.floor((double)prnDeadTopMm * 14.173228346456694 + 0.5);
        prnAliveLeftX = (int)Math.floor((double)prnDeadLeftMm * 14.173228346456694 + 0.5);
        prnAliveRightX = (int)Math.floor((double)(PrinterPort.prnCurrentPaper.paperWidthMm - prnDeadRightMm) * 14.173228346456694 + 0.5);
        prnAliveBottomY = (int)Math.floor((double)(PrinterPort.prnCurrentPaper.paperHeightMm - prnDeadBottomMm) * 14.173228346456694 + 0.5);
        prnRotation = prnNextRotation;
        if (prnRotation == 0) {
            prnRotatedWidthDot = PrinterPort.prnCurrentPaper.paperWidthDot;
            prnRotatedHeightDot = PrinterPort.prnCurrentPaper.paperHeightDot;
            prnM11 = 1;
            prnM12 = 0;
            prnM13 = 0;
            prnM21 = 0;
            prnM22 = 1;
            prnM23 = 0;
        } else if (prnRotation == 1) {
            prnRotatedWidthDot = PrinterPort.prnCurrentPaper.paperHeightDot;
            prnRotatedHeightDot = PrinterPort.prnCurrentPaper.paperWidthDot;
            prnM11 = 0;
            prnM12 = -1;
            prnM13 = prnRotatedWidthDot;
            prnM21 = 1;
            prnM22 = 0;
            prnM23 = 0;
        } else if (prnRotation == 2) {
            prnRotatedWidthDot = PrinterPort.prnCurrentPaper.paperWidthDot;
            prnRotatedHeightDot = PrinterPort.prnCurrentPaper.paperHeightDot;
            prnM11 = -1;
            prnM12 = 0;
            prnM13 = prnRotatedWidthDot;
            prnM21 = 0;
            prnM22 = -1;
            prnM23 = prnRotatedHeightDot;
        } else {
            prnRotatedWidthDot = PrinterPort.prnCurrentPaper.paperHeightDot;
            prnRotatedHeightDot = PrinterPort.prnCurrentPaper.paperWidthDot;
            prnM11 = 0;
            prnM12 = 1;
            prnM13 = 0;
            prnM21 = -1;
            prnM22 = 0;
            prnM23 = prnRotatedHeightDot;
        }
        prnIncrementX = prnM11 + prnRotatedWidthDot * prnM21;
        prnIncrementY = prnM12 + prnRotatedWidthDot * prnM22;
        prnDarkMode = prnNextDarkMode;
        prnImage = new BufferedImage(prnRotatedWidthDot, prnRotatedHeightDot, 13, prnDarkMode ? prnDarkImageColorModel : prnImageColorModel);
        prnBitmap = ((DataBufferByte)prnImage.getRaster().getDataBuffer()).getData();
        if (prnCanvas != null) {
            prnCanvas.setImage(prnImage);
        }
        PrinterPort.prnErasePaper();
    }

    public static void prnErasePaper() {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        } else {
            prnPageStart = 0;
            prnPageLength = (prnAliveBottomY - prnAliveTopY + 359) / 360 * 360;
            prnContentTopY = prnPageStart;
            prnContentBottomY = prnPageStart + prnPageLength - prnMarginBottomHeight;
            prnHeadX = prnMarginLeftX;
            prnHeadY = prnContentTopY;
            prnHeadLine = 0;
            Arrays.fill(prnBitmap, 0, prnRotatedWidthDot * prnRotatedHeightDot, (byte)7);
            prnPrinted = false;
            if (prnCanvas != null) {
                prnCanvas.repaint();
            }
        }
    }

    public static void prnEjectPaper() {
        if (prnCurrentPaper == null) {
            return;
        }
        if (prnPrinted) {
            prnPrinted = false;
            PrinterPort.prnSavePaper();
        }
        prnCurrentPaper = null;
        prnHeadX = -1;
        prnHeadY = -1;
        prnHeadLine = -1;
        if (prnCanvas != null) {
            prnCanvas.setImage(null);
        }
    }

    public static void prnSavePaper() {
        while (new File(prnSavePath + File.separator + prnSaveName).isFile()) {
            int n = prnSaveName.lastIndexOf(46);
            if (n < 0) {
                n = prnSaveName.length();
            }
            int n2 = n;
            int n3 = 2;
            if (0 < n && Character.isDigit(prnSaveName.charAt(n - 1))) {
                --n2;
                while (n - 8 < n2 && 0 < n2 && Character.isDigit(prnSaveName.charAt(n2 - 1))) {
                    --n2;
                }
                n3 = Integer.parseInt(prnSaveName.substring(n2, n));
                n3 = (n3 + 1) % 100000000;
            }
            prnSaveName = prnSaveName.substring(0, n2) + n3 + prnSaveName.substring(n);
        }
        File file = new File(prnSavePath + File.separator + prnSaveName).getAbsoluteFile();
        File file2 = file.getParentFile();
        prnSavePath = file2.getAbsolutePath();
        prnSaveName = file.getName();
        file2.mkdirs();
        if (prnAutosaveOn && !PrinterPort.prnSave()) {
            PrinterPort.prnSetAutosaveOn(false);
        }
        if (!prnAutosaveOn) {
            if (prnSaveDialog == null) {
                PrinterPort.prnMakeSaveDialog();
            }
            prnSaveFileChooser.setCurrentDirectory(file2);
            prnSaveFileChooser.rescanCurrentDirectory();
            prnSaveFileChooser.setSelectedFile(file);
            XEiJ.pnlExitFullScreen(false);
            prnSaveDialog.setVisible(true);
        }
    }

    public static void prnSetSingleColor(int n) {
        prnSingleColor = n;
        if (!prnColorMode) {
            prnCurrentColor = n;
        }
    }

    public static int prnGetCharacterWidth() {
        return prnKanjiMode ? (prnHalfWidthLeftSpace + 24 + prnHalfWidthRightSpace) * (prnHorizontalDoubleSizeMode || prnKanjiHorizontalDoubleSizeMode ? 2 : 1) : (prnCharacterType == 0 ? 36 : (prnCharacterType == 1 ? 30 : (prnCharacterType == 2 ? 21 : 0))) * (prnHorizontalDoubleSizeMode ? 2 : 1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void prnPrintCharacter(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        byte[] byArray;
        int n10;
        int n11;
        int n12;
        int n13;
        block101: {
            int n14;
            byte[] byArray2;
            block108: {
                block107: {
                    block105: {
                        block103: {
                            int n15;
                            int n16;
                            block106: {
                                block104: {
                                    block102: {
                                        void var1_8;
                                        int n17;
                                        block99: {
                                            block92: {
                                                block100: {
                                                    block98: {
                                                        block94: {
                                                            block97: {
                                                                block96: {
                                                                    block95: {
                                                                        n = (char)n;
                                                                        if (prnCurrentPaper == null) {
                                                                            PrinterPort.prnFeedPaper();
                                                                        }
                                                                        Object var1_1 = null;
                                                                        n17 = 0;
                                                                        n16 = 0;
                                                                        n15 = 0;
                                                                        if (n > 255) break block94;
                                                                        n16 = n & 0xF;
                                                                        n15 = n >> 4;
                                                                        if (!prnKanjiMode) break block95;
                                                                        FontPage.Prn prn = prnHalfWidthFont == 0 ? fntPagePan24x48R : fntPagePan24x48S;
                                                                        break block92;
                                                                    }
                                                                    if (prnHiraganaMode) {
                                                                        n15 += 16;
                                                                    }
                                                                    if (prnCharacterType != 0) break block96;
                                                                    FontPage.Prn prn = prnHalfWidthFont == 0 ? fntPagePic36x46R : fntPagePic36x46S;
                                                                    break block92;
                                                                }
                                                                if (prnCharacterType != 1) break block97;
                                                                FontPage.Prn prn = prnHalfWidthFont == 0 ? fntPageEli30x46R : fntPageEli30x46S;
                                                                break block92;
                                                            }
                                                            if (prnCharacterType == 2) {
                                                                FontPage.Prn prn = prnHalfWidthFont == 0 ? fntPageSma18x46R : fntPageSma18x46S;
                                                                break block92;
                                                            } else {
                                                                FontPage.Prn prn;
                                                                FontPage.Prn prn2 = prn = prnHalfWidthFont == 0 ? fntPageScr28x32R : fntPageScr28x32S;
                                                                if (prnScriptMode == 2) {
                                                                    n17 = 14;
                                                                }
                                                            }
                                                            break block92;
                                                        }
                                                        FontPage.Zen zen = prnFullWidthFont == 0 ? fntPageZen48x48M : fntPageZen48x48G;
                                                        n15 = n >> 8;
                                                        n16 = n & 0xFF;
                                                        if ((129 <= n15 && n15 <= 159 || 224 <= n15 && n15 <= 239) && (64 <= n16 && n16 <= 126 || 128 <= n16 && n16 <= 252)) {
                                                            if (224 <= n15) {
                                                                n15 -= 64;
                                                            }
                                                            n15 -= 129;
                                                            if (128 <= n16) {
                                                                --n16;
                                                            }
                                                            n15 *= 2;
                                                            if (94 <= (n16 -= 64)) {
                                                                ++n15;
                                                                n16 -= 94;
                                                            }
                                                            n15 += 33;
                                                            n16 += 33;
                                                        }
                                                        if ((n15 != 118 || 33 > n16 || n16 > 126) && (n15 != 119 || 33 > n16 || n16 > 38)) break block98;
                                                        n13 = 48;
                                                        n12 = 48;
                                                        n11 = 6;
                                                        n10 = n11 * n12;
                                                        byArray = new byte[n10];
                                                        System.arraycopy(PrinterPort.prnGetGaijiData(), n10 * (n16 - 33 + 94 * (n15 - 118)), byArray, 0, n10);
                                                        break block99;
                                                    }
                                                    if (33 > n16 || n16 > 126) break block100;
                                                    n16 -= 33;
                                                    if (33 <= n15 && n15 <= 40) {
                                                        n15 -= 33;
                                                        break block92;
                                                    } else if (48 <= n15 && n15 <= 116) {
                                                        n15 -= 33;
                                                        break block92;
                                                    } else {
                                                        n15 = 0;
                                                        n16 = 0;
                                                    }
                                                    break block92;
                                                }
                                                n15 = 0;
                                                n16 = 0;
                                            }
                                            if (!var1_8.fnpReady) {
                                                var1_8.fnpCreateImage((n <= 255 ? prnHalfWidthFont : prnFullWidthFont) == 0 ? PrinterPort.fntGetMinchoFamily() : PrinterPort.fntGetGothicFamily());
                                            }
                                            n13 = var1_8.fnpCharacterWidth;
                                            n12 = var1_8.fnpCharacterHeight;
                                            n11 = var1_8.fnpCharacterHorizontalBytes;
                                            n10 = n11 * n12;
                                            byArray = new byte[n11 * n17 + n10];
                                            System.arraycopy(var1_8.fnpBinaryArray, n10 * (n16 + var1_8.fnpImageCols * n15), byArray, n11 * n17, n10);
                                        }
                                        n10 = n11 * (n12 += n17);
                                        if (!prnVerticalWritingMode || var1_8 == null || var1_8.fnpImageCols != 94 || n15 == 0 && (5 <= n16 && n16 <= 7 || n16 == 60 || 65 <= n16 && n16 <= 69) || n15 == 1 && 9 <= n16 && n16 <= 12 || n15 == 7 && 0 <= n16 && n16 <= 31) break block101;
                                        if (n15 != 0 || 1 > n16 || n16 > 2) break block102;
                                        byArray2 = new byte[288];
                                        break block103;
                                    }
                                    if (n15 != 0 || n16 != 27 && n16 != 32) break block104;
                                    byArray2 = new byte[288];
                                    break block105;
                                }
                                if ((n15 != 3 || n16 != 0 && n16 != 2 && n16 != 4 && n16 != 6 && n16 != 8 && n16 != 34 && n16 != 66 && n16 != 68 && n16 != 70 && n16 != 77) && (n15 != 4 || n16 != 0 && n16 != 2 && n16 != 4 && n16 != 6 && n16 != 8 && n16 != 34 && n16 != 66 && n16 != 68 && n16 != 70 && n16 != 77 && n16 != 84 && n16 != 85)) break block106;
                                byArray2 = new byte[288];
                                break block107;
                            }
                            n9 = n15 == 0 && (16 <= n16 && n16 <= 17 || 28 <= n16 && n16 <= 29 || 33 <= n16 && n16 <= 36 || 41 <= n16 && n16 <= 58 || n16 == 64) ? 0 : 1;
                            break block108;
                        }
                        for (n8 = 0; n8 < 16; ++n8) {
                            n7 = n8 + 32;
                            for (n6 = 32; n6 < 48; ++n6) {
                                n14 = n6 - 32;
                                int n18 = 6 * n8 + (n6 >> 3);
                                byArray2[n18] = (byte)(byArray2[n18] | (byte)((byArray[6 * n7 + (n14 >> 3)] >> (~n14 & 7) & 1) << (~n6 & 7)));
                            }
                        }
                        byArray = byArray2;
                        n9 = 1;
                        break block108;
                    }
                    for (n8 = 0; n8 < 48; ++n8) {
                        n7 = 47 - n8;
                        for (n6 = 0; n6 < 48; ++n6) {
                            n14 = n6;
                            int n19 = 6 * n8 + (n6 >> 3);
                            byArray2[n19] = (byte)(byArray2[n19] | (byte)((byArray[6 * n7 + (n14 >> 3)] >> (~n14 & 7) & 1) << (~n6 & 7)));
                        }
                    }
                    byArray = byArray2;
                    n9 = 0;
                    break block108;
                }
                for (n8 = 0; n8 < 42; ++n8) {
                    n7 = n8 + 6;
                    for (n6 = 6; n6 < 48; ++n6) {
                        n14 = n6 - 6;
                        int n20 = 6 * n8 + (n6 >> 3);
                        byArray2[n20] = (byte)(byArray2[n20] | (byte)((byArray[6 * n7 + (n14 >> 3)] >> (~n14 & 7) & 1) << (~n6 & 7)));
                    }
                }
                byArray = byArray2;
                n9 = 1;
            }
            if (n9 != 0) {
                byArray2 = new byte[288];
                for (n8 = 0; n8 < 48; ++n8) {
                    n7 = 47 - n8;
                    for (n6 = 0; n6 < 48; ++n6) {
                        n14 = n6;
                        int n21 = 6 * n8 + (n6 >> 3);
                        byArray2[n21] = (byte)(byArray2[n21] | (byte)((byArray[6 * n14 + (n7 >> 3)] >> (~n7 & 7) & 1) << (~n6 & 7)));
                    }
                }
                byArray = byArray2;
            }
        }
        n9 = 0;
        int n22 = 0;
        if (prnKanjiMode) {
            if (n13 == 48) {
                n9 = prnFullWidthLeftSpace;
                n22 = prnFullWidthRightSpace;
            } else {
                n9 = prnHalfWidthLeftSpace;
                n22 = prnHalfWidthRightSpace;
            }
        } else if (prnCharacterType == 2) {
            n22 = 3;
        }
        if (n9 != 0 || n22 != 0) {
            n8 = n9 + n13 + n22;
            n7 = n8 + 7 >> 3;
            n6 = n7 * n12;
            byte[] byArray3 = new byte[n6];
            Arrays.fill(byArray3, (byte)0);
            n5 = n9 >> 3;
            n4 = n9 & 7;
            if (n4 == 0) {
                var19_43 = n5;
                for (n3 = 0; n3 < n10; n3 += n11, var19_43 += n7) {
                    for (var20_44 = n11 - 1; 0 <= var20_44; --var20_44) {
                        byArray3[var19_43 + var20_44] = byArray[n3 + var20_44];
                    }
                }
            } else {
                var19_43 = n5;
                for (n3 = 0; n3 < n10; n3 += n11, var19_43 += n7) {
                    byArray3[var19_43 + n11] = (byte)(byArray[n3 + n11 - 1] << 8 - n4);
                    for (var20_44 = n11 - 1; 0 < var20_44; --var20_44) {
                        byArray3[var19_43 + var20_44] = (byte)(byArray[n3 + var20_44 - 1] << 8 - n4 | (byArray[n3 + var20_44] & 0xFF) >> n4);
                    }
                    byArray3[var19_43] = (byte)((byArray[n3] & 0xFF) >> n4);
                }
            }
            n13 = n8;
            n11 = n7;
            n10 = n6;
            byArray = byArray3;
        }
        if (prnStrongMode) {
            for (n9 = 0; n9 < n10; n9 += n11) {
                for (n22 = n11 - 1; 0 < n22; --n22) {
                    int n23 = n9 + n22;
                    byArray[n23] = (byte)(byArray[n23] | (byte)(byArray[n9 + n22 - 1] << 7 | (byArray[n9 + n22] & 0xFF) >> 1));
                }
                int n24 = n9;
                byArray[n24] = (byte)(byArray[n24] | (byte)((byArray[n9] & 0xFF) >> 1));
            }
        }
        if (prnCharacterStyle != 0) {
            byte[] byArray4 = new byte[n10];
            Arrays.fill(byArray4, (byte)0);
            if (prnVerticalWritingMode) {
                n8 = 0;
                for (n22 = n11; n22 < n10; n22 += n11, n8 += n11) {
                    int n25 = n8;
                    byArray4[n25] = (byte)(byArray4[n25] | (byte)((byArray[n22] & 0xFF) >> 1));
                    for (n7 = 1; n7 < n11; ++n7) {
                        int n26 = n8 + n7;
                        byArray4[n26] = (byte)(byArray4[n26] | (byte)(byArray[n22 + n7 - 1] << 7 | (byArray[n22 + n7] & 0xFF) >> 1));
                    }
                }
            } else {
                n22 = 0;
                for (n8 = n11; n8 < n10; n22 += n11, n8 += n11) {
                    int n27 = n8;
                    byArray4[n27] = (byte)(byArray4[n27] | (byte)((byArray[n22] & 0xFF) >> 1));
                    for (n7 = 1; n7 < n11; ++n7) {
                        int n28 = n8 + n7;
                        byArray4[n28] = (byte)(byArray4[n28] | (byte)(byArray[n22 + n7 - 1] << 7 | (byArray[n22 + n7] & 0xFF) >> 1));
                    }
                }
            }
            if (prnCharacterStyle == 2 || prnCharacterStyle == 3) {
                if (prnVerticalWritingMode) {
                    n8 = 0;
                    for (n22 = n11 * 2; n22 < n10; n22 += n11, n8 += n11) {
                        int n29 = n8;
                        byArray4[n29] = (byte)(byArray4[n29] | (byte)((byArray[n22] & 0xFF) >> 2));
                        for (n7 = 1; n7 < n11; ++n7) {
                            int n30 = n8 + n7;
                            byArray4[n30] = (byte)(byArray4[n30] | (byte)(byArray[n22 + n7 - 1] << 6 | (byArray[n22 + n7] & 0xFF) >> 2));
                        }
                    }
                } else {
                    n22 = 0;
                    for (n8 = n11 * 2; n8 < n10; n22 += n11, n8 += n11) {
                        int n31 = n8;
                        byArray4[n31] = (byte)(byArray4[n31] | (byte)((byArray[n22] & 0xFF) >> 2));
                        for (n7 = 1; n7 < n11; ++n7) {
                            int n32 = n8 + n7;
                            byArray4[n32] = (byte)(byArray4[n32] | (byte)(byArray[n22 + n7 - 1] << 6 | (byArray[n22 + n7] & 0xFF) >> 2));
                        }
                    }
                }
            }
            if (prnCharacterStyle == 1 || prnCharacterStyle == 3) {
                n8 = 0;
                for (n22 = n11; n22 < n10; n22 += n11, n8 += n11) {
                    for (n7 = 0; n7 < n11 - 1; ++n7) {
                        int n33 = n8 + n7;
                        byArray4[n33] = (byte)(byArray4[n33] | (byte)(byArray[n22 + n7] << 1 | (byArray[n22 + n7 + 1] & 0xFF) >> 7));
                    }
                    int n34 = n8 + n11 - 1;
                    byArray4[n34] = (byte)(byArray4[n34] | (byte)(byArray[n22 + n11 - 1] << 1));
                }
                n8 = 0;
                for (n22 = n11; n22 < n10; n22 += n11, n8 += n11) {
                    for (n7 = 0; n7 < n11; ++n7) {
                        int n35 = n8 + n7;
                        byArray4[n35] = (byte)(byArray4[n35] | byArray[n22 + n7]);
                    }
                }
                if (prnVerticalWritingMode) {
                    n22 = 0;
                    for (n8 = n11; n8 < n10; n22 += n11, n8 += n11) {
                        int n36 = n8;
                        byArray4[n36] = (byte)(byArray4[n36] | (byte)((byArray[n22] & 0xFF) >> 1));
                        for (n7 = 1; n7 < n11; ++n7) {
                            int n37 = n8 + n7;
                            byArray4[n37] = (byte)(byArray4[n37] | (byte)(byArray[n22 + n7 - 1] << 7 | (byArray[n22 + n7] & 0xFF) >> 1));
                        }
                    }
                } else {
                    n8 = 0;
                    for (n22 = n11; n22 < n10; n22 += n11, n8 += n11) {
                        int n38 = n8;
                        byArray4[n38] = (byte)(byArray4[n38] | (byte)((byArray[n22] & 0xFF) >> 1));
                        for (n7 = 1; n7 < n11; ++n7) {
                            int n39 = n8 + n7;
                            byArray4[n39] = (byte)(byArray4[n39] | (byte)(byArray[n22 + n7 - 1] << 7 | (byArray[n22 + n7] & 0xFF) >> 1));
                        }
                    }
                }
                for (n22 = 0; n22 < n10; n22 += n11) {
                    for (n8 = 0; n8 < n11 - 1; ++n8) {
                        int n40 = n22 + n8;
                        byArray4[n40] = (byte)(byArray4[n40] | (byte)(byArray[n22 + n8] << 1 | (byArray[n22 + n8 + 1] & 0xFF) >> 7));
                    }
                    int n41 = n22 + n11 - 1;
                    byArray4[n41] = (byte)(byArray4[n41] | (byte)(byArray[n22 + n11 - 1] << 1));
                }
                for (n22 = 0; n22 < n10; n22 += n11) {
                    int n42 = n22;
                    byArray4[n42] = (byte)(byArray4[n42] | (byte)((byArray[n22] & 0xFF) >> 1));
                    for (n8 = 1; n8 < n11; ++n8) {
                        int n43 = n22 + n8;
                        byArray4[n43] = (byte)(byArray4[n43] | (byte)(byArray[n22 + n8 - 1] << 7 | (byArray[n22 + n8] & 0xFF) >> 1));
                    }
                }
                n22 = 0;
                for (n8 = n11; n8 < n10; n22 += n11, n8 += n11) {
                    for (n7 = 0; n7 < n11 - 1; ++n7) {
                        int n44 = n8 + n7;
                        byArray4[n44] = (byte)(byArray4[n44] | (byte)(byArray[n22 + n7] << 1 | (byArray[n22 + n7 + 1] & 0xFF) >> 7));
                    }
                    int n45 = n8 + n11 - 1;
                    byArray4[n45] = (byte)(byArray4[n45] | (byte)(byArray[n22 + n11 - 1] << 1));
                }
                n22 = 0;
                for (n8 = n11; n8 < n10; n22 += n11, n8 += n11) {
                    for (n7 = 0; n7 < n11; ++n7) {
                        int n46 = n8 + n7;
                        byArray4[n46] = (byte)(byArray4[n46] | byArray[n22 + n7]);
                    }
                }
            }
            for (n22 = 0; n22 < n10; ++n22) {
                int n47 = n22;
                byArray4[n47] = (byte)(byArray4[n47] & (byte)(~byArray[n22]));
            }
            byArray = byArray4;
        }
        if (prnUnderlineMode) {
            if (prnVerticalWritingMode) {
                int n48 = 0;
                for (n22 = 0; n22 < n11 - 1; ++n22) {
                    byArray[n48 + n22] = -1;
                }
                int n49 = n48 + n11 - 1;
                byArray[n49] = (byte)(byArray[n49] | (byte)(-256 >> (n13 - 1 & 7) + 1));
            } else {
                int n50 = n11 * (n12 - 1);
                for (n22 = 0; n22 < n11 - 1; ++n22) {
                    byArray[n50 + n22] = -1;
                }
                int n51 = n50 + n11 - 1;
                byArray[n51] = (byte)(byArray[n51] | (byte)(-256 >> (n13 - 1 & 7) + 1));
            }
        }
        if (prnHorizontalDoubleSizeMode || prnKanjiMode && prnKanjiHorizontalDoubleSizeMode) {
            int n52 = n13 * 2;
            n22 = n52 + 7 >> 3;
            n8 = n22 * n12;
            byte[] byArray5 = new byte[n8];
            int n53 = 0;
            for (n6 = 0; n6 < n10; n6 += n11, n53 += n22) {
                n4 = 0;
                for (n5 = 0; n5 < n11; ++n5, n4 += 2) {
                    n3 = byArray[n6 + n5] & 0xFF;
                    byArray5[n53 + n4] = PRN_DOUBLE_4BIT[n3 >> 4];
                    if (n4 + 1 >= n22) continue;
                    byArray5[n53 + n4 + 1] = PRN_DOUBLE_4BIT[n3 & 0xF];
                }
            }
            n13 = n52;
            n11 = n22;
            n10 = n8;
            byArray = byArray5;
        }
        if (prnVerticalDoubleSizeMode) {
            int n54 = n12 * 2;
            n22 = n11 * n54;
            byte[] byArray6 = new byte[n22];
            n6 = 0;
            for (int i = 0; i < n10; i += n11, n6 += n11 * 2) {
                for (int j = 0; j < n11; ++j) {
                    byte by = byArray[i + j];
                    byArray6[n6 + j] = by;
                    byArray6[n6 + n11 + j] = by;
                }
            }
            n12 = n54;
            n10 = n22;
            byArray = byArray6;
        }
        if (prnMarginLeftX < prnHeadX && prnMarginRightX < prnHeadX + n13) {
            prnHeadX = prnMarginLeftX;
            prnHeadY += prnLineHeight;
            ++prnHeadLine;
        }
        if (prnContentTopY < prnHeadY && prnContentBottomY < prnHeadY + n12) {
            PrinterPort.prnPrintFormFeed();
        }
        if (0 <= (n2 = PrinterPort.prnCheckRect(n13, n12))) {
            n22 = prnIncrementX;
            int n55 = prnIncrementY;
            for (int i = 0; i < n12; n2 += n55, ++i) {
                n6 = n2;
                for (int j = 0; j < n13; n6 += n22, ++j) {
                    if ((byArray[(j >> 3) + n11 * i] >> (~j & 7) & 1) == 0) continue;
                    int n56 = n6;
                    prnBitmap[n56] = (byte)(prnBitmap[n56] & (byte)prnCurrentColor);
                }
            }
        } else {
            for (n22 = 0; n22 < n12; ++n22) {
                for (int i = 0; i < n13; ++i) {
                    if ((byArray[(i >> 3) + n11 * n22] >> (~i & 7) & 1) == 0) continue;
                    PrinterPort.prnPaintDot(i, n22);
                }
            }
        }
        prnHeadX += n13;
        prnPrinted = true;
        if (prnCanvas != null) {
            prnCanvas.repaint();
        }
    }

    public static void prnPrintBackSpace() {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        prnHeadX = Math.max(prnMarginLeftX, prnHeadX - PrinterPort.prnGetCharacterWidth());
    }

    public static void prnPrintHorizontalTab() {
        int n;
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        for (int i = 0; i < 16 && (n = prnHorizontalTabAnchor[i]) != 0; ++i) {
            if (prnHeadX >= n) continue;
            prnHeadX = Math.min(n, prnMarginRightX - 1);
            break;
        }
    }

    public static void prnSetStartColumn(int n) {
        int n2;
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        if (0 <= n && n <= 999 && prnMarginLeftX + (n2 = PrinterPort.prnGetCharacterWidth() * n) < prnMarginRightX) {
            prnHeadX = prnMarginLeftX + n2;
        }
    }

    public static void prnPrintLineFeed(int n) {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        if (n < 0) {
            n = 0;
        }
        if (prnVerticalDoubleSizeMode) {
            n *= 2;
        }
        prnHeadLine += n;
        if (prnContentBottomY <= (prnHeadY += prnLineHeight * n)) {
            PrinterPort.prnPrintFormFeed();
        }
        if (prnColorMode) {
            prnColorMode = false;
            prnCurrentColor = prnSingleColor;
        }
    }

    public static void prnPrintVerticalTab(int n) {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        for (int i = prnHeadLine; i < 128; ++i) {
            if (prnVerticalTabAnchor[i] != n) continue;
            int n2 = i - prnHeadLine;
            prnHeadX = prnMarginLeftX;
            prnHeadLine += n2;
            if (prnContentBottomY <= (prnHeadY += prnLineHeight * n2)) {
                PrinterPort.prnPrintFormFeed();
            }
            return;
        }
    }

    public static void prnPrintFormFeed() {
        prnContentTopY = prnPageStart += prnPageLength;
        prnContentBottomY = Math.min(prnPageStart + prnPageLength - prnMarginBottomHeight, prnAliveBottomY - prnAliveTopY);
        prnHeadX = prnMarginLeftX;
        prnHeadY = prnContentTopY;
        prnHeadLine = 0;
        if (prnAliveBottomY <= prnAliveTopY + prnHeadY) {
            PrinterPort.prnEjectPaper();
            PrinterPort.prnFeedPaper();
        }
    }

    public static void prnPrintCarriageReturn() {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        prnHeadX = prnMarginLeftX;
        if (prnColorMode) {
            prnCurrentColor = prnCurrentColor == 6 ? 5 : (prnCurrentColor == 5 ? 3 : 6);
        }
    }

    public static void prnSetHorizontalDoubleSizeMode(boolean bl) {
        prnHorizontalDoubleSizeMode = bl;
    }

    public static void prnSelect(boolean bl) {
    }

    public static void prnSetVerticalTabAnchor(byte[] byArray, int n, int n2) {
        int n3;
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        PrinterPort.prnSetPageStartPosition();
        byte by = 48;
        for (n3 = 0; n3 < 128 && n3 < n2; ++n3) {
            byte by2 = byArray[n + n3];
            if (by2 == 48) {
                PrinterPort.prnVerticalTabAnchor[n3] = 0;
                continue;
            }
            if (49 > by2 || by2 > 60 || by2 <= by) break;
            PrinterPort.prnVerticalTabAnchor[n3] = by2 - 48;
            by = by2;
        }
        while (n3 < 128) {
            PrinterPort.prnVerticalTabAnchor[n3] = 0;
            ++n3;
        }
    }

    public static void prnCancel() {
    }

    public static void prnSetVerticalDoubleSizeMode(boolean bl) {
        prnVerticalDoubleSizeMode = bl;
    }

    public static void prnSetHorizontalStartPosition(int n) {
        int n2;
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        if (0 <= n && n <= 9999 && prnMarginLeftX + (n2 = 2 * n) < prnMarginRightX) {
            prnHeadX = prnMarginLeftX + n2;
        }
    }

    public static void prnSetColorMode() {
        prnColorMode = true;
        prnCurrentColor = 6;
    }

    public static void prnSetStrongMode(boolean bl) {
        prnStrongMode = bl;
    }

    public static void prnSetHiraganaMode(boolean bl) {
        prnHiraganaMode = bl;
    }

    public static void prnSetLineHeight(int n) {
        if (0 <= n && n <= 127) {
            prnLineHeight = n == 0 ? prnDefaultLineHeight : 3 * n;
        }
    }

    public static void prn8DotBitImage(byte[] byArray, int n, int n2) {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
    }

    public static void prnSetHorizontalTabAnchor(byte[] byArray, int n, int n2) {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        int n3 = PrinterPort.prnGetCharacterWidth();
        n2 += n;
        int n4 = 0;
        while (n4 < 16 && n < n2 && 48 <= byArray[n] && byArray[n] <= 57) {
            int n5;
            int n6 = byArray[n] - 48;
            ++n;
            while (n < n2 && 48 <= byArray[n] && byArray[n] <= 57) {
                n6 = n6 * 10 + (byArray[n] - 48);
                ++n;
            }
            if ((n4 == 0 ? prnMarginLeftX : prnHorizontalTabAnchor[n4 - 1]) < (n5 = prnMarginLeftX + n3 * n6)) {
                PrinterPort.prnHorizontalTabAnchor[n4] = n5;
                ++n4;
            }
            if (n >= n2 || byArray[n] != 44) break;
            ++n;
        }
        while (n4 < 16) {
            PrinterPort.prnHorizontalTabAnchor[n4] = 0;
            ++n4;
        }
    }

    public static void prnClearHorizontalTabAnchor(byte[] byArray, int n, int n2) {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        int n3 = PrinterPort.prnGetCharacterWidth();
        n2 += n;
        while (n < n2 && 48 <= byArray[n] && byArray[n] <= 57) {
            int n4;
            int n5 = byArray[n] - 48;
            ++n;
            while (n < n2 && 48 <= byArray[n] && byArray[n] <= 57) {
                n5 = n5 * 10 + (byArray[n] - 48);
                ++n;
            }
            int n6 = prnMarginLeftX + n3 * n5;
            for (int i = 0; i < 16 && (n4 = prnHorizontalTabAnchor[i]) != 0 && n6 >= n4; ++i) {
                if (n4 != n6) continue;
                for (int j = i; j < 15; ++j) {
                    PrinterPort.prnHorizontalTabAnchor[j] = prnHorizontalTabAnchor[j + 1];
                }
                PrinterPort.prnHorizontalTabAnchor[j] = 0;
                break;
            }
            if (n >= n2 || byArray[n] != 44) break;
            ++n;
        }
    }

    public static void prn16DotExtendedCharacterDefinition(byte[] byArray, int n, int n2) {
        byte[] byArray2 = PrinterPort.prnGetGaijiData();
        int n3 = byArray[n] & 0xFF;
        int n4 = byArray[n + 1] & 0xFF;
        if (!(n3 == 118 && 33 <= n4 && n4 <= 126 || n3 == 119 && 33 <= n4 && n4 <= 38)) {
            return;
        }
        int n5 = 288 * (n4 - 33 + 94 * (n3 - 118));
        int n6 = n + 2;
        for (int i = 0; i < 16; ++i) {
            int n7;
            int n8 = 0;
            for (n7 = 0; n7 < 8; ++n7) {
                n8 = n8 << 3 | (byArray[n6 + 2 * n7 + (i >> 3)] >> (~i & 7) & 1) * 7;
            }
            byte by = (byte)(n8 >> 16);
            byArray2[n5 + 12] = by;
            byArray2[n5 + 6] = by;
            byArray2[n5] = by;
            byte by2 = (byte)(n8 >> 8);
            byArray2[n5 + 13] = by2;
            byArray2[n5 + 7] = by2;
            byArray2[n5 + 1] = by2;
            byte by3 = (byte)n8;
            byArray2[n5 + 14] = by3;
            byArray2[n5 + 8] = by3;
            byArray2[n5 + 2] = by3;
            n8 = 0;
            for (n7 = 8; n7 < 16; ++n7) {
                n8 = n8 << 3 | (byArray[n6 + 2 * n7 + (i >> 3)] >> (~i & 7) & 1) * 7;
            }
            byte by4 = (byte)(n8 >> 16);
            byArray2[n5 + 15] = by4;
            byArray2[n5 + 9] = by4;
            byArray2[n5 + 3] = by4;
            byte by5 = (byte)(n8 >> 8);
            byArray2[n5 + 16] = by5;
            byArray2[n5 + 10] = by5;
            byArray2[n5 + 4] = by5;
            byte by6 = (byte)n8;
            byArray2[n5 + 17] = by6;
            byArray2[n5 + 11] = by6;
            byArray2[n5 + 5] = by6;
            n5 += 18;
        }
    }

    public static void prn24DotExtendedCharacterDefinition(byte[] byArray, int n, int n2) {
        byte[] byArray2 = PrinterPort.prnGetGaijiData();
        int n3 = byArray[n] & 0xFF;
        int n4 = byArray[n + 1] & 0xFF;
        if (!(n3 == 118 && 33 <= n4 && n4 <= 126 || n3 == 119 && 33 <= n4 && n4 <= 38)) {
            return;
        }
        int n5 = 288 * (n4 - 33 + 94 * (n3 - 118));
        int n6 = n + 2;
        for (int i = 0; i < 24; ++i) {
            int n7;
            int n8 = 0;
            for (n7 = 0; n7 < 16; ++n7) {
                n8 = n8 << 2 | (byArray[n6 + 3 * n7 + (i >> 3)] >> (~i & 7) & 1) * 3;
            }
            byte by = (byte)(n8 >> 24);
            byArray2[n5 + 6] = by;
            byArray2[n5] = by;
            byte by2 = (byte)(n8 >> 16);
            byArray2[n5 + 7] = by2;
            byArray2[n5 + 1] = by2;
            byte by3 = (byte)(n8 >> 8);
            byArray2[n5 + 8] = by3;
            byArray2[n5 + 2] = by3;
            byte by4 = (byte)n8;
            byArray2[n5 + 9] = by4;
            byArray2[n5 + 3] = by4;
            n8 = 0;
            for (n7 = 16; n7 < 24; ++n7) {
                n8 = n8 << 2 | (byArray[n6 + 3 * n7 + (i >> 3)] >> (~i & 7) & 1) * 3;
            }
            byte by5 = (byte)(n8 >> 8);
            byArray2[n5 + 10] = by5;
            byArray2[n5 + 4] = by5;
            byte by6 = (byte)n8;
            byArray2[n5 + 11] = by6;
            byArray2[n5 + 5] = by6;
            n5 += 12;
        }
    }

    public static void prnSetRightMargin(int n) {
        int n2;
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        if (0 <= n && n <= 999 && prnMarginLeftX < (n2 = PrinterPort.prnGetCharacterWidth() * n)) {
            prnMarginRightX = n2;
            for (int i = 0; i < 16; ++i) {
                PrinterPort.prnHorizontalTabAnchor[i] = 0;
            }
        }
    }

    public static void prnClearAllHorizontalTabAnchor() {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        for (int i = 0; i < 16; ++i) {
            PrinterPort.prnHorizontalTabAnchor[i] = 0;
        }
    }

    public static void prnSetPageStartPosition() {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        prnContentTopY = prnPageStart = prnHeadY;
        prnContentBottomY = Math.min(prnPageStart + prnPageLength - prnMarginBottomHeight, prnAliveBottomY - prnAliveTopY);
        prnHeadX = prnMarginLeftX;
        prnHeadY = prnContentTopY;
        prnHeadLine = 0;
    }

    public static void prnSetOneSixth() {
        prnLineHeight = 60;
        prnDefaultLineHeight = 60;
    }

    public static void prnSetOneEighth() {
        prnLineHeight = 45;
        prnDefaultLineHeight = 45;
    }

    public static void prnSetBottomMargin(int n) {
        int n2;
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        if (0 <= n && n <= 99 && (n2 = prnLineHeight * n) < prnPageLength) {
            prnMarginBottomHeight = n2;
            prnContentBottomY = Math.min(prnPageStart + prnPageLength - n2, prnAliveBottomY - prnAliveTopY);
            if (prnContentBottomY <= prnHeadY) {
                PrinterPort.prnPrintFormFeed();
            }
            for (int i = 0; i < 128; ++i) {
                PrinterPort.prnVerticalTabAnchor[i] = 0;
            }
        }
    }

    public static void prnSetEliteCharacterMode() {
        prnCharacterType = 1;
    }

    public static void prnSetPageHeight(int n) {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        PrinterPort.prnSetPageStartPosition();
        if (1 <= n && n <= 99) {
            prnPageLength = 180 * n;
            prnMarginBottomHeight = 0;
            PrinterPort.prnSetPageStartPosition();
        }
    }

    public static void prn16DotBitImage(byte[] byArray, int n, int n2) {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        if (prnLineHeight == 45) {
            prnLineHeight = 48;
        }
        if (!prnHorizontalDoubleSizeMode) {
            if (!prnVerticalDoubleSizeMode) {
                int n3 = n2;
                int n4 = 16;
                int n5 = PrinterPort.prnCheckRect(3 * (n3 = Math.min(3 * n3, prnMarginRightX - prnHeadX) / 3), 3 * (n4 = Math.min(3 * n4, prnContentBottomY - prnHeadY) / 3));
                if (0 <= n5) {
                    int n6 = prnIncrementX;
                    int n7 = prnIncrementY;
                    for (int i = 0; i < n4; ++i) {
                        int n8 = n5;
                        for (int j = 0; j < n3; ++j) {
                            if ((byArray[n + 2 * j + (i >> 3)] >> (~i & 7) & 1) != 0) {
                                int n9 = n8;
                                prnBitmap[n9] = (byte)(prnBitmap[n9] & (byte)prnCurrentColor);
                                int n10 = n8 + n6;
                                prnBitmap[n10] = (byte)(prnBitmap[n10] & (byte)prnCurrentColor);
                                int n11 = n8 + 2 * n6;
                                prnBitmap[n11] = (byte)(prnBitmap[n11] & (byte)prnCurrentColor);
                                int n12 = n8 + n7;
                                prnBitmap[n12] = (byte)(prnBitmap[n12] & (byte)prnCurrentColor);
                                int n13 = n8 + n6 + n7;
                                prnBitmap[n13] = (byte)(prnBitmap[n13] & (byte)prnCurrentColor);
                                int n14 = n8 + 2 * n6 + n7;
                                prnBitmap[n14] = (byte)(prnBitmap[n14] & (byte)prnCurrentColor);
                                int n15 = n8 + 2 * n7;
                                prnBitmap[n15] = (byte)(prnBitmap[n15] & (byte)prnCurrentColor);
                                int n16 = n8 + n6 + 2 * n7;
                                prnBitmap[n16] = (byte)(prnBitmap[n16] & (byte)prnCurrentColor);
                                int n17 = n8 + 2 * n6 + 2 * n7;
                                prnBitmap[n17] = (byte)(prnBitmap[n17] & (byte)prnCurrentColor);
                            }
                            n8 += 3 * n6;
                        }
                        n5 += 3 * n7;
                    }
                } else {
                    for (int i = 0; i < n4; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            if ((byArray[n + 2 * j + (i >> 3)] >> (~i & 7) & 1) == 0) continue;
                            PrinterPort.prnPaintDot(3 * j, 3 * i);
                            PrinterPort.prnPaintDot(3 * j + 1, 3 * i);
                            PrinterPort.prnPaintDot(3 * j + 2, 3 * i);
                            PrinterPort.prnPaintDot(3 * j, 3 * i + 1);
                            PrinterPort.prnPaintDot(3 * j + 1, 3 * i + 1);
                            PrinterPort.prnPaintDot(3 * j + 2, 3 * i + 1);
                            PrinterPort.prnPaintDot(3 * j, 3 * i + 2);
                            PrinterPort.prnPaintDot(3 * j + 1, 3 * i + 2);
                            PrinterPort.prnPaintDot(3 * j + 2, 3 * i + 2);
                        }
                    }
                }
                prnHeadX += 3 * n3;
            } else {
                int n18 = n2;
                int n19 = 16;
                int n20 = PrinterPort.prnCheckRect(3 * (n18 = Math.min(3 * n18, prnMarginRightX - prnHeadX) / 3), 6 * (n19 = Math.min(6 * n19, prnContentBottomY - prnHeadY) / 6));
                if (0 <= n20) {
                    int n21 = prnIncrementX;
                    int n22 = prnIncrementY;
                    for (int i = 0; i < n19; ++i) {
                        int n23 = n20;
                        for (int j = 0; j < n18; ++j) {
                            if ((byArray[n + 2 * j + (i >> 3)] >> (~i & 7) & 1) != 0) {
                                int n24 = n23;
                                prnBitmap[n24] = (byte)(prnBitmap[n24] & (byte)prnCurrentColor);
                                int n25 = n23 + n21;
                                prnBitmap[n25] = (byte)(prnBitmap[n25] & (byte)prnCurrentColor);
                                int n26 = n23 + 2 * n21;
                                prnBitmap[n26] = (byte)(prnBitmap[n26] & (byte)prnCurrentColor);
                                int n27 = n23 + n22;
                                prnBitmap[n27] = (byte)(prnBitmap[n27] & (byte)prnCurrentColor);
                                int n28 = n23 + n21 + n22;
                                prnBitmap[n28] = (byte)(prnBitmap[n28] & (byte)prnCurrentColor);
                                int n29 = n23 + 2 * n21 + n22;
                                prnBitmap[n29] = (byte)(prnBitmap[n29] & (byte)prnCurrentColor);
                                int n30 = n23 + 2 * n22;
                                prnBitmap[n30] = (byte)(prnBitmap[n30] & (byte)prnCurrentColor);
                                int n31 = n23 + n21 + 2 * n22;
                                prnBitmap[n31] = (byte)(prnBitmap[n31] & (byte)prnCurrentColor);
                                int n32 = n23 + 2 * n21 + 2 * n22;
                                prnBitmap[n32] = (byte)(prnBitmap[n32] & (byte)prnCurrentColor);
                                int n33 = n23 + 3 * n22;
                                prnBitmap[n33] = (byte)(prnBitmap[n33] & (byte)prnCurrentColor);
                                int n34 = n23 + n21 + 3 * n22;
                                prnBitmap[n34] = (byte)(prnBitmap[n34] & (byte)prnCurrentColor);
                                int n35 = n23 + 2 * n21 * 3 * n22;
                                prnBitmap[n35] = (byte)(prnBitmap[n35] & (byte)prnCurrentColor);
                                int n36 = n23 + 4 * n22;
                                prnBitmap[n36] = (byte)(prnBitmap[n36] & (byte)prnCurrentColor);
                                int n37 = n23 + n21 + 4 * n22;
                                prnBitmap[n37] = (byte)(prnBitmap[n37] & (byte)prnCurrentColor);
                                int n38 = n23 + 2 * n21 + 4 * n22;
                                prnBitmap[n38] = (byte)(prnBitmap[n38] & (byte)prnCurrentColor);
                                int n39 = n23 + 5 * n22;
                                prnBitmap[n39] = (byte)(prnBitmap[n39] & (byte)prnCurrentColor);
                                int n40 = n23 + n21 + 5 * n22;
                                prnBitmap[n40] = (byte)(prnBitmap[n40] & (byte)prnCurrentColor);
                                int n41 = n23 + 2 * n21 + 5 * n22;
                                prnBitmap[n41] = (byte)(prnBitmap[n41] & (byte)prnCurrentColor);
                            }
                            n23 += 3 * n21;
                        }
                        n20 += 6 * n22;
                    }
                } else {
                    for (int i = 0; i < n19; ++i) {
                        for (int j = 0; j < n18; ++j) {
                            if ((byArray[n + 2 * j + (i >> 3)] >> (~i & 7) & 1) == 0) continue;
                            PrinterPort.prnPaintDot(3 * j, 6 * i);
                            PrinterPort.prnPaintDot(3 * j + 1, 6 * i);
                            PrinterPort.prnPaintDot(3 * j + 2, 6 * i);
                            PrinterPort.prnPaintDot(3 * j, 6 * i + 1);
                            PrinterPort.prnPaintDot(3 * j + 1, 6 * i + 1);
                            PrinterPort.prnPaintDot(3 * j + 2, 6 * i + 1);
                            PrinterPort.prnPaintDot(3 * j, 6 * i + 2);
                            PrinterPort.prnPaintDot(3 * j + 1, 6 * i + 2);
                            PrinterPort.prnPaintDot(3 * j + 2, 6 * i + 2);
                            PrinterPort.prnPaintDot(3 * j, 6 * i + 3);
                            PrinterPort.prnPaintDot(3 * j + 1, 6 * i + 3);
                            PrinterPort.prnPaintDot(3 * j + 2, 6 * i + 3);
                            PrinterPort.prnPaintDot(3 * j, 6 * i + 4);
                            PrinterPort.prnPaintDot(3 * j + 1, 6 * i + 4);
                            PrinterPort.prnPaintDot(3 * j + 2, 6 * i + 4);
                            PrinterPort.prnPaintDot(3 * j, 6 * i + 5);
                            PrinterPort.prnPaintDot(3 * j + 1, 6 * i + 5);
                            PrinterPort.prnPaintDot(3 * j + 2, 6 * i + 5);
                        }
                    }
                }
                prnHeadX += 3 * n18;
            }
        } else if (!prnVerticalDoubleSizeMode) {
            int n42 = n2;
            int n43 = 16;
            int n44 = PrinterPort.prnCheckRect(6 * (n42 = Math.min(6 * n42, prnMarginRightX - prnHeadX) / 6), 3 * (n43 = Math.min(3 * n43, prnContentBottomY - prnHeadY) / 3));
            if (0 <= n44) {
                int n45 = prnIncrementX;
                int n46 = prnIncrementY;
                for (int i = 0; i < n43; ++i) {
                    int n47 = n44;
                    for (int j = 0; j < n42; ++j) {
                        if ((byArray[n + 2 * j + (i >> 3)] >> (~i & 7) & 1) != 0) {
                            int n48 = n47;
                            prnBitmap[n48] = (byte)(prnBitmap[n48] & (byte)prnCurrentColor);
                            int n49 = n47 + n45;
                            prnBitmap[n49] = (byte)(prnBitmap[n49] & (byte)prnCurrentColor);
                            int n50 = n47 + 2 * n45;
                            prnBitmap[n50] = (byte)(prnBitmap[n50] & (byte)prnCurrentColor);
                            int n51 = n47 + 3 * n45;
                            prnBitmap[n51] = (byte)(prnBitmap[n51] & (byte)prnCurrentColor);
                            int n52 = n47 + 4 * n45;
                            prnBitmap[n52] = (byte)(prnBitmap[n52] & (byte)prnCurrentColor);
                            int n53 = n47 + 5 * n45;
                            prnBitmap[n53] = (byte)(prnBitmap[n53] & (byte)prnCurrentColor);
                            int n54 = n47 + n46;
                            prnBitmap[n54] = (byte)(prnBitmap[n54] & (byte)prnCurrentColor);
                            int n55 = n47 + n45 + n46;
                            prnBitmap[n55] = (byte)(prnBitmap[n55] & (byte)prnCurrentColor);
                            int n56 = n47 + 2 * n45 + n46;
                            prnBitmap[n56] = (byte)(prnBitmap[n56] & (byte)prnCurrentColor);
                            int n57 = n47 + 3 * n45 + n46;
                            prnBitmap[n57] = (byte)(prnBitmap[n57] & (byte)prnCurrentColor);
                            int n58 = n47 + 4 * n45 + n46;
                            prnBitmap[n58] = (byte)(prnBitmap[n58] & (byte)prnCurrentColor);
                            int n59 = n47 + 5 * n45 + n46;
                            prnBitmap[n59] = (byte)(prnBitmap[n59] & (byte)prnCurrentColor);
                            int n60 = n47 + 2 * n46;
                            prnBitmap[n60] = (byte)(prnBitmap[n60] & (byte)prnCurrentColor);
                            int n61 = n47 + n45 + 2 * n46;
                            prnBitmap[n61] = (byte)(prnBitmap[n61] & (byte)prnCurrentColor);
                            int n62 = n47 + 2 * n45 + 2 * n46;
                            prnBitmap[n62] = (byte)(prnBitmap[n62] & (byte)prnCurrentColor);
                            int n63 = n47 + 3 * n45 + 2 * n46;
                            prnBitmap[n63] = (byte)(prnBitmap[n63] & (byte)prnCurrentColor);
                            int n64 = n47 + 4 * n45 + 2 * n46;
                            prnBitmap[n64] = (byte)(prnBitmap[n64] & (byte)prnCurrentColor);
                            int n65 = n47 + 5 * n45 + 2 * n46;
                            prnBitmap[n65] = (byte)(prnBitmap[n65] & (byte)prnCurrentColor);
                        }
                        n47 += 6 * n45;
                    }
                    n44 += 3 * n46;
                }
            } else {
                for (int i = 0; i < n43; ++i) {
                    for (int j = 0; j < n42; ++j) {
                        if ((byArray[n + 2 * j + (i >> 3)] >> (~i & 7) & 1) == 0) continue;
                        PrinterPort.prnPaintDot(6 * j, 3 * i);
                        PrinterPort.prnPaintDot(6 * j + 1, 3 * i);
                        PrinterPort.prnPaintDot(6 * j + 2, 3 * i);
                        PrinterPort.prnPaintDot(6 * j + 3, 3 * i);
                        PrinterPort.prnPaintDot(6 * j + 4, 3 * i);
                        PrinterPort.prnPaintDot(6 * j + 5, 3 * i);
                        PrinterPort.prnPaintDot(6 * j, 3 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 1, 3 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 2, 3 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 3, 3 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 4, 3 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 5, 3 * i + 1);
                        PrinterPort.prnPaintDot(6 * j, 3 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 1, 3 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 2, 3 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 3, 3 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 4, 3 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 5, 3 * i + 2);
                    }
                }
            }
            prnHeadX += 6 * n42;
        } else {
            int n66 = n2;
            int n67 = 16;
            int n68 = PrinterPort.prnCheckRect(6 * (n66 = Math.min(6 * n66, prnMarginRightX - prnHeadX) / 6), 6 * (n67 = Math.min(6 * n67, prnContentBottomY - prnHeadY) / 6));
            if (0 <= n68) {
                int n69 = prnIncrementX;
                int n70 = prnIncrementY;
                for (int i = 0; i < n67; ++i) {
                    int n71 = n68;
                    for (int j = 0; j < n66; ++j) {
                        if ((byArray[n + 2 * j + (i >> 3)] >> (~i & 7) & 1) != 0) {
                            int n72 = n71;
                            prnBitmap[n72] = (byte)(prnBitmap[n72] & (byte)prnCurrentColor);
                            int n73 = n71 + n69;
                            prnBitmap[n73] = (byte)(prnBitmap[n73] & (byte)prnCurrentColor);
                            int n74 = n71 + 2 * n69;
                            prnBitmap[n74] = (byte)(prnBitmap[n74] & (byte)prnCurrentColor);
                            int n75 = n71 + 3 * n69;
                            prnBitmap[n75] = (byte)(prnBitmap[n75] & (byte)prnCurrentColor);
                            int n76 = n71 + 4 * n69;
                            prnBitmap[n76] = (byte)(prnBitmap[n76] & (byte)prnCurrentColor);
                            int n77 = n71 + 5 * n69;
                            prnBitmap[n77] = (byte)(prnBitmap[n77] & (byte)prnCurrentColor);
                            int n78 = n71 + n70;
                            prnBitmap[n78] = (byte)(prnBitmap[n78] & (byte)prnCurrentColor);
                            int n79 = n71 + n69 + n70;
                            prnBitmap[n79] = (byte)(prnBitmap[n79] & (byte)prnCurrentColor);
                            int n80 = n71 + 2 * n69 + n70;
                            prnBitmap[n80] = (byte)(prnBitmap[n80] & (byte)prnCurrentColor);
                            int n81 = n71 + 3 * n69 + n70;
                            prnBitmap[n81] = (byte)(prnBitmap[n81] & (byte)prnCurrentColor);
                            int n82 = n71 + 4 * n69 + n70;
                            prnBitmap[n82] = (byte)(prnBitmap[n82] & (byte)prnCurrentColor);
                            int n83 = n71 + 5 * n69 + n70;
                            prnBitmap[n83] = (byte)(prnBitmap[n83] & (byte)prnCurrentColor);
                            int n84 = n71 + 2 * n70;
                            prnBitmap[n84] = (byte)(prnBitmap[n84] & (byte)prnCurrentColor);
                            int n85 = n71 + n69 + 2 * n70;
                            prnBitmap[n85] = (byte)(prnBitmap[n85] & (byte)prnCurrentColor);
                            int n86 = n71 + 2 * n69 + 2 * n70;
                            prnBitmap[n86] = (byte)(prnBitmap[n86] & (byte)prnCurrentColor);
                            int n87 = n71 + 3 * n69 + 2 * n70;
                            prnBitmap[n87] = (byte)(prnBitmap[n87] & (byte)prnCurrentColor);
                            int n88 = n71 + 4 * n69 + 2 * n70;
                            prnBitmap[n88] = (byte)(prnBitmap[n88] & (byte)prnCurrentColor);
                            int n89 = n71 + 5 * n69 + 2 * n70;
                            prnBitmap[n89] = (byte)(prnBitmap[n89] & (byte)prnCurrentColor);
                            int n90 = n71 + 3 * n70;
                            prnBitmap[n90] = (byte)(prnBitmap[n90] & (byte)prnCurrentColor);
                            int n91 = n71 + n69 + 3 * n70;
                            prnBitmap[n91] = (byte)(prnBitmap[n91] & (byte)prnCurrentColor);
                            int n92 = n71 + 2 * n69 * 3 * n70;
                            prnBitmap[n92] = (byte)(prnBitmap[n92] & (byte)prnCurrentColor);
                            int n93 = n71 + 3 * n69 * 3 * n70;
                            prnBitmap[n93] = (byte)(prnBitmap[n93] & (byte)prnCurrentColor);
                            int n94 = n71 + 4 * n69 * 3 * n70;
                            prnBitmap[n94] = (byte)(prnBitmap[n94] & (byte)prnCurrentColor);
                            int n95 = n71 + 5 * n69 * 3 * n70;
                            prnBitmap[n95] = (byte)(prnBitmap[n95] & (byte)prnCurrentColor);
                            int n96 = n71 + 4 * n70;
                            prnBitmap[n96] = (byte)(prnBitmap[n96] & (byte)prnCurrentColor);
                            int n97 = n71 + n69 + 4 * n70;
                            prnBitmap[n97] = (byte)(prnBitmap[n97] & (byte)prnCurrentColor);
                            int n98 = n71 + 2 * n69 + 4 * n70;
                            prnBitmap[n98] = (byte)(prnBitmap[n98] & (byte)prnCurrentColor);
                            int n99 = n71 + 3 * n69 + 4 * n70;
                            prnBitmap[n99] = (byte)(prnBitmap[n99] & (byte)prnCurrentColor);
                            int n100 = n71 + 4 * n69 + 4 * n70;
                            prnBitmap[n100] = (byte)(prnBitmap[n100] & (byte)prnCurrentColor);
                            int n101 = n71 + 5 * n69 + 4 * n70;
                            prnBitmap[n101] = (byte)(prnBitmap[n101] & (byte)prnCurrentColor);
                            int n102 = n71 + 5 * n70;
                            prnBitmap[n102] = (byte)(prnBitmap[n102] & (byte)prnCurrentColor);
                            int n103 = n71 + n69 + 5 * n70;
                            prnBitmap[n103] = (byte)(prnBitmap[n103] & (byte)prnCurrentColor);
                            int n104 = n71 + 2 * n69 + 5 * n70;
                            prnBitmap[n104] = (byte)(prnBitmap[n104] & (byte)prnCurrentColor);
                            int n105 = n71 + 3 * n69 + 5 * n70;
                            prnBitmap[n105] = (byte)(prnBitmap[n105] & (byte)prnCurrentColor);
                            int n106 = n71 + 4 * n69 + 5 * n70;
                            prnBitmap[n106] = (byte)(prnBitmap[n106] & (byte)prnCurrentColor);
                            int n107 = n71 + 5 * n69 + 5 * n70;
                            prnBitmap[n107] = (byte)(prnBitmap[n107] & (byte)prnCurrentColor);
                        }
                        n71 += 6 * n69;
                    }
                    n68 += 6 * n70;
                }
            } else {
                for (int i = 0; i < n67; ++i) {
                    for (int j = 0; j < n66; ++j) {
                        if ((byArray[n + 2 * j + (i >> 3)] >> (~i & 7) & 1) == 0) continue;
                        PrinterPort.prnPaintDot(6 * j, 6 * i);
                        PrinterPort.prnPaintDot(6 * j + 1, 6 * i);
                        PrinterPort.prnPaintDot(6 * j + 2, 6 * i);
                        PrinterPort.prnPaintDot(6 * j + 3, 6 * i);
                        PrinterPort.prnPaintDot(6 * j + 4, 6 * i);
                        PrinterPort.prnPaintDot(6 * j + 5, 6 * i);
                        PrinterPort.prnPaintDot(6 * j, 6 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 1, 6 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 2, 6 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 3, 6 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 4, 6 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 5, 6 * i + 1);
                        PrinterPort.prnPaintDot(6 * j, 6 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 1, 6 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 2, 6 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 3, 6 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 4, 6 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 5, 6 * i + 2);
                        PrinterPort.prnPaintDot(6 * j, 6 * i + 3);
                        PrinterPort.prnPaintDot(6 * j + 1, 6 * i + 3);
                        PrinterPort.prnPaintDot(6 * j + 2, 6 * i + 3);
                        PrinterPort.prnPaintDot(6 * j + 3, 6 * i + 3);
                        PrinterPort.prnPaintDot(6 * j + 4, 6 * i + 3);
                        PrinterPort.prnPaintDot(6 * j + 5, 6 * i + 3);
                        PrinterPort.prnPaintDot(6 * j, 6 * i + 4);
                        PrinterPort.prnPaintDot(6 * j + 1, 6 * i + 4);
                        PrinterPort.prnPaintDot(6 * j + 2, 6 * i + 4);
                        PrinterPort.prnPaintDot(6 * j + 3, 6 * i + 4);
                        PrinterPort.prnPaintDot(6 * j + 4, 6 * i + 4);
                        PrinterPort.prnPaintDot(6 * j + 5, 6 * i + 4);
                        PrinterPort.prnPaintDot(6 * j, 6 * i + 5);
                        PrinterPort.prnPaintDot(6 * j + 1, 6 * i + 5);
                        PrinterPort.prnPaintDot(6 * j + 2, 6 * i + 5);
                        PrinterPort.prnPaintDot(6 * j + 3, 6 * i + 5);
                        PrinterPort.prnPaintDot(6 * j + 4, 6 * i + 5);
                        PrinterPort.prnPaintDot(6 * j + 5, 6 * i + 5);
                    }
                }
            }
            prnHeadX += 6 * n66;
        }
        prnPrinted = true;
        if (prnCanvas != null) {
            prnCanvas.repaint();
        }
    }

    public static void prn24DotBitImage(byte[] byArray, int n, int n2) {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        if (prnLineHeight == 45) {
            prnLineHeight = 48;
        }
        if (!prnHorizontalDoubleSizeMode) {
            if (!prnVerticalDoubleSizeMode) {
                int n3 = n2;
                int n4 = 24;
                int n5 = PrinterPort.prnCheckRect(2 * (n3 = Math.min(2 * n3, prnMarginRightX - prnHeadX) >> 1), 2 * (n4 = Math.min(2 * n4, prnContentBottomY - prnHeadY) >> 1));
                if (0 <= n5) {
                    int n6 = prnIncrementX;
                    int n7 = prnIncrementY;
                    for (int i = 0; i < n4; ++i) {
                        int n8 = n5;
                        for (int j = 0; j < n3; ++j) {
                            if ((byArray[n + 3 * j + (i >> 3)] >> (~i & 7) & 1) != 0) {
                                int n9 = n8;
                                prnBitmap[n9] = (byte)(prnBitmap[n9] & (byte)prnCurrentColor);
                                int n10 = n8 + n6;
                                prnBitmap[n10] = (byte)(prnBitmap[n10] & (byte)prnCurrentColor);
                                int n11 = n8 + n7;
                                prnBitmap[n11] = (byte)(prnBitmap[n11] & (byte)prnCurrentColor);
                                int n12 = n8 + n6 + n7;
                                prnBitmap[n12] = (byte)(prnBitmap[n12] & (byte)prnCurrentColor);
                            }
                            n8 += 2 * n6;
                        }
                        n5 += 2 * n7;
                    }
                } else {
                    for (int i = 0; i < n4; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            if ((byArray[n + 3 * j + (i >> 3)] >> (~i & 7) & 1) == 0) continue;
                            PrinterPort.prnPaintDot(2 * j, 2 * i);
                            PrinterPort.prnPaintDot(2 * j + 1, 2 * i);
                            PrinterPort.prnPaintDot(2 * j, 2 * i + 1);
                            PrinterPort.prnPaintDot(2 * j + 1, 2 * i + 1);
                        }
                    }
                }
                prnHeadX += 2 * n3;
            } else {
                int n13 = n2;
                int n14 = 24;
                int n15 = PrinterPort.prnCheckRect(2 * (n13 = Math.min(2 * n13, prnMarginRightX - prnHeadX) >> 1), 4 * (n14 = Math.min(4 * n14, prnContentBottomY - prnHeadY) >> 2));
                if (0 <= n15) {
                    int n16 = prnIncrementX;
                    int n17 = prnIncrementY;
                    for (int i = 0; i < n14; ++i) {
                        int n18 = n15;
                        for (int j = 0; j < n13; ++j) {
                            if ((byArray[n + 3 * j + (i >> 3)] >> (~i & 7) & 1) != 0) {
                                int n19 = n18;
                                prnBitmap[n19] = (byte)(prnBitmap[n19] & (byte)prnCurrentColor);
                                int n20 = n18 + n16;
                                prnBitmap[n20] = (byte)(prnBitmap[n20] & (byte)prnCurrentColor);
                                int n21 = n18 + n17;
                                prnBitmap[n21] = (byte)(prnBitmap[n21] & (byte)prnCurrentColor);
                                int n22 = n18 + n16 + n17;
                                prnBitmap[n22] = (byte)(prnBitmap[n22] & (byte)prnCurrentColor);
                                int n23 = n18 + 2 * n17;
                                prnBitmap[n23] = (byte)(prnBitmap[n23] & (byte)prnCurrentColor);
                                int n24 = n18 + n16 + 2 * n17;
                                prnBitmap[n24] = (byte)(prnBitmap[n24] & (byte)prnCurrentColor);
                                int n25 = n18 + 3 * n17;
                                prnBitmap[n25] = (byte)(prnBitmap[n25] & (byte)prnCurrentColor);
                                int n26 = n18 + n16 + 3 * n17;
                                prnBitmap[n26] = (byte)(prnBitmap[n26] & (byte)prnCurrentColor);
                            }
                            n18 += 2 * n16;
                        }
                        n15 += 4 * n17;
                    }
                } else {
                    for (int i = 0; i < n14; ++i) {
                        for (int j = 0; j < n13; ++j) {
                            if ((byArray[n + 3 * j + (i >> 3)] >> (~i & 7) & 1) == 0) continue;
                            PrinterPort.prnPaintDot(2 * j, 4 * i);
                            PrinterPort.prnPaintDot(2 * j + 1, 4 * i);
                            PrinterPort.prnPaintDot(2 * j, 4 * i + 1);
                            PrinterPort.prnPaintDot(2 * j + 1, 4 * i + 1);
                            PrinterPort.prnPaintDot(2 * j, 4 * i + 2);
                            PrinterPort.prnPaintDot(2 * j + 1, 4 * i + 2);
                            PrinterPort.prnPaintDot(2 * j, 4 * i + 3);
                            PrinterPort.prnPaintDot(2 * j + 1, 4 * i + 3);
                        }
                    }
                }
                prnHeadX += 2 * n13;
            }
        } else if (!prnVerticalDoubleSizeMode) {
            int n27 = n2;
            int n28 = 24;
            int n29 = PrinterPort.prnCheckRect(4 * (n27 = Math.min(4 * n27, prnMarginRightX - prnHeadX) >> 2), 2 * (n28 = Math.min(2 * n28, prnContentBottomY - prnHeadY) >> 1));
            if (0 <= n29) {
                int n30 = prnIncrementX;
                int n31 = prnIncrementY;
                for (int i = 0; i < n28; ++i) {
                    int n32 = n29;
                    for (int j = 0; j < n27; ++j) {
                        if ((byArray[n + 3 * j + (i >> 3)] >> (~i & 7) & 1) != 0) {
                            int n33 = n32;
                            prnBitmap[n33] = (byte)(prnBitmap[n33] & (byte)prnCurrentColor);
                            int n34 = n32 + n30;
                            prnBitmap[n34] = (byte)(prnBitmap[n34] & (byte)prnCurrentColor);
                            int n35 = n32 + 2 * n30;
                            prnBitmap[n35] = (byte)(prnBitmap[n35] & (byte)prnCurrentColor);
                            int n36 = n32 + 3 * n30;
                            prnBitmap[n36] = (byte)(prnBitmap[n36] & (byte)prnCurrentColor);
                            int n37 = n32 + n31;
                            prnBitmap[n37] = (byte)(prnBitmap[n37] & (byte)prnCurrentColor);
                            int n38 = n32 + n30 + n31;
                            prnBitmap[n38] = (byte)(prnBitmap[n38] & (byte)prnCurrentColor);
                            int n39 = n32 + 2 * n30 + n31;
                            prnBitmap[n39] = (byte)(prnBitmap[n39] & (byte)prnCurrentColor);
                            int n40 = n32 + 3 * n30 + n31;
                            prnBitmap[n40] = (byte)(prnBitmap[n40] & (byte)prnCurrentColor);
                        }
                        n32 += 4 * n30;
                    }
                    n29 += 2 * n31;
                }
            } else {
                for (int i = 0; i < n28; ++i) {
                    for (int j = 0; j < n27; ++j) {
                        if ((byArray[n + 3 * j + (i >> 3)] >> (~i & 7) & 1) == 0) continue;
                        PrinterPort.prnPaintDot(4 * j, 2 * i);
                        PrinterPort.prnPaintDot(4 * j + 1, 2 * i);
                        PrinterPort.prnPaintDot(4 * j + 2, 2 * i);
                        PrinterPort.prnPaintDot(4 * j + 3, 2 * i);
                        PrinterPort.prnPaintDot(4 * j, 2 * i + 1);
                        PrinterPort.prnPaintDot(4 * j + 1, 2 * i + 1);
                        PrinterPort.prnPaintDot(4 * j + 2, 2 * i + 1);
                        PrinterPort.prnPaintDot(4 * j + 3, 2 * i + 1);
                    }
                }
            }
            prnHeadX += 4 * n27;
        } else {
            int n41 = n2;
            int n42 = 24;
            int n43 = PrinterPort.prnCheckRect(4 * (n41 = Math.min(4 * n41, prnMarginRightX - prnHeadX) >> 2), 4 * (n42 = Math.min(4 * n42, prnContentBottomY - prnHeadY) >> 2));
            if (0 <= n43) {
                int n44 = prnIncrementX;
                int n45 = prnIncrementY;
                for (int i = 0; i < n42; ++i) {
                    int n46 = n43;
                    for (int j = 0; j < n41; ++j) {
                        if ((byArray[n + 3 * j + (i >> 3)] >> (~i & 7) & 1) != 0) {
                            int n47 = n46;
                            prnBitmap[n47] = (byte)(prnBitmap[n47] & (byte)prnCurrentColor);
                            int n48 = n46 + n44;
                            prnBitmap[n48] = (byte)(prnBitmap[n48] & (byte)prnCurrentColor);
                            int n49 = n46 + 2 * n44;
                            prnBitmap[n49] = (byte)(prnBitmap[n49] & (byte)prnCurrentColor);
                            int n50 = n46 + 3 * n44;
                            prnBitmap[n50] = (byte)(prnBitmap[n50] & (byte)prnCurrentColor);
                            int n51 = n46 + n45;
                            prnBitmap[n51] = (byte)(prnBitmap[n51] & (byte)prnCurrentColor);
                            int n52 = n46 + n44 + n45;
                            prnBitmap[n52] = (byte)(prnBitmap[n52] & (byte)prnCurrentColor);
                            int n53 = n46 + 2 * n44 + n45;
                            prnBitmap[n53] = (byte)(prnBitmap[n53] & (byte)prnCurrentColor);
                            int n54 = n46 + 3 * n44 + n45;
                            prnBitmap[n54] = (byte)(prnBitmap[n54] & (byte)prnCurrentColor);
                            int n55 = n46 + 2 * n45;
                            prnBitmap[n55] = (byte)(prnBitmap[n55] & (byte)prnCurrentColor);
                            int n56 = n46 + n44 + 2 * n45;
                            prnBitmap[n56] = (byte)(prnBitmap[n56] & (byte)prnCurrentColor);
                            int n57 = n46 + 2 * n44 + 2 * n45;
                            prnBitmap[n57] = (byte)(prnBitmap[n57] & (byte)prnCurrentColor);
                            int n58 = n46 + 3 * n44 + 2 * n45;
                            prnBitmap[n58] = (byte)(prnBitmap[n58] & (byte)prnCurrentColor);
                            int n59 = n46 + 3 * n45;
                            prnBitmap[n59] = (byte)(prnBitmap[n59] & (byte)prnCurrentColor);
                            int n60 = n46 + n44 + 3 * n45;
                            prnBitmap[n60] = (byte)(prnBitmap[n60] & (byte)prnCurrentColor);
                            int n61 = n46 + 2 * n44 + 3 * n45;
                            prnBitmap[n61] = (byte)(prnBitmap[n61] & (byte)prnCurrentColor);
                            int n62 = n46 + 3 * n44 + 3 * n45;
                            prnBitmap[n62] = (byte)(prnBitmap[n62] & (byte)prnCurrentColor);
                        }
                        n46 += 4 * n44;
                    }
                    n43 += 4 * n45;
                }
            } else {
                for (int i = 0; i < n42; ++i) {
                    for (int j = 0; j < n41; ++j) {
                        if ((byArray[n + 3 * j + (i >> 3)] >> (~i & 7) & 1) == 0) continue;
                        PrinterPort.prnPaintDot(4 * j, 4 * i);
                        PrinterPort.prnPaintDot(4 * j + 1, 4 * i);
                        PrinterPort.prnPaintDot(4 * j + 2, 4 * i);
                        PrinterPort.prnPaintDot(4 * j + 3, 4 * i);
                        PrinterPort.prnPaintDot(4 * j, 4 * i + 1);
                        PrinterPort.prnPaintDot(4 * j + 1, 4 * i + 1);
                        PrinterPort.prnPaintDot(4 * j + 2, 4 * i + 1);
                        PrinterPort.prnPaintDot(4 * j + 3, 4 * i + 1);
                        PrinterPort.prnPaintDot(4 * j, 4 * i + 2);
                        PrinterPort.prnPaintDot(4 * j + 1, 4 * i + 2);
                        PrinterPort.prnPaintDot(4 * j + 2, 4 * i + 2);
                        PrinterPort.prnPaintDot(4 * j + 3, 4 * i + 2);
                        PrinterPort.prnPaintDot(4 * j, 4 * i + 3);
                        PrinterPort.prnPaintDot(4 * j + 1, 4 * i + 3);
                        PrinterPort.prnPaintDot(4 * j + 2, 4 * i + 3);
                        PrinterPort.prnPaintDot(4 * j + 3, 4 * i + 3);
                    }
                }
            }
            prnHeadX += 4 * n41;
        }
        prnPrinted = true;
        if (prnCanvas != null) {
            prnCanvas.repaint();
        }
    }

    public static void prnSetKanjiMode(boolean bl) {
        prnKanjiMode = bl;
    }

    public static void prnSetLeftMargin(int n) {
        int n2;
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        if (0 <= n && n <= 999 && (n2 = PrinterPort.prnGetCharacterWidth() * n) < prnMarginRightX) {
            prnMarginLeftX = n2;
            if (prnHeadX < prnMarginLeftX) {
                prnHeadX = prnMarginLeftX;
            }
            for (int i = 0; i < 16; ++i) {
                PrinterPort.prnHorizontalTabAnchor[i] = 0;
            }
        }
    }

    public static void prn48DotBitImage(byte[] byArray, int n, int n2) {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        if (prnLineHeight == 45) {
            prnLineHeight = 47;
        }
        if (!prnHorizontalDoubleSizeMode) {
            if (!prnVerticalDoubleSizeMode) {
                int n3 = n2;
                int n4 = 48;
                int n5 = PrinterPort.prnCheckRect(n3 = Math.min(n3, prnMarginRightX - prnHeadX), n4 = Math.min(n4, prnContentBottomY - prnHeadY));
                if (0 <= n5) {
                    int n6 = prnIncrementX;
                    int n7 = prnIncrementY;
                    for (int i = 0; i < n4; ++i) {
                        int n8 = n5;
                        for (int j = 0; j < n3; ++j) {
                            if ((byArray[n + 6 * j + (i >> 3)] >> (~i & 7) & 1) != 0) {
                                int n9 = n8;
                                prnBitmap[n9] = (byte)(prnBitmap[n9] & (byte)prnCurrentColor);
                            }
                            n8 += n6;
                        }
                        n5 += n7;
                    }
                } else {
                    for (int i = 0; i < n4; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            if ((byArray[n + 6 * j + (i >> 3)] >> (~i & 7) & 1) == 0) continue;
                            PrinterPort.prnPaintDot(j, i);
                        }
                    }
                }
                prnHeadX += n3;
            } else {
                int n10 = n2;
                int n11 = 48;
                int n12 = PrinterPort.prnCheckRect(n10 = Math.min(n10, prnMarginRightX - prnHeadX), 2 * (n11 = Math.min(2 * n11, prnContentBottomY - prnHeadY) >> 1));
                if (0 <= n12) {
                    int n13 = prnIncrementX;
                    int n14 = prnIncrementY;
                    for (int i = 0; i < n11; ++i) {
                        int n15 = n12;
                        for (int j = 0; j < n10; ++j) {
                            if ((byArray[n + 6 * j + (i >> 3)] >> (~i & 7) & 1) != 0) {
                                int n16 = n15;
                                prnBitmap[n16] = (byte)(prnBitmap[n16] & (byte)prnCurrentColor);
                                int n17 = n15 + n14;
                                prnBitmap[n17] = (byte)(prnBitmap[n17] & (byte)prnCurrentColor);
                            }
                            n15 += n13;
                        }
                        n12 += 2 * n14;
                    }
                } else {
                    for (int i = 0; i < n11; ++i) {
                        for (int j = 0; j < n10; ++j) {
                            if ((byArray[n + 6 * j + (i >> 3)] >> (~i & 7) & 1) == 0) continue;
                            PrinterPort.prnPaintDot(j, 2 * i);
                            PrinterPort.prnPaintDot(j, 2 * i + 1);
                        }
                    }
                }
                prnHeadX += n10;
            }
        } else if (!prnVerticalDoubleSizeMode) {
            int n18 = n2;
            int n19 = 48;
            int n20 = PrinterPort.prnCheckRect(2 * (n18 = Math.min(2 * n18, prnMarginRightX - prnHeadX) >> 1), n19 = Math.min(n19, prnContentBottomY - prnHeadY));
            if (0 <= n20) {
                int n21 = prnIncrementX;
                int n22 = prnIncrementY;
                for (int i = 0; i < n19; ++i) {
                    int n23 = n20;
                    for (int j = 0; j < n18; ++j) {
                        if ((byArray[n + 6 * j + (i >> 3)] >> (~i & 7) & 1) != 0) {
                            int n24 = n23;
                            prnBitmap[n24] = (byte)(prnBitmap[n24] & (byte)prnCurrentColor);
                            int n25 = n23 + n21;
                            prnBitmap[n25] = (byte)(prnBitmap[n25] & (byte)prnCurrentColor);
                        }
                        n23 += 2 * n21;
                    }
                    n20 += n22;
                }
            } else {
                for (int i = 0; i < n19; ++i) {
                    for (int j = 0; j < n18; ++j) {
                        if ((byArray[n + 6 * j + (i >> 3)] >> (~i & 7) & 1) == 0) continue;
                        PrinterPort.prnPaintDot(2 * j, i);
                        PrinterPort.prnPaintDot(2 * j + 1, i);
                    }
                }
            }
            prnHeadX += 2 * n18;
        } else {
            int n26 = n2;
            int n27 = 24;
            int n28 = PrinterPort.prnCheckRect(2 * (n26 = Math.min(2 * n26, prnMarginRightX - prnHeadX) >> 1), 2 * (n27 = Math.min(2 * n27, prnContentBottomY - prnHeadY) >> 1));
            if (0 <= n28) {
                int n29 = prnIncrementX;
                int n30 = prnIncrementY;
                for (int i = 0; i < n27; ++i) {
                    int n31 = n28;
                    for (int j = 0; j < n26; ++j) {
                        if ((byArray[n + 6 * j + (i >> 3)] >> (~i & 7) & 1) != 0) {
                            int n32 = n31;
                            prnBitmap[n32] = (byte)(prnBitmap[n32] & (byte)prnCurrentColor);
                            int n33 = n31 + n29;
                            prnBitmap[n33] = (byte)(prnBitmap[n33] & (byte)prnCurrentColor);
                            int n34 = n31 + n30;
                            prnBitmap[n34] = (byte)(prnBitmap[n34] & (byte)prnCurrentColor);
                            int n35 = n31 + n29 + n30;
                            prnBitmap[n35] = (byte)(prnBitmap[n35] & (byte)prnCurrentColor);
                        }
                        n31 += 2 * n29;
                    }
                    n28 += 2 * n30;
                }
            } else {
                for (int i = 0; i < n27; ++i) {
                    for (int j = 0; j < n26; ++j) {
                        if ((byArray[n + 6 * j + (i >> 3)] >> (~i & 7) & 1) == 0) continue;
                        PrinterPort.prnPaintDot(2 * j, 2 * i);
                        PrinterPort.prnPaintDot(2 * j + 1, 2 * i);
                        PrinterPort.prnPaintDot(2 * j, 2 * i + 1);
                        PrinterPort.prnPaintDot(2 * j + 1, 2 * i + 1);
                    }
                }
            }
            prnHeadX += 2 * n26;
        }
        prnPrinted = true;
        if (prnCanvas != null) {
            prnCanvas.repaint();
        }
    }

    public static void prnRepeatCharacter(int n, int n2) {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        if (32 <= n2) {
            for (int i = 0; i < n; ++i) {
                PrinterPort.prnPrintCharacter(n2);
            }
        }
    }

    public static void prnSetSmallCharacterMode() {
        prnCharacterType = 2;
    }

    public static void prnSetPicaCharacterMode() {
        prnCharacterType = 0;
    }

    public static void prnRepeat8DotBitImage(int n, int n2) {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
    }

    public static void prnRepeat16DotBitImage(int n, int n2) {
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        if (prnLineHeight == 45) {
            prnLineHeight = 48;
        }
        if (!prnHorizontalDoubleSizeMode) {
            if (!prnVerticalDoubleSizeMode) {
                int n3 = n;
                int n4 = 16;
                int n5 = PrinterPort.prnCheckRect(3 * (n3 = Math.min(3 * n3, prnMarginRightX - prnHeadX) / 3), 3 * (n4 = Math.min(3 * n4, prnContentBottomY - prnHeadY) / 3));
                if (0 <= n5) {
                    int n6 = prnIncrementX;
                    int n7 = prnIncrementY;
                    for (int i = 0; i < n4; ++i) {
                        int n8 = n5;
                        for (int j = 0; j < n3; ++j) {
                            if ((n2 >> (~i & 0xF) & 1) != 0) {
                                int n9 = n8;
                                prnBitmap[n9] = (byte)(prnBitmap[n9] & (byte)prnCurrentColor);
                                int n10 = n8 + n6;
                                prnBitmap[n10] = (byte)(prnBitmap[n10] & (byte)prnCurrentColor);
                                int n11 = n8 + 2 * n6;
                                prnBitmap[n11] = (byte)(prnBitmap[n11] & (byte)prnCurrentColor);
                                int n12 = n8 + n7;
                                prnBitmap[n12] = (byte)(prnBitmap[n12] & (byte)prnCurrentColor);
                                int n13 = n8 + n6 + n7;
                                prnBitmap[n13] = (byte)(prnBitmap[n13] & (byte)prnCurrentColor);
                                int n14 = n8 + 2 * n6 + n7;
                                prnBitmap[n14] = (byte)(prnBitmap[n14] & (byte)prnCurrentColor);
                                int n15 = n8 + 2 * n7;
                                prnBitmap[n15] = (byte)(prnBitmap[n15] & (byte)prnCurrentColor);
                                int n16 = n8 + n6 + 2 * n7;
                                prnBitmap[n16] = (byte)(prnBitmap[n16] & (byte)prnCurrentColor);
                                int n17 = n8 + 2 * n6 + 2 * n7;
                                prnBitmap[n17] = (byte)(prnBitmap[n17] & (byte)prnCurrentColor);
                            }
                            n8 += 3 * n6;
                        }
                        n5 += 3 * n7;
                    }
                } else {
                    for (int i = 0; i < n4; ++i) {
                        for (int j = 0; j < n3; ++j) {
                            if ((n2 >> (~i & 0xF) & 1) == 0) continue;
                            PrinterPort.prnPaintDot(3 * j, 3 * i);
                            PrinterPort.prnPaintDot(3 * j + 1, 3 * i);
                            PrinterPort.prnPaintDot(3 * j + 2, 3 * i);
                            PrinterPort.prnPaintDot(3 * j, 3 * i + 1);
                            PrinterPort.prnPaintDot(3 * j + 1, 3 * i + 1);
                            PrinterPort.prnPaintDot(3 * j + 2, 3 * i + 1);
                            PrinterPort.prnPaintDot(3 * j, 3 * i + 2);
                            PrinterPort.prnPaintDot(3 * j + 1, 3 * i + 2);
                            PrinterPort.prnPaintDot(3 * j + 2, 3 * i + 2);
                        }
                    }
                }
                prnHeadX += 3 * n3;
            } else {
                int n18 = n;
                int n19 = 16;
                int n20 = PrinterPort.prnCheckRect(3 * (n18 = Math.min(3 * n18, prnMarginRightX - prnHeadX) / 3), 6 * (n19 = Math.min(6 * n19, prnContentBottomY - prnHeadY) / 6));
                if (0 <= n20) {
                    int n21 = prnIncrementX;
                    int n22 = prnIncrementY;
                    for (int i = 0; i < n19; ++i) {
                        int n23 = n20;
                        for (int j = 0; j < n18; ++j) {
                            if ((n2 >> (~i & 0xF) & 1) != 0) {
                                int n24 = n23;
                                prnBitmap[n24] = (byte)(prnBitmap[n24] & (byte)prnCurrentColor);
                                int n25 = n23 + n21;
                                prnBitmap[n25] = (byte)(prnBitmap[n25] & (byte)prnCurrentColor);
                                int n26 = n23 + 2 * n21;
                                prnBitmap[n26] = (byte)(prnBitmap[n26] & (byte)prnCurrentColor);
                                int n27 = n23 + n22;
                                prnBitmap[n27] = (byte)(prnBitmap[n27] & (byte)prnCurrentColor);
                                int n28 = n23 + n21 + n22;
                                prnBitmap[n28] = (byte)(prnBitmap[n28] & (byte)prnCurrentColor);
                                int n29 = n23 + 2 * n21 + n22;
                                prnBitmap[n29] = (byte)(prnBitmap[n29] & (byte)prnCurrentColor);
                                int n30 = n23 + 2 * n22;
                                prnBitmap[n30] = (byte)(prnBitmap[n30] & (byte)prnCurrentColor);
                                int n31 = n23 + n21 + 2 * n22;
                                prnBitmap[n31] = (byte)(prnBitmap[n31] & (byte)prnCurrentColor);
                                int n32 = n23 + 2 * n21 + 2 * n22;
                                prnBitmap[n32] = (byte)(prnBitmap[n32] & (byte)prnCurrentColor);
                                int n33 = n23 + 3 * n22;
                                prnBitmap[n33] = (byte)(prnBitmap[n33] & (byte)prnCurrentColor);
                                int n34 = n23 + n21 + 3 * n22;
                                prnBitmap[n34] = (byte)(prnBitmap[n34] & (byte)prnCurrentColor);
                                int n35 = n23 + 2 * n21 + 3 * n22;
                                prnBitmap[n35] = (byte)(prnBitmap[n35] & (byte)prnCurrentColor);
                                int n36 = n23 + 4 * n22;
                                prnBitmap[n36] = (byte)(prnBitmap[n36] & (byte)prnCurrentColor);
                                int n37 = n23 + n21 + 4 * n22;
                                prnBitmap[n37] = (byte)(prnBitmap[n37] & (byte)prnCurrentColor);
                                int n38 = n23 + 2 * n21 + 4 * n22;
                                prnBitmap[n38] = (byte)(prnBitmap[n38] & (byte)prnCurrentColor);
                                int n39 = n23 + 5 * n22;
                                prnBitmap[n39] = (byte)(prnBitmap[n39] & (byte)prnCurrentColor);
                                int n40 = n23 + n21 + 5 * n22;
                                prnBitmap[n40] = (byte)(prnBitmap[n40] & (byte)prnCurrentColor);
                                int n41 = n23 + 2 * n21 + 5 * n22;
                                prnBitmap[n41] = (byte)(prnBitmap[n41] & (byte)prnCurrentColor);
                            }
                            n23 += 3 * n21;
                        }
                        n20 += 6 * n22;
                    }
                } else {
                    for (int i = 0; i < n19; ++i) {
                        for (int j = 0; j < n18; ++j) {
                            if ((n2 >> (~i & 0xF) & 1) == 0) continue;
                            PrinterPort.prnPaintDot(3 * j, 6 * i);
                            PrinterPort.prnPaintDot(3 * j + 1, 6 * i);
                            PrinterPort.prnPaintDot(3 * j + 2, 6 * i);
                            PrinterPort.prnPaintDot(3 * j, 6 * i + 1);
                            PrinterPort.prnPaintDot(3 * j + 1, 6 * i + 1);
                            PrinterPort.prnPaintDot(3 * j + 2, 6 * i + 1);
                            PrinterPort.prnPaintDot(3 * j, 6 * i + 2);
                            PrinterPort.prnPaintDot(3 * j + 1, 6 * i + 2);
                            PrinterPort.prnPaintDot(3 * j + 2, 6 * i + 2);
                            PrinterPort.prnPaintDot(3 * j, 6 * i + 3);
                            PrinterPort.prnPaintDot(3 * j + 1, 6 * i + 3);
                            PrinterPort.prnPaintDot(3 * j + 2, 6 * i + 3);
                            PrinterPort.prnPaintDot(3 * j, 6 * i + 4);
                            PrinterPort.prnPaintDot(3 * j + 1, 6 * i + 4);
                            PrinterPort.prnPaintDot(3 * j + 2, 6 * i + 4);
                            PrinterPort.prnPaintDot(3 * j, 6 * i + 5);
                            PrinterPort.prnPaintDot(3 * j + 1, 6 * i + 5);
                            PrinterPort.prnPaintDot(3 * j + 2, 6 * i + 5);
                        }
                    }
                }
                prnHeadX += 3 * n18;
            }
        } else if (!prnVerticalDoubleSizeMode) {
            int n42 = n;
            int n43 = 16;
            int n44 = PrinterPort.prnCheckRect(6 * (n42 = Math.min(6 * n42, prnMarginRightX - prnHeadX) / 6), 3 * (n43 = Math.min(3 * n43, prnContentBottomY - prnHeadY) / 3));
            if (0 <= n44) {
                int n45 = prnIncrementX;
                int n46 = prnIncrementY;
                for (int i = 0; i < n43; ++i) {
                    int n47 = n44;
                    for (int j = 0; j < n42; ++j) {
                        if ((n2 >> (~i & 0xF) & 1) != 0) {
                            int n48 = n47;
                            prnBitmap[n48] = (byte)(prnBitmap[n48] & (byte)prnCurrentColor);
                            int n49 = n47 + n45;
                            prnBitmap[n49] = (byte)(prnBitmap[n49] & (byte)prnCurrentColor);
                            int n50 = n47 + 2 * n45;
                            prnBitmap[n50] = (byte)(prnBitmap[n50] & (byte)prnCurrentColor);
                            int n51 = n47 + 3 * n45;
                            prnBitmap[n51] = (byte)(prnBitmap[n51] & (byte)prnCurrentColor);
                            int n52 = n47 + 4 * n45;
                            prnBitmap[n52] = (byte)(prnBitmap[n52] & (byte)prnCurrentColor);
                            int n53 = n47 + 5 * n45;
                            prnBitmap[n53] = (byte)(prnBitmap[n53] & (byte)prnCurrentColor);
                            int n54 = n47 + n46;
                            prnBitmap[n54] = (byte)(prnBitmap[n54] & (byte)prnCurrentColor);
                            int n55 = n47 + n45 + n46;
                            prnBitmap[n55] = (byte)(prnBitmap[n55] & (byte)prnCurrentColor);
                            int n56 = n47 + 2 * n45 + n46;
                            prnBitmap[n56] = (byte)(prnBitmap[n56] & (byte)prnCurrentColor);
                            int n57 = n47 + 3 * n45 + n46;
                            prnBitmap[n57] = (byte)(prnBitmap[n57] & (byte)prnCurrentColor);
                            int n58 = n47 + 4 * n45 + n46;
                            prnBitmap[n58] = (byte)(prnBitmap[n58] & (byte)prnCurrentColor);
                            int n59 = n47 + 5 * n45 + n46;
                            prnBitmap[n59] = (byte)(prnBitmap[n59] & (byte)prnCurrentColor);
                            int n60 = n47 + 2 * n46;
                            prnBitmap[n60] = (byte)(prnBitmap[n60] & (byte)prnCurrentColor);
                            int n61 = n47 + n45 + 2 * n46;
                            prnBitmap[n61] = (byte)(prnBitmap[n61] & (byte)prnCurrentColor);
                            int n62 = n47 + 2 * n45 + 2 * n46;
                            prnBitmap[n62] = (byte)(prnBitmap[n62] & (byte)prnCurrentColor);
                            int n63 = n47 + 3 * n45 + 2 * n46;
                            prnBitmap[n63] = (byte)(prnBitmap[n63] & (byte)prnCurrentColor);
                            int n64 = n47 + 4 * n45 + 2 * n46;
                            prnBitmap[n64] = (byte)(prnBitmap[n64] & (byte)prnCurrentColor);
                            int n65 = n47 + 5 * n45 + 2 * n46;
                            prnBitmap[n65] = (byte)(prnBitmap[n65] & (byte)prnCurrentColor);
                        }
                        n47 += 6 * n45;
                    }
                    n44 += 3 * n46;
                }
            } else {
                for (int i = 0; i < n43; ++i) {
                    for (int j = 0; j < n42; ++j) {
                        if ((n2 >> (~i & 0xF) & 1) == 0) continue;
                        PrinterPort.prnPaintDot(6 * j, 3 * i);
                        PrinterPort.prnPaintDot(6 * j + 1, 3 * i);
                        PrinterPort.prnPaintDot(6 * j + 2, 3 * i);
                        PrinterPort.prnPaintDot(6 * j + 3, 3 * i);
                        PrinterPort.prnPaintDot(6 * j + 4, 3 * i);
                        PrinterPort.prnPaintDot(6 * j + 5, 3 * i);
                        PrinterPort.prnPaintDot(6 * j, 3 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 1, 3 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 2, 3 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 3, 3 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 4, 3 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 5, 3 * i + 1);
                        PrinterPort.prnPaintDot(6 * j, 3 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 1, 3 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 2, 3 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 3, 3 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 4, 3 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 5, 3 * i + 2);
                    }
                }
            }
            prnHeadX += 6 * n42;
        } else {
            int n66 = n;
            int n67 = 16;
            int n68 = PrinterPort.prnCheckRect(6 * (n66 = Math.min(6 * n66, prnMarginRightX - prnHeadX) / 6), 6 * (n67 = Math.min(6 * n67, prnContentBottomY - prnHeadY) / 6));
            if (0 <= n68) {
                int n69 = prnIncrementX;
                int n70 = prnIncrementY;
                for (int i = 0; i < n67; ++i) {
                    int n71 = n68;
                    for (int j = 0; j < n66; ++j) {
                        if ((short)(n2 << (i & 0xF)) < 0) {
                            int n72 = n71;
                            prnBitmap[n72] = (byte)(prnBitmap[n72] & (byte)prnCurrentColor);
                            int n73 = n71 + n69;
                            prnBitmap[n73] = (byte)(prnBitmap[n73] & (byte)prnCurrentColor);
                            int n74 = n71 + 2 * n69;
                            prnBitmap[n74] = (byte)(prnBitmap[n74] & (byte)prnCurrentColor);
                            int n75 = n71 + 3 * n69;
                            prnBitmap[n75] = (byte)(prnBitmap[n75] & (byte)prnCurrentColor);
                            int n76 = n71 + 4 * n69;
                            prnBitmap[n76] = (byte)(prnBitmap[n76] & (byte)prnCurrentColor);
                            int n77 = n71 + 5 * n69;
                            prnBitmap[n77] = (byte)(prnBitmap[n77] & (byte)prnCurrentColor);
                            int n78 = n71 + n70;
                            prnBitmap[n78] = (byte)(prnBitmap[n78] & (byte)prnCurrentColor);
                            int n79 = n71 + n69 + n70;
                            prnBitmap[n79] = (byte)(prnBitmap[n79] & (byte)prnCurrentColor);
                            int n80 = n71 + 2 * n69 + n70;
                            prnBitmap[n80] = (byte)(prnBitmap[n80] & (byte)prnCurrentColor);
                            int n81 = n71 + 3 * n69 + n70;
                            prnBitmap[n81] = (byte)(prnBitmap[n81] & (byte)prnCurrentColor);
                            int n82 = n71 + 4 * n69 + n70;
                            prnBitmap[n82] = (byte)(prnBitmap[n82] & (byte)prnCurrentColor);
                            int n83 = n71 + 5 * n69 + n70;
                            prnBitmap[n83] = (byte)(prnBitmap[n83] & (byte)prnCurrentColor);
                            int n84 = n71 + 2 * n70;
                            prnBitmap[n84] = (byte)(prnBitmap[n84] & (byte)prnCurrentColor);
                            int n85 = n71 + n69 + 2 * n70;
                            prnBitmap[n85] = (byte)(prnBitmap[n85] & (byte)prnCurrentColor);
                            int n86 = n71 + 2 * n69 + 2 * n70;
                            prnBitmap[n86] = (byte)(prnBitmap[n86] & (byte)prnCurrentColor);
                            int n87 = n71 + 3 * n69 + 2 * n70;
                            prnBitmap[n87] = (byte)(prnBitmap[n87] & (byte)prnCurrentColor);
                            int n88 = n71 + 4 * n69 + 2 * n70;
                            prnBitmap[n88] = (byte)(prnBitmap[n88] & (byte)prnCurrentColor);
                            int n89 = n71 + 5 * n69 + 2 * n70;
                            prnBitmap[n89] = (byte)(prnBitmap[n89] & (byte)prnCurrentColor);
                            int n90 = n71 + 3 * n70;
                            prnBitmap[n90] = (byte)(prnBitmap[n90] & (byte)prnCurrentColor);
                            int n91 = n71 + n69 + 3 * n70;
                            prnBitmap[n91] = (byte)(prnBitmap[n91] & (byte)prnCurrentColor);
                            int n92 = n71 + 2 * n69 + 3 * n70;
                            prnBitmap[n92] = (byte)(prnBitmap[n92] & (byte)prnCurrentColor);
                            int n93 = n71 + 3 * n69 + 3 * n70;
                            prnBitmap[n93] = (byte)(prnBitmap[n93] & (byte)prnCurrentColor);
                            int n94 = n71 + 4 * n69 + 3 * n70;
                            prnBitmap[n94] = (byte)(prnBitmap[n94] & (byte)prnCurrentColor);
                            int n95 = n71 + 5 * n69 + 3 * n70;
                            prnBitmap[n95] = (byte)(prnBitmap[n95] & (byte)prnCurrentColor);
                            int n96 = n71 + 4 * n70;
                            prnBitmap[n96] = (byte)(prnBitmap[n96] & (byte)prnCurrentColor);
                            int n97 = n71 + n69 + 4 * n70;
                            prnBitmap[n97] = (byte)(prnBitmap[n97] & (byte)prnCurrentColor);
                            int n98 = n71 + 2 * n69 + 4 * n70;
                            prnBitmap[n98] = (byte)(prnBitmap[n98] & (byte)prnCurrentColor);
                            int n99 = n71 + 3 * n69 + 4 * n70;
                            prnBitmap[n99] = (byte)(prnBitmap[n99] & (byte)prnCurrentColor);
                            int n100 = n71 + 4 * n69 + 4 * n70;
                            prnBitmap[n100] = (byte)(prnBitmap[n100] & (byte)prnCurrentColor);
                            int n101 = n71 + 5 * n69 + 4 * n70;
                            prnBitmap[n101] = (byte)(prnBitmap[n101] & (byte)prnCurrentColor);
                            int n102 = n71 + 5 * n70;
                            prnBitmap[n102] = (byte)(prnBitmap[n102] & (byte)prnCurrentColor);
                            int n103 = n71 + n69 + 5 * n70;
                            prnBitmap[n103] = (byte)(prnBitmap[n103] & (byte)prnCurrentColor);
                            int n104 = n71 + 2 * n69 + 5 * n70;
                            prnBitmap[n104] = (byte)(prnBitmap[n104] & (byte)prnCurrentColor);
                            int n105 = n71 + 3 * n69 + 5 * n70;
                            prnBitmap[n105] = (byte)(prnBitmap[n105] & (byte)prnCurrentColor);
                            int n106 = n71 + 4 * n69 + 5 * n70;
                            prnBitmap[n106] = (byte)(prnBitmap[n106] & (byte)prnCurrentColor);
                            int n107 = n71 + 5 * n69 + 5 * n70;
                            prnBitmap[n107] = (byte)(prnBitmap[n107] & (byte)prnCurrentColor);
                        }
                        n71 += 6 * n69;
                    }
                    n68 += 6 * n70;
                }
            } else {
                for (int i = 0; i < n67; ++i) {
                    for (int j = 0; j < n66; ++j) {
                        if ((short)(n2 << (i & 0xF)) >= 0) continue;
                        PrinterPort.prnPaintDot(6 * j, 6 * i);
                        PrinterPort.prnPaintDot(6 * j + 1, 6 * i);
                        PrinterPort.prnPaintDot(6 * j + 2, 6 * i);
                        PrinterPort.prnPaintDot(6 * j + 3, 6 * i);
                        PrinterPort.prnPaintDot(6 * j + 4, 6 * i);
                        PrinterPort.prnPaintDot(6 * j + 5, 6 * i);
                        PrinterPort.prnPaintDot(6 * j, 6 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 1, 6 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 2, 6 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 3, 6 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 4, 6 * i + 1);
                        PrinterPort.prnPaintDot(6 * j + 5, 6 * i + 1);
                        PrinterPort.prnPaintDot(6 * j, 6 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 1, 6 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 2, 6 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 3, 6 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 4, 6 * i + 2);
                        PrinterPort.prnPaintDot(6 * j + 5, 6 * i + 2);
                        PrinterPort.prnPaintDot(6 * j, 6 * i + 3);
                        PrinterPort.prnPaintDot(6 * j + 1, 6 * i + 3);
                        PrinterPort.prnPaintDot(6 * j + 2, 6 * i + 3);
                        PrinterPort.prnPaintDot(6 * j + 3, 6 * i + 3);
                        PrinterPort.prnPaintDot(6 * j + 4, 6 * i + 3);
                        PrinterPort.prnPaintDot(6 * j + 5, 6 * i + 3);
                        PrinterPort.prnPaintDot(6 * j, 6 * i + 4);
                        PrinterPort.prnPaintDot(6 * j + 1, 6 * i + 4);
                        PrinterPort.prnPaintDot(6 * j + 2, 6 * i + 4);
                        PrinterPort.prnPaintDot(6 * j + 3, 6 * i + 4);
                        PrinterPort.prnPaintDot(6 * j + 4, 6 * i + 4);
                        PrinterPort.prnPaintDot(6 * j + 5, 6 * i + 4);
                        PrinterPort.prnPaintDot(6 * j, 6 * i + 5);
                        PrinterPort.prnPaintDot(6 * j + 1, 6 * i + 5);
                        PrinterPort.prnPaintDot(6 * j + 2, 6 * i + 5);
                        PrinterPort.prnPaintDot(6 * j + 3, 6 * i + 5);
                        PrinterPort.prnPaintDot(6 * j + 4, 6 * i + 5);
                        PrinterPort.prnPaintDot(6 * j + 5, 6 * i + 5);
                    }
                }
            }
            prnHeadX += 6 * n66;
        }
        prnPrinted = true;
        if (prnCanvas != null) {
            prnCanvas.repaint();
        }
    }

    public static void prnSetUnderlineMode(boolean bl) {
        prnUnderlineMode = bl;
    }

    public static void prnHorizontalMove(int n) {
        int n2;
        if (prnCurrentPaper == null) {
            PrinterPort.prnFeedPaper();
        }
        if (-1440 <= n && n <= 1440 && prnMarginLeftX <= (n2 = prnHeadX + 2 * n) && n2 < prnMarginRightX) {
            prnHeadX = n2;
        }
    }

    public static void prnResetSettings() {
        int n;
        PrinterPort.prnEjectPaper();
        prnMarginLeftX = 0;
        prnMarginRightX = 2879;
        prnMarginBottomHeight = 0;
        prnDefaultLineHeight = 60;
        prnLineHeight = 60;
        prnCharacterType = 0;
        prnHiraganaMode = false;
        prnScriptMode = 0;
        prnStrongMode = false;
        prnUnderlineMode = false;
        prnCharacterStyle = 0;
        prnKanjiMode = false;
        if (prnGaijiData != null) {
            Arrays.fill(prnGaijiData, (byte)0);
        }
        prnVerticalWritingMode = false;
        prnFullWidthLeftSpace = 2;
        prnFullWidthRightSpace = 6;
        prnHalfWidthLeftSpace = 0;
        prnHalfWidthRightSpace = 4;
        prnHorizontalDoubleSizeMode = false;
        prnVerticalDoubleSizeMode = false;
        prnKanjiHorizontalDoubleSizeMode = false;
        for (n = 0; n < 16; ++n) {
            PrinterPort.prnHorizontalTabAnchor[n] = 288 * (1 + n);
        }
        for (n = 0; n < 128; ++n) {
            PrinterPort.prnVerticalTabAnchor[n] = 0;
        }
        prnColorMode = false;
        prnFullWidthFont = (prnDIPSW & 0x80) == 0 ? 0 : 1;
        prnHalfWidthFont = prnFullWidthFont;
        prnCurrentColor = prnSingleColor;
        prnCommandLength = 1;
        prnCommandPointer = 0;
    }

    public static void prnSetHalfWidthFont(int n) {
        if (0 <= n && n <= 1) {
            prnHalfWidthFont = n;
        }
    }

    public static void prnSenseOutOfPaper(boolean bl) {
    }

    public static void prnSetCharacterStyle(int n) {
        if (0 <= n && n <= 3) {
            prnCharacterStyle = n;
        }
    }

    public static void prnSetScriptMode(int n) {
        if (0 <= n && n <= 2) {
            prnScriptMode = n;
        }
    }

    public static void prnSetVerticalWritingMode(boolean bl) {
        prnVerticalWritingMode = bl;
    }

    public static void prnSetFullWidthLeftRightSpace(int n, int n2) {
        prnFullWidthLeftSpace = n;
        prnFullWidthRightSpace = n2;
    }

    public static void prnSetHalfWidthLeftRightSpace(int n, int n2) {
        prnHalfWidthLeftSpace = n;
        prnHalfWidthRightSpace = n2;
    }

    public static void prnSetFullWidthFont(int n) {
        if (0 <= n && n <= 1) {
            prnFullWidthFont = n;
        }
    }

    public static void prnSetKanjiHorizontalDoubleSizeMode(boolean bl) {
        prnKanjiHorizontalDoubleSizeMode = bl;
    }

    public static int prnCheckRect(int n, int n2) {
        int n3 = prnAliveLeftX + prnHeadX;
        int n4 = prnAliveTopY + prnHeadY;
        int n5 = n3 + n - 1;
        int n6 = n4 + n2 - 1;
        int n7 = prnM11 * n3 + prnM12 * n4 + prnM13;
        int n8 = prnM21 * n3 + prnM22 * n4 + prnM23;
        int n9 = prnM11 * n5 + prnM12 * n6 + prnM13;
        int n10 = prnM21 * n5 + prnM22 * n6 + prnM23;
        return 0 <= n7 && n7 < prnRotatedWidthDot && 0 <= n8 && n8 < prnRotatedHeightDot && 0 <= n9 && n9 < prnRotatedWidthDot && 0 <= n10 && n10 < prnRotatedHeightDot ? n7 + prnRotatedWidthDot * n8 : -1;
    }

    public static void prnPaintDot(int n, int n2) {
        int n3 = prnAliveLeftX + prnHeadX + n;
        int n4 = prnAliveTopY + prnHeadY + n2;
        int n5 = prnM11 * n3 + prnM12 * n4 + prnM13;
        int n6 = prnM21 * n3 + prnM22 * n4 + prnM23;
        if (0 <= n5 && n5 < prnRotatedWidthDot && 0 <= n6 && n6 < prnRotatedHeightDot) {
            int n7 = n5 + prnRotatedWidthDot * n6;
            prnBitmap[n7] = (byte)(prnBitmap[n7] & (byte)prnCurrentColor);
        }
    }

    public static boolean prnSave() {
        String string;
        File file;
        int n = prnSaveName.lastIndexOf(46);
        if (n < 0) {
            prnSaveName = prnSaveName + ".png";
            n = prnSaveName.lastIndexOf(46);
        }
        if ((file = new File(string = prnSavePath + File.separator + prnSaveName)).isFile()) {
            if (!file.canWrite()) {
                XEiJ.pnlExitFullScreen(true);
                JOptionPane.showMessageDialog(null, string + (Multilingual.mlnJapanese ? "\n\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\u4e0a\u66f8\u304d\u3067\u304d\u307e\u305b\u3093\u3002" : "\nalreay exists. You cannot overwrite it."));
                return false;
            }
            XEiJ.pnlExitFullScreen(true);
            if (0 != JOptionPane.showConfirmDialog(null, string + (Multilingual.mlnJapanese ? "\n\u306f\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\u4e0a\u66f8\u304d\u3057\u307e\u3059\u304b\uff1f" : "\nalreay exists. Do you want to overwrite it?"), Multilingual.mlnJapanese ? "\u30d5\u30a1\u30a4\u30eb\u306e\u4e0a\u66f8\u304d\u306e\u78ba\u8a8d" : "Confirmation of overwriting file", 0, -1)) {
                return false;
            }
        }
        Iterator<ImageWriter> iterator = ImageIO.getImageWritersBySuffix(prnSaveName.substring(n + 1));
        while (iterator.hasNext()) {
            ImageWriter imageWriter = iterator.next();
            ImageWriteParam imageWriteParam = imageWriter.getDefaultWriteParam();
            IIOMetadata iIOMetadata = imageWriter.getDefaultImageMetadata(ImageTypeSpecifier.createFromBufferedImageType(prnImage.getType()), imageWriteParam);
            if (!iIOMetadata.isStandardMetadataFormatSupported()) continue;
            IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("javax_imageio_1.0");
            IIOMetadataNode iIOMetadataNode2 = new IIOMetadataNode("Dimension");
            IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("HorizontalPixelSize");
            IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode("VerticalPixelSize");
            iIOMetadataNode3.setAttribute("value", String.valueOf(14.173228346456694));
            iIOMetadataNode4.setAttribute("value", String.valueOf(14.173228346456694));
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode2.appendChild(iIOMetadataNode4);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            try {
                iIOMetadata.mergeTree("javax_imageio_1.0", iIOMetadataNode);
            }
            catch (IIOInvalidTreeException iIOInvalidTreeException) {
                continue;
            }
            file.delete();
            try (ImageOutputStream imageOutputStream = ImageIO.createImageOutputStream(file);){
                imageWriter.setOutput(imageOutputStream);
                imageWriter.write(iIOMetadata, new IIOImage(prnImage, null, iIOMetadata), imageWriteParam);
            }
            catch (IOException iOException) {
                continue;
            }
            return true;
        }
        XEiJ.pnlExitFullScreen(true);
        JOptionPane.showMessageDialog(null, string + (Multilingual.mlnJapanese ? "\n\u3092\u66f4\u65b0\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f\u3002" : "\nwas not updated"));
        return false;
    }

    static {
        PRN_MAX_WIDTH_MM = (int)Math.floor(1219.2);
        PRN_MAX_HEIGHT_MM = (int)Math.floor(1676.4);
        prnGaijiData = null;
        prnHorizontalTabAnchor = new int[16];
        prnVerticalTabAnchor = new int[128];
        prnCommandBuffer = new byte[103684];
        FNT_GOTHIC_FAMILIES = new String[]{"\uff2d\uff33 \u30b4\u30b7\u30c3\u30af", "MS Gothic", "\u30d2\u30e9\u30ae\u30ce\u89d2\u30b4 ProN W3", "Hiragino Kaku Gothic ProN", "\u30d2\u30e9\u30ae\u30ce\u89d2\u30b4 Pro W3", "Hiragino Kaku Gothic Pro", "Osaka\uff0d\u7b49\u5e45", "Osaka-Mono", "VL \u30b4\u30b7\u30c3\u30af", "VL Gothic", "Takao\u30b4\u30b7\u30c3\u30af", "TakaoGothic", "IPA\u30b4\u30b7\u30c3\u30af", "IPAGothic"};
        FNT_MINCHO_FAMILIES = new String[]{"\uff2d\uff33 \u660e\u671d", "MS Mincho", "\u30d2\u30e9\u30ae\u30ce\u660e\u671d ProN W3", "Hiragino Mincho ProN", "\u30d2\u30e9\u30ae\u30ce\u660e\u671d Pro W3", "Hiragino Mincho Pro", "\u3055\u3056\u306a\u307f\u660e\u671d", "Sazanami Mincho", "Takao\u660e\u671d", "TakaoMincho", "IPA\u660e\u671d", "IPAMincho"};
        PRN_DOUBLE_4BIT = new byte[]{0, 3, 12, 15, 48, 51, 60, 63, -64, -61, -52, -49, -16, -13, -4, -1};
    }

    public static class PrinterAdapterTicker
    extends TickerQueue.Ticker {
        @Override
        protected void tick() {
            PrinterPort.prnAdapterTaskLauncher();
        }
    }

    public static class PrinterAdapterTask
    extends TimerTask {
        private byte[] buffer;

        public PrinterAdapterTask(byte[] byArray) {
            this.buffer = byArray;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.buffer.length; ++i) {
                PrinterPort.prnOutput(this.buffer[i]);
            }
        }
    }

    public static class Paper {
        public String sizeEn;
        public String sizeJa;
        public String orientationEn;
        public String orientationJa;
        public int paperWidthMm;
        public int paperHeightMm;
        public int paperWidthDot;
        public int paperHeightDot;
        public int initialDeadTopMm;
        public int initialDeadLeftMm;
        public int initialDeadRightMm;
        public int initialDeadBottomMm;
        public String nameEn;
        public String nameJa;

        public Paper(int n, int n2, int n3) {
            int n4;
            int n5;
            if (n == 0) {
                n5 = (int)Math.floor(1000.0 / Math.pow(2.0, (double)(2 * n2 + 1) * 0.25) + 0.2);
                n4 = (int)Math.floor(1000.0 / Math.pow(2.0, (double)(2 * n2 - 1) * 0.25) + 0.2);
                this.initialDeadTopMm = 11;
                this.initialDeadLeftMm = 14;
                this.initialDeadRightMm = 14;
                this.initialDeadBottomMm = 11;
                this.sizeEn = n2 < 0 ? (1 << -n2) + "A0" : "A" + n2;
                this.sizeJa = this.sizeEn;
            } else if (n == 1) {
                n5 = (int)Math.floor(1000.0 * Math.sqrt(3.0) / Math.pow(2.0, (double)(2 * n2 + 3) * 0.25) + 0.2);
                n4 = (int)Math.floor(1000.0 * Math.sqrt(3.0) / Math.pow(2.0, (double)(2 * n2 + 1) * 0.25) + 0.2);
                this.initialDeadTopMm = 11;
                this.initialDeadLeftMm = 24;
                this.initialDeadRightMm = 24;
                this.initialDeadBottomMm = 11;
                this.sizeEn = n2 < 0 ? (1 << -n2) + "B0" : "B" + n2;
                this.sizeJa = this.sizeEn;
            } else {
                n5 = 100;
                n4 = 148;
                this.initialDeadTopMm = 10;
                this.initialDeadLeftMm = 3;
                this.initialDeadRightMm = 3;
                this.initialDeadBottomMm = 10;
                this.sizeEn = "Postcard";
                this.sizeJa = "\u306f\u304c\u304d";
            }
            if (n3 == 0) {
                this.paperWidthMm = n5;
                this.paperHeightMm = n4;
                this.orientationEn = "portrait";
                this.orientationJa = "\u7e26";
            } else {
                this.paperWidthMm = n4;
                this.paperHeightMm = n5;
                this.orientationEn = "landscape";
                this.orientationJa = "\u6a2a";
            }
            this.paperWidthDot = (int)Math.floor((double)this.paperWidthMm * 14.173228346456694 + 0.5);
            this.paperHeightDot = (int)Math.floor((double)this.paperHeightMm * 14.173228346456694 + 0.5);
            this.nameEn = this.sizeEn + " " + this.orientationEn + " " + this.paperWidthMm + "x" + this.paperHeightMm;
            this.nameJa = this.sizeJa + " " + this.orientationJa + " " + this.paperWidthMm + "x" + this.paperHeightMm;
        }
    }
}

