/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import xeij.CRTC;
import xeij.Keyboard;
import xeij.M68kException;
import xeij.MemoryMappedDevice;
import xeij.MercuryUnit;
import xeij.TickerQueue;
import xeij.XEiJ;

public class MC68901 {
    public static final boolean MFP_DELAYED_INTERRUPT = true;
    public static final int MFP_GPIP_DATA = 15237121;
    public static final int MFP_AER = 15237123;
    public static final int MFP_DDR = 15237125;
    public static final int MFP_IERA = 15237127;
    public static final int MFP_IERB = 15237129;
    public static final int MFP_IPRA = 15237131;
    public static final int MFP_IPRB = 15237133;
    public static final int MFP_ISRA = 15237135;
    public static final int MFP_ISRB = 15237137;
    public static final int MFP_IMRA = 15237139;
    public static final int MFP_IMRB = 15237141;
    public static final int MFP_VECTOR = 15237143;
    public static final int MFP_TACR = 15237145;
    public static final int MFP_TBCR = 15237147;
    public static final int MFP_TCDCR = 15237149;
    public static final int MFP_TADR = 15237151;
    public static final int MFP_TBDR = 15237153;
    public static final int MFP_TCDR = 15237155;
    public static final int MFP_TDDR = 15237157;
    public static final int MFP_SYNC_CHAR = 15237159;
    public static final int MFP_UCR = 15237161;
    public static final int MFP_RSR = 15237163;
    public static final int MFP_TSR = 15237165;
    public static final int MFP_UDR = 15237167;
    public static final int MFP_GPIP_ALARM_LEVEL = 0;
    public static final int MFP_GPIP_EXPWON_LEVEL = 1;
    public static final int MFP_GPIP_POWER_LEVEL = 2;
    public static final int MFP_GPIP_OPMIRQ_LEVEL = 3;
    public static final int MFP_GPIP_VDISP_LEVEL = 4;
    public static final int MFP_GPIP_RINT_LEVEL = 6;
    public static final int MFP_GPIP_HSYNC_LEVEL = 7;
    public static final int MFP_GPIP_ALARM_MASK = 1;
    public static final int MFP_GPIP_EXPWON_MASK = 2;
    public static final int MFP_GPIP_POWER_MASK = 4;
    public static final int MFP_GPIP_OPMIRQ_MASK = 8;
    public static final int MFP_GPIP_VDISP_MASK = 16;
    public static final int MFP_GPIP_RINT_MASK = 64;
    public static final int MFP_GPIP_HSYNC_MASK = 128;
    public static final int MFP_ALARM_LEVEL = 0;
    public static final int MFP_EXPWON_LEVEL = 1;
    public static final int MFP_POWER_LEVEL = 2;
    public static final int MFP_OPMIRQ_LEVEL = 3;
    public static final int MFP_TIMER_D_LEVEL = 4;
    public static final int MFP_TIMER_C_LEVEL = 5;
    public static final int MFP_VDISP_LEVEL = 6;
    public static final int MFP_TIMER_B_LEVEL = 8;
    public static final int MFP_OUTPUT_ERROR_LEVEL = 9;
    public static final int MFP_OUTPUT_EMPTY_LEVEL = 10;
    public static final int MFP_INPUT_ERROR_LEVEL = 11;
    public static final int MFP_INPUT_FULL_LEVEL = 12;
    public static final int MFP_TIMER_A_LEVEL = 13;
    public static final int MFP_RINT_LEVEL = 14;
    public static final int MFP_HSYNC_LEVEL = 15;
    public static final int MFP_ALARM_MASK = 1;
    public static final int MFP_EXPWON_MASK = 2;
    public static final int MFP_POWER_MASK = 4;
    public static final int MFP_OPMIRQ_MASK = 8;
    public static final int MFP_TIMER_D_MASK = 16;
    public static final int MFP_TIMER_C_MASK = 32;
    public static final int MFP_VDISP_MASK = 64;
    public static final int MFP_TIMER_B_MASK = 256;
    public static final int MFP_OUTPUT_ERROR_MASK = 512;
    public static final int MFP_OUTPUT_EMPTY_MASK = 1024;
    public static final int MFP_INPUT_ERROR_MASK = 2048;
    public static final int MFP_INPUT_FULL_MASK = 4096;
    public static final int MFP_TIMER_A_MASK = 8192;
    public static final int MFP_RINT_MASK = 16384;
    public static final int MFP_HSYNC_MASK = 32768;
    public static final long MFP_OSC_FREQ = 4000000L;
    public static final long[] MFP_DELTA = new long[]{Long.MAX_VALUE, 1000000L, 2500000L, 4000000L, 12500000L, 16000000L, 25000000L, 50000000L};
    public static final int MFP_UDR_QUEUE_BITS = 4;
    public static final int MFP_UDR_QUEUE_SIZE = 16;
    public static final int MFP_UDR_QUEUE_MASK = 15;
    public static int mfpGpipAlarm;
    public static int mfpGpipExpwon;
    public static int mfpGpipPower;
    public static int mfpGpipOpmirq;
    public static int mfpGpipVdisp;
    public static int mfpGpipRint;
    public static int mfpGpipHsync;
    public static int mfpAer;
    public static int mfpIer;
    public static int mfpImr;
    public static int mfpVectorHigh;
    public static int mfpTaPrescale;
    public static int mfpTbPrescale;
    public static int mfpTcPrescale;
    public static int mfpTdPrescale;
    public static boolean mfpTaEventcount;
    public static boolean mfpTbEventcount;
    public static int mfpTaInitial;
    public static int mfpTbInitial;
    public static int mfpTcInitial;
    public static int mfpTdInitial;
    public static int mfpTaCurrent;
    public static int mfpTbCurrent;
    public static int mfpTcCurrent;
    public static int mfpTdCurrent;
    public static boolean mfpTbKeyboardOn;
    public static int mfpUCR;
    public static int mfpRSR;
    public static int mfpTSR;
    public static long mfpTSRBufferFullTime;
    public static long mfpTSRBufferFullEnd;
    public static final int[] mfpInnerRequest;
    public static final int[] mfpInnerAcknowledged;
    public static final boolean[] mfpInnerInService;
    public static int mfpInnerLevel;
    public static long mfpTaStart;
    public static long mfpTbStart;
    public static long mfpTcStart;
    public static long mfpTdStart;
    public static long mfpTaDelta;
    public static long mfpTbDelta;
    public static long mfpTcDelta;
    public static long mfpTdDelta;
    public static long mfpTaClock;
    public static long mfpTbClock;
    public static long mfpTcClock;
    public static long mfpTdClock;
    public static final int[] mfpUdrQueueArray;
    public static volatile int mfpUdrQueueRead;
    public static volatile int mfpUdrQueueWrite;
    public static final TickerQueue.Ticker mfpTaTicker;
    public static final TickerQueue.Ticker mfpTbTicker;
    public static final TickerQueue.Ticker mfpTcTicker;
    public static final TickerQueue.Ticker mfpTdTicker;
    public static final TickerQueue.Ticker mfpTkTicker;
    public static final boolean MFP_KBD_ON = false;
    public static final int MFP_KBD_SIZE = 256;
    public static final int MFP_KBD_MASK = 255;
    public static final int[] mfpKbdBuffer;
    public static volatile int mfpKbdReadPointer;
    public static volatile int mfpKbdWritePointer;
    public static int mfpKbdLastData;
    public static long mfpTkClock;
    public static long mfpTkTime;

    public static void mfpInit() {
        for (int i = 0; i < 16; ++i) {
            MC68901.mfpUdrQueueArray[i] = 0;
        }
        mfpUdrQueueRead = 0;
        mfpUdrQueueWrite = 0;
        MC68901.mfpReset();
    }

    public static void mfpReset() {
        mfpGpipAlarm = 0;
        mfpGpipExpwon = 2;
        mfpGpipPower = 0;
        mfpGpipOpmirq = 8;
        mfpGpipVdisp = 0;
        mfpGpipRint = 64;
        mfpGpipHsync = 0;
        mfpAer = 0;
        mfpIer = 0;
        for (int i = 0; i < 16; ++i) {
            MC68901.mfpInnerRequest[i] = 0;
            MC68901.mfpInnerAcknowledged[i] = 0;
            MC68901.mfpInnerInService[i] = false;
        }
        mfpImr = 0;
        mfpVectorHigh = 0;
        mfpTaPrescale = 0;
        mfpTbPrescale = 0;
        mfpTcPrescale = 0;
        mfpTdPrescale = 0;
        mfpTaEventcount = false;
        mfpTbEventcount = false;
        mfpTaInitial = 256;
        mfpTbInitial = 256;
        mfpTcInitial = 256;
        mfpTdInitial = 256;
        mfpTaCurrent = 0;
        mfpTbCurrent = 0;
        mfpTcCurrent = 0;
        mfpTdCurrent = 0;
        mfpTaStart = 0L;
        mfpTbStart = 0L;
        mfpTcStart = 0L;
        mfpTdStart = 0L;
        mfpTaClock = Long.MAX_VALUE;
        mfpTbClock = Long.MAX_VALUE;
        mfpTcClock = Long.MAX_VALUE;
        mfpTdClock = Long.MAX_VALUE;
        mfpUCR = 136;
        mfpRSR = 1;
        mfpTSR = 1;
        mfpTSRBufferFullTime = 0L;
        mfpTSRBufferFullEnd = 0L;
        TickerQueue.tkqRemove(mfpTaTicker);
        TickerQueue.tkqRemove(mfpTbTicker);
        TickerQueue.tkqRemove(mfpTcTicker);
        TickerQueue.tkqRemove(mfpTdTicker);
        TickerQueue.tkqRemove(mfpTkTicker);
    }

    public static int mfpAcknowledge() {
        for (int i = 15; i >= 0; --i) {
            int n;
            if ((mfpImr & 1 << i) == 0 || mfpInnerAcknowledged[i] == (n = mfpInnerRequest[i])) continue;
            MC68901.mfpInnerAcknowledged[i] = n;
            mfpInnerLevel = i;
            MC68901.mfpInnerInService[MC68901.mfpInnerLevel] = true;
            return mfpVectorHigh + i;
        }
        return 0;
    }

    public static void mfpDone() {
        MC68901.mfpInnerInService[MC68901.mfpInnerLevel] = false;
        for (int i = 15; i >= 0; --i) {
            if ((mfpImr & 1 << i) == 0 || mfpInnerAcknowledged[i] == mfpInnerRequest[i]) continue;
            XEiJ.mpuDIRR |= 2;
            return;
        }
    }

    public static void mfpKeyboardInput(int n) {
        if (!mfpTbKeyboardOn) {
            return;
        }
        n &= 0xFF;
        if (mfpUdrQueueWrite + 1 != mfpUdrQueueRead) {
            MC68901.mfpUdrQueueArray[++MC68901.mfpUdrQueueWrite & 0xF] = n;
            if ((mfpIer & 0x1000) != 0) {
                mfpInnerRequest[12] = mfpInnerRequest[12] + 1;
                if ((mfpImr & 0x1000) != 0) {
                    XEiJ.mpuDIRR |= 2;
                }
            }
        }
    }

    public static void mfpAlarmRise() {
        if (mfpGpipAlarm == 0) {
            mfpGpipAlarm = 1;
            if ((mfpAer & 1) != 0 && (mfpIer & 1) != 0) {
                mfpInnerRequest[0] = mfpInnerRequest[0] + 1;
                if ((mfpImr & 1) != 0) {
                    XEiJ.mpuDIRR |= 2;
                }
            }
        }
    }

    public static void mfpAlarmFall() {
        if (mfpGpipAlarm != 0) {
            mfpGpipAlarm = 0;
            if ((mfpAer & 1) == 0 && (mfpIer & 1) != 0) {
                mfpInnerRequest[0] = mfpInnerRequest[0] + 1;
                if ((mfpImr & 1) != 0) {
                    XEiJ.mpuDIRR |= 2;
                }
            }
        }
    }

    public static void mfpExpwonRise() {
        if (mfpGpipExpwon == 0) {
            mfpGpipExpwon = 2;
            if ((mfpAer & 2) != 0 && (mfpIer & 2) != 0) {
                mfpInnerRequest[1] = mfpInnerRequest[1] + 1;
                if ((mfpImr & 2) != 0) {
                    XEiJ.mpuDIRR |= 2;
                }
            }
        }
    }

    public static void mfpExpwonFall() {
        if (mfpGpipExpwon != 0) {
            mfpGpipExpwon = 0;
            if ((mfpAer & 2) == 0 && (mfpIer & 2) != 0) {
                mfpInnerRequest[1] = mfpInnerRequest[1] + 1;
                if ((mfpImr & 2) != 0) {
                    XEiJ.mpuDIRR |= 2;
                }
            }
        }
    }

    public static void mfpPowerRise() {
        if (mfpGpipPower == 0) {
            mfpGpipPower = 4;
            if ((mfpAer & 4) != 0 && (mfpIer & 4) != 0) {
                mfpInnerRequest[2] = mfpInnerRequest[2] + 1;
                if ((mfpImr & 4) != 0) {
                    XEiJ.mpuDIRR |= 2;
                }
            }
        }
    }

    public static void mfpPowerFall() {
        if (mfpGpipPower != 0) {
            mfpGpipPower = 0;
            if ((mfpAer & 4) == 0 && (mfpIer & 4) != 0) {
                mfpInnerRequest[2] = mfpInnerRequest[2] + 1;
                if ((mfpImr & 4) != 0) {
                    XEiJ.mpuDIRR |= 2;
                }
            }
        }
    }

    public static void mfpOpmirqRise() {
        if (mfpGpipOpmirq == 0) {
            mfpGpipOpmirq = 8;
            if ((mfpAer & 8) != 0 && (mfpIer & 8) != 0) {
                mfpInnerRequest[3] = mfpInnerRequest[3] + 1;
                if ((mfpImr & 8) != 0) {
                    XEiJ.mpuDIRR |= 2;
                }
            }
        }
    }

    public static void mfpOpmirqFall() {
        if (mfpGpipOpmirq != 0) {
            mfpGpipOpmirq = 0;
            if ((mfpAer & 8) == 0 && (mfpIer & 8) != 0) {
                mfpInnerRequest[3] = mfpInnerRequest[3] + 1;
                if ((mfpImr & 8) != 0) {
                    XEiJ.mpuDIRR |= 2;
                }
            }
        }
    }

    public static void mfpVdispRise() {
        mfpGpipVdisp = 16;
        if ((mfpAer & 0x10) != 0) {
            if ((mfpIer & 0x40) != 0) {
                mfpInnerRequest[6] = mfpInnerRequest[6] + 1;
                if ((mfpImr & 0x40) != 0) {
                    XEiJ.mpuDIRR |= 2;
                }
            }
            if (mfpTaEventcount && --mfpTaCurrent <= 0) {
                mfpTaCurrent = mfpTaInitial;
                if ((mfpIer & 0x2000) != 0) {
                    mfpInnerRequest[13] = mfpInnerRequest[13] + 1;
                    if ((mfpImr & 0x2000) != 0) {
                        XEiJ.mpuDIRR |= 2;
                    }
                }
            }
        }
    }

    public static void mfpVdispFall() {
        mfpGpipVdisp = 0;
        if ((mfpAer & 0x10) == 0) {
            if ((mfpIer & 0x40) != 0) {
                mfpInnerRequest[6] = mfpInnerRequest[6] + 1;
                if ((mfpImr & 0x40) != 0) {
                    XEiJ.mpuDIRR |= 2;
                }
            }
            if (mfpTaEventcount && --mfpTaCurrent <= 0) {
                mfpTaCurrent = mfpTaInitial;
                if ((mfpIer & 0x2000) != 0) {
                    mfpInnerRequest[13] = mfpInnerRequest[13] + 1;
                    if ((mfpImr & 0x2000) != 0) {
                        XEiJ.mpuDIRR |= 2;
                    }
                }
            }
        }
    }

    public static void mfpRintRise() {
        mfpGpipRint = 64;
        if ((mfpAer & 0x40) != 0 && (mfpIer & 0x4000) != 0) {
            mfpInnerRequest[14] = mfpInnerRequest[14] + 1;
            if ((mfpImr & 0x4000) != 0) {
                XEiJ.mpuDIRR |= 2;
            }
        }
    }

    public static void mfpRintFall() {
        mfpGpipRint = 0;
        if ((mfpAer & 0x40) == 0 && (mfpIer & 0x4000) != 0) {
            mfpInnerRequest[14] = mfpInnerRequest[14] + 1;
            if ((mfpImr & 0x4000) != 0) {
                XEiJ.mpuDIRR |= 2;
            }
        }
    }

    public static void mfpHsyncRise() {
        mfpGpipHsync = 128;
        if ((mfpAer & 0x80) != 0 && (mfpIer & 0x8000) != 0) {
            mfpInnerRequest[15] = mfpInnerRequest[15] + 1;
            if ((mfpImr & 0x8000) != 0) {
                XEiJ.mpuDIRR |= 2;
            }
        }
        if (MercuryUnit.mu4OnPositive && CRTC.crtR05VSyncEndCurr <= CRTC.crtRasterNumber) {
            MercuryUnit.mu4HsyncStart(CRTC.crtClock);
        }
    }

    public static void mfpHsyncFall() {
        mfpGpipHsync = 0;
        if ((mfpAer & 0x80) == 0 && (mfpIer & 0x8000) != 0) {
            mfpInnerRequest[15] = mfpInnerRequest[15] + 1;
            if ((mfpImr & 0x8000) != 0) {
                XEiJ.mpuDIRR |= 2;
            }
        }
        if (MercuryUnit.mu4OnNegative && CRTC.crtRasterNumber < CRTC.crtR05VSyncEndCurr) {
            MercuryUnit.mu4HsyncStart(CRTC.crtClock);
        }
    }

    public static void mfpKbdInput(int n, boolean bl) {
        if (!mfpTbKeyboardOn) {
            return;
        }
        int n2 = mfpKbdWritePointer;
        if (n2 + 1 != mfpKbdReadPointer) {
            MC68901.mfpKbdBuffer[n2 & 0xFF] = (bl ? 65536 : 0) | n;
            mfpKbdWritePointer = n2 + 1;
            if ((mfpIer & 0x1000) != 0) {
                mfpInnerRequest[12] = mfpInnerRequest[12] + 1;
                if ((mfpImr & 0x1000) != 0) {
                    XEiJ.mpuDIRR |= 2;
                }
            }
        }
    }

    public static int mfpKbdReadData() {
        int n = mfpKbdReadPointer;
        int n2 = mfpKbdWritePointer;
        if (n != n2) {
            int n3 = mfpKbdBuffer[n & 0xFF];
            if (n + 1 != n2 && n3 < 0) {
                mfpKbdReadPointer = ++n;
                n3 = mfpKbdBuffer[n & 0xFF];
            }
            mfpKbdLastData = (char)n3;
            if (n + 1 != n2) {
                mfpKbdReadPointer = n + 1;
                if ((mfpIer & 0x1000) != 0) {
                    mfpInnerRequest[12] = mfpInnerRequest[12] + 1;
                    if ((mfpImr & 0x1000) != 0) {
                        XEiJ.mpuDIRR |= 2;
                    }
                }
            } else if (n3 >> 16 == 0) {
                mfpKbdReadPointer = n + 1;
            } else if (n3 >> 16 == 1) {
                MC68901.mfpKbdBuffer[n & 0xFF] = 0xFFFF0000 | n3;
                if (MC68901.mfpTkTicker.time == Long.MAX_VALUE && (mfpIer & 0x1000) != 0) {
                    mfpTkClock = XEiJ.mpuClockTime + 1000000000L * (long)Keyboard.kbdRepeatDelay;
                    TickerQueue.tkqAdd(mfpTkTicker, mfpTkClock);
                    mfpTkTime = System.currentTimeMillis() + (long)Keyboard.kbdRepeatDelay;
                }
            } else if (MC68901.mfpTkTicker.time == Long.MAX_VALUE && (mfpIer & 0x1000) != 0) {
                mfpTkClock = XEiJ.mpuClockTime + 1000000000L * (long)Keyboard.kbdRepeatInterval;
                TickerQueue.tkqAdd(mfpTkTicker, mfpTkClock);
                mfpTkTime = System.currentTimeMillis() + (long)Keyboard.kbdRepeatInterval;
            }
        }
        return mfpKbdLastData;
    }

    public static int mfpPeekByte(int n) {
        try {
            return (n & 0xFF803F) == 15237167 ? mfpUdrQueueArray[mfpUdrQueueRead & 0xF] : MC68901.mfpReadByte(n);
        }
        catch (M68kException m68kException) {
            return 0;
        }
    }

    public static int mfpReadByte(int n) throws M68kException {
        XEiJ.mpuClockTime += XEiJ.busWaitTime.mfp;
        switch (n & 0xFF803F) {
            case 15237121: {
                return mfpGpipHsync | mfpGpipRint | 0x20 | mfpGpipVdisp | mfpGpipOpmirq | mfpGpipPower | mfpGpipExpwon | mfpGpipAlarm;
            }
            case 15237123: {
                return mfpAer;
            }
            case 15237125: {
                return 0;
            }
            case 15237127: {
                return mfpIer >>> 8;
            }
            case 15237129: {
                return mfpIer & 0xFF;
            }
            case 15237131: {
                return (mfpInnerRequest[15] != mfpInnerAcknowledged[15] ? 128 : 0) | (mfpInnerRequest[14] != mfpInnerAcknowledged[14] ? 64 : 0) | (mfpInnerRequest[13] != mfpInnerAcknowledged[13] ? 32 : 0) | (mfpInnerRequest[12] != mfpInnerAcknowledged[12] ? 16 : 0) | (mfpInnerRequest[11] != mfpInnerAcknowledged[11] ? 8 : 0) | (mfpInnerRequest[10] != mfpInnerAcknowledged[10] ? 4 : 0) | (mfpInnerRequest[9] != mfpInnerAcknowledged[9] ? 2 : 0) | (mfpInnerRequest[8] != mfpInnerAcknowledged[8] ? 1 : 0);
            }
            case 15237133: {
                return (mfpInnerRequest[7] != mfpInnerAcknowledged[7] ? 128 : 0) | (mfpInnerRequest[6] != mfpInnerAcknowledged[6] ? 64 : 0) | (mfpInnerRequest[5] != mfpInnerAcknowledged[5] ? 32 : 0) | (mfpInnerRequest[4] != mfpInnerAcknowledged[4] ? 16 : 0) | (mfpInnerRequest[3] != mfpInnerAcknowledged[3] ? 8 : 0) | (mfpInnerRequest[2] != mfpInnerAcknowledged[2] ? 4 : 0) | (mfpInnerRequest[1] != mfpInnerAcknowledged[1] ? 2 : 0) | (mfpInnerRequest[0] != mfpInnerAcknowledged[0] ? 1 : 0);
            }
            case 15237135: {
                return (mfpInnerInService[15] ? 128 : 0) | (mfpInnerInService[14] ? 64 : 0) | (mfpInnerInService[13] ? 32 : 0) | (mfpInnerInService[12] ? 16 : 0) | (mfpInnerInService[11] ? 8 : 0) | (mfpInnerInService[10] ? 4 : 0) | (mfpInnerInService[9] ? 2 : 0) | (mfpInnerInService[8] ? 1 : 0);
            }
            case 15237137: {
                return (mfpInnerInService[7] ? 128 : 0) | (mfpInnerInService[6] ? 64 : 0) | (mfpInnerInService[5] ? 32 : 0) | (mfpInnerInService[4] ? 16 : 0) | (mfpInnerInService[3] ? 8 : 0) | (mfpInnerInService[2] ? 4 : 0) | (mfpInnerInService[1] ? 2 : 0) | (mfpInnerInService[0] ? 1 : 0);
            }
            case 15237139: {
                return mfpImr >>> 8;
            }
            case 15237141: {
                return mfpImr & 0xFF;
            }
            case 15237143: {
                return mfpVectorHigh;
            }
            case 15237145: {
                return (mfpTaEventcount ? 8 : 0) | mfpTaPrescale;
            }
            case 15237147: {
                return (mfpTbEventcount ? 8 : 0) | mfpTbPrescale;
            }
            case 15237149: {
                return mfpTcPrescale << 4 | mfpTdPrescale;
            }
            case 15237151: {
                if (mfpTaEventcount || mfpTaPrescale == 0) {
                    return mfpTaCurrent & 0xFF;
                }
                return mfpTaInitial - (int)(Math.floor((double)(XEiJ.mpuClockTime - mfpTaStart) / (double)mfpTaDelta) % (double)mfpTaInitial) & 0xFF;
            }
            case 15237153: {
                if (mfpTbEventcount || mfpTbPrescale == 0) {
                    return mfpTbCurrent & 0xFF;
                }
                return mfpTbInitial - (int)(Math.floor((double)(XEiJ.mpuClockTime - mfpTbStart) / (double)mfpTbDelta) % (double)mfpTbInitial) & 0xFF;
            }
            case 15237155: {
                if (mfpTcPrescale == 0) {
                    return mfpTcCurrent & 0xFF;
                }
                return mfpTcInitial - (int)(Math.floor((double)(XEiJ.mpuClockTime - mfpTcStart) / (double)mfpTcDelta) % (double)mfpTcInitial) & 0xFF;
            }
            case 15237157: {
                if (mfpTdPrescale == 0) {
                    return mfpTdCurrent & 0xFF;
                }
                return mfpTdInitial - (int)(Math.floor((double)(XEiJ.mpuClockTime - mfpTdStart) / (double)mfpTdDelta) % (double)mfpTdInitial) & 0xFF;
            }
            case 15237159: {
                return 0;
            }
            case 15237161: {
                return mfpUCR;
            }
            case 15237163: {
                return mfpRSR | (mfpUdrQueueRead == mfpUdrQueueWrite ? 0 : 128);
            }
            case 15237165: {
                return mfpTSR | (XEiJ.mpuClockTime < mfpTSRBufferFullEnd ? 0 : 128);
            }
            case 15237167: {
                if (mfpUdrQueueRead != mfpUdrQueueWrite && ++mfpUdrQueueRead != mfpUdrQueueWrite && (mfpIer & 0x1000) != 0) {
                    mfpInnerRequest[12] = mfpInnerRequest[12] + 1;
                    if ((mfpImr & 0x1000) != 0) {
                        XEiJ.mpuDIRR |= 2;
                    }
                }
                return mfpUdrQueueArray[mfpUdrQueueRead & 0xF];
            }
        }
        if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
            return MemoryMappedDevice.MMD_NUL.mmdRbz(n);
        }
        return 255;
    }

    public static void mfpWriteByte(int n, int n2) throws M68kException {
        XEiJ.mpuClockTime += XEiJ.busWaitTime.mfp;
        switch (n & 0xFF803F) {
            case 15237121: {
                return;
            }
            case 15237123: {
                mfpAer = n2 & 0xFF;
                return;
            }
            case 15237125: {
                return;
            }
            case 15237127: {
                n2 = (char)(n2 << 8);
                int n3 = mfpIer;
                mfpIer = n2 | mfpIer & 0xFF;
                if ((short)n2 >= 0) {
                    MC68901.mfpInnerAcknowledged[15] = mfpInnerRequest[15];
                }
                if (n2 << 17 >= 0) {
                    MC68901.mfpInnerAcknowledged[14] = mfpInnerRequest[14];
                }
                if (n2 << 18 >= 0) {
                    MC68901.mfpInnerAcknowledged[13] = mfpInnerRequest[13];
                }
                if (n2 << 19 >= 0) {
                    MC68901.mfpInnerAcknowledged[12] = mfpInnerRequest[12];
                } else if (n3 << 19 >= 0 && mfpUdrQueueRead != mfpUdrQueueWrite) {
                    mfpInnerRequest[12] = mfpInnerRequest[12] + 1;
                    if ((mfpImr & 0x1000) != 0) {
                        XEiJ.mpuDIRR |= 2;
                    }
                }
                if (n2 << 20 >= 0) {
                    MC68901.mfpInnerAcknowledged[11] = mfpInnerRequest[11];
                }
                if (n2 << 21 >= 0) {
                    MC68901.mfpInnerAcknowledged[10] = mfpInnerRequest[10];
                }
                if (n2 << 22 >= 0) {
                    MC68901.mfpInnerAcknowledged[9] = mfpInnerRequest[9];
                }
                if (n2 << 23 >= 0) {
                    MC68901.mfpInnerAcknowledged[8] = mfpInnerRequest[8];
                }
                return;
            }
            case 15237129: {
                mfpIer = mfpIer & 0xFFFFFF00 | n2 & 0xFF;
                if ((byte)n2 >= 0) {
                    MC68901.mfpInnerAcknowledged[7] = mfpInnerRequest[7];
                }
                if (n2 << 25 >= 0) {
                    MC68901.mfpInnerAcknowledged[6] = mfpInnerRequest[6];
                }
                if (n2 << 26 >= 0) {
                    MC68901.mfpInnerAcknowledged[5] = mfpInnerRequest[5];
                }
                if (n2 << 27 >= 0) {
                    MC68901.mfpInnerAcknowledged[4] = mfpInnerRequest[4];
                }
                if (n2 << 28 >= 0) {
                    MC68901.mfpInnerAcknowledged[3] = mfpInnerRequest[3];
                }
                if (n2 << 29 >= 0) {
                    MC68901.mfpInnerAcknowledged[2] = mfpInnerRequest[2];
                }
                if ((n2 & 2) == 0) {
                    MC68901.mfpInnerAcknowledged[1] = mfpInnerRequest[1];
                }
                if ((n2 & 1) == 0) {
                    MC68901.mfpInnerAcknowledged[0] = mfpInnerRequest[0];
                }
                return;
            }
            case 15237131: {
                switch (n2 & 0xFF) {
                    case 127: {
                        MC68901.mfpInnerAcknowledged[15] = mfpInnerRequest[15];
                        break;
                    }
                    case 191: {
                        MC68901.mfpInnerAcknowledged[14] = mfpInnerRequest[14];
                        break;
                    }
                    case 223: {
                        MC68901.mfpInnerAcknowledged[13] = mfpInnerRequest[13];
                        break;
                    }
                    case 239: {
                        MC68901.mfpInnerAcknowledged[12] = mfpInnerRequest[12];
                        break;
                    }
                    case 247: {
                        MC68901.mfpInnerAcknowledged[11] = mfpInnerRequest[11];
                        break;
                    }
                    case 251: {
                        MC68901.mfpInnerAcknowledged[10] = mfpInnerRequest[10];
                        break;
                    }
                    case 253: {
                        MC68901.mfpInnerAcknowledged[9] = mfpInnerRequest[9];
                        break;
                    }
                    case 254: {
                        MC68901.mfpInnerAcknowledged[8] = mfpInnerRequest[8];
                    }
                }
                return;
            }
            case 15237133: {
                switch (n2 & 0xFF) {
                    case 127: {
                        MC68901.mfpInnerAcknowledged[7] = mfpInnerRequest[7];
                        break;
                    }
                    case 191: {
                        MC68901.mfpInnerAcknowledged[6] = mfpInnerRequest[6];
                        break;
                    }
                    case 223: {
                        MC68901.mfpInnerAcknowledged[5] = mfpInnerRequest[5];
                        break;
                    }
                    case 239: {
                        MC68901.mfpInnerAcknowledged[4] = mfpInnerRequest[4];
                        break;
                    }
                    case 247: {
                        MC68901.mfpInnerAcknowledged[3] = mfpInnerRequest[3];
                        break;
                    }
                    case 251: {
                        MC68901.mfpInnerAcknowledged[2] = mfpInnerRequest[2];
                        break;
                    }
                    case 253: {
                        MC68901.mfpInnerAcknowledged[1] = mfpInnerRequest[1];
                        break;
                    }
                    case 254: {
                        MC68901.mfpInnerAcknowledged[0] = mfpInnerRequest[0];
                    }
                }
                return;
            }
            case 15237135: {
                switch (n2 & 0xFF) {
                    case 127: {
                        MC68901.mfpInnerInService[15] = false;
                        break;
                    }
                    case 191: {
                        MC68901.mfpInnerInService[14] = false;
                        break;
                    }
                    case 223: {
                        MC68901.mfpInnerInService[13] = false;
                        break;
                    }
                    case 239: {
                        MC68901.mfpInnerInService[12] = false;
                        break;
                    }
                    case 247: {
                        MC68901.mfpInnerInService[11] = false;
                        break;
                    }
                    case 251: {
                        MC68901.mfpInnerInService[10] = false;
                        break;
                    }
                    case 253: {
                        MC68901.mfpInnerInService[9] = false;
                        break;
                    }
                    case 254: {
                        MC68901.mfpInnerInService[8] = false;
                    }
                }
                return;
            }
            case 15237137: {
                switch (n2 & 0xFF) {
                    case 127: {
                        MC68901.mfpInnerInService[7] = false;
                        break;
                    }
                    case 191: {
                        MC68901.mfpInnerInService[6] = false;
                        break;
                    }
                    case 223: {
                        MC68901.mfpInnerInService[5] = false;
                        break;
                    }
                    case 239: {
                        MC68901.mfpInnerInService[4] = false;
                        break;
                    }
                    case 247: {
                        MC68901.mfpInnerInService[3] = false;
                        break;
                    }
                    case 251: {
                        MC68901.mfpInnerInService[2] = false;
                        break;
                    }
                    case 253: {
                        MC68901.mfpInnerInService[1] = false;
                        break;
                    }
                    case 254: {
                        MC68901.mfpInnerInService[0] = false;
                    }
                }
                return;
            }
            case 15237139: {
                mfpImr = (n2 & 0xFF) << 8 | mfpImr & 0xFF;
                if ((byte)n2 < 0 && mfpInnerRequest[15] != mfpInnerAcknowledged[15] || n2 << 25 < 0 && mfpInnerRequest[14] != mfpInnerAcknowledged[14] || n2 << 26 < 0 && mfpInnerRequest[13] != mfpInnerAcknowledged[13] || n2 << 27 < 0 && mfpInnerRequest[12] != mfpInnerAcknowledged[12] || n2 << 28 < 0 && mfpInnerRequest[11] != mfpInnerAcknowledged[11] || n2 << 29 < 0 && mfpInnerRequest[10] != mfpInnerAcknowledged[10] || (n2 & 2) != 0 && mfpInnerRequest[9] != mfpInnerAcknowledged[9] || (n2 & 1) != 0 && mfpInnerRequest[8] != mfpInnerAcknowledged[8]) {
                    XEiJ.mpuDIRR |= 2;
                }
                return;
            }
            case 15237141: {
                mfpImr = mfpImr & 0xFFFFFF00 | n2 & 0xFF;
                if ((byte)n2 < 0 && mfpInnerRequest[7] != mfpInnerAcknowledged[7] || n2 << 25 < 0 && mfpInnerRequest[6] != mfpInnerAcknowledged[6] || n2 << 26 < 0 && mfpInnerRequest[5] != mfpInnerAcknowledged[5] || n2 << 27 < 0 && mfpInnerRequest[4] != mfpInnerAcknowledged[4] || n2 << 28 < 0 && mfpInnerRequest[3] != mfpInnerAcknowledged[3] || n2 << 29 < 0 && mfpInnerRequest[2] != mfpInnerAcknowledged[2] || (n2 & 2) != 0 && mfpInnerRequest[1] != mfpInnerAcknowledged[1] || (n2 & 1) != 0 && mfpInnerRequest[0] != mfpInnerAcknowledged[0]) {
                    XEiJ.mpuDIRR |= 2;
                }
                return;
            }
            case 15237143: {
                mfpVectorHigh = 0xF0 & n2;
                return;
            }
            case 15237145: {
                boolean bl = mfpTaEventcount;
                int n4 = mfpTaPrescale;
                mfpTaEventcount = (n2 & 8) != 0;
                mfpTaPrescale = n2 & 7;
                if (mfpTaEventcount && mfpTaPrescale != 0) {
                    mfpTaEventcount = false;
                    mfpTaPrescale = 0;
                }
                if (bl != mfpTaEventcount || n4 != mfpTaPrescale) {
                    if (!bl && n4 != 0) {
                        mfpTaCurrent = mfpTaInitial - (int)(Math.floor((double)(XEiJ.mpuClockTime - mfpTaStart) / (double)mfpTaDelta) % (double)mfpTaInitial);
                        mfpTaClock = Long.MAX_VALUE;
                        TickerQueue.tkqRemove(mfpTaTicker);
                    }
                    if (!mfpTaEventcount && mfpTaPrescale != 0) {
                        mfpTaDelta = MFP_DELTA[mfpTaPrescale];
                        if (!bl && n4 != 0) {
                            long l = MFP_DELTA[n4];
                            mfpTaStart -= (mfpTaDelta - l) * (long)(mfpTaInitial - mfpTaCurrent);
                        } else {
                            mfpTaStart = XEiJ.mpuClockTime;
                        }
                        mfpTaClock = mfpTaStart + mfpTaDelta * (long)mfpTaInitial;
                        TickerQueue.tkqAdd(mfpTaTicker, mfpTaClock);
                    }
                }
                return;
            }
            case 15237147: {
                boolean bl = mfpTbEventcount;
                int n5 = mfpTbPrescale;
                mfpTbEventcount = (n2 & 8) != 0;
                mfpTbPrescale = n2 & 7;
                boolean bl2 = mfpTbKeyboardOn = !mfpTbEventcount && mfpTbPrescale == 1 && mfpTbInitial == 13;
                if (mfpTbEventcount && mfpTbPrescale != 0) {
                    mfpTbEventcount = false;
                    mfpTbPrescale = 0;
                }
                if (bl != mfpTbEventcount || n5 != mfpTbPrescale) {
                    if (!bl && n5 != 0) {
                        mfpTbCurrent = mfpTbInitial - (int)(Math.floor((double)(XEiJ.mpuClockTime - mfpTbStart) / (double)mfpTbDelta) % (double)mfpTbInitial);
                        mfpTbClock = Long.MAX_VALUE;
                        TickerQueue.tkqRemove(mfpTbTicker);
                    }
                    if (!mfpTbEventcount && mfpTbPrescale != 0) {
                        mfpTbDelta = MFP_DELTA[mfpTbPrescale];
                        if (!bl && n5 != 0) {
                            long l = MFP_DELTA[n5];
                            mfpTbStart -= (mfpTbDelta - l) * (long)(mfpTbInitial - mfpTbCurrent);
                        } else {
                            mfpTbStart = XEiJ.mpuClockTime;
                        }
                        mfpTbClock = mfpTbStart + mfpTbDelta * (long)mfpTbInitial;
                        TickerQueue.tkqAdd(mfpTbTicker, mfpTbClock);
                    }
                }
                return;
            }
            case 15237149: {
                long l;
                int n6 = mfpTcPrescale;
                mfpTcPrescale = n2 >> 4 & 7;
                if (n6 != mfpTcPrescale) {
                    if (n6 != 0) {
                        mfpTcCurrent = mfpTcInitial - (int)(Math.floor((double)(XEiJ.mpuClockTime - mfpTcStart) / (double)mfpTcDelta) % (double)mfpTcInitial);
                        mfpTcClock = Long.MAX_VALUE;
                        TickerQueue.tkqRemove(mfpTcTicker);
                    }
                    if (mfpTcPrescale != 0) {
                        mfpTcDelta = MFP_DELTA[mfpTcPrescale];
                        if (n6 != 0) {
                            l = MFP_DELTA[n6];
                            mfpTcStart -= (mfpTcDelta - l) * (long)(mfpTcInitial - mfpTcCurrent);
                        } else {
                            mfpTcStart = XEiJ.mpuClockTime;
                        }
                        mfpTcClock = mfpTcStart + mfpTcDelta * (long)mfpTcInitial;
                        TickerQueue.tkqAdd(mfpTcTicker, mfpTcClock);
                    }
                }
                if ((n6 = mfpTdPrescale) != (mfpTdPrescale = n2 & 7)) {
                    if (n6 != 0) {
                        mfpTdCurrent = mfpTdInitial - (int)(Math.floor((double)(XEiJ.mpuClockTime - mfpTdStart) / (double)mfpTdDelta) % (double)mfpTdInitial);
                        mfpTdClock = Long.MAX_VALUE;
                        TickerQueue.tkqRemove(mfpTdTicker);
                    }
                    if (mfpTdPrescale != 0) {
                        mfpTdDelta = MFP_DELTA[mfpTdPrescale];
                        if (n6 != 0) {
                            l = MFP_DELTA[n6];
                            mfpTdStart -= (mfpTdDelta - l) * (long)(mfpTdInitial - mfpTdCurrent);
                        } else {
                            mfpTdStart = XEiJ.mpuClockTime;
                        }
                        mfpTdClock = mfpTdStart + mfpTdDelta * (long)mfpTdInitial;
                        TickerQueue.tkqAdd(mfpTdTicker, mfpTdClock);
                    }
                }
                return;
            }
            case 15237151: {
                if (mfpTaEventcount || mfpTaPrescale == 0) {
                    mfpTaCurrent = mfpTaInitial = (n2 - 1 & 0xFF) + 1;
                } else {
                    int n7 = mfpTaInitial;
                    mfpTaInitial = (n2 - 1 & 0xFF) + 1;
                    mfpTaStart -= mfpTaDelta * (long)(mfpTaInitial - n7);
                }
                return;
            }
            case 15237153: {
                if (mfpTbEventcount || mfpTbPrescale == 0) {
                    mfpTbCurrent = mfpTbInitial = (n2 - 1 & 0xFF) + 1;
                } else {
                    int n8 = mfpTbInitial;
                    mfpTbInitial = (n2 - 1 & 0xFF) + 1;
                    mfpTbStart -= mfpTbDelta * (long)(mfpTbInitial - n8);
                }
                mfpTbKeyboardOn = !mfpTbEventcount && mfpTbPrescale == 1 && mfpTbInitial == 13;
                return;
            }
            case 15237155: {
                if (mfpTcPrescale == 0) {
                    mfpTcCurrent = mfpTcInitial = (n2 - 1 & 0xFF) + 1;
                } else {
                    int n9 = mfpTcInitial;
                    mfpTcInitial = (n2 - 1 & 0xFF) + 1;
                    mfpTcStart -= mfpTcDelta * (long)(mfpTcInitial - n9);
                }
                return;
            }
            case 15237157: {
                if (mfpTdPrescale == 0) {
                    mfpTdCurrent = mfpTdInitial = (n2 - 1 & 0xFF) + 1;
                } else {
                    int n10 = mfpTdInitial;
                    mfpTdInitial = (n2 - 1 & 0xFF) + 1;
                    mfpTdStart -= mfpTdDelta * (long)(mfpTdInitial - n10);
                }
                return;
            }
            case 15237159: {
                return;
            }
            case 15237161: {
                mfpUCR = n2 & 0xFE;
                mfpTSRBufferFullTime = mfpTbDelta * (long)mfpTbInitial * 2L * (long)((mfpUCR & 0x80) != 0 ? 16 : 1) * (long)(2 + (8 - (mfpUCR >> 5 & 3)) * 2 + ((mfpUCR >> 3 & 3) + 1)) / 2L;
                return;
            }
            case 15237163: {
                mfpRSR = n2 & 1;
                return;
            }
            case 15237165: {
                mfpTSR = n2 & 1;
                return;
            }
            case 15237167: {
                if (mfpTbKeyboardOn) {
                    if ((byte)n2 < 0) {
                        Keyboard.kbdSetLedStatus(n2);
                    } else if ((n2 & 0xF8) != 64 && (n2 & 0xF8) != 72) {
                        if ((n2 & 0xFC) == 84) {
                            Keyboard.kbdSetLedBrightness(n2);
                        } else if ((n2 & 0xFC) != 88 && (n2 & 0xFC) != 92) {
                            if ((n2 & 0xF0) == 96) {
                                Keyboard.kbdSetRepeatDelay(0xF & n2);
                            } else if ((n2 & 0xF0) == 112) {
                                Keyboard.kbdSetRepeatInterval(0xF & n2);
                            }
                        }
                    }
                }
                mfpTSRBufferFullEnd = XEiJ.mpuClockTime + mfpTSRBufferFullTime;
                return;
            }
        }
        if ((n & 1) == 0 && !XEiJ.currentIsSecond) {
            MemoryMappedDevice.MMD_NUL.mmdWb(n, n2);
        }
    }

    static {
        mfpInnerRequest = new int[16];
        mfpInnerAcknowledged = new int[16];
        mfpInnerInService = new boolean[16];
        mfpUdrQueueArray = new int[16];
        mfpTaTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if ((mfpIer & 0x2000) != 0) {
                    mfpInnerRequest[13] = mfpInnerRequest[13] + 1;
                    if ((mfpImr & 0x2000) != 0) {
                        XEiJ.mpuDIRR |= 2;
                    }
                }
                TickerQueue.tkqAdd(mfpTaTicker, mfpTaClock += mfpTaDelta * (long)mfpTaInitial);
            }
        };
        mfpTbTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if ((mfpIer & 0x100) != 0) {
                    mfpInnerRequest[8] = mfpInnerRequest[8] + 1;
                    if ((mfpImr & 0x100) != 0) {
                        XEiJ.mpuDIRR |= 2;
                    }
                }
                TickerQueue.tkqAdd(mfpTbTicker, mfpTbClock += mfpTbDelta * (long)mfpTbInitial);
            }
        };
        mfpTcTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if ((mfpIer & 0x20) != 0) {
                    mfpInnerRequest[5] = mfpInnerRequest[5] + 1;
                    if ((mfpImr & 0x20) != 0) {
                        XEiJ.mpuDIRR |= 2;
                    }
                }
                TickerQueue.tkqAdd(mfpTcTicker, mfpTcClock += mfpTcDelta * (long)mfpTcInitial);
            }
        };
        mfpTdTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
                if ((mfpIer & 0x10) != 0) {
                    mfpInnerRequest[4] = mfpInnerRequest[4] + 1;
                    if ((mfpImr & 0x10) != 0) {
                        XEiJ.mpuDIRR |= 2;
                    }
                }
                TickerQueue.tkqAdd(mfpTdTicker, mfpTdClock += mfpTdDelta * (long)mfpTdInitial);
            }
        };
        mfpTkTicker = new TickerQueue.Ticker(){

            @Override
            protected void tick() {
            }
        };
        mfpKbdBuffer = new int[256];
    }
}

