;========================================================================================
;  spr1016test.s
;  Copyright (C) 2003-2025 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------
;spr1016test.x
;	XEiJ̊g@\eXg܂Bȉ̐ݒŎsĂB
;	EXvCg̖1016
;	E4096̃p^[
;	E768x512ŃXvCg\
;	EX^̃XvCg̖1016
;	Esprdrv.xgݍ
;	L[ƏI܂B
;	X68000@ł͓܂B
;XV
;	2025-04-07
;		ŁB
;	2025-04-10
;		IOCS _SP_REGST̃XvCgԍ̕ύXɒǏ]܂B
;----------------------------------------------------------------

	.include	control2.mac
	.include	doscall.mac
	.include	fefunc.mac
	.include	forvar.mac
	.include	iocscall.mac
	.include	misc.mac
	.include	sprc.equ

;ʃ[hύX
	move.l	#14<<16|3,-(sp)		;t@NVL[\Ȃ
	DOS	_CONCTRL
	addq.l	#4,sp
	move.w	d0,-(sp)
	move.l	#16<<16|0,-(sp)		;768x512OtBbNȂ
	DOS	_CONCTRL
	addq.l	#4,sp
	move.w	d0,-(sp)

;XvCgʂ
	move.l	#'SPRD',d1		;g@\gp
	move.l	#2<<1|1,d2		;p^[4096AeLXgGAړ
	IOCS	_SP_INIT

;O
;	x=16+floor(OX+AX*sin(AF*t)-BX*sin(BF*t))
;	y=16+floor(OY+AY*cos(AF*t)+BY*cos(BF*t))
N	equ	1016			;vf
M	equ	23			;
PI	fset	3.14159265358979323846	;~
TI	fequ	2.0*PI/(M*N)		;t/ʒuԍ
OX	fequ	376.0			;SX
OY	fequ	248.0			;SY
RX	fequ	360.0			;Ŝ̔aX
RY	fequ	240.0			;Ŝ̔aY
AF	fequ	6.0			;~̎g
BF	fequ	23.0			;~̎g
PA	fequ	5.0			;~̊
PB	fequ	2.0			;~̊
AX	fequ	RX*PA/(PA+PB)		;~̔aX
AY	fequ	RY*PA/(PA+PB)		;~̔aY
BX	fequ	RX*PB/(PA+PB)		;~̔aX
BY	fequ	RY*PB/(PA+PB)		;~̔aY
	.data
	.even
ti:	.dc.d	TI
af:	.dc.d	AF
bf:	.dc.d	BF
ax:	.dc.d	AX
bx:	.dc.d	BX
ox:	.dc.d	OX
ay:	.dc.d	AY
by:	.dc.d	BY
oy:	.dc.d	OY
	.bss
	.even
;O(ʒuԍ*4W)
orbit:
	.dc.w	2*M*N
	.text
	lea.l	orbit(pc),a0		;O
	moveq.l	#0,d7			;d7=i ʒuԍ
	do
		move.l	d7,d0			;d0=i
		FPACK	__LTOD			;d0d1=i
		movem.l	ti(pc),d2-d3		;d2d3=ti
		FPACK	__DMUL			;d0d1=ti*i=t
		move.l	d0,d4
		move.l	d1,d5			;d4d5=t
		movem.l	af(pc),d2-d3		;d2d3=af
		FPACK	__DMUL			;d0d1=af*t
		movea.l	d0,a2
		movea.l	d1,a3			;a2a3=af*t
		move.l	d4,d0
		move.l	d5,d1			;d0d1=t
		movem.l	bf(pc),d2-d3		;d2d3=bf
		FPACK	__DMUL			;d0d1=bf*t
		movea.l	d0,a4
		movea.l	d1,a5			;a4a5=bf*t
		FPACK	__SIN			;d0d1=sin(bf*t)
		movem.l	bx(pc),d2-d3		;d2d3=bx
		FPACK	__DMUL			;d0d1=bx*sin(bf*t)
		move.l	d0,d4
		move.l	d1,d5			;d4d5=bx*sin(bf*t)
		move.l	a2,d0
		move.l	a3,d1			;d0d1=af*t
		FPACK	__SIN			;d0d1=sin(af*t)
		movem.l	ax(pc),d2-d3		;d2d3=ax
		FPACK	__DMUL			;d0d1=ax*sin(af*t)
		move.l	d4,d2
		move.l	d5,d3			;d2d3=bx*sin(bf*t)
		FPACK	__DSUB			;d0d1=ax*sin(af*t)-bx*sin(bf*t)
		movem.l	ox(pc),d2-d3		;d2d3=ox
		FPACK	__DADD			;d0d1=ox+ax*sin(af*t)-bx*sin(bf*t)
		FPACK	__DFLOOR		;d0d1=floor(ox+ax*sin(af*t)-bx*sin(bf*t))
		FPACK	__DTOL			;d0=floor(ox+ax*sin(af*t)-bx*sin(bf*t))
		add.l	#16,d0			;d0=16+floor(ox+ax*sin(af*t)-bx*sin(bf*t))=x
		move.l	d0,d6			;d6=x
		move.l	a4,d0
		move.l	a5,d1			;d0d1=bf*t
		FPACK	__COS			;d0d1=cos(bf*t)
		movem.l	by(pc),d2-d3		;d2d3=by
		FPACK	__DMUL			;d0d1=by*cos(bf*t)
		move.l	d0,d4
		move.l	d1,d5			;d4d5=by*cos(bf*t)
		move.l	a2,d0
		move.l	a3,d1			;d0d1=af*t
		FPACK	__COS			;d0d1=cos(af*t)
		movem.l	ay(pc),d2-d3		;d2d3=ay
		FPACK	__DMUL			;d0d1=ay*cos(af*t)
		move.l	d4,d2
		move.l	d5,d3			;d2d3=by*cos(bf*t)
		FPACK	__DADD			;d0d1=ay*cos(af*t)+by*cos(bf*t)
		movem.l	oy(pc),d2-d3		;d2d3=oy
		FPACK	__DADD			;d0d1=oy+ay*cos(af*t)+by*cos(bf*t)
		FPACK	__DFLOOR		;d0d1=floor(oy+ay*cos(af*t)+by*cos(bf*t))
		FPACK	__DTOL			;d0=floor(oy+ay*cos(af*t)+by*cos(bf*t))
		add.l	#16,d0			;d0=16+floor(oy+ay*cos(af*t)+by*cos(bf*t))=y
		move.w	d6,(a0)+		;x
		move.w	d0,(a0)+		;y
		addq.l	#1,d7			;i++
	while	<cmp.l	#M*N,d7>,lo

;pbgݒ肷
;	pbgubN1`15ApbgR[h1`15225Fg
;	j=0`224	Fԍ
;	h=floor(HJ*j)
;	s=31
;	v=floor(VO+VR*cos(VF*TJ*j))
	.data
	.even
hj:	.dc.d	192.0/225.0
vftj:	.dc.d	AF*2.0*PI/225.0
vr:	.dc.d	10.0
vo:	.dc.d	20.0
;FԍpbgubN
color_to_block:
	forvar	i,0,224,<.dc.b (i/15)+1>
;FԍpbgR[h
color_to_code:
	forvar	i,0,224,<.dc.b (i.mod.15)+1>
	.text
	lea.l	color_to_block(pc),a4	;FԍpbgubN
	lea.l	color_to_code(pc),a5	;FԍpbgR[h
	moveq.l	#0,d7			;d7=j Fԍ
	do
		move.l	d7,d0			;d0=j
		FPACK	__LTOD			;d0d1=j
		move.l	d0,d4
		move.l	d1,d5			;d4d5=j
		movem.l	hj(pc),d2-d3		;d2d3=hj
		FPACK	__DMUL			;d0d1=hj*j
		FPACK	__DFLOOR		;d0d1=floor(hj*j)=h
		FPACK	__DTOL			;d0=h
		move.l	d0,d6			;d6=h
		move.l	d4,d0
		move.l	d5,d1			;d0d1=p
		movem.l	vftj(pc),d2-d3		;d2d3=vf*tj
		FPACK	__DMUL			;d0d1=vf*tj*j=vf*t
		FPACK	__COS			;d0d1=cos(vf*t)
		movem.l	vr(pc),d2-d3		;d2d3=vr
		FPACK	__DMUL			;d0d1=vr*cos(vf*t)
		movem.l	vo(pc),d2-d3		;d2d3=vo
		FPACK	__DADD			;d0d1=vo+vr*cos(vf*t)
		FPACK	__DFLOOR		;d0d1=floor(vo+vr*cos(vf*t))=V
		FPACK	__DTOL			;d0=v
		move.l	d6,d1			;d1=h
		swap.w	d1			;d1=h<<16
		move.w	#31<<8,d1		;d1=h<<16|s<<8
		move.b	d0,d1			;d1=h<<16|s<<8|v
		IOCS	_HSVTORGB		;d0=J[R[h
		move.w	d0,d3			;d3=J[R[h
		moveq.l	#0,d2
		move.b	(a4,d7.w),d2		;d2=b pbgubN
		moveq.l	#0,d1
		move.b	(a5,d7.w),d1		;d1=c pbgR[h
		if	<tst.w d7>,ne
			bset.l	#31,d1
		endif
		IOCS	_SPALET
		addq.w	#1,d7			;p++
	while	<cmp.w	#225,d7>,lo

;p^[`
	.data
	.even
;vfԍ*2
elem_to_moji:
	.dc.b	'ÈĈňƈǈȈɈʈˈ͈̈Έψ'
	.dc.b	'ш҈ӈԈՈֈ׈؈وڈۈ܈݈ވ߈@ABCDE'
	.dc.b	'FGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvw'
	.dc.b	'xyz{|}~'
	.dc.b	'ÉĉŉƉǉȉɉʉˉ͉̉ΉωЉщ҉ӉԉՉ։׉؉ىډۉ'
	.dc.b	'݉މ߉@ABCDEFGHIJKLMNOPQ'
	.dc.b	'RSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~'
	.dc.b	''
	.dc.b	'ÊĊŊƊǊȊɊʊˊ̊͊ΊϊЊъҊӊԊՊ֊׊؊يڊۊ܊݊ފߊ'
	.dc.b	'@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]'
	.dc.b	'^_`abcdefghijklmnopqrstuvwxyz{|}~'
	.dc.b	''
	.dc.b	'ËċŋƋǋȋɋʋˋ̋͋΋ϋЋыҋӋԋՋ֋׋؋ًڋۋ܋݋ދߋ'
	.dc.b	'@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghi'
	.dc.b	'jklmnopqrstuvwxyz{|}~'
	.dc.b	'ÌČŌƌǌȌɌʌˌ̌͌'
	.dc.b	'όЌьҌӌԌՌ֌׌،ٌڌی܌݌ތߌ@ABC'
	.dc.b	'DEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstu'
	.dc.b	'vwxyz{|}~'
	.dc.b	'ÍčōƍǍȍɍʍˍ͍̍΍ύЍэҍӍԍՍ֍׍؍ٍ'
	.dc.b	'ۍ܍ݍލߍ'
;vfԍpbgR[h
elem_to_code:
	forvar	i,0,N-1,<.dc.b ((i*225/N).mod.15)+1>
	.text
	lea.l	-(4+2*16+4*32)(sp),sp	;tHgTCYAtHgf[^Ap^[f[^
	lea.l	elem_to_moji(pc),a3	;vfԍ*2
	lea.l	elem_to_code(pc),a5	;vfԍpbgR[h
	moveq.l	#0,d4			;vfԍ
	do
	;tHgf[^𓾂
		move.w	(a3)+,d1		;
		moveq.l	#0,d2			;16x16
		movea.l	sp,a1			;tHgTCYAtHgf[^
		IOCS	_FNTGET
	;pbgR[hpӂ
		move.b	(a5)+,d5		;pbgR[h
	;tHgf[^p^[f[^
		lea.l	4(sp),a0		;tHgf[^
		lea.l	4+2*16(sp),a1		;p^[f[^
	;
		moveq	#16-1,d3
		for	d3
			move.b	(a0)+,d0		;と
			addq.l	#1,a0
		;	moveq.l	#0,d1
			moveq.l	#8-1,d2
			for	d2
				lsl.l	#4,d1
				add.b	d0,d0
				if	cs
					or.b	d5,d1
				endif
			next
			move.l	d1,(a1)+		;と=E
		next
		lea.l	-2*16(a0),a0		;
	;E
		moveq	#16-1,d3
		for	d3
			addq.l	#1,a0			;と
			move.b	(a0)+,d0
		;	moveq.l	#0,d1
			moveq.l	#8-1,d2
			for	d2
				lsl.l	#4,d1
				add.b	d0,d0
				if	cs
					or.b	d5,d1
				endif
			next
			move.l	d1,(a1)+		;=EとE
		next
	;p^[`
		move.l	d4,d1			;p^[ԍ=vfԍ
		moveq.l	#1,d2			;16x16
		lea.l	4+2*16(sp),a1		;p^[f[^
		IOCS	_SP_DEFCG
		addq.w	#1,d4			;vfԍ++
	while	<cmp.w #N,d4>,lo
	lea.l	4+2*16+4*32(sp),sp

;J[\\OFF
	IOCS	_B_CUROFF

;XvCg\ON
	IOCS	_SP_ON

;
	.data
	.even
;vfԍ*2LN^
elem_to_char:
	forvar	i,0,N-1,<.dc.w ((i&$F00)<<4)|(((i*225/N)/15+1)<<8)|(i&$FF)>
	.text
	lea.l	orbit(pc),a2		;O̐擪vf0̍W̃AhX
	movea.l	a2,a3			;O̐擪
	move.l	#4*M*N,d6		;O̒
	adda.l	d6,a3			;O̖
	moveq.l	#0,d2
	moveq.l	#0,d3
	moveq.l	#0,d4
	movea.l	#$80000000,a5
	do
		lea.l	elem_to_char(pc),a4	;vfԍ*2LN^
		movea.l	a2,a1			;vf̍W̃AhX
		moveq.l	#0,d1			;vf0VDISP̗҂
		moveq.l	#0,d7			;vfԍ
		do
			move.w	d7,d1			;XvCgԍ(A)
			move.w	(a1)+,d2		;XW
			move.w	(a1)+,d3		;YW
			move.w	(a4)+,d4		;LN^
			moveq.l	#3,d5			;vCIeB
			IOCS	_SP_REGST
			move.l	a5,d1			;vf0ȊOVDISP̗҂Ȃ
			lea.l	4*(M-1)(a1),a1		;vf̍W̃AhX+=*4
			if	<cmpa.l a3,a1>,hs	;ɒB
				suba.l	d6,a1			;߂
			endif
			addq.w	#1,d7			;vfԍ++
		while	<cmp.w #N,d7>,lo
		addq.l	#4,a2			;vf0̍W̃AhX+=4
		if	<cmpa.l a3,a2>,hs	;ɒB
			suba.l	d6,a2			;߂
		endif
		bsr	inkey0
	while	eq			;L[܂ŌJԂ

;XvCg\OFF
	IOCS	_SP_OFF

;J[\\ON
	IOCS	_B_CURON

;ʃ[h𕜌
	move.w	#16,-(sp)
	DOS	_CONCTRL
	addq.l	#4,sp
	move.w	#14,-(sp)
	DOS	_CONCTRL
	addq.l	#4,sp

;I
	DOS	_EXIT

;----------------------------------------------------------------
;R[h0łȂL[͂BĂȂĂ҂Ȃ
;>d0.l:R[hB0=ĂȂ
inkey0::
	dostart
		IOCS	_B_KEYINP		;L[obt@菜
		break	<tst.b d0>,ne		;R[h0łȂL[ꂽƂI
	start
		IOCS	_B_KEYSNS		;L[obt@ǂ݂
	while	<tst.l d0>,ne		;ĂƂJԂ
	and.l	#$000000FF,d0		;R[h
	rts
