;========================================================================================
;  ppcon.s
;  Copyright (C) 2003-2024 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

	.include	bioswork.equ
	.include	control2.mac
	.include	crtc.equ
	.include	doscall.mac
	.include	dosconst.equ
	.include	doswork.equ
	.include	iocscall.mac
	.include	mfp.equ
	.include	misc.mac
	.include	push2.mac
	.include	sram.equ

DEVICE_NAME	reg	'CON     '
TITLE_STRING	reg	'Proportional-Pitch CONsole'
VERSION_STRING	reg	'0.11'
MAGIC_STRING	reg	'PPCON011'

;----------------------------------------------------------------
;vO̐擪
	.text
program_head:

;foCXwb_
	.dc.l	-1			;̃foCXwb_B-1=foCXwb_̃Xg̖
	.dc.w	$8003			;foCX^CvBLN^foCXAWóAW
	.dc.l	strategy_routine	;XgeW[`
	.dc.l	interrupt_routine	;C^vg[`
	.dc.b	DEVICE_NAME		;foCX

;----------------------------------------------------------------
;}WbN
magic:
	.dc.b	MAGIC_STRING

;xN^e[u
vector_table:
;J[\_ŏ[`
	.dc.w	BIOS_TC_CURSOR_HANDLE	;ItZbg
	.dc.l	timer_c_cursor		;VxN^
	.dc.l	0			;ÂxN^
;_B_CURON
	.dc.w	4*($100+_B_CURON)
	.dc.l	iocs_1E_B_CURON
	.dc.l	0
;_B_CUROFF
	.dc.w	4*($100+_B_CUROFF)
	.dc.l	iocs_1F_B_CUROFF
	.dc.l	0
;_B_PUTC
	.dc.w	4*($100+_B_PUTC)
	.dc.l	iocs_20_B_PUTC
	.dc.l	0
;_B_PRINT
	.dc.w	4*($100+_B_PRINT)
	.dc.l	iocs_21_B_PRINT
	.dc.l	0
;_B_COLOR
	.dc.w	4*($100+_B_COLOR)
	.dc.l	iocs_22_B_COLOR
	.dc.l	0
;_B_LOCATE
	.dc.w	4*($100+_B_LOCATE)
	.dc.l	iocs_23_B_LOCATE
	.dc.l	0
;_B_DOWN_S
	.dc.w	4*($100+_B_DOWN_S)
	.dc.l	iocs_24_B_DOWN_S
	.dc.l	0
;_B_UP_S
	.dc.w	4*($100+_B_UP_S)
	.dc.l	iocs_25_B_UP_S
	.dc.l	0
;_B_UP
	.dc.w	4*($100+_B_UP)
	.dc.l	iocs_26_B_UP
	.dc.l	0
;_B_DOWN
	.dc.w	4*($100+_B_DOWN)
	.dc.l	iocs_27_B_DOWN
	.dc.l	0
;_B_RIGHT
	.dc.w	4*($100+_B_RIGHT)
	.dc.l	iocs_28_B_RIGHT
	.dc.l	0
;_B_LEFT
	.dc.w	4*($100+_B_LEFT)
	.dc.l	iocs_29_B_LEFT
	.dc.l	0
;_B_CLR_ST
	.dc.w	4*($100+_B_CLR_ST)
	.dc.l	iocs_2A_B_CLR_ST
	.dc.l	0
;_B_ERA_ST
	.dc.w	4*($100+_B_ERA_ST)
	.dc.l	iocs_2B_B_ERA_ST
	.dc.l	0
;_B_INS
	.dc.w	4*($100+_B_INS)
	.dc.l	iocs_2C_B_INS
	.dc.l	0
;_B_DEL
	.dc.w	4*($100+_B_DEL)
	.dc.l	iocs_2D_B_DEL
	.dc.l	0
;_B_CONSOL
	.dc.w	4*($100+_B_CONSOL)
	.dc.l	iocs_2E_B_CONSOL
	.dc.l	0
;_OS_CURON
	.dc.w	4*($100+_OS_CURON)
	.dc.l	iocs_AE_OS_CURON
	.dc.l	0
;_OS_CUROF
	.dc.w	4*($100+_OS_CUROF)
	.dc.l	iocs_AF_OS_CUROF
	.dc.l	0
;_PUTCHAR
	.dc.w	$1800+4*(_PUTCHAR-$FF00)
	.dc.l	dos_FF02_PUTCHAR
old_putchar:
	.dc.l	0
;_INPOUT
	.dc.w	$1800+4*(_INPOUT-$FF00)
	.dc.l	dos_FF06_INPOUT
old_inpout:
	.dc.l	0
;_PRINT
	.dc.w	$1800+4*(_PRINT-$FF00)
	.dc.l	dos_FF09_PRINT
old_print:
	.dc.l	0
;_FPUTC
	.dc.w	$1800+4*(_FPUTC-$FF00)
	.dc.l	dos_FF1D_FPUTC
old_fputc:
	.dc.l	0
;_FPUTS
	.dc.w	$1800+4*(_FPUTS-$FF00)
	.dc.l	dos_FF1E_FPUTS
old_fputs:
	.dc.l	0
;_CONCTRL
	.dc.w	$1800+4*(_CONCTRL-$FF00)
	.dc.l	dos_FF23_CONCTRL
old_conctrl:
	.dc.l	0
;_WRITE
	.dc.w	$1800+4*(_WRITE-$FF00)
	.dc.l	dos_FF40_WRITE
old_write:
	.dc.l	0
	.dc.w	0

;----------------------------------------------------------------
;NGXgwb_̃AhX
request_header:
	.dc.l	0

;XgeW[`
strategy_routine:
	move.l	a5,request_header
	rts

;C^vg[`
interrupt_routine:
	push	d0-d7/a0-a6
	movea.l	request_header(pc),a5
	moveq.l	#0,d0
	move.b	2(a5),d0		;R}hԍ
	if	<cmp.w #(jump_table_end-jump_table)/2,d0>,hs	;͈͊O
		moveq.l	#(jump_table_end-jump_table)/2,d0
	endif
	add.w	d0,d0
	move.w	jump_table(pc,d0.w),d0
	jsr	jump_table(pc,d0.w)
	move.b	d0,3(a5)		;G[R[h
	lsr.w	#8,d0
	move.b	d0,4(a5)		;G[R[h
	pop
	rts

;foCXR}h̃Wve[u
jump_table:
	.dc.w	initialize-jump_table		;foCXR}h0 
	.dc.w	command_error-jump_table	;foCXR}h1 fBXN`FbN
	.dc.w	command_error-jump_table	;foCXR}h2 BPBe[u̍č\z
	.dc.w	ioctrl_input-jump_table		;foCXR}h3 _IOCTRLɂ
	.dc.w	input-jump_table		;foCXR}h4 
	.dc.w	control_sense-jump_table	;foCXR}h5 Rg[/ZX
	.dc.w	input_status-jump_table		;foCXR}h6 ̓Xe[^X
	.dc.w	input_flush-jump_table		;foCXR}h7 ̓obt@tbV
	.dc.w	output-jump_table		;foCXR}h8 o(xt@CȂ)
	.dc.w	output-jump_table		;foCXR}h9 o(xt@C)
	.dc.w	output_status-jump_table	;foCXR}h10 o̓Xe[^X
	.dc.w	no_error-jump_table		;foCXR}h11 I
	.dc.w	ioctrl_output-jump_table	;foCXR}h12 _IOCTRLɂo
jump_table_end:
	.dc.w	command_error-jump_table	;͈͊O R}hG[

;foCXR}h1 fBXN`FbN
;foCXR}h2 BPBe[u̍č\z
;R}hG[
command_error:
	move.w	#IGNORE|ABORT|UNKNOWN_COMMAND,d0	;(I) ~(A) foCXhCoɖȃR}hw肵܂
	rts

;foCXR}h3 _IOCTRLɂ
ioctrl_input:
;	movea.l	14(a5),a1		;AhX
	goto	command_error

;foCXR}h4 
input:
	movea.l	14(a5),a1		;AhX
	move.l	18(a5),d3		;
	dostart
		clr.w	-(sp)			;1
  .if 0
		DOS	_KEYCTRL
  .else
		movea.l	sp,a6
		movea.l	$1800+4*(_KEYCTRL-$FF00).w,a0
		jsr	(a0)
  .endif
		addq.l	#2,sp
		move.b	d0,(a1)+		;R[h
  .if 0
		break	<cmp.b #13,d0>,eq
  .endif
	start
		subq.l	#1,d3
	while	cc
;	move.l	18(a5),18(a5)		;͂
	moveq.l	#0,d0			;ɐ(I܂ŕAȂ)
	rts

;foCXR}h5 Rg[/ZX
control_sense:
	move.w	#1,-(sp)		;1ZX
  .if 0
	DOS	_KEYCTRL
  .else
	movea.l	sp,a6
	movea.l	$1800+4*(_KEYCTRL-$FF00).w,a0
	jsr	(a0)
  .endif
	addq.l	#2,sp
	move.b	d0,13(a5)		;R[h
	moveq.l	#0,d0			;ɐ
	rts

;foCXR}h6 ̓Xe[^X
input_status:
	move.w	#1,-(sp)		;1ZX
  .if 0
	DOS	_KEYCTRL
  .else
	movea.l	sp,a6
	movea.l	$1800+4*(_KEYCTRL-$FF00).w,a0
	jsr	(a0)
  .endif
	addq.l	#2,sp
	if	<tst.b d0>,ne
		moveq.l	#0,d0			;0=̓obt@ł͂Ȃ̂œ͂ł
	else
		moveq.l	#1,d0			;1=̓obt@Ȃ̂œ͂łȂ
	endif
	rts

;foCXR}h7 ̓obt@tbV
input_flush:
	dostart
		clr.w	-(sp)			;1
  .if 0
		DOS	_KEYCTRL
  .else
		movea.l	sp,a6
		movea.l	$1800+4*(_KEYCTRL-$FF00).w,a0
		jsr	(a0)
  .endif
		addq.l	#2,sp
	start
		move.w	#1,-(sp)		;1ZX
  .if 0
		DOS	_KEYCTRL
  .else
		movea.l	sp,a6
		movea.l	$1800+4*(_KEYCTRL-$FF00).w,a0
		jsr	(a0)
  .endif
		addq.l	#2,sp
	while	<tst.b d0>,ne
	moveq.l	#0,d0			;ɐ
	rts

;foCXR}h8 o(xt@CȂ)
;foCXR}h9 o(xt@C)
output:
	movea.l	14(a5),a1		;AhX
	move.l	18(a5),d3		;
	dostart
		moveq.l	#0,d1
		move.b	(a1)+,d1		;R[h
  .if 0
		move.w	d1,-(sp)
		clr.w	-(sp)			;1\
		DOS	_CONCTRL
		addq.l	#4,sp
  .else
		bsr	putc			;1\
  .endif
	start
		subq.l	#1,d3
	while	cc
;	move.l	18(a5),18(a5)		;o͂
	moveq.l	#0,d0			;ɐ(I܂ŕAȂ)
	rts

;foCXR}h10 o̓Xe[^X
output_status:
	moveq.l	#0,d0			;0=o̓obt@tł͂Ȃ̂ŏo͂ł
;	moveq.l	#1,d0			;1=o̓obt@tȂ̂ŏo͂łȂ
	rts

;foCXR}h11 I
no_error:
	moveq.l	#0,d0			;ɐ
	rts

;foCXR}h12 _IOCTRLɂo
ioctrl_output:
;	movea.l	14(a5),a1		;AhX
	goto	command_error



;hiocs.xDOSR[$FF02,$FF06,$FF09,$FF1D,$FF1E,$FF23,$FF40Bׂď㏑

;----------------------------------------------------------------
;DOSR[$FF02 _PUTCHAR Wo͂1oCgo
;<(a6).w:1oCgf[^
dos_FF02_PUTCHAR:
;Wo͂CON
	bsr	is_stdout_con		;Wo͂CON
	if	pl			;G[Ȃ
		if	ne			;CONł͂Ȃ
		;̏
			movea.l	old_putchar(pc),a0
			jmp	(a0)
		endif
	;o͂
		moveq.l	#0,d1
		move.b	1(a6),d1
		bsr	putchar_to_con		;CON1oCgo͂Bv^o,^S,^P,^N,^C
		moveq.l	#0,d0
	endif
	rts

;----------------------------------------------------------------
;CON1oCgo͂Bv^o,^S,^P,^N,^C
;<d1.l:1oCgf[^
putchar_to_con:
	push	d0-d7/a0-a6
;CON֏o͂
	bsr	putc			;1\
;Wv^֏o͂
	if	<tst.b DOS_CTRL_P_MODE.w>,ne
		move.w	#STDPRN,-(sp)		;Wv^o
		move.w	d1,-(sp)
		movea.l	sp,a6
		movea.l	old_fputc(pc),a0
		jsr	(a0)
		addq.l	#2+2,sp
	endif
;^S
	move.w	#$00FE,-(sp)		;$00FEBW͂̐ǂ݁B0ł߂BBREAK`FbN
	movea.l	sp,a6
	movea.l	old_inpout(pc),a0
	jsr	(a0)
	addq.l	#2,sp
	if	<cmp.w DOS_CTRL_S_CODE.w,d1>,eq	;^Sꂽ
		move.w	#$00FF,-(sp)		;$00FFBW͂́B0ł߂BBREAK`FbN
		movea.l	sp,a6
		movea.l	old_inpout(pc),a0
		jsr	(a0)
		addq.l	#2,sp
  .if 0
		DOS	_INKEY
  .else
		movea.l	$1800+4*(_INKEY-$FF00).w,a0
		jsr	(a0)
  .endif
	endif
;^P,^N,^C
  .if 0
	DOS	_KEYSNS
  .else
	movea.l	$1800+4*(_KEYSNS-$FF00).w,a0
	jsr	(a0)
  .endif
	pop
	rts

;----------------------------------------------------------------
;DOSR[$FF06 _INPOUT Wnhւ̓o
;<(a6).w:1oCgf[^
;	$FE	W͂̐ǂ݁B0ł߂BBREAK`FbN
;	$FF	W͂́B0ł߂BBREAK`FbN
;	̑	Wo͂1oCgo
;>d0.l:͂1oCgf[^
dos_FF06_INPOUT:
;ǂ݂܂͓͂
	if	<cmp.b #$FE,1(a6)>,hs	;ǂ݂܂͓
	;̏
		movea.l	old_inpout(pc),a0
		jmp	(a0)
	endif
;Wo͂CON
	bsr	is_stdout_con		;Wo͂CON
	if	pl			;G[Ȃ
		if	ne			;CONł͂Ȃ
		;̏
			movea.l	old_inpout(pc),a0
			jmp	(a0)
		endif
	;CON֏o͂
		moveq.l	#0,d1
		move.b	1(a6),d1
		bsr	putc			;1\
	;Wv^֏o͂
		if	<tst.b DOS_CTRL_P_MODE.w>,ne
			move.w	#STDPRN,-(sp)		;Wv^o
			move.w	d1,-(sp)
			movea.l	sp,a6
			movea.l	old_fputc(pc),a0
			jsr	(a0)
			addq.l	#2+2,sp
		endif
		moveq.l	#0,d0
	;^S,^P,^N,^C͏Ȃ
	endif
	rts

;----------------------------------------------------------------
;DOSR[$FF09 _PRINT Wo͂ɕo
;<(a6).l:
dos_FF09_PRINT:
;Wo͂CON
	bsr	is_stdout_con		;Wo͂CON
	if	pl			;G[Ȃ
		if	ne			;CONł͂Ȃ
		;̏
			movea.l	old_print(pc),a0
			jmp	(a0)
		endif
	;CON֏o͂
		movea.l	(a6),a1			;
		dostart
			bsr	putchar_to_con		;CON1oCgo͂Bv^o,^S,^P,^N,^C
		start
			moveq.l	#0,d1
			move.b	(a1)+,d1
		while	ne
		moveq.l	#0,d0
	endif
	rts

;----------------------------------------------------------------
;DOSR[$FF1D _FPUTC nh1oCgo
;<(a6).w:
;<2(a6).w:nhԍ
;>d0.l:o͂܂̓G[R[h
dos_FF1D_FPUTC:
;nhCON
	move.w	2(a6),d0		;nhԍ
	bsr	is_handle_con		;nhCON
	if	pl			;G[Ȃ
		if	ne			;CONł͂Ȃ
		;̏
			movea.l	old_fputc(pc),a0
			jmp	(a0)
		endif
	;߂邩
		moveq.l	#$0F,d0
		and.b	14(a0),d0		;t@CI[v[h
		if	ne			;߂
		;CON֏o͂Bv^o,^S,^P,^N,^C͏Ȃ
			moveq.l	#0,d1
			move.b	1(a6),d1		;
			bsr	putc			;1\
			moveq.l	#1,d0			;o͂
		else				;߂Ȃ
			moveq.l	#INVALID_ACCESS_MODE,d0	;I[ṽANZX[hُ
		endif
	endif
	rts

;----------------------------------------------------------------
;DOSR[$FF1E _FPUTS nh֕o
;<(a6).l:
;<4(a6).w:nhԍ
;>d0.l:o͂܂̓G[R[h
dos_FF1E_FPUTS:
;̒0
	movea.l	(a6),a0			;
	tst.b	(a0)
	if	eq			;̒0
	;nhԍɊ֌WȂI
		moveq.l	#0,d0			;o͂
	else				;̒0ł͂Ȃ
	;nhCON
		move.w	4(a6),d0		;nhԍ
		bsr	is_handle_con		;nhCON
		if	pl			;G[Ȃ
			if	ne			;CONł͂Ȃ
			;̏
				movea.l	old_fputs(pc),a0
				jmp	(a0)
			endif
		;߂邩
			moveq.l	#$0F,d0
			and.b	14(a0),d0		;t@CI[v[h
			if	ne			;߂
			;CON֏o͂Bv^o,^S,^P,^N,^C͏Ȃ
				movea.l	(a6),a1			;
				move.l	a1,d0
				dostart
					bsr	putc			;1\
				start
					moveq.l	#0,d1
					move.b	(a1)+,d1
				while	ne
				subq.l	#1,a1
				exg.l	d0,a1
				sub.l	a1,d0			;o͂
			else				;߂Ȃ
				moveq.l	#INVALID_ACCESS_MODE,d0	;I[ṽANZX[hُ
			endif
		endif
	endif
	rts

;----------------------------------------------------------------
;DOSR[$FF23 _CONCTRL R\[o͂̐
;<(a6).w:[h
;	0	1\
;			<2(a6).w:1oCgf[^
;	1	\
;			<2(a6).l:
;	2	̐ݒ
;			<2(a6).w:
;	3	J[\̈ړ
;			<2(a6).w:XW
;			<4(a6).w:YW
;	4	J[\1sֈړ([ł̓XN[Abv)
;	5	J[\1sֈړ([ł̓XN[_E)
;	6	J[\Nsֈړ
;			<2(a6).w:N
;	7	J[\Nsֈړ
;			<2(a6).w:N
;	8	J[\NEֈړ
;			<2(a6).w:N
;	9	J[\Nֈړ
;			<2(a6).w:N
;	10	ʏ
;			<2(a6).w:[h
;				0
;				1
;				2
;	11	s
;			<2(a6).w:[h
;				0
;				1
;				2
;	12	Ns}
;			<2(a6).w:N
;	13	Ns폜
;			<2(a6).w:N
;	14	t@NV\s̃[h̎擾Ɛݒ
;			<2(a6).w:[h
;				-1	擾
;				0	m[}
;				1	Vtg
;				2	\Ȃ
;				3	ʂ̍s
;	15	XN[͈͂̐ݒ
;			<2(a6).w:XN[͈͂̊JnsYW
;			<4(a6).w:XN[͈͂̍s
;	16	ʃ[h̐ݒ
;			<2(a6).w:ʃ[h
;				0	768x512,OtBbNȂ
;				1	768x512,OtBbN16F
;				2	512x512,OtBbNȂ
;				3	512x512,OtBbN16F
;				4	512x512,OtBbN256F
;				5	512x512,OtBbN65536F
;	17	J[\\
;	18	J[\
dos_FF23_CONCTRL:
	move.w	(a6),d0			;[h
	if	<cmp.w #13,d0>,hi	;IOCSR[ȊO
	;̏
		movea.l	old_conctrl(pc),a0
		jmp	(a0)
	endif
	movea.l	2(a6),a1
	move.l	a1,d1
	swap.w	d1
	move.l	a1,d2
	add.w	d0,d0
	move.w	100f(pc,d0.w),d0
	jmp	100f(pc,d0.w)
100:
	.dc.w	iocs_20_B_PUTC-100b
	.dc.w	iocs_21_B_PRINT-100b
	.dc.w	iocs_22_B_COLOR-100b
	.dc.w	iocs_23_B_LOCATE-100b
	.dc.w	iocs_24_B_DOWN_S-100b
	.dc.w	iocs_25_B_UP_S-100b
	.dc.w	iocs_26_B_UP-100b
	.dc.w	iocs_27_B_DOWN-100b
	.dc.w	iocs_28_B_RIGHT-100b
	.dc.w	iocs_29_B_LEFT-100b
	.dc.w	iocs_2A_B_CLR_ST-100b
	.dc.w	iocs_2B_B_ERA_ST-100b
	.dc.w	iocs_2C_B_INS-100b
	.dc.w	iocs_2D_B_DEL-100b

;----------------------------------------------------------------
;DOSR[$FF40 _WRITE nh֎w肳ꂽTCỸf[^
;<(a6).w:nhԍ
;<2(a6).l:
;<6(a6).l:̒
;>d0.l:o͂
dos_FF40_WRITE:
;nhCON
	move.w	(a6),d0			;nhԍ
	bsr	is_handle_con		;nhCON
	if	pl			;G[Ȃ
		if	ne			;CONł͂Ȃ
		;̏
			movea.l	old_write(pc),a0
			jmp	(a0)
		endif
	;߂邩
		moveq.l	#$0F,d0
		and.b	14(a0),d0		;t@CI[v[h
		if	ne			;߂
		;CON֏o͂Bv^o,^S,^P,^N,^C
			movea.l	2(a6),a1		;
			move.l	6(a6),d0		;̒
			move.l	d0,d2
			dostart
				moveq.l	#0,d1
				move.b	(a1)+,d1
				bsr	putchar_to_con		;CON1oCgo͂Bv^o,^S,^P,^N,^C
			start
				subq.l	#1,d2
			while	cc
		else				;߂Ȃ
			moveq.l	#INVALID_ACCESS_MODE,d0	;I[ṽANZX[hُ
		endif
	endif
	rts

;----------------------------------------------------------------
;Wo͂CON
;>d0.l:FCBe[u܂̓G[R[h
;>a0.l:FCBe[u
;>n:pl=G[Ȃ,mi=G[
;>z:ne=CONł͂Ȃ,eq=CON
;?d1-d7/a1-a5
is_stdout_con:
	moveq.l	#1,d0
;----------------------------------------------------------------
;nhCON
;<d0.w:nhԍ
;>d0.l:FCBe[u܂̓G[R[h
;>a0.l:FCBe[u
;>n:pl=G[Ȃ,mi=G[
;>z:ne=CONł͂Ȃ,eq=CON
;?d1-d7/a1-a5
is_handle_con:
  .if 0
	move.w	d0,-(sp)
	DOS	_GETFCB
	addq.l	#2,sp
  .else
	push	a6
	move.w	d0,-(sp)
	movea.l	sp,a6
	movea.l	$1800+4*(_GETFCB-$FF00).w,a0
	jsr	(a0)
	addq.l	#2,sp
	pop
  .endif
	if	<tst.l d0>,pl		;G[Ȃ
		movea.l	d0,a0			;FCBe[u
		if	<tst.b 1(a0)>,mi	;LN^foCX
			cmpi.l	#'CON ',36(a0)		;foCX܂̓t@C1
		endif
	endif
	rts



;R\[g
BIOS_ATTRIBUTE_2	equ	$0D30		;.b 2B-|t|t||ۈ͂|lp͂|v|[Vi|g
BIOS_SUPERSCRIPT_BIT	equ	 6		;t
BIOS_SUPERSCRIPT	equ	%01000000
BIOS_SUBSCRIPT_BIT	equ	  5		;t
BIOS_SUBSCRIPT		equ	%00100000
BIOS_OVERLINE_BIT	equ	    4		;
BIOS_OVERLINE		equ	%00010000
BIOS_ENCIRCLE_BIT	equ	     3		;ۈ͂
BIOS_ENCIRCLE		equ	%00001000
BIOS_FRAME_BIT		equ	      2		;lp͂
BIOS_FRAME		equ	%00000100
BIOS_PROPORTIONAL_BIT	equ	       1	;v|[Vi
BIOS_PROPORTIONAL	equ	%00000010
BIOS_WAVELINE_BIT	equ	        0	;g
BIOS_WAVELINE		equ	%00000001
BIOS_CURSOR_FRACTION	equ	$0D31		;.b J[\̌W̒[B0`7
BIOS_SAVED_ATTRIBUTE_2	equ	$0D32		;.b ESC [sŕۑꂽ2
BIOS_SAVED_FRACTION	equ	$0D33		;.b ESC [sŕۑꂽJ[\̌W̒[
BIOS_BUFFER_REQUEST	equ	$0D34		;.w obt@̕\̈̃hbgB0=obt@o͒ł͂Ȃ
BIOS_BUFFER_WIDTH	equ	$0D36		;.w obt@̃̕hbg
BIOS_BUFFER_POINTER	equ	$0D38		;.l obt@݈̏ʒu
BIOS_BUFFER_ARRAY	equ	$0D3C		;.w[64] obt@BE񂹁A񂹂Ŏg
BIOS_CONSOLE_STATUS	equ	$0DBC		;.b R\[̏ԁB----|||E|A
BIOS_ALIGN_LEFT_BIT	equ	     3		;
BIOS_ALIGN_LEFT		equ	%00001000
BIOS_ALIGN_CENTER_BIT	equ	      2		;
BIOS_ALIGN_CENTER	equ	%00000100
BIOS_ALIGN_RIGHT_BIT	equ	       1	;E
BIOS_ALIGN_RIGHT	equ	%00000010
BIOS_CONNECTION_BIT	equ	        0	;ABŌɕ`悵͎Α̂ł̌J[\𓮂ĂȂBΑ̂Ȃ΋l߂ĕ`悷
BIOS_CONNECTION		equ	%00000001
;				$0DBD		;.b[3]

;----------------------------------------------------------------
;J[\_ŏ[`
;	Timer-C荞݃[`500msԊuŌĂ΂
timer_c_cursor:
	if	<tst.b BIOS_CURSOR_ON.w>,ne	;J[\\Ƃ
		ifor	<tst.w BIOS_CURSOR_NOT_BLINK.w>,eq,<tst.b BIOS_CURSOR_DRAWN.w>,eq	;_ł邩A`ĂȂƂ
			if	<btst.b #1,CRTC_ACCESS>,eq	;CRTC̃}XNgpłȂƂ
				bsr	toggle_cursor		;J[\𔽓]
				not.b	BIOS_CURSOR_DRAWN.w	;J[\`Ă邩B0=`ĂȂ,-1=`Ă
			endif
		endif
	endif
	rts

;----------------------------------------------------------------
;J[\𔽓]
toggle_cursor:
	push	d0-d2/a0-a2
	move.w	BIOS_CURSOR_ROW.w,d0	;J[\̍sW
	swap.w	d0
	clr.w	d0			;65536*sW
	lsr.l	#5,d0			;128*16*sW
	move.w	BIOS_CURSOR_COLUMN.w,d1	;J[\̌W
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d1>,hi
		move.w	BIOS_CONSOLE_RIGHT.w,d1	;E[Ŏ~܂
	endif
	add.w	d1,d0
	add.l	BIOS_CONSOLE_OFFSET.w,d0
	add.l	#$00E00000,d0		;J[\̃AhX
	movea.l	d0,a2
	move.w	CRTC_ACCESS,-(sp)
	bclr.b	#0,CRTC_ACCESS		;ANZXOFF
***	move.w	BIOS_CURSOR_PATTERN.w,d1
***	if	eq
***		moveq.l	#-1,d1
***	endif
	moveq.l	#$80,d1
	move.b	BIOS_CURSOR_FRACTION.w,d0
	lsr.b	d0,d1
	bsr	toggle_cursor_1		;v[0𔽓]
***	lsr.w	#8,d1
	adda.l	#$00020000,a2
	bsr	toggle_cursor_1		;v[1𔽓]
	move.w	(sp)+,CRTC_ACCESS
	pop
	rts

toggle_cursor_1:
	move.w	BIOS_CURSOR_START.w,d2	;J[\`JnC*4
	jmp	@f(pc,d2.w)
@@:	eor.b	d1,(a2)
	movea.l	a0,a0			;nop
  .irp row,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15
	eor.b	d1,128*row(a2)
  .endm
	rts

;----------------------------------------------------------------
;IOCSR[$1E _B_CURON J[\\
iocs_1E_B_CURON:
	ifand	<tst.b BIOS_CURSOR_PROHIBITED.w>,eq,<tst.b BIOS_CURSOR_ON.w>,eq	;Ăĕ\ĂȂƂ
		move.w	#5,BIOS_TC_CURSOR_COUNTER.w	;^C}JE^B1ڂ10ms*5=50msɔ
		st.b	BIOS_CURSOR_ON.w	;\Ă
		clr.b	BIOS_CURSOR_DRAWN.w	;`ĂȂ
	endif
	rts

;----------------------------------------------------------------
;IOCSR[$1F _B_CUROFF J[\\Ȃ
iocs_1F_B_CUROFF:
	if	<tst.b BIOS_CURSOR_PROHIBITED.w>,eq	;ĂƂ
		move.w	#5,BIOS_TC_CURSOR_COUNTER.w	;^C}JE^B1ڂ10ms*5=50msɔ
		clr.b	BIOS_CURSOR_ON.w	;\ĂȂ
		if	<tst.b BIOS_CURSOR_DRAWN.w>,ne	;`ĂƂ
			bsr	toggle_cursor		;J[\𔽓]
			clr.b	BIOS_CURSOR_DRAWN.w	;`ĂȂ
		endif
	endif
	rts

;----------------------------------------------------------------
;IOCSR[$20 _B_PUTC \
;<d1.w:R[h
;>d0.l:\̃J[\̌W<<16|J[\̍sW
iocs_20_B_PUTC:
	bsr	putc			;1\
	move.l	BIOS_CURSOR_COLUMN.w,d0	;J[\̌W<<16|J[\̍sW
	rts

;----------------------------------------------------------------
;IOCSR[$21 _B_PRINT \
;<a1.l:̃AhX
;>d0.l:\̃J[\̌W<<16|J[\̍sW
;>a1.l:̖0̎̃AhXB}jAɏĂBύXs
iocs_21_B_PRINT:
	push	d1
	dostart
		bsr	putc			;1\
	start
		moveq.l	#0,d1
		move.b	(a1)+,d1
	while	ne
	pop
	move.l	BIOS_CURSOR_COLUMN.w,d0	;J[\̌W<<16|J[\̍sW
	rts

;----------------------------------------------------------------
;IOCSR[$22 _B_COLOR ݒ肷
;<d1.w:B-1=擾̂
;	0	
;	1	F
;	2	F
;	3	
;	4+	
;	8+	]
;>d0.l:ݒO̕B-1=ݒl͈͊O
iocs_22_B_COLOR:
	push	d1
	moveq.l	#0,d0
	move.b	BIOS_ATTRIBUTE_1.w,d0	;2B-|t|t||ۈ͂|lp͂|v|[Vi|g
	lsl.w	#8,d0
	move.b	BIOS_ATTRIBUTE_1.w,d0	;1B||Α|׎|]||v[##
	if	<cmp.w #-1,d1>,ne	;ݒ肷Ƃ
		if	<cmp.w #$7FFF,d1>,ls	;ݒl͈͓̂Ƃ
			move.b	d1,BIOS_ATTRIBUTE_1.w
			lsr.w	#8,d1
			move.b	d1,BIOS_ATTRIBUTE_2.w
		else				;ݒl͈͊ÔƂ
			moveq.l	#-1,d0
		endif
	endif
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$23 _B_LOCATE J[\̍Wݒ肷
;<d1.w:J[\̌W̒[<<8|J[\̌WB-1=擾̂
;<d2.w:J[\̍sW
;>d0.l:ݒÕJ[\̍WBJ[\̌W̒[<<24|J[\̌W<<16|J[\̍sWB-1=ݒl͈͊O
;>d1.l:(IOCS.X,1.3ȏ)擾݂̂̂Ƃd0.lƓ
iocs_23_B_LOCATE:
	moveq.l	#0,d0
	move.b	BIOS_CURSOR_FRACTION.w,d0
	ror.l	#8,d0
	or.l	BIOS_CURSOR_COLUMN.w,d0	;BIOS_CURSOR_ROWBJ[\̌W̒[<<24|J[\̌W<<16|J[\̍sW
	if	<cmp.w #-1,d1>,eq	;擾̂
		move.l	d0,d1
		rts
	endif
	push	d1/d3
	move.w	d1,d3
	and.w	#$00FF,d1		;J[\̌W
	lsr.w	#8,d3			;J[\̌W̒[
	ifand	<cmp.w BIOS_CONSOLE_RIGHT.w,d1>,ls,<cmp.w BIOS_CONSOLE_BOTTOM.w,d2>,ls,<cmp.w #7,d3>,ls	;ݒl͈͓̂Ƃ
;		push	d0
		bsr	iocs_1F_B_CUROFF
		move.w	d1,BIOS_CURSOR_COLUMN.w
		move.w	d2,BIOS_CURSOR_ROW.w
		move.b	d3,BIOS_CURSOR_FRACTION.w
		bsr	iocs_1E_B_CURON
;		pop	d0
	else				;ݒl͈͊ÔƂ
		moveq.l	#-1,d0
	endif
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$24 _B_DOWN_S J[\1sցB[ł̓XN[Abv
;>d0.l:0
iocs_24_B_DOWN_S:
	push	d1-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
		addq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	else				;[̂Ƃ
		moveq.l	#1,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
		moveq.l	#0,d2			;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
		move.w	d0,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	bsr	iocs_1E_B_CURON
	pop
	moveq.l	#0,d0
	rts

;----------------------------------------------------------------
;IOCSR[$25 _B_UP_S J[\1sցB[ł̓XN[_E
;>d0.l:0
iocs_25_B_UP_S:
	push	d1-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	<tst.w d0>,hi	;[ł͂ȂƂ
		subq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	else				;[̂Ƃ
		moveq.l	#0,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1
		subq.w	#1,d1			;Rs[̉[̍sW
		moveq.l	#1,d2			;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		moveq.l	#0,d0			;[̍sW
		moveq.l	#0,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	bsr	iocs_1E_B_CURON
	pop
	moveq.l	#0,d0
	rts

;----------------------------------------------------------------
;IOCSR[$26 _B_UP J[\nsցB[𒴂Ƃ͓Ȃ
;<d1.b:ړsB0=1s
;>d0.l:0=,-1=sB[𒴂B̂ƂJ[\͓Ȃ
iocs_26_B_UP:
	push	d1
	bsr	iocs_1F_B_CUROFF
	and.w	#$00FF,d1
	if	eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CURSOR_ROW.w,d0	;J[\̍sW
	sub.w	d1,d0			;ns
	if	mi			;[𒴂
		moveq.l	#-1,d1
	else				;[𒴂Ȃ
		move.w	d0,BIOS_CURSOR_ROW.w
		moveq.l	#0,d1
	endif
	bsr	iocs_1E_B_CURON
	move.l	d1,d0
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$27 _B_DOWN J[\nsցB[Ŏ~܂
;<d1.b:ړsB0=1s
;>d0.l:0
iocs_27_B_DOWN:
	push	d1
	bsr	iocs_1F_B_CUROFF
	and.w	#$00FF,d1
	if	eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CURSOR_ROW.w,d0	;J[\̍sW
	add.w	d1,d0			;ns
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,hi	;[𒴂
		move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[Ŏ~܂
	endif
	move.w	d0,BIOS_CURSOR_ROW.w
	bsr	iocs_1E_B_CURON
	pop
	moveq.l	#0,d0
	rts

;----------------------------------------------------------------
;IOCSR[$28 _B_RIGHT J[\nEցBE[Ŏ~܂
;<d1.w:ړ錅B0=1
;>d0.l:0
iocs_28_B_RIGHT:
	push	d1
	bsr	iocs_1F_B_CUROFF
	and.w	#$00FF,d1
	if	eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CURSOR_COLUMN.w,d0	;J[\̌W
	add.w	d1,d0			;nsE
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d0>,hi	;E[𒴂
		move.w	BIOS_CONSOLE_RIGHT.w,d0	;E[Ŏ~܂
	endif
	move.w	d0,BIOS_CURSOR_COLUMN.w
	clr.b	BIOS_CURSOR_FRACTION.w
	bsr	iocs_1E_B_CURON
	pop
	moveq.l	#0,d0
	rts

;----------------------------------------------------------------
;IOCSR[$29 _B_LEFT J[\nցB[Ŏ~܂
;<d1.w:ړ錅B0=1
;>d0.l:0
iocs_29_B_LEFT:
	push	d1
	bsr	iocs_1F_B_CUROFF
	and.w	#$00FF,d1
	if	eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CURSOR_COLUMN.w,d0	;J[\̌W
	sub.w	d1,d0			;ns
	if	mi			;[𒴂
		clr.w	d0			;[Ŏ~܂
	endif
	move.w	d0,BIOS_CURSOR_COLUMN.w
	clr.b	BIOS_CURSOR_FRACTION.w
	bsr	iocs_1E_B_CURON
	pop
	moveq.l	#0,d0
	rts

;----------------------------------------------------------------
;IOCSR[$2A _B_CLR_ST ͈͂Iĉʂ
;<d1.b:͈́B0=J[\E܂,1=ォJ[\܂,2=ォE܂ŁBJ[\
;>d0.l:0=,-1=sB
iocs_2A_B_CLR_ST:
	push	d1
	bsr	iocs_1F_B_CUROFF
	if	<subq.b #1,d1>,lo	;0=J[\E܂
		bsr	putc_csi_0J		;ESC [0J J[\E܂ŏ
		moveq.l	#0,d1
	elif	eq			;1=ォJ[\܂
		bsr	putc_csi_1J		;ESC [1J ォJ[\܂ŏ
		moveq.l	#0,d1
	elif	<subq.b #3-1,d1>,lo	;2=ォE܂
		bsr	putc_csi_2J		;ESC [2J ォE܂ŏBJ[\
		moveq.l	#0,d1
	else
		moveq.l	#-1,d1
	endif
	bsr	iocs_1E_B_CURON
	move.l	d1,d0
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$2B _B_ERA_ST ͈͂Ičs
;<d1.b:͈́B0=J[\E[܂,1=[J[\܂,2=[E[܂
;>d0.l:0=,-1=sB
iocs_2B_B_ERA_ST:
	push	d1
	bsr	iocs_1F_B_CUROFF
	if	<subq.b #1,d1>,lo	;0=J[\E[܂
		bsr	putc_csi_0K		;ESC [0K J[\E[܂ŏ
		moveq.l	#0,d1
	elif	eq			;1=[J[\܂
		bsr	putc_csi_1K		;ESC [1K [J[\܂ŏ
		moveq.l	#0,d1
	elif	<subq.b #3-1,d1>,lo	;2=[E[܂
		bsr	putc_csi_2K		;ESC [2K [E[܂ŏ
		moveq.l	#0,d1
	else				;
		moveq.l	#-1,d1
	endif
	bsr	iocs_1E_B_CURON
	move.l	d1,d0
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$2C _B_INS J[\牺ns}BJ[\[
;<d1.w:}sB0=1s
;>d0.l:0
iocs_2C_B_INS:
	push	d1
	bsr	iocs_1F_B_CUROFF
	bsr	putc_csi_L		;ESC [nL J[\牺ns}BJ[\[
	bsr	iocs_1E_B_CURON
	moveq.l	#0,d0
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$2D _B_DEL J[\牺ns폜BJ[\[
;<d1.w:폜sB0=1s
;>d0.l:0
iocs_2D_B_DEL:
	push	d1
	bsr	iocs_1F_B_CUROFF
	bsr	putc_csi_M		;ESC [nM J[\牺ns폜BJ[\[
	bsr	iocs_1E_B_CURON
	moveq.l	#0,d0
	pop
	rts

;----------------------------------------------------------------
;IOCSR[$2E _B_CONSOL R\[͈̔͂ݒBJ[\
;<d1.l:XhbgW<<16|YhbgWB-1=擾̂݁BXhbgW8̔{AYhbgW4̔{
;<d2.l:E[̌W<<16|[̍sWB-1=擾̂
;>d0.l:0
;>d1.l:ݒO̍XhbgW<<16|YhbgW
;>d2.l:ݒỎE[̌W<<16|[̍sW
iocs_2E_B_CONSOL:
	bsr	iocs_1F_B_CUROFF
	move.l	BIOS_CONSOLE_OFFSET.w,d0
	if	<cmp.l #-1,d1>,ne
		and.l	#($03F8<<16)|$03FC,d1
		move.l	d1,d0
		swap.w	d0		;XhbgW
		lsr.w	#3,d0		;XhbgW/8
		ext.l	d1
		lsl.l	#7,d1		;YhbgW*128
		add.w	d0,d1
		move.l	BIOS_CONSOLE_OFFSET.w,d0
		move.l	d1,BIOS_CONSOLE_OFFSET.w
		clr.l	BIOS_CURSOR_COLUMN.w	;BIOS_CURSOR_ROW.wBJ[\
	endif
	moveq.l	#127,d1
	and.w	d0,d1			;XhbgW/8
	lsl.w	#3,d1			;XhbgW
	swap.w	d1
	lsr.l	#7,d0			;YhbgW
	move.w	d0,d1			;ݒO̍XhbgW<<16|YhbgW
	move.l	BIOS_CONSOLE_RIGHT.w,d0	;BIOS_CONSOLE_BOTTOM.w
	if	<cmp.l #-1,d2>,ne
		and.l	#127<<16|63,d2
		move.l	d2,BIOS_CONSOLE_RIGHT.w	;BIOS_CONSOLE_BOTTOM.w
		clr.l	BIOS_CURSOR_COLUMN.w	;BIOS_CURSOR_ROW.wBJ[\
	endif
	move.l	d0,d2			;ݒỎE[̌W<<16|[̍sW
	bsr	iocs_1E_B_CURON
	moveq.l	#0,d0
	rts

;----------------------------------------------------------------
;IOCSR[$AE _OS_CURON J[\̕\
iocs_AE_OS_CURON:
	move.w	BIOS_TC_CURSOR_PERIOD.w,BIOS_TC_CURSOR_COUNTER.w	;^C}JE^lɂ
	di				;݋֎~
	ifor	<tst.b BIOS_CURSOR_PROHIBITED.w>,ne,<tst.b BIOS_CURSOR_DRAWN.w>,eq	;֎~Ă邩`ĂȂƂ
		bsr	toggle_cursor		;J[\𔽓]
		st.b	BIOS_CURSOR_DRAWN.w	;`Ă
	endif
	st.b	BIOS_CURSOR_ON.w		;\Ă
	sf.b	BIOS_CURSOR_PROHIBITED.w	;Ă
	ei				;荞݋
	rts

;----------------------------------------------------------------
;IOCSR[$AF _OS_CUROF J[\̕\֎~
iocs_AF_OS_CUROF:
	bsr	iocs_1F_B_CUROFF
	st.b	BIOS_CURSOR_PROHIBITED.w	;֎~Ă
	rts

;----------------------------------------------------------------
;1\
;<d1.w:R[h
putc:
	push	d0-d1
	if	<move.b BIOS_PUTC_POOL.w,d0>,eq	;1oCgڂ̂Ƃ
		if	<cmp.w #$001F,d1>,ls	;$0000`$001F̂Ƃ
			bsr	putc_control		;䕶
		elif	<cmp.w #$007F,d1>,ls	;$0020`$007F̂Ƃ
			if	<cmp.w #$005C,d1>,eq	;$005ĈƂ
				if	<btst.b #0,SRAM_XCHG>,ne	;ϊtOB-----|$7Cb/$82U|$7EP/$81`|$5C/$80_
					move.w	#$0080,d1		;$5C$80
				endif
			elif	<cmp.w #$007E,d1>,eq	;$007ÊƂ
				if	<btst.b #1,SRAM_XCHG>,ne	;ϊtOB-----|$7Cb/$82U|$7EP/$81`|$5C/$80_
					move.w	#$0081,d1		;$7E$81
				endif
			elif	<cmp.w #$007C,d1>,eq	;$007ĈƂ
				if	<btst.b #2,SRAM_XCHG>,ne	;ϊtOB-----|$7Cb/$82U|$7EP/$81`|$5C/$80_
					move.w	#$0082,d1		;$7C$82
				endif
			endif
			bsr	putc_output		;ʂɕ`܂̓obt@ɏo͂
		elif	<cmp.w #$009F,d1>,ls	;$0080`$009F̂Ƃ
			move.b	d1,BIOS_PUTC_POOL.w	;1oCgڂ̃v[
		elif	<cmp.w #$00DF,d1>,ls	;$00A0`$00DF̂Ƃ
			bsr	putc_output		;ʂɕ`܂̓obt@ɏo͂
		elif	<cmp.w #$00FF,d1>,ls	;$00E0`$00FF̂Ƃ
			move.b	d1,BIOS_PUTC_POOL.w	;1oCgڂ̃v[
		else				;$0100`$FFFF̂Ƃ
			bsr	putc_output		;ʂɕ`܂̓obt@ɏo͂
		endif
	else				;2oCgڂ̂Ƃ
		if	<cmp.b #$1B,d0>,eq	;1oCgڂ$1B̂ƂBGXP[vV[PX̏o͒
			bsr	putc_escape		;GXP[vV[PX
		else				;1oCgڂ$1Bł͂ȂƂ
			clr.b	BIOS_PUTC_POOL.w	;1oCgڂ
			lsl.w	#8,d0			;1oCg<<8
			move.b	d1,d0			;1oCg<<8|2oCg
			move.w	d0,d1			;1oCg<<8|2oCgځB1oCgڂƂd1.w̏ʃoCg͖
			bsr	putc_output		;ʂɕ`܂̓obt@ɏo͂
		endif
	endif
	pop
	rts

;----------------------------------------------------------------
;obt@o͂I
putc_finish_buffer:
	push	d0-d6/a0-a1
	move.w	BIOS_BUFFER_REQUEST.w,d0
	goto	eq,putc_finish_buffer_end	;obt@o͒ł͂Ȃ
;<d0.w:obt@̕\̈̃hbg
	move.w	BIOS_BUFFER_WIDTH.w,d1
;<d1.w:obt@̃̕hbg
	movea.l	BIOS_BUFFER_POINTER.w,a0
;<a0.l:obt@݈̏ʒu=̒
	lea.l	BIOS_BUFFER_ARRAY.w,a1
;<a1.l:obt@=̐擪
	clr.w	BIOS_BUFFER_REQUEST.w	;obt@o͏IBċAĂяoŕ\̂ł̑OɏI邱
	clr.w	BIOS_BUFFER_WIDTH.w
	move.l	a1,BIOS_BUFFER_POINTER.w
	sub.w	d1,d0			;]hbg
;<d0.w:]hbg
	if	ls			;]ȂƂ
	;\
		do
			move.w	(a1)+,d1
			bsr	putc_output
		while	<cmpa.w a0,a1>,lo
	elif	<bclr.b #BIOS_ALIGN_LEFT_BIT,BIOS_CONSOLE_STATUS.w>,ne	;񂹂ŗ]Ƃ
	;\
		do
			move.w	(a1)+,d1
			bsr	putc_output
		while	<cmpa.w a0,a1>,lo
	;E̗]͈͂
		moveq.l	#0,d4
		move.b	BIOS_CURSOR_FRACTION.w,d4	;d4=[̌W̒[
		add.w	d4,d0
		subq.w	#1,d0
		moveq.l	#7,d5
		and.w	d0,d5				;d5=E[̌W̒[
		lsr.w	#3,d0
		move.w	BIOS_CURSOR_COLUMN.w,d2		;d2=[̌W
		add.w	d2,d0
		move.w	d0,d3				;d3=E[̌W
		move.w	BIOS_CURSOR_ROW.w,d0		;d0=[̍sW
		move.w	d0,d1				;d1=[̍sW
		bsr	putc_clear
	;J[\𓮂
		addq.w	#1,d5
		if	<cmp.w #8,d5>,hs
			subq.w	#8,d5
			addq.w	#1,d3
		endif
		move.w	d3,BIOS_CURSOR_COLUMN.w
		move.b	d5,BIOS_CURSOR_FRACTION.w
	elif	<bclr.b #BIOS_ALIGN_RIGHT_BIT,BIOS_CONSOLE_STATUS.w>,ne	;E񂹂ŗ]Ƃ
	;̗]͈͂
		moveq.l	#0,d4
		move.b	BIOS_CURSOR_FRACTION.w,d4	;d4=[̌W̒[
		add.w	d4,d0
		subq.w	#1,d0
		moveq.l	#7,d5
		and.w	d0,d5				;d5=E[̌W̒[
		lsr.w	#3,d0
		move.w	BIOS_CURSOR_COLUMN.w,d2		;d2=[̌W
		add.w	d2,d0
		move.w	d0,d3				;d3=E[̌W
		move.w	BIOS_CURSOR_ROW.w,d0		;d0=[̍sW
		move.w	d0,d1				;d1=[̍sW
		bsr	putc_clear
	;J[\𓮂
		addq.w	#1,d5
		if	<cmp.w #8,d5>,hs
			subq.w	#8,d5
			addq.w	#1,d3
		endif
		move.w	d3,BIOS_CURSOR_COLUMN.w
		move.b	d5,BIOS_CURSOR_FRACTION.w
	;\
		do
			move.w	(a1)+,d1
			bsr	putc_output
		while	<cmpa.w a0,a1>,lo
	elif	<bclr.b #BIOS_ALIGN_CENTER_BIT,BIOS_CONSOLE_STATUS.w>,ne	;񂹂ŗ]Ƃ
	;̗]͈͂
		move.w	d0,d6
		lsr.w	#1,d0			;̗]͈͂̃hbg
		sub.w	d0,d6			;E̗]͈͂̃hbg
		moveq.l	#0,d4
		move.b	BIOS_CURSOR_FRACTION.w,d4	;d4=[̌W̒[
		add.w	d4,d0
		subq.w	#1,d0
		moveq.l	#7,d5
		and.w	d0,d5				;d5=E[̌W̒[
		lsr.w	#3,d0
		move.w	BIOS_CURSOR_COLUMN.w,d2		;d2=[̌W
		add.w	d2,d0
		move.w	d0,d3				;d3=E[̌W
		move.w	BIOS_CURSOR_ROW.w,d0		;d0=[̍sW
		move.w	d0,d1				;d1=[̍sW
		bsr	putc_clear
	;J[\𓮂
		addq.w	#1,d5
		if	<cmp.w #8,d5>,hs
			subq.w	#8,d5
			addq.w	#1,d3
		endif
		move.w	d3,BIOS_CURSOR_COLUMN.w
		move.b	d5,BIOS_CURSOR_FRACTION.w
	;\
		do
			move.w	(a1)+,d1
			bsr	putc_output
		while	<cmpa.w a0,a1>,lo
	;E̗]͈͂
		move.w	d6,d0
		moveq.l	#0,d4
		move.b	BIOS_CURSOR_FRACTION.w,d4	;d4=[̌W̒[
		add.w	d4,d0
		subq.w	#1,d0
		moveq.l	#7,d5
		and.w	d0,d5				;d5=E[̌W̒[
		lsr.w	#3,d0
		move.w	BIOS_CURSOR_COLUMN.w,d2		;d2=[̌W
		add.w	d2,d0
		move.w	d0,d3				;d3=E[̌W
		move.w	BIOS_CURSOR_ROW.w,d0		;d0=[̍sW
		move.w	d0,d1				;d1=[̍sW
		bsr	putc_clear
	;J[\𓮂
		addq.w	#1,d5
		if	<cmp.w #8,d5>,hs
			subq.w	#8,d5
			addq.w	#1,d3
		endif
		move.w	d3,BIOS_CURSOR_COLUMN.w
		move.b	d5,BIOS_CURSOR_FRACTION.w
	endif
putc_finish_buffer_end:
	pop
	rts

;----------------------------------------------------------------
;䕶
;<d1.w:R[h
putc_control:
	push	d0-d1
;obt@o͂I
	if	<tst.w BIOS_BUFFER_REQUEST.w>,ne	;obt@o͒
		bsr	putc_finish_buffer	;obt@o͂I
	endif
;J[\E[͂ݏoĂƂBSłȂΉs
	move.w	BIOS_CURSOR_COLUMN.w,d0	;J[\̌W
	ifand	<cmp.w BIOS_CONSOLE_RIGHT.w,d0>,hi,<cmp.w #$0008,d1>,ne	;J[\E[͂ݏoĂ邩BSł͂ȂƂ
		move.w	BIOS_CURSOR_ROW.w,d0
		if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
			addq.w	#1,d0			;1s
			move.w	d0,BIOS_CURSOR_ROW.w
		else				;[̂Ƃ
			moveq.l	#1,d0			;Rs[̏[̍sW
			move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
			moveq.l	#0,d2			;Rs[̏[̍sW
			bsr	putc_copy_rows		;sRs[
			move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
			move.w	d0,d1			;[̍sW
			bsr	putc_clear_rows		;s
		endif
		clr.w	BIOS_CURSOR_COLUMN.w	;[
		clr.b	BIOS_CURSOR_FRACTION.w
	endif
;䕶
	add.w	d1,d1
	move.w	putc_control_jump_table(pc,d1.w),d1
	jsr	putc_control_jump_table(pc,d1.w)
	pop
	rts

putc_control_jump_table:
	.dc.w	putc_00_NL-putc_control_jump_table	;䕶$00 NL 
	.dc.w	putc_01_SH-putc_control_jump_table	;䕶$01 SH 
	.dc.w	putc_02_SX-putc_control_jump_table	;䕶$02 SX 
	.dc.w	putc_03_EX-putc_control_jump_table	;䕶$03 EX 
	.dc.w	putc_04_ET-putc_control_jump_table	;䕶$04 ET 
	.dc.w	putc_05_EQ-putc_control_jump_table	;䕶$05 EQ 
	.dc.w	putc_06_AK-putc_control_jump_table	;䕶$06 AK 
	.dc.w	putc_07_BL-putc_control_jump_table	;䕶$07 BL x炷
	.dc.w	putc_08_BS-putc_control_jump_table	;䕶$08 BS J[\1ցB[ł1s̉E[ցB[ł͉Ȃ
	.dc.w	putc_09_HT-putc_control_jump_table	;䕶$09 HT J[\̃^uցBȂ1s̍[ցB[ł̓XN[Abvč[
	.dc.w	putc_0A_LF-putc_control_jump_table	;䕶$0A LF J[\1sցB[ł̓XN[Abv
	.dc.w	putc_0B_VT-putc_control_jump_table	;䕶$0B VT J[\1sցB[ł͉Ȃ
	.dc.w	putc_0C_FF-putc_control_jump_table	;䕶$0C FF J[\1EցBE[ł1s̍[ցB[ł̓XN[Abvč[
	.dc.w	putc_0D_CR-putc_control_jump_table	;䕶$0D CR J[\[
	.dc.w	putc_0E_SO-putc_control_jump_table	;䕶$0E SO 
	.dc.w	putc_0F_SI-putc_control_jump_table	;䕶$0F SI 
	.dc.w	putc_10_DE-putc_control_jump_table	;䕶$10 DE 
	.dc.w	putc_11_D1-putc_control_jump_table	;䕶$11 D1 
	.dc.w	putc_12_D2-putc_control_jump_table	;䕶$12 D2 
	.dc.w	putc_13_D3-putc_control_jump_table	;䕶$13 D3 
	.dc.w	putc_14_D4-putc_control_jump_table	;䕶$14 D4 
	.dc.w	putc_15_NK-putc_control_jump_table	;䕶$15 NK 
	.dc.w	putc_16_SN-putc_control_jump_table	;䕶$16 SN 
	.dc.w	putc_17_EB-putc_control_jump_table	;䕶$17 EB 
	.dc.w	putc_18_CN-putc_control_jump_table	;䕶$18 CN 
	.dc.w	putc_19_EM-putc_control_jump_table	;䕶$19 EM 
	.dc.w	putc_1A_SB-putc_control_jump_table	;䕶$1A SB ォE܂ŏBJ[\
	.dc.w	putc_1B_EC-putc_control_jump_table	;䕶$1B EC GXP[vV[PXJn
	.dc.w	putc_1C_FS-putc_control_jump_table	;䕶$1C FS 
	.dc.w	putc_1D_GS-putc_control_jump_table	;䕶$1D GS 
	.dc.w	putc_1E_RS-putc_control_jump_table	;䕶$1E RS J[\
	.dc.w	putc_1F_US-putc_control_jump_table	;䕶$1F US 

;----------------------------------------------------------------
;䕶$00 NL 
putc_00_NL:
	rts

;----------------------------------------------------------------
;䕶$01 SH 
putc_01_SH:
	rts

;----------------------------------------------------------------
;䕶$02 SX 
putc_02_SX:
	rts

;----------------------------------------------------------------
;䕶$03 EX 
putc_03_EX:
	rts

;----------------------------------------------------------------
;䕶$04 ET 
putc_04_ET:
	rts

;----------------------------------------------------------------
;䕶$05 EQ 
putc_05_EQ:
	rts

;----------------------------------------------------------------
;䕶$06 AK 
putc_06_AK:
	rts

;----------------------------------------------------------------
;䕶$07 BL x炷
putc_07_BL:
	push	d0-d2/a0-a1
	move.l	BIOS_BEEP_DATA.w,d0	;BEEPADPCMf[^̃AhXB-1=BIOS_BEEP_EXTENSIONg
	moveq.l	#-1,d1
	if	<cmp.l d1,d0>,eq
		movea.l	BIOS_BEEP_EXTENSION.w,a0	;BEEP܂邲ƍ[`̃AhXBBIOS_BEEP_DATA=-1̂ƂL
		jsr	(a0)
	else
		move.w	#4<<8|3,d1
		moveq.l	#0,d2
		move.w	BIOS_BEEP_LENGTH.w,d2	;BEEPADPCMf[^̃oCgB0=
		movea.l	d0,a1
		IOCS	_ADPCMOUT
	endif
	pop
	rts

;----------------------------------------------------------------
;䕶$08 BS J[\1ցB[ł1s̉E[ցB[ł͉Ȃ
putc_08_BS:
	push	d0
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_COLUMN.w,d0
	if	ne
		subq.w	#1,d0			;1
		move.w	d0,BIOS_CURSOR_COLUMN.w
		clr.b	BIOS_CURSOR_FRACTION.w
	else
		move.w	BIOS_CURSOR_ROW.w,d0
		if	ne
			subq.w	#1,d0			;1s
			move.w	d0,BIOS_CURSOR_ROW.w
			move.w	BIOS_CONSOLE_RIGHT.w,BIOS_CURSOR_COLUMN.w	;E[
			clr.b	BIOS_CURSOR_FRACTION.w
		endif
	endif
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$09 HT J[\̃^uցBȂ1s̍[ցB[ł̓XN[Abvč[
putc_09_HT:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_COLUMN.w,d0
	addq.w	#8,d0
	and.w	#-8,d0			;̃^u
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d0>,ls	;͈͓
		move.w	d0,BIOS_CURSOR_COLUMN.w
		clr.b	BIOS_CURSOR_FRACTION.w
	else				;͈͊O
		move.w	BIOS_CURSOR_ROW.w,d0
		if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
			addq.w	#1,d0			;1s
			move.w	d0,BIOS_CURSOR_ROW.w
		else				;[̂Ƃ
			moveq.l	#1,d0			;Rs[̏[̍sW
			move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
			moveq.l	#0,d2			;Rs[̏[̍sW
			bsr	putc_copy_rows		;sRs[
			move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
			move.w	d0,d1			;[̍sW
			bsr	putc_clear_rows		;s
		endif
		clr.w	BIOS_CURSOR_COLUMN.w	;[
		clr.b	BIOS_CURSOR_FRACTION.w
	endif
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$0A LF J[\1sցB[ł̓XN[Abv
putc_0A_LF:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
		addq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	else				;[̂Ƃ
		moveq.l	#1,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
		moveq.l	#0,d2			;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
		move.w	d0,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$0B VT J[\1sցB[ł͉Ȃ
putc_0B_VT:
	push	d0
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	hi
		subq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	endif
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$0C FF J[\1EցBE[ł1s̍[ցB[ł̓XN[Abvč[
putc_0C_FF:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_COLUMN.w,d0
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d0>,lo	;E[ł͂ȂƂ
		addq.w	#1,d0			;1E
		move.w	d0,BIOS_CURSOR_COLUMN.w
		clr.b	BIOS_CURSOR_FRACTION.w
	else				;E[̂Ƃ
		move.w	BIOS_CURSOR_ROW.w,d0
		if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
			addq.w	#1,d0			;1s
			move.w	d0,BIOS_CURSOR_ROW.w
		else				;[̂Ƃ
			moveq.l	#1,d0			;Rs[̏[̍sW
			move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
			moveq.l	#0,d2			;Rs[̏[̍sW
			bsr	putc_copy_rows		;sRs[
			move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
			move.w	d0,d1			;[̍sW
			bsr	putc_clear_rows		;s
		endif
		clr.w	BIOS_CURSOR_COLUMN.w	;[
		clr.b	BIOS_CURSOR_FRACTION.w
	endif
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$0D CR J[\[
putc_0D_CR:
	push	d0
	bsr	iocs_1F_B_CUROFF
	clr.w	BIOS_CURSOR_COLUMN.w	;[
	clr.b	BIOS_CURSOR_FRACTION.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$0E SO 
putc_0E_SO:
	rts

;----------------------------------------------------------------
;䕶$0F SI 
putc_0F_SI:
	rts

;----------------------------------------------------------------
;䕶$10 DE 
putc_10_DE:
	rts

;----------------------------------------------------------------
;䕶$11 D1 
putc_11_D1:
	rts

;----------------------------------------------------------------
;䕶$12 D2 
putc_12_D2:
	rts

;----------------------------------------------------------------
;䕶$13 D3 
putc_13_D3:
	rts

;----------------------------------------------------------------
;䕶$14 D4 
putc_14_D4:
	rts

;----------------------------------------------------------------
;䕶$15 NK 
putc_15_NK:
	rts

;----------------------------------------------------------------
;䕶$16 SN 
putc_16_SN:
	rts

;----------------------------------------------------------------
;䕶$17 EB 
putc_17_EB:
	rts

;----------------------------------------------------------------
;䕶$18 CN 
putc_18_CN:
	rts

;----------------------------------------------------------------
;䕶$19 EM 
putc_19_EM:
	rts

;----------------------------------------------------------------
;䕶$1A SB ォE܂ŏBJ[\
putc_1A_SB:
	push	d0-d1
	bsr	iocs_1F_B_CUROFF
	clr.w	d0			;[̍sW
	move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[̍sW
	bsr	putc_clear_rows		;s
	clr.l	BIOS_CURSOR_COLUMN.w	;
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;䕶$1B EC GXP[vV[PXJn
putc_1B_EC:
	move.b	#$1B,BIOS_PUTC_POOL.w	;1oCgڂ̃v[
	move.l	#BIOS_ESCAPE_BUFFER,BIOS_ESCAPE_POINTER.w	;GXP[vV[PXobt@݈̏ʒu
	rts

;----------------------------------------------------------------
;䕶$1C FS 
putc_1C_FS:
	rts

;----------------------------------------------------------------
;䕶$1D GS 
putc_1D_GS:
	rts

;----------------------------------------------------------------
;䕶$1E RS J[\
putc_1E_RS:
	bsr	iocs_1F_B_CUROFF
	clr.l	BIOS_CURSOR_COLUMN.w
	bsr	iocs_1E_B_CURON
	rts

;----------------------------------------------------------------
;䕶$1F US 
putc_1F_US:
	rts

;----------------------------------------------------------------
;GXP[vV[PX
;<d1.w:R[h
putc_escape:
	push	d0/a0
	movea.l	BIOS_ESCAPE_POINTER.w,a0
	move.b	d1,(a0)+
	if	<cmpa.l #BIOS_ESCAPE_BUFFER+10,a0>,lo
		move.l	a0,BIOS_ESCAPE_POINTER.w
	endif
	move.b	BIOS_ESCAPE_BUFFER.w,d0	;GXP[vV[PX̍ŏ̕
	if	<cmp.b #'[',d0>,eq	;ESC [
		moveq.l	#$20,d0
		or.b	d1,d0
		ifand	<cmp.b #'`',d0>,hs,<cmp.b #'z',d0>,ls	;'@'`'Z','`'`'z'
			bsr	putc_csi
		endif
	elif	<cmp.b #'*',d0>,eq	;ESC *
		bsr	putc_esc_ast
	elif	<cmp.b #'=',d0>,eq	;ESC =
		if	<cmpa.l #BIOS_ESCAPE_BUFFER+3,a0>,eq
			bsr	putc_esc_equ
		endif
	elif	<cmp.b #'D',d0>,eq	;ESC D
		bsr	putc_esc_D
	elif	<cmp.b #'E',d0>,eq	;ESC E
		bsr	putc_esc_E
	elif	<cmp.b #'M',d0>,eq	;ESC M
		bsr	putc_esc_M
	else				;̑
		clr.b	BIOS_PUTC_POOL.w
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC *
;	ォE܂ŏBJ[\
putc_esc_ast:
	push	d0-d1
	bsr	iocs_1F_B_CUROFF
	clr.w	d0			;[̍sW
	move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[̍sW
	bsr	putc_clear_rows		;s
	clr.l	BIOS_CURSOR_COLUMN.w	;J[\
	clr.b	BIOS_PUTC_POOL.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;ESC = r c
;	J[\r-' 's,c-' 'ցBrc͕
putc_esc_equ:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	moveq.l	#0,d1
	moveq.l	#0,d2
	move.b	BIOS_ESCAPE_BUFFER+2.w,d1	;B' '=0
	move.b	BIOS_ESCAPE_BUFFER+1.w,d2	;sB' '=0
	moveq.l	#' ',d0
	sub.w	d0,d1			;W
	sub.w	d0,d2			;sW
	ifand	<cmp.w BIOS_CONSOLE_RIGHT.w,d1>,ls,<cmp.w BIOS_CONSOLE_BOTTOM.w,d2>,ls	;R\[͈͓̔̂Ƃ
		move.w	d1,BIOS_CURSOR_COLUMN.w
		move.w	d2,BIOS_CURSOR_ROW.w
		clr.b	BIOS_CURSOR_FRACTION.w
	endif
	clr.b	BIOS_PUTC_POOL.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;ESC D
;	J[\1sցB[ł̓XN[Abv
;	_B_DOWN_SƓ
putc_esc_D:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
		addq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	else				;[̂Ƃ
		moveq.l	#1,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
		moveq.l	#0,d2			;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
		move.w	d0,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	clr.b	BIOS_PUTC_POOL.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;ESC E
;	J[\1s̍[ցB[ł̓XN[Abv
putc_esc_E:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
		addq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	else				;[̂Ƃ
		moveq.l	#1,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
		moveq.l	#0,d2			;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
		move.w	d0,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	clr.w	BIOS_CURSOR_COLUMN.w	;[
	clr.b	BIOS_CURSOR_FRACTION.w
	clr.b	BIOS_PUTC_POOL.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;ESC M
;	J[\1sցB[ł̓XN[_E
;	_B_UP_SƓ
putc_esc_M:
	push	d0-d2
	bsr	iocs_1F_B_CUROFF
	move.w	BIOS_CURSOR_ROW.w,d0
	if	<tst.w d0>,hi		;[ł͂ȂƂ
		subq.w	#1,d0			;1s
		move.w	d0,BIOS_CURSOR_ROW.w
	else				;[̂Ƃ
		moveq.l	#0,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1
		subq.w	#1,d1			;Rs[̉[̍sW
		moveq.l	#1,d2			;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		moveq.l	#0,d0			;[̍sW
		moveq.l	#0,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	clr.b	BIOS_PUTC_POOL.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;ESC [
;	https://en.wikipedia.org/wiki/ANSI_escape_code
;	http://nanno.dip.jp/softlib/man/rlogin/ctrlcode.html
putc_csi:
	push	d0-d3/a0
	bsr	iocs_1F_B_CUROFF
	move.l	BIOS_CSI_EXTENSION.w,d0	;GXP[vV[PXۂƍւ[`
	if	ne
		lea.l	BIOS_ESCAPE_BUFFER.w,a0
		movejsr	d0
	else
		lea.l	BIOS_ESCAPE_BUFFER.w,a0
		move.w	(a0)+,d0
		if	<cmp.w #'[>',d0>,eq	;ESC [>
			move.w	(a0)+,d0
			if	<cmp.w #'5l',d0>,eq	;ESC [>5l J[\ON
				sf.b	BIOS_CURSOR_PROHIBITED.w
			elif	<cmp.w #'5h',d0>,eq	;ESC [>5h J[\OFF
				st.b	BIOS_CURSOR_PROHIBITED.w
			else
				bsr	putc_csi_extension
			endif
		elif	<cmp.w #'[?',d0>,eq	;ESC [?
			move.w	(a0)+,d0
			if	<cmp.w #'4l',d0>,eq	;ESC [?4l WvXN[
				clr.w	BIOS_SMOOTH_SCROLL.w
			elif	<cmp.w #'4h',d0>,eq	;ESC [?4h 8hbgX[XXN[
				move.w	#2,BIOS_SMOOTH_SCROLL.w
			else
				bsr	putc_csi_extension
			endif
		else
			lea.l	BIOS_ESCAPE_BUFFER+1.w,a0	;[̎
			moveq.l	#0,d0
			moveq.l	#-1,d1			;1Ԗڂ̐l
			moveq.l	#-1,d2			;2Ԗڂ̐l
			moveq.l	#-1,d3			;3Ԗڂ̐l
			do
				move.b	(a0)+,d0
			while	<cmp.b #' ',d0>,eq
			ifand	<cmp.b #'0',d0>,hs,<cmp.b #'9',d0>,ls
				moveq.l	#0,d1
				do
					sub.b	#'0',d0
					mulu.w	#10,d1
					add.w	d0,d1
					move.b	(a0)+,d0
				whileand	<cmp.b #'0',d0>,hs,<cmp.b #'9',d0>,ls
				if	<cmp.b #';',d0>,eq
					do
						move.b	(a0)+,d0
					while	<cmp.b #' ',d0>,eq
					ifand	<cmp.b #'0',d0>,hs,<cmp.b #'9',d0>,ls
						moveq.l	#0,d2
						do
							sub.b	#'0',d0
							mulu.w	#10,d2
							add.w	d0,d2
							move.b	(a0)+,d0
						whileand	<cmp.b #'0',d0>,hs,<cmp.b #'9',d0>,ls
						if	<cmp.b #';',d0>,eq
							do
								move.b	(a0)+,d0
							while	<cmp.b #' ',d0>,eq
							ifand	<cmp.b #'0',d0>,hs,<cmp.b #'9',d0>,ls
								moveq.l	#0,d3
								do
									sub.b	#'0',d0
									mulu.w	#10,d3
									add.w	d0,d3
									move.b	(a0)+,d0
								whileand	<cmp.b #'0',d0>,hs,<cmp.b #'9',d0>,ls
							endif
						endif
					endif
				endif
			endif
			if	<cmp.b #'@',d0>,eq
				bsr	putc_csi_at		;ESC [n@ J[\En}
			elif	<cmp.b #'A',d0>,eq
				bsr	putc_csi_A		;ESC [nA J[\nsցB[𒴂Ƃ͓Ȃ
			elif	<cmp.b #'B',d0>,eq
				bsr	putc_csi_B		;ESC [nB J[\nsցB[Ŏ~܂
			elif	<cmp.b #'C',d0>,eq
				bsr	putc_csi_C		;ESC [nC J[\nEցBE[Ŏ~܂
			elif	<cmp.b #'D',d0>,eq
				bsr	putc_csi_D		;ESC [nD J[\nցB[Ŏ~܂
			elif	<cmp.b #'H',d0>,eq
				bsr	putc_csi_H		;ESC [r;cH J[\r-1s,c-1
			elif	<cmp.b #'J',d0>,eq
				bsr	putc_csi_J		;ESC [nJ ʂ
			elif	<cmp.b #'K',d0>,eq
				bsr	putc_csi_K		;ESC [nK s
			elif	<cmp.b #'L',d0>,eq
				bsr	putc_csi_L		;ESC [nL J[\牺ns}BJ[\[
			elif	<cmp.b #'M',d0>,eq
				bsr	putc_csi_M		;ESC [nM J[\牺ns폜BJ[\[
			elif	<cmp.b #'P',d0>,eq
				bsr	putc_csi_P		;ESC [nP J[\En폜
			elif	<cmp.b #'R',d0>,eq
				bsr	putc_csi_R		;ESC [r;cR CSR(Cursor Position Report)
			elif	<cmp.b #'X',d0>,eq
				bsr	putc_csi_X		;ESC [nX J[\En
			elif	<cmp.b #'c',d0>,eq
				bsr	putc_csi_c		;ESC [nc 
			elif	<cmp.b #'f',d0>,eq
				bsr	putc_csi_f		;ESC [r;cf J[\r-1s,c-1
			elif	<cmp.b #'l',d0>,eq
				bsr	putc_csi_l		;ESC [nl 
			elif	<cmp.b #'m',d0>,eq
				bsr	putc_csi_m		;ESC [nm ݒ肷
			elif	<cmp.b #'n',d0>,eq
				bsr	putc_csi_n		;ESC [nn DSR(Device Status Report)
			elif	<cmp.b #'r',d0>,eq
				bsr	putc_csi_r		;ESC [nr E
			elif	<cmp.b #'s',d0>,eq
				bsr	putc_csi_s		;ESC [ns J[\̍Wƕۑ
			elif	<cmp.b #'u',d0>,eq
				bsr	putc_csi_u		;ESC [nu J[\̍Wƕ𕜌
			else
				bsr	putc_csi_extension
			endif
		endif
	endif
	clr.b	BIOS_PUTC_POOL.w
	bsr	iocs_1E_B_CURON
	pop
	rts

;----------------------------------------------------------------
;gGXP[vV[PX[`Ăяo
putc_csi_extension:
	push	d0/a0
	move.l	BIOS_ESCAPE_EXTENSION.w,d0
	if	ne
		lea.l	BIOS_ESCAPE_BUFFER.w,a0
		movejsr	d0
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [n@ J[\En}
;<d1.w:}錅B0=1
putc_csi_at:
	push	d0-d5/a0-a3
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1
	endif
;
;	`abcdefgh
;	`ab@@@@cd
;
	move.w	BIOS_CURSOR_COLUMN.w,d4
	add.w	d1,d4			;J[\̌W+}錅=ړ̌W
	move.w	BIOS_CONSOLE_RIGHT.w,d3
	sub.w	d4,d3			;R\[̉E[-ړ̌W=ړ镔̌-1
	if	lo			;ׂĉo
		bsr	putc_csi_0K		;ESC [0K J[\E[܂ŏ
	else				;ړ镔
		move.w	BIOS_CURSOR_ROW.w,d0	;sW
		swap.w	d0
		clr.w	d0			;65536*sW
		lsr.l	#5,d0			;128*16*sW
		add.l	BIOS_CONSOLE_OFFSET.w,d0
		add.l	#$00E00000,d0
		movea.l	d0,a2			;s̍[̃AhX
		movea.l	a2,a3
		adda.w	BIOS_CURSOR_COLUMN.w,a2	;J[\̃AhX
		adda.w	d3,a2			;ړ̉E[̃AhX
		adda.w	BIOS_CONSOLE_RIGHT.w,a3	;s̉E[̃AhX=ړ̉E[̃AhX
		do				;v[̃[v
			moveq.l	#16-1,d2
			for	d2			;X^̃[v
				lea.l	1(a2),a0		;ړ̉E[̃AhX+1
				lea.l	1(a3),a1		;ړ̉E[̃AhX+1
				move.w	d3,d1			;ړ镔̌-1
				for	d1			;̃[v
					move.b	-(a0),-(a1)
				next
				lea.l	128(a2),a2		;̃X^
				lea.l	128(a3),a3
			next
			adda.l	#-128*16+128*1024,a2	;̃v[
			adda.l	#-128*16+128*1024,a3
		while	<cmpa.l #$00E40000,a2>,lo
		move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
		move.w	d0,d1			;[̍sW
		move.w	BIOS_CURSOR_COLUMN.w,d2	;[̌W
		move.w	d4,d3
		subq.w	#1,d3			;E[̌W
		moveq.l	#0,d4			;[̌W̒[
		moveq.l	#7,d5			;E[̌W̒[
		bsr	putc_clear		;s
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [nA J[\nsցB[𒴂Ƃ͓Ȃ
;<d1.w:ړsB0=1s
putc_csi_A:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1s
	endif
	move.w	BIOS_CURSOR_ROW.w,d0
	sub.w	d1,d0			;ns
	if	hs			;[𒴂ȂƂ
		move.w	d0,BIOS_CURSOR_ROW.w
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [nB J[\nsցB[Ŏ~܂
;<d1.w:ړsB0=1
putc_csi_B:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1s
	endif
	move.w	BIOS_CURSOR_ROW.w,d0
	add.w	d1,d0			;ns
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,hi	;[𒴂Ƃ
		move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[Ŏ~܂
	endif
	move.w	d0,BIOS_CURSOR_ROW.w
	pop
	rts

;----------------------------------------------------------------
;ESC [nC J[\nEցBE[Ŏ~܂
;<d1.w:ړ錅B0=1
putc_csi_C:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1
	endif
	move.w	BIOS_CURSOR_COLUMN.w,d0
	add.w	d1,d0			;nE
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d0>,hi	;E[𒴂Ƃ
		move.w	BIOS_CONSOLE_RIGHT.w,d0	;E[Ŏ~܂
	endif
	move.w	d0,BIOS_CURSOR_COLUMN.w
	clr.b	BIOS_CURSOR_FRACTION.w
	pop
	rts

;----------------------------------------------------------------
;ESC [nD J[\nցB[Ŏ~܂
;<d1.w:ړ錅B0=1
putc_csi_D:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1
	endif
	move.w	BIOS_CURSOR_COLUMN.w,d0
	sub.w	d1,d0			;n
	if	lo			;[𒴂Ƃ
		moveq.l	#0,d0			;[Ŏ~܂
	endif
	move.w	d0,BIOS_CURSOR_COLUMN.w
	clr.b	BIOS_CURSOR_FRACTION.w
	pop
	rts

;----------------------------------------------------------------
;ESC [r;cf J[\r-1s,c-1
;<d1.w:ړ̍sW+1B0=[B[Ŏ~܂
;<d2.w:ړ̌W+1B0=[BE[Ŏ~܂
putc_csi_f:
;----------------------------------------------------------------
;ESC [r;cH J[\r-1s,c-1
;<d1.w:ړ̍sW+1B0=[B[Ŏ~܂
;<d2.w:ړ̌W+1B0=[BE[Ŏ~܂
putc_csi_H:
	push	d1-d2
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=[
	endif
	subq.w	#1,d1
	if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d1>,hi
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[Ŏ~܂
	endif
	ifor	<cmp.w #-1,d2>,eq,<tst.w d2>,eq
		moveq.l	#1,d2			;0=[
	endif
	subq.w	#1,d2
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d2>,hi
		move.w	BIOS_CONSOLE_RIGHT.w,d2	;E[Ŏ~܂
	endif
	move.w	d2,BIOS_CURSOR_COLUMN.w
	move.w	d1,BIOS_CURSOR_ROW.w
	clr.b	BIOS_CURSOR_FRACTION.w
	pop
	rts

;----------------------------------------------------------------
;ESC [nJ ʂ
;<d1.w:0=J[\E܂,1=ォJ[\܂,2=ォE܂ŁBJ[\
putc_csi_J:
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		bsr	putc_csi_0J		;ESC [0J J[\E܂ŏ
	elif	<cmp.w #1,d1>,eq
		bsr	putc_csi_1J		;ESC [1J ォJ[\܂ŏ
	elif	<cmp.w #2,d1>,eq
		bsr	putc_csi_2J		;ESC [2J ォE܂ŏBJ[\
	endif
	rts

;----------------------------------------------------------------
;ESC [0J J[\E܂ŏ
putc_csi_0J:
	push	d0-d5
	move.w	BIOS_CURSOR_ROW.w,d0
	move.w	BIOS_CONSOLE_BOTTOM.w,d1
	if	<cmp.w d1,d0>,lo		;[ł͂ȂƂ
	;	move.w	BIOS_CURSOR_ROW.w,d0
		addq.w	#1,d0			;[̍sW
	;	move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[̍sW
		bsr	putc_clear_rows		;s
	endif
	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
	move.w	d0,d1			;[̍sW
	move.w	BIOS_CURSOR_COLUMN.w,d2	;[̌W
	move.w	BIOS_CONSOLE_RIGHT.w,d3	;E[̌W
	moveq.l	#0,d4
	move.b	BIOS_CURSOR_FRACTION.w,d4	;[̌W̒[
	moveq.l	#7,d5			;E[̌W̒[
	bsr	putc_clear		;
	pop
	rts

;----------------------------------------------------------------
;ESC [1J ォJ[\܂ŏ
putc_csi_1J:
	push	d0-d5
	move.w	BIOS_CURSOR_ROW.w,d1
	if	<tst.w d1>,hi			;[ł͂ȂƂ
		clr.w	d0			;[̍sW
	;	move.w	BIOS_CURSOR_ROW.w,d1
		subq.w	#1,d1			;[̍sW
		bsr	putc_clear_rows		;s
	endif
	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
	move.w	d0,d1			;[̍sW
	moveq.l	#0,d2			;[̌W
	move.w	BIOS_CURSOR_COLUMN.w,d3	;E[̌W
	moveq.l	#0,d4			;[̌W̒[
	moveq.l	#7,d5
	add.b	BIOS_CURSOR_FRACTION.w,d5	;E[̌W̒[
	if	<cmp.w #7,d5>,hi	;̌̂Ƃ
		if	<cmp.w BIOS_CONSOLE_RIGHT.w,d3>,lo	;E[ł͂ȂƂ
			addq.w	#1,d3
			subq.w	#8,d5
		else				;E[̂Ƃ
			moveq.l	#7,d5
		endif
	endif
	bsr	putc_clear		;
	pop
	rts

;----------------------------------------------------------------
;ESC [2J ォE܂ŏBJ[\
putc_csi_2J:
	push	d0-d1
	moveq.l	#0,d0			;[̍sW
	move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[̍sW
	bsr	putc_clear_rows		;s
	clr.l	BIOS_CURSOR_COLUMN.w
	pop
	rts

;----------------------------------------------------------------
;ESC [nK s
;<d1.w:0=J[\E[܂,1=[J[\܂,2=[E[܂
putc_csi_K:
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		bsr	putc_csi_0K		;ESC [0K J[\E[܂ŏ
	elif	<cmp.w #1,d1>,eq
		bsr	putc_csi_1K		;ESC [1K [J[\܂ŏ
	elif	<cmp.w #2,d1>,eq
		bsr	putc_csi_2K		;ESC [2K [E[܂ŏ
	endif
	rts

;----------------------------------------------------------------
;ESC [0K J[\E[܂ŏ
putc_csi_0K:
	push	d0-d5
	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
	move.w	d0,d1			;[̍sW
	move.w	BIOS_CURSOR_COLUMN.w,d2	;[̌W
	move.w	BIOS_CONSOLE_RIGHT.w,d3	;E[̌W
	moveq.l	#0,d4			;[̌W̒[
	moveq.l	#7,d5			;E[̌W̒[
	bsr	putc_clear		;
	pop
	rts

;----------------------------------------------------------------
;ESC [1K [J[\܂ŏ
putc_csi_1K:
	push	d0-d5
	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
	move.w	d0,d1			;[̍sW
	moveq.l	#0,d2			;[̌W
	move.w	BIOS_CURSOR_COLUMN.w,d3	;E[̌W
	moveq.l	#0,d4			;[̌W̒[
	moveq.l	#7,d5			;E[̌W̒[
	bsr	putc_clear		;
	pop
	rts

;----------------------------------------------------------------
;ESC [2K [E[܂ŏ
putc_csi_2K:
	push	d0-d1
	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
	move.w	d0,d1			;[̍sW
	bsr	putc_clear_rows		;s
	pop
	rts

;----------------------------------------------------------------
;ESC [nL J[\牺ns}BJ[\[
;<d1.w:}sB0=1s
putc_csi_L:
	push	d0-d2
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1s
	endif
	move.w	BIOS_CURSOR_ROW.w,d0
;<d0.w:J[\̍sW
	move.w	BIOS_CONSOLE_BOTTOM.w,d2	;R\[̍s-1
	addq.w	#1,d2			;R\[̍s
	sub.w	d0,d2			;J[\牺̍s
	sub.w	d1,d2			;ʓɎcs
;<d2.w:ʓɎcs
	if	ls			;ʓɎcsȂBׂĉʊOɉo
	;    
	;                
	;                
	;d0
	;    
	;    
	;    
	;;;	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[̍sW
		bsr	putc_clear_rows		;s
	else				;ʓɎcs
	;    
	;                
	;                
	;d0\d1
	;    /
	;    )d2
	;    
		add.w	d0,d2
		subq.w	#1,d2			;Rs[̉[̍sW
		add.w	d0,d1			;Rs[̏[̍sW
		exg.l	d1,d2
	;;;	move.w	BIOS_CURSOR_ROW.w,d0	;Rs[̏[̍sW
		bsr	putc_copy_rows		;sRs[
		exg.l	d1,d2
		subq.w	#1,d1			;[̍sW
	;;;	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
		bsr	putc_clear_rows		;s
	endif
	clr.w	BIOS_CURSOR_COLUMN.w	;[
	clr.b	BIOS_CURSOR_FRACTION.w
	pop
	rts

;----------------------------------------------------------------
;ESC [nM J[\牺ns폜BJ[\[
;<d1.w:폜sB0=1s
putc_csi_M:
	push	d0-d3
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1s
	endif
	move.w	BIOS_CURSOR_ROW.w,d0
;<d0.w:J[\̍sW
	move.w	BIOS_CONSOLE_BOTTOM.w,d3	;R\[̍s-1
	addq.w	#1,d3			;R\[̍s
	sub.w	d0,d3			;J[\牺̍s
	sub.w	d1,d3			;ʓɎcs
;<d3.w:ʓɎcs
	if	ls			;ʓɎcsȂBׂč폜
	;    
	;                
	;                
	;d0
	;    
	;    
	;    
	;;;	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;[̍sW
		bsr	putc_clear_rows		;s
	else				;ʓɎcs
	;    
	;                
	;                
	;d0)d3
	;    \d1
	;    /
	;    
	;;;	move.w	BIOS_CURSOR_ROW.w,d0
		move.w	d0,d2			;Rs[̏[̍sW
		add.w	d1,d0			;Rs[̏[̍sW
		move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
		bsr	putc_copy_rows		;sRs[
		move.w	d2,d0
		add.w	d3,d0			;[̍sW
	;;;	move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
		bsr	putc_clear_rows		;s
	endif
	clr.w	BIOS_CURSOR_COLUMN.w	;[
	clr.b	BIOS_CURSOR_FRACTION.w
	pop
	rts

;----------------------------------------------------------------
;ESC [nP J[\En폜
;<d1.w:폜錅B0=1
putc_csi_P:
	push	d0-d5/a0-a3
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1
	endif
;
;	`abcdefgh
;	`abgh@@@@
;
	move.w	BIOS_CURSOR_COLUMN.w,d4	;J[\̌W
	add.w	d1,d4			;J[\̌W+폜錅=ړ̍[̌W
	move.w	BIOS_CONSOLE_RIGHT.w,d3	;R\[̉E[̌W=ړ̉E[̌W
	sub.w	d4,d3			;ړ̉E[̌W-ړ̍[̌W=ړ镔̌-1
	if	lo			;ׂč폜
		bsr	putc_csi_0K		;ESC [0K J[\E[܂ŏ
	else				;ړ镔
		move.w	BIOS_CURSOR_ROW.w,d0	;J[\̍sW
		swap.w	d0
		clr.w	d0			;65536*J[\̍sW
		lsr.l	#5,d0			;128*16*J[\̍sW
		add.l	BIOS_CONSOLE_OFFSET.w,d0
		add.l	#$00E00000,d0
		movea.l	d0,a2			;J[\̍s̍[̃AhX
		movea.l	a2,a3
		adda.w	d4,a2			;J[\̍s̍[̃AhX+ړ̍[̌W=ړ̍[̃AhX
		adda.w	BIOS_CURSOR_COLUMN.w,a3	;J[\̍s̍[̃AhX+J[\̌W=J[\̃AhX=ړ̍[̃AhX
		do				;v[̃[v
			moveq.l	#16-1,d2
			for	d2			;X^̃[v
				movea.l	a2,a0			;ړ̍[̃AhX
				movea.l	a3,a1			;ړ̍[̃AhX
				move.w	d3,d1			;ړ镔̌-1
				for	d1			;̃[v
					move.b	(a0)+,(a1)+
				next
				lea.l	128(a2),a2		;̃X^
				lea.l	128(a3),a3
			next
			adda.l	#-128*16+128*1024,a2	;̃v[
			adda.l	#-128*16+128*1024,a3
		while	<cmpa.l #$00E40000,a2>,lo
		move.w	BIOS_CURSOR_ROW.w,d0	;J[\̍sW=͈͂̏[̍sW
		move.w	d0,d1			;J[\̍sW=͈͂̉[̍sW
		move.w	BIOS_CURSOR_COLUMN.w,d2	;J[\̌W
		add.w	d3,d2			;J[\̌W+ړ͈͂̌-1
		addq.w	#1,d2			;J[\̌W+ړ͈͂̌=͈͂̍[̌W
		move.w	BIOS_CONSOLE_RIGHT.w,d3	;R\[̉E[̌W=͈͂̉E[̌W
		moveq.l	#0,d4			;͈͂̍[̌W̒[
		moveq.l	#7,d5			;͈͂̉E[̌W̒[
		bsr	putc_clear		;s
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [r;cR CPR(Cursor Position Report)
;	DSR(Device Status Report)̕ԓBł͉Ȃ
putc_csi_R:
	rts

;----------------------------------------------------------------
;ESC [nX J[\En
;<d1.w:錅B0=1
putc_csi_X:
	push	d0-d5
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1			;0=1
	endif
	move.w	BIOS_CURSOR_COLUMN.w,d2	;[̌W
	move.w	d2,d3
	add.w	d1,d3
	subq.w	#1,d3			;E[̌W
	if	<cmp.w BIOS_CONSOLE_RIGHT.w,d3>,hi	;E[𒴂Ƃ
		move.w	BIOS_CONSOLE_RIGHT.w,d3	;E[Ŏ~܂
	endif
	move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
	move.w	d0,d1			;[̍sW
	moveq.l	#7,d4
	and.b	BIOS_CURSOR_FRACTION.w,d4	;[̌W̒[
	moveq.l	#7,d5			;E[̌W̒[
	bsr	putc_clear		;
	pop
	rts

;----------------------------------------------------------------
;ESC [nc 
;<d1.w:hbg
putc_csi_c:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CONSOLE_RIGHT.w,d0
	addq.w	#1,d0
	lsl.w	#3,d0			;R\[̃hbg
	if	<cmp.w d0,d1>,ls	;傫Ȃ
		bset.b	#BIOS_ALIGN_CENTER_BIT,BIOS_CONSOLE_STATUS.w	;
		move.l	#BIOS_BUFFER_ARRAY,BIOS_BUFFER_POINTER.w
		clr.w	BIOS_BUFFER_WIDTH.w
		move.w	d1,BIOS_BUFFER_REQUEST.w	;obt@o͊Jn
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [nl 
;<d1.w:hbg
putc_csi_l:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CONSOLE_RIGHT.w,d0
	addq.w	#1,d0
	lsl.w	#3,d0			;R\[̃hbg
	if	<cmp.w d0,d1>,ls	;傫Ȃ
		bset.b	#BIOS_ALIGN_LEFT_BIT,BIOS_CONSOLE_STATUS.w	;
		move.l	#BIOS_BUFFER_ARRAY,BIOS_BUFFER_POINTER.w
		clr.w	BIOS_BUFFER_WIDTH.w
		move.w	d1,BIOS_BUFFER_REQUEST.w	;obt@o͊Jn
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [nm ݒ肷
;	0	Zbg
;	1	
;	2	׎
;	3	Α
;	4	
;	5	(x_)
;	6	(_)
;	7	]
;	8	(閧)
;	9	
;	11`19	(փtHg1`9)
;	20	(ubN^[)
;	21	g
;	22	A׎
;	23	Α̉A(ubN^[)
;	24	Ag
;	25	(x_ŉA_ŉ)
;	26	v|[Vi
;	27	]
;	28	(閧)
;	29	
;	30	
;	31	F
;	32	F
;	33	
;	34	A
;	35	AF
;	36	AF
;	37	A
;	40	]A
;	41	]AF
;	42	]AF
;	43	]A
;	44	]AA
;	45	]AAF
;	46	]AAF
;	47	]AA
;	50	v|[Vi
;	51	lp͂
;	52	ۈ͂
;	53	
;	54	lp͂݁Aۈ͂݉
;	55	
;	73	t
;	74	t
;	75	tAt
;<d1.w:B-1=wȂ
;<d2.w:B-1=wȂ
;<d3.w:B-1=wȂ
putc_csi_m:
	push	d1
	bsr	putc_csi_m_1
	if	<cmp.w #-1,d2>,ne
		move.w	d2,d1
		bsr	putc_csi_m_1
	endif
	if	<cmp.w #-1,d3>,ne
		move.w	d3,d1
		bsr	putc_csi_m_1
	endif
	pop
	rts

;?d1
putc_csi_m_1:
;Ɣ]̂݃gOB̑ON܂OFF̂ǂ炩
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		move.b	#3,BIOS_ATTRIBUTE_1.w	;1B||Α|׎|]||v[##
		clr.b	BIOS_ATTRIBUTE_2.w	;2B-|t|t||ۈ͂|lp͂|v|[Vi|g
	elif	<cmp.w #1,d1>,eq
		bchg.b	#BIOS_BOLD_BIT,BIOS_ATTRIBUTE_1.w	;
		if	eq			;OFFON̂Ƃ
			bclr.b	#BIOS_FAINT_BIT,BIOS_ATTRIBUTE_1.w	;׎
		endif
	elif	<cmp.w #2,d1>,eq
		bclr.b	#BIOS_BOLD_BIT,BIOS_ATTRIBUTE_1.w	;
		bset.b	#BIOS_FAINT_BIT,BIOS_ATTRIBUTE_1.w	;׎
	elif	<cmp.w #3,d1>,eq
		bset.b	#BIOS_ITALIC_BIT,BIOS_ATTRIBUTE_1.w	;Α
	elif	<cmp.w #4,d1>,eq
		bset.b	#BIOS_UNDERLINE_BIT,BIOS_ATTRIBUTE_1.w	;
		bclr.b	#BIOS_WAVELINE_BIT,BIOS_ATTRIBUTE_2.w	;g
	elif	<cmp.w #7,d1>,eq
		bchg.b	#BIOS_REVERSE_BIT,BIOS_ATTRIBUTE_1.w	;]
	elif	<cmp.w #9,d1>,eq
		bset.b	#BIOS_STRIKETHROUGH_BIT,BIOS_ATTRIBUTE_1.w	;
	elif	<cmp.w #21,d1>,eq
		bclr.b	#BIOS_UNDERLINE_BIT,BIOS_ATTRIBUTE_1.w	;
		bset.b	#BIOS_WAVELINE_BIT,BIOS_ATTRIBUTE_2.w	;g
	elif	<cmp.w #22,d1>,eq
		bclr.b	#BIOS_BOLD_BIT,BIOS_ATTRIBUTE_1.w	;
		bclr.b	#BIOS_FAINT_BIT,BIOS_ATTRIBUTE_1.w	;׎
	elif	<cmp.w #23,d1>,eq
		bclr.b	#BIOS_ITALIC_BIT,BIOS_ATTRIBUTE_1.w	;Α̉
	elif	<cmp.w #24,d1>,eq
		bclr.b	#BIOS_UNDERLINE_BIT,BIOS_ATTRIBUTE_1.w	;
		bclr.b	#BIOS_WAVELINE_BIT,BIOS_ATTRIBUTE_2.w	;g
	elif	<cmp.w #26,d1>,eq
		bset.b	#BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w	;v|[Vi
	elif	<cmp.w #27,d1>,eq
		bclr.b	#BIOS_REVERSE_BIT,BIOS_ATTRIBUTE_1.w	;]
	elif	<cmp.w #29,d1>,eq
		bclr.b	#BIOS_STRIKETHROUGH_BIT,BIOS_ATTRIBUTE_1.w	;
	elifand	<cmp.w #30,d1>,hs,<cmp.w #37,d1>,ls
		sub.w	#30,d1
		andi.b	#$F0,BIOS_ATTRIBUTE_1.w
		or.b	d1,BIOS_ATTRIBUTE_1.w
	elifand	<cmp.w #40,d1>,hs,<cmp.w #47,d1>,ls
		sub.w	#40,d1
		addq.b	#8,d1
		andi.b	#$F0,BIOS_ATTRIBUTE_1.w
		or.b	d1,BIOS_ATTRIBUTE_1.w
	elif	<cmp.w #50,d1>,eq
		bclr.b	#BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w	;v|[Vi
	elif	<cmp.w #51,d1>,eq
		bset.b	#BIOS_FRAME_BIT,BIOS_ATTRIBUTE_2.w	;lp͂
		bclr.b	#BIOS_ENCIRCLE_BIT,BIOS_ATTRIBUTE_2.w	;ۈ͂݉
	elif	<cmp.w #52,d1>,eq
		bclr.b	#BIOS_FRAME_BIT,BIOS_ATTRIBUTE_2.w	;lp͂݉
		bset.b	#BIOS_ENCIRCLE_BIT,BIOS_ATTRIBUTE_2.w	;ۈ͂
	elif	<cmp.w #53,d1>,eq
		bset.b	#BIOS_OVERLINE_BIT,BIOS_ATTRIBUTE_2.w	;
	elif	<cmp.w #54,d1>,eq
		bclr.b	#BIOS_FRAME_BIT,BIOS_ATTRIBUTE_2.w	;lp͂݉
		bclr.b	#BIOS_ENCIRCLE_BIT,BIOS_ATTRIBUTE_2.w	;ۈ͂݉
	elif	<cmp.w #55,d1>,eq
		bclr.b	#BIOS_OVERLINE_BIT,BIOS_ATTRIBUTE_2.w	;
	elif	<cmp.w #73,d1>,eq
		bset.b	#BIOS_SUPERSCRIPT_BIT,BIOS_ATTRIBUTE_2.w	;t
		bclr.b	#BIOS_SUBSCRIPT_BIT,BIOS_ATTRIBUTE_2.w	;t
	elif	<cmp.w #74,d1>,eq
		bclr.b	#BIOS_SUPERSCRIPT_BIT,BIOS_ATTRIBUTE_2.w	;t
		bset.b	#BIOS_SUBSCRIPT_BIT,BIOS_ATTRIBUTE_2.w	;t
	elif	<cmp.w #75,d1>,eq
		bclr.b	#BIOS_SUPERSCRIPT_BIT,BIOS_ATTRIBUTE_2.w	;t
		bclr.b	#BIOS_SUBSCRIPT_BIT,BIOS_ATTRIBUTE_2.w	;t
	endif
	rts

;----------------------------------------------------------------
;ESC [nn DSR(Device Status Report)
;<d1.w:6
putc_csi_n:
	push	d0-d2/a0
	if	<cmp.w #6,d1>,eq	;CPR(Cursor Position Report)
		move.w	#$0100+27,d2
		bsr	20f
		move.w	#$1C00+'[',d2
		bsr	20f
		move.w	BIOS_CURSOR_ROW.w,d0
		bsr	10f
		move.w	#$2700+';',d2
		bsr	20f
		move.w	BIOS_CURSOR_COLUMN.w,d0
		bsr	10f
		move.w	#$1400+'R',d2
		bsr	20f
	endif
	pop
	rts

;l+1𕶎ɕϊăL[̓obt@ɏ
;<d0.b:lB255͕sBł1ȗȂ
;?d0-d2/a0
10:	addq.b	#1,d0
	move.l	#(1<<24)+(10<<16)+(100<<8),d1
	do
		lsr.l	#8,d1
	while	<cmp.b d1,d0>,lo
	do
		moveq.l	#-2,d2
		do
			addq.w	#2,d2
			sub.b	d1,d0
		while	hs
		move.w	15f(pc,d2.w),d2
		bsr	20f
		add.b	d1,d0
		lsr.l	#8,d1
	while	<tst.b d1>,ne
	rts

15:	.dc.w	$0B00+'0'
	.dc.w	$0200+'1'
	.dc.w	$0300+'2'
	.dc.w	$0400+'3'
	.dc.w	$0500+'4'
	.dc.w	$0600+'5'
	.dc.w	$0700+'6'
	.dc.w	$0800+'7'
	.dc.w	$0900+'8'
	.dc.w	$0A00+'9'

;L[̓obt@ɏ
;<d2.w:(XLR[h<<8)+R[h
;?a0
20:	di
	if	<cmpi.w #64,BIOS_KEY_REMAINING.w>,lo	;L[̓obt@ɎcĂf[^̐64̂Ƃ
		movea.l	BIOS_KEY_WRITTEN.w,a0	;Ōɏ񂾈ʒu
		addq.l	#2,a0			;񏑂ވʒu
		if	<cmpa.w #BIOS_KEY_BUFFER+2*64.w,a0>,hs	;𒴂
			lea.l	BIOS_KEY_BUFFER.w,a0	;擪ɖ߂
		endif
		move.w	d2,(a0)			;
		move.l	a0,BIOS_KEY_WRITTEN.w	;Ōɏ񂾈ʒu
		addq.w	#1,BIOS_KEY_REMAINING.w	;L[̓obt@ɎcĂf[^̐
	endif
	ei
	rts

;----------------------------------------------------------------
;ESC [nr E
;<d1.w:hbg
putc_csi_r:
	push	d0-d1
	ifor	<cmp.w #-1,d1>,eq,<tst.w d1>,eq
		moveq.l	#1,d1
	endif
	move.w	BIOS_CONSOLE_RIGHT.w,d0
	addq.w	#1,d0
	lsl.w	#3,d0			;R\[̃hbg
	if	<cmp.w d0,d1>,ls	;傫Ȃ
		bset.b	#BIOS_ALIGN_RIGHT_BIT,BIOS_CONSOLE_STATUS.w	;E
		move.l	#BIOS_BUFFER_ARRAY,BIOS_BUFFER_POINTER.w
		clr.w	BIOS_BUFFER_WIDTH.w
		move.w	d1,BIOS_BUFFER_REQUEST.w	;obt@o͊Jn
	endif
	pop
	rts

;----------------------------------------------------------------
;ESC [ns J[\̍Wƕۑ
;<d1.w:-1
putc_csi_s:
	if	<cmp.w #-1,d1>,eq
		move.w	BIOS_CURSOR_ROW.w,BIOS_SAVED_ROW.w
		move.w	BIOS_CURSOR_COLUMN.w,BIOS_SAVED_COLUMN.w
		move.b	BIOS_CURSOR_FRACTION.w,BIOS_SAVED_FRACTION.w
		move.b	BIOS_ATTRIBUTE_1.w,BIOS_SAVED_ATTRIBUTE_1.w
		move.b	BIOS_ATTRIBUTE_2.w,BIOS_SAVED_ATTRIBUTE_2.w
	endif
	rts

;----------------------------------------------------------------
;ESC [nu J[\̍Wƕ𕜌
;<d1.w:-1
putc_csi_u:
	if	<cmp.w #-1,d1>,eq
		move.w	BIOS_SAVED_ROW.w,BIOS_CURSOR_ROW.w
		move.w	BIOS_SAVED_COLUMN.w,BIOS_CURSOR_COLUMN.w
		move.b	BIOS_SAVED_FRACTION.w,BIOS_CURSOR_FRACTION.w
		move.b	BIOS_SAVED_ATTRIBUTE_1.w,BIOS_ATTRIBUTE_1.w
		move.b	BIOS_SAVED_ATTRIBUTE_2.w,BIOS_ATTRIBUTE_2.w
	endif
	rts

;----------------------------------------------------------------
;ʂɕ`܂̓obt@ɏo͂
;<d1.w:R[h
putc_output:
	push	d0-d7/a0-a2
	lea.l	-4*16-4*16(sp),sp	;tHgf[^ƃ}XNf[^
;<(sp).l[16]:tHgf[^
;<4*16(sp).l[16]:}XNf[^
	move.w	d1,d7
;<d7.w:R[h
;----------------
;tHgAhXƃhbg߂
	ifand	<btst.b #BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w>,ne,<cmp.w #$0020,d1>,hs,<cmp.w #$0082,d1>,ls	;v|[Viɂ
		lea.l	proportional_font(pc),a0	;v|[VitHg($20`$82)
		sub.w	#$0020,d1
		mulu.w	#2+2*16,d1
		adda.l	d1,a0			;tHgAhX
		move.w	(a0)+,d6		;hbgB1`16
		moveq.l	#1,d2			;16hbgf[^
	else				;v|[ViɂȂ
		moveq.l	#8,d2
		IOCS	_FNTADR
	;<d0.l:tHgAhX
	;<d1.w:̃hbg<<16|̃oCg-1
	;<d2.w:c̃hbg-1
		movea.l	d0,a0			;tHgAhX
		move.w	d1,d2			;0=8hbgf[^,1=16hbgf[^
		swap.w	d1
		move.w	d1,d6			;hbgB1`16
	endif
;<d2.w:0=8hbgf[^,1=16hbgf[^
;<d6.w:hbgB1`16
;<(a0).b[16]:8hbgf[^
;܂
;<(a0).w[16]:16hbgf[^
;----------------
;obt@ɏo͂邩
	if	<tst.w BIOS_BUFFER_REQUEST.w>,ne	;obt@o͒
		movea.l	BIOS_BUFFER_POINTER.w,a0	;obt@݈̏ʒu
		goto	<cmpa.l #BIOS_BUFFER_ARRAY+2*64,a0>,hs,putc_output_end	;obt@t̂Ƃ͖
		move.w	d7,(a0)+		;R[h
		move.l	a0,BIOS_BUFFER_POINTER.w	;݈ʒui߂
		if	<btst.b #BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w>,ne	;v|[VîƂ
			if	<btst.b #BIOS_BOLD_BIT,BIOS_ATTRIBUTE_1.w>,ne	;̂Ƃ
				addq.w	#1,d6			;1hbg
			endif
			if	<btst.b #BIOS_ITALIC_BIT,BIOS_ATTRIBUTE_1.w>,ne	;Α̂̂Ƃ
				addq.w	#3,d6			;3hbg
				bset.b #BIOS_CONNECTION_BIT,BIOS_CONSOLE_STATUS.w
				if	ne	;ÂƂ
					subq.w	#3,BIOS_BUFFER_WIDTH.w	;3hbgl߂
					if	cs
						clr.w	BIOS_BUFFER_WIDTH.w	;Ö
					endif
				endif
			else				;Α̂ł͂ȂƂ
				bclr.b	#BIOS_CONNECTION_BIT,BIOS_CONSOLE_STATUS.w
			endif
		endif
		add.w	d6,BIOS_BUFFER_WIDTH.w	;
		goto	putc_output_end
	endif
;----------------
;J[\OFF
;	Α̂̂Ƃʒûł̑OɃJ[\
	bsr	iocs_1F_B_CUROFF
;----------------
;tHgf[^
	movea.l	sp,a1			;tHgf[^
	moveq.l	#0,d0
	if	<tst.w d2>,eq		;8hbgf[^̂Ƃ
		moveq.l	#16-1,d3
		for	d3
			move.b	(a0)+,(a1)+
			move.b	d0,(a1)+		;clr
			move.w	d0,(a1)+		;clr
		next
	else				;16hbgf[^̂Ƃ
		moveq.l	#16-1,d3
		for	d3
			move.w	(a0)+,(a1)+
			move.w	d0,(a1)+		;clr
		next
	endif
;<(sp).l[16]:tHgf[^
;----------------
;
;	ŜE1hbg炵OR
;	v|[VîƂ͕1hbg
;<d6.w:hbgB1`16
;<(sp).l[16]:tHgf[^
;>d6.w:hbgB1`17
	if	<btst.b #BIOS_BOLD_BIT,BIOS_ATTRIBUTE_1.w>,ne	;̂Ƃ
		movea.l	sp,a1			;tHgf[^
		if	<btst.b #BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w>,ne	;v|[VîƂ
			moveq.l	#16-1,d3
			for	d3
				move.l	(a1),d0
				move.l	d0,d1
				lsr.l	#1,d0			;E1hbg炵
				or.l	d1,d0			;OR
				move.l	d0,(a1)+
			next
			addq.w	#1,d6			;1hbg
		else				;v|[Vił͂ȂƂ
			moveq.l	#1,d2
			ror.l	d6,d2
			neg.l	d2
			moveq.l	#16-1,d3
			for	d3
				move.l	(a1),d0
				move.l	d0,d1
				lsr.l	#1,d0			;E1hbg炵
				or.l	d1,d0			;OR
				and.l	d2,d0			;𑝂₳Ȃ
				move.l	d0,(a1)+
			next
		endif
	endif
;----------------
;׎
;	㉺Êꂩ1ŁAbV1̂ƂA10ɂ
;<d6.w:hbgB1`16
;<(sp).l[16]:tHgf[^
	if	<btst.b #BIOS_FAINT_BIT,BIOS_ATTRIBUTE_1.w>,ne	;׎̂Ƃ
		movea.l	sp,a1			;tHgf[^
		move.l	#$AAAAAAAA,d2
		moveq.l	#1,d0
		and.b	BIOS_CURSOR_FRACTION.w,d0
		rol.l	d0,d2
		moveq.l	#16-1,d3
		for	d3
			move.l	(a1),d0
			move.l	d0,d1
			lsr.l	#1,d1			;
			lsl.l	#1,d0			;E
			or.l	d1,d0
			if	<cmpa.l sp,a1>,ne
				or.l	-4(a1),d0	;
			endif
			if	<tst.w d3>,ne
				or.l	4(a1),d0	;
			endif
			and.l	d2,d0			;bV
			not.l	d0
			and.l	d0,(a1)+
			rol.l	#1,d2
		next
	endif
;----------------
;
;<d6.w:hbgB1`17
;<(sp).l[16]:tHgf[^
	if	<btst.b #BIOS_UNDERLINE_BIT,BIOS_ATTRIBUTE_1.w>,ne	;̂Ƃ
		movea.l	sp,a1			;tHgf[^
		moveq.l	#1,d0
		ror.l	d6,d0
		neg.l	d0
		or.l	d0,4*15(a1)
	endif
;----------------
;
;<d6.w:hbgB1`17
;<(sp).l[16]:tHgf[^
	if	<btst.b #BIOS_STRIKETHROUGH_BIT,BIOS_ATTRIBUTE_1.w>,ne	;̂Ƃ
		movea.l	sp,a1			;tHgf[^
		moveq.l	#1,d0
		ror.l	d6,d0
		neg.l	d0
		or.l	d0,4*8(a1)
	endif
;----------------
;g
;<d6.w:hbgB1`17
;<(sp).l[16]:tHgf[^
	if	<btst.b #BIOS_WAVELINE_BIT,BIOS_ATTRIBUTE_2.w>,ne	;ĝƂ
		movea.l	sp,a1			;tHgf[^
		moveq.l	#1,d2
		ror.l	d6,d2
		neg.l	d2
		moveq.l	#3,d0
		and.b	BIOS_CURSOR_FRACTION.w,d0
  .if 0
		move.l	#$CCCCCCCC,d1
		rol.l	d0,d1
		move.l	d1,d0			;11001100
		not.l	d1			;00110011
		and.l	d2,d0
		and.l	d2,d1
		or.l	d0,4*14(a1)
		or.l	d1,4*15(a1)
  .else
		move.l	#$88888888,d1
		move.l	#$55555555,d3
		rol.l	d0,d1			;10001000
		rol.l	d0,d3			;01010101
		move.l	d1,d0
		rol.l	#2,d0			;00100010
		and.l	d2,d0
		and.l	d2,d1
		and.l	d2,d3
		or.l	d0,4*13(a1)
		or.l	d3,4*14(a1)
		or.l	d1,4*15(a1)
  .endif
	endif
;----------------
;lp͂
	if	<btst.b #BIOS_FRAME_BIT,BIOS_ATTRIBUTE_2.w>,ne	;lp݂͂̂Ƃ
	;16x16̒Ɋ񂹂
		moveq.l	#16,d1
		sub.w	d6,d1
		if	hs
			lsr.w	#1,d1
			movea.l	sp,a1
			moveq.l	#16-1,d3
			for	d3
				move.l	(a1),d0
				lsr.l	d1,d0
				move.l	d0,(a1)+
			next
			moveq.l	#16,d6
		endif
	;16x1612x12ɏk
		lea.l	subscript_pattern(pc),a2
		lea.l	4*0(sp),a0
		lea.l	4*0(sp),a1
		moveq.l	#0,d0
		moveq.l	#4-1,d3
		for	d3
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.b	4(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#6,d2
			move.b	5(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#2,d2
			or.w	d2,d1
			move.w	d1,(a1)
			addq.l	#8,a0
			addq.l	#4,a1
		;
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
			addq.l	#4,a0
			addq.l	#4,a1
		;
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
			addq.l	#4,a0
			addq.l	#4,a1
		next
		clr.l	4*12(sp)
		clr.l	4*13(sp)
		clr.l	4*14(sp)
		clr.l	4*15(sp)
	;16x16̒Ɋ񂹂
		lea.l	4*12(sp),a0
		lea.l	4*14(sp),a1
		moveq.l	#12-1,d3
		for	d3
			move.l	-(a0),d0
			lsr.l	#2,d0
			move.l	d0,-(a1)
		next
		clr.l	4*0(sp)
		clr.l	4*1(sp)
	;lpt
		movea.l	sp,a0
		or.l	#$FFFF0000,(a0)+
		moveq.l	#14-1,d3
		for	d3
			or.l	#$80010000,(a0)+
		next
		or.l	#$FFFF0000,(a0)+
	endif
;----------------
;ۈ͂
	if	<btst.b #BIOS_ENCIRCLE_BIT,BIOS_ATTRIBUTE_2.w>,ne	;ۈ݂͂̂Ƃ
	;16x16̒Ɋ񂹂
		moveq.l	#16,d1
		sub.w	d6,d1
		if	hs
			lsr.w	#1,d1
			movea.l	sp,a1
			moveq.l	#16-1,d3
			for	d3
				move.l	(a1),d0
				lsr.l	d1,d0
				move.l	d0,(a1)+
			next
			moveq.l	#16,d6
		endif
	;16x1612x12ɏk
		lea.l	subscript_pattern(pc),a2
		lea.l	4*0(sp),a0
		lea.l	4*0(sp),a1
		moveq.l	#0,d0
		moveq.l	#4-1,d3
		for	d3
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.b	4(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#6,d2
			move.b	5(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#2,d2
			or.w	d2,d1
			move.w	d1,(a1)
			addq.l	#8,a0
			addq.l	#4,a1
		;
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
			addq.l	#4,a0
			addq.l	#4,a1
		;
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
			addq.l	#4,a0
			addq.l	#4,a1
		next
		clr.l	4*12(sp)
		clr.l	4*13(sp)
		clr.l	4*14(sp)
		clr.l	4*15(sp)
	;16x16̒Ɋ񂹂
		lea.l	4*12(sp),a0
		lea.l	4*14(sp),a1
		moveq.l	#12-1,d3
		for	d3
			move.l	-(a0),d0
			lsr.l	#2,d0
			move.l	d0,-(a1)
		next
		clr.l	4*0(sp)
		clr.l	4*1(sp)
	;ۂt
		movea.l	sp,a0
	;	perl -e "for$y(0..15){print qq(\t\tandi.l\t#%);for$x(0..15){$t=($x-7.5)*($x-7.5)+($y-7.5)*($y-7.5);print($t<=8**2?'1':'0');}print qq(_0000000000000000,(a0)+\n);}"
		andi.l	#%0000011111100000_0000000000000000,(a0)+
		andi.l	#%0001111111111000_0000000000000000,(a0)+
		andi.l	#%0011111111111100_0000000000000000,(a0)+
		andi.l	#%0111111111111110_0000000000000000,(a0)+
		andi.l	#%0111111111111110_0000000000000000,(a0)+
		andi.l	#%1111111111111111_0000000000000000,(a0)+
		andi.l	#%1111111111111111_0000000000000000,(a0)+
		andi.l	#%1111111111111111_0000000000000000,(a0)+
		andi.l	#%1111111111111111_0000000000000000,(a0)+
		andi.l	#%1111111111111111_0000000000000000,(a0)+
		andi.l	#%1111111111111111_0000000000000000,(a0)+
		andi.l	#%0111111111111110_0000000000000000,(a0)+
		andi.l	#%0111111111111110_0000000000000000,(a0)+
		andi.l	#%0011111111111100_0000000000000000,(a0)+
		andi.l	#%0001111111111000_0000000000000000,(a0)+
		andi.l	#%0000011111100000_0000000000000000,(a0)+
		movea.l	sp,a0
	;	perl -e "for$y(0..15){print qq(\t\tori.l\t#%);for$x(0..15){$t=($x-7.5)*($x-7.5)+($y-7.5)*($y-7.5);print(7**2<=$t&&$t<=8**2?'1':'0');}print qq(_0000000000000000,(a0)+\n);}"
		ori.l	#%0000011111100000_0000000000000000,(a0)+
		ori.l	#%0001100000011000_0000000000000000,(a0)+
		ori.l	#%0011000000001100_0000000000000000,(a0)+
		ori.l	#%0110000000000110_0000000000000000,(a0)+
		ori.l	#%0100000000000010_0000000000000000,(a0)+
		ori.l	#%1000000000000001_0000000000000000,(a0)+
		ori.l	#%1000000000000001_0000000000000000,(a0)+
		ori.l	#%1000000000000001_0000000000000000,(a0)+
		ori.l	#%1000000000000001_0000000000000000,(a0)+
		ori.l	#%1000000000000001_0000000000000000,(a0)+
		ori.l	#%1000000000000001_0000000000000000,(a0)+
		ori.l	#%0100000000000010_0000000000000000,(a0)+
		ori.l	#%0110000000000110_0000000000000000,(a0)+
		ori.l	#%0011000000001100_0000000000000000,(a0)+
		ori.l	#%0001100000011000_0000000000000000,(a0)+
		ori.l	#%0000011111100000_0000000000000000,(a0)+
	endif
;----------------
;
;<d6.w:hbgB1`17
;<(sp).l[16]:tHgf[^
	if	<btst.b #BIOS_OVERLINE_BIT,BIOS_ATTRIBUTE_2.w>,ne	;̂Ƃ
		movea.l	sp,a1			;tHgf[^
		moveq.l	#1,d0
		ror.l	d6,d0
		neg.l	d0
		or.l	d0,4*0(a1)
	endif
;----------------
;t
;	4x4̏2hbgƍ2hbgꂼOR1hbgɂ邱ƂŁA4x43x3ɏk
;	SX-WindowƓ@
;	c16hbg12hbgɏkA1hbg̍ɔzu
;<d6.w:hbgB1`16
;<(sp).l[16]:tHgf[^
;>d6.w:hbgB1`12
	if	<btst.b #BIOS_SUBSCRIPT_BIT,BIOS_ATTRIBUTE_2.w>,ne	;t̂Ƃ
		lea.l	subscript_pattern(pc),a2
		lea.l	4*16(sp),a0
		lea.l	4*15(sp),a1
		moveq.l	#0,d0
		moveq.l	#4-1,d3
		for	d3
			subq.l	#8,a0
			subq.l	#4,a1
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.b	4(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#6,d2
			move.b	5(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#2,d2
			or.w	d2,d1
			move.w	d1,(a1)
		;
			subq.l	#4,a0
			subq.l	#4,a1
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
		;
			subq.l	#4,a0
			subq.l	#4,a1
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
		next
		clr.l	4*0(sp)
		clr.l	4*1(sp)
		clr.l	4*2(sp)
		clr.l	4*15(sp)
		moveq.l	#3,d0
		and.w	d6,d0
		lsr.w	#2,d6
		move.w	d6,d1
		add.w	d6,d6
		add.w	d1,d6
		add.w	d0,d6
	endif
;----------------
;t
;	4x4̏2hbgƍ2hbgꂼOR1hbgɂ邱ƂŁA4x43x3ɏk
;	SX-WindowƓ@
;	c16hbg12hbgɏkAォ0hbg̍ɔzu
;<d6.w:hbgB1`16
;<(sp).l[16]:tHgf[^
;>d6.w:hbgB1`12
	if	<btst.b #BIOS_SUPERSCRIPT_BIT,BIOS_ATTRIBUTE_2.w>,ne	;t̂Ƃ
		lea.l	subscript_pattern(pc),a2
		lea.l	4*0(sp),a0
		lea.l	4*0(sp),a1
		moveq.l	#0,d0
		moveq.l	#4-1,d3
		for	d3
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.b	4(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#6,d2
			move.b	5(a0),d0
			move.b	(a2,d0.w),d2
			lsl.w	#2,d2
			or.w	d2,d1
			move.w	d1,(a1)
			addq.l	#8,a0
			addq.l	#4,a1
		;
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
			addq.l	#4,a0
			addq.l	#4,a1
		;
			move.b	(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#6,d1
			move.b	1(a0),d0
			move.b	(a2,d0.w),d1
			lsl.w	#2,d1
			move.w	d1,(a1)
			addq.l	#4,a0
			addq.l	#4,a1
		next
		clr.l	4*12(sp)
		clr.l	4*13(sp)
		clr.l	4*14(sp)
		clr.l	4*15(sp)
		moveq.l	#3,d0
		and.w	d6,d0
		lsr.w	#2,d6
		move.w	d6,d1
		add.w	d6,d6
		add.w	d1,d6
		add.w	d0,d6
	endif
;----------------
;]
;	Ŝ𔽓]
;<d6.w:hbgB1`17
;<(sp).l[16]:tHgf[^
	if	<btst.b #BIOS_REVERSE_BIT,BIOS_ATTRIBUTE_1.w>,ne	;]̂Ƃ
		movea.l	sp,a1			;tHgf[^
		moveq.l	#1,d0
		ror.l	d6,d0
		neg.l	d0
		moveq.l	#16-1,d3
		for	d3
			eor.l	d0,(a1)+
		next
	endif
;----------------
;}XNf[^
;<d6.w:hbgB1`17
;>4*16(sp).l[16]:}XNf[^
	lea.l	4*16(sp),a1		;}XNf[^
	moveq.l	#1,d0
	ror.l	d6,d0
	neg.l	d0
	moveq.l	#16-1,d3
	for	d3
		move.l	d0,(a1)+
	next
;----------------
;Α
;	ŜE0`3hbg炷
;	v|[VîƂ3hbg
;	Α̂𑱂ĕ`悷ƂJ[\Ȃ3hbgl߂
;<d6.w:hbgB1`17
;<(sp).l[16]:tHgf[^
;<4*16(sp).l[16]:}XNf[^
;>d6.w:hbgB1`20
	if	<btst.b #BIOS_ITALIC_BIT,BIOS_ATTRIBUTE_1.w>,ne	;Α̂̂Ƃ
		movea.l	sp,a0			;tHgf[^
		lea.l	4*16(sp),a1		;}XNf[^
*		if	<btst.b #BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w>,ne	;v|[VîƂ
			moveq.l	#3,d3
			do
				moveq.l	#4-1,d2
				for	d2
					move.l	(a0),d0
					lsr.l	d3,d0
					move.l	d0,(a0)+
					move.l	(a1),d0
					lsr.l	d3,d0
					move.l	d0,(a1)+
				next
				subq.w	#1,d3
			while	ne
			addq.w	#3,d6			;3hbg
			bset.b #BIOS_CONNECTION_BIT,BIOS_CONSOLE_STATUS.w
			if	ne			;ÂƂ
				subq.b	#3,BIOS_CURSOR_FRACTION.w	;3hbgl߂
				if	cs
					addq.b	#8,BIOS_CURSOR_FRACTION.w
					subq.w	#1,BIOS_CURSOR_COLUMN.w
					if	cs
						clr.w	BIOS_CURSOR_COLUMN.w	;Ö
						clr.b	BIOS_CURSOR_FRACTION.w
					endif
				endif
			endif
*		else				;v|[Vił͂ȂƂ
*			moveq.l	#1,d4
*			ror.l	d6,d4
*			neg.l	d4
*			moveq.l	#4-1,d2
*			for	d2
*				move.l	(a0),d0
*				lsr.l	#2,d0
*				and.l	d4,d0			;𑝂₳Ȃ
*				move.l	d0,(a0)+
*				move.l	(a1),d0
*				lsr.l	#2,d0
*				and.l	d4,d0			;𑝂₳Ȃ
*				move.l	d0,(a1)+
*			next
*			moveq.l	#4-1,d2
*			for	d2
*				move.l	(a0),d0
*				lsr.l	#1,d0
*				and.l	d4,d0			;𑝂₳Ȃ
*				move.l	d0,(a0)+
*				move.l	(a1),d0
*				lsr.l	#1,d0
*				and.l	d4,d0			;𑝂₳Ȃ
*				move.l	d0,(a1)+
*			next
*			lea.l	4*4(a0),a0
*			lea.l	4*4(a1),a1
*			moveq.l	#4-1,d2
*			for	d2
*				move.l	(a0),d0
*				lsl.l	#1,d0
*				move.l	d0,(a0)+
*				move.l	(a1),d0
*				lsl.l	#1,d0
*				move.l	d0,(a1)+
*			next
*		endif
	else				;Α̂ł͂ȂƂ
		bclr.b	#BIOS_CONNECTION_BIT,BIOS_CONSOLE_STATUS.w
	endif
;----------------
;݂̍sɓ؂ȂΉs
;<d6.w:hbg
	move.w	BIOS_CONSOLE_RIGHT.w,d0
	addq.w	#1,d0
	lsl.w	#3,d0			;R\[̃hbg
	move.w	BIOS_CURSOR_COLUMN.w,d1
	lsl.w	#3,d1
	add.b	BIOS_CURSOR_FRACTION.w,d1	;J[\XhbgW
	sub.w	d1,d0			;R\[̃hbg-J[\XhbgW=chbg
	if	le			;chbg<=0Bɂ͂ݏoĂ
	;s
		move.w	BIOS_CURSOR_ROW.w,d0
		if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
			addq.w	#1,d0			;1s
			move.w	d0,BIOS_CURSOR_ROW.w
		else				;[̂Ƃ
			moveq.l	#1,d0			;Rs[̏[̍sW
			move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
			moveq.l	#0,d2			;Rs[̏[̍sW
			bsr	putc_copy_rows		;sRs[
			move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
			move.w	d0,d1			;[̍sW
			bsr	putc_clear_rows		;s
		endif
		clr.w	BIOS_CURSOR_COLUMN.w	;[
		clr.b	BIOS_CURSOR_FRACTION.w
	elif	<cmp.w d6,d0>,lt	;chbg<hbgB؂Ȃ
	;c󔒂Ŗ߂
		move.w	BIOS_CURSOR_ROW.w,d0	;[̍sW
		move.w	d0,d1			;[̍sW
		move.w	BIOS_CURSOR_COLUMN.w,d2	;[̌W
		move.w	BIOS_CONSOLE_RIGHT.w,d3	;E[̌W
		moveq.l	#7,d4
		and.b	BIOS_CURSOR_FRACTION.w,d4	;[̌W̒[
		moveq.l	#7,d5			;E[̌W̒[
		bsr	putc_clear		;
		;s
		move.w	BIOS_CURSOR_ROW.w,d0
		if	<cmp.w BIOS_CONSOLE_BOTTOM.w,d0>,lo	;[ł͂ȂƂ
			addq.w	#1,d0			;1s
			move.w	d0,BIOS_CURSOR_ROW.w
		else				;[̂Ƃ
			moveq.l	#1,d0			;Rs[̏[̍sW
			move.w	BIOS_CONSOLE_BOTTOM.w,d1	;Rs[̉[̍sW
			moveq.l	#0,d2			;Rs[̏[̍sW
			bsr	putc_copy_rows		;sRs[
			move.w	BIOS_CONSOLE_BOTTOM.w,d0	;[̍sW
			move.w	d0,d1			;[̍sW
			bsr	putc_clear_rows		;s
		endif
		clr.w	BIOS_CURSOR_COLUMN.w	;[
		clr.b	BIOS_CURSOR_FRACTION.w
	endif
;----------------
;`
;<d6.w:hbg
;<(sp).l[16]:tHgf[^
;<4*16(sp).l[16]:}XNf[^
	move.w	BIOS_CURSOR_ROW.w,d0	;sW
	move.w	BIOS_CURSOR_COLUMN.w,d1	;W
	moveq.l	#7,d2
	and.b	BIOS_CURSOR_FRACTION.w,d2	;W̒[
	move.w	d6,d3			;hbg
	moveq.l	#3,d4
	and.b	BIOS_ATTRIBUTE_1.w,d4	;v[
	movea.l	sp,a0			;tHgf[^
	lea.l	4*16(sp),a1		;}XNf[^
	bsr	putc_draw		;`
;----------------
;J[\i߂
;<d6.w:hbg
	add.b	BIOS_CURSOR_FRACTION.w,d6	;J[\̌W̒[+hbg
	moveq.l	#7,d0
	and.w	d6,d0
	move.b	d0,BIOS_CURSOR_FRACTION.w	;J[\̌W̒[
	lsr.w	#3,d6
	add.w	d6,BIOS_CURSOR_COLUMN.w	;J[\̌WB傤ǉE[ɂȂꍇ邪ł͉sȂ
;----------------
;J[\ON
	bsr	iocs_1E_B_CURON
;----------------
putc_output_end:
	lea.l	4*16+4*16(sp),sp	;tHgf[^ƃ}XNf[^
	pop
	rts

;----------------------------------------------------------------
;tŎgp^[
;	
subscript_pattern:
  .irp ff,%00000000,%10000000,%10000000,%10000000
    .irp ee,%00000000,%01000000
      .irp dd,%00000000,%00100000
        .irp cc,%00000000,%00010000,%00010000,%00010000
          .irp bb,%00000000,%00001000
            .irp aa,%00000000,%00000100
	.dc.b	ff+ee+dd+cc+bb+aa
            .endm
          .endm
        .endm
      .endm
    .endm
  .endm

;----------------------------------------------------------------
;`
;<d0.l:sW
;<d1.l:W
;<d2.l:W̒[
;<d3.l:hbg
;<d4.l:v[B1̉2rbg
;<(a0).l[16]:tHgf[^B񂹁Bo[X܂߂ĉHς
;<(a1).l[16]:}XNf[^B񂹁Bރrbg1
putc_draw:
	push	d0-d5/a0-a4
;----------------
;AhX߂
	swap.w	d0
	clr.w	d0			;65536*sW
	lsr.l	#5,d0			;128*16*sW
	add.w	d1,d0			;128*16*sW+W
	add.l	BIOS_CONSOLE_OFFSET.w,d0	;`n߂AhX̃ItZbg
	add.l	#$00E00000,d0		;`n߂AhX
	bclr.l	#0,d0			;ɂ
	if	ne
		addq.w	#8,d2
	endif
;<d2.w:W̒[B0`15
	movea.l	d0,a4
;<a4.l:`n߂AhXB
;?d0-d1
;----------------
	add.w	d2,d3			;W̒[+hbg
;<d3.w:W̒[+hbg
;----------------
;1[hɎ܂邩A2[hɌׂ邩A3[hɌׂ邩
	if	<cmp.w #16,d3>,ls
	;----------------
	;1[hɎ܂Ƃ
		do				;v[̃[v
			lsr.b	#1,d4
			if	cs			;v[ɕ`悷Ƃ
				movea.l	a0,a2			;tHgf[^
				movea.l	a1,a3			;}XNf[^
				moveq.l	#16-1,d5
				for	d5			;X^̃[v
					move.w	(a2)+,d0		;tHg
					move.w	(a3)+,d1		;}XN
					lsr.w	d2,d0
					lsr.w	d2,d1
					not.w	d1
					and.w	(a4),d1			;蔲
					or.w	d1,d0			;킹
					move.w	d0,(a4)+		;
					addq.l	#4-2,a2
					addq.l	#4-2,a3
					lea.l	128-2(a4),a4		;̃X^
				next
			else				;v[Ƃ
				movea.l	a1,a3			;}XNf[^
				moveq.l	#16-1,d5
				for	d5			;X^̃[v
					move.w	(a3)+,d1		;}XN
					lsr.w	d2,d1
					not.w	d1
					and.w	d1,(a4)+		;蔲
					addq.l	#4-2,a3
					lea.l	128-2(a4),a4		;̃X^
				next
			endif
			adda.l	#-128*16+128*1024,a4	;̃v[
		while	<cmpa.l #$00E40000,a4>,lo
	elif	<cmp.w #32,d3>,ls
	;----------------
	;2[hɌׂƂ
		do				;v[̃[v
			lsr.b	#1,d4
			if	cs			;v[ɕ`悷Ƃ
				movea.l	a0,a2			;tHgf[^
				movea.l	a1,a3			;}XNf[^
				moveq.l	#16-1,d5
				for	d5			;X^̃[v
					move.l	(a2)+,d0		;tHg
					move.l	(a3)+,d1		;}XN
					lsr.l	d2,d0
					lsr.l	d2,d1
					not.l	d1
					and.l	(a4),d1			;蔲
					or.l	d1,d0			;킹
					move.l	d0,(a4)+		;
				;	addq.l	#4-4,a2
				;	addq.l	#4-4,a3
					lea.l	128-4(a4),a4		;̃X^
				next
			else				;v[Ƃ
				movea.l	a1,a3			;}XNf[^
				moveq.l	#16-1,d5
				for	d5			;X^̃[v
					move.l	(a3)+,d1		;}XN
					lsr.l	d2,d1
					not.l	d1
					and.l	d1,(a4)+		;蔲
				;	addq.l	#4-4,a3
					lea.l	128-4(a4),a4		;̃X^
				next
			endif
			adda.l	#-128*16+128*1024,a4	;̃v[
		while	<cmpa.l #$00E40000,a4>,lo
	else
	;----------------
	;3[hɌׂƂ
		do				;v[̃[v
			lsr.b	#1,d4
			if	cs			;v[ɕ`悷Ƃ
				movea.l	a0,a2			;tHgf[^
				movea.l	a1,a3			;}XNf[^
				moveq.l	#16-1,d5
				for	d5			;X^̃[v
					move.l	(a2)+,d0		;tHg
					move.l	(a3)+,d1		;}XN
					lsr.l	d2,d0
					lsr.l	d2,d1
					not.l	d1
					and.l	(a4),d1			;蔲
					or.l	d1,d0			;킹
					move.l	d0,(a4)+		;
					move.w	-2(a2),d0		;tHg
					move.w	-2(a3),d1		;}XN
					swap.w	d0
					swap.w	d1
					clr.w	d0
					clr.w	d1
					lsr.l	d2,d0
					lsr.l	d2,d1
					not.w	d1
					and.w	(a4),d1			;蔲
					or.w	d1,d0			;킹
					move.w	d0,(a4)+		;
				;	addq.l	#4-4,a2
				;	addq.l	#4-4,a3
					lea.l	128-6(a4),a4		;̃X^
				next
			else				;v[Ƃ
				movea.l	a1,a3			;}XNf[^
				moveq.l	#16-1,d5
				for	d5			;X^̃[v
					move.l	(a3)+,d1		;}XN
					lsr.l	d2,d1
					not.l	d1
					and.l	d1,(a4)+		;蔲
					move.w	-2(a3),d1		;}XN
					swap.w	d1
					clr.w	d1
					lsr.l	d2,d1
					not.w	d1
					and.w	d1,(a4)+		;蔲
				;	addq.l	#4-4,a3
					lea.l	128-6(a4),a4		;̃X^
				next
			endif
			adda.l	#-128*16+128*1024,a4	;̃v[
		while	<cmpa.l #$00E40000,a4>,lo
	endif
	pop
	rts

;----------------------------------------------------------------
;sRs[
;	    
;	            
;	          d2
;	d0                  
;	                    
;	d1        
;	            
;	    
;	    
;	            
;	d0        
;	                    d2
;	d1                  
;	          
;	            
;	    
;<d0.w:Rs[̏[̍sW
;<d1.w:Rs[̉[̍sW
;<d2.w:Rs[̏[̍sW
putc_copy_rows:
	push	d0-d3/a0
	move.l	BIOS_CONSOLE_OFFSET.w,d3	;R\[̍̃AhX̃ItZbg
	lsr.l	#7,d3			;R\[̏[YhbgW
	lsr.w	#2,d3			;R\[̏[̃X^ubNԍ
	sub.w	d0,d1			;Rs[̉[̍sW-Rs[̏[̍sW=Rs[s-1
	lsl.w	#2,d1			;Rs[郉X^ubN-4
	addq.w	#3,d1			;Rs[郉X^ubN-1
;<d1.w:Rs[郉X^ubN-1
	lsl.w	#2,d0
	add.w	d3,d0			;Rs[̏[̃X^ubNԍ
;<d0.w:Rs[̏[̃X^ubNԍ
	lsl.w	#2,d2
	add.w	d3,d2			;Rs[̏[̃X^ubNԍ
;<d2.w:Rs[̏[̃X^ubNԍ
	if	<cmp.w d0,d2>,ls	;ɂ炷Ƃ
		move.w	#$0101,d3		;X^ubNԍ̑
	else				;ɂ炷Ƃ
		add.w	d1,d0			;Rs[̉[̃X^ubNԍ
		add.w	d1,d2			;Rs[̉[̃X^ubNԍ
		move.w	#$FEFF,d3		;X^ubNԍ̑
	endif
;<d0.w:Rs[̃X^ubNԍ
;<d2.w:Rs[̃X^ubNԍ
;<d3.w:X^ubNԍ̑
	lsl.w	#8,d0			;Rs[̃X^ubNԍ<<8
	move.b	d2,d0			;Rs[̃X^ubNԍ<<8|Rs[̃X^ubNԍ
;<d0.w:Rs[̃X^ubNԍ<<8|Rs[̃X^ubNԍ
aGPDR	reg	a0
	lea.l	MFP_GPDR,aGPDR		;GPIPf[^WX^BHSYNC|RINT|-|VDISP|OPMIRQ|POWER|EXPWON|ALARM
	move.w	sr,d2
	for	d1			;X^ubÑ[v
		do
		while	<tst.b (aGPDR)>,mi	;\Ԃ҂
		ori.w	#$0700,sr		;荞݂֎~
		do
		while	<tst.b (aGPDR)>,pl	;AԂ҂
		move.w	d0,CRTC_BLOCK-MFP_GPDR(aGPDR)	;X^ubNԍݒ肷
		move.w	#$0008,CRTC_ACTION-MFP_GPDR(aGPDR)	;X^Rs[ONɂB2ڈȍ~͕sv
		move.w	d2,sr			;荞݂
		add.w	d3,d0			;̃X^ubN
	next
	do
	while	<tst.b (aGPDR)>,mi	;\Ԃ҂
	ori.w	#$0700,sr		;荞݂֎~
	do
	while	<tst.b (aGPDR)>,pl	;AԂ҂
	move.w	d2,sr			;荞݂
	clr.w	CRTC_ACTION-MFP_GPDR(aGPDR)	;X^Rs[OFFɂBKv
	pop
	rts

;----------------------------------------------------------------
;s
;<d0.w:[̍sW
;<d1.w:[̍sW
putc_clear_rows:
	push	d2-d5
	moveq.l	#0,d2			;[̌W
	move.w	BIOS_CONSOLE_RIGHT.w,d3	;E[̌W
	moveq.l	#0,d4			;[̌W̒[
	moveq.l	#7,d5			;E[̌W̒[
	bsr	putc_clear		;
	pop
	rts

;----------------------------------------------------------------
;
;	͋󔒂̕`ƓBwiFœhׂ
;				F	wiF
;		0				
;		1			F	
;		2			F	
;		3				
;		4				
;		5			F	
;		6			F	
;		7				
;		8	]			
;		9	]			F
;		10	]			F
;		11	]			
;		12	]			
;		13	]			F
;		14	]			F
;		15	]			
;<d0.w:[̍sW
;<d1.w:[̍sW
;<d2.w:[̌W
;<d3.w:E[̌W
;<d4.w:[̌W̒[B0`7B܂
;<d5.w:E[̌W̒[B0`7B܂
putc_clear:
	push	d0-d7/a0-a3
;----------------
;X^߂
	sub.w	d0,d1			;[̍sW-[̍sW=s-1
	addq.w	#1,d1			;s
	lsl.w	#4,d1			;16*s=X^
	subq.w	#1,d1			;X^-1
	movea.w	d1,a3
;<a3.w:X^-1
;?d1
;----------------
;AhX߂
	swap.w	d0
	clr.w	d0			;65536*sW
	lsr.l	#5,d0			;128*16*sW
	add.l	BIOS_CONSOLE_OFFSET.w,d0	;[̍s̍̃AhX̃ItZbg
	add.l	#$00E00000,d0		;[̍s̍̃AhX
	ext.l	d2
	ext.l	d3
	add.l	d0,d2			;̃AhX
	add.l	d0,d3			;ẼAhX
;<d2.l:̃AhX
;<d3.l:ẼAhX
;?d0
;----------------
;AhXɂ
;	Wł͂ȂAhXɂ
;	_B_CONSOL̓R\[̍[̃AhXɐĂȂ
	bclr.l	#0,d2
	if	ne
		addq.w	#8,d4
	endif
;<d2.l:̃AhXB
;<d4.w:[̌W̒[B0`15
	bclr.l	#0,d3
	if	ne
		addq.w	#8,d5
	endif
;<d3.l:ẼAhXB
;<d5.w:E[̌W̒[B0`15
	movea.l	d2,a2
;<a2.l:̃AhXB
;----------------
;[h߂
	sub.w	d2,d3			;E[̃AhX-[̃AhX=2*([h-1)
	lsr.w	#1,d3			;[h-1
;<d3.w:[h-1
;?d2
;----------------
;}XN
	moveq.l	#-1,d6
	move.w	#$8000,d7
	lsr.w	d4,d6			;[̏ޕ1̃}XNB$FFFF,$7FFF,c,$0003,$0001
	asr.w	d5,d7			;E[̏ޕ1̃}XNB$8000,$C000,c,$FFFE,$FFFF
;<d6.w:[̏ޕ1̃}XNB$FFFF,$7FFF,c,$0003,$0001
;<d7.w:E[̏ޕ1̃}XNB$8000,$C000,c,$FFFE,$FFFF
;?d4-d5
;----------------
;f[^
	moveq.l	#%1111,d0
	and.b	BIOS_ATTRIBUTE_1.w,d0	;v[##
;		  111111
;		  5432109876543210
	move.w	#%1100110000000000,d2	;wiFF܂͔Bv[1hׂ
	btst.l	d0,d2
	sne.b	d2
	ext.w	d2
	swap.w	d2
;		  111111
;		  5432109876543210
	move.w	#%1010101000000000,d2	;wiFF܂͔Bv[0hׂ
	btst.l	d0,d2
	sne.b	d2
	ext.w	d2
;<d2.l:v[1̃f[^<<16|v[0̃f[^
;----------------
;1[h1[hł͂Ȃ
	if	<tst.w d3>,eq
	;----------------
	;1[ĥƂ
		and.w	d7,d6
	;<d6.w:ޕ1̃}XN
		and.w	d6,d2
		swap.w	d2
		and.w	d6,d2
		swap.w	d2
	;<d2.l:v[1̃f[^<<16|v[0̃f[^
		not.w	d6
	;<d6.w:܂Ȃ1̃}XN
		do				;v[̃[v
			movea.l	a2,a0			;̃AhX[̃AhX
			move.w	a3,d1			;X^-1
			for	d1			;X^̃[v
				move.w	(a0),d0
				and.w	d6,d0			;}XN
				or.w	d2,d0			;f[^
				move.w	d0,(a0)
				lea.l	128(a0),a0		;̍[̃AhX
			next
			swap.w	d2			;̃v[̃f[^
			adda.l	#128*1024,a2		;̃v[̍̃AhX
		while	<cmpa.l #$00E40000,a2>,lo
	else
	;----------------
	;1[hł͂ȂƂ
		subq.w	#1,d3
	;<d3.w:[ƉE[̊Ԃ̃[hB0`
		move.l	d2,d4
		move.l	d2,d5
	;<d4.l:v[1̃f[^<<16|v[0̃f[^
	;<d5.l:v[1̃f[^<<16|v[0̃f[^
		and.w	d6,d4
		and.w	d7,d5
		swap.w	d4
		swap.w	d5
		and.w	d6,d4
		and.w	d7,d5
		swap.w	d4
		swap.w	d5
	;<d4.l:v[1̍[̃f[^<<16|v[0̍[̃f[^
	;<d5.l:v[1̉E[̃f[^<<16|v[0̉E[̃f[^
		not.w	d6
		not.w	d7
	;<d6.w:[̏܂Ȃ1̃}XNB$0000,$8000,c,$FFFC,$FFFE
	;<d7.w:E[̏܂Ȃ1̃}XNB$7FFF,$3FFF,c,$0001,$0000
		do				;v[̃[v
			movea.l	a2,a1			;̃AhX[̃AhX
			move.w	a3,d1			;X^-1
			for	d1			;X^̃[v
				movea.l	a1,a0			;[̃AhX̃AhX
			;[
				move.w	(a0),d0
				and.w	d6,d0			;[̃}XN
				or.w	d4,d0			;[̃f[^
				move.w	d0,(a0)+
			;[ƉE[̊
				move.w	d3,d0			;[ƉE[̊Ԃ̃[hB0`
				forcontinue	d0
					move.w	d2,(a0)+		;f[^
				next
			;E[
				move.w	(a0),d0
				and.w	d7,d0			;E[̃}XN
				or.w	d5,d0			;E[̃f[^
				move.w	d0,(a0)+
				lea.l	128(a1),a1		;̍[̃AhX
			next
			swap.w	d2			;̃v[̃f[^
			swap.w	d4			;̃v[̍[̃f[^
			swap.w	d5			;̃v[̉E[̃f[^
			adda.l	#128*1024,a2		;̃v[̍̃AhX
		while	<cmpa.l #$00E40000,a2>,lo
	endif
	pop
	rts

;----------------------------------------------------------------
;v|[VitHg($20`$82)
proportional_font:
	.dc.w	6	;$20   
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$21 I
	.dc.w	%0000000000000000
	.dc.w	%0010000000000000
	.dc.w	%0111000000000000
	.dc.w	%0111000000000000
	.dc.w	%0111000000000000
	.dc.w	%0111000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0010000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$22 h
	.dc.w	%0000000000000000
	.dc.w	%0110011000000000
	.dc.w	%0110011000000000
	.dc.w	%0010001000000000
	.dc.w	%0010001000000000
	.dc.w	%0100010000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$23 
	.dc.w	%0000000000000000
	.dc.w	%0001001000000000
	.dc.w	%0001001000000000
	.dc.w	%0001001000000000
	.dc.w	%0111111100000000
	.dc.w	%0010010000000000
	.dc.w	%0010010000000000
	.dc.w	%0010010000000000
	.dc.w	%1111111000000000
	.dc.w	%0100100000000000
	.dc.w	%0100100000000000
	.dc.w	%0100100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$24 
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0111110000000000
	.dc.w	%1001001000000000
	.dc.w	%1101000000000000
	.dc.w	%0111100000000000
	.dc.w	%0011110000000000
	.dc.w	%0001011000000000
	.dc.w	%1001001000000000
	.dc.w	%0111110000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$25 
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%1001000010000000
	.dc.w	%1001000100000000
	.dc.w	%1001001000000000
	.dc.w	%0110010000000000
	.dc.w	%0000100000000000
	.dc.w	%0001001100000000
	.dc.w	%0010010010000000
	.dc.w	%0100010010000000
	.dc.w	%1000010010000000
	.dc.w	%0000001100000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$26 
	.dc.w	%0000000000000000
	.dc.w	%0111000000000000
	.dc.w	%1000100000000000
	.dc.w	%1000100000000000
	.dc.w	%1000100000000000
	.dc.w	%0101000000000000
	.dc.w	%0011000000000000
	.dc.w	%0100100100000000
	.dc.w	%1000010100000000
	.dc.w	%1000001000000000
	.dc.w	%1000010100000000
	.dc.w	%0111100010000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$27 f
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$28 i
	.dc.w	%0000000000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$29 j
	.dc.w	%0000000000000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%1000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$2A 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0001000000000000
	.dc.w	%1001001000000000
	.dc.w	%0101010000000000
	.dc.w	%0011100000000000
	.dc.w	%0101010000000000
	.dc.w	%1001001000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$2B {
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%1111111000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$2C C
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$2D |
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$2E D
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$2F ^
	.dc.w	%0000000000000000
	.dc.w	%0000100000000000
	.dc.w	%0000100000000000
	.dc.w	%0000100000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$30 O
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$31 P
	.dc.w	%0000000000000000
	.dc.w	%0000100000000000
	.dc.w	%0001100000000000
	.dc.w	%0011100000000000
	.dc.w	%0111100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0111111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$32 Q
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%0000001100000000
	.dc.w	%0000011000000000
	.dc.w	%0000110000000000
	.dc.w	%0001100000000000
	.dc.w	%0011000000000000
	.dc.w	%0110000000000000
	.dc.w	%1100000000000000
	.dc.w	%1111111100000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$33 R
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%0000001100000000
	.dc.w	%0000011000000000
	.dc.w	%0001110000000000
	.dc.w	%0000011000000000
	.dc.w	%0000001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$34 S
	.dc.w	%0000000000000000
	.dc.w	%0000001000000000
	.dc.w	%0000011000000000
	.dc.w	%0000111000000000
	.dc.w	%0001111000000000
	.dc.w	%0011011000000000
	.dc.w	%0110011000000000
	.dc.w	%1100011000000000
	.dc.w	%1111111100000000
	.dc.w	%0000011000000000
	.dc.w	%0000011000000000
	.dc.w	%0000011000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$35 T
	.dc.w	%0000000000000000
	.dc.w	%0111111000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0111110000000000
	.dc.w	%0000011000000000
	.dc.w	%0000001100000000
	.dc.w	%0000001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$36 U
	.dc.w	%0000000000000000
	.dc.w	%0000110000000000
	.dc.w	%0001100000000000
	.dc.w	%0011000000000000
	.dc.w	%0110000000000000
	.dc.w	%0111110000000000
	.dc.w	%1110011000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$37 V
	.dc.w	%0000000000000000
	.dc.w	%1111111100000000
	.dc.w	%1100001100000000
	.dc.w	%1100011000000000
	.dc.w	%0000011000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$38 W
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$39 X
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011100000000
	.dc.w	%0011111000000000
	.dc.w	%0000011000000000
	.dc.w	%0000110000000000
	.dc.w	%0001100000000000
	.dc.w	%0011000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$3A F
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$3B G
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$3C 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000100000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$3D 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$3E 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000100000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%1000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$3F H
	.dc.w	%0000000000000000
	.dc.w	%1111000000000000
	.dc.w	%0011100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$40 
	.dc.w	%0000000000000000
	.dc.w	%0001111100000000
	.dc.w	%0010000010000000
	.dc.w	%0100000001000000
	.dc.w	%1000111001000000
	.dc.w	%1001001001000000
	.dc.w	%1001001001000000
	.dc.w	%1001001001000000
	.dc.w	%1001110110000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0011111110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$41 `
	.dc.w	%0000000000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0001011000000000
	.dc.w	%0001011000000000
	.dc.w	%0001011000000000
	.dc.w	%0010001100000000
	.dc.w	%0010001100000000
	.dc.w	%0011111100000000
	.dc.w	%0100000110000000
	.dc.w	%0100000110000000
	.dc.w	%1110001111000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$42 a
	.dc.w	%0000000000000000
	.dc.w	%1111110000000000
	.dc.w	%0110011100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110011000000000
	.dc.w	%0111111000000000
	.dc.w	%0110001100000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110001100000000
	.dc.w	%1111110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$43 b
	.dc.w	%0000000000000000
	.dc.w	%0001111010000000
	.dc.w	%0110000110000000
	.dc.w	%1100000010000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000010000000
	.dc.w	%0110000100000000
	.dc.w	%0001111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$44 c
	.dc.w	%0000000000000000
	.dc.w	%1111110000000000
	.dc.w	%0110001100000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110001100000000
	.dc.w	%1111110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$45 d
	.dc.w	%0000000000000000
	.dc.w	%1111111110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000010000000
	.dc.w	%0110000000000000
	.dc.w	%0110001000000000
	.dc.w	%0111111000000000
	.dc.w	%0110001000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000010000000
	.dc.w	%0110000110000000
	.dc.w	%1111111110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$46 e
	.dc.w	%0000000000000000
	.dc.w	%1111111110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000010000000
	.dc.w	%0110000000000000
	.dc.w	%0110001000000000
	.dc.w	%0111111000000000
	.dc.w	%0110001000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$47 f
	.dc.w	%0000000000000000
	.dc.w	%0001111010000000
	.dc.w	%0110000110000000
	.dc.w	%1100000010000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100001111000000
	.dc.w	%1100000010000000
	.dc.w	%1100000010000000
	.dc.w	%0110000100000000
	.dc.w	%0001111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$48 g
	.dc.w	%0000000000000000
	.dc.w	%1111001111000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0111111110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%1111001111000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	7	;$49 h
	.dc.w	%0000000000000000
	.dc.w	%1111110000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%0011000000000000
	.dc.w	%1111110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$4A i
	.dc.w	%0000000000000000
	.dc.w	%0001111000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%1100110000000000
	.dc.w	%0011000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$4B j
	.dc.w	%0000000000000000
	.dc.w	%1111001110000000
	.dc.w	%0110000100000000
	.dc.w	%0110001000000000
	.dc.w	%0110010000000000
	.dc.w	%0110100000000000
	.dc.w	%0111110000000000
	.dc.w	%0110011000000000
	.dc.w	%0110011000000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%1111011110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$4C k
	.dc.w	%0000000000000000
	.dc.w	%1111000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000010000000
	.dc.w	%0110000110000000
	.dc.w	%1111111110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	13	;$4D l
	.dc.w	%0000000000000000
	.dc.w	%1110000001110000
	.dc.w	%0110000001100000
	.dc.w	%0111000001100000
	.dc.w	%0111000011100000
	.dc.w	%0111100011100000
	.dc.w	%0101100101100000
	.dc.w	%0101110101100000
	.dc.w	%0100111001100000
	.dc.w	%0100111001100000
	.dc.w	%0100010001100000
	.dc.w	%1110010011110000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	12	;$4E m
	.dc.w	%0000000000000000
	.dc.w	%1100000011100000
	.dc.w	%0110000001000000
	.dc.w	%0111000001000000
	.dc.w	%0111100001000000
	.dc.w	%0101110001000000
	.dc.w	%0100111001000000
	.dc.w	%0100011101000000
	.dc.w	%0100001111000000
	.dc.w	%0100000111000000
	.dc.w	%0100000011000000
	.dc.w	%1110000001000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$4F n
	.dc.w	%0000000000000000
	.dc.w	%0001111000000000
	.dc.w	%0110000110000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%0110000110000000
	.dc.w	%0001111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$50 o
	.dc.w	%0000000000000000
	.dc.w	%1111111000000000
	.dc.w	%0110000110000000
	.dc.w	%0110000011000000
	.dc.w	%0110000011000000
	.dc.w	%0110000011000000
	.dc.w	%0110000110000000
	.dc.w	%0111111000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$51 p
	.dc.w	%0000000000000000
	.dc.w	%0001111000000000
	.dc.w	%0110000110000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1100000011000000
	.dc.w	%1101110011000000
	.dc.w	%1111011110000000
	.dc.w	%0110001100000000
	.dc.w	%0001111100000000
	.dc.w	%0000000110000000
	.dc.w	%0000000011000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$52 q
	.dc.w	%0000000000000000
	.dc.w	%1111111000000000
	.dc.w	%0110000110000000
	.dc.w	%0110000011000000
	.dc.w	%0110000011000000
	.dc.w	%0110000011000000
	.dc.w	%0110000110000000
	.dc.w	%0111111000000000
	.dc.w	%0110111000000000
	.dc.w	%0110011100000000
	.dc.w	%0110001110000000
	.dc.w	%1111000111000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$53 r
	.dc.w	%0000000000000000
	.dc.w	%0001110100000000
	.dc.w	%0110001100000000
	.dc.w	%1100000100000000
	.dc.w	%1110000000000000
	.dc.w	%0111000000000000
	.dc.w	%0011110000000000
	.dc.w	%0000111000000000
	.dc.w	%0000011100000000
	.dc.w	%1000001100000000
	.dc.w	%1100011000000000
	.dc.w	%1011100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$54 s
	.dc.w	%0000000000000000
	.dc.w	%1111111111000000
	.dc.w	%1100110011000000
	.dc.w	%1000110001000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0011111100000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$55 t
	.dc.w	%0000000000000000
	.dc.w	%1111000111000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0011000100000000
	.dc.w	%0000111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$56 u
	.dc.w	%0000000000000000
	.dc.w	%1111000111000000
	.dc.w	%0110000010000000
	.dc.w	%0110000010000000
	.dc.w	%0011000100000000
	.dc.w	%0011000100000000
	.dc.w	%0011000100000000
	.dc.w	%0001101000000000
	.dc.w	%0001101000000000
	.dc.w	%0001101000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	16	;$57 v
	.dc.w	%0000000000000000
	.dc.w	%1111000110001110
	.dc.w	%0110000110000100
	.dc.w	%0011000111000100
	.dc.w	%0011000111000100
	.dc.w	%0011001011001000
	.dc.w	%0001101001101000
	.dc.w	%0001101001101000
	.dc.w	%0001101001101000
	.dc.w	%0000110000110000
	.dc.w	%0000110000110000
	.dc.w	%0000110000110000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$58 w
	.dc.w	%0000000000000000
	.dc.w	%1111000111000000
	.dc.w	%0110000010000000
	.dc.w	%0011000100000000
	.dc.w	%0011001000000000
	.dc.w	%0001110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000111000000000
	.dc.w	%0001001100000000
	.dc.w	%0010001100000000
	.dc.w	%0100000110000000
	.dc.w	%1110001111000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$59 x
	.dc.w	%0000000000000000
	.dc.w	%1111000111000000
	.dc.w	%0110000010000000
	.dc.w	%0011000100000000
	.dc.w	%0011000100000000
	.dc.w	%0001101000000000
	.dc.w	%0001101000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0000110000000000
	.dc.w	%0001111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	11	;$5A y
	.dc.w	%0000000000000000
	.dc.w	%1111111111000000
	.dc.w	%1100000011000000
	.dc.w	%1000000110000000
	.dc.w	%0000001100000000
	.dc.w	%0000011000000000
	.dc.w	%0000110000000000
	.dc.w	%0001100000000000
	.dc.w	%0011000000000000
	.dc.w	%0110000001000000
	.dc.w	%1100000011000000
	.dc.w	%1111111111000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$5B m
	.dc.w	%0000000000000000
	.dc.w	%0111000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$5C 
	.dc.w	%0000000000000000
	.dc.w	%1000001000000000
	.dc.w	%1000001000000000
	.dc.w	%0100010000000000
	.dc.w	%0100010000000000
	.dc.w	%0010100000000000
	.dc.w	%0010100000000000
	.dc.w	%0111110000000000
	.dc.w	%0001000000000000
	.dc.w	%0111110000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$5D n
	.dc.w	%0000000000000000
	.dc.w	%0111000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$5E O
	.dc.w	%0000000000000000
	.dc.w	%0001000000000000
	.dc.w	%0010100000000000
	.dc.w	%0100010000000000
	.dc.w	%1000001000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$5F Q
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$60 M
	.dc.w	%0000000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$61 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0111110000000000
	.dc.w	%1100111000000000
	.dc.w	%0000011000000000
	.dc.w	%0011111000000000
	.dc.w	%0110011000000000
	.dc.w	%1100011000000000
	.dc.w	%1100111000000000
	.dc.w	%0111011100000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$62 
	.dc.w	%0000000000000000
	.dc.w	%1110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110111000000000
	.dc.w	%0111001100000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0110000110000000
	.dc.w	%0111001100000000
	.dc.w	%1101111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$63 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$64 
	.dc.w	%0000000000000000
	.dc.w	%0000011100000000
	.dc.w	%0000001100000000
	.dc.w	%0000001100000000
	.dc.w	%0011101100000000
	.dc.w	%0110011100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011100000000
	.dc.w	%0011101110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$65 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001000000000
	.dc.w	%1111111000000000
	.dc.w	%1100000000000000
	.dc.w	%1100000000000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	7	;$66 
	.dc.w	%0000000000000000
	.dc.w	%0011100000000000
	.dc.w	%0110110000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111100000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$67 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0111110100000000
	.dc.w	%1100011000000000
	.dc.w	%1100011000000000
	.dc.w	%1100011000000000
	.dc.w	%0111110000000000
	.dc.w	%1100000000000000
	.dc.w	%0111111000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0111111000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$68 
	.dc.w	%0000000000000000
	.dc.w	%1110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110111000000000
	.dc.w	%0111011100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%1111011110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$69 
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0000000000000000
	.dc.w	%1110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$6A 
	.dc.w	%0000000000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0000000000000000
	.dc.w	%0011100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%0001100000000000
	.dc.w	%1101100000000000
	.dc.w	%0111000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$6B 
	.dc.w	%0000000000000000
	.dc.w	%1110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110111000000000
	.dc.w	%0110010000000000
	.dc.w	%0110100000000000
	.dc.w	%0111000000000000
	.dc.w	%0111100000000000
	.dc.w	%0110110000000000
	.dc.w	%0110011000000000
	.dc.w	%1111011100000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	5	;$6C 
	.dc.w	%0000000000000000
	.dc.w	%1110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	15	;$6D 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1101111011110000
	.dc.w	%0111011110111000
	.dc.w	%0110001100011000
	.dc.w	%0110001100011000
	.dc.w	%0110001100011000
	.dc.w	%0110001100011000
	.dc.w	%0110001100011000
	.dc.w	%1111011110111100
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$6E 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1110111000000000
	.dc.w	%0111011100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%1111011110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$6F 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0011110000000000
	.dc.w	%0110011000000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%1100001100000000
	.dc.w	%0110011000000000
	.dc.w	%0011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$70 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1110111000000000
	.dc.w	%0111011100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0111011100000000
	.dc.w	%0110111000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$71 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0111011100000000
	.dc.w	%1110111000000000
	.dc.w	%1100011000000000
	.dc.w	%1100011000000000
	.dc.w	%1100011000000000
	.dc.w	%1100011000000000
	.dc.w	%1110111000000000
	.dc.w	%0111011000000000
	.dc.w	%0000011000000000
	.dc.w	%0000011000000000
	.dc.w	%0000111100000000
	.dc.w	%0000000000000000
	.dc.w	9	;$72 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1110111000000000
	.dc.w	%0111001100000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$73 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0111101000000000
	.dc.w	%1100011000000000
	.dc.w	%1100001000000000
	.dc.w	%0111100000000000
	.dc.w	%0011110000000000
	.dc.w	%1000011000000000
	.dc.w	%1100011000000000
	.dc.w	%1011110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	7	;$74 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%1111100000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110000000000000
	.dc.w	%0110110000000000
	.dc.w	%0011100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$75 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1110011100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110001100000000
	.dc.w	%0110011100000000
	.dc.w	%0011110110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	9	;$76 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111011100000000
	.dc.w	%0110001000000000
	.dc.w	%0110010000000000
	.dc.w	%0011010000000000
	.dc.w	%0011100000000000
	.dc.w	%0011100000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	14	;$77 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111001000111000
	.dc.w	%0110001100010000
	.dc.w	%0110001100010000
	.dc.w	%0011010110100000
	.dc.w	%0011010110100000
	.dc.w	%0001110011100000
	.dc.w	%0001100011000000
	.dc.w	%0000100001000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$78 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111011100000000
	.dc.w	%0110001000000000
	.dc.w	%0011010000000000
	.dc.w	%0001100000000000
	.dc.w	%0001110000000000
	.dc.w	%0010011000000000
	.dc.w	%0100001100000000
	.dc.w	%1110011110000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	10	;$79 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111001110000000
	.dc.w	%0110000100000000
	.dc.w	%0110000100000000
	.dc.w	%0011001000000000
	.dc.w	%0011001000000000
	.dc.w	%0001110000000000
	.dc.w	%0001110000000000
	.dc.w	%0000100000000000
	.dc.w	%0000100000000000
	.dc.w	%0001000000000000
	.dc.w	%0110000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$7A 
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%1111111000000000
	.dc.w	%1000011000000000
	.dc.w	%0000110000000000
	.dc.w	%0001100000000000
	.dc.w	%0011000000000000
	.dc.w	%0110000000000000
	.dc.w	%1100001000000000
	.dc.w	%1111111000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$7B o
	.dc.w	%0000000000000000
	.dc.w	%0001100000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0100000000000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$7C b
	.dc.w	%0000000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$7D p
	.dc.w	%0000000000000000
	.dc.w	%1100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000100000000000
	.dc.w	%0001000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%1100000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$7E P
	.dc.w	%0000000000000000
	.dc.w	%1111100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$7F DL
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$80 _
	.dc.w	%0000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%1000000000000000
	.dc.w	%0100000000000000
	.dc.w	%0100000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0001000000000000
	.dc.w	%0001000000000000
	.dc.w	%0000100000000000
	.dc.w	%0000100000000000
	.dc.w	%0000100000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	8	;$81 `
	.dc.w	%0000000000000000
	.dc.w	%0110000000000000
	.dc.w	%1001001000000000
	.dc.w	%0000110000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	6	;$82 U
	.dc.w	%0000000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0010000000000000
	.dc.w	%0000000000000000
	.dc.w	%0000000000000000



;----------------------------------------------------------------
;foCXhCo̖
device_tail:

;----------------------------------------------------------------
;foCXR}h0 
initialize:

;p[^mF
	movea.l	18(a5),a0		;p[^B؂0A0,0B擪̓foCXt@C
	do
	while	<tst.b (a0)+>,ne	;foCXt@Cǂݔ΂
	dostart
		gotoand	<cmp.b #'-',d0>,ne,<cmp.b #'/',d0>,ne,parameter_error	;-,/ȊO
		move.b	(a0)+,d0
		goto	eq,parameter_error	;-,/̌ɕȂ
		st.b	option_flag		;IvV
		bsr	tolower
		if	<cmp.b #'f',d0>,eq	;-f
			st.b	fixed_flag
			sf.b	proportional_flag
		elif	<cmp.b #'p',d0>,eq	;-p
			sf.b	fixed_flag
			st.b	proportional_flag
		elif	<cmp.b #'q',d0>,eq	;-q
			st.b	quiet_flag
			sf.b	verbose_flag
		elif	<cmp.b #'s',d0>,eq	;-s
			st.b	sample_flag
		elif	<cmp.b #'v',d0>,eq	;-v
			sf.b	quiet_flag
			st.b	verbose_flag
		else
			goto	parameter_error
		endif
		tst.b	(a0)+			;؂
		goto	ne,parameter_error	;]ȕ
	start
		move.b	(a0)+,d0
	while	ne

;[NGA
	bsr	initialize_workarea	;[NGA

;xN^ύX
	IOCS	_OS_CUROF
	lea.l	vector_table(pc),a0	;xN^e[u
	bsr	set_vector		;xN^ύX
	IOCS	_OS_CURON

;Œsb`܂̓v|[Visb`ݒ肷
	if	<tst.b fixed_flag>,ne	;Œsb`
		bclr.b	#BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w
	elif	<tst.b proportional_flag>,ne	;v|[Visb`
		bset.b	#BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w
	endif

;sƃ^Cg\
	if	<tst.b quiet_flag>,eq
		lea.l	crlf_title(pc),a0
		bsr	print
	endif

;Tv\
	if	<tst.b sample_flag>,ne
		lea.l	sample(pc),a0
		bsr	print
	endif

;foCXhCo̖ݒ肷
	move.l	#device_tail,14(a5)	;foCXhCo̖

;foCXhCogݍ
	moveq.l	#0,d0
	rts

;p[^G[
parameter_error:

;sƃ^CgƃG[bZ[W\
	lea.l	crlf_title(pc),a0
	bsr	print
	lea.l	parameter_message(pc),a0
	bsr	print

;foCXhCogݍ܂Ȃ
	move.w	#ABORT|MISCELLANEOUS_ERROR,d0	;~(A) G[܂
	rts

;----------------------------------------------------------------
;sJn
execution_start:

;IvVmF
	lea.l	1(a2),a0		;R}hC
	dostart
		gotoand	<cmp.b #'-',d0>,ne,<cmp.b #'/',d0>,ne,usage_exit	;-,/ȊO
		addq.l	#1,a0
		move.b	(a0)+,d0
		goto	eq,usage_exit		;-,/̌ɕȂ
		st.b	option_flag		;IvV
		bsr	tolower
		if	<cmp.b #'f',d0>,eq	;-f
			st.b	fixed_flag
			sf.b	proportional_flag
		elif	<cmp.b #'k',d0>,eq	;-k
			st.b	keeppr_flag
			sf.b	release_flag
		elif	<cmp.b #'p',d0>,eq	;-p
			sf.b	fixed_flag
			st.b	proportional_flag
		elif	<cmp.b #'q',d0>,eq	;-q
			st.b	quiet_flag
			sf.b	verbose_flag
		elif	<cmp.b #'r',d0>,eq	;-r
			sf.b	keeppr_flag
			st.b	release_flag
		elif	<cmp.b #'s',d0>,eq	;-s
			st.b	sample_flag
		elif	<cmp.b #'v',d0>,eq	;-v
			sf.b	quiet_flag
			st.b	verbose_flag
		else
			goto	usage_exit
		endif
		move.b	(a0),d0
		break	eq
		bsr	isspace
		goto	ne,usage_exit		;]ȕ
	start
		bsr	nonspace
	while	ne
	goto	<tst.b option_flag>,eq,usage_exit	;IvVȂ

;X[p[oCU[hֈڍs
	supervisormode

;----------------------------------------------------------------
;foCXhCoT
	movea.l	DOS_HUMAN_MEMORY.w,a2	;Human68k̐擪
	do
		addq.l	#2,a2
	whileor	<cmpi.l #'NUL ',DH_NAME(a2)>,ne,<cmpi.l #'    ',DH_NAME+4(a2)>,ne,<cmpi.w #$8024,DH_TYPE(a2)>,ne	;NULfoCXhCoTBK
;<a2.l:NULfoCXhCo̐擪
	dostart
		lea.l	magic-program_head(a2),a0	;풓̃}WbN
		lea.l	magic(pc),a1		;̃}WbN
		gotoand	<cmpm.l (a0)+,(a1)+>,eq,<cmpm.l (a0)+,(a1)+>,eq,device_found	;vI
	start
		movea.l	a2,a3			;foCXhCoÕfoCXhCo
		movea.l	DH_NEXT(a2),a2		;̃foCXhCo
	while	<cmpa.l #-1,a2>,ne
	suba.l	a2,a2
device_found:
;<a2.l:foCXhCo̐擪,0=foCXhCoȂ
;<a3.l:(foCXhCoƂ)ÕfoCXhCo,(foCXhCoȂƂ)Ō̃foCXhCo

;----------------------------------------------------------------
;풓vOT
	lea.l	program_head(pc),a4	;̐擪
	dostart
		movea.l	d0,a4
		lea.l	MM_PROGRAM(a4),a4	;풓̐擪
		lea.l	magic+8-program_head(a4),a0	;풓̃}WbN̖
		if	<cmpa.l MM_TAIL-MM_PROGRAM(a4),a0>,ls	;ubN̒mF
			lea.l	magic-program_head(a4),a0	;풓̃}WbN
			lea.l	magic(pc),a1		;̃}WbN
			gotoand	<cmpm.l (a0)+,(a1)+>,eq,<cmpm.l (a0)+,(a1)+>,eq,keeppr_found	;vI
		endif
	start
		move.l	MM_PREV-MM_PROGRAM(a4),d0	;ÕǗe[u
	while	ne
	lea.l	program_head(pc),a4	;̐擪
	dostart
		movea.l	d0,a4
		lea.l	MM_PROGRAM(a4),a4	;풓̐擪
		lea.l	magic+8-program_head(a4),a0	;풓̃}WbN̖
		if	<cmpa.l MM_TAIL-MM_PROGRAM(a4),a0>,ls	;ubN̒mF
			lea.l	magic-program_head(a4),a0	;풓̃}WbN
			lea.l	magic(pc),a1		;̃}WbN
			gotoand	<cmpm.l (a0)+,(a1)+>,eq,<cmpm.l (a0)+,(a1)+>,eq,keeppr_found	;vI
		endif
	start
		move.l MM_NEXT-MM_PROGRAM(a4),d0	;̃Ǘe[u
	while	ne
	suba.l	a4,a4
keeppr_found:
;<a4.l:풓vO̐擪,0=풓vOȂ

;----------------------------------------------------------------
	move.l	a2,d0			;foCXhCo̐擪
	if 	eq			;foCXhCoȂ

	;----------------------------------------------------------------
	;풓ĂȂ

		if	<tst.b keeppr_flag>,eq	;풓Ȃ

		;[U[h֕A
			usermode

		;^CgƃbZ[W\
			if	<tst.b quiet_flag>,eq
				lea.l	title(pc),a0
				bsr	print
			endif
			lea.l	not_installed_message(pc),a0
			bsr	eprint

		;G[I
			move.w	#1,-(sp)
			DOS	_EXIT2

		endif

	;----------------------------------------------------------------
	;풓

	;[NGA
		bsr	initialize_workarea	;[NGA

	;Œsb`܂̓v|[Visb`ݒ肷
		if	<tst.b fixed_flag>,ne	;Œsb`
			bclr.b	#BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w
		elif	<tst.b proportional_flag>,ne	;v|[Visb`
			bset.b	#BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w
		endif

	;xN^ύX
		IOCS	_OS_CUROF
		lea.l	vector_table(pc),a0	;xN^e[u
		bsr	set_vector		;xN^ύX
		IOCS	_OS_CURON

	;foCXhCoڑ
		move.l	#program_head,(a3)	;Ō̃foCXhCo̎̃foCXhCoɂ
		bsr	reset_con_device	;Wo͂Ɍ݂CONfoCXڑ

	;[U[h֕A
		usermode

	;^CgƃbZ[W\
		if	<tst.b quiet_flag>,eq
			lea.l	title(pc),a0
			bsr	print
			lea.l	install_message(pc),a0
			bsr	print
		endif

	;Tv\
		if	<tst.b sample_flag>,ne
			lea.l	sample(pc),a0
			bsr	print
		endif

	;풓I
		clr.w	-(sp)
		move.l	#device_tail-program_head,-(sp)
		DOS	_KEEPPR

	else				;foCXhCo

	;----------------------------------------------------------------
	;풓Ă

		if	<tst.b keeppr_flag>,ne	;풓

		;[U[h֕A
			usermode

		;^CgƃbZ[W\
			if	<tst.b quiet_flag>,eq
				lea.l	title(pc),a0
				bsr	print
			endif
			lea.l	already_message(pc),a0
			bsr	eprint

		;G[I
			move.w	#1,-(sp)
			DOS	_EXIT2

		endif

	;----------------------------------------------------------------
	;풓Ȃ

	;Œsb`܂̓v|[Visb`ݒ肷
		if	<tst.b fixed_flag>,ne	;Œsb`
			bclr.b	#BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w
		elif	<tst.b proportional_flag>,ne	;v|[Visb`
			bset.b	#BIOS_PROPORTIONAL_BIT,BIOS_ATTRIBUTE_2.w
		endif

	;Tv\
		if	<tst.b sample_flag>,ne
			lea.l	sample(pc),a0
			bsr	print
		endif

		if	<tst.b release_flag>,eq	;Ȃ

		;[U[h֕A
			usermode

		;I
			DOS	_EXIT

		endif

	;----------------------------------------------------------------
	;

	;xN^mF
		lea.l	(vector_table-program_head)(a2),a0	;풓̃xN^e[u
		bsr	check_vector		;xN^mF

		if	ne			;xN^ύXĂ

		;[U[h֕A
			usermode

		;^CgƃbZ[W\
			if	<tst.b quiet_flag>,eq
				lea.l	title(pc),a0
				bsr	print
			endif
			lea.l	vector_message(pc),a0
			bsr	eprint

		;G[I
			move.w	#1,-(sp)
			DOS	_EXIT2

		endif

	;xN^ύXĂȂ

	;foCXhCo؂藣
		move.l	(a2),(a3)		;ÕfoCXhCoɎ̃foCXhCoq
		bsr	reset_con_device	;Wo͂Ɍ݂CONfoCXڑ

	;xN^𕜌
		IOCS	_OS_CUROF
		lea.l	(vector_table-program_head)(a2),a0	;풓̃xN^e[u
		bsr	release_vector		;xN^𕜌
		IOCS	_OS_CURON

	;풓vOJ
		move.l a4,d0			;풓vO̐擪
		if	ne			;풓vO

			;풓vOJ
			pea.l	MM_SIZE-MM_PROGRAM(a4)	;풓vÕubN̐擪
			DOS	_MFREE
			addq.l	#4,sp

		endif

	;[U[h֕A
		usermode

	;^CgƃbZ[W\
		if	<tst.b quiet_flag>,eq
			lea.l	title(pc),a0
			bsr	print
			lea.l	release_message(pc),a0
			bsr	print
		endif

	;I
		DOS	_EXIT

	endif

;----------------------------------------------------------------
;gp@\
usage_exit:
	if	<tst.b quiet_flag>,eq
		lea.l	title_usage(pc),a0
		bsr	more
	endif

;I
	DOS	_EXIT

;----------------------------------------------------------------
;xN^ύX
;<a0.l:xN^e[u
set_vector:
	push	d0/a0-a1
	dostart
		movea.w	d0,a1			;ItZbg
		move.l	(a1),d0
		move.l	(a0)+,(a1)		;VxN^
		move.l	d0,(a0)+		;ÂxN^
	start
		move.w	(a0)+,d0
	while	ne
	pop
	rts

;----------------------------------------------------------------
;xN^mF
;<a0.l:풓̃xN^e[u
;>ccr:eq=xN^͕ύXĂȂ,ne=xN^ύXĂ
check_vector:
	push	d0/a0-a1
	dostart
		movea.w	d0,a1			;ItZbg
		move.l	(a1),d0
		break	<cmp.l (a0)+,d0>,ne	;VxN^݂̃xN^ƈvȂΎs
		addq.l	#4,a0			;ÂxN^ǂݔ΂
	start
		move.w	(a0)+,d0
	while	ne
	pop
	rts

;----------------------------------------------------------------
;xN^𕜌
;<a0.l:풓̃xN^e[u
release_vector:
	push	d0/a0-a1
	dostart
		movea.w	d0,a1			;ItZbg
		addq.l	#4,a0			;VxN^ǂݔ΂
		move.l	(a0)+,(a1)		;ÂxN^
	start
		move.w	(a0)+,d0
	while	ne
	pop
	rts

;----------------------------------------------------------------
;Wo͂Ɍ݂CONfoCXڑ
reset_con_device:
	push	d0
	clr.w	-(sp)
	DOS	_CLOSE
	addq.w	#1,(sp)
	DOS	_CLOSE
	addq.w	#1,(sp)
	DOS	_CLOSE
	addq.l	#2,sp
	pop
	rts

;----------------------------------------------------------------
;[NGA
initialize_workarea:
	push	d0-d1/a0
	moveq.l	#0,d0
	lea.l	$0D30.w,a0
	move.w	#($0DC0-$0D30)/4-1,d1
	for	d1
		move.l	d0,(a0)+
	next
	pop
	rts

;----------------------------------------------------------------
;bZ[W
parameter_message:	.dc.b	'włȂp[^ł',13,10,0
not_installed_message:	.dc.b	'풓Ă܂',13,10,0
install_message:	.dc.b	'풓܂',13,10,0
already_message:	.dc.b	'ɏ풓Ă܂',13,10,0
vector_message:		.dc.b	'xN^ύXĂ܂Bł܂',13,10,0
release_message:	.dc.b	'܂',13,10,0

;sƃ^Cg
crlf_title:		.dc.b	13,10
;^Cg
title:			.dc.b	TITLE_STRING,' version ',VERSION_STRING,13,10,0

;^CgƎgp@
title_usage:		.dc.b	TITLE_STRING,' version ',VERSION_STRING,13,10
			.dc.b	13,10
			.dc.b	'IvV',13,10
			.dc.b	'  -f        Œsb`ɐ؂ւ',13,10
			.dc.b	'  -k        풓',13,10
			.dc.b	'  -p        v|[Visb`ɐ؂ւ',13,10
			.dc.b	'  -q        \炷',13,10
			.dc.b	'  -r        ',13,10
			.dc.b	'  -s        Tv\',13,10
			.dc.b	'  -v        \𑝂₷',13,10
			.dc.b	13,10
			.dc.b	'䕶',13,10
			.dc.b	'  ^G        $07 BL x炷',13,10
			.dc.b	'  ^H        $08 BS J[\1ցB[ł1s̉E[ցB[ł͉Ȃ',13,10
			.dc.b	'  ^I        $09 HT J[\̃^uցBȂ1s̍[ցB[ł̓XN[Abvč[',13,10
			.dc.b	'  ^J        $0A LF J[\1sցB[ł̓XN[Abv',13,10
			.dc.b	'  ^K        $0B VT J[\1sցB[ł͉Ȃ',13,10
			.dc.b	'  ^L        $0C FF J[\1EցBE[ł1s̍[ցB[ł̓XN[Abvč[',13,10
			.dc.b	'  ^M        $0D CR J[\[',13,10
			.dc.b	'  ^Z        $1A SB ォE܂ŏBJ[\',13,10
			.dc.b	'  ^[        $1B EC GXP[vV[PXJn',13,10
			.dc.b	'  ^^        $1E RS J[\',13,10
			.dc.b	13,10
			.dc.b	'GXP[vV[PX',13,10
			.dc.b	'  ^[*       ォE܂ŏBJ[\',13,10
			.dc.b	'  ^[=rc     J[\r-$20s,c-$20ցBrc͕',13,10
			.dc.b	'  ^[D       J[\1sցB[ł̓XN[Abv',13,10
			.dc.b	'  ^[E       J[\1s̍[ցB[ł̓XN[Abv',13,10
			.dc.b	'  ^[M       J[\1sցB[ł̓XN[_E',13,10
			.dc.b	'  ^[[>5l    J[\ON',13,10
			.dc.b	'  ^[[>5h    J[\OFF',13,10
			.dc.b	'  ^[[?4l    WvXN[',13,10
			.dc.b	'  ^[[?4h    8hbgX[XXN[',13,10
			.dc.b	'  ^[[n@     J[\En}',13,10
			.dc.b	'  ^[[nA     J[\nsցB[𒴂Ƃ͓Ȃ',13,10
			.dc.b	'  ^[[nB     J[\nsցB[Ŏ~܂',13,10
			.dc.b	'  ^[[nC     J[\nEցBE[Ŏ~܂',13,10
			.dc.b	'  ^[[nD     J[\nցB[Ŏ~܂',13,10
			.dc.b	'  ^[[r;cH   J[\r-1s,c-1ցB[Ŏ~܂BE[Ŏ~܂',13,10
			.dc.b	'  ^[[r;cf   J[\r-1s,c-1ցB[Ŏ~܂BE[Ŏ~܂',13,10
			.dc.b	'  ^[[0J     J[\E܂ŏ',13,10
			.dc.b	'  ^[[1J     ォJ[\܂ŏ',13,10
			.dc.b	'  ^[[2J     ォE܂ŏBJ[\',13,10
			.dc.b	'  ^[[0K     J[\E[܂ŏ',13,10
			.dc.b	'  ^[[1K     [J[\܂ŏ',13,10
			.dc.b	'  ^[[2K     [E[܂ŏ',13,10
			.dc.b	'  ^[[nL     J[\牺ns}BJ[\[',13,10
			.dc.b	'  ^[[nM     J[\牺ns폜BJ[\[',13,10
			.dc.b	'  ^[[nP     J[\En폜',13,10
			.dc.b	'  ^[[nX     J[\En',13,10
			.dc.b	'  ^[[nc     ',13,10
			.dc.b	'  ^[[nl     ',13,10
			.dc.b	'  ^[[0m     Zbg',13,10
			.dc.b	'  ^[[1m     ',13,10
			.dc.b	'  ^[[2m     ׎',13,10
			.dc.b	'  ^[[3m     Α',13,10
			.dc.b	'  ^[[4m     ',13,10
			.dc.b	'  ^[[7m     ]',13,10
			.dc.b	'  ^[[9m     ',13,10
			.dc.b	'  ^[[21m    g',13,10
			.dc.b	'  ^[[22m    A׎',13,10
			.dc.b	'  ^[[23m    Α̉',13,10
			.dc.b	'  ^[[24m    Ag',13,10
			.dc.b	'  ^[[26m    v|[Vi',13,10
			.dc.b	'  ^[[27m    ]',13,10
			.dc.b	'  ^[[29m    ',13,10
			.dc.b	'  ^[[30m    ',13,10
			.dc.b	'  ^[[31m    F',13,10
			.dc.b	'  ^[[32m    F',13,10
			.dc.b	'  ^[[33m    ',13,10
			.dc.b	'  ^[[34m    A',13,10
			.dc.b	'  ^[[35m    AF',13,10
			.dc.b	'  ^[[36m    AF',13,10
			.dc.b	'  ^[[37m    A',13,10
			.dc.b	'  ^[[40m    ]A',13,10
			.dc.b	'  ^[[41m    ]AF',13,10
			.dc.b	'  ^[[42m    ]AF',13,10
			.dc.b	'  ^[[43m    ]A',13,10
			.dc.b	'  ^[[44m    ]AA',13,10
			.dc.b	'  ^[[45m    ]AAF',13,10
			.dc.b	'  ^[[46m    ]AAF',13,10
			.dc.b	'  ^[[47m    ]AA',13,10
			.dc.b	'  ^[[50m    v|[Vi',13,10
			.dc.b	'  ^[[51m    lp͂',13,10
			.dc.b	'  ^[[52m    ۈ͂',13,10
			.dc.b	'  ^[[53m    ',13,10
			.dc.b	'  ^[[54m    lp͂݁Aۈ͂݉',13,10
			.dc.b	'  ^[[55m    ',13,10
			.dc.b	'  ^[[73m    t',13,10
			.dc.b	'  ^[[74m    t',13,10
			.dc.b	'  ^[[75m    tAt',13,10
			.dc.b	'  ^[[6n     J[\ʒu񍐁B^[[r;cR',13,10
			.dc.b	'  ^[[nr     E',13,10
			.dc.b	'  ^[[s      J[\̍Wƕۑ',13,10
			.dc.b	'  ^[[u      J[\̍Wƕ𕜌',13,10
			.dc.b	0

;Tv
sample:			.dc.b	27,'[s',27,'[m',13,10
			.dc.b	'Tv',13,10
			.dc.b	'  ',27,'[1m',27,'[m'
			.dc.b	'  ',27,'[7m]',27,'[m'
			.dc.b	'  ',27,'[31mF',27,'[m'
			.dc.b	'  ',27,'[32mF',27,'[m',13,10
			.dc.b	'  ',27,'[2m׎',27,'[m'
			.dc.b	'  ',27,'[3mΑ',27,'[m'
			.dc.b	'  ',27,'[4m',27,'[m'
			.dc.b	'  ',27,'[53m',27,'[m'
			.dc.b	'  ',27,'[9m',27,'[m'
			.dc.b	'  ',27,'[21mg',27,'[m',13,10
			.dc.b	'  ',27,'[51mlp͂',27,'[m'
			.dc.b	'  ',27,'[52mۈ͂',27,'[m'
			.dc.b	'  ',27,'[73mt',27,'[m'
			.dc.b	'  ',27,'[74mt',27,'[m',13,10
			.dc.b	'  ',27,'[7m',27,'[150l',27,'[m',13,10
			.dc.b	'  ',27,'[7m',27,'[150c',27,'[m',13,10
			.dc.b	'  ',27,'[7m',27,'[150rE',27,'[m',13,10
			.dc.b	'  ',27,'[26mProportional-Pitch',27,'[m',13,10
			.dc.b	13,10
			.dc.b	'  ',27,'[26m    Alice was beginning to get very tired of sitting by her sister on the bank, and',13,10
			.dc.b	'  of having nothing to do: once or twice she had peeped into the book her sister was',13,10
			.dc.b	'  reading, but it had no pictures or conversations in it, `and what is the use of a book,',39,13,10
			.dc.b	'  thought Alice `without pictures or conversation?',39,13,10
			.dc.b	'  ',27,'[640r-- from Alice in Wonderland by Lewis Carroll --',27,'[m',13,10
			.dc.b	13,10,27,'[u'
			.dc.b	0

	.data

;----------------------------------------------------------------
;tO
option_flag:		.dc.b	0	;-1=IvVw肳ꂽ
fixed_flag:		.dc.b	0	;-fB-1=Œsb`
keeppr_flag:		.dc.b	0	;-kB-1=풓
proportional_flag:	.dc.b	0	;-pB-1=v|[Visb`
quiet_flag:		.dc.b	0	;-qB-1=\炷
release_flag:		.dc.b	0	;-rB-1=
sample_flag:		.dc.b	0	;-sB-1=Tv
verbose_flag:		.dc.b	0	;-vB-1=\𑝂₷



	.text
	.even

;----------------------------------------------------------------
;G[\
;<a0.l:
eprint:
	move.l	d0,-(sp)
	bsr	strlen
	move.l	d0,-(sp)
	move.l	a0,-(sp)
	move.w	#2,-(sp)
	DOS	_WRITE
	lea.l	10(sp),sp
	move.l	(sp)+,d0
	rts

;----------------------------------------------------------------
;sG[\
eprintcrlf:
	move.l	a0,-(sp)
	lea.l	100f(pc),a0		;13,10
	bsr	eprint
	movea.l	(sp)+,a0
	rts

100:	.dc.b	13,10,0
	.even

;----------------------------------------------------------------
;ƉsG[\
;<a0.l:
eprintln:
	bsr	eprint
	bsr	eprintcrlf
	rts

;----------------------------------------------------------------
;-more-݂Ȃ當\
;<a0.l:
more:
	push	d0-d5/a0-a2
;W͂mF
	clr.l	-(sp)			;(0<<16)|0
	DOS	_IOCTRL
	addq.l	#4,sp
;<d0.b:W͂FCBtO
	and.b	#$81,d0			;LN^foCXAW
	goto	<cmp.b #$81,d0>,ne,90f	;W͂_CNgĂBmoreȂ
;Wo͂mF
	pea.l	1.w			;(0<<16)|1
	DOS	_IOCTRL
	addq.l	#4,sp
;<d0.b:Wo͂FCBtO
	and.b	#$82,d0			;LN^foCXAWo
	goto	<cmp.b #$82,d0>,ne,90f	;Wo͂_CNgĂBmoreȂ
;CONDRV.SYSmF
	move.w	#$0100+_KEY_INIT,-(sp)
	DOS	_INTVCG
	addq.l	#2,sp
	movea.l	d0,a1
	subq.l	#4,a1
	IOCS	_B_LPEEK
	goto	<cmp.l #'hmk*',d0>,eq,90f	;CONDRV.SYSgݍ܂ĂBmoreȂ
;ʂ̑傫mF
	moveq.l	#-1,d1
	moveq.l	#-1,d2
	IOCS	_B_CONSOL
;<d2.l:E[̌W<<16|[̍sW
	move.w	d2,d3
	swap.w	d2
	addq.w	#1,d2
;<d2.w:ʂ̌
;<d3.w:[̍sWB-more-̍sʂ̍s
	gotoor	<cmp.w #8,d2>,lo,<tst.w d3>,eq,90f	;ʂBmoreȂB^u܂߂1ȏ㏑Ȃ΂ȂȂ̂8x1s
;y[W[v
	do
		move.l	#0,d4			;W
		move.l	#0,d5			;sW
		movea.l	a0,a2			;y[W擪
	;[v
		do
			movea.l	a0,a1			;擪
			move.b	(a0)+,d0		;1oCg
			if	eq			;00 I
				subq.l	#1,a0
				break
			elif	<cmp.b #$09,d0>,eq	;09 ^u
				moveq.l	#7,d1
				and.w	d4,d1
				subq.w	#8,d1
				neg.w	d1		;^ǔ
			elif	<cmp.b #$0A,d0>,eq	;0A s
				moveq.l	#0,d4		;[
				addq.w	#1,d5		;̍s
				break	<cmp.w d3,d5>,eq	;[By[WI
				continue
			elif	<cmp.b #$0C,d0>,eq	;0C y[W
				break
			elif	<cmp.b #$1F,d0>,ls	;01-08,0B,0D-1F 
				continue
			else				;20-FF
				do
					moveq.l	#1,d1			;p̌
					break	<tst.b d0>,pl		;20-7F AXL[
					breakand	<cmp.b #$A0,d0>,hs,<cmp.b #$DF,d0>,ls	;A0-DF pJ^Ji
					addq.l	#1,a0			;2oCg
					break	<cmp.b #$80,d0>,eq	;8000-80FF pЂ炪
					break	<cmp.b #$F0,d0>,hs	;F000-FFFF 1/4pApO
					moveq.l	#2,d1			;Sp̌
				while	f
			endif
			add.w	d1,d4			;\̌W
			if	<cmp.w d2,d4>,hi	;͂ݏo
				sub.w	d1,d4			;i݉߂߂
				movea.l	a1,a0
				addq.w	#1,d5			;̍s
				break	<cmp.w d3,d5>,eq	;[By[WI
				moveq.l	#0,d4			;[
			endif
		while	t
	;1y[W\
		move.l	a0,d0			;
		sub.l	a2,d0			;-擪=
		move.l	d0,-(sp)		;
		move.l	a2,-(sp)		;擪
		move.w	#1,-(sp)		;Wo
		DOS	_WRITE
		lea.l	10(sp),sp
	;ȂΏI
		break	<tst.b (a0)>,eq
	;KvȂΉs
		ifand	<tst.w d4>,ne,<cmp.w d2,d4>,ne	;[łE[łȂ
			bsr	printcrlf
		endif
	;-more-\
		pea.l	6.w
		pea.l	100f(pc)		;'-more-'
		move.w	#1,-(sp)
		DOS	_WRITE
		lea.l	10(sp),sp
	;L[͂҂
		DOS	_GETC
		move.l	d0,d1
	;s
		bsr	printcrlf
	whileand	<cmp.b #$1B,d1>,ne,<cmp.b #'Q',d1>,ne,<cmp.b #'q',d1>,ne	;ESC܂QꂽƂ͏I
99:	pop
	rts

;moreȂ
90:	bsr	print
	goto	99b

100:	.dc.b	'-more-'
	.even

;----------------------------------------------------------------
;󔒂
;<d0.b:
;>z:eq=,ne=󔒂ł͂Ȃ
isspace:
	ifor	<cmp.b #' ',d0>,eq,<cmp.b #9,d0>,eq,<cmp.b #10,d0>,eq,<cmp.b #11,d0>,eq,<cmp.b #12,d0>,eq,<cmp.b #13,d0>,eq	; \t\n\v\f\r
	endif
	rts

;----------------------------------------------------------------
;󔒈ȊO̕܂œǂݔ΂
;<a0.l:
;>d0.l:󔒈ȊO̕܂0
;>a0.l:󔒈ȊO̕܂0̈ʒu
;>z:eq=0
nonspace:
	moveq.l	#0,d0
	do
		move.b	(a0)+,d0		;̕
		redoand	<cmp.b #9,d0>,hs,<cmp.b #13,d0>,ls	;\t\n\v\f\rȂΌJԂ
	while	<cmp.b #' ',d0>,eq	;󔒂ȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	tst.l	d0
	rts

;----------------------------------------------------------------
;\
;<a0.l:
print:
	move.l	d0,-(sp)
	bsr	strlen
	move.l	d0,-(sp)
	move.l	a0,-(sp)
	move.w	#1,-(sp)
	DOS	_WRITE
	lea.l	10(sp),sp
	move.l	(sp)+,d0
	rts

;----------------------------------------------------------------
;s\
printcrlf:
	move.l	a0,-(sp)
	lea.l	100f(pc),a0		;13,10
	bsr	print
	movea.l	(sp)+,a0
	rts

100:	.dc.b	13,10,0
	.even

;----------------------------------------------------------------
;Ɖs\
;<a0.l:
println:
	bsr	print
	bsr	printcrlf
	rts

;----------------------------------------------------------------
;10i̕𕄍Ȃɕϊ
;<a0.l:10i̕B擪̋󔒂͔F߂Ȃ
;>d0.l:(cĉƂ)ȂB(cŝƂ)0=10i̕Ȃ,-1=I[o[t[
;>a0.l:(cĉƂ)10i̎̈̕ʒuB(cŝƂ)ωȂ
;>z:(cĉƂ)eq=Ȃ0
;>v:(cŝƂ)vc=10i̕Ȃ,vs=I[o[t[
;>c:cs=10i̕Ȃ܂̓I[o[t[
stou:
	push	d1-d2/a1
	moveq.l	#0,d0			;Ȃ
	moveq.l	#0,d1			;
	movea.l	a0,a1			;Jnʒu
	dostart
		goto	<cmp.l #$1999999A,d0>,hs,80f	;10{I[o[t[
		move.l	d0,d2			;1{
		lsl.l	#2,d0			;4{
		add.l	d2,d0			;5{
		add.l	d0,d0			;10{
		add.l	d1,d0			;1
		goto	cs,80f			;I[o[t[
	start
		move.b	(a0)+,d1		;̕
		sub.b	#'0',d1			;ɂ
	whileand	<>,hs,<cmp.b #10,d1>,lo	;10i̕ȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	if	<cmpa.l a1,a0>,eq	;iłȂB10i̕Ȃ
		move.w	#%00001,ccr		;vc,cs
	else
		tst.l	d0			;eq or ne,vc,cc
	endif
	goto	90f

;I[o[t[Ƃ
80:	moveq.l	#-1,d0			;I[o[t[
	movea.l	a1,a0			;ωȂ
	move.w	#%00011,ccr		;vs,cs
90:	pop
	rts

;----------------------------------------------------------------
;̒𐔂
;<a0.l:
;>d0.l:
strlen:
	move.l	a0,d0			;d0=擪
	do
		tst.b (a0)+
	while	ne			;0łȂΌJԂ
	subq.l	#1,a0			;i݉߂߂Ba0=
	exg.l	d0,a0			;d0=,a0=擪
	sub.l	a0,d0			;d0=-擪=
	rts

;----------------------------------------------------------------
;ɂ
;<d0.b:
;>d0.b:
tolower:
	ifand	<cmp.b #'A',d0>,hs,<cmp.b #'Z',d0>,ls	;啶
		add.b	#'a'-'A',d0		;ɂ
	endif
	rts



;----------------------------------------------------------------
;vO̖
	.bss
	.even
program_end:

	.end	execution_start
