;========================================================================================
;  crtmodtest.s
;  Copyright (C) 2003-2025 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

;----------------------------------------------------------------
;	crtmodtest.x (2025-06-29)
;
;	
;		crtmodtest.xCRTMOD̎ƃj^̐\mF邽߂̉ʂ\܂B
;		ESCL[Ɖʃ[hύX܂܏IÃL[ƌɖ߂ďI܂B
;
;	IvV
;		-l 0`1    0CRT̓gA1LCD̓gI܂B
;		-m 0`73   ʃ[hI܂B
;		-s         -l̑ISRAMɕۑ܂B
;
;	XV
;		2022-02-21
;			JB
;		2023-01-10
;			wvbZ[Wy[Wɋ؂ĕ\悤ɂ܂B
;		2023-11-14
;			-lw肵ƂCRTorLCD[hύX܂܏IĂ܂Aɖ߂ďI悤ɂ܂B
;			-sǉ܂B-sw肷-lŎw肳ꂽCRTorLCD[hɕύX܂܏I܂B
;		2024-08-25
;			ʃ[h40`47ɑΉ܂B
;		2024-08-26
;			IPLROM 1.0`1.3IOCS _SP_INIT̃oO𓥂܂Ȃ悤ɂ܂B
;			ESCL[ŏIƂAXvCgƃOtBbN\ɁAeLXgAeLXgpbg𕜌܂B
;			R[h𐮗܂B
;		2025-04-01
;			IPLROM 1.6/crtmod16.xȊO̊œƉʂC܂B
;		2025-04-13
;			stouC܂B
;		2025-06-29
;			ʃ[h48`73ɑΉ܂B
;			IPLROM 1.6/crtmod16.xmFđIłʃ[hmF܂B
;			XvCgʂgĂsprdrv.xgݍ܂ĂƂA
;			E768x512ŃXvCgʂ\܂B
;			E512x512BG1\܂B
;
;----------------------------------------------------------------

	.include	bioswork.equ
	.include	control2.mac
	.include	crtc.equ
	.include	doscall.mac
	.include	iocscall.mac
	.include	misc.mac
	.include	push2.mac
	.include	sprc.equ
	.include	vector.equ

TITLE_STRING	reg	'crtmodtest.x (2025-06-29)'

MODE_MAX	equ	73		;ʃ[h̍ől

TEXT_LINE	equ	3
GRAPHIC_LINE	equ	4		;4,5,6,7
SPRITE_LINE	equ	8
BG_LINE		equ	9		;9,10

	.text

base:
	lea.l	base(pc),a6
r	reg	-base(a6)

;IvVmF
	moveq.l	#-1,d6			;CRTorLCD[h͎w肳ĂȂ
	moveq.l	#-1,d7			;ʃ[h͎w肳ĂȂ
	sf.b	(save_to_sram)r		;CRTorLCD[hSRAMɕۑȂ
	lea.l	1(a2),a0
	dostart
		gotoand	<cmp.b #'-',d0>,ne,<cmp.b #'/',d0>,ne,usage_exit	;-,/ȊO
		addq.l	#1,a0
		move.b	(a0)+,d0
		goto	eq,usage_exit		;-,/̌ɕȂ
		bsr	tolower
		if	<cmp.b #'l',d0>,eq	;-l
			goto	<tst.l d6>,pl,usage_exit	;CRTorLCD[h͊Ɏw肳Ă
			bsr	nextword
			bsr	stou
			gotoor	<>,cs,<cmp.l #1,d0>,hi,usage_exit	;10iȂ͈͊O
			move.l	d0,d6			;CRTorLCD[hw肳ꂽ
		elif	<cmp.b #'m',d0>,eq	;-m
			goto	<tst.l d7>,pl,usage_exit	;ʃ[h͊Ɏw肳Ă
			bsr	nextword
			bsr	stou
			gotoor	<>,cs,<cmp.l #MODE_MAX,d0>,hi,usage_exit	;10iȂ͈͊O
			move.l	d0,d7			;ʃ[hw肳ꂽ
		elif	<cmp.b #'s',d0>,eq	;-s
			st.b	(save_to_sram)r		;CRTorLCD[hSRAMɕۑ
		else				;-l,-m,-sȊO
			goto	usage_exit
		endif
	start
		bsr	nextword
	while	ne
	goto	<tst.l d7>,mi,usage_exit	;ʃ[hw肳ĂȂ
	gotoand	<tst.l d6>,mi,<tst.b (save_to_sram)r>,ne,usage_exit	;CRTorLCD[hw肳ĂȂ̂SRAMɕۑłȂ
;<d6.l:CRTorLCD[hB0=CRT,1=LCD,-1=w肳ĂȂ
;<d7.l:ʃ[h

;_CRTMODmF
	move.w	#$56FF,d1
	IOCS	_CRTMOD
;W_CRTMODd1.w$FFFFłȂd1.b͈͊ÔƂԂȂBd0.lɂ̓[gꂽIOCSR[ԍ$00000010Ă͂
	rol.l	#8,d0
	if	<cmp.b #$16,d0>,eq	;_CRTMODIPLROM 1.6/crtmod16.x
		ror.l	#8,d0
	else				;_CRTMODIPLROM 1.6/crtmod16.xłȂo[WÂ
		moveq.l	#0,d0
	endif
	moveq.l	#0,d1
	if	<cmp.w #48,d7>,hs	;48`73
		move.l	#$16_250629,d1
	elif	<cmp.w #40,d7>,hs	;40`47
		move.l	#$16_240825,d1
	elifor	<cmp.w #28,d7>,hs,<tst.l d6>,gt	;28`39܂LCD
		move.l	#$16_231012,d1		;ÂIPLROM 1.6/crtmod16.x̓o[WԂȂ̂ŕsƂ
	endif
	if	<cmp.l d1,d0>,lo	;_CRTMODIPLROM 1.6/crtmod16.xłȂo[WÂ
		leastr	<'_CRTMODIPLROM 1.6/crtmod16.xłȂo[WÂ܂',13,10>,a0
		bsr	print
		goto	exit

	endif

;X[p[oCU[hֈڍs
	supervisormode

;gOtBbNʂmF
	ifand	<cmp.w #48,d7>,hs,<cmp.w #73,d7>,ls	;48`73
		lea.l	CRTC_MODE_BYTE,a1
		move.b	(a1),-(sp)		;[hۑ
		move.b	#7,(a1)			;[h7ɕύX
		movea.l	#$00C00000,a0
		move.w	(a0),d1			;ۑ
		not.w	(a0)			;]
		move.w	(a0),d0			;d0=]Ăǂݏo
		move.w	d1,(a0)			;
		move.b	(sp)+,(a1)		;[h𕜌
		not.w	d1			;d2=ǂݏoĂ甽]
		if	<cmp.w d1,d0>,ne	;]łĂȂ
			usermode
			leastr	<'gOtBbNʂ܂',13,10>,a0
			bsr	print
			goto	exit

		endif
	endif

;CRTorLCD[hۑ
	move.w	#$16FF,d1
	IOCS	_CRTMOD
	rol.l	#8,d0
	cmp.b	#$96,d0
	seq.b	(saved_crtlcd)r

;CRTorLCD[hύX
	if	<tst.l d6>,pl		;CRTorLCD[hw肳ĂB_CRTMODIPLROM 1.6/crtmod16.xł邱Ƃ͊mFς
		if	eq			;CRT
			move.w	#$43FF,d1
		else				;LCD
			move.w	#$4CFF,d1
		endif
		IOCS	_CRTMOD			;CRTorLCD[hύX
	endif

;ʃ[hݒ肷
	move.l	d7,d1			;ʃ[h
	IOCS	_CRTMOD
	IOCS	_G_CLR_ON

;W߂
;ʃ[h
	moveq.l	#0,d0
	move.b	BIOS_CRTMOD.w,(screen_mode)r
;CRTorLCD[h
	move.w	#$16FF,d1
	IOCS	_CRTMOD
	rol.l	#8,d0
	cmp.b	#$96,d0
	seq.b	(crtlcd_mode)r
;OtBbNy[W
	move.b	BIOS_GRAPHIC_PAGES.w,d0
	move.b	d0,(pages)r
;BGTCY
	moveq.l	#3,d0
	and.w	SPRC_RESOLUTION,d0
	sne.b	(bg_size)r
;XvCgʂ̗L
	moveq.l	#.not.%10010,d0
	or.b	CRTC_RESOLUTION_BYTE,d0	;R20LB%1xx1x̂Ƃ%11111111
	not.b	d0			;%1xx1x̂Ƃ%00000000
	if	ne			;%1xx1xł͂Ȃ
		st.b	(sprite_exists)r	;XvCgʂgpł
	else				;%1xx1x
		moveq.l	#-1,d0
		move.l	OFFSET_BUS_ERROR.w,-(sp)
		movea.l	sp,a0
		move.l	#@f,OFFSET_BUS_ERROR.w
		nop
		move.w	SPRC_SCROLL,d0		;XvCgXN[WX^[hĂ݂
		nop
	@@:	movea.l	a0,sp
		move.l	(sp)+,OFFSET_BUS_ERROR.w
		tst.w	d0			;oXG[XŴƂmiAȂpl
		spl.b	(sprite_exists)r	;pl̂ƂXvCgʂgpł
	endif
;ʂ̕
	move.w	BIOS_GRAPHIC_RIGHT.w,d0
	addq.w	#1,d0
	move.w	BIOS_CONSOLE_RIGHT.w,d1
	addq.w	#1,d1
	lsl.w	#3,d1
	if	<cmp.w d1,d0>,lo
		move.w	d1,d0
	endif
	move.w	d0,(screen_width)r
;ʂ̍
	moveq.l	#0,d0
	move.w	BIOS_GRAPHIC_BOTTOM.w,d0
	addq.l	#1,d0
	moveq.l	#0,d1
	move.w	BIOS_CONSOLE_BOTTOM.w,d1
	addq.w	#1,d1
	lsl.w	#4,d1
	if	<cmp.l d1,d0>,lo
		move.l	d1,d0
	endif
	move.w	d0,(screen_height)r
;XvCgʂ̍
	move.w	(screen_height)r,(sprite_height)r
	move.b	(screen_mode)r,d0
	if	<cmp.b #44,d0>,hs
		ifor	<cmp.b #47,d0>,ls,<cmp.b #60,d0>,eq,<cmp.b #73,d0>,eq	;44/45/46/47/60/73
			lsl.w	(sprite_height)r	;ʃ[h44`47̓XvCgʂ̍2{ɂ
		endif
	endif
;ʃTCY
	move.l	BIOS_GRAPHIC_Y_OFFSET.w,d0
	lsr.l	#1,d0
	move.w	d0,(real_size)r
;OtBbNF
	moveq.l	#0,d0
	move.w	BIOS_GRAPHIC_PALETS.w,d0
	addq.l	#1,d0
	move.l	d0,(palets)r

;[U[h֕A
	usermode

;eLXgʂ`
;pbgݒ肷
	moveq.l	#3,d1			;pbgR[h
	move.w	(text_color)r,d2	;J[R[h
	IOCS	_TPALET
;ʃ[h\
	lea.l	(string_buffer)r,a0
	movestr	'CRTMOD(',a1
	bsr	strcpy
	moveq.l	#0,d0
	move.b	(screen_mode)r,d0
	bsr	utos
	if	<tst.b (crtlcd_mode)r>,eq
		movestr	') CRT',a1
	else
		movestr	') LCD',a1
	endif
	bsr	strcpy
	moveq.l	#3,d1			;pbgR[h
	moveq.l	#2,d2			;XW
	moveq.l	#TEXT_LINE-2,d3		;YW
	lea.l	(string_buffer)r,a1	;
	move.l	a0,d4
	sub.l	a1,d4
	subq.w	#1,d4			;-1
	IOCS	_B_PUTMES
;ʃTCY\
	lea.l	(string_buffer)r,a0
	moveq.l	#0,d0
	move.w	(screen_width)r,d0
	bsr	utos
	move.b	#'x',(a0)+
	moveq.l	#0,d0
	move.w	(screen_height)r,d0
	bsr	utos
	move.b	#'/',(a0)+
	moveq.l	#0,d0
	move.w	(real_size)r,d0
	bsr	utos
	move.b	#'x',(a0)+
	moveq.l	#0,d0
	move.w	(real_size)r,d0
	bsr	utos
	move.b	#' ',(a0)+
	move.l	(palets)r,d0
	bsr	utos
	move.b	#' ',(a0)+
	moveq.l	#0,d0
	move.b	(pages)r,d0
	bsr	utos
	moveq.l	#3,d1			;pbgR[h
	moveq.l	#2,d2			;XW
	moveq.l	#TEXT_LINE-1,d3		;YW
	lea.l	(string_buffer)r,a1	;
	move.l	a0,d4
	sub.l	a1,d4
	subq.w	#1,d4			;-1
	IOCS	_B_PUTMES
;TEXTƏ
	moveq.l	#3,d1			;pbgR[h
	moveq.l	#2,d2			;XW
	moveq.l	#TEXT_LINE,d3		;YW
	moveq.l	#8-1,d4			;-1
	movestr	'sdws',a1		;
	IOCS	_B_PUTMES

;OtBbNʂ`
;pbgݒ肷
	if	<cmp.l #65536,(palets)r>,lo
		moveq.l	#0,d1			;pbgR[h0
		moveq.l	#0,d2			;J[R[h
		IOCS	_GPALET
		lea.l	(graphic_color)r,a0
		moveq.l	#1,d3
		do
			move.w	d3,d1			;pbgR[h1`4
			move.w	(a0)+,d2		;J[R[h
			IOCS	_GPALET
			addq.w	#1,d3
		while	<cmp.w #4,d3>,ls
	endif
;g`
	move.w	#$F0F0,-(sp)		;CX^C
	moveq.l	#1,d0
	if	<cmp.l #65536,(palets)r>,eq
		move.w	(graphic_color)r,d0
	endif
	move.w	d0,-(sp)		;pbgR[h
	move.w	(screen_height)r,d0
	subq.w	#1,d0
	move.w	d0,-(sp)		;I_YW
	move.w	(screen_width)r,d0
	subq.w	#1,d0
	move.w	d0,-(sp)		;I_XW
	clr.w	-(sp)			;n_YW
	clr.w	-(sp)			;n_XW
	moveq.l	#2-1,d1			;O,
	for	d1
		movea.l	sp,a1
		IOCS	_BOX
		addq.w	#4,(sp)			;n_XW
		addq.w	#4,2(sp)		;n_YW
		subq.w	#4,4(sp)		;I_XW
		subq.w	#4,6(sp)		;I_YW
	next
	lea.l	12(sp),sp
;GRAPHIC PAGE 0/1/2/3Ə
	moveq.l	#0,d5			;y[Wԍ 0,1,2,3
	do
	;
		lea.l	(string_buffer)r,a0
		movestr	'fq`oghb@o`fd@',a1
		bsr	strcpy
		move.w	#'O',d0
		add.w	d5,d0
		rol.w	#8,d0
		move.b	d0,(a0)+
		rol.w	#8,d0
		move.b	d0,(a0)+
		clr.b	d0
	;y[WI
		move.l	d5,d1
		IOCS	_APAGE
	;`
		move.w	#1<<8|0,-(sp)		;TCY 1 px 0
		moveq.l	#1,d0
		add.w	d5,d0
		if	<cmp.l #65536,(palets)r>,eq
			move.w	d5,d0
			lea.l	(graphic_color)r,a0
			add.w	d0,d0
			move.w	(a0,d0.w),d0
		endif
		move.w	d0,-(sp)		;pbgR[h
		move.w	#1<<8|1,-(sp)		;X̔{ 1 Y̔{ 1
		pea.l	(string_buffer)r	;
		moveq.l	#GRAPHIC_LINE,d0
		add.w	d5,d0
		lsl.w	#4,d0
		move.w	d0,-(sp)		;YW
		move.w	#8*2,-(sp)		;XW
		movea.l	sp,a1
		IOCS	_SYMBOL
		lea.l	14(sp),sp
		addq.w	#1,d5
	while	<cmp.b (pages)r,d5>,lo

;XvCgʂ`
;	p^[
;		1	l̃XvCg
;		2	BG0̘g
;		3	BG1̘g
;		4`23	
;	XvCg
;		0`3	l̃XvCg
;		4`9	SPRITE̕
;	pbgubN
;		1	l̃XvCgASPRITE̕
;		2	BG0̘g
;		3	BG1̘g
	do
		break	<tst.b (sprite_exists)r>,eq	;XvCgʂgpłȂ
	;
		moveq.l	#0,d1			;oN͎gpȂ
		IOCS	_SP_INIT
		break	<tst.l d0>,mi		;XvCgʂgpł邪%1xx1xsprdrv.xgݍ܂ĂȂ
		IOCS	_SP_ON
	;pbgݒ肷
		lea.l	(sprite_color)r,a0
		moveq.l	#1,d4			;pbgubN 1,2,3
		do
			moveq.l	#0,d1			;pbgR[h 0
			move.l	d4,d2			;pbgubN 1,2,3
			moveq.l	#0,d3			;J[R[h 0
			IOCS	_SPALET
			moveq.l	#1,d1			;pbgR[h 1
			move.l	d4,d2			;pbgubN 1,2,3
			move.w	(a0)+,d3		;J[R[h
			IOCS	_SPALET
			addq.w	#1,d4
		while	<cmp.w #3,d4>,ls
	;p^[`
		moveq.l	#1,d1			;p^[ԍ 1`3
		moveq.l	#1,d2			;TCY 16x16
		lea.l	(pattern_data)r,a1	;p^[f[^
		do
			IOCS	_SP_DEFCG		;p^[`
			addq.w	#1,d1
			lea.l	128(a1),a1
		while	<cmp.w #3,d1>,ls	;̃p^[ԍ
	;̃p^[`
	;		  4 5 6 7 8 91011121314151617181920212223
		movestr	'roqhsda`bj|fqntmc@OP',a4
		moveq.l	#4,d6			;p^[ԍ 4`23
		dostart
			lsl.w	#8,d1
			move.b	(a4)+,d1		;R[h
			moveq.l	#8,d2			;TCY 16x16
			lea.l	(font_buffer)r,a1	;tHgobt@
			IOCS	_FNTGET			;tHgf[^o
			lea.l	(pattern_buffer)r,a0	;p^[obt@
			moveq.l	#0,d7			;0Œ
			moveq.l	#-2,d5			;-2=,-1=E
			do
				lea.l	(font_buffer+4)r,a1	;tHgf[^̖{
				moveq.l	#16-1,d3		;c16hbg
				for	d3
				;	moveq.l	#0,d0
					move.b	2(a1,d5.w),d1		;܂͉E
					moveq.l	#8-1,d2			;8hbg
					for	d2
						lsl.l	#4,d0			;00000ɁA10001ɂ
						add.b	d1,d1			;d1.b̏ʂ牟o
						addx.b	d7,d0			;d0.l̉ʂ։
					next
					move.l	d0,(a0)+		;p^[f[^
					addq.l	#2,a1
				next
				addq.w	#1,d5
			while	ne
			move.w	d6,d1			;p^[ԍ 4`23
			moveq.l	#1,d2			;TCY 16x16
			lea.l	(pattern_buffer)r,a1	;p^[f[^
			IOCS	_SP_DEFCG		;p^[`
			addq.w	#1,d6			;̃p^[ԍ
		start
			moveq.l	#0,d1
			move.b	(a4)+,d1		;R[h
		while	ne
	;l̃XvCg\
		moveq.l	#0,d6			;ʒu=XvCgԍ 0=,1=E,2=,3=E
		do
			move.l	d6,d1			;XvCgԍ 0`3
			moveq.l	#16,d2			;XW[
			if	<btst.l #0,d6>,ne
				move.w	(screen_width)r,d2	;XWE[
			endif
			moveq.l	#16,d3			;YW[
			if	<btst.l #1,d6>,ne
				move.w	(sprite_height)r,d3	;YW[
			endif
			move.w	#1<<8|1,d4		;pbgubN 1 p^[ԍ 1
			moveq.l	#3,d5			;vCIeB 3
			IOCS	_SP_REGST
			addq.w	#1,d6			;̈ʒu=̃XvCgԍ
		while	<cmp.w #3,d6>,ls
	;SPRITEƏ
		moveq.l	#16+16*1,d2
		movea.l	d2,a2			;XW
		moveq.l	#SPRITE_LINE,d3
		move.w	(screen_height)r,d0
		if	<cmp.w (sprite_height)r,d0>,ne
			add.w	d3,d3
		endif
		lsl.w	#4,d3
		add.w	#16,d3
		movea.l	d3,a3			;YW
	;		 S P R I T E
		movestr	<4,5,6,7,8,9>,a4	;p^[ԍ
		moveq.l	#4,d7			;XvCgԍ
		dostart
			move.l	d7,d1			;XvCgԍ 4`9
			move.w	a2,d2			;XW
			move.w	a3,d3			;YW
			move.w	#1<<8,d4		;pbgubN 1
			move.b	d0,d4			;p^[ԍ
			moveq.l	#3,d5			;vCIeB 3
			IOCS	_SP_REGST
			addq.w	#1,d7			;̃XvCgԍ
			adda.w	#16,a2			;XW
		start
			moveq.l	#0,d0
			move.b	(a4)+,d0		;p^[ԍ
		while	ne
	;BG`
		if	<tst.b (bg_size)r>,eq	;8x8/512x512x2
			moveq.l	#0,d5			;BGeLXgGA 0`1
			do
			;g̃p^[œhׂ
				move.l	d5,d1			;BGeLXgGA 0`1
				move.l	d5,d2
				addq.b	#2,d2			;pbgubN 2`3
				lsl.w	#8,d2
				move.b	d5,d2
				addq.b	#2,d2			;16x16p^[ԍ 2`3
				lsl.b	#2,d2			;8x8p^[ԍ
				IOCS	_BGTEXTCL
			;gcē蔲
				move.l	d5,d1			;BGeLXgGA 0`1
				moveq.l	#0<<8|0,d4		;pbgubN 0 p^[ԍ 0
				moveq.l	#1,d3			;BGeLXgYWBg1
				move.w	(sprite_height)r,d7
				lsr.w	#3,d7			;8x8cɕԐ
				subq.w	#2+1,d7			;g2
				for	d7			;c
					moveq.l	#1,d2			;BGeLXgXWBg1
					move.w	(screen_width)r,d6
					lsr.w	#3,d6			;8x8ɕԐ
					subq.w	#2+1,d6			;g2
					for	d6			;
						IOCS	_BGTEXTST
						addq.w	#1,d2			;BGeLXgXW
					next
					addq.w	#1,d3			;BGeLXgYW
				next
			;BACK-GROUND 0/1Ə
				moveq.l	#2*1,d2
				movea.l	d2,a2			;XW
				moveq.l	#BG_LINE,d3
				add.w	d5,d3
				move.w	(screen_height)r,d0
				if	<cmp.w (sprite_height)r,d0>,ne
					add.w	d3,d3
				endif
				add.w	d3,d3
				movea.l	d3,a3			;YW
			;		  B  A  C  K  -  G  R  O  U  N  D     0
				movestr	<10,11,12,13,14,15,16,17,18,19,20,21,22>,a4	;p^[ԍ
				dostart
					move.l	d5,d4
					addq.b	#2,d4			;pbgubN 2`3
					lsl.w	#8,d4
					if	<cmp.b #22,d0>,eq	;0/1
						add.b	d5,d0			;22(0)23(1)
					endif
					move.b	d0,d4			;16x16p^[ԍ
					lsl.b	#2,d4			;8x8p^[ԍ
					moveq.l	#4-1,d6			;,,E,E
					for	d6
						move.l	d5,d1			;BGeLXgGA 0`1
						moveq.l	#2,d2
						and.b	d4,d2
						lsr.w	#1,d2
						add.w	a2,d2			;BGeLXgXW
						moveq.l	#1,d3
						and.b	d4,d3
						add.w	a3,d3			;BGeLXgYW
						IOCS	_BGTEXTST
						addq.b	#1,d4			;8x8p^[ԍ
					next
					addq.w	#2,a2			;BGeLXgXW
				start
					moveq.l	#0,d0
					move.b	(a4)+,d0		;p^[ԍ
				while	ne
			;\ON
				move.l	d5,d1			;BGy[W 0`1
				move.l	d5,d2			;BGeLXgGA 0`1
				moveq.l	#1,d3			;\ON
				IOCS	_BGCTRLST
			;
				addq.w	#1,d5			;BGeLXgGA
			while	<cmp.w #1,d5>,ls
		else				;16x16/1024x1024x2 gΉ
			moveq.l	#0,d5			;BGeLXgGA 0`1
			do
			;g̃p^[œhׂ
				move.l	d5,d1			;BGeLXgGA 0`1
				move.l	d5,d2
				addq.b	#2,d2			;pbgubN 2`3
				lsl.w	#8,d2
				move.b	d5,d2
				addq.b	#2,d2			;16x16p^[ԍ 2`3
				IOCS	_BGTEXTCL
			;gcē蔲
				move.l	d5,d1			;BGeLXgGA 0`1
				moveq.l	#0<<8|0,d4		;pbgubN 0 p^[ԍ 0
				moveq.l	#1,d3			;BGeLXgYWBg1
				move.w	(sprite_height)r,d7
				lsr.w	#4,d7			;16x16cɕԐ
				subq.w	#2+1,d7			;g2
				for	d7			;c
					moveq.l	#1,d2			;BGeLXgXWBg1
					move.w	(screen_width)r,d6
					lsr.w	#4,d6			;16x16ɕԐ
					subq.w	#2+1,d6			;g2
					for	d6			;
						IOCS	_BGTEXTST
						addq.w	#1,d2			;BGeLXgXW
					next
					addq.w	#1,d3			;BGeLXgYW
				next
			;BACK-GROUND 0/1Ə
				moveq.l	#1*1,d2
				movea.l	d2,a2			;XW
				moveq.l	#BG_LINE,d3
				add.w	d5,d3
				move.w	(screen_height)r,d0
				if	<cmp.w (sprite_height)r,d0>,ne
					add.w	d3,d3
				endif
				movea.l	d3,a3			;YW
			;		  B  A  C  K  -  G  R  O  U  N  D     0
				movestr	<10,11,12,13,14,15,16,17,18,19,20,21,22>,a4	;p^[ԍ
				dostart
					move.l	d5,d4
					addq.b	#2,d4			;pbgubN 2`3
					lsl.w	#8,d4
					if	<cmp.b #22,d0>,eq	;0/1
						add.b	d5,d0			;22(0)23(1)
					endif
					move.b	d0,d4			;16x16p^[ԍ
					move.l	d5,d1			;BGeLXgGA 0`1
					move.w	a2,d2			;BGeLXgXW
					move.w	a3,d3			;BGeLXgYW
					IOCS	_BGTEXTST
					addq.w	#1,a2			;BGeLXgXW
				start
					moveq.l	#0,d0
					move.b	(a4)+,d0		;p^[ԍ
				while	ne
			;\ON
				move.l	d5,d1			;BGy[W 0`1
				move.l	d5,d2			;BGeLXgGA 0`1
				moveq.l	#1,d3			;\ON
				IOCS	_BGCTRLST
			;
				addq.w	#1,d5			;BGeLXgGA
			while	<cmp.w #1,d5>,ls
		endif
	while	f

;L[͂҂Ăʃ[h𕜌
	IOCS	_B_CUROFF
	DOS	_GETC
	if	<cmp.b #27,d0>,eq	;ESCL[ꂽƂ
	;XvCgʂƃOtBbNʂOFFɂ
		moveq.l	#$0020,d1
		IOCS	_CRTMOD2
	;eLXgʂ
		moveq.l	#2,d1
		IOCS	_B_CLR_ST
	;eLXgpbg𕜌
		moveq.l	#3,d1
		moveq.l	#-2,d2
		IOCS	_TPALET
	else				;ESCL[ȊOꂽƂ
	;CRTorLCD[h𕜌
		if	<tst.b (save_to_sram)r>,eq	;CRTorLCD[hSRAMɕۑȂ
			if	<tst.b (saved_crtlcd)r>,eq	;CRT
				move.w	#$43FF,d1
			else				;LCD
				move.w	#$4CFF,d1
			endif
			IOCS	_CRTMOD			;CRTorLCD[h𕜌
		endif
	;OS̉ʃ[h𕜌
		move.l	#(16<<16)|$FFFF,-(sp)
		DOS	_CONCTRL
		move.w	d0,2(sp)
		DOS	_CONCTRL
		addq.l	#4,sp
	endif
	IOCS	_B_CURON

;I
exit:
	DOS	_EXIT

;^CgƎgp@\ďI
usage_exit:
	lea.l	title_usage(pc),a0
	bsr	more
	goto	exit

;^CgƎgp@
title_usage:
	.dc.b	TITLE_STRING,13,10
	.dc.b	13,10
	.dc.b	'',13,10
	.dc.b	'  crtmodtest.xCRTMOD̎ƃj^̐\mF邽߂̉ʂ\܂B',13,10
	.dc.b	'  ESCL[Ɖʃ[hύX܂܏IÃL[ƌɖ߂ďI܂B',13,10
	.dc.b	13,10
	.dc.b	'IvV',13,10
	.dc.b	'  -l 0`1    0CRT̓gA1LCD̓gI܂B',13,10
	.dc.b	'  -m 0`73   ʃ[hI܂B',13,10
	.dc.b	'  -s         -l̑ISRAMɕۑ܂B',13,10
	.dc.b	13,10
	.dc.b	'ʃ[ḧꗗ',13,10
	.dc.b	'  ',13,10
	.dc.b	'          F            CRT           LCD     ',13,10
	.dc.b	'   TCY   TCY  y[W[h    ',13,10
	.dc.b	'  ',13,10
	.dc.b	'   256x256  512x512    16  4   6  31.500kHz 55.458Hz34.500kHz 55.200Hz',13,10
	.dc.b	'              V      256  2  10     X^2xǂ     X^2xǂ  ',13,10
	.dc.b	'              V    65536  1  14                                      ',13,10
	.dc.b	'           1024x1024   16  1   2                                      ',13,10
	.dc.b	'              V      256* 1  50*                                     ',13,10
	.dc.b	'              V    65536* 1  63*                                     ',13,10
	.dc.b	'  ',13,10
	.dc.b	'   256x256  512x512    16  4  37* 31.963kHz 56.273Hz31.963kHz 51.141Hz',13,10
	.dc.b	'   `     V      256  2  38*    X^2xǂ     X^2xǂ  ',13,10
	.dc.b	'              V    65536  1  39*                                     ',13,10
	.dc.b	'           1024x1024   16  1  36*                                     ',13,10
	.dc.b	'              V      256* 1  58*                                     ',13,10
	.dc.b	'              V    65536* 1  71*                                     ',13,10
	.dc.b	'                                      ',13,10
	.dc.b	'   384x256  512x512    16  4  29*                                     ',13,10
	.dc.b	'              V      256  2  30*                                     ',13,10
	.dc.b	'              V    65536  1  31*                                     ',13,10
	.dc.b	'           1024x1024   16  1  28*                                     ',13,10
	.dc.b	'              V      256* 1  56*                                     ',13,10
	.dc.b	'              V    65536* 1  69*                                     ',13,10
	.dc.b	'  ',13,10
	.dc.b	'   512x256  512x512    16  4  41* 31.500kHz 55.458Hz35.341kHz 56.546Hz',13,10
	.dc.b	'              V      256  2  42*    X^2xǂ     X^2xǂ  ',13,10
	.dc.b	'              V    65536  1  43*                                     ',13,10
	.dc.b	'           1024x1024   16  1  40*                                     ',13,10
	.dc.b	'              V      256* 1  59*                                     ',13,10
	.dc.b	'              V    65536* 1  72*                                     ',13,10
	.dc.b	'                                      ',13,10
	.dc.b	'   512x256  512x512    16  4  45*                                     ',13,10
	.dc.b	'  SP:         V      256  2  46*                                     ',13,10
	.dc.b	'   512x512    V    65536  1  47*                                     ',13,10
	.dc.b	'           1024x1024   16  1  44*                                     ',13,10
	.dc.b	'              V      256* 1  60*                                     ',13,10
	.dc.b	'              V    65536* 1  73*                                     ',13,10
	.dc.b	'  ',13,10
	.dc.b	'   512x512  512x512    16  4   4  31.500kHz 55.458Hz35.341kHz 56.546Hz',13,10
	.dc.b	'              V      256  2   8                                      ',13,10
	.dc.b	'              V    65536  1  12                                      ',13,10
	.dc.b	'           1024x1024   16  1   0                                      ',13,10
	.dc.b	'              V      256* 1  48*                                     ',13,10
	.dc.b	'              V    65536* 1  61*                                     ',13,10
	.dc.b	'                    ',13,10
	.dc.b	'   512x512  512x512    16  4  33*                   35.056kHz 56.090Hz',13,10
	.dc.b	'   `     V      256  2  34*                                     ',13,10
	.dc.b	'              V    65536  1  35*                                     ',13,10
	.dc.b	'           1024x1024   16  1  32*                                     ',13,10
	.dc.b	'              V      256* 1  57*                                     ',13,10
	.dc.b	'              V    65536* 1  70*                                     ',13,10
	.dc.b	'                                      ',13,10
	.dc.b	'   768x512  512x512   256  2  20                                      ',13,10
	.dc.b	'              V    65536  1  24                                      ',13,10
	.dc.b	'           1024x1024   16  1  16                                      ',13,10
	.dc.b	'              V      256* 1  52*                                     ',13,10
	.dc.b	'              V    65536* 1  65*                                     ',13,10
	.dc.b	'                    ',13,10
	.dc.b	'   640x480  512x512   256  2  23                    31.469kHz 59.940Hz',13,10
	.dc.b	'              V    65536  1  27                            VGA       ',13,10
	.dc.b	'           1024x1024   16  1  19                                      ',13,10
	.dc.b	'              V      256* 1  55*                                     ',13,10
	.dc.b	'              V    65536* 1  68*                                     ',13,10
	.dc.b	'  ',13,10
	.dc.b	'   256x240  512x512    16  4   7  15.980kHz 61.463Hz34.500kHz 55.200Hz',13,10
	.dc.b	'              V      256  2  11                       X^2xǂ  ',13,10
	.dc.b	'              V    65536  1  15                                      ',13,10
	.dc.b	'           1024x1024   16  1   3                                      ',13,10
	.dc.b	'              V      256* 1  51*                                     ',13,10
	.dc.b	'              V    65536* 1  64*                                     ',13,10
	.dc.b	'  ',13,10
	.dc.b	'   512x480  512x512    16  4   5  15.980kHz 61.463Hz35.341kHz 56.546Hz',13,10
	.dc.b	'              V      256  2   9    C^[[X                    ',13,10
	.dc.b	'              V    65536  1  13                                      ',13,10
	.dc.b	'           1024x1024   16  1   1                                      ',13,10
	.dc.b	'              V      256* 1  49*                                     ',13,10
	.dc.b	'              V    65536* 1  62*                                     ',13,10
	.dc.b	'  ',13,10
	.dc.b	'  CRT:      512x512   256  2  21  24.699kHz 53.116Hz35.056kHz 56.090Hz',13,10
	.dc.b	'  1024x424    V    65536  1  25                                      ',13,10
	.dc.b	'  LCD:     1024x1024   16  1  17                                      ',13,10
	.dc.b	'   768x600    V      256* 1  53*                                     ',13,10
	.dc.b	'              V    65536* 1  66*                                     ',13,10
	.dc.b	'  ',13,10
	.dc.b	'  CRT:      512x512   256  2  22  24.699kHz 53.116Hz35.056kHz 56.090Hz',13,10
	.dc.b	'  1024x848    V    65536  1  26    C^[[X    C^[[X  ',13,10
	.dc.b	'  LCD:     1024x1024   16  1  18                                      ',13,10
	.dc.b	'  768x1024    V      256* 1  54*                                     ',13,10
	.dc.b	'              V    65536* 1  67*                                     ',13,10
	.dc.b	'  ',13,10
	.dc.b	0
	.even

;F
text_color:	dchsv	0,24,31
graphic_color:	dchsv	24,24,31
		dchsv	48,24,31
		dchsv	72,24,31
		dchsv	96,24,31
sprite_color:	dchsv	120,24,31
		dchsv	144,24,31
		dchsv	168,24,31

;p^[f[^
pattern_data:
	.dc.l	$00001111		;1 l̃XvCg
	.dc.l	$00001111
	.dc.l	$00001111
	.dc.l	$00001111
	.dc.l	$11110000
	.dc.l	$11110000
	.dc.l	$11110000
	.dc.l	$11110000
	.dc.l	$00001111
	.dc.l	$00001111
	.dc.l	$00001111
	.dc.l	$00001111
	.dc.l	$11110000
	.dc.l	$11110000
	.dc.l	$11110000
	.dc.l	$11110000

	.dc.l	$00001111
	.dc.l	$00001111
	.dc.l	$00001111
	.dc.l	$00001111
	.dc.l	$11110000
	.dc.l	$11110000
	.dc.l	$11110000
	.dc.l	$11110000
	.dc.l	$00001111
	.dc.l	$00001111
	.dc.l	$00001111
	.dc.l	$00001111
	.dc.l	$11110000
	.dc.l	$11110000
	.dc.l	$11110000
	.dc.l	$11110000

	.dc.l	$00110011		;2 BG0̘g
	.dc.l	$00110011
	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$00110011
	.dc.l	$00110011
	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$00110011
	.dc.l	$00110011
	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$00110011
	.dc.l	$00110011
	.dc.l	$00000000
	.dc.l	$00000000

	.dc.l	$00110011
	.dc.l	$00110011
	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$00110011
	.dc.l	$00110011
	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$00110011
	.dc.l	$00110011
	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$00110011
	.dc.l	$00110011
	.dc.l	$00000000
	.dc.l	$00000000

	.dc.l	$00000000		;3 BG1̘g
	.dc.l	$00000000
	.dc.l	$11001100
	.dc.l	$11001100
	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$11001100
	.dc.l	$11001100
	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$11001100
	.dc.l	$11001100
	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$11001100
	.dc.l	$11001100

	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$11001100
	.dc.l	$11001100
	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$11001100
	.dc.l	$11001100
	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$11001100
	.dc.l	$11001100
	.dc.l	$00000000
	.dc.l	$00000000
	.dc.l	$11001100
	.dc.l	$11001100

	.bss

save_to_sram:	.ds.b	1		;CRTorLCD[hSRAMɕۑ邩B0=Ȃ,-1=
saved_crtlcd:	.ds.b	1		;̉ʃ[h
screen_mode:	.ds.b	1		;ʃ[h
crtlcd_mode:	.ds.b	1		;CRTorLCD[hB0=CRT,-1=LCD
pages:		.ds.b	1		;OtBbNy[W
bg_size:	.ds.b	1		;BGTCYB0=8x8/512x512x2,-1=16x16/1024x1024x1
sprite_exists:	.ds.b	1		;XvCgʂ̗LB0=Ȃ,-1=
	.even
screen_width:	.ds.w	1		;ʂ̕
screen_height:	.ds.w	1		;ʂ̍
sprite_height:	.ds.w	1		;XvCgʂ̍
real_size:	.ds.w	1		;ʃTCY
palets:		.ds.l	1		;OtBbNF
font_buffer:	.ds.w	2+2+3*24	;tHgobt@
pattern_buffer:	.ds.l	8*4		;XvCgp^[obt@
string_buffer:	.ds.b	256		;obt@

	.text



;----------------------------------------------------------------
;-more-݂Ȃ當\
;<a0.l:
more::
	push	d0-d5/a0-a2
;W͂mF
	clr.l	-(sp)			;(0<<16)|0
	DOS	_IOCTRL
	addq.l	#4,sp
;<d0.b:W͂FCBtO
	and.b	#$81,d0			;LN^foCXAW
	goto	<cmp.b #$81,d0>,ne,90f	;W͂_CNgĂBmoreȂ
;Wo͂mF
	pea.l	1.w			;(0<<16)|1
	DOS	_IOCTRL
	addq.l	#4,sp
;<d0.b:Wo͂FCBtO
	and.b	#$82,d0			;LN^foCXAWo
	goto	<cmp.b #$82,d0>,ne,90f	;Wo͂_CNgĂBmoreȂ
;CONDRV.SYSmF
	move.w	#$0100+_KEY_INIT,-(sp)
	DOS	_INTVCG
	addq.l	#2,sp
	movea.l	d0,a1
	subq.l	#4,a1
	IOCS	_B_LPEEK
	goto	<cmp.l #'hmk*',d0>,eq,90f	;CONDRV.SYSgݍ܂ĂBmoreȂ
;ʂ̑傫mF
	moveq.l	#-1,d1
	moveq.l	#-1,d2
	IOCS	_B_CONSOL
;<d2.l:E[̌W<<16|[̍sW
	move.w	d2,d3
	swap.w	d2
	addq.w	#1,d2
;<d2.w:ʂ̌
;<d3.w:[̍sWB-more-̍sʂ̍s
	gotoor	<cmp.w #8,d2>,lo,<tst.w d3>,eq,90f	;ʂBmoreȂB^u܂߂1ȏ㏑Ȃ΂ȂȂ̂8x1s
;y[W[v
	do
		move.l	#0,d4			;W
		move.l	#0,d5			;sW
		movea.l	a0,a2			;y[W擪
	;[v
		do
			movea.l	a0,a1			;擪
			move.b	(a0)+,d0		;1oCg
			if	eq			;00 I
				subq.l	#1,a0
				break
			elif	<cmp.b #$09,d0>,eq	;09 ^u
				moveq.l	#7,d1
				and.w	d4,d1
				subq.w	#8,d1
				neg.w	d1		;^ǔ
			elif	<cmp.b #$0A,d0>,eq	;0A s
				moveq.l	#0,d4		;[
				addq.w	#1,d5		;̍s
				break	<cmp.w d3,d5>,eq	;[By[WI
				continue
			elif	<cmp.b #$0C,d0>,eq	;0C y[W
				break
			elif	<cmp.b #$1F,d0>,ls	;01-08,0B,0D-1F 
				continue
			else				;20-FF
				do
					moveq.l	#1,d1			;p̌
					break	<tst.b d0>,pl		;20-7F AXL[
					breakand	<cmp.b #$A0,d0>,hs,<cmp.b #$DF,d0>,ls	;A0-DF pJ^Ji
					addq.l	#1,a0			;2oCg
					break	<cmp.b #$80,d0>,eq	;8000-80FF pЂ炪
					break	<cmp.b #$F0,d0>,hs	;F000-FFFF 1/4pApO
					moveq.l	#2,d1			;Sp̌
				while	f
			endif
			add.w	d1,d4			;\̌W
			if	<cmp.w d2,d4>,hi	;͂ݏo
				sub.w	d1,d4			;i݉߂߂
				movea.l	a1,a0
				addq.w	#1,d5			;̍s
				break	<cmp.w d3,d5>,eq	;[By[WI
				moveq.l	#0,d4			;[
			endif
		while	t
	;1y[W\
		move.l	a0,d0			;
		sub.l	a2,d0			;-擪=
		move.l	d0,-(sp)		;
		move.l	a2,-(sp)		;擪
		move.w	#1,-(sp)		;Wo
		DOS	_WRITE
		lea.l	10(sp),sp
	;ȂΏI
		break	<tst.b (a0)>,eq
	;KvȂΉs
		ifand	<tst.w d4>,ne,<cmp.w d2,d4>,ne	;[łE[łȂ
			bsr	printcrlf
		endif
	;-more-\
		pea.l	6.w
		pea.l	100f(pc)		;'-more-'
		move.w	#1,-(sp)
		DOS	_WRITE
		lea.l	10(sp),sp
	;L[͂҂
		DOS	_GETC
		move.l	d0,d1
	;s
		bsr	printcrlf
	whileand	<cmp.b #$1B,d1>,ne,<cmp.b #'Q',d1>,ne,<cmp.b #'q',d1>,ne	;ESC܂QꂽƂ͏I
99:	pop
	rts

;moreȂ
90:	bsr	print
	goto	99b

100:	.dc.b	'-more-'
	.even

;----------------------------------------------------------------
;󔒂ǂݔ΂
;<a0.l:
;>d0.l:ŏ̋󔒈ȊO̕܂0
;>a0.l:ŏ̋󔒈ȊO̕܂0̈ʒu
;>z:ne=󔒈ȊO̕,eq=󔒈ȊO̕Ȃ
nextword::
	moveq.l	#0,d0
	do
		move.b	(a0)+,d0		;̕
		break	eq			;0ȂΏI
		redo	<cmp.b #' ',d0>,eq	;' 'ȂΌJԂ
	whileand	<cmp.b #9,d0>,hs,<cmp.b #13,d0>,ls	;\t\n\v\f\rȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	tst.l	d0
	rts

;----------------------------------------------------------------
;\
;<a0.l:
print::
	push	d0
	bsr	strlen
	move.l	d0,-(sp)
	move.l	a0,-(sp)
	move.w	#1,-(sp)
	DOS	_WRITE
	lea.l	(10,sp),sp
	pop
	rts

;----------------------------------------------------------------
;s\
printcrlf::
	move.l	a0,-(sp)
	lea.l	100f(pc),a0		;13,10
	bsr	print
	movea.l	(sp)+,a0
	rts

100:	.dc.b	13,10,0
	.even

;----------------------------------------------------------------
;10i̕𕄍Ȃɕϊ
;<a0.l:10i̕B擪̋󔒂͔F߂Ȃ
;>d0.l:(cĉƂ)ȂB(cŝƂ)0=10i̕Ȃ,-1=I[o[t[
;>a0.l:(cĉƂ)10i̎̈̕ʒuB(cŝƂ)ωȂ
;>z:(cĉƂ)eq=Ȃ0
;>v:(cŝƂ)vc=10i̕Ȃ,vs=I[o[t[
;>c:cs=10i̕Ȃ܂̓I[o[t[
stou::
	push	d1-d2/a1
	moveq.l	#0,d0			;Ȃ
	moveq.l	#0,d1			;
	movea.l	a0,a1			;Jnʒu
	dostart
		goto	<cmp.l #$1999999A,d0>,hs,20f	;10{I[o[t[
		move.l	d0,d2			;1{
		lsl.l	#2,d0			;4{
		add.l	d2,d0			;5{
		add.l	d0,d0			;10{
		add.l	d1,d0			;1
		goto	cs,20f			;I[o[t[
	start
		move.b	(a0)+,d1		;̕
		sub.b	#'0',d1			;ɂ
	whileand	<>,hs,<cmp.b #10,d1>,lo	;10i̕ȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	goto	<cmpa.l a1,a0>,eq,30f	;iłȂB10i̕Ȃ
	tst.l	d0			;ne/eq,vc,cc
10:	pop
	rts

;I[o[t[
20:
  .if 0
	do
		move.b	(a0)+,d1		;̕
		sub.b	#'0',d1			;ɂ
	whileand	<>,hs,<cmp.b #10,d1>,lo	;10i̕ǂݔ΂
	subq.l	#1,a0			;i݉߂߂
  .else
	movea.l	a1,a0			;Jnʒuɖ߂
  .endif
	moveq.l	#-1,d0			;I[o[t[
	move.w	#%00011,ccr		;ne,vs,cs
	goto	10b

;10i̕Ȃ
30:
;	moveq.l	#0,d0			;10i̕Ȃ
	move.w	#%00101,ccr		;eq,vc,cs
	goto	10b

;----------------------------------------------------------------
;Rs[
;<a0.l:Rs[
;<a1.l:Rs[
;>a0.l:Rs[0̈ʒu
;>a1.l:Rs[0̎̈ʒu
strcpy::
	do
		move.b	(a1)+,(a0)+
	while	ne			;0łȂΌJԂ
	subq.l	#1,a0			;i݉߂߂
	rts

;----------------------------------------------------------------
;̒𐔂
;<a0.l:
;>d0.l:
strlen::
	move.l	a0,d0			;d0=擪
	do
		tst.b (a0)+
	while	ne			;0łȂΌJԂ
	subq.l	#1,a0			;i݉߂߂Ba0=
	exg.l	d0,a0			;d0=,a0=擪
	sub.l	a0,d0			;d0=-擪=
	rts

;----------------------------------------------------------------
;ɂ
;<d0.b:
;>d0.b:
tolower::
	ifand	<cmp.b #'A',d0>,hs,<cmp.b #'Z',d0>,ls	;啶
		add.b	#'a'-'A',d0		;ɂ
	endif
	rts

;----------------------------------------------------------------
;32rbgȂ10i̕ɕϊ
;<d0.l:Ȃ
;<a0.l:obt@B10i̐̕擪
;>a0.l:10i̖̕0̈ʒu
utos::
	if	<tst.l d0>,eq		;0
		move.b	#'0',(a0)+
	else				;0ȊO
		push	d0-d2/a1
		lea.l	utos_table(pc),a1
		do
			move.l	(a1)+,d1
		while	<cmp.l d1,d0>,lo	;Ƃ܂ŐiށB[TvX
		do
			moveq.l	#'0'-1,d2
			do
				addq.b	#1,d2
				sub.l	d1,d0
			while	hs			;񐔂𐔂
			move.b	d2,(a0)+
			add.l	d1,d0			;߂߂
			move.l	(a1)+,d1
		while	ne
		pop
	endif
	clr.b	(a0)
	rts

utos_table::
	.dc.l	1000000000
	.dc.l	100000000
	.dc.l	10000000
	.dc.l	1000000
	.dc.l	100000
	.dc.l	10000
	.dc.l	1000
	.dc.l	100
	.dc.l	10
	.dc.l	1
	.dc.l	0



	.end
