;----------------------------------------------------------------
;
;	_HIMEM
;
;----------------------------------------------------------------

	.include	t02const.equ
	.include	t08debug.equ
	.include	t09version.equ

;__DEBUG__	equ	1

;TS16_VERSION
;	TS16DRV.Xł̃o[W
;	TS16DRV.X̍Ō̃o[W$12Ȃ̂ŁA$13ɂĂ
TS16_VERSION	equ	$13

	.cpu	68060

;----------------------------------------------------------------
;IOCS _HIMEM($F8)	nC
;	TS-6BE16̓YtfBXNɓĂHIMEM.SYS v1.0Ƃقڏʌ݊
;	gTS-6BE16ǗhCo(TS16DRV.X)Ƃقڏʌ݊
;<d1.w:R}hR[h
;	1	HIMEM_MALLOC
;		ubN̊m
;			ʃAhXmۂ
;			<d2.l:mۂubÑTCY
;			>d0.l:0=,-1=s
;			>a1.l:0=s,0ȊO=mۂubÑ[Ü̐擪
;	2	HIMEM_FREE
;		ubN̊J
;			<d2.l:JubÑ[Ü̐擪
;				0=s̃vZXmۂubNׂĊJ
;			>d0.l:0=,-1=s
;	3	HIMEM_GETSIZE
;		mۂłTCY̎擾
;			>d0.l:mۂłTCY̍v
;			>d1.l:xɊmۂłő̃TCY
;	4	HIMEM_RESIZE
;		ubÑTCYύX
;			ubN͈ړȂ
;			VTCY0Ȃ΃ubNJ
;			<d2.l:TCYύXubÑ[Ü̐擪
;			<d3.l:VTCY(0=ubNJ)
;			>d0.l:0=,-1=s
;	ȍ~̃R[HIMEM.SYS v1.0ɂ͂Ȃ
;	5	HIMEM_VERSION
;		_HIMEM̃o[W̎擾
;			>d0.l:'060T'
;			>d1.l:o[W
;	6	HIMEM_CALLOC
;		ẑ߂̃ubN̊m
;			ʃAhXmۂ
;			mۂubN0ŏ
;			<d2.l:zvf
;			<d3.l:zvfTCY
;			>d0.l:0=,-1=s
;			>a1.l:0=s,0ȊO=mۂubÑ[Ü̐擪
;	7	HIMEM_REALLOC
;		ubÑTCYύX
;			ubNړ邱Ƃ
;			ړƂVubN͉ʂmۂ
;			ړĂubNmۂvZX͕ωȂ
;			VTCY0Ȃ΃ubNJ
;			<d2.l:TCYύXubÑ[Ü̐擪
;			<d3.l:VTCY(0=ubNJ)
;			>d0.l:0=,-1=s
;			>a1.l:0=s,0ȊO=ړ̃ubÑ[Ü̐擪
;	8	HIMEM_MALLOC2
;		ubN̊m
;			<d2.l:mۂTCY
;			<d3.w:bit15=vZXwtO
;					0	s̃vZX
;					1	d4.levZXƂĎgp
;				8bit=[h
;					0	ʂ
;					1	KvŏubN
;					2	ʂ
;					3	őubN
;			<d4.l:(d3.wbit151̂Ƃ)evZX̃Ǘe[u
;			>d0.l:0=,$81xxxxxx=mۂłő̃TCY,$82000000=܂mۂłȂ
;			>a1.l:0=s,0ȊO=mۂubÑ[Ü̐擪
;	9	HIMEM_PSFREE
;		̃vZXmۂubN̊J
;			qvZXmۂubNJ
;			<d2.l:JubNmۂvZX̃Ǘe[u
;			>d0.l:0=,-1=s
;	10	HIMEM_GETAREA
;		_HIMEMŃANZXł郁Ԃ̎擾
;			>d0.l:Ԃ̐擪(擪̃ubÑwb_),-1=s
;			>d1.l:Ԃ̖+1,-1=s
;?d0,d1-d7/a0-a6͕ԋpɎĝĔj󂳂Ȃ
	.dc.b	'060T'
	.dc.b	'TS16DRV',TS16_VERSION
	.dc.b	'HIMEM',0
iocsHimem::
	cmp.w	#(himemJumpTableEnd-himemJumpTable)/4,d1
	bcc	himemUnknownCall
	jmp	([himemJumpTable,pc,d1.w*4])

himemReserved:
himemUnknownCall:
	moveq.l	#-1,d0
	rts

himemJumpTable:
	.dc.l	himemReserved
	.dc.l	himemMalloc
	.dc.l	himemFree
	.dc.l	himemGetSize
	.dc.l	himemResize
	.dc.l	himemVersion
	.dc.l	himemCalloc
	.dc.l	himemRealloc
	.dc.l	himemMalloc2
	.dc.l	himemPsfree
	.dc.l	himemGetArea
himemJumpTableEnd:

;----------------------------------------------------------------
;_HIMEM	1	ubN̊m
;	ʃAhXmۂ
;<d2.l:mۂubÑTCY
;>d0.l:0=,-1=s
;>a1.l:0=s,0ȊO=mۂubÑ[Ü̐擪
himemMalloc::
  debug '|himemMalloc in (size)=',1,d2
	movem.l	d4/a4-a5,-(sp)
	bsr	himemAreaSet
	bmi	himemMallocFailed
;<a4.l:Ԃ̐擪(擪̃ubÑwb_)
;<a5.l:Ԃ̖+1(16oCgACg)
	bsr	getProc
;<d4.l:s̃vZX̃Ǘe[u
	bsr	malloc20		;ubN̊m(ʂ)
;<d0.l:0=,$8xxxxxxx=mۂłő̃TCY
;<a1.l:0=s,0ȊO=mۂubÑ[Ü̐擪
	bpl	himemMallocEnd
	moveq.l	#-1,d0
himemMallocEnd:
  debug '|himemMalloc out (err,ptr)=',2,d0,a1
	movem.l	(sp)+,d4/a4-a5
	rts

himemMallocFailed:
	suba.l	a1,a1
	bra	himemMallocEnd

;----------------------------------------------------------------
;_HIMEM	2	ubN̊J
;<d2.l:JubÑ[Ü̐擪
;	0=s̃vZXmۂubNׂĊJ
;>d0.l:0=,-1=s
himemFree::
  debug '|himemFree in (ptr)=',1,d2
	movem.l	a4-a5,-(sp)
	bsr	himemAreaSet
	bmi	himemFreeEnd
;<a4.l:Ԃ̐擪(擪̃ubÑwb_)
;<a5.l:Ԃ̖+1(16oCgACg)
	tst.l	d2
	beq	himemFreeProc		;s̃vZXmۂubNׂĊJ
	bsr	free
;<d0.l:0=,-1=wb_Ȃ
himemFreeEnd:
  debug '|himemFree out (err)=',1,d0
	movem.l	(sp)+,a4-a5
	rts

;s̃vZXmۂubNׂĊJ
himemFreeProc:
	move.l	d4,-(sp)
	bsr	getProc
;<d4.l:s̃vZX̃Ǘe[u
	bsr	psfree
;<d0.l:0(ɐ)
	move.l	(sp)+,d4
	tst.l	d0
	bra	himemFreeEnd

;----------------------------------------------------------------
;_HIMEM	3	mۂłTCY̎擾
;>d0.l:mۂłTCY̍v
;>d1.l:xɊmۂłő̃TCY
;*d0-d1
himemGetSize::
  debug '|himemGetSize in',0
	movem.l	a4-a5,-(sp)
	bsr	himemAreaSet
	bmi	himemGetSizeFailed
;<a4.l:Ԃ̐擪(擪̃ubÑwb_)
;<a5.l:Ԃ̖+1(16oCgACg)
	bsr	getSize
;<d0.l:mۂłTCY̍v
;<d1.l:xɊmۂłő̃TCY
himemGetSizeEnd:
  debug '|himemGetSize out (ttl,max)=',2,d0,d1
	movem.l	(sp)+,a4-a5
	rts

himemGetSizeFailed:
	moveq.l	#0,d0
	moveq.l	#0,d1
	bra	himemGetSizeEnd

;----------------------------------------------------------------
;_HIMEM	4	ubÑTCYύX
;	ubN͈ړȂ
;	VTCY0Ȃ΃ubNJ
;<d2.l:TCYύXubÑ[Ü̐擪
;<d3.l:VTCY(0=ubNJ)
;>d0.l:0=,-1=s
;*d0
himemResize::
  debug '|himemResize in (ptr,size)=',2,d2,d3
	movem.l	a4-a5,-(sp)
	bsr	himemAreaSet
	bmi	himemResizeEnd
;<a4.l:Ԃ̐擪(擪̃ubÑwb_)
;<a5.l:Ԃ̖+1(16oCgACg)
	bsr	resizeOrFree
;<d0.l:0=,-1=wb_Ȃ,$8xxxxxxx=mۂłő̃TCY
	bpl	himemResizeEnd
	moveq.l	#-1,d0
himemResizeEnd:
  debug '|himemResize out (err)=',1,d0
	movem.l	(sp)+,a4-a5
	rts

;----------------------------------------------------------------
;_HIMEM	5	_HIMEM̃o[W̎擾
;>d0.l:'060T'
;>d1.l:o[W
;*d0-d1
himemVersion::
	move.l	#'060T',d0
	move.l	#VERSION,d1
	rts

;----------------------------------------------------------------
;_HIMEM	6	ẑ߂̃ubN̊m
;	ʃAhXmۂ
;	mۂubN0ŏ
;<d2.l:zvf
;<d3.l:zvfTCY
;>d0.l:0=,-1=s
;>a1.l:0=s,0ȊO=mۂubÑ[Ü̐擪
himemCalloc::
  debug '|himemCalloc in (cnt,size)=',2,d2,d3
	movem.l	d1-d2/d4/a2/a4-a5,-(sp)
	bsr	himemAreaSet
	bmi	himemCallocFailed
;<a4.l:Ԃ̐擪(擪̃ubÑwb_)
;<a5.l:Ԃ̖+1(16oCgACg)
	move.l	d2,d0
	move.l	d3,d1
	bsr	imul			;32bit~32bit64bitZ(Ȃ)
	tst.l	d0
	bne	himemCallocFailed	;I[o[t[
	move.l	d1,d2
	bmi	himemCallocFailed	;I[o[t[
	bsr	getProc
;<d4.l:s̃vZX̃Ǘe[u
	bsr	malloc20		;ubN̊m(ʂ)
;<d0.l:0=,$8xxxxxxx=mۂłő̃TCY
;<a1.l:0=s,0ȊO=mۂubÑ[Ü̐擪
	bmi	himemCallocFailed	;mۂłȂ
	movea.l	a1,a2			;mۂubÑ[Ü̐擪
	subq.l	#1,d2
	bcs	himemCallocDone		;TCY0
	moveq.l	#0,d0
	lsr.l	#4,d2			;(TCY-1)/16=(TCY+15)/16-1
	swap.w	d2
himemCallocClear1:
	swap.w	d2
himemCallocClear0:
	move.l	d0,(a2)+
	move.l	d0,(a2)+
	move.l	d0,(a2)+
	move.l	d0,(a2)+
	dbra	d2,himemCallocClear0
	swap.w	d2
	dbra	d2,himemCallocClear1
himemCallocDone:
	moveq.l	#0,d0
himemCallocEnd:
  debug '|himemCalloc out (err,ptr)=',2,d0,a1
	movem.l	(sp)+,d1-d2/d4/a2/a4-a5
	rts

himemCallocFailed:
	suba.l	a1,a1
	moveq.l	#-1,d0
	bra	himemCallocEnd

;----------------------------------------------------------------
;_HIMEM	7	ubÑTCYύX
;	ubNړ邱Ƃ
;	ړƂVubN͉ʂmۂ
;	ړĂubNmۂvZX͕ωȂ
;	VTCY0Ȃ΃ubNJ
;<d2.l:TCYύXubÑ[Ü̐擪
;<d3.l:VTCY(0=ubNJ)
;>d0.l:0=,-1=s
;>a1.l:0=s,0ȊO=ړ̃ubÑ[Ü̐擪
himemRealloc::
  debug '|himemRealloc in (ptr,size)=',2,d2,d3
	movem.l	d1-d2/a2/a4-a5,-(sp)
	bsr	himemAreaSet
	bmi	himemReallocFailed
;<a4.l:Ԃ̐擪(擪̃ubÑwb_)
;<a5.l:Ԃ̖+1(16oCgACg)
	bsr	reallocOrFree
;>d0.l:0=,$8xxxxxxx=mۂłő̃TCY
;>a1.l:0=s,0ȊO=ړ̃ubÑ[Ü̐擪
	bmi	himemReallocFailed
himemReallocEnd:
  debug '|himemRealloc out (err,ptr,)=',2,d0,a1
	movem.l	(sp)+,d1-d2/a2/a4-a5
	rts

himemReallocFailed:
	suba.l	a1,a1
	moveq.l	#-1,d0
	bra	himemReallocEnd

;----------------------------------------------------------------
;_HIMEM	8	ubN̊m
;<d2.l:mۂTCY
;<d3.w:bit15=vZXwtO
;		0	s̃vZX
;		1	d4.levZXƂĎgp
;	8bit=[h
;		0	ʂ
;		1	KvŏubN
;		2	ʂ
;		3	őubN
;<d4.l:(d3.wbit151̂Ƃ)evZX̃Ǘe[u
;>d0.l:0=,$8xxxxxxx=mۂłő̃TCY
;>a1.l:0=s,0ȊO=mۂubÑ[Ü̐擪
;*d0/a1
himemMalloc2::
  debug '|himemMalloc2 in (size,mode,proc)=',3,d2,d3,d4
	movem.l	d4/a4-a5,-(sp)
	bsr	himemAreaSet
	bmi	himemMalloc2Failed
;<a4.l:Ԃ̐擪(擪̃ubÑwb_)
;<a5.l:Ԃ̖+1(16oCgACg)
	move.w	d3,d0
	bmi	@f
	bsr	getProc
@@:
;<d4.l:s̃vZX̃Ǘe[u
	and.w	#$00FF,d0
	cmp.w	#4,d0
	bcc	himemMalloc2Failed
	jsr	([malloc2Table,pc,d0.w*4])	;ubN̊m
;<d0.l:0=,$8xxxxxxx=mۂłő̃TCY
;<a1.l:0=s,0ȊO=mۂubÑ[Ü̐擪
	bpl	himemMalloc2End
	moveq.l	#-1,d0
himemMalloc2End:
  debug '|himemMalloc2 out (err,ptr)=',2,d0,a1
	movem.l	(sp)+,d4/a4-a5
	rts

himemMalloc2Failed:
	suba.l	a1,a1
	moveq.l	#-1,d0
	bra	himemMalloc2End

;----------------------------------------------------------------
;_HIMEM	9	̃vZXmۂubN̊J
;	qvZXmۂubNJ
;<d2.l:JubNmۂvZX̃Ǘe[u
;>d0.l:0=,-1=s
;*d0
himemPsfree::
  debug '|himemPsfree in (proc)=',1,d2
	movem.l	d4/a4-a5,-(sp)
	bsr	himemAreaSet
	bmi	himemPsfreeEnd
;<a4.l:Ԃ̐擪(擪̃ubÑwb_)
;<a5.l:Ԃ̖+1(16oCgACg)
	move.l	d2,d4
;<d4.l:JubNmۂvZX̃Ǘe[u
	bsr	psfree
;<d0.l:0(ɐ)
himemPsfreeEnd:
  debug '|himemPsfree out (err)=',1,d0
	movem.l	(sp)+,d4/a4-a5
	rts

;----------------------------------------------------------------
;_HIMEM	10	_HIMEMŃANZXł郁Ԃ̎擾
;>d0.l:Ԃ̐擪(擪̃ubÑwb_),-1=s
;>d1.l:Ԃ̖+1,-1=s
;*d0-d1
himemGetArea::
  debug '|himemGetArea in',0
	movem.l	a4-a5,-(sp)
	bsr	himemAreaSet
	bmi	himemGetAreaFailed
;<a4.l:Ԃ̐擪(擪̃ubÑwb_)
;<a5.l:Ԃ̖+1(16oCgACg)
	move.l	a4,d0
	move.l	a5,d1
;<d0.l:Ԃ̐擪(擪̃ubN)
;<d1.l:Ԃ̖+1
himemGetAreaEnd:
  debug '|himemGetArea out (top,btm)=',2,d0,d1
	movem.l	(sp)+,a4-a5
	rts

himemGetAreaFailed:
	moveq.l	#-1,d0
	moveq.l	#-1,d1
	bra	himemGetAreaEnd

;----------------------------------------------------------------
;----------------------------------------------------------------
;gԂANZXł邩ׂ
;	Vmpusw.r_HIMEMgp68000[hɐ؂ւȂ悤ɂȂĂ
;>d0.l:0=,-1=s
;>a4.l:Ԃ̐擪(擪̃ubÑwb_)
;>a5.l:Ԃ̖+1(16oCgACg)
himemAreaSet::
	tst.l	himemAreaSize
	beq	9f			;gԎgps
	movea.l	himemAreaStart,a4
	movea.l	himemAreaEnd,a5
	moveq.l	#0,d0
	rts

9:	moveq.l	#-1,d0
	rts

;----------------------------------------------------------------
;32bit~32bit64bitZ(Ȃ)
;<d0.l:搔
;<d1.l:搔
;>d0.l:()
;>d1.l:()
;*d0-d1
imul::
	movem.l	d2-d4,-(sp)
	move.l	d0,d3
	move.l	d1,d4
	swap.w	d3
	swap.w	d4
	move.w	d3,d2
	mulu.w	d1,d2
	mulu.w	d0,d1
	mulu.w	d4,d0
	mulu.w	d3,d4
	add.l	d2,d0
	clr.w	d3
	addx.w	d3,d3
	swap.w	d1
	add.w	d0,d1
	swap.w	d1
	move.w	d3,d0
	swap.w	d0
	addx.l	d4,d0
	movem.l	(sp)+,d2-d4
	rts
