/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.util.Arrays;
import xeij.ByteArray;
import xeij.HumanMedia;
import xeij.SPC;

public class SCMedia
extends HumanMedia {
    public int scmBytesShiftRecord;
    public int scmBytesPerRecord;
    public int scmDiskEndRecord;
    public int scmPartitionStartSector;
    public int scmDiskEndSector;

    public SCMedia(int n, int n2) {
        super(1024, -1, 2, 1, 512, 247, 247, -1, (long)n * (long)n2, 32768L, (long)n * (long)n2);
        this.scmBytesShiftRecord = Integer.numberOfTrailingZeros(n);
        this.scmBytesPerRecord = 1 << this.scmBytesShiftRecord;
        this.scmDiskEndRecord = n2;
        this.scmPartitionStartSector = (int)(this.humPartitionStartByte >> this.humBytesShiftSector);
        this.scmDiskEndSector = (int)(this.humDiskEndByte >> this.humBytesShiftSector);
    }

    public boolean scmMakeFormatData(byte[] byArray, boolean bl, boolean bl2, boolean bl3) {
        Arrays.fill(byArray, (byte)0);
        System.arraycopy(SPC.SPC_DISK_ID_1, 0, byArray, 0, SPC.SPC_DISK_ID_1.length);
        ByteArray.byaWw(byArray, 8, this.scmBytesPerRecord);
        ByteArray.byaWl(byArray, 10, this.scmDiskEndRecord);
        ByteArray.byaWw(byArray, 14, 256);
        System.arraycopy(SPC.SPC_DISK_ID_2, 0, byArray, 16, SPC.SPC_DISK_ID_2.length);
        System.arraycopy(SPC.SPC_DISK_IPL, 0, byArray, 1024, SPC.SPC_DISK_IPL.length);
        ByteArray.byaWl(byArray, 2048, 1479948363);
        if (bl) {
            ByteArray.byaWl(byArray, 2052, this.scmDiskEndSector);
        } else {
            ByteArray.byaWl(byArray, 2052, this.scmPartitionStartSector);
        }
        ByteArray.byaWl(byArray, 2056, this.scmDiskEndSector);
        ByteArray.byaWl(byArray, 2060, this.scmDiskEndSector);
        if (bl) {
            ByteArray.byaWl(byArray, 2064, 1215655265);
            ByteArray.byaWl(byArray, 2068, 1849047147);
            ByteArray.byaWl(byArray, 2072, this.scmPartitionStartSector);
            ByteArray.byaWl(byArray, 2076, this.humPartitionSectors);
        }
        System.arraycopy(SPC.SPC_DEVICE_DRIVER, 0, byArray, 3072, SPC.SPC_DEVICE_DRIVER.length);
        if (bl) {
            System.arraycopy(SPC.SPC_PARTITION_IPL, 0, byArray, (int)this.humPartitionStartByte, SPC.SPC_PARTITION_IPL.length);
            ByteArray.byaWw(byArray, (int)this.humPartitionStartByte + 18, this.humBytesPerSector);
            ByteArray.byaWb(byArray, (int)this.humPartitionStartByte + 20, this.humSectorsPerCluster);
            ByteArray.byaWb(byArray, (int)this.humPartitionStartByte + 21, this.humFatCount);
            ByteArray.byaWw(byArray, (int)this.humPartitionStartByte + 22, this.humReservedSectors);
            ByteArray.byaWw(byArray, (int)this.humPartitionStartByte + 24, this.humRootEntries);
            ByteArray.byaWw(byArray, (int)this.humPartitionStartByte + 26, 0);
            ByteArray.byaWb(byArray, (int)this.humPartitionStartByte + 28, this.humFatID);
            ByteArray.byaWb(byArray, (int)this.humPartitionStartByte + 29, this.humFatSectors);
            ByteArray.byaWl(byArray, (int)this.humPartitionStartByte + 30, this.humPartitionSectors);
            ByteArray.byaWl(byArray, (int)this.humPartitionStartByte + 34, this.scmPartitionStartSector);
            this.humWriteFatMarker(byArray);
            if (bl2) {
                if (!this.humCopyHumanSys(byArray)) {
                    return false;
                }
                if (bl3 && !this.humCopyCommandX(byArray)) {
                    return false;
                }
            }
        }
        return true;
    }
}

