/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.util.HashMap;
import xeij.MC68060;
import xeij.MainMemory;
import xeij.XEiJ;

public class LabeledAddress {
    public static final int[] LBL_VECTOR_SPECIAL = new int[]{2356, 2360, 2430, 2486, 2494, 2502, 2510, 3328, 3346, 3350};
    public static final int LBL_VECTOR_LENGTH = 768 + LBL_VECTOR_SPECIAL.length;
    public static final int LBL_MAX_DEVICES = 100;
    public static final int LBL_MAX_PROGRAMS = 100;
    public static final String[] LBL_VECTOR_NAME = "RESET_SSP,RESET_PC,BUS_ERROR,ADDRESS_ERROR,ILLEGAL_INSTRUCTION,DIVIDE_BY_ZERO,CHK_INSTRUCTION,TRAPV_INSTRUCTION,PRIVILEGE_VIOLATION,TRACE,LINE_1010_EMULATOR,LINE_1111_EMULATOR,EMULATOR_INTERRUPT,COPROCESSOR_PROTOCOL,FORMAT_ERROR,UNINITIALIZED_INTERRUPT,,,,,,,,,SPURIOUS_INTERRUPT,LEVEL_1_INTERRUPT,LEVEL_2_INTERRUPT,LEVEL_3_INTERRUPT,LEVEL_4_INTERRUPT,LEVEL_5_INTERRUPT,LEVEL_6_INTERRUPT,LEVEL_7_INTERRUPT,TRAP_0,TRAP_1,TRAP_2,TRAP_3,TRAP_4,TRAP_5,TRAP_6,TRAP_7,TRAP_8,TRAP_9,TRAP_10,TRAP_11,TRAP_12,TRAP_13,TRAP_14,TRAP_15,FP_BRANCH_SET_UNORDERED,FP_INEXACT_RESULT,FP_DIVIDE_BY_ZERO,FP_UNDERFLOW,FP_OPERAND_ERROR,FP_OVERFLOW,FP_SIGNALING_NAN,FP_UNSUPPORTED_DATA_TYPE,MMU_CONFIGULATION,MMU_ILLEGAL_OPERATION,MMU_ACCESS_LEVEL,,EFFECTIVE_ADDRESS,INTEGER_INSTRUCTION,,,MFP_ALARM,MFP_EXPWON,MFP_POWER,MFP_OPMIRQ,MFP_TIMERD,MFP_TIMERC,MFP_VDISP,,MFP_TIMERB,MFP_TRANSMIT_ERROR,MFP_TRANSMIT_EMPTY,MFP_RECEIVE_ERROR,MFP_RECEIVE_FULL,MFP_TIMERA,MFP_RINT,MFP_HSYNC,SCC_B_EMPTY,SCC_B_EMPTY,SCC_B_STATUS,SCC_B_STATUS,SCC_B_FULL,SCC_B_FULL,SCC_B_SPECIAL,SCC_B_SPECIAL,SCC_A_EMPTY,SCC_A_EMPTY,SCC_A_STATUS,SCC_A_STATUS,SCC_A_FULL,SCC_A_FULL,SCC_A_SPECIAL,SCC_A_SPECIAL,IOI_FDC,IOI_FDD,IOI_SASI,IOI_PRN,DMA_0_COMPLETE,DMA_0_ERROR,DMA_1_COMPLETE,DMA_1_ERROR,DMA_2_COMPLETE,DMA_2_ERROR,DMA_3_COMPLETE,DMA_3_ERROR,SPC_IN,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,AUX3_EMPTY,AUX3_EMPTY,AUX3_STATUS,AUX3_STATUS,AUX3_FULL,AUX3_FULL,AUX3_SPECIAL,AUX3_SPECIAL,AUX2_EMPTY,AUX2_EMPTY,AUX2_STATUS,AUX2_STATUS,AUX2_FULL,AUX2_FULL,AUX2_SPECIAL,AUX2_SPECIAL,AUX5_EMPTY,AUX5_EMPTY,AUX5_STATUS,AUX5_STATUS,AUX5_FULL,AUX5_FULL,AUX5_SPECIAL,AUX5_SPECIAL,AUX4_EMPTY,AUX4_EMPTY,AUX4_STATUS,AUX4_STATUS,AUX4_FULL,AUX4_FULL,AUX4_SPECIAL,AUX4_SPECIAL,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,IOCS_B_KEYINP,IOCS_B_KEYSNS,IOCS_B_SFTSNS,IOCS_KEY_INIT,IOCS_BITSNS,IOCS_SKEYSET,IOCS_LEDCTRL,IOCS_LEDSET,IOCS_KEYDLY,IOCS_KEYREP,IOCS_OPT2TVON,IOCS_OPT2TVOFF,IOCS_TVCTRL,IOCS_LEDMOD,IOCS_TGUSEMD,IOCS_DEFCHR,IOCS_CRTMOD,IOCS_CONTRAST,IOCS_HSVTORGB,IOCS_TPALET,IOCS_TPALET2,IOCS_TCOLOR,IOCS_FNTADR,IOCS_VRAMGET,IOCS_VRAMPUT,IOCS_FNTGET,IOCS_TEXTGET,IOCS_TEXTPUT,IOCS_CLIPPUT,IOCS_SCROLL,IOCS_B_CURON,IOCS_B_CUROFF,IOCS_B_PUTC,IOCS_B_PRINT,IOCS_B_COLOR,IOCS_B_LOCATE,IOCS_B_DOWN_S,IOCS_B_UP_S,IOCS_B_UP,IOCS_B_DOWN,IOCS_B_RIGHT,IOCS_B_LEFT,IOCS_B_CLR_ST,IOCS_B_ERA_ST,IOCS_B_INS,IOCS_B_DEL,IOCS_B_CONSOL,IOCS_B_PUTMES,IOCS_SET232C,IOCS_LOF232C,IOCS_INP232C,IOCS_ISNS232C,IOCS_OSNS232C,IOCS_OUT232C,IOCS_MS_VCS,IOCS_EXESC,IOCS_CHR_ADR,IOCS_SETBEEP,IOCS_SETPRN,IOCS_JOYGET,IOCS_INIT_PRN,IOCS_SNSPRN,IOCS_OUTLPT,IOCS_OUTPRN,IOCS_B_SEEK,IOCS_B_VERIFY,IOCS_B_READDI,IOCS_B_DSKINI,IOCS_B_DRVSNS,IOCS_B_WRITE,IOCS_B_READ,IOCS_B_RECALI,IOCS_B_ASSIGN,IOCS_B_WRITED,IOCS_B_READID,IOCS_B_BADFMT,IOCS_B_READDL,IOCS_B_FORMAT,IOCS_B_DRVCHK,IOCS_B_EJECT,IOCS_DATEBCD,IOCS_DATESET,IOCS_TIMEBCD,IOCS_TIMESET,IOCS_DATEGET,IOCS_DATEBIN,IOCS_TIMEGET,IOCS_TIMEBIN,IOCS_DATECNV,IOCS_TIMECNV,IOCS_DATEASC,IOCS_TIMEASC,IOCS_DAYASC,IOCS_ALARMMOD,IOCS_ALARMSET,IOCS_ALARMGET,IOCS_ADPCMOUT,IOCS_ADPCMINP,IOCS_ADPCMAOT,IOCS_ADPCMAIN,IOCS_ADPCMLOT,IOCS_ADPCMLIN,IOCS_ADPCMSNS,IOCS_ADPCMMOD,IOCS_OPMSET,IOCS_OPMSNS,IOCS_OPMINTST,IOCS_TIMERDST,IOCS_VDISPST,IOCS_CRTCRAS,IOCS_HSYNCST,IOCS_PRNINTST,IOCS_MS_INIT,IOCS_MS_CURON,IOCS_MS_CUROF,IOCS_MS_STAT,IOCS_MS_GETDT,IOCS_MS_CURGT,IOCS_MS_CURST,IOCS_MS_LIMIT,IOCS_MS_OFFTM,IOCS_MS_ONTM,IOCS_MS_PATST,IOCS_MS_SEL,IOCS_MS_SEL2,IOCS_SKEY_MOD,IOCS_DENSNS,IOCS_ONTIME,IOCS_B_INTVCS,IOCS_B_SUPER,IOCS_B_BPEEK,IOCS_B_WPEEK,IOCS_B_LPEEK,IOCS_B_MEMSTR,IOCS_B_BPOKE,IOCS_B_WPOKE,IOCS_B_LPOKE,IOCS_B_MEMSET,IOCS_DMAMOVE,IOCS_DMAMOV_A,IOCS_DMAMOV_L,IOCS_DMAMODE,IOCS_BOOTINF,IOCS_ROMVER,IOCS_G_CLR_ON,IOCS_G_MOD,IOCS_PRIORITY,IOCS_CRTMOD2,IOCS_GPALET,IOCS_PENCOLOR,IOCS_SET_PAGE,IOCS_GGET,IOCS_MASK_GPUT,IOCS_GPUT,IOCS_GPTRN,IOCS_BK_GPTRN,IOCS_X_GPTRN,,,,IOCS_SFTJIS,IOCS_JISSFT,IOCS_AKCONV,IOCS_RMACNV,IOCS_DAKJOB,IOCS_HANJOB,,,,,,,IOCS_SYS_STAT,IOCS_B_CONMOD,IOCS_OS_CURON,IOCS_OS_CUROF,IOCS_DRAWMODE,IOCS_APAGE,IOCS_VPAGE,IOCS_HOME,IOCS_WINDOW,IOCS_WIPE,IOCS_PSET,IOCS_POINT,IOCS_LINE,IOCS_BOX,IOCS_FILL,IOCS_CIRCLE,IOCS_PAINT,IOCS_SYMBOL,IOCS_GETGRM,IOCS_PUTGRM,IOCS_SP_INIT,IOCS_SP_ON,IOCS_SP_OFF,IOCS_SP_CGCLR,IOCS_SP_DEFCG,IOCS_SP_GTPCG,IOCS_SP_REGST,IOCS_SP_REGGT,IOCS_BGSCRLST,IOCS_BGSCRLGT,IOCS_BGCTRLST,IOCS_BGCTRLGT,IOCS_BGTEXTCL,IOCS_BGTEXTST,IOCS_BGTEXTGT,IOCS_SPALET,,,,IOCS_TXXLINE,IOCS_TXYLINE,IOCS_TXLINE,IOCS_TXBOX,IOCS_TXFILL,IOCS_TXREV,,,,,,,IOCS_TXRASCPY,,,,,,,,,,,,,,,,,IOCS_OPMDRV,IOCS_RSDRV,IOCS_A_JOY,IOCS_MUSICDRV,,IOCS_SCSIDRV,,,IOCS_TS16DRV,,,,,IOCS_ABORTRST,IOCS_IPLERR,IOCS_ABORTJOB,DOS_EXIT,DOS_GETCHAR,DOS_PUTCHAR,DOS_COMINP,DOS_COMOUT,DOS_PRNOUT,DOS_INPOUT,DOS_INKEY,DOS_GETC,DOS_PRINT,DOS_GETS,DOS_KEYSNS,DOS_KFLUSH,DOS_FFLUSH,DOS_CHGDRV,DOS_DRVCTRL,DOS_CONSNS,DOS_PRNSNS,DOS_CINSNS,DOS_COUTSNS,,,,DOS_FATCHK,DOS_HENDSP,DOS_CURDRV,DOS_GETSS,DOS_FGETC,DOS_FGETS,DOS_FPUTC,DOS_FPUTS,DOS_ALLCLOSE,DOS_SUPER,DOS_FNCKEY,DOS_KNJCTRL,DOS_CONCTRL,DOS_KEYCTRL,DOS_INTVCS,DOS_PSPSET,DOS_GETTIM2,DOS_SETTIM2,DOS_NAMESTS,DOS_GETDATE,DOS_SETDATE,DOS_GETTIME,DOS_SETTIME,DOS_VERIFY,DOS_DUP0,DOS_VERNUM,DOS_KEEPPR,DOS_GETDPB,DOS_BREAKCK,DOS_DRVXCHG,DOS_INTVCG,DOS_DSKFRE,DOS_NAMECK,,DOS_MKDIR,DOS_RMDIR,DOS_CHDIR,DOS_CREATE,DOS_OPEN,DOS_CLOSE,DOS_READ,DOS_WRITE,DOS_DELETE,DOS_SEEK,DOS_CHMOD,DOS_IOCTRL,DOS_DUP,DOS_DUP2,DOS_CURDIR,DOS_MALLOC,DOS_MFREE,DOS_SETBLOCK,DOS_EXEC,DOS_EXIT2,DOS_WAIT,DOS_FILES,DOS_NFILES,DOS_V2_SETPDB,DOS_V2_GETPDB,DOS_V2_SETENV,DOS_V2_GETENV,DOS_V2_VERIFYG,DOS_V2_COMMON,DOS_V2_RENAME,DOS_V2_FILEDATE,DOS_V2_MALLOC2,,DOS_V2_MAKETMP,DOS_V2_NEWFILE,DOS_V2_LOCK,,,DOS_V2_ASSIGN,DOS_V2_MALLOC3,DOS_V2_SETBLOCK2,DOS_V2_MALLOC4,DOS_V2_S_MALLOC2,,,,,,,,,,,,,,,,,,,,,,,DOS_V2_FFLUSH_SET,DOS_V2_OS_PATCH,DOS_V2_GETFCB,DOS_V2_S_MALLOC,DOS_V2_S_MFREE,DOS_V2_S_PROCESS,DOS_SETPDB,DOS_GETPDB,DOS_SETENV,DOS_GETENV,DOS_VERIFYG,DOS_COMMON,DOS_RENAME,DOS_FILEDATE,DOS_MALLOC2,,DOS_MAKETMP,DOS_NEWFILE,DOS_LOCK,,,DOS_ASSIGN,DOS_MALLOC3,DOS_SETBLOCK2,DOS_MALLOC4,DOS_S_MALLOC2,,,,,,,,,,,,,,,,,,,,,,,DOS_FFLUSH_SET,DOS_OS_PATCH,DOS_GETFCB,DOS_S_MALLOC,DOS_S_MFREE,DOS_S_PROCESS,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,,DOS_EXITVC,DOS_CTRLVC,DOS_ERRJVC,DOS_DISKRED,DOS_DISKWRT,DOS_INDOSFLG,DOS_SUPER_JSR,DOS_BUS_ERR,DOS_OPEN_PR,DOS_KILL_PR,DOS_GET_PR,DOS_SUSPEND_PR,DOS_SLEEP_PR,DOS_SEND_PR,DOS_TIME_PR,DOS_CHANGE_PR,BIOS_SOFTKEY_HANDLE,BIOS_MOUSE_HANDLE,BIOS_ESCAPE_EXTENSION,BIOS_TC_MOUSE_HANDLE,BIOS_TC_CURSOR_HANDLE,BIOS_TC_MOTOR_HANDLE,BIOS_TC_MINUTE_HANDLE,BIOS_FDD_EXTENSION,BIOS_BEEP_EXTENSION,BIOS_CSI_EXTENSION".split(",", LBL_VECTOR_LENGTH);
    public static final int[] lblVectorTable = new int[LBL_VECTOR_LENGTH];
    public static final String[] lblProgramName = new String[200];
    public static final int[] lblProgramHead = new int[200];
    public static final int[] lblProgramTail = new int[200];
    public static int lblProgramCount;
    public static int lblProgramAge;
    public static int lblLastGetAge;
    public static int lblLastGetHead;
    public static int lblLastGetTail;
    public static int lblLastGetIndex;
    public static boolean lblLastGetInside;

    public static void lblClear() {
        lblProgramCount = 0;
    }

    public static void lblUpdateVector() {
        int n;
        int n2 = 0;
        for (n = 0; n <= 255; ++n) {
            LabeledAddress.lblVectorTable[n2++] = MC68060.mmuPeekLongData(XEiJ.mpuVBR + (n << 2), 1);
        }
        for (n = 256; n <= 511; ++n) {
            LabeledAddress.lblVectorTable[n2++] = MC68060.mmuPeekLongData(n << 2, 1);
        }
        for (n = 65280; n <= 65535; ++n) {
            LabeledAddress.lblVectorTable[n2++] = MC68060.mmuPeekLongData(6144 + ((n & 0xFF) << 2), 1);
        }
        for (int n3 : LBL_VECTOR_SPECIAL) {
            LabeledAddress.lblVectorTable[n2++] = MC68060.mmuPeekLongData(n3, 1);
        }
    }

    public static void lblUpdateProgram() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int n6 = MainMemory.mmrHumanTop();
        int n7 = MainMemory.mmrHumanBtm();
        int n8 = MainMemory.mmrHumanPmm();
        int n9 = MainMemory.mmrHumanNul();
        if (n6 >= 0 && n7 >= 0 && n8 >= 0 && n9 >= 0) {
            n4 = MC68060.mmuPeekLongData(n6 + 8, 1);
            n3 = n9;
            for (n2 = 0; n3 < n4 && n2 < 100; ++n2) {
                int n10;
                n = MC68060.mmuPeekLongData(n3, 1);
                if (n < 0 || n4 < n) {
                    n = n4;
                }
                for (n10 = 8; n10 > 0 && MC68060.mmuPeekByteSignData(n3 + 13 + n10, 1) == 32; --n10) {
                }
                LabeledAddress.lblProgramName[n5] = MC68060.mmuPeekStringL(new StringBuilder(), n3 + 14, n10, 1).toString();
                LabeledAddress.lblProgramHead[n5] = n3;
                LabeledAddress.lblProgramTail[n5] = n;
                ++n5;
                n3 = n;
            }
            n3 = n6;
            while (0 < n3 && n3 < n7) {
                if ((MC68060.mmuPeekByteSignData(n3 + 4, 1) & 0xE0) == 224) {
                    LabeledAddress.lblProgramName[n5] = MC68060.mmuPeekStringL(new StringBuilder(), n3 + 196, MC68060.mmuPeekStrlen(n3 + 196, 24, 1), 1).toString();
                    LabeledAddress.lblProgramHead[n5] = n3 == n6 ? 0 : n3 + 256;
                    LabeledAddress.lblProgramTail[n5] = MC68060.mmuPeekLongData(n3 + 8, 1);
                    ++n5;
                }
                n3 = MC68060.mmuPeekLongData(n3 + 12, 1);
            }
            n3 = n8;
            while (0 < n3 && n3 < n7) {
                LabeledAddress.lblProgramName[n5] = MC68060.mmuPeekStringL(new StringBuilder(), n3 + 196, MC68060.mmuPeekStrlen(n3 + 196, 24, 1), 1).toString();
                LabeledAddress.lblProgramHead[n5] = n3 == n6 ? 0 : n3 + 256;
                LabeledAddress.lblProgramTail[n5] = MC68060.mmuPeekLongData(n3 + 8, 1);
                ++n5;
                n3 = MC68060.mmuPeekLongData(n3 + 4, 1);
            }
        }
        lblProgramCount = n5;
        n4 = 0;
        while (n4 + 1 < n5) {
            n3 = lblProgramHead[n4];
            n2 = n4;
            for (n = n4 + 1; n < n5; ++n) {
                int n11 = lblProgramHead[n];
                if (n11 >= n3) continue;
                n3 = n11;
                n2 = n;
            }
            if (n4 < n2) {
                n = lblProgramHead[n4];
                LabeledAddress.lblProgramHead[n4] = lblProgramHead[n2];
                LabeledAddress.lblProgramHead[n2] = n;
                n = lblProgramTail[n4];
                LabeledAddress.lblProgramTail[n4] = lblProgramTail[n2];
                LabeledAddress.lblProgramTail[n2] = n;
                String string = lblProgramName[n4];
                LabeledAddress.lblProgramName[n4] = lblProgramName[n2];
                LabeledAddress.lblProgramName[n2] = string;
            }
            ++n4;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (n3 = 0; n3 < n5; ++n3) {
            String string = lblProgramName[n3];
            if (hashMap.containsKey(string)) {
                hashMap.put(string, (Integer)hashMap.get(string) + 1);
                continue;
            }
            hashMap.put(string, 1);
        }
        for (n3 = 0; n3 < n5; ++n3) {
            String string = lblProgramName[n3];
            if ((Integer)hashMap.get(string) != 1) continue;
            hashMap.remove(string);
        }
        for (n3 = n5 - 1; 0 <= n3; --n3) {
            String string = lblProgramName[n3];
            if (!hashMap.containsKey(string)) continue;
            n = (Integer)hashMap.get(string);
            int n12 = n3;
            lblProgramName[n12] = lblProgramName[n12] + "#" + n;
            hashMap.put(string, n - 1);
        }
        ++lblProgramAge;
    }

    public static int lblGetIndex(int n) {
        if (lblLastGetAge == lblProgramAge && Integer.compareUnsigned(lblLastGetHead, n) <= 0 && Integer.compareUnsigned(n, lblLastGetTail) < 0) {
            return lblLastGetIndex;
        }
        lblLastGetAge = lblProgramAge;
        lblLastGetInside = false;
        lblLastGetIndex = -1;
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < lblProgramCount; ++i) {
            int n4 = lblProgramTail[i];
            int n5 = lblProgramHead[i];
            if (Integer.compareUnsigned(n4, n5) <= 0) continue;
            if (Integer.compareUnsigned(n5, n) <= 0 && Integer.compareUnsigned(n, n4) < 0) {
                lblLastGetInside = true;
                lblLastGetIndex = i;
                lblLastGetHead = n5;
                lblLastGetTail = n4;
                break;
            }
            if (Integer.compareUnsigned(n2, n4) < 0 && Integer.compareUnsigned(n4, n) < 0) {
                n2 = n4;
                continue;
            }
            if (Integer.compareUnsigned(n, n5) >= 0 || Integer.compareUnsigned(n5, n3) >= 0) continue;
            n3 = n5;
        }
        if (!lblLastGetInside) {
            lblLastGetHead = n2;
            lblLastGetTail = n3;
        }
        return lblLastGetIndex;
    }

    public static StringBuilder lblSearch(StringBuilder stringBuilder, int n) {
        int n2;
        LabeledAddress.lblUpdateVector();
        if (lblProgramCount == 0) {
            LabeledAddress.lblUpdateProgram();
        }
        for (n2 = 0; n2 < LBL_VECTOR_LENGTH; ++n2) {
            if (n != lblVectorTable[n2]) continue;
            String string = LBL_VECTOR_NAME[n2];
            if (string.length() > 0) {
                stringBuilder.append('.').append(string);
                continue;
            }
            if (n2 < 256) {
                XEiJ.fmtHex4(stringBuilder.append(".$"), n2);
                continue;
            }
            if (n2 < 512) {
                XEiJ.fmtHex2(stringBuilder.append(".IOCS_$"), n2 - 256);
                continue;
            }
            if (n2 < 768) {
                XEiJ.fmtHex4(stringBuilder.append(".DOS_$"), 64768 + n2);
                continue;
            }
            XEiJ.fmtHex4(stringBuilder.append(".$"), LBL_VECTOR_SPECIAL[n2 - 768]);
        }
        for (n2 = 0; n2 < lblProgramCount; ++n2) {
            if (lblProgramHead[n2] > n || n >= lblProgramTail[n2]) continue;
            stringBuilder.append(" @ ").append(lblProgramName[n2]);
            if (lblProgramHead[n2] != 0) {
                XEiJ.fmtHex8(stringBuilder.append(" $"), n - lblProgramHead[n2]);
            }
            return stringBuilder;
        }
        return stringBuilder;
    }

    public static String lblDump() {
        int n;
        int n2;
        int n3;
        int n4;
        LabeledAddress.lblUpdateVector();
        if (lblProgramCount == 0) {
            LabeledAddress.lblUpdateProgram();
        }
        int[] nArray = new int[LBL_VECTOR_LENGTH];
        System.arraycopy(lblVectorTable, 0, nArray, 0, LBL_VECTOR_LENGTH);
        int[] nArray2 = new int[LBL_VECTOR_LENGTH];
        for (n4 = 0; n4 < LBL_VECTOR_LENGTH; ++n4) {
            nArray2[n4] = n4;
        }
        for (n4 = 0; n4 <= LBL_VECTOR_LENGTH - 2; ++n4) {
            int n5 = n4;
            for (n3 = n4 + 1; n3 <= LBL_VECTOR_LENGTH - 1; ++n3) {
                if (nArray[n3] >= nArray[n5]) continue;
                n5 = n3;
            }
            if (n4 >= n5) continue;
            n3 = nArray[n5];
            n2 = nArray2[n5];
            for (n = n5 - 1; n4 <= n; --n) {
                nArray[n + 1] = nArray[n];
                nArray2[n + 1] = nArray2[n];
            }
            nArray[n4] = n3;
            nArray2[n4] = n2;
        }
        n4 = MC68060.mmuPeekLongData(7124, 1);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  head     tail         name\n-------- -------- ----------------\n     handle  address   offset     label\n    -------- -------- -------- ------------\n");
        n3 = -2;
        for (n2 = 0; n2 < LBL_VECTOR_LENGTH; ++n2) {
            n = nArray2[n2];
            int n6 = n < 512 ? n << 2 : (n < 768 ? 6144 + (n - 512 << 2) : LBL_VECTOR_SPECIAL[n - 768]);
            int n7 = lblVectorTable[n];
            String string = LBL_VECTOR_NAME[n];
            int n8 = -1;
            int n9 = Integer.MAX_VALUE;
            for (int i = 0; i < lblProgramCount; ++i) {
                int n10 = lblProgramHead[i];
                int n11 = lblProgramTail[i];
                int n12 = n11 - n10;
                if (n10 > n7 || n7 >= n11 || n12 >= n9 || n10 < 0xF00000 && 0xFFFFFF < n11) continue;
                n8 = i;
                n9 = n12;
                break;
            }
            if (n3 != n8) {
                if (0 <= n8) {
                    XEiJ.fmtHex8(stringBuilder, lblProgramHead[n8]);
                    stringBuilder.append(' ');
                    XEiJ.fmtHex8(stringBuilder, lblProgramTail[n8]);
                    stringBuilder.append(' ');
                    stringBuilder.append(lblProgramName[n8]);
                    stringBuilder.append('\n');
                }
                n3 = n8;
            }
            if (0 > n8 || n7 == 0 || n7 == n4) continue;
            stringBuilder.append("    ");
            XEiJ.fmtHex8(stringBuilder, n6);
            stringBuilder.append(' ');
            XEiJ.fmtHex8(stringBuilder, n7);
            stringBuilder.append(' ');
            XEiJ.fmtHex8(stringBuilder, n7 - lblProgramHead[n8]);
            stringBuilder.append(' ');
            stringBuilder.append(LBL_VECTOR_NAME[n]);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    static {
        lblLastGetAge = -1;
        lblLastGetHead = 0;
        lblLastGetTail = 0;
        lblLastGetIndex = -1;
        lblLastGetInside = false;
    }
}

