/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.Arrays;
import javax.swing.Box;
import xeij.ComponentFactory;
import xeij.FontPage;
import xeij.LnF;
import xeij.Model;
import xeij.XEiJ;

public class Indicator {
    public static final int IND_MPU_X = 0;
    public static final int IND_CLOCK_X = 10;
    public static final int IND_RATIO_X = 19;
    public static final int IND_COLS = 25;
    public static final int IND_FONT_WIDTH = 6;
    public static final int IND_FONT_HEIGHT = 8;
    public static final int IND_PADDING_LEFT = 6;
    public static final int IND_PADDING_RIGHT = 6;
    public static final int IND_PADDING_TOP = 3;
    public static final int IND_PADDING_BOTTOM = 2;
    public static final int IND_WIDTH = 162;
    public static final int IND_HEIGHT = 13;
    public static int indBackGround;
    public static int indColor00;
    public static int indColor20;
    public static int indColor40;
    public static int indColor60;
    public static int indColor80;
    public static int indLastMPU;
    public static BufferedImage indImage;
    public static int[] indBitmap;
    public static Box indBox;
    public static final char[] IND_ASCII_3X5;

    public static void indInit() {
        indBackGround = LnF.lnfRGB[0];
        indColor00 = LnF.lnfRGB[14];
        indColor20 = -16711681;
        indColor40 = -16711936;
        indColor60 = -256;
        indColor80 = -65536;
        indLastMPU = 0;
        indImage = new BufferedImage(162, 13, 1);
        indBitmap = ((DataBufferInt)indImage.getRaster().getDataBuffer()).getData();
        Arrays.fill(indBitmap, indBackGround);
        indBox = ComponentFactory.setFixedSize(new Box(2){

            @Override
            public void paint(Graphics graphics) {
                graphics.drawImage(indImage, 0, 0, null);
            }

            @Override
            protected void paintComponent(Graphics graphics) {
            }

            @Override
            protected void paintBorder(Graphics graphics) {
            }

            @Override
            protected void paintChildren(Graphics graphics) {
            }

            @Override
            public void update(Graphics graphics) {
            }
        }, 162, 13);
    }

    public static void indUpdate(double d) {
        int n;
        if (indLastMPU != XEiJ.currentMPU) {
            indLastMPU = XEiJ.currentMPU;
            n = indColor00;
            String string = Model.mpuNameOf(XEiJ.currentMPU);
            int n2 = string.length();
            for (int i = 0; i < 9; ++i) {
                Indicator.indPutChar(0 + i, i < n2 ? (int)string.charAt(i) : 32, n);
            }
        }
        n = indColor00;
        int n3 = XEiJ.FMT_BCD4[Math.max(0, Math.min(9999, (int)(10.0 * XEiJ.mpuCurrentMHz + 0.5)))];
        Indicator.indPutChar(10, n3 < 4096 ? 32 : (n3 >> 12) + 48, n);
        Indicator.indPutChar(11, n3 < 256 ? 32 : (n3 >> 8 & 0xF) + 48, n);
        Indicator.indPutChar(12, (n3 >> 4 & 0xF) + 48, n);
        Indicator.indPutChar(13, 46, n);
        Indicator.indPutChar(14, (n3 & 0xF) + 48, n);
        Indicator.indPutChar(15, 77, n);
        Indicator.indPutChar(16, 72, n);
        Indicator.indPutChar(17, 122, n);
        n = XEiJ.FMT_BCD4[Math.max(0, Math.min(9999, (int)(10.0 * d + 0.5)))];
        n3 = n < 512 ? indColor00 : (n < 1024 ? indColor20 : (n < 1536 ? indColor40 : (n < 2048 ? indColor60 : indColor80)));
        Indicator.indPutChar(19, n < 4096 ? 32 : (n >> 12) + 48, n3);
        Indicator.indPutChar(20, n < 256 ? 32 : (n >> 8 & 0xF) + 48, n3);
        Indicator.indPutChar(21, (n >> 4 & 0xF) + 48, n3);
        Indicator.indPutChar(22, 46, n3);
        Indicator.indPutChar(23, (n & 0xF) + 48, n3);
        Indicator.indPutChar(24, 37, n3);
        indBox.repaint();
    }

    public static void indPutChar(int n, int n2, int n3) {
        int n4 = 8 * n2;
        int n5 = 6 + 6 * n + 486;
        for (int i = 0; i < 8; ++i) {
            int n6 = FontPage.Lcd.LCD6X8_FONT[n4] << 24;
            for (int j = 0; j < 6; ++j) {
                Indicator.indBitmap[n5 + j] = n6 < 0 ? n3 : indBackGround;
                n6 <<= 1;
            }
            ++n4;
            n5 += 162;
        }
    }

    static {
        IND_ASCII_3X5 = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u2482\u5a00\u5f7d\u3c9e\u5c9d\u6cae\u2400\u1491\u4494\u0aa8\u05d0\u0012\u01c0\u0002\u02a0\u7b6f\u2492\u73e7\u73cf\u5bc9\u79cf\u79ef\u7249\u7bef\u7bcf\u0410\u0412\u1511\u0e38\u4454\u6282\u2be3\u2bed\u6bae\u3923\u6b6e\u79e7\u79e4\u396b\u5bed\u7497\u124e\u5bad\u4927\u5fed\u6b6d\u2b6a\u6ba4\u2b7b\u6bad\u388e\u7492\u5b6f\u5b6a\u5bfd\u5aad\u5a92\u72a7\u3493\u0888\u6496\u2a00\u0007\u2200\u076b\u4d6e\u0723\u176b\u0773\u3e92\u3bce\u4d6d\u2092\u104e\u4bb5\u6492\u0dfd\u0d6d\u056a\u0d74\u0759\u0724\u068e\u2e91\u0b6b\u0b6a\u0bfb\u0a95\u0b54\u0e57\u1591\u2412\u44d4\u7000".toCharArray();
    }
}

