/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.filechooser.FileFilter;
import xeij.AbstractOpenDialog;
import xeij.AbstractUnit;
import xeij.ByteArray;
import xeij.CharacterCode;
import xeij.ComponentFactory;
import xeij.DnT;
import xeij.JFileChooser2;
import xeij.M68kException;
import xeij.MC68060;
import xeij.MainMemory;
import xeij.Multilingual;
import xeij.RP5C15;
import xeij.Settings;
import xeij.XEiJ;

public class HFS {
    public static final boolean HFS_DEBUG_TRACE = false;
    public static final boolean HFS_DEBUG_FILE_INFO = false;
    public static final boolean HFS_REPORT_INCOMPATIBLE_COMMAND = false;
    public static final boolean HFS_COMMAND_TRACE = false;
    public static boolean hfsCommandTraceOn;
    public static final boolean HFS_USE_THREAD = true;
    public static final long HFS_THREAD_DELAY = 0L;
    public static Timer hfsTimer;
    public static final int HFS_STATE_IDLE = 0;
    public static final int HFS_STATE_X68K = 1;
    public static final int HFS_STATE_HOST = 2;
    public static final int HFS_STATE_BUSY = 3;
    public static final int HFS_STATE_DONE = 4;
    public static int hfsState;
    public static final boolean HFS_BUFFER_TRACE = false;
    public static final int HFS_BUFFER_SIZE = 65536;
    public static final int HFS_BUFFER_STEP = 128;
    public static final int HFS_ADDRESS = 15331360;
    public static final int HFS_BOOT_HANDLE = 15331360;
    public static final int HFS_INSTALL_HANDLE = 15331364;
    public static final int HFS_INSTALL_PARAMETER = 15331368;
    public static final int HFS_HUMAN68K_MAGIC = 15331372;
    public static final int HFS_BOOT_ROUTINE = 15331380;
    public static final int HFS_INSTALL_ROUTINE = 15331384;
    public static final int HFS_MAGIC = 15331388;
    public static final int HFS_ROM_SIZE = 32;
    public static final int HFS_NEXT_DEVICE = 0;
    public static final int HFS_DEVICE_TYPE = 4;
    public static final int HFS_STRATEGY_HANDLE = 6;
    public static final int HFS_INTERRUPT_HANDLE = 10;
    public static final int HFS_DEVICE_NAME = 14;
    public static final int HFS_DRIVE_NUMBER = 22;
    public static final int HFS_STRATEGY_ROUTINE = 24;
    public static final int HFS_INTERRUPT_ROUTINE = 28;
    public static final int HFS_DEVICE_SIZE = 32;
    public static final int HFS_MIN_UNITS = 1;
    public static final int HFS_MAX_UNITS = 16;
    public static final String HFS_DUMMY_UNIT_NAME = "*HFS*";
    public static final HFUnit[] hfsUnitArray;
    public static int hfsBootUnit;
    public static final int[] hfsDeviceUnitArray;
    public static int hfsDeviceUnitCount;
    public static JMenu hfsMenu;
    public static FileFilter hfsFileFilter;
    public static OpenDialog hfsOpenDialog;
    public static int hfsOpenUnit;
    public static ArrayList<File[]> hfsOpenHistory;
    public static int hfsDeviceHeader;
    public static int hfsRequestHeader;
    public static int hfsRequest1Number;
    public static int hfsRequest2Command;
    public static int hfsRequest13Mode;
    public static int hfsRequest14Namests;
    public static int hfsRequest18Param;
    public static int hfsRequest22Fcb;
    public static int hfsRequest3Error;
    public static int hfsRequest18Result;
    public static HFUnit hfsRequestUnit;
    public static final boolean HFS_USE_TWENTY_ONE = false;
    public static final int HFS_TW_VERBOSE_MODE = Integer.MIN_VALUE;
    public static final int HFS_TW_CASE_SENSITIVE = 0x40000000;
    public static final int HFS_TW_SPECIAL_CHARACTER = 0x20000000;
    public static final int HFS_TW_MULTI_PERIOD = 0x10000000;
    public static final int HFS_TW_NOT_TWENTY_ONE = 0x8000000;
    public static final int HFS_TW_DISABLE_PRINTER_ECHO = 0x4000000;
    public static final int HFS_TW_USE_SYSROOT = 0x2000000;
    public static final int HFS_TW_WARN_CASE_MISMATCH = 0x1000000;
    public static final int HFS_TW_USE_STRONG_SYSROOT = 0x800000;
    public static int hfsTwentyOneOption;
    public static final boolean HFS_UTF8_WARNING = true;
    public static boolean hfsUTF8WarningOn;
    public static HashSet<String> hfsUTF8WarningSet;

    public static void hfsInit() {
        HFUnit hFUnit;
        int n;
        hfsTimer = new Timer();
        hfsFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getPath();
                return !HFS.hfsIsInserted(string);
            }

            @Override
            public String getDescription() {
                return Multilingual.mlnJapanese ? "\u30eb\u30fc\u30c8\u306b\u306a\u308b\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u307e\u305f\u306f\u305d\u3053\u306b\u3042\u308b\u304b\u3082\u77e5\u308c\u306a\u3044\u30d5\u30a1\u30a4\u30eb" : "Directory to be the root or files that may be found there";
            }
        };
        hfsOpenDialog = null;
        hfsOpenUnit = 0;
        hfsOpenHistory = new ArrayList();
        for (n = 99; 0 <= n; --n) {
            HFS.hfsAddHistory(JFileChooser2.pathsToFiles(Settings.sgsGetString("hfhistory" + n)));
        }
        hfsBootUnit = 0;
        hfsDeviceUnitCount = 0;
        for (n = 0; n < 16; ++n) {
            hFUnit = HFS.hfsUnitArray[n] = new HFUnit(n);
            if (n >= 1) continue;
            hFUnit.connect(false);
        }
        for (n = 0; n < 16; ++n) {
            boolean bl;
            hFUnit = hfsUnitArray[n];
            String string = Settings.sgsGetString("hf" + n);
            boolean bl2 = false;
            if (string.toUpperCase().endsWith(":R")) {
                string = string.substring(0, string.length() - 2);
                bl2 = true;
            }
            boolean bl3 = bl = !new File(string).canWrite();
            if (string.length() == 0) continue;
            hFUnit.connect(true);
            if (!hFUnit.insert(string, bl2 || bl)) continue;
            HFS.hfsAddHistory(new File(string).getAbsoluteFile());
        }
        hfsUTF8WarningOn = Settings.sgsGetOnOff("utf8warning");
        hfsUTF8WarningSet = new HashSet();
        hfsMenu = ComponentFactory.createMenu("HFS", new JComponent[0]);
        ComponentFactory.addComponents(hfsMenu, ComponentFactory.createHorizontalBox(Multilingual.mlnText(ComponentFactory.createLabel("Host file system"), "ja", "\u30db\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u30b7\u30b9\u30c6\u30e0")), ComponentFactory.createHorizontalSeparator());
        for (HFUnit hFUnit2 : hfsUnitArray) {
            hfsMenu.add(hFUnit2.getMenuBox());
        }
        ComponentFactory.addComponents(hfsMenu, ComponentFactory.createHorizontalSeparator(), Multilingual.mlnText(ComponentFactory.createCheckBoxMenuItem(hfsCommandTraceOn, "UTF-8 warning", new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                hfsUTF8WarningOn = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
            }
        }), "ja", "UTF-8 \u8b66\u544a"));
        MainMemory.mmrWl(15331360, 15331380);
        MainMemory.mmrWl(15331364, 15331384);
        MainMemory.mmrWl(15331368, 0);
        MainMemory.mmrWl(15331372, 1215655265);
        MainMemory.mmrWl(15331376, 1849047147);
        MainMemory.mmrWl(15331380, 1308642933);
        MainMemory.mmrWl(15331384, 1308708469);
        MainMemory.mmrWl(15331388, 1246250579);
        hfsState = 0;
    }

    public static void hfsTini() {
        if (hfsTimer != null) {
            hfsTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    for (HFUnit hFUnit : hfsUnitArray) {
                        hFUnit.hfuTini();
                    }
                    hfsTimer.cancel();
                }
            }, 0L);
        }
        if (hfsOpenDialog != null) {
            int n;
            Settings.sgsPutOnOff("hfreadonly", hfsOpenDialog.getReadOnly());
            Settings.sgsPutOnOff("hfappreboot", hfsOpenDialog.getReboot());
            ArrayList<String> arrayList = hfsOpenDialog.getHistory();
            int n2 = arrayList.size();
            for (n = 0; n < n2; ++n) {
                Settings.sgsPutString("hfhistory" + n, arrayList.get(n));
            }
            for (n = n2; n < 16; ++n) {
                Settings.sgsPutString("hfhistory" + n, "");
            }
        }
        for (int i = 0; i < 16; ++i) {
            HFUnit hFUnit = hfsUnitArray[i];
            Settings.sgsPutString("hf" + i, (String)(hFUnit.abuConnected && hFUnit.abuInserted ? (hFUnit.abuWriteProtected ? hFUnit.abuPath + ":R" : hFUnit.abuPath) : ""));
        }
        Settings.sgsPutOnOff("utf8warning", hfsUTF8WarningOn);
    }

    public static boolean hfsIsInserted(String string) {
        for (HFUnit hFUnit : hfsUnitArray) {
            if (hFUnit == null || !hFUnit.abuConnected || !hFUnit.abuInserted || !hFUnit.abuPath.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static void hfsReset() {
        for (HFUnit hFUnit : hfsUnitArray) {
            hFUnit.hfuTini();
        }
    }

    public static boolean hfsIPLBoot() {
        return hfsUnitArray[hfsBootUnit].hfuIPLBoot();
    }

    public static void hfsInstall() throws M68kException {
        if (XEiJ.regRn[2] != 0) {
            XEiJ.regRn[2] = -1;
        } else {
            int n;
            XEiJ.regRn[2] = 1;
            hfsDeviceHeader = n = XEiJ.regRn[9];
            MC68060.mmuWriteLongData(n + 0, -1, XEiJ.regSRS);
            MC68060.mmuWriteWordData(n + 4, 8192, XEiJ.regSRS);
            MC68060.mmuWriteLongData(n + 6, n + 24, XEiJ.regSRS);
            MC68060.mmuWriteLongData(n + 10, n + 28, XEiJ.regSRS);
            MC68060.mmuWriteLongData(n + 14, 22562121, XEiJ.regSRS);
            MC68060.mmuWriteLongData(n + 14 + 4, 1246250579, XEiJ.regSRS);
            MC68060.mmuWriteLongData(n + 24, 1308774005, XEiJ.regSRS);
            MC68060.mmuWriteLongData(n + 28, 1308839541, XEiJ.regSRS);
        }
    }

    public static void hfsStrategy() throws M68kException {
        hfsRequestHeader = XEiJ.regRn[13];
    }

    public static boolean hfsInterrupt() throws M68kException {
        int n = hfsRequestHeader;
        if (hfsState == 0) {
            hfsRequest1Number = MC68060.mmuReadByteZeroData(n + 1, XEiJ.regSRS);
            hfsRequest2Command = MC68060.mmuReadByteZeroData(n + 2, XEiJ.regSRS) & 0x7F;
            hfsRequest13Mode = MC68060.mmuReadByteZeroData(n + 13, XEiJ.regSRS);
            hfsRequest14Namests = MC68060.mmuReadLongData(n + 14, XEiJ.regSRS);
            hfsRequest18Param = MC68060.mmuReadLongData(n + 18, XEiJ.regSRS);
            hfsRequest22Fcb = MC68060.mmuReadLongData(n + 22, XEiJ.regSRS);
            hfsRequest3Error = 0;
            hfsRequest18Result = 0;
            if (hfsRequest2Command == 64) {
                MC68060.mmuWriteByteData(n + 2, 0, XEiJ.regSRS);
                hfsDeviceUnitCount = 0;
                int n2 = -1;
                for (int i = 0; i < 16; ++i) {
                    if (!hfsUnitArray[i].isConnected()) continue;
                    if (i == hfsBootUnit) {
                        n2 = hfsDeviceUnitCount;
                    }
                    HFS.hfsDeviceUnitArray[HFS.hfsDeviceUnitCount++] = i;
                }
                if (hfsDeviceUnitCount > 0 && n2 >= 0) {
                    MC68060.mmuWriteByteData(n + 13, hfsDeviceUnitCount, XEiJ.regSRS);
                    MC68060.mmuWriteLongData(n + 14, hfsDeviceHeader + 34, XEiJ.regSRS);
                    MC68060.mmuWriteByteData(n + 22, 1 + n2, XEiJ.regSRS);
                } else {
                    hfsRequest3Error = 4097;
                    hfsRequest18Result = -1;
                }
                hfsState = 4;
            } else if (hfsRequest1Number < hfsDeviceUnitCount) {
                hfsRequestUnit = hfsUnitArray[hfsDeviceUnitArray[hfsRequest1Number]];
                hfsState = 1;
                hfsRequestUnit.hfuCall();
            } else {
                hfsRequest3Error = 4097;
                hfsRequest18Result = -1;
                hfsState = 4;
            }
        }
        while (hfsState != 4) {
            if (hfsState == 1) {
                hfsRequestUnit.hfuCallX68k();
                if (hfsState == 1) {
                    return true;
                }
            }
            if (hfsState == 2) {
                hfsState = 3;
                hfsTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        hfsRequestUnit.hfuCallHost();
                    }
                }, 0L);
            }
            if (hfsState != 3) continue;
            return true;
        }
        MC68060.mmuWriteByteData(n + 3, hfsRequest3Error, XEiJ.regSRS);
        MC68060.mmuWriteByteData(n + 4, hfsRequest3Error >> 8, XEiJ.regSRS);
        MC68060.mmuWriteLongData(n + 18, hfsRequest18Result, XEiJ.regSRS);
        hfsState = 0;
        return false;
    }

    public static void hfsOpenFiles(File[] fileArray, boolean bl) {
        boolean bl2 = true;
        int n = hfsOpenUnit;
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file;
            if (16 <= n) {
                bl2 = false;
                break;
            }
            HFUnit hFUnit = hfsUnitArray[n];
            if (!hFUnit.abuConnected) {
                ++n;
                continue;
            }
            if (!((file = fileArray[n2++]).isDirectory() || (file = file.getParentFile()) != null && file.isDirectory())) {
                bl2 = false;
                continue;
            }
            if (!hFUnit.insert(file.getPath(), hfsOpenDialog.getReadOnly() || !file.canWrite())) {
                bl2 = false;
                continue;
            }
            ++n;
        }
        if (bl2) {
            HFS.hfsAddHistory(fileArray);
            if (bl) {
                hfsBootUnit = hfsOpenUnit;
                XEiJ.mpuReset(40960, 15331360);
            }
        }
    }

    public static void hfsAddHistory(File file) {
        HFS.hfsAddHistory(new File[]{file});
    }

    public static void hfsAddHistory(File[] fileArray) {
        if (hfsOpenDialog == null) {
            hfsOpenHistory.add(fileArray);
        } else {
            hfsOpenDialog.addHistory(fileArray);
        }
    }

    public void hfsCheckTwentyOneOption() {
        hfsTwentyOneOption = 0;
    }

    static {
        hfsUnitArray = new HFUnit[16];
        hfsDeviceUnitArray = new int[16];
    }

    static class OpenDialog
    extends AbstractOpenDialog {
        public OpenDialog() {
            super(XEiJ.frmFrame, "Host file system directory to assign Human68k drives", "Human68k \u306e\u30c9\u30e9\u30a4\u30d6\u3092\u5272\u308a\u5f53\u3066\u308b\u30db\u30b9\u30c8\u30d5\u30a1\u30a4\u30eb\u30b7\u30b9\u30c6\u30e0\u306e\u30c7\u30a3\u30ec\u30af\u30c8\u30ea", true, hfsFileFilter);
        }

        @Override
        public void openFiles(File[] fileArray, boolean bl) {
            HFS.hfsOpenFiles(fileArray, bl);
        }
    }

    public static class HFUnit
    extends AbstractUnit {
        public static final int DEV_IGNORE = 16384;
        public static final int DEV_RETRY = 8192;
        public static final int DEV_ABORT = 4096;
        public static final int DEV_INVALID_UNIT_NUMBER = 1;
        public static final int DEV_INSERT_MEDIA = 2;
        public static final int DEV_UNKNOWN_COMMAND = 3;
        public static final int DEV_CRC_ERROR = 4;
        public static final int DEV_MANEGEMENT_AREA_BROKEN = 5;
        public static final int DEV_SEEK_ERROR = 6;
        public static final int DEV_INVALID_MEDIA = 7;
        public static final int DEV_SECTOR_NOT_FOUND = 8;
        public static final int DEV_PRINTER_NOT_CONNECTED = 9;
        public static final int DEV_WRITE_ERROR = 10;
        public static final int DEV_READ_ERROR = 11;
        public static final int DEV_MISCELLANEOUS_ERROR = 12;
        public static final int DEV_UNPROTECT_MEDIA = 13;
        public static final int DEV_CANNOT_WRITE = 14;
        public static final int DEV_FILE_SHARING_VIOLATION = 15;
        public static final int DOS_INVALID_FUNCTION = -1;
        public static final int DOS_FILE_NOT_FOUND = -2;
        public static final int DOS_DIRECTORY_NOT_FOUND = -3;
        public static final int DOS_TOO_MANY_HANDLES = -4;
        public static final int DOS_NOT_A_FILE = -5;
        public static final int DOS_HANDLE_IS_NOT_OPENED = -6;
        public static final int DOS_BROKEN_MEMORY_CHAIN = -7;
        public static final int DOS_NOT_ENOUGH_MEMORY = -8;
        public static final int DOS_INVALID_MEMORY_CHAIN = -9;
        public static final int DOS_INVALID_ENVIRONMENT = -10;
        public static final int DOS_ABNORMAL_X_FILE = -11;
        public static final int DOS_INVALID_ACCESS_MODE = -12;
        public static final int DOS_ILLEGAL_FILE_NAME = -13;
        public static final int DOS_INVALID_PARAMETER = -14;
        public static final int DOS_ILLEGAL_DRIVE_NUMBER = -15;
        public static final int DOS_CURRENT_DIRECTORY = -16;
        public static final int DOS_CANNOT_IOCTRL = -17;
        public static final int DOS_NO_MORE_FILES = -18;
        public static final int DOS_CANNOT_WRITE = -19;
        public static final int DOS_DIRECTORY_EXISTS = -20;
        public static final int DOS_RM_NONEMPTY_DIRECTORY = -21;
        public static final int DOS_MV_NONEMPTY_DIRECTORY = -22;
        public static final int DOS_DISK_FULL = -23;
        public static final int DOS_DIRECTORY_FULL = -24;
        public static final int DOS_SEEK_OVER_EOF = -25;
        public static final int DOS_ALREADY_SUPERVISOR = -26;
        public static final int DOS_THREAD_EXISTS = -27;
        public static final int DOS_COMMUNICATION_FAILED = -28;
        public static final int DOS_TOO_MANY_THREADS = -29;
        public static final int DOS_NOT_ENOUGH_LOCK_AREA = -32;
        public static final int DOS_FILE_IS_LOCKED = -33;
        public static final int DOS_OPENED_HANDLE_EXISTS = -34;
        public static final int DOS_FILE_EXISTS = -80;
        private static final int HFU_FILES_MAGIC = 709379667;
        public String hfuRootPath = null;
        public HashMap<Integer, ArrayDeque<byte[]>> hfuFilesBufferToArrayDeque;
        public int hfuFilesBufferCounter = 0;
        public HashMap<Integer, HFHandle> hfuFcbToHandle;
        public LinkedList<HFHandle> hfuClosedHandle;
        public final byte[] hfuTargetNameArray1 = new byte[88];
        public final byte[] hfuTargetNameArray2 = new byte[88];
        public String hfuTargetName1;
        public String hfuTargetName2;
        public long hfuTargetLastModified;
        public int hfuTargetOpenMode;
        public HFHandle hfuTargetHandle;
        public long hfuTargetPosition;
        public long hfuTargetFileSize;
        public long hfuTargetLength;
        public long hfuTargetAddress;
        public long hfuTargetTransferred;
        public long hfuTargetTotalSpace;
        public long hfuTargetFreeSpace;

        public HFHandle hfuNewHandle(int n, File file, RandomAccessFile randomAccessFile) {
            HFHandle hFHandle = this.hfuClosedHandle.pollFirst();
            if (hFHandle == null) {
                return new HFHandle(this, n, file, randomAccessFile);
            }
            hFHandle.hfhFcb = n;
            hFHandle.hfhFile = file;
            hFHandle.hfhRaf = randomAccessFile;
            Arrays.fill(hFHandle.hfhBuffer, (byte)0);
            hFHandle.hfhStart = 0L;
            hFHandle.hfhEnd = 0L;
            hFHandle.hfhDirty = false;
            return hFHandle;
        }

        public void hfuRecycleHandle(HFHandle hFHandle) {
            this.hfuClosedHandle.push(hFHandle);
        }

        public HFUnit(int n) {
            super(n);
            this.hfuFilesBufferToArrayDeque = new HashMap();
            this.hfuFcbToHandle = new HashMap();
            this.hfuClosedHandle = new LinkedList();
        }

        public void hfuTini() {
            for (HFHandle hFHandle : this.hfuFcbToHandle.values()) {
                RandomAccessFile randomAccessFile = hFHandle.hfhRaf;
                if (hFHandle.hfhDirty) {
                    try {
                        randomAccessFile.seek(hFHandle.hfhStart);
                    }
                    catch (IOException iOException) {
                        System.out.println((Multilingual.mlnJapanese ? "\u30b7\u30fc\u30af\u30a8\u30e9\u30fc: " : "Seek error: ") + hFHandle.toString());
                    }
                    try {
                        randomAccessFile.write(hFHandle.hfhBuffer, 0, (int)(hFHandle.hfhEnd - hFHandle.hfhStart));
                    }
                    catch (IOException iOException) {
                        System.out.println((Multilingual.mlnJapanese ? "\u9045\u5ef6\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " : "Delayed write failed: ") + hFHandle.toString());
                    }
                    hFHandle.hfhDirty = false;
                }
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u30af\u30ed\u30fc\u30ba\u30a8\u30e9\u30fc: " : "Close error: ") + hFHandle.toString());
                }
            }
            this.hfuFcbToHandle.clear();
            this.hfuFilesBufferToArrayDeque.clear();
        }

        public boolean hfuIPLBoot() {
            if (!this.abuConnected) {
                return false;
            }
            byte[] byArray = XEiJ.rscGetResource("HUMAN.SYS", new int[0]);
            if (byArray == null || ByteArray.byaRwz(byArray, 0) != 18517 || ByteArray.byaRls(byArray, 4) != 26624 || ByteArray.byaRls(byArray, 8) != 26624) {
                return false;
            }
            int n = ByteArray.byaRls(byArray, 12) + ByteArray.byaRls(byArray, 16);
            int n2 = ByteArray.byaRls(byArray, 20);
            System.arraycopy(byArray, 64, MainMemory.mmrM8, 26624, n);
            Arrays.fill(MainMemory.mmrM8, 26624 + n, 26624 + n + n2, (byte)0);
            return true;
        }

        @Override
        protected boolean eject() {
            String string = this.abuPath;
            if (!super.eject()) {
                return false;
            }
            if (string.length() != 0) {
                HFS.hfsAddHistory(new File(string).getAbsoluteFile());
                System.out.println(Multilingual.mlnJapanese ? string + " \u3092 hf" + this.abuNumber + " \u304b\u3089\u5207\u308a\u96e2\u3057\u307e\u3057\u305f" : string + " was ejected from hf" + this.abuNumber);
            }
            return true;
        }

        @Override
        protected boolean open() {
            if (!super.open()) {
                return false;
            }
            hfsOpenUnit = this.abuNumber;
            if (hfsOpenDialog == null) {
                hfsOpenDialog = new OpenDialog();
                hfsOpenDialog.setReadOnly(Settings.sgsGetOnOff("hfreadonly"));
                hfsOpenDialog.setReboot(Settings.sgsGetOnOff("hfappreboot"));
                for (File[] fileArray : hfsOpenHistory) {
                    hfsOpenDialog.addHistory(fileArray);
                }
                hfsOpenHistory.clear();
            }
            hfsOpenDialog.rescanCurrentDirectory();
            XEiJ.pnlExitFullScreen(true);
            hfsOpenDialog.setVisible(true);
            return true;
        }

        @Override
        protected boolean load(String string) {
            File file = new File(string).getAbsoluteFile();
            if (!(file.isDirectory() || (file = file.getParentFile()) != null && file.isDirectory())) {
                return false;
            }
            this.hfuRootPath = file.getAbsolutePath();
            HFS.hfsAddHistory(new File(string).getAbsoluteFile());
            System.out.println(Multilingual.mlnJapanese ? this.hfuRootPath + " \u3092 hf" + this.abuNumber + " \u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f" : this.hfuRootPath + " was inserted in hf" + this.abuNumber);
            return true;
        }

        public void hfuCall() throws M68kException {
            switch (hfsRequest2Command) {
                case 65: {
                    this.hfuCallChdir();
                    break;
                }
                case 66: {
                    this.hfuCallMkdir();
                    break;
                }
                case 67: {
                    this.hfuCallRmdir();
                    break;
                }
                case 68: {
                    this.hfuCallRename();
                    break;
                }
                case 69: {
                    this.hfuCallDelete();
                    break;
                }
                case 70: {
                    this.hfuCallChmod();
                    break;
                }
                case 71: {
                    this.hfuCallFiles();
                    break;
                }
                case 72: {
                    this.hfuCallNfiles();
                    break;
                }
                case 73: {
                    this.hfuCallCreateNewfile();
                    break;
                }
                case 74: {
                    this.hfuCallOpen();
                    break;
                }
                case 75: {
                    this.hfuCallClose();
                    break;
                }
                case 76: {
                    this.hfuCallRead();
                    break;
                }
                case 77: {
                    this.hfuCallWrite();
                    break;
                }
                case 78: {
                    this.hfuCallSeek();
                    break;
                }
                case 79: {
                    this.hfuCallFiledate();
                    break;
                }
                case 80: {
                    this.hfuCallDskfre();
                    break;
                }
                case 81: {
                    this.hfuCallDrvctrl();
                    break;
                }
                case 82: {
                    this.hfuCallGetdpb();
                    break;
                }
                case 83: {
                    this.hfuCallDiskred();
                    break;
                }
                case 84: {
                    this.hfuCallDiskwrt();
                    break;
                }
                case 85: {
                    this.hfuCallSpecialCtrl();
                    break;
                }
                case 86: {
                    this.hfuCallFflush();
                    break;
                }
                case 87: {
                    this.hfuCallMediacheck();
                    break;
                }
                case 88: {
                    this.hfuCallLock();
                    break;
                }
                default: {
                    hfsRequest3Error = 4099;
                    hfsRequest18Result = -1;
                    hfsState = 4;
                }
            }
        }

        public void hfuCallX68k() throws M68kException {
            switch (hfsRequest2Command) {
                case 71: {
                    this.hfuCallFilesX68k();
                    break;
                }
                case 73: {
                    this.hfuCallCreateNewfileX68k();
                    break;
                }
                case 74: {
                    this.hfuCallOpenX68k();
                    break;
                }
                case 75: {
                    this.hfuCallCloseX68k();
                    break;
                }
                case 76: {
                    this.hfuCallReadX68k();
                    break;
                }
                case 77: {
                    this.hfuCallWriteX68k();
                    break;
                }
                case 80: {
                    this.hfuCallDskfreX68k();
                }
            }
        }

        public void hfuCallHost() {
            switch (hfsRequest2Command) {
                case 65: {
                    this.hfuCallChdirHost();
                    break;
                }
                case 66: {
                    this.hfuCallMkdirHost();
                    break;
                }
                case 67: {
                    this.hfuCallRmdirHost();
                    break;
                }
                case 68: {
                    this.hfuCallRenameHost();
                    break;
                }
                case 69: {
                    this.hfuCallDeleteHost();
                    break;
                }
                case 70: {
                    this.hfuCallChmodHost();
                    break;
                }
                case 71: {
                    this.hfuCallFilesHost();
                    break;
                }
                case 73: {
                    this.hfuCallCreateNewfileHost();
                    break;
                }
                case 74: {
                    this.hfuCallOpenHost();
                    break;
                }
                case 75: {
                    this.hfuCallCloseHost();
                    break;
                }
                case 76: {
                    this.hfuCallReadHost();
                    break;
                }
                case 77: {
                    this.hfuCallWriteHost();
                    break;
                }
                case 80: {
                    this.hfuCallDskfreHost();
                    break;
                }
                case 86: {
                    this.hfuCallFflushHost();
                }
            }
        }

        public void hfuCallChdir() throws M68kException {
            this.hfuTargetName1 = this.hfuNamestsToPath(hfsRequest14Namests, false);
            if (this.hfuTargetName1 == null) {
                hfsRequest18Result = -13;
                hfsState = 4;
                return;
            }
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            hfsRequest18Result = 0;
            hfsState = 2;
        }

        public void hfuCallChdirHost() {
            File file = new File(this.hfuTargetName1);
            hfsRequest18Result = !file.isDirectory() || file.list() == null ? -3 : 0;
            hfsState = 4;
        }

        public void hfuCallMkdir() throws M68kException {
            this.hfuTargetName1 = this.hfuNamestsToPath(hfsRequest14Namests);
            if (this.hfuTargetName1 == null) {
                hfsRequest18Result = -13;
                hfsState = 4;
                return;
            }
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            if (this.abuWriteProtected) {
                hfsRequest3Error = 28686;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            hfsRequest18Result = 0;
            hfsState = 2;
        }

        public void hfuCallMkdirHost() {
            try {
                File file = new File(this.hfuTargetName1);
                hfsRequest18Result = !file.mkdir() ? -20 : 0;
            }
            catch (Exception exception) {
                hfsRequest18Result = -19;
            }
            hfsState = 4;
        }

        public void hfuCallRmdir() throws M68kException {
            this.hfuTargetName1 = this.hfuNamestsToPath(hfsRequest14Namests);
            if (this.hfuTargetName1 == null) {
                hfsRequest18Result = -13;
                hfsState = 4;
                return;
            }
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            if (this.abuWriteProtected) {
                hfsRequest3Error = 28686;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            hfsRequest18Result = 0;
            hfsState = 2;
        }

        public void hfuCallRmdirHost() {
            try {
                File file = new File(this.hfuTargetName1);
                hfsRequest18Result = !file.isDirectory() ? -3 : (!file.canWrite() ? -19 : (!file.delete() ? -21 : 0));
            }
            catch (Exception exception) {
                hfsRequest18Result = -19;
            }
            hfsState = 4;
        }

        public void hfuCallRename() throws M68kException {
            this.hfuTargetName1 = this.hfuNamestsToPath(hfsRequest14Namests);
            if (this.hfuTargetName1 == null) {
                hfsRequest18Result = -13;
                hfsState = 4;
                return;
            }
            this.hfuTargetName2 = this.hfuNamestsToPath(hfsRequest18Param);
            if (this.hfuTargetName2 == null) {
                hfsRequest18Result = -13;
                hfsState = 4;
                return;
            }
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            if (this.abuWriteProtected) {
                hfsRequest3Error = 28686;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            hfsRequest18Result = 0;
            hfsState = 2;
        }

        public void hfuCallRenameHost() {
            try {
                File file = new File(this.hfuTargetName1);
                File file2 = new File(this.hfuTargetName2);
                hfsRequest18Result = !file.exists() ? -2 : (!file.renameTo(file2) ? (file.isFile() ? -19 : -22) : 0);
            }
            catch (Exception exception) {
                hfsRequest18Result = -19;
            }
            hfsState = 4;
        }

        public void hfuCallDelete() throws M68kException {
            this.hfuTargetName1 = this.hfuNamestsToPath(hfsRequest14Namests);
            if (this.hfuTargetName1 == null) {
                hfsRequest18Result = -13;
                hfsState = 4;
                return;
            }
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            if (this.abuWriteProtected) {
                hfsRequest3Error = 28686;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            hfsRequest18Result = 0;
            hfsState = 2;
        }

        public void hfuCallDeleteHost() {
            try {
                File file = new File(this.hfuTargetName1);
                hfsRequest18Result = !file.isFile() ? -2 : (!file.canWrite() ? -19 : (!file.delete() ? -19 : 0));
            }
            catch (Exception exception) {
                hfsRequest18Result = -19;
            }
            hfsState = 4;
        }

        public void hfuCallChmod() throws M68kException {
            this.hfuTargetName1 = this.hfuNamestsToPath(hfsRequest14Namests);
            if (this.hfuTargetName1 == null) {
                hfsRequest18Result = -13;
                hfsState = 4;
                return;
            }
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            if (hfsRequest13Mode != 255 && this.abuWriteProtected) {
                hfsRequest3Error = 28686;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            hfsRequest18Result = 0;
            hfsState = 2;
        }

        public void hfuCallChmodHost() {
            File file = new File(this.hfuTargetName1);
            if (!file.exists()) {
                hfsRequest18Result = -2;
            } else if (hfsRequest13Mode == 255) {
                hfsRequest18Result = (file.isFile() ? 32 : 0) | (file.isDirectory() ? 16 : 0) | (file.isHidden() ? 2 : 0) | (!file.canWrite() ? 1 : 0);
            } else {
                boolean bl;
                hfsRequest18Result = 0;
                boolean bl2 = !file.canWrite();
                boolean bl3 = bl = (hfsRequest13Mode & 1) != 0;
                if (bl2 != bl) {
                    try {
                        if (!file.setWritable(!bl)) {
                            hfsRequest18Result = -19;
                        }
                    }
                    catch (Exception exception) {
                        hfsRequest18Result = -19;
                    }
                }
            }
            hfsState = 4;
        }

        public void hfuCallFiles() throws M68kException {
            byte[] byArray = this.hfuTargetNameArray1;
            MC68060.mmuReadByteArray(hfsRequest14Namests, byArray, 0, 88, XEiJ.regSRS);
            String string = this.hfuTargetName1 = this.hfuNamestsToPath(byArray, false);
            if (this.hfuTargetName1 == null) {
                hfsRequest18Result = -13;
                hfsState = 4;
                return;
            }
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            hfsRequest18Result = 0;
            hfsState = 2;
        }

        public void hfuCallFilesHost() {
            char c;
            int n;
            int n2;
            int n3;
            byte[] byArray = this.hfuTargetNameArray1;
            String string = this.hfuTargetName1;
            File file = new File(string);
            String[] stringArray = file.list();
            if (stringArray == null) {
                hfsRequest18Result = -3;
                hfsState = 4;
                return;
            }
            for (n3 = 21; n3 <= 28; ++n3) {
                byArray[n3] = byArray[46 + n3];
            }
            if (byArray[74] == 63 && byArray[78] == 0) {
                for (n3 = 29; n3 <= 38; ++n3) {
                    byArray[n3] = 63;
                }
            } else {
                for (n3 = 29; n3 <= 38; ++n3) {
                    byArray[n3] = byArray[49 + n3];
                }
            }
            for (n3 = 38; n3 >= 21 && (byArray[n3] == 0 || byArray[n3] == 32); --n3) {
                byArray[n3] = 0;
            }
            for (n3 = 39; n3 <= 41; ++n3) {
                byArray[n3] = byArray[36 + n3];
            }
            for (n3 = 41; n3 >= 39 && (byArray[n3] == 0 || byArray[n3] == 32); --n3) {
                byArray[n3] = 0;
            }
            for (n3 = 21; n3 <= 41; ++n3) {
                n2 = byArray[n3] & 0xFF;
                if (65 <= n2 && n2 <= 90) {
                    byArray[n3] = (byte)(n2 | 0x20);
                    continue;
                }
                if ((129 > n2 || n2 > 159) && (224 > n2 || n2 > 239)) continue;
                ++n3;
            }
            n2 = n3 = (int)(string.equals(this.hfuRootPath) ? 1 : 0);
            int n4 = n3;
            ArrayDeque<byte[]> arrayDeque = new ArrayDeque<byte[]>();
            if (n3 != 0 && (hfsRequest13Mode & 8) != 0 && byArray[21] == 63 && byArray[39] == 63) {
                int n5;
                int n6;
                for (n6 = string.length(); 2 <= n6 && (string.charAt(n6 - 1) == '/' || string.charAt(n6 - 1) == '\\' || string.charAt(n6 - 1) == '.' && (string.charAt(n6 - 2) == '/' || string.charAt(n6 - 2) == '\\')); --n6) {
                }
                byte[] byArray2 = new byte[32];
                this.hfuFileInfo(file, byArray2);
                byArray2[0] = 8;
                byArray2[8] = 0;
                byArray2[7] = 0;
                byArray2[6] = 0;
                byArray2[5] = 0;
                int n7 = 9;
                for (n5 = 0; n5 < n6; ++n5) {
                    n = CharacterCode.chrCharToSJIS[string.charAt(n5)];
                    if (n < 256) {
                        if (30 < n7 + 1) {
                            n7 = 0;
                            break;
                        }
                        byArray2[n7++] = (byte)n;
                        continue;
                    }
                    if (30 < n7 + 2) {
                        n7 = 0;
                        break;
                    }
                    byArray2[n7++] = (byte)(n >> 8);
                    byArray2[n7++] = (byte)n;
                }
                if (n7 == 0) {
                    n7 = 9;
                    for (n5 = 0; n5 < n6; ++n5) {
                        n = CharacterCode.chrCharToSJIS[string.charAt(n5)];
                        if (n < 256) {
                            if (14 < n7 + 1) break;
                            byArray2[n7++] = (byte)n;
                            continue;
                        }
                        if (14 < n7 + 2) break;
                        byArray2[n7++] = (byte)(n >> 8);
                        byArray2[n7++] = (byte)n;
                    }
                    byArray2[n7++] = 95;
                    n5 = 30;
                    for (n = n6 - 1; 0 <= n; --n) {
                        c = CharacterCode.chrCharToSJIS[string.charAt(n)];
                        if (c < '\u0100') {
                            if (n5 - 1 < n7) break;
                            byArray2[--n5] = (byte)c;
                            continue;
                        }
                        if (n5 - 2 < n7) break;
                        byArray2[--n5] = (byte)c;
                        byArray2[--n5] = (byte)(c >> 8);
                    }
                    if (n7 < n5) {
                        while (n5 < 30) {
                            byArray2[n7++] = byArray2[n5++];
                        }
                    } else {
                        n7 = 30;
                    }
                }
                for (n5 = n7; n5 <= 31; ++n5) {
                    byArray2[n5] = 0;
                }
                if (byArray2[27] != 0) {
                    byArray2[30] = byArray2[29];
                    byArray2[29] = byArray2[28];
                    byArray2[28] = byArray2[27];
                    byArray2[27] = 46;
                }
                arrayDeque.addLast(byArray2);
            }
            block13: for (String string2 : stringArray) {
                int n8;
                int n9;
                int n10;
                n = string2.length();
                if (n == 0) continue;
                c = '\u0000';
                boolean bl = false;
                if (n3 != 0) {
                    if (string2.equals(".") || string2.equals("..")) continue;
                    c = string2.equalsIgnoreCase("HUMAN.SYS");
                    if (c != '\u0000') {
                        n2 = 0;
                    }
                    if (bl = string2.equalsIgnoreCase("COMMAND.X")) {
                        n4 = 0;
                    }
                }
                byte[] byArray3 = new byte[32];
                int n11 = 9;
                for (n10 = 0; n10 < n; ++n10) {
                    n9 = CharacterCode.chrCharToSJIS[string2.charAt(n10)];
                    if (n9 <= 31 || n9 == 47 || n9 == 92 || n9 == 45 && n10 == 0 || n9 == 34 || n9 == 39 || n9 == 44 || n9 == 59 || n9 == 60 || n9 == 61 || n9 == 62 || n9 == 91 || n9 == 93 || n9 == 124) continue block13;
                    if (n9 < 256) {
                        if (n11 >= 31) continue block13;
                        byArray3[n11++] = (byte)n9;
                        continue;
                    }
                    if (n11 >= 30) continue block13;
                    byArray3[n11++] = (byte)(n9 >> 8);
                    byArray3[n11++] = (byte)n9;
                }
                for (n10 = n11; n10 <= 31; ++n10) {
                    byArray3[n10] = 0;
                }
                int n12 = byArray3[n11 - 1] == 46 ? n11 : (n11 >= 12 && byArray3[n11 - 2] == 46 ? n11 - 2 : (n11 >= 13 && byArray3[n11 - 3] == 46 ? n11 - 3 : (n10 = n11 >= 14 && byArray3[n11 - 4] == 46 ? n11 - 4 : n11)));
                if (n10 > 27) continue;
                n9 = 0;
                for (n8 = 9; n8 < n10; ++n8) {
                    byArray[n9++] = byArray3[n8];
                }
                while (n9 <= 17) {
                    byArray[n9++] = 0;
                }
                for (n8 = n10 + 1; n8 < n11; ++n8) {
                    byArray[n9++] = byArray3[n8];
                }
                while (n9 <= 20) {
                    byArray[n9++] = 0;
                }
                n9 = 32;
                for (n8 = 0; n8 <= 20; ++n8) {
                    int n13 = byArray[n8] & 0xFF;
                    int n14 = byArray[21 + n8] & 0xFF;
                    if (n14 != 63 && (65 <= n13 && n13 <= 90 ? n13 | n9 : n13) != n14) continue block13;
                    n9 = n9 != 0 && (129 <= n13 && n13 <= 159 || 224 <= n13 && n13 <= 239) ? 0 : 32;
                }
                File file2 = new File(file, string2);
                if (0xFFFFFFFFL < file2.length()) continue;
                this.hfuFileInfo(file2, byArray3);
                if (c != '\u0000') {
                    byArray3[0] = (byte)(byArray3[0] | 4);
                }
                if ((byArray3[0] & hfsRequest13Mode) == 0) continue;
                arrayDeque.addLast(byArray3);
            }
            if (arrayDeque.isEmpty()) {
                hfsRequest18Result = -2;
                hfsState = 4;
                return;
            }
            ++this.hfuFilesBufferCounter;
            this.hfuFilesBufferToArrayDeque.put(this.hfuFilesBufferCounter, arrayDeque);
            hfsRequest18Result = 0;
            hfsState = 1;
        }

        public void hfuCallFilesX68k() throws M68kException {
            MC68060.mmuWriteLongData(hfsRequest18Param + 2, 709379667, XEiJ.regSRS);
            MC68060.mmuWriteLongData(hfsRequest18Param + 6, this.hfuFilesBufferCounter, XEiJ.regSRS);
            int n = this.hfuFilesBufferCounter;
            ArrayDeque<byte[]> arrayDeque = this.hfuFilesBufferToArrayDeque.get(n);
            if (arrayDeque == null) {
                hfsRequest18Result = -18;
                hfsState = 4;
                return;
            }
            byte[] byArray = arrayDeque.pollFirst();
            MC68060.mmuWriteByteArray(hfsRequest18Param + 21, byArray, 0, 32, XEiJ.regSRS);
            if (arrayDeque.isEmpty()) {
                MC68060.mmuWriteLongData(hfsRequest18Param + 2, 0, XEiJ.regSRS);
                MC68060.mmuWriteLongData(hfsRequest18Param + 6, 0, XEiJ.regSRS);
                this.hfuFilesBufferToArrayDeque.remove(n);
            }
            hfsRequest18Result = 0;
            hfsState = 4;
        }

        public void hfuCallNfiles() throws M68kException {
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            if (MC68060.mmuReadLongData(hfsRequest18Param + 2, XEiJ.regSRS) != 709379667) {
                hfsRequest18Result = -18;
                hfsState = 4;
                return;
            }
            int n = MC68060.mmuReadLongData(hfsRequest18Param + 6, XEiJ.regSRS);
            ArrayDeque<byte[]> arrayDeque = this.hfuFilesBufferToArrayDeque.get(n);
            if (arrayDeque == null) {
                hfsRequest18Result = -18;
                hfsState = 4;
                return;
            }
            byte[] byArray = arrayDeque.pollFirst();
            MC68060.mmuWriteByteArray(hfsRequest18Param + 21, byArray, 0, 32, XEiJ.regSRS);
            if (arrayDeque.isEmpty()) {
                MC68060.mmuWriteLongData(hfsRequest18Param + 2, 0, XEiJ.regSRS);
                MC68060.mmuWriteLongData(hfsRequest18Param + 6, 0, XEiJ.regSRS);
                this.hfuFilesBufferToArrayDeque.remove(n);
            }
            hfsRequest18Result = 0;
            hfsState = 4;
        }

        public void hfuCallCreateNewfile() throws M68kException {
            byte[] byArray = this.hfuTargetNameArray1;
            MC68060.mmuReadByteArray(hfsRequest14Namests, byArray, 0, 88, XEiJ.regSRS);
            this.hfuTargetName1 = this.hfuNamestsToPath(byArray, true);
            if (this.hfuTargetName1 == null) {
                hfsRequest18Result = -13;
                hfsState = 4;
                return;
            }
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            if (this.abuWriteProtected) {
                hfsRequest3Error = 28686;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            hfsRequest18Result = 0;
            hfsState = 2;
        }

        public void hfuCallCreateNewfileHost() {
            RandomAccessFile randomAccessFile;
            byte[] byArray = this.hfuTargetNameArray2;
            File file = new File(this.hfuTargetName1);
            if (file.exists()) {
                if (hfsRequest18Param == 0) {
                    hfsRequest18Result = -80;
                    hfsState = 4;
                    return;
                }
                if (file.isDirectory() || !file.delete()) {
                    hfsRequest18Result = -19;
                    hfsState = 4;
                    return;
                }
            }
            try {
                randomAccessFile = new RandomAccessFile(file, "rw");
            }
            catch (IOException iOException) {
                hfsRequest18Result = -19;
                hfsState = 4;
                return;
            }
            if (this.hfuFcbToHandle.isEmpty()) {
                this.prevent();
            }
            this.hfuFileInfo(file, byArray);
            int n = hfsRequest22Fcb;
            HFHandle hFHandle = this.hfuTargetHandle = this.hfuNewHandle(n, file, randomAccessFile);
            this.hfuFcbToHandle.put(n, hFHandle);
            hfsRequest18Result = 0;
            hfsState = 1;
        }

        public void hfuCallCreateNewfileX68k() throws M68kException {
            int n;
            HFHandle hFHandle = this.hfuTargetHandle;
            int n2 = hFHandle.hfhFcb;
            byte[] byArray = this.hfuTargetNameArray1;
            byte[] byArray2 = this.hfuTargetNameArray2;
            for (n = 0; n < 11; ++n) {
                MC68060.mmuWriteByteData(n2 + 36 + n, byArray[67 + n], XEiJ.regSRS);
            }
            MC68060.mmuWriteByteData(n2 + 47, byArray2[0], XEiJ.regSRS);
            for (n = 0; n < 10; ++n) {
                MC68060.mmuWriteByteData(n2 + 48 + n, byArray[78 + n], XEiJ.regSRS);
            }
            MC68060.mmuWriteLongData(n2 + 58, ByteArray.byaRls(byArray2, 1), XEiJ.regSRS);
            MC68060.mmuWriteWordData(n2 + 62, 0, XEiJ.regSRS);
            MC68060.mmuWriteLongData(n2 + 64, ByteArray.byaRls(byArray2, 5), XEiJ.regSRS);
            hfsRequest18Result = 0;
            hfsState = 4;
        }

        public void hfuCallOpen() throws M68kException {
            byte[] byArray = this.hfuTargetNameArray1;
            MC68060.mmuReadByteArray(hfsRequest14Namests, byArray, 0, 88, XEiJ.regSRS);
            this.hfuTargetName1 = this.hfuNamestsToPath(byArray, true);
            if (this.hfuTargetName1 == null) {
                hfsRequest18Result = -13;
                hfsState = 4;
                return;
            }
            int n = hfsRequest22Fcb;
            this.hfuTargetOpenMode = MC68060.mmuReadByteZeroData(n + 14, XEiJ.regSRS);
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            if (this.hfuTargetOpenMode != 0 && this.abuWriteProtected) {
                hfsRequest3Error = 28686;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            hfsRequest18Result = 0;
            hfsState = 2;
        }

        public void hfuCallOpenHost() {
            Object object;
            int n;
            RandomAccessFile randomAccessFile;
            byte[] byArray = this.hfuTargetNameArray2;
            File file = new File(this.hfuTargetName1);
            if (!file.exists()) {
                hfsRequest18Result = -2;
                hfsState = 4;
                return;
            }
            if (0xFFFFFFFFL < file.length()) {
                hfsRequest18Result = -2;
                hfsState = 4;
                return;
            }
            this.hfuFileInfo(file, byArray);
            try {
                randomAccessFile = new RandomAccessFile(file, this.hfuTargetOpenMode == 0 ? "r" : "rw");
                if (hfsUTF8WarningOn && !hfsUTF8WarningSet.contains(this.hfuTargetName1)) {
                    int n2;
                    int n3;
                    hfsUTF8WarningSet.add(this.hfuTargetName1);
                    n = (int)Math.min(4096L, file.length());
                    object = new byte[n];
                    for (n2 = 0; n2 < n && (n3 = randomAccessFile.read((byte[])object, n2, n - n2)) >= 0; n2 += n3) {
                    }
                    randomAccessFile.seek(0L);
                    if (!HFUnit.hfuUTF8WarningTest((byte[])object, n2)) {
                        System.out.println("The character encoding of " + this.hfuTargetName1 + " is UTF-8, not SJIS.");
                    }
                }
            }
            catch (IOException iOException) {
                hfsRequest18Result = -2;
                hfsState = 4;
                return;
            }
            if (this.hfuFcbToHandle.isEmpty()) {
                this.prevent();
            }
            n = hfsRequest22Fcb;
            this.hfuTargetHandle = this.hfuNewHandle(n, file, randomAccessFile);
            object = this.hfuTargetHandle;
            this.hfuFcbToHandle.put(n, (HFHandle)object);
            hfsRequest18Result = 0;
            hfsState = 1;
        }

        private static boolean hfuUTF8WarningTest(byte[] byArray, int n) {
            int n2;
            int n3;
            int n4;
            for (n4 = 0; n4 < n; ++n4) {
                n3 = byArray[n4] & 0xFF;
                if (n3 <= 127) {
                    if (n3 != 0) {
                        continue;
                    }
                } else if (n3 > 191) {
                    if (n3 <= 223) {
                        int n5 = n2 = n4 + 1 < n ? byArray[n4 + 1] & 0xFF : -1;
                        if (n2 == -1 || 128 <= n2 && n2 <= 191) {
                            ++n4;
                            continue;
                        }
                    } else if (n3 <= 239) {
                        n2 = n4 + 1 < n ? byArray[n4 + 1] & 0xFF : -1;
                        int n6 = var5_5 = n4 + 2 < n ? byArray[n4 + 2] & 0xFF : -1;
                        if ((n2 == -1 || 128 <= n2 && n2 <= 191) && (var5_5 == -1 || 128 <= var5_5 && var5_5 <= 191)) {
                            n4 += 2;
                            continue;
                        }
                    } else if (n3 <= 247) {
                        int n7;
                        n2 = n4 + 1 < n ? byArray[n4 + 1] & 0xFF : -1;
                        var5_5 = n4 + 2 < n ? byArray[n4 + 2] & 0xFF : -1;
                        int n8 = n7 = n4 + 3 < n ? byArray[n4 + 3] & 0xFF : -1;
                        if ((n2 == -1 || 128 <= n2 && n2 <= 191) && (var5_5 == -1 || 128 <= var5_5 && var5_5 <= 191) && (n7 == -1 || 128 <= n7 && n7 <= 191)) {
                            n4 += 3;
                            continue;
                        }
                    }
                }
                return true;
            }
            for (n4 = 0; n4 < n; ++n4) {
                n3 = byArray[n4] & 0xFF;
                if (0 <= n3 && n3 <= 127 || 160 <= n3 && n3 <= 223) {
                    if (n3 != 0) {
                        continue;
                    }
                } else if (n3 == 128 || 240 <= n3 && n3 <= 245) {
                    if (n <= n4 + 1 || byArray[n4 + 1] != 0) {
                        ++n4;
                        continue;
                    }
                } else if (129 <= n3 && n3 <= 159 || 224 <= n3 && n3 <= 239) {
                    int n9 = n2 = n4 + 1 < n ? byArray[n4 + 1] & 0xFF : -1;
                    if (n2 == -1 || 64 <= n2 && n2 <= 252 && n2 != 127) {
                        ++n4;
                        continue;
                    }
                }
                return false;
            }
            return true;
        }

        public void hfuCallOpenX68k() throws M68kException {
            int n;
            HFHandle hFHandle = this.hfuTargetHandle;
            int n2 = hFHandle.hfhFcb;
            byte[] byArray = this.hfuTargetNameArray1;
            byte[] byArray2 = this.hfuTargetNameArray2;
            for (n = 0; n < 11; ++n) {
                MC68060.mmuWriteByteData(n2 + 36 + n, byArray[67 + n], XEiJ.regSRS);
            }
            MC68060.mmuWriteByteData(n2 + 47, byArray2[0], XEiJ.regSRS);
            for (n = 0; n < 10; ++n) {
                MC68060.mmuWriteByteData(n2 + 48 + n, byArray[78 + n], XEiJ.regSRS);
            }
            MC68060.mmuWriteLongData(n2 + 58, ByteArray.byaRls(byArray2, 1), XEiJ.regSRS);
            MC68060.mmuWriteWordData(n2 + 62, 0, XEiJ.regSRS);
            MC68060.mmuWriteLongData(n2 + 64, ByteArray.byaRls(byArray2, 5), XEiJ.regSRS);
            hfsRequest18Result = 0;
            hfsState = 4;
        }

        public void hfuCallClose() throws M68kException {
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            int n = hfsRequest22Fcb;
            this.hfuTargetHandle = this.hfuFcbToHandle.remove(n);
            HFHandle hFHandle = this.hfuTargetHandle;
            if (hFHandle == null) {
                hfsRequest18Result = 0;
                hfsState = 4;
                return;
            }
            hfsRequest18Result = 0;
            hfsState = 2;
        }

        public void hfuCallCloseHost() {
            HFHandle hFHandle = this.hfuTargetHandle;
            if (hfsRequest18Result != 0) {
                File file = hFHandle.hfhFile;
                if (!file.setLastModified(this.hfuTargetLastModified)) {
                    System.out.println((Multilingual.mlnJapanese ? "\u6700\u7d42\u66f4\u65b0\u65e5\u6642\u3092\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093: " : "Could not set last modified date and time: ") + hFHandle.toString());
                }
                if (this.hfuFcbToHandle.isEmpty()) {
                    this.allow();
                }
                this.hfuRecycleHandle(hFHandle);
                this.hfuTargetHandle = null;
                hFHandle = null;
                hfsRequest18Result = 0;
                hfsState = 4;
                return;
            }
            RandomAccessFile randomAccessFile = hFHandle.hfhRaf;
            if (hFHandle.hfhDirty) {
                try {
                    hFHandle.hfhRaf.seek(hFHandle.hfhStart);
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u30b7\u30fc\u30af\u30a8\u30e9\u30fc: " : "Seek error: ") + hFHandle.toString());
                }
                try {
                    hFHandle.hfhRaf.write(hFHandle.hfhBuffer, 0, (int)(hFHandle.hfhEnd - hFHandle.hfhStart));
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u9045\u5ef6\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " : "Delayed write failed: ") + hFHandle.toString());
                }
                hFHandle.hfhDirty = false;
            }
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                System.out.println((Multilingual.mlnJapanese ? "\u30af\u30ed\u30fc\u30ba\u30a8\u30e9\u30fc: " : "Close error: ") + hFHandle.toString());
            }
            hfsRequest18Result = 0;
            hfsState = 1;
        }

        public void hfuCallCloseX68k() throws M68kException {
            HFHandle hFHandle = this.hfuTargetHandle;
            int n = hFHandle.hfhFcb;
            if ((MC68060.mmuReadByteZeroData(n + 14, XEiJ.regSRS) & 0xF) == 0) {
                if (this.hfuFcbToHandle.isEmpty()) {
                    this.allow();
                }
                this.hfuRecycleHandle(hFHandle);
                this.hfuTargetHandle = null;
                hFHandle = null;
                hfsRequest18Result = 0;
                hfsState = 4;
                return;
            }
            if ((MC68060.mmuReadByteZeroData(n + 1, XEiJ.regSRS) & 0x40) != 0) {
                this.hfuTargetLastModified = System.currentTimeMillis();
            } else {
                int n2 = MC68060.mmuReadWordZeroData(n + 58, XEiJ.regSRS);
                int n3 = MC68060.mmuReadWordZeroData(n + 60, XEiJ.regSRS);
                this.hfuTargetLastModified = DnT.dntCmilYearMontMdayHourMinuSeco((n3 >> 9) + 1980, n3 >> 5 & 0xF, n3 & 0x1F, n2 >> 11, n2 >> 5 & 0x3F, (n2 & 0x1F) << 1) - RP5C15.rtcCmilGap;
            }
            hfsRequest18Result = 1;
            hfsState = 2;
        }

        public void hfuCallRead() throws M68kException {
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            int n = hfsRequest22Fcb;
            this.hfuTargetHandle = this.hfuFcbToHandle.get(n);
            HFHandle hFHandle = this.hfuTargetHandle;
            if (hFHandle == null) {
                hfsRequest18Result = -6;
                hfsState = 4;
                return;
            }
            this.hfuTargetLength = (long)hfsRequest18Param & 0xFFFFFFFFL;
            this.hfuTargetPosition = (long)MC68060.mmuReadLongData(n + 6, XEiJ.regSRS) & 0xFFFFFFFFL;
            this.hfuTargetFileSize = (long)MC68060.mmuReadLongData(n + 64, XEiJ.regSRS) & 0xFFFFFFFFL;
            this.hfuTargetLength = Math.min(this.hfuTargetLength, this.hfuTargetFileSize - this.hfuTargetPosition);
            if (this.hfuTargetLength == 0L) {
                hfsRequest18Result = 0;
                hfsState = 4;
                return;
            }
            this.hfuTargetAddress = (long)hfsRequest14Namests & 0xFFFFFFFFL;
            this.hfuTargetTransferred = 0L;
            if (this.hfuTargetFileSize == 0L || 0L < hFHandle.hfhEnd && hFHandle.hfhStart <= this.hfuTargetPosition && this.hfuTargetPosition < hFHandle.hfhStart + 65536L) {
                hfsRequest18Result = 0;
                hfsState = 1;
            } else {
                hfsRequest18Result = 0;
                hfsState = 2;
            }
        }

        public void hfuCallReadHost() {
            HFHandle hFHandle = this.hfuTargetHandle;
            RandomAccessFile randomAccessFile = hFHandle.hfhRaf;
            if (hFHandle.hfhDirty) {
                try {
                    randomAccessFile.seek(hFHandle.hfhStart);
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u30b7\u30fc\u30af\u30a8\u30e9\u30fc: " : "Seek error: ") + hFHandle.toString());
                }
                try {
                    randomAccessFile.write(hFHandle.hfhBuffer, 0, (int)(hFHandle.hfhEnd - hFHandle.hfhStart));
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u9045\u5ef6\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " : "Delayed write failed: ") + hFHandle.toString());
                }
                hFHandle.hfhDirty = false;
            }
            int n = (int)Math.min(65536L, this.hfuTargetFileSize - this.hfuTargetPosition);
            int n2 = 0;
            Arrays.fill(hFHandle.hfhBuffer, (byte)0);
            hFHandle.hfhStart = this.hfuTargetPosition;
            hFHandle.hfhEnd = this.hfuTargetPosition + (long)n;
            hFHandle.hfhDirty = false;
            if (0 < n) {
                try {
                    randomAccessFile.seek(this.hfuTargetPosition);
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u30b7\u30fc\u30af\u30a8\u30e9\u30fc: " : "Seek error: ") + hFHandle.toString());
                }
                try {
                    while (n2 < n) {
                        int n3 = randomAccessFile.read(hFHandle.hfhBuffer, n2, n - n2);
                        if (n3 < 0) {
                            hfsRequest18Result = -1;
                            hfsState = 4;
                            return;
                        }
                        n2 += n3;
                    }
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u30ea\u30fc\u30c9\u30a8\u30e9\u30fc: " : "Read error: ") + hFHandle.toString());
                    hfsRequest18Result = -1;
                    hfsState = 4;
                    return;
                }
            }
            hfsRequest18Result = 0;
            hfsState = 1;
        }

        public void hfuCallReadX68k() throws M68kException {
            HFHandle hFHandle = this.hfuTargetHandle;
            int n = hFHandle.hfhFcb;
            long l = Math.min(this.hfuTargetLength - this.hfuTargetTransferred, hFHandle.hfhEnd - this.hfuTargetPosition);
            long l2 = Math.min(128L, l);
            MC68060.mmuWriteByteArray((int)(this.hfuTargetAddress + this.hfuTargetTransferred), hFHandle.hfhBuffer, (int)(this.hfuTargetPosition - hFHandle.hfhStart), (int)l2, XEiJ.regSRS);
            this.hfuTargetPosition += l2;
            MC68060.mmuWriteLongData(n + 6, (int)this.hfuTargetPosition, XEiJ.regSRS);
            this.hfuTargetTransferred += l2;
            if (this.hfuTargetLength <= this.hfuTargetTransferred) {
                hfsRequest18Result = (int)this.hfuTargetTransferred;
                hfsState = 4;
                return;
            }
            if (l2 < l) {
                hfsRequest18Result = 0;
                hfsState = 1;
            } else {
                hfsRequest18Result = 0;
                hfsState = 2;
            }
        }

        public void hfuCallWrite() throws M68kException {
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            if (this.abuWriteProtected) {
                hfsRequest3Error = 28686;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            int n = hfsRequest22Fcb;
            this.hfuTargetHandle = this.hfuFcbToHandle.get(n);
            HFHandle hFHandle = this.hfuTargetHandle;
            if (hFHandle == null) {
                hfsRequest18Result = -6;
                hfsState = 4;
                return;
            }
            this.hfuTargetLength = (long)hfsRequest18Param & 0xFFFFFFFFL;
            this.hfuTargetPosition = (long)MC68060.mmuReadLongData(n + 6, XEiJ.regSRS) & 0xFFFFFFFFL;
            this.hfuTargetFileSize = (long)MC68060.mmuReadLongData(n + 64, XEiJ.regSRS) & 0xFFFFFFFFL;
            if (this.hfuTargetLength == 0L) {
                if (this.hfuTargetFileSize <= this.hfuTargetPosition) {
                    hfsRequest18Result = 0;
                    hfsState = 4;
                    return;
                }
                MC68060.mmuWriteLongData(n + 64, (int)this.hfuTargetPosition, XEiJ.regSRS);
                hfsRequest18Result = 1;
                hfsState = 2;
                return;
            }
            if (0xFFFFFFFFL < this.hfuTargetPosition + this.hfuTargetLength) {
                this.hfuTargetLength = 0xFFFFFFFFL - this.hfuTargetPosition;
                if (this.hfuTargetLength == 0L) {
                    hfsRequest18Result = 0;
                    hfsState = 4;
                    return;
                }
            }
            this.hfuTargetAddress = (long)hfsRequest14Namests & 0xFFFFFFFFL;
            this.hfuTargetTransferred = 0L;
            if (this.hfuTargetFileSize == 0L || 0L < hFHandle.hfhEnd && hFHandle.hfhStart <= this.hfuTargetPosition && this.hfuTargetPosition < hFHandle.hfhStart + 65536L) {
                hfsRequest18Result = 0;
                hfsState = 1;
            } else {
                hfsRequest18Result = 0;
                hfsState = 2;
            }
        }

        public void hfuCallWriteHost() {
            HFHandle hFHandle = this.hfuTargetHandle;
            RandomAccessFile randomAccessFile = hFHandle.hfhRaf;
            if (hfsRequest18Result != 0) {
                if (hFHandle.hfhStart <= this.hfuTargetPosition && this.hfuTargetPosition < hFHandle.hfhEnd) {
                    Arrays.fill(hFHandle.hfhBuffer, (int)(this.hfuTargetPosition - hFHandle.hfhStart), (int)(hFHandle.hfhEnd - hFHandle.hfhStart), (byte)0);
                    hFHandle.hfhEnd = this.hfuTargetPosition;
                }
                try {
                    randomAccessFile.seek(this.hfuTargetPosition);
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u30b7\u30fc\u30af\u30a8\u30e9\u30fc: " : "Seek error: ") + hFHandle.toString());
                }
                try {
                    randomAccessFile.setLength(this.hfuTargetPosition);
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u30d5\u30a1\u30a4\u30eb\u306e\u9577\u3055\u3092\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093: " : "Could not set length of file: ") + hFHandle.toString());
                    hfsRequest18Result = -1;
                    hfsState = 4;
                    return;
                }
                hfsRequest18Result = 0;
                hfsState = 4;
                return;
            }
            if (hFHandle.hfhDirty) {
                try {
                    randomAccessFile.seek(hFHandle.hfhStart);
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u30b7\u30fc\u30af\u30a8\u30e9\u30fc: " : "Seek error: ") + hFHandle.toString());
                }
                try {
                    randomAccessFile.write(hFHandle.hfhBuffer, 0, (int)(hFHandle.hfhEnd - hFHandle.hfhStart));
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u9045\u5ef6\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " : "Delayed write failed: ") + hFHandle.toString());
                }
                hFHandle.hfhDirty = false;
            }
            int n = (int)Math.min(65536L, this.hfuTargetFileSize - this.hfuTargetPosition);
            int n2 = 0;
            Arrays.fill(hFHandle.hfhBuffer, (byte)0);
            hFHandle.hfhStart = this.hfuTargetPosition;
            hFHandle.hfhEnd = this.hfuTargetPosition + (long)n;
            hFHandle.hfhDirty = false;
            if (0 < n) {
                try {
                    randomAccessFile.seek(this.hfuTargetPosition);
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u30b7\u30fc\u30af\u30a8\u30e9\u30fc: " : "Seek error: ") + hFHandle.toString());
                }
                try {
                    while (n2 < n) {
                        int n3 = randomAccessFile.read(hFHandle.hfhBuffer, n2, n - n2);
                        if (n3 < 0) {
                            hfsRequest18Result = -1;
                            hfsState = 4;
                            return;
                        }
                        n2 += n3;
                    }
                }
                catch (IOException iOException) {
                    System.out.println((Multilingual.mlnJapanese ? "\u30ea\u30fc\u30c9\u30a8\u30e9\u30fc: " : "Read error: ") + hFHandle.toString());
                    hfsRequest18Result = -1;
                    hfsState = 4;
                    return;
                }
            }
            hfsRequest18Result = 0;
            hfsState = 1;
        }

        public void hfuCallWriteX68k() throws M68kException {
            HFHandle hFHandle = this.hfuTargetHandle;
            int n = hFHandle.hfhFcb;
            long l = Math.min(this.hfuTargetLength - this.hfuTargetTransferred, hFHandle.hfhStart + 65536L - this.hfuTargetPosition);
            long l2 = Math.min(128L, l);
            MC68060.mmuReadByteArray((int)(this.hfuTargetAddress + this.hfuTargetTransferred), hFHandle.hfhBuffer, (int)(this.hfuTargetPosition - hFHandle.hfhStart), (int)l2, XEiJ.regSRS);
            hFHandle.hfhEnd = Math.max(hFHandle.hfhEnd, this.hfuTargetPosition + l2);
            hFHandle.hfhDirty = true;
            this.hfuTargetPosition += l2;
            MC68060.mmuWriteLongData(n + 6, (int)this.hfuTargetPosition, XEiJ.regSRS);
            if (this.hfuTargetFileSize < this.hfuTargetPosition) {
                this.hfuTargetFileSize = this.hfuTargetPosition;
                MC68060.mmuWriteLongData(n + 64, (int)this.hfuTargetFileSize, XEiJ.regSRS);
            }
            this.hfuTargetTransferred += l2;
            if (this.hfuTargetLength <= this.hfuTargetTransferred) {
                hfsRequest18Result = (int)this.hfuTargetTransferred;
                hfsState = 4;
                return;
            }
            if (l2 < l) {
                hfsRequest18Result = 0;
                hfsState = 1;
            } else {
                hfsRequest18Result = 0;
                hfsState = 2;
            }
        }

        public void hfuCallSeek() throws M68kException {
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            int n = hfsRequest13Mode;
            long l = hfsRequest18Param;
            int n2 = hfsRequest22Fcb;
            HFHandle hFHandle = this.hfuFcbToHandle.get(n2);
            if (hFHandle == null) {
                hfsRequest18Result = -6;
                hfsState = 4;
                return;
            }
            long l2 = MC68060.mmuReadLongData(n2 + 6, XEiJ.regSRS);
            long l3 = MC68060.mmuReadLongData(n2 + 64, XEiJ.regSRS);
            l2 &= 0xFFFFFFFFL;
            l3 &= 0xFFFFFFFFL;
            if (n == 0) {
                l2 = l &= 0xFFFFFFFFL;
            } else if (n == 1) {
                l = (l + 0x80000000L & 0xFFFFFFFFL) - 0x80000000L;
                l2 += l;
            } else if (n == 2) {
                l = (l - 1L & 0xFFFFFFFFL) - 0xFFFFFFFFL;
                l2 = l3 + l;
            } else {
                hfsRequest18Result = -14;
                hfsState = 4;
                return;
            }
            if (l2 < 0L || l3 < l2) {
                hfsRequest18Result = -25;
                hfsState = 4;
                return;
            }
            MC68060.mmuWriteLongData(n2 + 6, (int)l2, XEiJ.regSRS);
            hfsRequest18Result = (int)l2;
            hfsState = 4;
        }

        public void hfuCallFiledate() throws M68kException {
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            int n = hfsRequest22Fcb;
            int n2 = hfsRequest18Param;
            if (n2 == 0) {
                n2 = MC68060.mmuReadWordZeroData(n + 60, XEiJ.regSRS) << 16 | MC68060.mmuReadWordZeroData(n + 58, XEiJ.regSRS);
            } else {
                int n3 = n2 & 0xFFFF;
                int n4 = n2 >>> 16;
                MC68060.mmuWriteWordData(n + 58, n3, XEiJ.regSRS);
                MC68060.mmuWriteWordData(n + 60, n4, XEiJ.regSRS);
                byte by = MC68060.mmuModifyByteSignData(n + 1, XEiJ.regSRS);
                if ((by & 0x40) != 0) {
                    MC68060.mmuWriteByteData(n + 1, by & 0xFFFFFFBF, XEiJ.regSRS);
                }
            }
            hfsRequest18Result = n2;
            hfsState = 4;
        }

        public void hfuCallDskfre() throws M68kException {
            if (!this.abuInserted) {
                hfsRequest3Error = 12290;
                hfsRequest18Result = -1;
                hfsState = 4;
                return;
            }
            hfsRequest18Result = 0;
            hfsState = 2;
        }

        public void hfuCallDskfreHost() {
            File file = new File(this.hfuRootPath);
            this.hfuTargetTotalSpace = file.getTotalSpace();
            this.hfuTargetFreeSpace = file.getFreeSpace();
            hfsRequest18Result = 0;
            hfsState = 1;
        }

        public void hfuCallDskfreX68k() throws M68kException {
            int n = (int)Math.min(Integer.MAX_VALUE, this.hfuTargetTotalSpace);
            int n2 = (int)Math.min(Integer.MAX_VALUE, this.hfuTargetFreeSpace);
            int n3 = Math.max(0, 7 - Integer.numberOfLeadingZeros(n));
            MC68060.mmuWriteWordData(hfsRequest14Namests, n2 >>> n3 + 10, XEiJ.regSRS);
            MC68060.mmuWriteWordData(hfsRequest14Namests + 2, n >>> n3 + 10, XEiJ.regSRS);
            MC68060.mmuWriteWordData(hfsRequest14Namests + 4, 1 << n3, XEiJ.regSRS);
            MC68060.mmuWriteWordData(hfsRequest14Namests + 6, 1024, XEiJ.regSRS);
            hfsRequest18Result = n2;
            hfsState = 4;
        }

        public void hfuCallDrvctrl() throws M68kException {
            switch (hfsRequest13Mode) {
                case 1: {
                    if (!this.hfuFcbToHandle.isEmpty()) break;
                    this.eject();
                    break;
                }
                case 2: {
                    this.prevent();
                    break;
                }
                case 3: {
                    if (!this.hfuFcbToHandle.isEmpty()) break;
                    this.allow();
                }
            }
            MC68060.mmuWriteByteData(hfsRequestHeader + 13, (this.abuInserted ? 2 : 0) | (this.abuWriteProtected ? 8 : 0) | (this.abuBuffered ? 32 : 0) | (this.abuEjectPrevented ? 64 : 0), XEiJ.regSRS);
            hfsRequest18Result = 0;
            hfsState = 4;
        }

        public void hfuCallGetdpb() throws M68kException {
            MC68060.mmuWriteLongData(hfsRequest14Namests, 0, XEiJ.regSRS);
            MC68060.mmuWriteLongData(hfsRequest14Namests + 4, 0, XEiJ.regSRS);
            MC68060.mmuWriteLongData(hfsRequest14Namests + 8, 0, XEiJ.regSRS);
            MC68060.mmuWriteLongData(hfsRequest14Namests + 12, 0, XEiJ.regSRS);
            hfsRequest18Result = 0;
            hfsState = 4;
        }

        public void hfuCallDiskred() throws M68kException {
            int n = hfsRequest18Param << 10;
            for (int i = 0; i < n; i += 4) {
                MC68060.mmuWriteLongData(hfsRequest14Namests + i, 0, XEiJ.regSRS);
            }
            hfsRequest18Result = 0;
            hfsState = 4;
        }

        public void hfuCallDiskwrt() throws M68kException {
            hfsRequest18Result = 0;
            hfsState = 4;
        }

        public void hfuCallSpecialCtrl() throws M68kException {
            hfsRequest18Result = -17;
            hfsState = 4;
        }

        public void hfuCallFflush() throws M68kException {
            hfsRequest18Result = 0;
            hfsState = 2;
        }

        public void hfuCallFflushHost() {
            for (HFHandle hFHandle : this.hfuFcbToHandle.values()) {
                if (hFHandle.hfhDirty) {
                    RandomAccessFile randomAccessFile = hFHandle.hfhRaf;
                    try {
                        randomAccessFile.seek(hFHandle.hfhStart);
                    }
                    catch (IOException iOException) {
                        System.out.println((Multilingual.mlnJapanese ? "\u30b7\u30fc\u30af\u30a8\u30e9\u30fc: " : "Seek error: ") + hFHandle.toString());
                    }
                    try {
                        randomAccessFile.write(hFHandle.hfhBuffer, 0, (int)(hFHandle.hfhEnd - hFHandle.hfhStart));
                    }
                    catch (IOException iOException) {
                        System.out.println((Multilingual.mlnJapanese ? "\u9045\u5ef6\u66f8\u304d\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f: " : "Delayed write failed: ") + hFHandle.toString());
                    }
                    hFHandle.hfhDirty = false;
                }
                hFHandle.hfhStart = 0L;
                hFHandle.hfhEnd = 0L;
            }
            hfsRequest18Result = 0;
            hfsState = 4;
        }

        public void hfuCallMediacheck() throws M68kException {
            hfsRequest18Result = this.hasBeenEjected() ? -1 : 0;
            hfsState = 4;
        }

        public void hfuCallLock() throws M68kException {
            hfsRequest18Result = -1;
            hfsState = 4;
        }

        private void hfuFileInfo(File file, byte[] byArray) {
            byArray[0] = (byte)((file.isFile() ? 32 : 0) | (file.isDirectory() ? 16 : 0) | (file.isHidden() ? 2 : 0) | (!file.canWrite() ? 1 : 0));
            long l = DnT.dntDttmCmil(file.lastModified() + RP5C15.rtcCmilGap);
            int n = DnT.dntHourDttm(l) << 11 | DnT.dntMinuDttm(l) << 5 | DnT.dntSecoDttm(l) >> 1;
            byArray[1] = (byte)(n >> 8);
            byArray[2] = (byte)n;
            int n2 = DnT.dntYearDttm(l) - 1980 << 9 | DnT.dntMontDttm(l) << 5 | DnT.dntMdayDttm(l);
            byArray[3] = (byte)(n2 >> 8);
            byArray[4] = (byte)n2;
            int n3 = (int)Math.min(0xFFFFFFFFL, file.length());
            byArray[5] = (byte)(n3 >> 24);
            byArray[6] = (byte)(n3 >> 16);
            byArray[7] = (byte)(n3 >> 8);
            byArray[8] = (byte)n3;
        }

        public void hfuPrintFileInfo(byte[] byArray) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            int n2 = byArray[0] & 0xFF;
            stringBuilder.append((n2 & 0x80) != 0 ? (char)'e' : '-');
            stringBuilder.append((n2 & 0x40) != 0 ? (char)'l' : '-');
            stringBuilder.append((n2 & 0x20) != 0 ? (char)'a' : '-');
            stringBuilder.append((n2 & 0x10) != 0 ? (char)'d' : '-');
            stringBuilder.append((n2 & 8) != 0 ? (char)'v' : '-');
            stringBuilder.append((n2 & 4) != 0 ? (char)'s' : '-');
            stringBuilder.append((n2 & 2) != 0 ? (char)'h' : '-');
            stringBuilder.append((n2 & 1) != 0 ? (char)'r' : '-');
            stringBuilder.append("  ");
            char c = (char)(byArray[3] << 8 | byArray[4] & 0xFF);
            XEiJ.fmtSB02u(XEiJ.fmtSB02u(XEiJ.fmtSB04u(stringBuilder, (c >>> 9) + 1980).append('-'), c >>> 5 & 0xF).append('-'), c & 0x1F);
            stringBuilder.append("  ");
            char c2 = (char)(byArray[1] << 8 | byArray[2] & 0xFF);
            XEiJ.fmtSB02u(XEiJ.fmtSB02u(XEiJ.fmtSB02u(stringBuilder, c2 >>> 11).append(':'), c2 >>> 5 & 0x3F).append(':'), c2 << 1 & 0x3F);
            stringBuilder.append("  ");
            if ((n2 & 0x10) != 0) {
                stringBuilder.append("     <dir>");
            } else if ((n2 & 8) != 0) {
                stringBuilder.append("     <vol>");
            } else {
                n = (byArray[5] << 8 | byArray[6] & 0xFF) << 16 | (char)(byArray[7] << 8 | byArray[8] & 0xFF);
                XEiJ.fmtSBnd(stringBuilder, 10, n);
            }
            stringBuilder.append("  ");
            n = byArray.length;
            for (int i = 9; i < n; ++i) {
                int n3;
                int n4 = byArray[i] & 0xFF;
                if (129 <= n4 && n4 <= 159 || 224 <= n4 && n4 <= 239) {
                    int n5;
                    int n6 = n5 = i + 1 < n ? byArray[i + 1] & 0xFF : 0;
                    if (64 <= n5 && n5 != 127 && n5 <= 252) {
                        n3 = CharacterCode.chrSJISToChar[n4 << 8 | n5];
                        if (n3 == 0) {
                            n3 = 8251;
                        }
                        ++i;
                    } else {
                        n3 = 46;
                    }
                } else {
                    n3 = CharacterCode.chrSJISToChar[n4];
                    if (n3 < 32 || n3 == 127) {
                        n3 = 46;
                    }
                }
                stringBuilder.append((char)n3);
            }
            System.out.println(stringBuilder.toString());
        }

        private String hfuNamestsToPath(int n) throws M68kException {
            byte[] byArray = new byte[88];
            MC68060.mmuReadByteArray(n, byArray, 0, 88, XEiJ.regSRS);
            return this.hfuNamestsToPath(byArray, true);
        }

        private String hfuNamestsToPath(int n, boolean bl) throws M68kException {
            byte[] byArray = new byte[88];
            MC68060.mmuReadByteArray(n, byArray, 0, 88, XEiJ.regSRS);
            return this.hfuNamestsToPath(byArray, bl);
        }

        private String hfuNamestsToPath(byte[] byArray, boolean bl) throws M68kException {
            byte[] byArray2 = new byte[88];
            int n = 0;
            int n2 = 2;
            while (n2 < 67) {
                while (n2 < 67 && byArray[n2] == 9) {
                    ++n2;
                }
                if (n2 >= 67 || byArray[n2] == 0) break;
                byArray2[n++] = 47;
                while (n2 < 67 && byArray[n2] != 0 && byArray[n2] != 9) {
                    byArray2[n++] = byArray[n2];
                    ++n2;
                }
            }
            if (bl) {
                byArray2[n++] = 47;
                for (n2 = 67; n2 < 75; ++n2) {
                    byArray2[n++] = byArray[n2];
                }
                for (n2 = 78; n2 < 88; ++n2) {
                    byArray2[n++] = byArray[n2];
                }
                while (n > 0 && byArray2[n - 1] == 0) {
                    --n;
                }
                while (n > 0 && byArray2[n - 1] == 32) {
                    --n;
                }
                byArray2[n++] = 46;
                for (n2 = 75; n2 < 78; ++n2) {
                    byArray2[n++] = byArray[n2];
                }
                while (n > 0 && byArray2[n - 1] == 32) {
                    --n;
                }
                while (n > 0 && byArray2[n - 1] == 46) {
                    --n;
                }
            }
            StringBuilder stringBuilder = new StringBuilder(this.hfuRootPath);
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n; ++i) {
                char c;
                int n5 = byArray2[i] & 0xFF;
                if (n3 != 0 && 64 <= n5 && n5 != 127 && n5 <= 252) {
                    c = CharacterCode.chrSJISToChar[n3 << 8 | n5];
                    if (c != '\u0000') {
                        stringBuilder.append(c);
                    } else {
                        XEiJ.fmtHex2(XEiJ.fmtHex2(stringBuilder.append('%'), n3).append('%'), n5);
                    }
                    n3 = 0;
                    n4 |= 2;
                    continue;
                }
                if (n3 != 0) {
                    XEiJ.fmtHex2(stringBuilder.append('%'), n3);
                    n3 = 0;
                }
                if (129 <= n5 && n5 <= 159 || 224 <= n5 && n5 <= 239) {
                    n3 = n5;
                    continue;
                }
                c = CharacterCode.chrSJISToChar[n5];
                if (' ' <= c && c != '\u007f') {
                    stringBuilder.append(c);
                } else {
                    XEiJ.fmtHex2(stringBuilder.append('%'), n5);
                }
                if (c == '/') {
                    if (n4 == 1) {
                        return null;
                    }
                    n4 = 0;
                    continue;
                }
                if (c == '.') {
                    n4 |= 1;
                    continue;
                }
                n4 |= 2;
            }
            if (n3 != 0) {
                XEiJ.fmtHex2(stringBuilder.append('%'), n3);
            }
            if (n4 == 1) {
                return null;
            }
            return stringBuilder.toString();
        }

        public class HFHandle {
            public int hfhFcb;
            public File hfhFile;
            public RandomAccessFile hfhRaf;
            public byte[] hfhBuffer;
            public long hfhStart;
            public long hfhEnd;
            public boolean hfhDirty;

            public HFHandle(HFUnit hFUnit, int n, File file, RandomAccessFile randomAccessFile) {
                Objects.requireNonNull(hFUnit);
                this.hfhFcb = n;
                this.hfhFile = file;
                this.hfhRaf = randomAccessFile;
                this.hfhBuffer = new byte[65536];
                this.hfhStart = 0L;
                this.hfhEnd = 0L;
                this.hfhDirty = false;
            }

            public String toString() {
                return String.format("HFHandle{fcb:0x%08x,file:\"%s\",start:%d,end:%d,dirty:%b}", this.hfhFcb, this.hfhFile.toString(), this.hfhStart, this.hfhEnd, this.hfhDirty);
            }
        }
    }
}

