/*
 * Decompiled with CFR 0.152.
 */
package xeij;

public final class ByteQueue {
    private static final boolean DEBUG = false;
    private static final boolean TEST = false;
    private volatile Block newest;
    private volatile Block oldest;
    private static final int size = Integer.MAX_VALUE;
    private volatile int wcnt;
    private volatile int rcnt;
    private volatile Thread waitThread;

    public ByteQueue() {
        this.oldest = this.newest = new Block();
        this.wcnt = 0;
        this.rcnt = 0;
        this.waitThread = null;
    }

    public final int clear() {
        return this.skip(this.wcnt - this.rcnt);
    }

    public final int read() {
        int n = -1;
        if (0 < this.wcnt - this.rcnt) {
            n = this.oldest.read();
            if (n < 0) {
                Block block = this.oldest.newer;
                block.older = null;
                this.oldest.newer = null;
                this.oldest = block;
                n = this.oldest.read();
            }
            ++this.rcnt;
        }
        return n;
    }

    public final int read(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("length=%d", n2));
        }
        if (0 < (n2 = Math.min(n2, this.wcnt - this.rcnt))) {
            int n3 = n;
            int n4 = n2;
            int n5 = this.oldest.read(byArray, n3, n4);
            n3 += n5;
            n4 -= n5;
            while (0 < n4) {
                Block block = this.oldest.newer;
                block.older = null;
                this.oldest.newer = null;
                this.oldest = block;
                n5 = this.oldest.read(byArray, n3, n4);
                n3 += n5;
                n4 -= n5;
            }
            this.rcnt += n2;
        }
        return n2;
    }

    public final int skip(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.format("length=%d", n));
        }
        if (0 < (n = Math.min(n, this.wcnt - this.rcnt))) {
            int n2 = n;
            int n3 = this.oldest.skip(n2);
            n2 -= n3;
            while (0 < n2) {
                Block block = this.oldest.newer;
                block.older = null;
                this.oldest.newer = null;
                this.oldest = block;
                n3 = this.oldest.skip(n2);
                n2 -= n3;
            }
            this.rcnt += n;
        }
        return n;
    }

    public final int unused() {
        return Integer.MAX_VALUE - (this.wcnt - this.rcnt);
    }

    public final int used() {
        return this.wcnt - this.rcnt;
    }

    public final int write(int n) {
        Object object;
        int n2 = 0;
        if (this.wcnt - this.rcnt < Integer.MAX_VALUE) {
            n2 = this.newest.write(n);
            if (n2 == 0) {
                object = new Block();
                ((Block)object).older = this.newest;
                this.newest.newer = object;
                this.newest = object;
                n2 = this.newest.write(n);
            }
            this.wcnt += n2;
        }
        if ((object = this.waitThread) != null) {
            ((Thread)object).interrupt();
        }
        return n2;
    }

    public final int write(byte[] byArray, int n, int n2) {
        if (0 < (n2 = Math.min(n2, Integer.MAX_VALUE - (this.wcnt - this.rcnt)))) {
            Object object;
            int n3 = n;
            int n4 = n2;
            int n5 = this.newest.write(byArray, n3, n4);
            n3 += n5;
            n4 -= n5;
            while (0 < n4) {
                object = new Block();
                ((Block)object).older = this.newest;
                this.newest.newer = object;
                this.newest = object;
                n5 = this.newest.write(byArray, n3, n4);
                n3 += n5;
                n4 -= n5;
            }
            this.wcnt += n2;
            object = this.waitThread;
            if (object != null) {
                ((Thread)object).interrupt();
            }
        }
        return n2;
    }

    public final void cancel() {
        Thread thread = this.waitThread;
        if (thread != null) {
            this.waitThread = null;
            thread.interrupt();
        }
    }

    public final int waitAndRead() {
        int n = -1;
        this.waitThread = Thread.currentThread();
        while (this.waitThread != null && 0 > (n = this.read()) && this.waitThread != null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.waitThread = null;
        return n;
    }

    public final int waitAndRead(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException(String.format("length=%d", n2));
        }
        if (0 < n2) {
            int n3 = this.waitAndRead();
            if (n3 < 0) {
                n2 = -1;
            } else {
                byArray[n] = (byte)n3;
                n2 = 1 + this.read(byArray, n + 1, n2 - 1);
            }
        }
        return n2;
    }

    private static final class Block {
        private volatile Block newer = null;
        private volatile Block older = null;
        private static final int size = 65536;
        private final byte[] buff = new byte[65536];
        private volatile int wcnt = 0;
        private volatile int rcnt = 0;

        private Block() {
        }

        private final int clear() {
            int n = this.wcnt - this.rcnt;
            if (0 < n) {
                this.rcnt += n;
            }
            return n;
        }

        private final int read() {
            return this.wcnt - this.rcnt == 0 ? -1 : this.buff[this.rcnt++ & 0xFFFF] & 0xFF;
        }

        private final int read(byte[] byArray, int n, int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException(String.format("length=%d", n2));
            }
            if (0 < (n2 = Math.min(n2, this.wcnt - this.rcnt))) {
                int n3 = this.rcnt & 0xFFFF;
                int n4 = Math.min(n2, 65536 - n3);
                System.arraycopy(this.buff, n3, byArray, n, n4);
                if (n4 < n2) {
                    System.arraycopy(this.buff, 0, byArray, n + n4, n2 - n4);
                }
                this.rcnt += n2;
            }
            return n2;
        }

        private final int skip(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(String.format("length=%d", n));
            }
            if (0 < (n = Math.min(n, this.wcnt - this.rcnt))) {
                this.rcnt += n;
            }
            return n;
        }

        private final int unused() {
            return 65536 - (this.wcnt - this.rcnt);
        }

        private final int used() {
            return this.wcnt - this.rcnt;
        }

        private final int write(int n) {
            if (this.wcnt - this.rcnt == 65536) {
                return 0;
            }
            this.buff[this.wcnt++ & 0xFFFF] = (byte)n;
            return 1;
        }

        private final int write(byte[] byArray, int n, int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException(String.format("length=%d", n2));
            }
            if (0 < (n2 = Math.min(n2, 65536 - (this.wcnt - this.rcnt)))) {
                int n3 = this.wcnt & 0xFFFF;
                int n4 = Math.min(n2, 65536 - n3);
                System.arraycopy(byArray, n, this.buff, n3, n4);
                if (n4 < n2) {
                    System.arraycopy(byArray, n + n4, this.buff, 0, n2 - n4);
                }
                this.wcnt += n2;
            }
            return n2;
        }
    }
}

