/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import xeij.ComponentFactory;
import xeij.JFileChooser2;
import xeij.Multilingual;

public abstract class AbstractOpenDialog
extends JDialog
implements ActionListener {
    protected JFileChooser2 fileChooser;
    protected JCheckBox readOnlyCheckBox;
    protected JRadioButton rebootRadioButton;
    protected JRadioButton openRadioButton;
    protected boolean directory;
    protected boolean readOnly;
    protected boolean reboot;

    public AbstractOpenDialog(Frame frame, String string, String string2, boolean bl, FileFilter fileFilter) {
        super(frame, string, true);
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(1);
        this.setAlwaysOnTop(true);
        this.setLocationByPlatform(true);
        this.setDefaultCloseOperation(1);
        Multilingual.mlnTitle(this, "ja", string2);
        this.directory = bl;
        this.fileChooser = new JFileChooser2();
        this.fileChooser.setMultiSelectionEnabled(true);
        this.fileChooser.setControlButtonsAreShown(false);
        this.fileChooser.setFileFilter(fileFilter);
        this.fileChooser.addActionListener(this);
        ButtonGroup buttonGroup = new ButtonGroup();
        JComponent[] jComponentArray = new JComponent[1];
        Component[] componentArray = new Component[3];
        componentArray[0] = this.fileChooser;
        Component[] componentArray2 = new Component[12];
        componentArray2[0] = Box.createHorizontalStrut(12);
        componentArray2[1] = Box.createHorizontalGlue();
        this.readOnlyCheckBox = Multilingual.mlnText(ComponentFactory.createCheckBox(this.readOnly, "Read-only", this), "ja", "\u66f8\u304d\u8fbc\u307f\u7981\u6b62");
        componentArray2[2] = this.readOnlyCheckBox;
        componentArray2[3] = Box.createHorizontalGlue();
        this.rebootRadioButton = ComponentFactory.setFixedSize(ComponentFactory.setText(ComponentFactory.createRadioButton(buttonGroup, this.reboot, "approve reboot", this), ""), 20, 20);
        componentArray2[4] = this.rebootRadioButton;
        componentArray2[5] = Multilingual.mlnText(ComponentFactory.createButton("Reboot from it", 82, (ActionListener)this), "ja", "\u3053\u3053\u304b\u3089\u518d\u8d77\u52d5");
        componentArray2[6] = Box.createHorizontalStrut(12);
        this.openRadioButton = ComponentFactory.setFixedSize(ComponentFactory.setText(ComponentFactory.createRadioButton(buttonGroup, !this.reboot, "approve open", this), ""), 20, 20);
        componentArray2[7] = this.openRadioButton;
        componentArray2[8] = Multilingual.mlnText(ComponentFactory.createButton("Open", 79, (ActionListener)this), "ja", "\u958b\u304f");
        componentArray2[9] = Box.createHorizontalStrut(20);
        componentArray2[10] = Multilingual.mlnText(ComponentFactory.createButton("Cancel", 67, (ActionListener)this), "ja", "\u30ad\u30e3\u30f3\u30bb\u30eb");
        componentArray2[11] = Box.createHorizontalStrut(12);
        componentArray[1] = ComponentFactory.createHorizontalBox(componentArray2);
        componentArray[2] = Box.createVerticalStrut(12);
        jComponentArray[0] = ComponentFactory.createVerticalBox(componentArray);
        JPanel jPanel = ComponentFactory.createBorderPanel(0, 0, jComponentArray);
        this.getContentPane().add((Component)jPanel, "Center");
        this.pack();
        this.setVisible(false);
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
        if (this.readOnlyCheckBox != null) {
            this.readOnlyCheckBox.setSelected(bl);
        }
    }

    public boolean getReboot() {
        return this.reboot;
    }

    public void setReboot(boolean bl) {
        this.reboot = bl;
        if (bl) {
            if (this.rebootRadioButton != null) {
                this.rebootRadioButton.setSelected(true);
            }
        } else if (this.openRadioButton != null) {
            this.openRadioButton.setSelected(true);
        }
    }

    public void addHistory(File[] fileArray) {
        this.fileChooser.addHistory(fileArray);
        this.fileChooser.selectLastFiles();
    }

    public ArrayList<String> getHistory() {
        return this.fileChooser.getHistory();
    }

    public void rescanCurrentDirectory() {
        this.fileChooser.rescanCurrentDirectory();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        switch (actionEvent.getActionCommand()) {
            case "ApproveSelection": {
                this.approve(this.reboot);
                break;
            }
            case "Read-only": {
                this.readOnly = ((JCheckBox)actionEvent.getSource()).isSelected();
                break;
            }
            case "approve reboot": {
                this.reboot = true;
                break;
            }
            case "Reboot from it": {
                this.approve(true);
                break;
            }
            case "approve open": {
                this.reboot = false;
                break;
            }
            case "Open": {
                this.approve(false);
                break;
            }
            case "CancelSelection": 
            case "Cancel": {
                this.setVisible(false);
            }
        }
    }

    protected void approve(boolean bl) {
        File[] fileArray = this.fileChooser.getSelectedFiles();
        if (fileArray.length == 0 && this.directory) {
            fileArray = new File[]{this.fileChooser.getCurrentDirectory()};
        }
        if (0 < fileArray.length) {
            this.openFiles(fileArray, bl);
            this.setVisible(false);
        }
    }

    public abstract void openFiles(File[] var1, boolean var2);
}

