	.include	t00iocs.equ
	.include	t01dos.equ
	.include	t02const.equ
	.include	t08debug.equ
	.include	t09version.equ

;__DEBUG__	equ	1

;__USE_DISPLACMENT__	equ	1

	.cpu	68060

  .ifdef __USE_DISPLACEMENT__
r	reg	-deviceHeader.w(a4)	;t10head.sɂ郉xȊOɂ͎gȂ
  .else
r	reg	-0
  .endif

;----------------------------------------------------------------
;풓̖
keepTail::

;----------------------------------------------------------------
;foCX
deviceInitialize::
	movem.l	d1-d7/a0-a4/a6,-(sp)
  .ifdef __USE_DISPLACEMENT__
	lea.l	deviceHeader,a4
  .endif
  debug 'device initialize start',0

	lea.l	(banner,pc),a1
	bsr	print

;----------------------------------------------------------------
;MPU,Humañ`FbN
	bsr	mpuCheck
	bmi	deviceInitializeError
	bsr	humanCheck
	bmi	deviceInitializeError
  debug 'MPU,ROM,Human check ok',0

;----------------------------------------------------------------
;f[^LbVOFF̂ƂLbVvbVɖ
	cmpi.b	#4,$0CBC.w
	blo	99f
	movec.l	cacr,d0
	btst.l	#CACR_EDC_BIT,d0
	bne	@f
	cinva	dc
@@:	cinva	ic
99:

;----------------------------------------------------------------
;store/load bypass@\𖳌ɂ
	cmpi.b	#6,$0CBC.w
	bne	10f
	movec.l	pcr,d0
	bset.l	#5,d0			;disable store/load bypass
	movec.l	d0,pcr
10:

;----------------------------------------------------------------
;[J̗eʃ`FbN
	bsr	getLocalMemorySize
	move.l	d0,(localMemorySize)r
	move.l	d1,(localMemoryStart)r
	add.l	d0,d1
	move.l	d1,(localMemoryEnd)r
  debug 'local memory size checked',0

;----------------------------------------------------------------
;Ǘ͈̈̔͂̏
	move.l	#keepTail,d0
	add.l	#$00001FFF,d0		;mainLowerStart̓y[WTCYɍ킹
	and.l	#$FFFFE000,d0
	move.l	d0,(mainLowerStart)r
	move.l	d0,(mainLowerEnd)r
	move.l	$1C00.w,d0
	and.l	#$FFFFE000,d0
	move.l	d0,(mainUpperStart)r
	move.l	d0,(mainUpperEnd)r
	tst.l	(localMemorySize)r
	beq	@f
	move.l	(localMemoryStart)r,d0
	move.l	d0,(localLowerStart)r
	move.l	d0,(localLowerEnd)r
	move.l	(localMemoryEnd)r,d0
	move.l	d0,(localUpperStart)r
	move.l	d0,(localUpperEnd)r
@@:
  debug 'management area set',0

;----------------------------------------------------------------
;]obt@̗̈̏
	clr.l	(tempBufferSize)r
  debug 'temporary buffer vanished',0

;----------------------------------------------------------------
;CRAMDISK̗̈̏
	move.l	(mainUpperStart)r,d0
	move.l	d0,(mainRamdiskAreaStart)r
	move.l	d0,(mainRamdiskAreaEnd)r
	clr.l	(mainRamdiskAreaSize)r
  debug 'main RAMDISK vanished',0

;[JRAMDISK̗̈̏
	move.l	(localLowerStart)r,d0
	move.l	d0,(localRamdiskAreaStart)r
	move.l	d0,(localRamdiskAreaEnd)r
	clr.l	(localRamdiskAreaSize)r
  debug 'local RAMDISK vanished',0

;----------------------------------------------------------------
;C̃TCY̏
	move.l	#-1,(mainMemorySize)r
  debug 'main memory size initialized',0

;----------------------------------------------------------------
;p[^̉
;	mainLowerg
;		tempBuffer
;		dosBusErr
;	mainUpperg
;		mainRamdiskArea
;		descArea
;	localLowerg
;		localRamdiskArea
;	localLowerlocalUpper̊ԂhimemArea
;	localUpperg
;		localRom
;		descArea
  debug 'parameter check start',0
;68030̂Ƃ-ntIɎw肷
	cmpi.b	#3,$0CBC.w
	bhi	@f
	st.b	(noTranslation)r
@@:
	movea.l	(18,a5),a6		;p[^̃AhX
1:	tst.b	(a6)+
	bne	1b
	tst.b	(a6)
	beq	2f
	movea.l	a6,a0
	bsr	getParam
	bra	1b
2:
  debug 'parameter check end',0

;----------------------------------------------------------------
;fXNv^̗̈̃TCY肷
;	-ts̎w肪΂̂܂
;	-ts̎w肪0ɂȂĂ̂łŐݒ肳
	tst.b	(noTranslation)r
	bne	99f
	bsr	defaultDescAreaSize
  debug 'desc area size set',0
99:

;----------------------------------------------------------------
;CRAMDISK̗̈y[WTCY̔{܂Ő؂艺
	move.l	(mainRamdiskAreaStart)r,d0
	and.l	(pageMask)r,d0
	move.l	d0,(mainRamdiskAreaStart)r
	move.l	d0,(mainUpperStart)r
  debug 'main RAMDISK area resized',0

;----------------------------------------------------------------
;]obt@̊m
	tst.l	(tempBufferSize)r
	bne	@f
	move.l	#DEFAULT_BUFFER_SIZE,d0	;]obt@̓y[WTCY̔{ɂ邱
	move.l	d0,(tempBufferSize)r
	move.l	(mainLowerEnd)r,d1
	add.l	#$00001FFF,d1		;]obt@̓y[Wʒuɍ킹
	and.l	#$FFFFE000,d1
	move.l	d1,(tempBufferStart)r
	add.l	d0,d1
	move.l	d1,(tempBufferEnd)r
	move.l	d1,(mainLowerEnd)r
	move.l	(mainUpperStart)r,d0
	sub.l	d1,d0
	cmp.l	#128*1024,d0
	blt	tempBufferOver
@@:

;----------------------------------------------------------------
;ADPCM]obt@̊mۂƏ
	tst.b	(patchIocsAdpcm)r
	beq	@f
	move.l	(adpcmBufferSize)r,d0	;ݒς
	move.l	(mainLowerEnd)r,d1
	add.l	#$00001FFF,d1		;]obt@̓y[Wʒuɍ킹
	and.l	#$FFFFE000,d1
	move.l	d1,(adpcmBufferStart)r
	move.l	d1,(adpcmBufferPtr0)r
	add.l	d0,d1
	move.l	d1,(adpcmBufferPtr1)r
	add.l	d0,d1
	move.l	d1,(adpcmBufferEnd)r
	add.l	#$00001FFF,d1		;]obt@̓y[Wʒuɍ킹
	and.l	#$FFFFE000,d1
	move.l	d1,(mainLowerEnd)r
	bsr	dmac3Initialize
;1y[WȂ̂Ńs`FbN͏ȗ
@@:

;----------------------------------------------------------------
;_BUS_ERRp̉̃xN^e[uƉ̃X[p[oCUX^bN̗̈mۂ
	move.l	(mainLowerEnd)r,d0
	move.l	d0,(dosBusErrVbr)r
	add.l	#1024+1024,d0		;2KBȂ̂Ńs`FbN͏ȗ
	move.l	d0,(dosBusErrSsp)r
	move.l	d0,(mainLowerEnd)r

;----------------------------------------------------------------
;[JRAMDISK̗̈y[WTCY̔{܂Ő؂グ
	move.l	(localRamdiskAreaEnd)r,d0
	add.l	(pageOffsetMask)r,d0
*****pageMaskŃ}XNƘ_AhXԂ̖0ɂȂĂ܂
*****	and.l	(pageMask)r,d0
	and.w	(pageMask+2)r,d0
	move.l	d0,(localRamdiskAreaEnd)r
	move.l	d0,(localLowerEnd)r
  debug 'local RAMDISK area resized',0

;----------------------------------------------------------------
;[JROMRs[
	tst.b	(noTranslation)r
	bne	99f
	tst.b	(localRomArea)r
	beq	2f
	movea.l	#$00F00000,a1
	movea.l	(localRomStart)r,a0
1:	move16	(a1)+,(a0)+
	cmpa.l	#$01000000,a1
	blo	1b
	movea.l	(localRomStart)r,a0
	add.l	#$00FF0000-$00F00000,a0
	move.l	#'loca',(a0)+
	move.l	#'lRom',(a0)+

;ROMVER=$15970213̃oOC
	IOCS	_ROMVER
	cmp.l	#$15970213,d0
	bne	9f
	movea.l	(localRomStart)r,a0
	add.l	#$00FFB32C-$00F00000,a0
	cmpi.l	#$4A75002A,(a0)
	bne	@f
	move.l	#$4A75042A,(a0)
@@:
	move.b	#$08,DCR2
	move.b	#$05,MFC2
	move.b	#$03,CPR2
	move.b	#$05,DFC2
;	move.b	#$05,BFC2
;	move.b	#$68,NIV2
;	move.b	#$69,EIV2
9:

;ROMVER=$15970529̃oOC
	IOCS	_ROMVER
	cmp.l	#$15970529,d0
	bne	9f
;\tgL[{[h\ĂԂŃL[ƃnOAbvoOC
	movea.l	(localRomStart)r,a0
	add.l	#$00FF5004-$00F00000,a0
	cmpi.w	#$2057,(a0)		;movea.l (sp),a0
	bne	@f
	move.w	#$205F,(a0)		;movea.l (sp)+,a0
@@:
9:

;SCSIDMA]PACKĂ݂(700KB500KBƁAĒxȂ炵)
;	IOCS	_ROMVER
;	cmp.l	#$14970107,d0
;	bne	@f
;	movea.l	(localRomStart)r,a0
;	add.l	#$00FFDE60-$00F00000,a0
;	cmpi.w	#$80B1,(a0)
;	bne	@f
;	move.w	#$8081,(a0)
;@@:
	bsr	cache_flush
2:
  debug 'local ROM area set',0
99:

;----------------------------------------------------------------
;fXNv^̗̈̊m
	tst.b	(noTranslation)r
	bne	99f
	tst.b	(localAreaDescriptor)r
	beq	1f
	move.l	(localUpperStart)r,d0
	sub.l	(descAreaSize)r,d0
	and.l	(pageMask)r,d0
	cmp.l	(localLowerEnd)r,d0
	bcc	2f
	sf.b	(localAreaDescriptor)r
;Cɍ
1:	move.l	(mainUpperStart)r,d0
	sub.l	(descAreaSize)r,d0
	and.l	(pageMask)r,d0
	move.l	(mainLowerEnd)r,d1
	add.l	#128*1024,d1
	cmp.l	d1,d0
	blt	descAreaOver
	move.l	d0,(mainUpperStart)r
	bra	3f
;[Jɍ
2:	move.l	d0,(localUpperStart)r
3:	move.l	d0,(descAreaStart)r
	add.l	(descAreaSize)r,d0
	move.l	d0,(descAreaEnd)r
  debug 'descriptor area allocated',0
99:

;----------------------------------------------------------------
;_HIMEM̗̈ݒ
	clr.l	(himemAreaStart)r
	clr.l	(himemAreaEnd)r
	clr.l	(himemAreaSize)r
	tst.l	(localMemorySize)r
	beq	2f
	move.l	(localLowerEnd)r,d1
	move.l	(localUpperStart)r,d2
	move.l	d2,d0
	sub.l	d1,d0
	bls	2f			;HIMEMɋ󂫃GAȂ
	move.l	d0,(himemAreaSize)r
	move.l	d1,(himemAreaStart)r
	move.l	d2,(himemAreaEnd)r
	movea.l	d1,a0
	lea.l	(User,a0),a1
;;;	cmpi.l	#'060t',(a1)
;;;	beq	2f			;Ă
	move.l	#'060t',(a1)+
	move.l	#'urbo',(a1)+
	move.l	#'HIME',(a1)+
	move.l	#'M'<<24,(a1)+
	clr.l	(Prev,a0)
	move.l	$1C20.w,(Proc,a0)	;HumañǗ|C^
	move.l	a1,(Tail,a0)
	clr.l	(Next,a0)
2:
  debug 'HIMEM area initialized',0

;----------------------------------------------------------------
;XbhԂ̔r
	tst.b	(backgroundFlag)r
	beq	9f
;CXbh̔r
	lea.l	(mainExclusive)r,a2
;Wnh쐬
	moveq.l	#0,d2
1:	move.w	d2,-(sp)
	DOS	_DUP			;Wnh𕡐
	addq.l	#2,sp			;G[Ă͂ȂȂ
	move.w	d0,(xStdin,a2,d2.w*2)
	addq.w	#1,d2
	cmp.w	#5,d2
	blo	1b
;hCuǗe[ũAhXݒ肷
	move.l	$1C38.w,(xDriveTablePtr,a2)	;݂̃hCuǗe[u
9:

;----------------------------------------------------------------
;n
	DOS	_GETDATE
	move.l	d0,d1
	DOS	_GETTIME
	add.w	d1,d0
	swap.w	d1
	add.w	d1,d0
	move.l	d0,d1
	bsr	srand
	move.l	d1,d0
	bsr	randomize

;----------------------------------------------------------------
;
;	ȍ~͒fs
;
;----------------------------------------------------------------

;----------------------------------------------------------------
;HumanɃpb`Ă
	tst.b	(unitCounter)r		;RAMDISKȂ,
	bne	@f			;RAMDISK̃`FbN͖ӖȂ̂ŏȗ
	move.l	#callDeviceNoRamdisk,patchHumanCallDevice+2
@@:
	bsr	patchHuman
	bmi	deviceInitializeError
  debug 'Human68k patched',0

;----------------------------------------------------------------
;C؂l߂
	move.l	(mainUpperStart)r,$1C00.w
  debug 'main memory resized',0

;----------------------------------------------------------------
;AhXϊe[u
	tst.b	(noTranslation)r
	bne	99f
	bsr	makeTranslationTable
  debug 'address translation table created',0
99:

;----------------------------------------------------------------
;xN^ݒ
	move.b	(localRomArea)r,d0
	or.b	(localSystemArea)r,d0
	beq	@f
	lea.l	(vectorInfoHumanTrap10)r,a0
	bsr	setVector
  debug 'TRAP#10 vector set',0
@@:

	lea.l	(vectorInfoPRIVILEGE)r,a0
	bsr	setVector
	lea.l	(vectorInfoFLINE)r,a0
	bsr	setVector
	lea.l	(vectorInfoBSUN)r,a0
	bsr	setVector
	lea.l	(vectorInfoINEX)r,a0
	bsr	setVector
	lea.l	(vectorInfoDZ)r,a0
	bsr	setVector
	lea.l	(vectorInfoUNFL)r,a0
	bsr	setVector
	lea.l	(vectorInfoOPERR)r,a0
	bsr	setVector
	lea.l	(vectorInfoOVFL)r,a0
	bsr	setVector
	lea.l	(vectorInfoSNAN)r,a0
	bsr	setVector
	lea.l	(vectorInfoUNSUPP)r,a0
	bsr	setVector
	lea.l	(vectorInfoEFFADD)r,a0
	bsr	setVector
	lea.l	(vectorInfoUNINT)r,a0
	bsr	setVector
  debug '060SP vector set',0

	lea.l	(spBanner,pc),a1
	bsr	print

	tst.b	(patchIocsAdpcm)r
	beq	@f
	lea.l	(vectorInfoIocsAdpcmout)r,a0
	bsr	setVector
	lea.l	(vectorInfoIocsAdpcminp)r,a0
	bsr	setVector
	lea.l	(vectorInfoIocsAdpcmaot)r,a0
	bsr	setVector
	lea.l	(vectorInfoIocsAdpcmain)r,a0
	bsr	setVector
	lea.l	(vectorInfoIocsAdpcmlot)r,a0
	bsr	setVector
	lea.l	(vectorInfoIocsAdpcmlin)r,a0
	bsr	setVector
	lea.l	(vectorInfoIocsAdpcmsns)r,a0
	bsr	setVector
	lea.l	(vectorInfoIocsAdpcmmod)r,a0
	bsr	setVector
  debug 'IOCS ADPCM vector set',0
@@:

	tst.b	(softwareIocsDma)r
	beq	@f
	lea.l	(vectorInfoIocsDmamove)r,a0
	bsr	setVector
	lea.l	(vectorInfoIocsDmamovA)r,a0
	bsr	setVector
	lea.l	(vectorInfoIocsDmamovL)r,a0
	bsr	setVector
	lea.l	(vectorInfoIocsDmamode)r,a0
	bsr	setVector
  debug 'IOCS DMA vector set',0
@@:

	lea.l	(vectorInfoIocsSysStat)r,a0
	bsr	setVector
  debug 'SYS_STAT vector set',0

	cmpi.w	#_SCSIDRV*$0100+$00FF,$0400+_SCSIDRV*4.w
	beq	@f			;_SCSIDRV͓o^ĂȂ
	cmpi.w	#$00FF,$0400+_SCSIDRV*4.w
	beq	@f			;_SCSIDRV͓o^ĂȂ
	SCSI	_S_REVISION
	move.w	d0,(scsiRevisionCode)r
	lea.l	(vectorInfoIocsScsidrv)r,a0
	bsr	setVector
  debug 'SCSIDRV vector set',0
@@:

	lea.l	(vectorInfoIocsPrnintst)r,a0
	bsr	setVector
	lea.l	(vectorInfoPrnint)r,a0
	bsr	setVector
  debug 'PRNINTST vector set',0

	tst.b	(useIocsHimem)r
	beq	@f
	lea.l	(vectorInfoIocsHimem)r,a0
	bsr	setVector
  debug 'HIMEM vector set',0
@@:

	lea.l	(vectorInfoDosExec)r,a0
	bsr	setVector
  debug 'EXEC vector set',0

;	tst.b	(useJointMode)r
;	beq	@f
	lea.l	(vectorInfoDosMalloc)r,a0
	bsr	setVector
	lea.l	(vectorInfoDos0Malloc2)r,a0
	bsr	setVector
	lea.l	(vectorInfoDosMalloc2)r,a0
	bsr	setVector
	lea.l	(vectorInfoDos0Malloc3)r,a0
	bsr	setVector
	lea.l	(vectorInfoDosMalloc3)r,a0
	bsr	setVector
	lea.l	(vectorInfoDos0Malloc4)r,a0
	bsr	setVector
	lea.l	(vectorInfoDosMalloc4)r,a0
	bsr	setVector
	lea.l	(vectorInfoDosMfree)r,a0
	bsr	setVector
	lea.l	(vectorInfoDosSetblock)r,a0
	bsr	setVector
	lea.l	(vectorInfoDos0Setblock2)r,a0
	bsr	setVector
	lea.l	(vectorInfoDosSetblock2)r,a0
	bsr	setVector
	lea.l	(vectorInfoDos0SMalloc)r,a0
	bsr	setVector
	lea.l	(vectorInfoDosSMalloc)r,a0
	bsr	setVector
	lea.l	(vectorInfoDos0SMalloc2)r,a0
	bsr	setVector
	lea.l	(vectorInfoDosSMalloc2)r,a0
	bsr	setVector
	lea.l	(vectorInfoDos0SMfree)r,a0
	bsr	setVector
	lea.l	(vectorInfoDosSMfree)r,a0
	bsr	setVector
	lea.l	(vectorInfoDos0SProcess)r,a0
	bsr	setVector
	lea.l	(vectorInfoDosSProcess)r,a0
	bsr	setVector
  debug 'memory doscall vector set',0
@@:

	tst.b	(backgroundFlag)r
	beq	@f
	lea.l	(vectorInfoDosOpenPr)r,a0
	bsr	setVector
	lea.l	(vectorInfoDosKillPr)r,a0
	bsr	setVector
	lea.l	(vectorInfoDosChangePr)r,a0
	bsr	setVector
  debug 'background doscall vector set',0
@@:

;----------------------------------------------------------------
;AhXϊJn
	tst.b	(noTranslation)r
	bne	99f
	bsr	enableTranslation
  debug 'address translation enabled',0
99:

;----------------------------------------------------------------
;LbVȂǂ̏Ԃ
;EBC=1,ESB=1,ESS=1,EDC=0,EIC=0
;	f[^LbVƖ߃LbV̏Ԃ,
;	060turbo.sys̏IHumanɖ߂,
;	pb`ɂSRAM̐ݒɂȂ
	move.w	#$C007,d1
	moveq.l	#%11100,d2
	IOCS	_SYS_STAT
  debug 'branch cache, store buffer, superscaler enabled',0

;----------------------------------------------------------------
;xN^̈悩Human{̖̂܂ł060turbo.sys̏풓[JɈړ
	tst.b	(localSystemArea)r
	beq	9f
	PUSH_MMU_SFC_DFC	d0
	move.l	(localSystemStart)r,d3	;Rs[
	suba.l	a1,a1			;Rs[
1:	cmpa.l	#$0001447A.and.PAGE_MASK,a1	;Human{̖̂
	bne	@f
	move.l	#deviceHeader,d0	;060turbo.sys̐擪
	add.l	#PAGE_OFFSET_SIZE-1,d0
	and.l	#PAGE_MASK,d0
	movea.l	d0,a1
@@:
;
	bsr	getDesc
	move.l	d0,d2			;݂̃y[WfXNv^
	and.l	(pageOffsetMask)r,d2	;o
	or.l	d3,d2			;Rs[̃AhXg
	movea.l	d3,a2			;Rs[
	movea.l	a1,a3			;Rs[
	move.l	(pageOffsetSize)r,d0
	lsr.l	#4,d0
;荞݂~߂Ԃő}ŃRs[Ăɐ؂ւ
;Rs[̃AhXŃRs[悪悤ɂ
	PUSH_SR_DI
2:	move16	(a3)+,(a2)+
	subq.l	#1,d0
	bne	2b
	movea.l	d3,a2
	cpushp	bc,(a2)
	moves.l	d2,(a0)
	pflusha
	POP_SR
;Ô߃Rs[̃AhXŃRs[悤ɂĂ
	exg.l	d3,a1
	bsr	getDesc			;Rs[
	and.l	(pageOffsetMask)r,d2	;o
	or.l	d3,d2			;Rs[̃AhXg
	moves.l	d2,(a0)
	pflusha
	exg.l	d3,a1
;
	add.l	(pageOffsetSize)r,d3
	adda.l	(pageOffsetSize)r,a1
	cmp.l	(localSystemEnd)r,d3
	blo	1b
	POP_SFC_DFC	d0
  debug 'local system started',0
9:

;----------------------------------------------------------------
;foCXI
	tst.b	(unitCounter)r
	bne	1f
;jbg0̂ƂLN^foCX̂ӂ
	move.w	#$8000,(deviceHeader+dhType)r
	move.l	#'/*06',(deviceHeader+dhName)r
	move.l	#'0T*/',(deviceHeader+dhName+4)r
	bra	2f
1:	move.b	(unitCounter)r,(13,a5)	;jbg
	move.l	#bpbTablePointer,(18,a5)	;BPBe[ũ|C^̃e[u
2:	move.l	(mainLowerEnd)r,(14,a5)	;foCXhCo̖+1
	moveq.l	#0,d0
  debug 'device initialize end',0

deviceInitializeExit:
	movem.l	(sp)+,d1-d7/a0-a4/a6
	rts

banner:
	.dc.b	13,10
*	.dc.b	$1B,'[1m'
	.dc.b	'060turbo.sys version ',VERSION
*	.dc.b	$1B,'[1m'
	.dc.b	' ',DATE
	.dc.b	' by M.Kamada',13,10,0

spBanner:
	.dc.b	'M68060 Software Package Copyright (C) Motorola Inc.',13,10
	.dc.b	0
	.even

deviceInitializeError:
	move.w	#$700D,d0
	bra	deviceInitializeExit

tempBufferOver:
	lea.l	(@f,pc),a1
	bsr	print
	bra	deviceInitializeError
@@:	.dc.b	']obt@mۂł܂',13,10,0
	.even

descAreaOver:
	lea.l	(@f,pc),a1
	bsr	print
	bra	deviceInitializeError
@@:	.dc.b	'fXNv^̗̈悪mۂł܂',13,10,0
	.even

;----------------------------------------------------------------
;MPUm߂
;68060̂ƂHuman[$0CBC].b=$03ɂĂ܂Ă
;>d0.l:0=,-1=s
;>ccr:pl,mi=s
mpuCheck:
	movem.l	d1/a0-a2,-(sp)
	PUSH_SR_DI
	movea.l	sp,a1
	move.l	$0010,a2
	move.l	#110f,$0010.w		;Illegal Instruction
;MOVEC from SFCȂ68000
	moveq.l	#0,d0
	lea.l	(80f,pc),a0
	movec.l	sfc,d0
;XP[t@N^Ȃ68010
	moveq.l	#1,d0
10:	moveq.l	#1,d1
	and.b	(10b-1,pc,d1.l*2),d1
	beq	80f
;CALLM68020
	.cpu	68020
	lea.l	(40f,pc),a0
	callm	#0,(20f,pc)
	moveq.l	#2,d0
	bra	80f

;W[fXNv^
20:	.dc.l	%0<<13|0<<24|0<<16	;option=0,type=0,accesslevel=0
	.dc.l	30f			;W[Gg|C^
	.dc.l	0			;W[f[^̈|C^
	.dc.l	0
;W[Gg
30:	.dc.w	15<<12			;Rn=sp
	rtm	sp
	.cpu	68060

;MOVEC from CAAR68030
	.cpu	68030
40:	lea.l	(50f,pc),a0
	movec.l	caar,d0
	moveq.l	#3,d0
	bra	80f
	.cpu	68060

;MOVEC from MMUSR68040
	.cpu	68040
50:	lea.l	(60f,pc),a0
	movec.l	mmusr,d0
	moveq.l	#4,d0
	bra	80f
	.cpu	68060

;MOVEC from PCR68060
60:	lea.l	(70f,pc),a0
	movec.l	pcr,d0
	moveq.l	#6,d0
	bra	80f

;s
70:	moveq.l	#0,d0
80:	move.b	d0,$0CBC.w
	move.l	a2,$0010.w
	POP_SR
	moveq.l	#0,d0
	cmpi.b	#3,$0CBC.w
	bhs	90f
	lea.l	(100f,pc),a1
	bsr	print
	moveq.l	#-1,d0
90:	movem.l	(sp)+,d1/a0-a2
	tst.l	d0
	rts

100:	.dc.b	'68030 ȏł͂܂',13,10,0
	.even

110:	movea.l	a1,sp
	jmp	(a0)

;----------------------------------------------------------------
;Human68k̃o[Wm߂
humanCheck:
	DOS	_VERNUM
	cmp.w	#$0302,d0
	bne	9f
	moveq.l	#0,d0
	rts

9:	lea.l	(@f,pc),a1
	bsr	print
	moveq.l	#-1,d0
	rts
@@:	.dc.b	'Human ̃o[WႢ܂',13,10,0
	.even

;----------------------------------------------------------------
;HumanɃpb`Ă
patchHuman::
	bsr	patchHuman302
	bmi	9f
	rts

9:	lea.l	(@f,pc),a1
	bsr	print
	moveq.l	#-1,d0
	rts
@@:	.dc.b	'Human ُł',13,10,0
	.even

;----------------------------------------------------------------
;xN^ݒ肷
;<a0.l:xN^
;	0000	.l	xN^AhX
;	0004	.l	̃xN^
;	0008	.l	VxN^
setVector::
	movem.l	a0-a1,-(sp)
	movea.l	(a0)+,a1		;xN^AhX
	move.l	(a1),(a0)+		;̃xN^ۑ
	move.l	(a0),(a1)		;VxN^ݒ
	movem.l	(sp)+,a0-a1
	rts

;----------------------------------------------------------------
;[J̗eʂƐ擪AhXԂ
;	O
;	E[J̗eʂƐ擪AhX$01000000(16MB)̔{ł
;	E[J̃ANZXŃANZXG[sɂf[^̔j͔Ȃ
;	ẼvO̓X[p[oCU[hŎs
;	ẼvOƃX[p[oCUX^bNGA͘_AhX=AhẌ̗ɂ
;	ẼvOƃX[p[oCUX^bNGÃAhX̏8rbg$00ł
;	菇
;	E$00000000-$3FFFFFFF(1024MB)$01000000(16MB)64ɋ؂
;	Eʂ̃ubN珇ɓItZbgɈقȂf[^
;	Eʂ̃ubN珇ɏ񂾃f[^ǂݏoΑ݂Ɣf
;p[^Ȃ
;>d0.l:[J̗e
;>d1.l:[J̐擪AhX
getLocalMemorySize::
	movem.l	d2-d5/a0,-(sp)
	moveq.l	#0,d0
;LbV֎~
	movec.l	cacr,d4
	movec.l	d0,cacr
	CACHE_FLUSH	d3
;MMU֎~
	cmpi.b	#4,$0CBC.w
	blo	@f
	movec.l	tc,d3
	movec.l	d0,tc
	pflusha
;gXyAgϊ֎~
	movec.l	dtt1,d2
	movec.l	d0,dtt1
	movec.l	dtt0,d5
	movec.l	d0,dtt0
@@:
;Rg[WX^ۑ
	movem.l	d2-d5,-(sp)
;[NGAm
	lea.l	-4-64(sp),sp
;ۑ
	moveq.l	#$3F,d1			;ubN̔ԍB$3F$00
10:	move.l	d1,d0
	ror.l	#8,d0
	lea.l	(sp,d0.l),a0		;eXgAhX
	move.b	(a0),4(sp,d1.l)		;ۑ
	dbra	d1,10b
;ύX
	moveq.l	#$3F,d1			;ubN̔ԍB$3F$00
20:	move.l	d1,d0
	ror.l	#8,d0
	lea.l	(sp,d0.l),a0		;eXgAhX
	move.b	d1,(a0)			;ύX
	dbra	d1,20b
;rƕ
	moveq.l	#$3F,d1			;ubN̔ԍB$3F$00
30:	move.l	d1,d0
	ror.l	#8,d0
	lea.l	(sp,d0.l),a0		;eXgAhX
	cmp.b	(a0),d1			;r
	seq.b	d0			;0=Ȃ,-1=
	bne	40f
	move.b	4(sp,d1.l),(a0)		;(Ƃ)
40:	move.b	d0,4(sp,d1.l)		;ʁB0=Ȃ,-1=
	dbra	d1,30b
	sf.b	4(sp)			;ubN0̓[Jł͂Ȃ
;
	moveq.l	#$3F,d1			;ubN̔ԍB$3F$00
50:	tst.b	4(sp,d1.l)
	dbne	d1,50b
	beq	70f			;Ȃ
;
	move.l	d1,d0			;̃ubN̔ԍ
;擪
60:	tst.b	4(sp,d1.l)
	dbeq	d1,60b			;KeqŎ~܂
	addq.b	#1,d1
	ror.l	#8,d1			;擪̃ubN̐擪AhX
	addq.b	#1,d0
	ror.l	#8,d0			;̃ubN̖AhX+1
	sub.l	d1,d0			;
	bra	80f
;Ȃ
70:	moveq.l	#0,d0
	moveq.l	#0,d1
80:
;<d0.l:[J̗e
;<d1.l:[J̐擪AhX
;[NGAJ
	lea.l	4+64(sp),sp
;Rg[WX^
	movem.l	(sp)+,d2-d5
;gXyAgϊ
	cmpi.b	#4,$0CBC.w
	blo	@f
	movec.l	d5,dtt0
	movec.l	d2,dtt1
;MMU
	movec.l	d3,tc
@@:
;LbV
	movec.l	d4,cacr
	movem.l	(sp)+,d2-d5/a0
	rts


;----------------------------------------------------------------
;[J̃TCYfXNv^̗̈̃TCY肷
defaultDescAreaSize::
	movem.l	d0-d1,-(sp)
	tst.l	(descAreaSize)r
	bne	2f			;Ɏw肳Ă
	move.l	#DEFAULT_DESC_SIZE_0,d1
	move.l	(localMemorySize)r,d0
	beq	1f			;{16MB̂
	move.l	#DEFAULT_DESC_SIZE_16,d1
	cmp.l	#16<<20,d0
	bls	1f			;{16MB+[J16MB
	move.l	#DEFAULT_DESC_SIZE_32,d1
	cmp.l	#32<<20,d0
	bls	1f			;{16MB+[J32MB
	move.l	#DEFAULT_DESC_SIZE_64,d1
	cmp.l	#64<<20,d0
	bls	1f			;{16MB+[J64MB
	move.l	#DEFAULT_DESC_SIZE_128,d1
	cmp.l	#128<<20,d0
	bls	1f			;{16MB+[J128MB
	move.l	#DEFAULT_DESC_SIZE_256,d1
	cmp.l	#256<<20,d0
	bls	1f			;{16MB+[J256MB
	move.l	#DEFAULT_DESC_SIZE_384,d1
	cmp.l	#384<<20,d0
	bls	1f			;{16MB+[J384MB
	move.l	#DEFAULT_DESC_SIZE_512,d1
	cmp.l	#512<<20,d0
	bls	1f			;{16MB+[J512MB
	move.l	#DEFAULT_DESC_SIZE_768,d1
					;{16MB+[J768MB
1:	move.l	d1,(descAreaSize)r
2:	movem.l	(sp)+,d0-d1
	rts

;----------------------------------------------------------------
;AhXϊe[u
makeTranslationTable::
	movea.l	(descAreaStart)r,a0
	movea.l	(descAreaEnd)r,a1
;fXNv^̗̈Ɋ֘A郏[Nݒ肷
	move.l	a0,(descHead)r
;	move.l	a0,(rootDescHead)r
	lea.l	(ROOT_DESC_SIZE,a0),a2
	move.l	a2,(rootDescTail)r
;	move.l	a2,(pointerDescHead)r
	move.l	a2,(pointerDescTail)r
	move.l	(descAreaSize)r,d0
	move.l	(pageIndexWidth)r,d1
	lsr.l	d1,d0			;QƐJE^̗̈̃TCY
	move.l	a1,d1
	sub.l	d0,d1
	and.l	(pageDescMask)r,d1
	move.l	d1,(pageDescHead)r
	move.l	d1,(pageDescTail)r
;	move.l	d1,(pointerCounterHead)r
	move.l	a1,(pageCounterTail)r
;	move.l	a1,(descTail)r

;fXNv^̗̈
	movea.l	(rootDescHead)r,a0
	movea.l	(pageDescTail)r,a1
@@:	clr.l	(a0)+
	cmpa.l	a1,a0
	blo	@b
	movea.l	(pageCounterTail)r,a1
@@:	move.l	#-1,(a0)+
	cmpa.l	a1,a0
	blo	@b

	MMU_SFC_DFC	d0

;C̃AhXϊ
	lea.l	(physicalModeTable,pc),a2
	suba.l	a1,a1
1:	move.l	(a2)+,d2		;[h
	move.l	(a2)+,d0		;̃AhX
6:	cmpa.l	d0,a1
	blo	7f
	move.l	(a2)+,d2		;[h
	move.l	(a2)+,d0		;̃AhX
	bpl	6b
7:	subq.l	#8,a2
	add.l	a1,d2
	bsr	setDesc
	bmi	9f			;G[
	adda.l	(pageOffsetSize)r,a1
	cmpa.l	#$01000000,a1
	bne	1b

	moveq.l	#$00000000,d1
2:	move.l	d1,d0
	bsr	copyPointerDesc
	add.l	#$00040000,d1
	adda.l	#$00040000,a1
	cmpa.l	#$02000000,a1
	bne	2b

3:	moveq.l	#$00000000,d0
	bsr	copyRootDesc
	adda.l	#$02000000,a1
	cmpa.l	#LOGICAL_SIZE,a1
	bne	3b

;[J̃AhXϊ
	move.l	(localMemorySize)r,d1
	beq	5f
	clr.w	d3
	move.b	localMemoryCacheMode,d3
	lsl.w	#PD_CM_BIT,d3
;		  UR G U1U0 S CM M U W PDT
	or.w	#%00_1__00__0_00_0_0_0_11,d3
	movea.l	#$10000000,a1
	add.l	a1,d1
4:	move.l	a1,d2
	or.w	d3,d2
	bsr	setDesc
	bmi	9f			;G[
	adda.l	(pageOffsetSize)r,a1
	cmpa.l	d1,a1
	bne	4b
5:

9:

;]obt@̗̈CgX[ɂ
	tst.l	(tempBufferSize)r
	beq	2f			;Ô
	movea.l	(tempBufferStart)r,a1	;Ƀy[WTCYɍ킹Ă
	movea.l	(tempBufferEnd)r,a2	;Ƀy[WTCYɍ킹Ă
1:	moveq.l	#0,d2			;CgX[
	bsr	sysStat_8004
	adda.l	(pageOffsetSize)r,a1
	cmpa.l	a2,a1
	blo	1b
2:

;ADPCM̓]obt@̗̈CgX[ɂ
	movea.l	(adpcmBufferStart)r,a1	;Ƀy[WTCYɍ킹Ă
	moveq.l	#0,d2			;CgX[
	bsr	sysStat_8004		;1y[W

;CRAMDISK̗̈mLbVuɂ
	movea.l	(mainRamdiskAreaStart)r,a1
	movea.l	(mainRamdiskAreaEnd)r,a2
	cmpa.l	a1,a2
	beq	2f
1:	moveq.l	#3,d2			;LbV֎~XgAobt@
	bsr	sysStat_8004
;w_y[WX[p[oCUی삷
;<a1.l:_AhX
	PUSH_MMU_SFC_DFC	d0
	bsr	getDesc
	bset.l	#PD_S_BIT,d0
	moves.l	d0,(a0)
	POP_SFC_DFC	d0
;
	adda.l	(pageOffsetSize)r,a1
	cmpa.l	a2,a1
	blo	1b
2:

;[JRAMDISK̗̈mLbVuɂ
	movea.l	(localRamdiskAreaStart)r,a1
	movea.l	(localRamdiskAreaEnd)r,a2
	cmpa.l	a1,a2
	beq	2f
1:	moveq.l	#3,d2			;LbV֎~XgAobt@
	bsr	sysStat_8004
;w_y[WX[p[oCUی삷
;<a1.l:_AhX
	PUSH_MMU_SFC_DFC	d0
	bsr	getDesc
	bset.l	#PD_S_BIT,d0
	moves.l	d0,(a0)
	POP_SFC_DFC	d0
;
	adda.l	(pageOffsetSize)r,a1
	cmpa.l	a2,a1
	blo	1b
2:

;[JROM
	tst.b	(localRomArea)r
	beq	2f
	movea.l	#$00F00000,a1
	move.l	(localRomStart)r,d2
1:	bsr	sysStat_F001		;ROMAhX[J
	exg.l	d2,a1
	bsr	invDesc			;[J
	exg.l	d2,a1
	add.l	(pageOffsetSize)r,d2
	adda.l	(pageOffsetSize)r,a1
	cmp.l	#$01000000,a1
	blo	1b


2:

;fXNv^̗̈Ȃ
	movea.l	(descAreaStart)r,a1
1:	bsr	invDesc
	adda.l	(pageOffsetSize)r,a1
	cmpa.l	(descAreaEnd)r,a1
	bne	1b
2:

	CACHE_FLUSH	d0		;Ô߃vbVĂ
	rts

physicalModeTable::
;			   UR G U1U0 S CM M U W PDT
;	.dc.l	          %00_1__00__1_00_0_0_0_01	;Vector
;	.dc.l	$00002000
mainPD:
	.dc.l	          %00_1__00__0_00_0_0_0_01	;Main Memory
	.dc.l	$00C00000,%00_1__00__1_11_0_0_0_01	;Graphic
	.dc.l	$00E00000,%00_1__00__1_11_0_0_0_01	;Text
	.dc.l	$00E80000,%00_1__00__1_10_0_0_0_01	;CRTC
	.dc.l	$00E82000,%00_1__00__1_10_0_0_0_01	;Palet/Video Controler
	.dc.l	$00E84000,%00_1__00__1_10_0_0_0_01	;DMAC
	.dc.l	$00E86000,%00_1__00__1_10_0_0_0_01	;Supervisor Area Control
	.dc.l	$00E88000,%00_1__00__1_10_0_0_0_01	;MFP
	.dc.l	$00E8A000,%00_1__00__1_10_0_0_0_01	;RTC
	.dc.l	$00E8C000,%00_1__00__1_10_0_0_0_01	;Printer
	.dc.l	$00E8E000,%00_1__00__1_10_0_0_0_01	;System Port
	.dc.l	$00E90000,%00_1__00__1_10_0_0_0_01	;FM
	.dc.l	$00E92000,%00_1__00__1_10_0_0_0_01	;ADPCM
	.dc.l	$00E94000,%00_1__00__1_10_0_0_0_01	;FDC
	.dc.l	$00E96000,%00_1__00__1_10_0_0_0_01	;Internal SCSI
	.dc.l	$00E98000,%00_1__00__1_10_0_0_0_01	;SCC
	.dc.l	$00E9A000,%00_1__00__1_10_0_0_0_01	;Joy Stick
	.dc.l	$00E9C000,%00_1__00__1_10_0_0_0_01	;I/O Interrupt Control
	.dc.l	$00E9E000,%00_1__00__1_10_0_0_0_01	;Co-processor
	.dc.l	$00EA0000,%00_1__00__1_10_0_0_0_01	;External SCSI
	.dc.l	$00EAE000,%00_1__00__1_10_0_0_0_01	;Supervisor Area Control
							;External RS-232C
	.dc.l	$00EB0000,%00_1__00__1_10_0_0_0_01	;Sprite Register/Controler
	.dc.l	$00EB8000,%00_1__00__1_11_0_0_0_01	;Sprite PCG
	.dc.l	$00EBC000,%00_1__00__1_11_0_0_0_01	;Sprite Text
	.dc.l	$00EC0000,%00_1__00__0_10_0_0_0_01	;User I/O
	.dc.l	$00ED0000,%00_1__00__1_10_0_0_0_01	;SRAM
	.dc.l	$00ED4000,%00_1__00__0_10_0_0_0_01	;User I/O
	.dc.l	$00F00000,%00_1__00__1_00_0_0_1_01	;ROM
	.dc.l	-1

makeTranslationMain:
	.dc.b	'AhXϊe[uCɔzu܂',13,10,0
	.even

;----------------------------------------------------------------
;AhXϊLɂ
enableTranslation::
	PUSH_SR_DI

	moveq.l	#0,d0
	movec.l	d0,cacr
	CACHE_FLUSH	d0

	move.l	(rootDescHead)r,d0
	movec.l	d0,srp
	movec.l	d0,urp

;		  E  P NAD NAI FOTC FITC DCO DUO DWO DCI DUI
	move.l	#%1__0__0__0___0____0____10__00__0___10__00_0,d0
	cmpi.l	#4096,(pageOffsetSize)r
	beq	@f
	bset.l	#TC_P_BIT,d0
@@:	movec.l	d0,tc

	pflusha

	POP_SR
	rts


;----------------------------------------------------------------
;p[^̉
;<a0.l:[h̐擪
getParam::
	movea.l	a0,a1
	cmpi.b	#'-',(a0)+
	bne	9f
	move.w	(a0)+,d0		;AhX̉\
	or.w	#$2020,d0
	cmp.w	#'ad',d0
	beq	param_ad
	cmp.w	#'bg',d0
	beq	param_bg
	cmp.w	#'bs',d0
	beq	param_bs
	cmp.w	#'cm',d0
	beq	param_cm
	cmp.w	#'dv',d0
	beq	param_dv
	cmp.w	#'fe',d0
	beq	param_fe
	cmp.w	#'hi',d0
	beq	param_hi
	cmp.w	#'ld',d0
	beq	param_ld
	cmp.w	#'lr',d0
	beq	param_lr
	cmp.w	#'ls',d0
	beq	param_ls
	cmp.w	#'lt',d0
	beq	param_lt
	cmp.w	#'lz',d0
	beq	param_lz
	cmp.w	#'md',d0
	beq	param_md
	cmp.w	#'mm',d0
	beq	param_mm
	cmp.w	#'np',d0
	beq	param_np
	cmp.w	#'nt',d0
	beq	param_nt
	cmp.w	#'sd',d0
	beq	param_sd
	cmp.w	#'sl',d0
	beq	param_sl
	cmp.w	#'ss',d0
	beq	param_ss
	cmp.w	#'ts',d0
	beq	param_ts
	cmp.w	#'xm',d0
	beq	param_xm
9:	bsr	print
	lea.l	(1f,pc),a1
	bra	print
1:	.dc.b	' c ߂ł܂̂Ŗ܂',13,10,0
	.even

;----------------------------------------------------------------
;@:	-sl
;@\:	68060store/load bypass@\Lɂ
;:	68060result forwarding features1łstore/load
;	bypass@\Lɂ܂B
;	store/load bypass@\̓Zbg͗LłA
;	060turbo.sys(v0.54ȍ~)𖳌ɂĂ܂B
;	-slw肷ƁAstore/load bypass@\LɂȂ܂B
;	store/load bypass@\𖳌ɂ邱Ƃɂ鑬xቺ͂
;	Ƃǂ܂B
param_sl:
	cmpi.b	#6,$0CBC.w
	bne	10f
	movec.l	pcr,d0
	bclr.l	#5,d0			;enable store/load bypass
	movec.l	d0,pcr
10:
	rts

;----------------------------------------------------------------
;@:	-mm<size>
;	<size>	C̃TCYiPʂ MBj
;@\:	C̃TCY̐ݒ
;:	C̃TCYw肵܂B
;	Ȃ΃[J΂₢A
;	烍[Jɉo܂B
;	TCY̕ύX̓VFNOɍs܂B
;	-mm0 ƂƃfoCXhCõׂ
;	[Jɉo܂iJUPITER ̊g[hƓjB
param_mm:
	tst.b	(noTranslation)r
	bne	param_mm_notrans	;-ntw肳Ă
	bsr	stou
	bmi	param_mm_illegal
	cmp.l	#12,d0
	bhi	param_mm_illegal
	swap.w	d0
	lsl.l	#4,d0
	move.l	d0,(mainMemorySize)r
	rts

param_mm_notrans:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-nt  -mm ͓Ɏwł܂D-mm ͖ł',13,10,0
	.even

param_mm_illegal:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-mm ̎wlُł',13,10,0
	.even

;----------------------------------------------------------------
;@:	-ts<size>
;	<size>	AhXϊ̂߂̗̈̃TCYiPʂ KBj
;@\:	AhXϊ̂߂̗̈̃TCY̐ݒ
;:	AhXϊ̂߂̗̈̃TCYw肵܂B
;	y[WTCY 8KB ̂ƂA[J̗eʂɉ
;	ŒTCYƃftHgTCY͈ȉ̒ʂłB
;					Œ	ftHg
;		{16MB̂		10KB	32KB
;		{16MB+[J16MB	19KB	48KB
;		{16MB+[J32MB	27KB	64KB
;		{16MB+[J64MB	44KB	96KB
;		{16MB+[J128MB	78KB	160KB
;		{16MB+[J256MB	146KB	320KB
;		{16MB+[J384MB	214KB	480KB
;		{16MB+[J512MB	282KB	640KB
;		{16MB+[J768MB	418KB	960KB
;	4MB ȏ͎wł܂B
param_ts:
	cmpi.b	#3,$0CBC.w
	beq	param_ts_68030		;68030ł͎włȂ
	tst.b	(noTranslation)r
	bne	param_ts_notrans	;-ntw肳Ă
	bsr	stou
	bmi	param_ts_illegal	;Ȃ
	cmp.l	#4096,d0
	bhi	param_ts_toobig		;傫
	move.l	(localMemorySize)r,d1
	bne	@f
;{16MB̂
	cmp.w	#MINIMUM_DESC_SIZE_0>>10,d0
	blo	param_ts_toosmall	;
	bra	9f

@@:	cmp.l	#16<<20,d1
	bhi	@f
;{16MB+[J16MB
	cmp.w	#MINIMUM_DESC_SIZE_16>>10,d0
	blo	param_ts_toosmall	;
	bra	9f

@@:	cmp.l	#32<<20,d1
	bhi	@f
;{16MB+[J32MB
	cmp.w	#MINIMUM_DESC_SIZE_32>>10,d0
	blo	param_ts_toosmall	;
	bra	9f

@@:	cmp.l	#64<<20,d1
	bhi	@f
;{16MB+[J64MB
	cmp.w	#MINIMUM_DESC_SIZE_64>>10,d0
	blo	param_ts_toosmall	;
	bra	9f

@@:	cmp.l	#128<<20,d1
	bhi	@f
;{16MB+[J128MB
	cmp.w	#MINIMUM_DESC_SIZE_128>>10,d0
	blo	param_ts_toosmall	;
	bra	9f

@@:	cmp.l	#256<<20,d1
	bhi	@f
;{16MB+[J256MB
	cmp.w	#MINIMUM_DESC_SIZE_256>>10,d0
	blo	param_ts_toosmall	;
	bra	9f

@@:	cmp.l	#384<<20,d1
	bhi	@f
;{16MB+[J384MB
	cmp.w	#MINIMUM_DESC_SIZE_384>>10,d0
	blo	param_ts_toosmall	;
	bra	9f

@@:	cmp.l	#512<<20,d1
	bhi	@f
;{16MB+[J512MB
	cmp.w	#MINIMUM_DESC_SIZE_512>>10,d0
	blo	param_ts_toosmall	;
	bra	9f

@@:
;{16MB+[J768MB
	cmp.w	#MINIMUM_DESC_SIZE_768>>10,d0
	blo	param_ts_toosmall	;

9:	lsl.l	#8,d0
	lsl.l	#2,d0
	move.l	d0,(descAreaSize)r
	rts

param_ts_68030:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-ts  68030 ł͎wł܂D-ts ͖ł',13,10,0
	.even

param_ts_notrans:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-nt  -ts ͓Ɏwł܂D-ts ͖ł',13,10,0
	.even

param_ts_toosmall:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-ts ̎wl܂BftHggp܂',13,10,0
	.even

param_ts_toobig:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-ts ̎wl傫܂BftHggp܂',13,10,0
	.even

param_ts_illegal:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-ts ̎wlُłBftHggp܂',13,10,0
	.even

;----------------------------------------------------------------
;@:	-lr
;:	[JƂAROM [JɃRs[
;	Ďg܂B
param_lr:
	tst.b	(localRomArea)r
	bne	99f			;-lr͊Ɏw肳ꂽ
	tst.b	(forceNoSimm)r
	bne	param_lr_nosimm		;-lzw肳Ă
	cmpi.b	#3,$0CBC.w
	beq	param_lr_68030		;68030ł͎włȂ
	tst.b	(noTranslation)r
	bne	param_lr_notrans	;-ntw肳Ă
	tst.l	(localMemorySize)r
	beq	param_lr_cannot		;[JȂ
	move.l	(localUpperStart)r,d0
	sub.l	#1024*1024,d0
	cmp.l	(localLowerEnd)r,d0
	blo	param_lr_over
	move.l	d0,(localUpperStart)r
	move.l	d0,(localRomStart)r
	add.l	#1024*1024,d0
	move.l	d0,(localRomEnd)r
	st.b	(localRomArea)r
99:	rts

param_lr_nosimm:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-lz  -lr ͓Ɏwł܂D-lr ͖ł',13,10,0
	.even

param_lr_68030:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-lr  68030 ł͎wł܂D-lr ͖ł',13,10,0
	.even

param_lr_notrans:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-nt  -lr ͓Ɏwł܂D-lr ͖ł',13,10,0
	.even

param_lr_over:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'[JsĂ܂D-lr ͖ł',13,10,0
	.even

param_lr_cannot:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'[J܂D-lr ͖ł',13,10,0
	.even

;----------------------------------------------------------------
;@:	-lt
;:	[JƂAAhXϊe[u[J
;	ɒu܂B
param_lt:
	tst.b	(forceNoSimm)r
	bne	param_lt_nosimm		;-lzw肳Ă
	cmpi.b	#3,$0CBC.w
	beq	param_lt_68030		;68030ł͎włȂ
	tst.b	(noTranslation)r
	bne	param_lt_notrans	;-ntw肳Ă
	tst.l	(localMemorySize)r
	beq	9f
	st.b	(localAreaDescriptor)r
	rts

param_lt_nosimm:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-lz  -lt ͓Ɏwł܂D-lt ͖ł',13,10,0
	.even

param_lt_68030:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-lt  68030 ł͎wł܂D-lt ͖ł',13,10,0
	.even

param_lt_notrans:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-nt  -lt ͓Ɏwł܂D-lt ͖ł',13,10,0
	.even

9:	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'[J܂D-lt ͖ł',13,10,0
	.even

;----------------------------------------------------------------
;@:	-ss
;@\:	SCSI ̃ANZXŃ\tg]g
;:	IOCS $F5 ɂ SCSI ̃ANZXŃ[JƂ̂
;	\ɂ܂B
;	w肳ꂽobt@̘_AhXAhXƈقȂ
;	Â[JɂƂAꎞIɃ\tg]
;	ɐ؂ւ܂B
param_ss:
	st.b	(patchIocsScsi)r
	rts

;----------------------------------------------------------------
;@:	-dv
;@\:	foCXhCõANZXŃe|obt@g
;:	foCXhCõANZXŃ[JƂ̂Ƃ
;	\ɂ܂B
;	w肳ꂽobt@̘_AhXAhXƈقȂ
;	Â[JɂƂAe|obt
;	@}ăf[^Ƃ肵܂B
param_dv:
	st.b	(patchDevice)r
	rts

;----------------------------------------------------------------
;@:	-bs<size>
;	<size>	e|obt@̃TCYiPʂ KBj
;:	-dv w莞Ɏgpe|obt@̃TCYw肵
;	BftHg 64KB łB
;	e|obt@͏ɃCɊmۂ܂B
param_bs:
	tst.l	(tempBufferSize)r
	bne	param_bs_already
	bsr	stou
	bmi	param_bs_illegal
	lsl.l	#8,d0
	lsl.l	#2,d0
	add.l	#$00001FFF,d0		;]obt@̓y[Wʒuɍ킹
	and.l	#$FFFFE000,d0
	move.l	d0,(tempBufferSize)r
	move.l	(mainLowerEnd)r,d1
	add.l	#$00001FFF,d1		;]obt@̓y[Wʒuɍ킹
	and.l	#$FFFFE000,d1
	move.l	d1,(tempBufferStart)r
	add.l	d0,d1
	move.l	d1,(tempBufferEnd)r
	move.l	d1,d0
	add.l	#128*1024,d0
	cmp.l	(mainUpperStart)r,d0
	bhi	param_bs_over
	move.l	d1,(mainLowerEnd)r
	rts

param_bs_already:
	lea.l	(@f,pc),a1
	bra	9f
@@:	.dc.b	'-bs ͓dwł',13,10,0
	.even

param_bs_illegal:
	lea.l	(@f,pc),a1
	bra	9f
@@:	.dc.b	'-bs ̎w肪ُł',13,10,0
	.even

param_bs_over:
	lea.l	(@f,pc),a1
9:	bsr	print
	clr.l	(tempBufferSize)r
	rts
@@:	.dc.b	'-bs ̎w肪傫܂DftHggp܂',13,10,0
	.even

;----------------------------------------------------------------
;@:	-xm
;@\:	g[h̐ݒ
;:	g[hɂĂVFN܂B
;	Human ̃Ǘ[J܂Ŋg܂B
;	Ǘ֌W DOS R[g܂B
;	XC ̃CugpĂvO[hƂA
;	IɃpb`Ă܂B
param_xm:
	tst.b	(forceNoSimm)r
	bne	param_xm_nosimm		;-lzw肳Ă
	tst.l	(localMemorySize)r
	beq	9f
	st.b	(useJointMode)r
	st.b	(jointMode)r
	rts

param_xm_nosimm:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-lz  -xm ͓Ɏwł܂D-xm ͖ł',13,10,0
	.even

9:	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'[J܂D-xm ͖ł',13,10,0
	.even

;----------------------------------------------------------------
;@:	-hi
;	v0.53芮Sɔp~
param_hi:
	rts

;----------------------------------------------------------------
;@:	-md<size>{[K]|M}[a][i]
;	<size>	RAMDISK ̃TCY
;	K	TCY̒Pʂ KB
;	M	TCY̒Pʂ MB
;	a	TIMER-LED ANZXvɂ
;	i	SHIFT L[ĂȂƂ
;@\:	C RAMDISK ̐ݒ
;:	RAMDISK hCogݍ݂܂BRAMDISK ̗̈̓C
;	̏ʑmۂ܂B
;	<size> ͈̔͂ 16KB  32767KB ܂łłBAC
;	̗eʂɂĐ܂B
;	i w肵Ȃ SHIFT L[ĂƂ
;	܂BARAMDISK ̐擪ĂƂ͖ɏ
;	܂B
;	-ld  -md ͍킹 16 ܂Ŏwł܂B
;	RAMDISK ̗̈̓X[p[oCUveNg܂B܂A
;	LbV[hmLbVuECvTCYhV
;	AC[[Vɂ邱ƂŁALbV𖳑ʌ
;	悤ɂ܂B
;:	-md512Ka
;		C 512KB  RAMDISK mۂ܂B
;		TIMER-LED ANZXvɂ܂B
;		SHIFT L[ĂƂ܂B
;<a0.l:'md'̎̃AhX
param_md:
	moveq.l	#0,d0
	move.b	(unitCounter)r,d0
	cmp.b	#MAXIMUM_UNIT,d0
	beq	param_md_toomany	;jbg
	lea.l	(bpbTablePointer)r,a1
1:	movea.l	(a1)+,a3
	dbra	d0,1b
;<a3.l:BPBe[u
	moveq.l	#0,d2
	cmpi.b	#'-',(a0)
	bne	@f
	moveq.l	#1,d2
	addq.l	#1,a0
@@:	bsr	stou
	bmi	param_md_illegal
	move.l	d0,d1
	moveq.l	#$20,d0
	or.b	(a0),d0
	cmp.b	#'k',d0
	beq	1f
	cmp.b	#'m',d0
	bne	2f
	lsl.l	#8,d1
	lsl.l	#2,d1
1:	addq.l	#1,a0
2:	tst.l	d2
	beq	@f
	move.l	(mainUpperStart)r,d0
	sub.l	(mainLowerEnd)r,d0
	lsr.l	#8,d0
	lsr.l	#2,d0
	sub.l	d1,d0
	move.l	d0,d1
@@:	cmp.l	#MINIMUM_SIZE,d1
	blo	param_md_illegal
	cmp.l	#MAXIMUM_SIZE,d1
	bhi	param_md_illegal
;<d1.l:S̈̃ZN^
	move.l	d1,(12,a3)		;S̈̃ZN^
	move.l	d1,d2
	lsl.l	#8,d2
	lsl.l	#2,d2			;S̈̃oCg
;<d2.l:S̈̃oCg
;CRAMDISK͖mۂ
	movea.l	(mainRamdiskAreaStart)r,a1
;<a1.l:AhX+1
	movea.l	a1,a2
	suba.l	d2,a2
;<a2.l:擪AhX
	move.l	a2,d0
	sub.l	#128*1024,d0
	cmp.l	(mainLowerEnd)r,d0
	blt	param_md_over
	move.l	a2,(mainRamdiskAreaStart)r
;<a1.l:AhX+1
;<a2.l:擪AhX
	move.l	a2,(16,a3)		;擪AhX
	move.l	a1,(20,a3)		;AhX+1
	moveq.l	#0,d6
1:	move.b	(a0)+,d0
	beq	2f
	or.b	#$20,d0
	cmp.b	#'i',d0
	bne	@f
	or.b	#%00000001,d6
	bra	1b
@@:	cmp.b	#'a',d0
	bne	@f
	or.b	#%00000100,d6
	bra	1b
@@:	bra	param_md_illegal
2:
;<d1.l:S̈̃ZN^
	move.l	d1,d0
	sub.l	#(ROOT_ENTRY+31)>>5,d0
;<d0.l:f[^̈̃ZN^̏
	moveq.l	#1,d3
	moveq.l	#0,d4
	bra	2f
1:	add.l	d3,d3			;1NX^̃ZN^
	addq.l	#1,d4			;1NX^̃ZN^̃VtgJEg
	lsr.l	#1,d0
2:	cmp.l	#$0000FFF0,d0
	bhi	1b
	addq.l	#2,d0
;<d0.l:f[^̈̃NX^̏+2
;<d3.l:1NX^̃ZN^
;<d4.l:1NX^̃ZN^̃VtgJEg
	move.b	d3,(2,a3)		;1NX^̃ZN^
	move.l	d0,d3
	add.l	d3,d3
	cmp.l	#$0FF7,d0
	bcc	@f
	lsr.l	#2,d3
	addx.l	d0,d3
@@:	add.l	#$03FF,d3
	lsr.l	#8,d3
	lsr.l	#2,d3
;<d3.l:FAT̈̃ZN^
	move.b	d3,(11,a3)		;1FAT̈ɎgpZN^
	move.l	d1,d5			;S̈̃ZN^
	sub.l	#(ROOT_ENTRY+31)>>5,d5
	sub.l	d3,d5
;<d5.l:f[^̈̃ZN^
	lsr.l	d4,d5
	addq.l	#2,d5
;<d5.l:f[^̈̃NX^+2
	moveq.l	#1,d4
	cmpi.w	#$F9FF,(a2)
	bne	1f			;Ă
	cmpi.b	#$FF,(2,a2)
	bne	1f			;Ă
	IOCS	_B_SFTSNS
	and.b	d0,d4			;SHIFTL[̏
	btst.l	#0,d6
	beq	@f			;w肪Ȃ
	eori.b	#1,d4			;SHIFTL[̏𔽓]
@@:	tst.l	d4
	beq	2f			;Ȃ
1:	movea.l	a2,a0			;擪AhX
	move.l	d3,d0			;1FAT̈ɎgpZN^
	lsl.l	#10-2,d0		;1FAT̈ɎgpoCg/4
	subq.w	#1,d0
@@:	clr.l	(a0)+			;FAT
	dbra	d0,@b
	move.w	#ROOT_ENTRY*32/4-1,d0
@@:	clr.l	(a0)+			;[gfBNg
	dbra	d0,@b
	moveq.l	#$F9,d0
	ror.l	#8,d0
	cmp.l	#$00000FF7,d5
	bcc	@f
	clr.b	d0
@@:	move.l	d0,(a2)			;FAT̃wb_Zbg
2:
;<d4.l:tO(0=Ȃ,1=)
;ANZXv
	btst.l	#2,d6
	sne.b	(24,a3)
;bZ[W\
	lea.l	(param_md_message,pc),a1
	moveq.l	#'A',d0
	add.b	(22,a5),d0		;hCu
	add.b	(unitCounter)r,d0
	move.b	d0,(param_md_drive-param_md_message,a1)
	move.l	a2,d0
	lea.l	(param_md_start-param_md_message,a1),a0
	bsr	hex8			;16i8
	add.l	d2,d0
	subq.l	#1,d0
	lea.l	(param_md_end-param_md_message,a1),a0
	bsr	hex8			;16i8
	bsr	print
	lea.l	(param_md_not_initialized,pc),a1	;'͏܂'
	tst.l	d4
	beq	@f
	lea.l	(param_md_initialized,pc),a1	;'܂'
@@:	bsr	print
;
	addq.b	#1,(unitCounter)r
	rts

param_md_message:
	.dc.b	'q`lfBXN '
param_md_drive:
	.dc.b	'?: $'
param_md_start:
	.dc.b	'xxxxxxxx`$'
param_md_end:
	.dc.b	'xxxxxxxx ',0
param_md_not_initialized:
	.dc.b	'͏܂',13,10,0
param_md_initialized:
	.dc.b	'܂',13,10,0
	.even

param_md_toomany:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-md ̃jbg܂',13,10,0
	.even

param_md_illegal:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-md ̎w肪ُł',13,10,0
	.even

param_md_over:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-md ̎w肪傫܂',13,10,0
	.even

;----------------------------------------------------------------
;@:	-ld<size>{[K]|M}[a][i]
;	<size>	RAMDISK ̃TCY
;	K	<size> ̒Pʂ KB
;	M	<size> ̒Pʂ MB
;	a	TIMER-LED ANZXvɂ
;	i	SHIFT L[ĂȂƂ
;@\:	[J RAMDISK ̐ݒ
;:	RAMDISK hCogݍ݂܂BRAMDISK ̗̈̓[J
;	̉ʑmۂ܂B
;	<size> ͈̔͂ 16KB  1024MB ܂łłBA[
;	J̗eʂɂĐ܂B
;	<size>  - tƎcTCYwł܂B
;	i w肵Ȃ SHIFT L[ĂƂ
;	܂BARAMDISK ̐擪ĂƂ͖ɏ
;	܂B
;	-ld  -md ͍킹 16 ܂Ŏwł܂B
;	RAMDISK ̗̈̓X[p[oCUveNg܂B܂A
;	LbV[hmLbVuECvTCYhV
;	AC[[Vɂ邱ƂŁALbV𖳑ʌ
;	悤ɂ܂B
;:	-ld16Mai
;		[J 16MB  RAMDISK mۂ܂B
;		TIMER-LED ANZXvɂ܂B
;		SHIFT L[ĂȂƂ܂B
;<a0.l:'ld'̎̃AhX
param_ld:
	tst.b	(forceNoSimm)r
	bne	param_ld_nosimm		;-lzw肳Ă
	tst.l	(localMemorySize)r
	beq	param_ld_cannot		;[JȂ
	moveq.l	#0,d0
	move.b	(unitCounter)r,d0
	cmp.b	#MAXIMUM_UNIT,d0
	beq	param_ld_toomany	;jbg
	lea.l	(bpbTablePointer)r,a1
1:	movea.l	(a1)+,a3
	dbra	d0,1b
;<a3.l:BPBe[u
	moveq.l	#0,d2
	cmpi.b	#'-',(a0)
	bne	@f
	moveq.l	#1,d2
	addq.l	#1,a0
@@:	bsr	stou
	bmi	param_ld_illegal
	move.l	d0,d1
	moveq.l	#$20,d0
	or.b	(a0),d0
	cmp.b	#'k',d0
	beq	1f
	cmp.b	#'m',d0
	bne	2f
	lsl.l	#8,d1
	lsl.l	#2,d1
1:	addq.l	#1,a0
2:	tst.l	d2
	beq	@f
	move.l	(localUpperStart)r,d0
	sub.l	(localRamdiskAreaEnd)r,d0
	lsr.l	#8,d0
	lsr.l	#2,d0
	sub.l	d1,d0			;mۂZN^=󂫃ZN^-cZN^
	move.l	d0,d1
@@:	cmp.l	#MINIMUM_SIZE,d1
	blo	param_ld_illegal
	cmp.l	#MAXIMUM_SIZE,d1
	bhi	param_ld_illegal
;<d1.l:S̈̃ZN^
	move.l	d1,(12,a3)		;S̈̃ZN^
	move.l	d1,d2
	lsl.l	#8,d2
	lsl.l	#2,d2			;S̈̃oCg
;nCRAMDISK͐擪mۂ
;<d2.l:S̈̃oCg
	movea.l	(localRamdiskAreaEnd)r,a2
;<a2.l:擪AhX
	lea.l	(a2,d2.l),a1
;<a1.l:AhX+1
	cmpa.l	(localUpperStart)r,a1
	bhi	param_ld_over		;c0eĂB-xmłȂȂ
	move.l	a1,(localRamdiskAreaEnd)r
;<a1.l:AhX+1
;<a2.l:擪AhX
	move.l	a2,(16,a3)		;擪AhX
	move.l	a1,(20,a3)		;AhX+1
	moveq.l	#0,d6
1:	move.b	(a0)+,d0
	beq	2f
	or.b	#$20,d0
	cmp.b	#'i',d0
	bne	@f
	or.b	#%00000001,d6
	bra	1b
@@:	cmp.b	#'a',d0
	bne	@f
	or.b	#%00000100,d6
	bra	1b
@@:	bra	param_ld_illegal
2:
;<d1.l:S̈̃ZN^
	move.l	d1,d0
	sub.l	#(ROOT_ENTRY+31)>>5,d0
;<d0.l:f[^̈̃ZN^̏
	moveq.l	#1,d3
	moveq.l	#0,d4
	bra	2f
1:	add.l	d3,d3			;1NX^̃ZN^
	addq.l	#1,d4			;1NX^̃ZN^̃VtgJEg
	lsr.l	#1,d0
2:	cmp.l	#$0000FFF0,d0
	bhi	1b
	addq.l	#2,d0
;<d0.l:f[^̈̃NX^̏+2
;<d3.l:1NX^̃ZN^
;<d4.l:1NX^̃ZN^̃VtgJEg
	move.b	d3,(2,a3)		;1NX^̃ZN^
	move.l	d0,d3
	add.l	d3,d3
	cmp.l	#$0FF7,d0
	bcc	@f
	lsr.l	#2,d3
	addx.l	d0,d3
@@:	add.l	#$03FF,d3
	lsr.l	#8,d3
	lsr.l	#2,d3
;<d3.l:FAT̈̃ZN^
	move.b	d3,(11,a3)		;1FAT̈ɎgpZN^
	move.l	d1,d5			;S̈̃ZN^
	sub.l	#(ROOT_ENTRY+31)>>5,d5
	sub.l	d3,d5
;<d5.l:f[^̈̃ZN^
	lsr.l	d4,d5
	addq.l	#2,d5
;<d5.l:f[^̈̃NX^+2
	moveq.l	#1,d4
	cmpi.w	#$F9FF,(a2)
	bne	1f			;Ă
	cmpi.b	#$FF,(2,a2)
	bne	1f			;Ă
	IOCS	_B_SFTSNS
	and.b	d0,d4			;SHIFTL[̏
	btst.l	#0,d6
	beq	@f			;w肪Ȃ
	eori.b	#1,d4			;SHIFTL[̏𔽓]
@@:	tst.l	d4
	beq	2f			;Ȃ
1:	movea.l	a2,a0			;擪AhX
	move.l	d3,d0			;1FAT̈ɎgpZN^
	lsl.l	#10-2,d0		;1FAT̈ɎgpoCg/4
	subq.w	#1,d0
@@:	clr.l	(a0)+			;FAT
	dbra	d0,@b
	move.w	#ROOT_ENTRY*32/4-1,d0
@@:	clr.l	(a0)+			;[gfBNg
	dbra	d0,@b
	moveq.l	#$F9,d0
	ror.l	#8,d0
	cmp.l	#$00000FF7,d5
	bcc	@f
	clr.b	d0
@@:	move.l	d0,(a2)			;FAT̃wb_Zbg
2:
;<d4.l:tO(0=Ȃ,1=)
;ANZXv
	btst.l	#2,d6
	sne.b	(24,a3)
;bZ[W\
	lea.l	(param_ld_message,pc),a1
	moveq.l	#'A',d0
	add.b	(22,a5),d0		;hCu
	add.b	(unitCounter)r,d0
	move.b	d0,(param_ld_drive-param_ld_message,a1)
	move.l	a2,d0
	lea.l	(param_ld_start-param_ld_message,a1),a0
	bsr	hex8			;16i8
	add.l	d2,d0
	subq.l	#1,d0
	lea.l	(param_ld_end-param_ld_message,a1),a0
	bsr	hex8			;16i8
	bsr	print
	lea.l	(param_ld_not_initialized,pc),a1	;'͏܂'
	tst.l	d4
	beq	@f
	lea.l	(param_ld_initialized,pc),a1	;'܂'
@@:	bsr	print
;
	addq.b	#1,(unitCounter)r
	rts

param_ld_message:
	.dc.b	'q`lfBXN '
param_ld_drive:
	.dc.b	'?: $'
param_ld_start:
	.dc.b	'xxxxxxxx`$'
param_ld_end:
	.dc.b	'xxxxxxxx ',0
param_ld_not_initialized:
	.dc.b	'͏܂',13,10,0
param_ld_initialized:
	.dc.b	'܂',13,10,0
	.even

param_ld_nosimm:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-lz  -ld ͓Ɏwł܂D-ld ͖ł',13,10,0
	.even

param_ld_cannot:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'[J܂D-ld ͖ł',13,10,0
	.even

param_ld_toomany:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-ld ̃jbg܂',13,10,0
	.even

param_ld_illegal:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-ld ̎w肪ُł',13,10,0
	.even

param_ld_over:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-ld ̎w肪傫܂',13,10,0
	.even

;----------------------------------------------------------------
;@:	-cm<mode>
;	<mode>	LbV[h
;		0	LbV,CgX[
;		1	LbV,Rs[obN
;		2	LbV֎~,XgAobt@֎~
;		3	LbV֎~,XgAobt@
;:	̃LbV[hw肵܂BftHg̓Cg
;	X[łB
param_cm:
	moveq.l	#0,d0
	move.b	(a0),d0
	sub.b	#'0',d0
	bmi	param_cm_illegal
	cmp.b	#3,d0
	bhi	param_cm_illegal
	move.b	d0,mainMemoryCacheMode
	move.b	d0,localMemoryCacheMode
	lsl.l	#PD_CM_BIT,d0
	andi.l	#.not.PD_CM_MASK,mainPD
	or.l	d0,mainPD
	rts

param_cm_illegal:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-cm ̎w肪ُł',13,10,0
	.even

;----------------------------------------------------------------
;@:	-bg
;:	XbhԂ̔rs܂B
;	-bgw肷ƁAXbh؂ւxɁAFPU̓
;	ƊeWX^AWnhAWnh̕ϊԁAeh
;	CũJgfBNgAJghCu؂ւ
;	܂B
;	CONFIG.SYSFILES̒l͍Œł30ȏw肵ĉB
param_bg:
	tst.b	(backgroundFlag)r
	bne	99f			;-bg͊Ɏw肳ꂽ
	tst.w	$1C58.w			;process̃Xbh-1
	beq	param_bg_no_process	;TuXbh͎gȂ
	cmpi.w	#30+2,$1C6E.w		;files30ȏォ
	blo	param_bg_no_files	;files̎wl
	movea.l	(mainLowerEnd)r,a1	;r̐擪
	move.l	a1,(exclusiveStart)r
	move.w	#xSize2,d0		;r1̃TCY
	mulu.w	$1C58.w,d0		;TuXbh̔r̃TCY
	add.l	#$0000000F,d0		;16̔{ɐ؂グ
	and.l	#$FFFFFFF0,d0
	adda.l	d0,a1			;r̖+1
	move.l	(mainUpperStart)r,d0
	sub.l	#128*1024,d0
	cmpa.l	d0,a1
	bhi	param_bg_over
	move.l	a1,(exclusiveEnd)r
	move.l	a1,(mainLowerEnd)r
	st.b	(backgroundFlag)r
99:	rts

param_bg_no_process:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'process w肳Ă܂D-bg ͖ł',13,10,0
	.even

param_bg_no_files:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'files ̎wl܂D-bg ͖ł',13,10,0
	.even

param_bg_over:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'sĂ܂D-bg ͖ł',13,10,0
	.even

;----------------------------------------------------------------
;@:	-sd
;:	IOCSɂDMA]\tg]ɂ܂B
param_sd:
	st.b	(softwareIocsDma)r
	rts

;----------------------------------------------------------------
;@:	-fe
;:	060turbo.sys̓FEt@NVgp邱Ƃ𖾎
;	܂BォFLOATn.XgݍނƂłȂȂ܂B
param_fe:
	cmpi.b	#6,$0CBC.w
	bne	param_fe_not_68060	;68060ȊOł͎włȂ
	move.l	#'FEfn',_060_fpsp_fline-4
	rts

param_fe_not_68060:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-fe  68060 ȊOł͎wł܂D-fe ͖ł',13,10,0
	.even

;----------------------------------------------------------------
;@:	-ls
;:	xN^̈悩Human{̖̂܂ł060turbo.sys{̂[
;	JɃRs[Ďg܂B
param_ls:
	tst.b	(localSystemArea)r
	bne	99f			;-ls͊Ɏw肳ꂽ
	tst.b	(forceNoSimm)r
	bne	param_ls_nosimm		;-lzw肳Ă
	cmpi.b	#3,$0CBC.w
	beq	param_ls_68030		;68030ł͎włȂ
	tst.b	(noTranslation)r
	bne	param_ls_notrans	;-ntw肳Ă
	tst.l	(localMemorySize)r
	beq	param_ls_cannot
;VXeRs[̈m
	move.l	#keepTail,d1
	and.l	#PAGE_MASK,d1		;ϊ镔̖Ȃ̂Ő؂̂Ă
	sub.l	#deviceHeader,d1
	and.l	#PAGE_MASK,d1		;060turbo.sys̏풓̒
	add.l	#$0001447A.and.PAGE_MASK,d1	;Human̒
	move.l	(localUpperStart)r,d0
	sub.l	d1,d0
	cmp.l	(localLowerEnd)r,d0
	blo	param_ls_over
	move.l	d0,(localUpperStart)r
	move.l	d0,(localSystemStart)r
	add.l	d1,d0
	move.l	d0,(localSystemEnd)r
	st.b	(localSystemArea)r
99:	rts

param_ls_nosimm:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-lz  -ls ͓Ɏwł܂D-ls ͖ł',13,10,0
	.even

param_ls_68030:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-ls  68030 ł͎wł܂D-ls ͖ł',13,10,0
	.even

param_ls_notrans:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-nt  -ls ͓Ɏwł܂D-ls ͖ł',13,10,0
	.even

param_ls_over:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'[JsĂ܂D-ls ͖ł',13,10,0
	.even

param_ls_cannot:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'[J܂D-ls ͖ł',13,10,0
	.even

;----------------------------------------------------------------
;@:	-np
;:	ȊÕfoCXĂяoŃf[^LbṼvbV
;	іs܂B
;	SCSI]͋IɃ\tg]ɂȂ܂B
param_np:
	tst.b	(deviceCacheNoPush)r
	bne	99f				;-np͊Ɏw肳ꂽ
	st.b	(patchIocsScsi)r		;SCSIIɃ\tg]ɂ
	st.b	(forceSoftScsi)r
	st.b	([$1C20.w],pDeviceNoPush)	;Human-np
	st.b	(deviceCacheNoPush)r
99:	rts

;----------------------------------------------------------------
;@:	-ad
;:	ADPCM֌WIOCSR[Ƀpb`Ăă[J璼
;	ڍĐł悤ɂ܂B
param_ad:
	st.b	(patchIocsAdpcm)r
	rts

;----------------------------------------------------------------
;@:	-lz
;:	SIMMĂĂgȂƂɂ܂B
param_lz:
	tst.b	(forceNoSimm)r
	bne	99f			;-lz͊Ɏw肳ꂽ
	tst.l	(localMemorySize)r
	beq	99f			;[JȂ
	tst.l	(localRamdiskAreaSize)r
	bne	param_lz_error
	tst.b	(localAreaDescriptor)r
	bne	param_lz_error
	tst.b	(localRomArea)r
	bne	param_lz_error
	tst.b	(useJointMode)r
	bne	param_lz_error
	tst.b	(jointMode)r
	bne	param_lz_error
	tst.b	(localSystemArea)r
	bne	param_lz_error
	clr.l	(localMemorySize)r
	move.l	(localMemoryStart)r,(localMemoryEnd)r
	clr.l	(localLowerStart)r
	clr.l	(localLowerEnd)r
	clr.l	(localUpperStart)r
	clr.l	(localUpperEnd)r
	clr.l	(localRamdiskAreaStart)r
	clr.l	(localRamdiskAreaEnd)r
	st.b	(forceNoSimm)r
99:	rts

param_lz_error:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-ld,-lr,-ls,-lt,-xm  -lz ͓Ɏwł܂D-lz ͖ł',13,10,0
	.even

;----------------------------------------------------------------
;@:	-nt
;:	AhXϊs܂B
;	@ю@Ɠ菇ŃLbVC[U悤
;	G~[^ł͎w肵ȂłB
;	-lr,-ls,-lt,-mm,-ts  -nt ͓Ɏwł܂B
param_nt:
	tst.b	(noTranslation)r
	bne	99f			;-nt͊Ɏw肳ꂽ(68030܂)
	tst.b	(localRomArea)r
	bne	param_nt_error		;-lrw肳Ă
	tst.b	(localSystemArea)r
	bne	param_nt_error		;-lsw肳Ă
	tst.b	(localAreaDescriptor)r
	bne	param_nt_error		;-ltw肳Ă
	tst.l	(mainMemorySize)r
	bpl	param_nt_error		;-mmw肳Ă
	tst.l	(descAreaSize)r
	bne	param_nt_error		;-tsw肳Ă
	st.b	(noTranslation)r
99:	rts

param_nt_error:
	lea.l	(@f,pc),a1
	bra	print
@@:	.dc.b	'-lr,-ls,-lt,-mm,-ts  -nt ͓Ɏwł܂D-nt ͖ł',13,10,0
	.even

;----------------------------------------------------------------
;𕄍Ȃ10iƌȂĐlɕϊ
;<a0.l:̃AhX
;>d0.l:l(0`$7FFFFFFF,-1=G[)
;>a0.l:̎̃AhX
;>n-flag:mi=G[
stou::
	move.l	d1,-(sp)
	moveq.l	#0,d0
	moveq.l	#0,d1
1:	move.b	(a0)+,d1
	sub.b	#'0',d1
	bcs	3f
	cmp.b	#10,d1
	bcc	3f
	mulu.l	#10,d0
	bvs	2f
	bmi	2f
	add.l	d1,d0
	bcs	2f
	bpl	1b
2:	moveq.l	#-1,d0
3:	subq.l	#1,a0
	move.l	(sp)+,d1
	tst.l	d0
	rts

;----------------------------------------------------------------
;\
print::
	move.l	d0,-(sp)
	move.l	a1,-(sp)
	DOS	_PRINT
	addq.l	#4,sp
	move.l	(sp)+,d0
	rts

;----------------------------------------------------------------
;16i8
hex8::
	movem.l	d1-d2,-(sp)
	moveq.l	#8-1,d2
1:	rol.l	#4,d0
	moveq.l	#$0F,d1
	and.b	d0,d1
	move.b	(2f,pc,d1.w),(a0)+
	dbra	d2,1b
	movem.l	(sp)+,d1-d2
	rts
2:	.dc.b	'0123456789ABCDEF'
