/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import javax.swing.JFrame;
import javax.swing.JPanel;
import xeij.ADPCM;
import xeij.ComponentFactory;
import xeij.FFT;
import xeij.Indicator;
import xeij.Multilingual;
import xeij.OPM;
import xeij.RestorableFrame;
import xeij.XEiJ;
import xeij.YM2151;

public class SoundMonitor {
    public static final int SMN_WIDTH = 488;
    public static final int SMN_OFFSET = 122;
    public static final byte SMN_BLACK = 0;
    public static final byte SMN_BLUE = 85;
    public static final byte SMN_ORANGE = -86;
    public static final byte SMN_WHITE = -1;
    public static final byte[] SMN_FONT_1 = new byte[635];
    public static final byte[] SMN_FONT_2 = new byte[635];
    public static final byte[] SMN_FONT_3 = new byte[635];
    public static final byte[] SMN_ICON_1 = "UT@\u0004A\u0004A\u0004A\u0004A\u0004A\u0004@\u0004UTUT@\u0004ED@DEDD\u0004ED@\u0004UTUT@\u0004ED@DED@DED@\u0004UTUT@\u0004DDDDED@D@D@\u0004UTUT@\u0004EDD\u0004ED@DED@\u0004UTUT@\u0004EDD\u0004EDDDED@\u0004UTUT@\u0004ED@D@D@D@D@\u0004UTUT@\u0004EDDDEDDDED@\u0004UTUT@\u0004DDDDEDEDDD@\u0004UTUT@\u0004ADD\u0004A\u0004@DE\u0004@\u0004UTUT@\u0004E\u0004DDE\u0004D\u0004D\u0004@\u0004UT".getBytes(XEiJ.ISO_8859_1);
    public static final byte[] SMN_ICON_3 = "\u00ff\u00fc\u00c0\f\u00c3\f\u00c3\f\u00c3\f\u00c3\f\u00c3\f\u00c0\f\u00ff\u00fc\u00ff\u00fc\u00c0\f\u00cf\u00cc\u00c0\u00cc\u00cf\u00cc\u00cc\f\u00cf\u00cc\u00c0\f\u00ff\u00fc\u00ff\u00fc\u00c0\f\u00cf\u00cc\u00c0\u00cc\u00cf\u00cc\u00c0\u00cc\u00cf\u00cc\u00c0\f\u00ff\u00fc\u00ff\u00fc\u00c0\f\u00cc\u00cc\u00cc\u00cc\u00cf\u00cc\u00c0\u00cc\u00c0\u00cc\u00c0\f\u00ff\u00fc\u00ff\u00fc\u00c0\f\u00cf\u00cc\u00cc\f\u00cf\u00cc\u00c0\u00cc\u00cf\u00cc\u00c0\f\u00ff\u00fc\u00ff\u00fc\u00c0\f\u00cf\u00cc\u00cc\f\u00cf\u00cc\u00cc\u00cc\u00cf\u00cc\u00c0\f\u00ff\u00fc\u00ff\u00fc\u00c0\f\u00cf\u00cc\u00c0\u00cc\u00c0\u00cc\u00c0\u00cc\u00c0\u00cc\u00c0\f\u00ff\u00fc\u00ff\u00fc\u00c0\f\u00cf\u00cc\u00cc\u00cc\u00cf\u00cc\u00cc\u00cc\u00cf\u00cc\u00c0\f\u00ff\u00fc\u00ff\u00fc\u00c0\f\u00cc\u00cc\u00cc\u00cc\u00cf\u00cc\u00cf\u00cc\u00cc\u00cc\u00c0\f\u00ff\u00fc\u00ff\u00fc\u00c0\f\u00c3\u00cc\u00cc\f\u00c3\f\u00c0\u00cc\u00cf\f\u00c0\f\u00ff\u00fc\u00ff\u00fc\u00c0\f\u00cf\f\u00cc\u00cc\u00cf\f\u00cc\f\u00cc\f\u00c0\f\u00ff\u00fc".getBytes(XEiJ.ISO_8859_1);
    public static final int SMN_WAVE_X = 12;
    public static final int SMN_WAVE_Y = 4;
    public static final int SMN_WAVE_WIDTH = 472;
    public static final int SMN_WAVE_VALUE_SHIFT = 11;
    public static final int SMN_WAVE_HEIGHT = 33;
    public static final int SMN_WAVE_SCALE_X_MAX = 5;
    public static final int SMN_WAVE_SCALE_Y_MAX = 3;
    public static final int[] smnOPMBuffer = new int[5000];
    public static final int[] smnPCMBuffer = new int[5000];
    public static final int[][] smnWaveIndex0 = new int[6][];
    public static final int[][] smnWaveIndex1 = new int[6][];
    public static int smnWaveScaleX;
    public static int smnWaveScaleY;
    public static int smnWaveOffsetMax;
    public static int smnWaveOffset;
    public static int smnWaveElevation;
    public static boolean smnWaveDragOn;
    public static int smnWavePressedX;
    public static int smnWavePressedY;
    public static final int[] smnWaveLastYPCMLeft;
    public static final int[] smnWaveLastYPCMRight;
    public static final int[] smnWaveLastYOPMLeft;
    public static final int[] smnWaveLastYOPMRight;
    public static final int SMN_SPECTRUM_X = 4;
    public static final int SMN_SPECTRUM_Y = 41;
    public static final int SMN_SPECTRUM_WIDTH = 480;
    public static final int SMN_SPECTRUM_HEIGHT = 32;
    public static final byte[] SMN_SPECTRUM_MAP;
    public static final int SMN_SPECTRUM_BIT = 10;
    public static final int SMN_SPECTRUM_N = 1024;
    public static final int SMN_SPECTRUM_PARTITIONS = 6;
    public static final int SMN_SPECTRUM_RANGE = 80;
    public static final int[] SMN_SPECTRUM_INTERVAL;
    public static final double[][] smnSpectrumBuffer;
    public static final double[] smnSpectrumX;
    public static final double[] smnSpectrumY;
    public static final int[] smnSpectrumIndex;
    public static final int[] smnSpectrumValue;
    public static final double[] smnSpectrumWindow;
    public static final int SMN_SPECTRUM_TRAIL = 2;
    public static final double SMN_SPECTRUM_SCALE = 64.0;
    public static FFT smnFFT;
    public static final int[] SMN_440HZ_PATTERN;
    public static final int SMN_KEY_X = 12;
    public static final int SMN_KEY_Y = 74;
    public static final int SMN_KEY_HEIGHT = 102;
    public static final byte[] SMN_KEY_COLOR;
    public static final int[] smnKey;
    public static final int SMN_TONE_X = 20;
    public static final int SMN_TONE_Y = 180;
    public static final int SMN_TONE_BOX_COLS = 38;
    public static final int SMN_TONE_BOX_HEIGHT = 46;
    public static final int SMN_TONE_HEIGHT = 134;
    public static final char[] SMN_TONE_H1;
    public static final char[] SMN_TONE_V0;
    public static final char[] SMN_TONE_H2;
    public static final char[] SMN_TONE_M1;
    public static final char[] SMN_TONE_V1;
    public static final char[] SMN_TONE_C1;
    public static final char[] SMN_TONE_V2;
    public static final char[] SMN_TONE_M2;
    public static final char[] SMN_TONE_V3;
    public static final char[] SMN_TONE_C2;
    public static final char[] SMN_TONE_V4;
    public static final int SMN_PCM_COL = 87;
    public static final int SMN_PCM_Y = 272;
    public static final char[][] SMN_PCM_OSCILLATOR;
    public static final char[][] SMN_PCM_DIVIDER;
    public static final char[][] SMN_PCM_FREQ;
    public static final char[][] SMN_PCM_PLAY;
    public static final char[][] SMN_PCM_DATA;
    public static final char[][] SMN_PCM_LEFT;
    public static final char[][] SMN_PCM_RIGHT;
    public static final int SMN_PALET_X = 324;
    public static final int SMN_PALET_Y = 284;
    public static final int SMN_PALET_WIDTH = 140;
    public static final int SMN_PALET_HEIGHT = 30;
    public static final int[][] SMN_SLIDER_ARRAY;
    public static final int[][] SMN_SLIDER_PATTERN;
    public static int smnPaletDragSlider;
    public static int smnPaletPressedX;
    public static IndexColorModel smnColorModel;
    public static final int SMN_PAUSE_WIDTH = 16;
    public static final int SMN_PAUSE_HEIGHT = 16;
    public static final int SMN_PAUSE_X = 468;
    public static final int SMN_PAUSE_Y = 294;
    public static final byte[] SMN_PAUSE_ICON_3;
    public static final byte[] SMN_PLAY_ICON_3;
    public static boolean smnPauseRequest;
    public static boolean smnPauseUpdate;
    public static final int SMN_ZOOM_WIDTH = 16;
    public static final int SMN_ZOOM_HEIGHT = 16;
    public static final int SMN_ZOOM_X = 468;
    public static final int SMN_ZOOM_Y = 270;
    public static final byte[] SMN_ZOOM_X1_ICON;
    public static final byte[] SMN_ZOOM_X2_ICON;
    public static int smnZoomRequest;
    public static int smnZoomShift;
    public static final int SMN_HEIGHT = 318;
    public static boolean smnIsVisible;
    public static BufferedImage smnImage;
    public static byte[] smnBitmap;
    public static JPanel smnPanel;
    public static JFrame smnFrame;

    public static void smnInit() {
        int n;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < 127; ++n2) {
            char c = Indicator.IND_ASCII_3X5[n2];
            int n4 = (int)(6075430939327988736L >>> (c >>> 9 & 0x38)) & 0xFF;
            SoundMonitor.SMN_FONT_1[n3] = (byte)n4;
            SoundMonitor.SMN_FONT_2[n3] = (byte)(n4 * 2);
            SoundMonitor.SMN_FONT_3[n3] = (byte)(n4 * 3);
            n4 = (int)(6075430939327988736L >>> (c >>> 6 & 0x38)) & 0xFF;
            SoundMonitor.SMN_FONT_1[++n3] = (byte)n4;
            SoundMonitor.SMN_FONT_2[n3] = (byte)(n4 * 2);
            SoundMonitor.SMN_FONT_3[n3] = (byte)(n4 * 3);
            n4 = (int)(6075430939327988736L >>> (c >>> 3 & 0x38)) & 0xFF;
            SoundMonitor.SMN_FONT_1[++n3] = (byte)n4;
            SoundMonitor.SMN_FONT_2[n3] = (byte)(n4 * 2);
            SoundMonitor.SMN_FONT_3[n3] = (byte)(n4 * 3);
            n4 = (int)(6075430939327988736L >>> (c & 0x38)) & 0xFF;
            SoundMonitor.SMN_FONT_1[++n3] = (byte)n4;
            SoundMonitor.SMN_FONT_2[n3] = (byte)(n4 * 2);
            SoundMonitor.SMN_FONT_3[n3] = (byte)(n4 * 3);
            n4 = (int)(6075430939327988736L >>> (c << 3 & 0x38)) & 0xFF;
            SoundMonitor.SMN_FONT_1[++n3] = (byte)n4;
            SoundMonitor.SMN_FONT_2[n3] = (byte)(n4 * 2);
            SoundMonitor.SMN_FONT_3[n3] = (byte)(n4 * 3);
            ++n3;
        }
        for (n3 = 0; n3 <= 5; ++n3) {
            n2 = 472 << n3;
            SoundMonitor.smnWaveIndex0[n3] = new int[n2];
            int[] nArray = SoundMonitor.smnWaveIndex0[n3];
            SoundMonitor.smnWaveIndex1[n3] = new int[n2];
            int[] nArray2 = SoundMonitor.smnWaveIndex1[n3];
            for (n = 0; n < n2; ++n) {
                nArray[n] = n * 2500 / n2 << 1;
                nArray2[n] = nArray[n] + 1;
            }
        }
        smnWaveScaleX = 0;
        smnWaveScaleY = 0;
        smnWaveOffsetMax = (472 << smnWaveScaleX) - 472;
        smnWaveOffset = 0;
        smnWaveElevation = 0;
        smnWaveDragOn = false;
        smnWavePressedX = -1;
        smnWavePressedY = -1;
        SoundMonitor.smnWaveLastYPCMLeft[0] = 0;
        SoundMonitor.smnWaveLastYPCMLeft[1] = 0;
        SoundMonitor.smnWaveLastYPCMRight[0] = 0;
        SoundMonitor.smnWaveLastYPCMRight[1] = 0;
        SoundMonitor.smnWaveLastYOPMLeft[0] = 0;
        SoundMonitor.smnWaveLastYOPMLeft[1] = 0;
        SoundMonitor.smnWaveLastYOPMRight[0] = 0;
        SoundMonitor.smnWaveLastYOPMRight[1] = 0;
        for (n3 = 0; n3 < 6; ++n3) {
            int n5;
            if (n3 != 1) {
                SoundMonitor.smnSpectrumBuffer[n3] = new double[1024];
            }
            double d = 7.20896 * (double)SMN_SPECTRUM_INTERVAL[n3];
            n = n5 + 80;
            for (n5 = 80 * n3; n5 < n; ++n5) {
                int n6 = (int)Math.floor(d * Math.pow(2.0, (double)(((48 + n5) / 56 - 1) * 96 + SMN_SPECTRUM_MAP[(48 + n5) % 56] - 459) / 96.0));
                int n7 = (int)Math.floor(d * Math.pow(2.0, (double)(((49 + n5) / 56 - 1) * 96 + SMN_SPECTRUM_MAP[(49 + n5) % 56] - 459) / 96.0)) - n6;
                SoundMonitor.smnSpectrumIndex[n5] = n7 << 16 | n6;
            }
        }
        Arrays.fill(smnSpectrumValue, -1);
        for (n3 = 0; n3 < 1024; ++n3) {
            SoundMonitor.smnSpectrumWindow[n3] = 0.5 * (1.0 - Math.cos(0.006135923151542565 * (double)n3));
        }
        smnFFT = new FFT(1024);
        smnPauseRequest = false;
        smnPauseUpdate = true;
        smnZoomRequest = 0;
        smnZoomShift = 1;
        smnPaletDragSlider = -1;
        smnPaletPressedX = 0;
    }

    public static void smnStart() {
        if (RestorableFrame.rfmGetOpened("smn")) {
            SoundMonitor.smnOpen();
        }
    }

    public static void smnOpen() {
        if (smnFrame == null) {
            SoundMonitor.smnMakeFrame();
        }
        smnIsVisible = true;
        SoundMonitor.smnUpdate();
        XEiJ.pnlExitFullScreen(false);
        smnFrame.setVisible(true);
    }

    public static void smnMakeFrame() {
        SoundMonitor.smnMakeImage();
        smnPanel = ComponentFactory.setFixedSize(new JPanel(){

            @Override
            public void paint(Graphics graphics) {
                if (smnZoomShift == 0) {
                    graphics.drawImage(smnImage, 0, 0, null);
                } else {
                    graphics.drawImage(smnImage, 0, 0, 488 << smnZoomShift, 318 << smnZoomShift, 0, 0, 488, 318, null);
                }
            }

            @Override
            protected void paintComponent(Graphics graphics) {
            }

            @Override
            protected void paintBorder(Graphics graphics) {
            }

            @Override
            protected void paintChildren(Graphics graphics) {
            }

            @Override
            public void update(Graphics graphics) {
            }
        }, 488, 318);
        smnPanel.setOpaque(true);
        ComponentFactory.addListener(smnPanel, new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = mouseEvent.getX() >> smnZoomShift;
                int n2 = mouseEvent.getY() >> smnZoomShift;
                int n3 = mouseEvent.getButton();
                int n4 = mouseEvent.getModifiersEx();
                if (12 <= n && n < 484 && 4 <= n2 && n2 < 37) {
                    if ((n4 & 0x40) == 0) {
                        int n5 = 0;
                        if (n3 == 1) {
                            if (smnWaveScaleX < 5) {
                                n5 = 1;
                            }
                        } else if (n3 == 3 && 0 < smnWaveScaleX) {
                            n5 = -1;
                        }
                        if (n5 != 0) {
                            smnWaveOffsetMax = (472 << (smnWaveScaleX += n5)) - 472;
                            int n6 = n - 12;
                            smnWaveOffset = Math.max(0, Math.min(smnWaveOffsetMax, (n5 >= 0 ? smnWaveOffset + n6 << n5 : smnWaveOffset + n6 >> -n5) - n6));
                            if (smnPauseUpdate) {
                                SoundMonitor.smnWavePaint();
                                smnPanel.repaint();
                            }
                        }
                    } else {
                        int n7 = 0;
                        if (n3 == 1) {
                            if (smnWaveScaleY < 3) {
                                n7 = 1;
                            }
                        } else if (n3 == 3 && 0 < smnWaveScaleY) {
                            n7 = -1;
                        }
                        if (n7 != 0) {
                            int n8 = (16 << (smnWaveScaleY += n7)) - 16;
                            int n9 = n2 - 20;
                            smnWaveElevation = Math.max(-n8, Math.min(n8, (n7 >= 0 ? smnWaveElevation + n9 << n7 : smnWaveElevation + n9 >> -n7) - n9));
                            if (smnPauseUpdate) {
                                SoundMonitor.smnWavePaint();
                                smnPanel.repaint();
                            }
                        }
                    }
                } else if (468 <= n && n < 484 && 294 <= n2 && n2 < 310) {
                    smnPauseRequest = !smnPauseRequest;
                } else if (468 <= n && n < 484 && 270 <= n2 && n2 < 286) {
                    smnZoomRequest = smnZoomShift ^ 1;
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getX() >> smnZoomShift;
                int n2 = mouseEvent.getY() >> smnZoomShift;
                smnWaveDragOn = false;
                smnPaletDragSlider = -1;
                if (12 <= n && n < 484 && 4 <= n2 && n2 < 37) {
                    smnWaveDragOn = true;
                    smnWavePressedX = n;
                    smnWavePressedY = n2;
                } else if (324 <= n && n < 464 && 284 <= n2 && n2 < 314) {
                    for (int i = 0; i < SMN_SLIDER_ARRAY.length; ++i) {
                        int[] nArray = SMN_SLIDER_ARRAY[i];
                        int n3 = nArray[0];
                        int n4 = nArray[1];
                        int n5 = nArray[2];
                        int n6 = nArray[4];
                        if (n3 > n || n >= n3 + n5 + 4 || n4 > n2 || n2 >= n4 + 5) continue;
                        smnPaletDragSlider = i;
                        smnPaletPressedX = n;
                        if (n >= n3 + n6 && n3 + n6 + 4 > n) break;
                        nArray[4] = Math.max(0, Math.min(n5, n - n3));
                        SoundMonitor.smnDrawPaletSlider();
                        SoundMonitor.smnUpdateColor();
                        break;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                smnWaveDragOn = false;
                smnPaletDragSlider = -1;
            }
        });
        ComponentFactory.addListener(smnPanel, new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                int n = mouseEvent.getX() >> smnZoomShift;
                int n2 = mouseEvent.getY() >> smnZoomShift;
                if (smnWaveDragOn) {
                    int n3 = Math.max(0, Math.min(smnWaveOffsetMax, smnWaveOffset - (n - smnWavePressedX)));
                    int n4 = (16 << smnWaveScaleY) - 16;
                    int n5 = Math.max(-n4, Math.min(n4, smnWaveElevation - (n2 - smnWavePressedY)));
                    smnWavePressedX = n;
                    smnWavePressedY = n2;
                    if (smnWaveOffset != n3 || smnWaveElevation != n5) {
                        smnWaveOffset = n3;
                        smnWaveElevation = n5;
                        if (smnPauseUpdate) {
                            SoundMonitor.smnWavePaint();
                            smnPanel.repaint();
                        }
                    }
                } else if (smnPaletDragSlider >= 0) {
                    int[] nArray = SMN_SLIDER_ARRAY[smnPaletDragSlider];
                    int n6 = nArray[2];
                    int n7 = nArray[4];
                    nArray[4] = Math.max(0, Math.min(n6, n7 + n - smnPaletPressedX));
                    smnPaletPressedX = n;
                    SoundMonitor.smnDrawPaletSlider();
                    SoundMonitor.smnUpdateColor();
                }
            }
        });
        smnFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("smn", "Sound Monitor", null, smnPanel, false), "ja", "\u97f3\u58f0\u30e2\u30cb\u30bf");
        ComponentFactory.addListener(smnFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                smnIsVisible = false;
            }
        });
    }

    public static void smnMakeImage() {
        int n;
        SoundMonitor.smnMakeColorModel();
        smnImage = new BufferedImage(488, 318, 12, smnColorModel);
        smnBitmap = ((DataBufferByte)smnImage.getRaster().getDataBuffer()).getData();
        byte[] byArray = smnBitmap;
        SoundMonitor.smnDrawIcon3(1, 41, 9);
        SoundMonitor.smnDrawPattern(279, 74, SMN_440HZ_PATTERN);
        for (n = 0; n < 8; ++n) {
            SoundMonitor.smnDrawIcon3(1, 80 + 12 * n, n);
            SoundMonitor.smnKey[n] = -1;
            int n2 = 0;
            int n3 = 3 + 122 * (80 + 12 * n);
            while (true) {
                SoundMonitor.smnDrawChar1(3 + 14 * n2, 74, 48 + n2);
                SoundMonitor.smnPaintKey(n3, 0, SMN_KEY_COLOR[0]);
                SoundMonitor.smnPaintKey(n3 + 1, 1, SMN_KEY_COLOR[1]);
                SoundMonitor.smnPaintKey(n3 + 2, 2, SMN_KEY_COLOR[2]);
                SoundMonitor.smnPaintKey(n3 + 3, 3, SMN_KEY_COLOR[3]);
                SoundMonitor.smnPaintKey(n3 + 4, 4, SMN_KEY_COLOR[4]);
                if (n2 == 8) break;
                SoundMonitor.smnPaintKey(n3 + 6, 5, SMN_KEY_COLOR[5]);
                SoundMonitor.smnPaintKey(n3 + 7, 6, SMN_KEY_COLOR[6]);
                SoundMonitor.smnPaintKey(n3 + 8, 7, SMN_KEY_COLOR[7]);
                SoundMonitor.smnPaintKey(n3 + 9, 8, SMN_KEY_COLOR[8]);
                SoundMonitor.smnPaintKey(n3 + 10, 9, SMN_KEY_COLOR[9]);
                SoundMonitor.smnPaintKey(n3 + 11, 10, SMN_KEY_COLOR[10]);
                SoundMonitor.smnPaintKey(n3 + 12, 11, SMN_KEY_COLOR[11]);
                ++n2;
                n3 += 14;
            }
            n2 = 5 + 38 * (18724 >> (n << 1) & 3);
            n3 = 180 + 46 * (42304 >> (n << 1) & 3);
            SoundMonitor.smnDrawIcon3(n2, n3, n);
            SoundMonitor.smnDrawString1(3 + n2, n3, SMN_TONE_H1);
            SoundMonitor.smnDrawString1(3 + n2, 12 + n3, SMN_TONE_H2);
            SoundMonitor.smnDrawString1(n2, 18 + n3, SMN_TONE_M1);
            SoundMonitor.smnDrawString1(n2, 24 + n3, SMN_TONE_C1);
            SoundMonitor.smnDrawString1(n2, 30 + n3, SMN_TONE_M2);
            SoundMonitor.smnDrawString1(n2, 36 + n3, SMN_TONE_C2);
        }
        SoundMonitor.smnDrawIcon3(87, 272, 10);
        SoundMonitor.smnDrawString3(92, 272, "MHz");
        SoundMonitor.smnDrawString3(96, 272, "1/");
        SoundMonitor.smnDrawString3(107, 272, "kHz");
        SoundMonitor.smnDrawChar1(89, 284, 72);
        SoundMonitor.smnDrawChar1(101, 284, 83);
        SoundMonitor.smnDrawChar1(111, 284, 66);
        for (n = 0; n < 4; ++n) {
            SoundMonitor.smnDrawChar1(81, 290 + 6 * n, 48 + n);
        }
        SoundMonitor.smnDrawPaletSlider();
    }

    public static void smnDrawPaletSlider() {
        for (int i = 0; i < 4; ++i) {
            int[] nArray = SMN_SLIDER_PATTERN[i];
            SoundMonitor.smnDrawSlider(SMN_SLIDER_ARRAY[3 * i], nArray);
            SoundMonitor.smnDrawSlider(SMN_SLIDER_ARRAY[3 * i + 1], nArray);
            SoundMonitor.smnDrawSlider(SMN_SLIDER_ARRAY[3 * i + 2], nArray);
        }
    }

    public static void smnMakeColorModel() {
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int n = Color.HSBtoRGB((float)SMN_SLIDER_ARRAY[3 * i][4] / 48.0f, (float)SMN_SLIDER_ARRAY[3 * i + 1][4] / 32.0f, (float)SMN_SLIDER_ARRAY[3 * i + 2][4] / 32.0f);
            byArray[i] = (byte)(n >> 16);
            byArray2[i] = (byte)(n >> 8);
            byArray3[i] = (byte)n;
        }
        smnColorModel = new IndexColorModel(2, 4, byArray, byArray2, byArray3);
    }

    public static void smnUpdateColor() {
        SoundMonitor.smnMakeColorModel();
        smnImage = new BufferedImage(smnColorModel, smnImage.getRaster(), false, null);
        smnPanel.repaint();
    }

    public static void smnUpdate() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        byte[] byArray = smnBitmap;
        if (smnZoomShift != smnZoomRequest) {
            int n9;
            smnZoomShift = smnZoomRequest;
            byte[] byArray2 = smnZoomShift == 0 ? SMN_ZOOM_X2_ICON : SMN_ZOOM_X1_ICON;
            n8 = 33057;
            n7 = 0;
            for (n6 = 0; n6 < 16; ++n6) {
                for (n9 = 0; n9 < 16; n9 += 4) {
                    byArray[n8++] = byArray2[n7++];
                }
                n8 += 118;
            }
            n6 = 488 << smnZoomShift;
            n9 = 318 << smnZoomShift;
            n5 = smnFrame.getWidth() - smnPanel.getWidth();
            n4 = smnFrame.getHeight() - smnPanel.getHeight();
            ComponentFactory.setFixedSize(smnFrame, n6 + n5, n9 + n4);
            smnFrame.setResizable(false);
            ComponentFactory.setFixedSize(smnPanel, n6, n9);
            smnFrame.pack();
        }
        if (smnPauseUpdate) {
            if (smnPauseRequest) {
                return;
            }
            smnPauseUpdate = false;
            int n10 = 35985;
            n8 = 0;
            for (n7 = 0; n7 < 16; ++n7) {
                for (n6 = 0; n6 < 16; n6 += 4) {
                    byArray[n10++] = SMN_PAUSE_ICON_3[n8++];
                }
                n10 += 118;
            }
        } else if (smnPauseRequest) {
            smnPauseUpdate = true;
            int n11 = 35985;
            n8 = 0;
            for (n7 = 0; n7 < 16; ++n7) {
                for (n6 = 0; n6 < 16; n6 += 4) {
                    byArray[n11++] = SMN_PLAY_ICON_3[n8++];
                }
                n11 += 118;
            }
            smnPanel.repaint();
            return;
        }
        System.arraycopy(OPM.opmBuffer, 0, smnOPMBuffer, 0, 5000);
        System.arraycopy(ADPCM.pcmBuffer, 0, smnPCMBuffer, 0, 5000);
        SoundMonitor.smnWavePaint();
        double[] dArray = smnSpectrumBuffer[0];
        double[] dArray2 = smnSpectrumBuffer[2];
        double[] dArray3 = smnSpectrumBuffer[3];
        double[] dArray4 = smnSpectrumBuffer[4];
        double[] dArray5 = smnSpectrumBuffer[5];
        System.arraycopy(dArray5, 500, dArray5, 0, 524);
        n5 = 524;
        n4 = 0;
        while (n5 < 1024) {
            dArray5[n5] = (double)(OPM.opmBuffer[n4] + OPM.opmBuffer[n4 + 1] + ADPCM.pcmBuffer[n4] + ADPCM.pcmBuffer[n4 + 1] + OPM.opmBuffer[n4 + 2] + OPM.opmBuffer[n4 + 3] + ADPCM.pcmBuffer[n4 + 2] + ADPCM.pcmBuffer[n4 + 3] + OPM.opmBuffer[n4 + 4] + OPM.opmBuffer[n4 + 5] + ADPCM.pcmBuffer[n4 + 4] + ADPCM.pcmBuffer[n4 + 5] + OPM.opmBuffer[n4 + 6] + OPM.opmBuffer[n4 + 7] + ADPCM.pcmBuffer[n4 + 6] + ADPCM.pcmBuffer[n4 + 7] + OPM.opmBuffer[n4 + 8] + OPM.opmBuffer[n4 + 9] + ADPCM.pcmBuffer[n4 + 8] + ADPCM.pcmBuffer[n4 + 9]) * 3.0517578125E-6;
            ++n5;
            n4 += 10;
        }
        System.arraycopy(dArray4, 250, dArray4, 0, 774);
        n5 = 774;
        n4 = 524;
        while (n5 < 1024) {
            dArray4[n5] = (dArray5[n4] + dArray5[n4 + 1]) * 0.5;
            ++n5;
            n4 += 2;
        }
        System.arraycopy(dArray3, 100, dArray3, 0, 924);
        n5 = 924;
        n4 = 524;
        while (n5 < 1024) {
            dArray3[n5] = (dArray5[n4] + dArray5[n4 + 1] + dArray5[n4 + 2] + dArray5[n4 + 3] + dArray5[n4 + 4]) * 0.2;
            ++n5;
            n4 += 5;
        }
        System.arraycopy(dArray2, 50, dArray2, 0, 974);
        n5 = 974;
        n4 = 924;
        while (n5 < 1024) {
            dArray2[n5] = (dArray3[n4] + dArray3[n4 + 1]) * 0.5;
            ++n5;
            n4 += 2;
        }
        System.arraycopy(dArray, 25, dArray, 0, 999);
        n5 = 999;
        n4 = 974;
        while (n5 < 1024) {
            dArray[n5] = (dArray2[n4] + dArray2[n4 + 1]) * 0.5;
            ++n5;
            n4 += 2;
        }
        for (n5 = 0; n5 < 6; ++n5) {
            int n12;
            if (n5 != 1) {
                double[] dArray6 = smnSpectrumBuffer[n5];
                for (n12 = 0; n12 < 1024; ++n12) {
                    SoundMonitor.smnSpectrumX[n12] = smnSpectrumWindow[n12] * dArray6[n12];
                }
                Arrays.fill(smnSpectrumY, 0, 1024, 0.0);
                smnFFT.fftSandeTukey4(smnSpectrumX, smnSpectrumY);
            }
            n12 = n4 + 80;
            int n13 = 6;
            for (n4 = n5 == 0 ? 8 : 80 * n5; n4 < n12; ++n4) {
                int n14 = smnSpectrumIndex[n4];
                int n15 = n14 >> 16;
                n14 = (char)n14;
                double d = smnSpectrumX[n14];
                while (--n15 > 0) {
                    d = Math.max(d, smnSpectrumX[++n14]);
                }
                n3 = Math.max(0, Math.min(31, (int)(2.0 * d)));
                if (n3 > (n2 = smnSpectrumValue[n4])) {
                    SoundMonitor.smnSpectrumValue[n4] = n3;
                    n = 122 * (72 - n3) + 1 + (n4 >> 2);
                    while (n3 > n2) {
                        byArray[n] = (byte)(byArray[n] & ~(3 << n13) | 3 << n13);
                        n += 122;
                        --n3;
                    }
                } else if (n3 < n2) {
                    if (n3 < n2 - 2) {
                        n3 = n2 - 2;
                    }
                    SoundMonitor.smnSpectrumValue[n4] = n3;
                    n = 122 * (72 - n2) + 1 + (n4 >> 2);
                    while (n3 < n2) {
                        byArray[n] = (byte)(byArray[n] & ~(3 << n13));
                        n += 122;
                        ++n3;
                    }
                }
                n13 = n13 - 2 & 6;
            }
        }
        for (n5 = 0; n5 < 8; ++n5) {
            int n16;
            int n17;
            int n18;
            int n19;
            YM2151.fm_channel fm_channel2 = OPM.opmYM2151.m_channel[n5];
            YM2151.fm_operator fm_operator2 = fm_channel2.m_op[0];
            YM2151.fm_operator fm_operator3 = fm_channel2.m_op[1];
            YM2151.fm_operator fm_operator4 = fm_channel2.m_op[2];
            YM2151.fm_operator fm_operator5 = fm_channel2.m_op[3];
            int n20 = smnKey[n5];
            int n21 = fm_operator2.m_env_state < 4 ? -1 : (n19 = fm_operator2.m_env_attenuation < 896 ? 0 : 1);
            int n22 = fm_operator3.m_env_state < 4 ? -1 : (n3 = fm_operator3.m_env_attenuation < 896 ? 0 : 1);
            int n23 = fm_operator4.m_env_state < 4 ? -1 : (n2 = fm_operator4.m_env_attenuation < 896 ? 0 : 1);
            int n24 = fm_operator5.m_env_state < 4 ? -1 : (n = fm_operator5.m_env_attenuation < 896 ? 0 : 1);
            if (n19 > 0 && n3 > 0 && n2 > 0 && n > 0) {
                n18 = -1;
            } else {
                n17 = OPM.opmRegister[40 + n5] & 0x7F;
                n16 = OPM.opmRegister[48 + n5] >> 2 & 0x3F;
                n18 = (n17 - (n17 >> 2) << 6 | n16) + 192 + 26 >> 6;
                if (n19 >= 0 && n3 >= 0 && n2 >= 0 && n >= 0) {
                    n18 |= 0x10000;
                }
            }
            if (n20 != n18) {
                int n25;
                n17 = 3 + 122 * (80 + 12 * n5);
                if (n20 >= 0 && (short)n20 != (short)n18) {
                    n16 = (short)n20;
                    SoundMonitor.smnPaintKey(n17 + 14 * n25 + ((n16 -= 12 * (n25 = n16 * 43 >>> 9)) < 5 ? n16 : n16 + 1), n16, SMN_KEY_COLOR[n16]);
                }
                if (n18 >= 0 && n20 != n18) {
                    n16 = (short)n18;
                    n25 = n16 * 43 >>> 9;
                    n16 -= 12 * n25;
                    if (n18 >> 16 == 0) {
                        SoundMonitor.smnPaintKey(n17 + 14 * n25 + (n16 < 5 ? n16 : n16 + 1), n16, -86);
                    } else {
                        SoundMonitor.smnPaintKey2(n17 + 14 * n25 + (n16 < 5 ? n16 : n16 + 1), n16, SMN_KEY_COLOR[n16], -86);
                    }
                }
                SoundMonitor.smnKey[n5] = n18;
            }
            XEiJ.fmtHex2(SMN_TONE_V0, 0, OPM.opmRegister[32 + n5] & 0x3F);
            XEiJ.fmtHex2(SMN_TONE_V0, 3, OPM.opmRegister[256 + n5]);
            XEiJ.fmtHex2(SMN_TONE_V0, 6, OPM.opmRegister[27] & 3);
            XEiJ.fmtHex2(SMN_TONE_V0, 9, 0);
            XEiJ.fmtHex2(SMN_TONE_V0, 12, OPM.opmRegister[24] & 0xFF);
            XEiJ.fmtHex2(SMN_TONE_V0, 15, OPM.opmRegister[265]);
            XEiJ.fmtHex2(SMN_TONE_V0, 18, OPM.opmRegister[264]);
            XEiJ.fmtHex2(SMN_TONE_V0, 21, OPM.opmRegister[56 + n5] >> 4 & 7);
            XEiJ.fmtHex2(SMN_TONE_V0, 24, OPM.opmRegister[56 + n5] & 3);
            XEiJ.fmtHex2(SMN_TONE_V0, 27, OPM.opmRegister[32 + n5] >> 6 & 3);
            XEiJ.fmtHex2(SMN_TONE_V1, 0, OPM.opmRegister[128 + n5] & 0x1F);
            XEiJ.fmtHex2(SMN_TONE_V2, 0, OPM.opmRegister[144 + n5] & 0x1F);
            XEiJ.fmtHex2(SMN_TONE_V3, 0, OPM.opmRegister[136 + n5] & 0x1F);
            XEiJ.fmtHex2(SMN_TONE_V4, 0, OPM.opmRegister[152 + n5] & 0x1F);
            XEiJ.fmtHex2(SMN_TONE_V1, 3, OPM.opmRegister[160 + n5] & 0x1F);
            XEiJ.fmtHex2(SMN_TONE_V2, 3, OPM.opmRegister[176 + n5] & 0x1F);
            XEiJ.fmtHex2(SMN_TONE_V3, 3, OPM.opmRegister[168 + n5] & 0x1F);
            XEiJ.fmtHex2(SMN_TONE_V4, 3, OPM.opmRegister[184 + n5] & 0x1F);
            XEiJ.fmtHex2(SMN_TONE_V1, 6, OPM.opmRegister[192 + n5] & 0x1F);
            XEiJ.fmtHex2(SMN_TONE_V2, 6, OPM.opmRegister[208 + n5] & 0x1F);
            XEiJ.fmtHex2(SMN_TONE_V3, 6, OPM.opmRegister[200 + n5] & 0x1F);
            XEiJ.fmtHex2(SMN_TONE_V4, 6, OPM.opmRegister[216 + n5] & 0x1F);
            XEiJ.fmtHex2(SMN_TONE_V1, 9, OPM.opmRegister[224 + n5] & 0xF);
            XEiJ.fmtHex2(SMN_TONE_V2, 9, OPM.opmRegister[240 + n5] & 0xF);
            XEiJ.fmtHex2(SMN_TONE_V3, 9, OPM.opmRegister[232 + n5] & 0xF);
            XEiJ.fmtHex2(SMN_TONE_V4, 9, OPM.opmRegister[248 + n5] & 0xF);
            XEiJ.fmtHex2(SMN_TONE_V1, 12, OPM.opmRegister[224 + n5] >> 4 & 0xF);
            XEiJ.fmtHex2(SMN_TONE_V2, 12, OPM.opmRegister[240 + n5] >> 4 & 0xF);
            XEiJ.fmtHex2(SMN_TONE_V3, 12, OPM.opmRegister[232 + n5] >> 4 & 0xF);
            XEiJ.fmtHex2(SMN_TONE_V4, 12, OPM.opmRegister[248 + n5] >> 4 & 0xF);
            XEiJ.fmtHex2(SMN_TONE_V1, 15, OPM.opmRegister[96 + n5] & 0x7F);
            XEiJ.fmtHex2(SMN_TONE_V2, 15, OPM.opmRegister[112 + n5] & 0x7F);
            XEiJ.fmtHex2(SMN_TONE_V3, 15, OPM.opmRegister[104 + n5] & 0x7F);
            XEiJ.fmtHex2(SMN_TONE_V4, 15, OPM.opmRegister[120 + n5] & 0x7F);
            XEiJ.fmtHex2(SMN_TONE_V1, 18, OPM.opmRegister[128 + n5] >> 6 & 3);
            XEiJ.fmtHex2(SMN_TONE_V2, 18, OPM.opmRegister[144 + n5] >> 6 & 3);
            XEiJ.fmtHex2(SMN_TONE_V3, 18, OPM.opmRegister[136 + n5] >> 6 & 3);
            XEiJ.fmtHex2(SMN_TONE_V4, 18, OPM.opmRegister[152 + n5] >> 6 & 3);
            XEiJ.fmtHex2(SMN_TONE_V1, 21, OPM.opmRegister[64 + n5] & 0xF);
            XEiJ.fmtHex2(SMN_TONE_V2, 21, OPM.opmRegister[80 + n5] & 0xF);
            XEiJ.fmtHex2(SMN_TONE_V3, 21, OPM.opmRegister[72 + n5] & 0xF);
            XEiJ.fmtHex2(SMN_TONE_V4, 21, OPM.opmRegister[88 + n5] & 0xF);
            XEiJ.fmtHex2(SMN_TONE_V1, 24, OPM.opmRegister[64 + n5] >> 4 & 7);
            XEiJ.fmtHex2(SMN_TONE_V2, 24, OPM.opmRegister[80 + n5] >> 4 & 7);
            XEiJ.fmtHex2(SMN_TONE_V3, 24, OPM.opmRegister[72 + n5] >> 4 & 7);
            XEiJ.fmtHex2(SMN_TONE_V4, 24, OPM.opmRegister[88 + n5] >> 4 & 7);
            XEiJ.fmtHex2(SMN_TONE_V1, 27, OPM.opmRegister[192 + n5] >> 6 & 3);
            XEiJ.fmtHex2(SMN_TONE_V2, 27, OPM.opmRegister[208 + n5] >> 6 & 3);
            XEiJ.fmtHex2(SMN_TONE_V3, 27, OPM.opmRegister[200 + n5] >> 6 & 3);
            XEiJ.fmtHex2(SMN_TONE_V4, 27, OPM.opmRegister[216 + n5] >> 6 & 3);
            XEiJ.fmtHex2(SMN_TONE_V1, 30, OPM.opmRegister[160 + n5] >> 7 & 1);
            XEiJ.fmtHex2(SMN_TONE_V2, 30, OPM.opmRegister[176 + n5] >> 7 & 1);
            XEiJ.fmtHex2(SMN_TONE_V3, 30, OPM.opmRegister[168 + n5] >> 7 & 1);
            XEiJ.fmtHex2(SMN_TONE_V4, 30, OPM.opmRegister[184 + n5] >> 7 & 1);
            n17 = 5 + 38 * (18724 >> (n5 << 1) & 3);
            n16 = 180 + 46 * (42304 >> (n5 << 1) & 3);
            SoundMonitor.smnDrawString3(3 + n17, 6 + n16, SMN_TONE_V0);
            SoundMonitor.smnDrawString3(3 + n17, 18 + n16, SMN_TONE_V1);
            SoundMonitor.smnDrawString3(3 + n17, 24 + n16, SMN_TONE_V2);
            SoundMonitor.smnDrawString3(3 + n17, 30 + n16, SMN_TONE_V3);
            SoundMonitor.smnDrawString3(3 + n17, 36 + n16, SMN_TONE_V4);
        }
        SoundMonitor.smnDrawString3(90, 272, SMN_PCM_OSCILLATOR[ADPCM.pcmOSCFreqMode << 1 | ADPCM.pcmOscillator]);
        SoundMonitor.smnDrawString3(98, 272, SMN_PCM_DIVIDER[ADPCM.pcmDivider]);
        SoundMonitor.smnDrawString3(103, 272, SMN_PCM_FREQ[ADPCM.pcmOSCFreqMode << 3 | ADPCM.pcmOscillator << 2 | ADPCM.pcmDivider]);
        SoundMonitor.smnDrawString2(90, 278, SMN_PCM_PLAY[ADPCM.pcmActive ? 1 : 0]);
        SoundMonitor.smnDrawString2(95, 278, SMN_PCM_DATA[ADPCM.pcmEncodedData >= 0 ? 1 : 0]);
        SoundMonitor.smnDrawString2(100, 278, SMN_PCM_LEFT[ADPCM.pcmPanLeft == 0 || ADPCM.pcmPanLeft < -2147481600 ? 0 : 1]);
        SoundMonitor.smnDrawString2(105, 278, SMN_PCM_RIGHT[ADPCM.pcmPanRight == 0 || ADPCM.pcmPanRight < -2147481600 ? 0 : 1]);
        smnPanel.repaint();
    }

    public static void smnWavePaint() {
        int n;
        byte[] byArray = smnBitmap;
        Arrays.fill(byArray, 488, 4514, (byte)0);
        SoundMonitor.smnDrawIcon3(1, 4, 8);
        if (-16 <= smnWaveElevation && smnWaveElevation <= 16) {
            n = 122 * (20 - smnWaveElevation) + 3;
            Arrays.fill(byArray, n, n + 118, (byte)85);
        }
        n = (40 * smnWaveOffset + (472 << smnWaveScaleX) - 1) / (472 << smnWaveScaleX);
        int n2 = 40 * (smnWaveOffset + 472) / (472 << smnWaveScaleX);
        for (int i = n; i <= n2; ++i) {
            int n3;
            int n4;
            int n5 = Math.max(0, Math.min(471, (11800 * i * 8389 >>> 23 << smnWaveScaleX) - smnWaveOffset));
            int n6 = (~n5 & 3) << 1;
            if (n2 - n <= 10 || n2 - n <= 20 && -8925843906633654008L << i < 0L || -9214356032908681208L << i < 0L) {
                n4 = XEiJ.FMT_BCD4[i];
                n3 = 3 + Math.max(0, Math.min(118 - (n4 >= 16 ? 4 : 3), (n5 + 3 >> 2) - (n4 >= 16 ? 2 : 1)));
                if (n4 >= 16) {
                    SoundMonitor.smnDrawChar1(n3++, 31, 0x30 | n4 >> 4);
                }
                SoundMonitor.smnDrawChar1(n3, 31, 0x30 | n4 & 0xF);
                SoundMonitor.smnDrawChar1(n3 + 1, 31, 109);
                SoundMonitor.smnDrawChar1(n3 + 2, 31, 115);
            }
            if (-9214356032908681208L << i < 0L) {
                n4 = 8;
                n3 = 24;
            } else if (-8925843906633654008L << i < 0L) {
                n4 = 10;
                n3 = 22;
            } else {
                n4 = 12;
                n3 = 20;
            }
            n3 -= smnWaveElevation;
            if ((n4 -= smnWaveElevation) < 0) {
                n4 = 0;
            }
            if (n3 > 32) {
                n3 = 32;
            }
            int n7 = 122 * (4 + n4) + 3 + (n5 >> 2);
            for (int j = n4; j <= n3; ++j) {
                byArray[n7] = (byte)(byArray[n7] & ~(3 << n6) | 1 << n6);
                n7 += 122;
            }
        }
        SoundMonitor.smnWavePaint1(smnPCMBuffer, smnWaveIndex0[smnWaveScaleX], 2, smnWaveLastYPCMLeft);
        SoundMonitor.smnWavePaint1(smnPCMBuffer, smnWaveIndex1[smnWaveScaleX], 2, smnWaveLastYPCMRight);
        SoundMonitor.smnWavePaint1(smnOPMBuffer, smnWaveIndex0[smnWaveScaleX], 3, smnWaveLastYOPMLeft);
        SoundMonitor.smnWavePaint1(smnOPMBuffer, smnWaveIndex1[smnWaveScaleX], 3, smnWaveLastYOPMRight);
    }

    public static void smnWavePaint1(int[] nArray, int[] nArray2, int n, int[] nArray3) {
        byte[] byArray = smnBitmap;
        int n2 = smnWaveOffset;
        int n3 = nArray3[0];
        int n4 = nArray3[1];
        int n5 = 11 - smnWaveScaleY;
        int n6 = 6;
        for (int i = 0; i < 472; ++i) {
            int n7;
            int n8;
            int n9 = nArray[nArray2[n2 + i]];
            int n10 = 16 - (n9 + (n9 >>> -n5) >> n5);
            if (n3 < n4) {
                if (n4 < n10) {
                    n8 = n3 + n4 >> 1;
                    n7 = n4 + n10 >> 1;
                } else if (n3 < n10) {
                    n8 = n3 + n4 >> 1;
                    n7 = n4;
                } else {
                    n8 = n4 + n10 >> 1;
                    n7 = n4;
                }
            } else if (n3 < n10) {
                n8 = n4;
                n7 = n4 + n10 >> 1;
            } else if (n4 < n10) {
                n8 = n4;
                n7 = n3 + n4 >> 1;
            } else {
                n8 = n4 + n10 >> 1;
                n7 = n3 + n4 >> 1;
            }
            n7 -= smnWaveElevation;
            if ((n8 -= smnWaveElevation) < 0) {
                n8 = 0;
            }
            if (n7 > 32) {
                n7 = 32;
            }
            for (int j = n8; j <= n7; ++j) {
                int n11 = 122 * (4 + j) + 3 + (i >> 2);
                byArray[n11] = (byte)(byArray[n11] & ~(3 << n6) | n << n6);
            }
            n3 = n4;
            n4 = n10;
            n6 = n6 - 2 & 6;
        }
        nArray3[0] = n3;
        nArray3[1] = n4;
    }

    public static void smnPaintKey(int n, int n2, int n3) {
        int n4 = n3 & 0xFC;
        byte[] byArray = smnBitmap;
        switch (n2) {
            case 0: 
            case 5: {
                byte by = (byte)n3;
                byArray[1220 + n] = by;
                byArray[1098 + n] = by;
                byArray[976 + n] = by;
                byArray[854 + n] = by;
                byArray[732 + n] = by;
                byte by2 = (byte)n4;
                byArray[1221 + n] = by2;
                byArray[1099 + n] = by2;
                byArray[977 + n] = by2;
                byArray[855 + n] = by2;
                byArray[733 + n] = by2;
                byArray[610 + n] = by2;
                byArray[488 + n] = by2;
                byArray[366 + n] = by2;
                byArray[244 + n] = by2;
                byArray[122 + n] = by2;
                byArray[n] = by2;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                byte by = (byte)n3;
                byArray[488 + n] = by;
                byArray[366 + n] = by;
                byArray[244 + n] = by;
                byArray[122 + n] = by;
                byArray[n] = by;
                byte by3 = (byte)n4;
                byArray[489 + n] = by3;
                byArray[367 + n] = by3;
                byArray[245 + n] = by3;
                byArray[123 + n] = by3;
                byArray[1 + n] = by3;
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                byte by = (byte)n3;
                byArray[1220 + n] = by;
                byArray[1098 + n] = by;
                byArray[976 + n] = by;
                byArray[854 + n] = by;
                byArray[732 + n] = by;
                byte by4 = (byte)n4;
                byArray[1221 + n] = by4;
                byArray[1099 + n] = by4;
                byArray[977 + n] = by4;
                byArray[855 + n] = by4;
                byArray[733 + n] = by4;
                break;
            }
            case 4: 
            case 11: {
                byte by = (byte)n3;
                byArray[1220 + n] = by;
                byArray[1098 + n] = by;
                byArray[976 + n] = by;
                byArray[854 + n] = by;
                byArray[732 + n] = by;
                byte by5 = (byte)n4;
                byArray[1221 + n] = by5;
                byArray[1099 + n] = by5;
                byArray[977 + n] = by5;
                byArray[855 + n] = by5;
                byArray[733 + n] = by5;
                byArray[611 + n] = by5;
                byArray[489 + n] = by5;
                byArray[367 + n] = by5;
                byArray[245 + n] = by5;
                byArray[123 + n] = by5;
                byArray[1 + n] = by5;
            }
        }
    }

    public static void smnPaintKey2(int n, int n2, int n3, int n4) {
        int n5 = n3 & 0xCC | n4 & 0x33;
        int n6 = n4 & 0xCC | n3 & 0x33;
        int n7 = n5 & 0xFC;
        int n8 = n6 & 0xFC;
        byte[] byArray = smnBitmap;
        switch (n2) {
            case 0: 
            case 5: {
                byte by = (byte)n5;
                byArray[1220 + n] = by;
                byArray[976 + n] = by;
                byArray[732 + n] = by;
                byte by2 = (byte)n6;
                byArray[1098 + n] = by2;
                byArray[854 + n] = by2;
                byte by3 = (byte)n7;
                byArray[1221 + n] = by3;
                byArray[977 + n] = by3;
                byArray[733 + n] = by3;
                byArray[488 + n] = by3;
                byArray[244 + n] = by3;
                byArray[n] = by3;
                byte by4 = (byte)n8;
                byArray[1099 + n] = by4;
                byArray[855 + n] = by4;
                byArray[610 + n] = by4;
                byArray[366 + n] = by4;
                byArray[122 + n] = by4;
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                byte by = (byte)n5;
                byArray[488 + n] = by;
                byArray[244 + n] = by;
                byArray[n] = by;
                byte by5 = (byte)n6;
                byArray[366 + n] = by5;
                byArray[122 + n] = by5;
                byte by6 = (byte)n7;
                byArray[489 + n] = by6;
                byArray[245 + n] = by6;
                byArray[1 + n] = by6;
                byte by7 = (byte)n8;
                byArray[367 + n] = by7;
                byArray[123 + n] = by7;
                break;
            }
            case 2: 
            case 7: 
            case 9: {
                byte by = (byte)n5;
                byArray[1220 + n] = by;
                byArray[976 + n] = by;
                byArray[732 + n] = by;
                byte by8 = (byte)n6;
                byArray[1098 + n] = by8;
                byArray[854 + n] = by8;
                byte by9 = (byte)n7;
                byArray[1221 + n] = by9;
                byArray[977 + n] = by9;
                byArray[733 + n] = by9;
                byte by10 = (byte)n8;
                byArray[1099 + n] = by10;
                byArray[855 + n] = by10;
                break;
            }
            case 4: 
            case 11: {
                byte by = (byte)n5;
                byArray[1220 + n] = by;
                byArray[976 + n] = by;
                byArray[732 + n] = by;
                byte by11 = (byte)n6;
                byArray[1098 + n] = by11;
                byArray[854 + n] = by11;
                byte by12 = (byte)n7;
                byArray[1221 + n] = by12;
                byArray[977 + n] = by12;
                byArray[733 + n] = by12;
                byArray[489 + n] = by12;
                byArray[245 + n] = by12;
                byArray[1 + n] = by12;
                byte by13 = (byte)n8;
                byArray[1099 + n] = by13;
                byArray[855 + n] = by13;
                byArray[611 + n] = by13;
                byArray[367 + n] = by13;
                byArray[123 + n] = by13;
            }
        }
    }

    public static void smnDrawIcon1(int n, int n2, int n3) {
        byte[] byArray = smnBitmap;
        byArray[n += 122 * n2] = SMN_ICON_1[n3 *= 18];
        byArray[1 + n] = SMN_ICON_1[n3 + 1];
        byArray[122 + n] = SMN_ICON_1[n3 + 2];
        byArray[123 + n] = SMN_ICON_1[n3 + 3];
        byArray[244 + n] = SMN_ICON_1[n3 + 4];
        byArray[245 + n] = SMN_ICON_1[n3 + 5];
        byArray[366 + n] = SMN_ICON_1[n3 + 6];
        byArray[367 + n] = SMN_ICON_1[n3 + 7];
        byArray[488 + n] = SMN_ICON_1[n3 + 8];
        byArray[489 + n] = SMN_ICON_1[n3 + 9];
        byArray[610 + n] = SMN_ICON_1[n3 + 10];
        byArray[611 + n] = SMN_ICON_1[n3 + 11];
        byArray[732 + n] = SMN_ICON_1[n3 + 12];
        byArray[733 + n] = SMN_ICON_1[n3 + 13];
        byArray[854 + n] = SMN_ICON_1[n3 + 14];
        byArray[855 + n] = SMN_ICON_1[n3 + 15];
        byArray[976 + n] = SMN_ICON_1[n3 + 16];
        byArray[977 + n] = SMN_ICON_1[n3 + 17];
    }

    public static void smnDrawIcon3(int n, int n2, int n3) {
        byte[] byArray = smnBitmap;
        byArray[n += 122 * n2] = SMN_ICON_3[n3 *= 18];
        byArray[1 + n] = SMN_ICON_3[n3 + 1];
        byArray[122 + n] = SMN_ICON_3[n3 + 2];
        byArray[123 + n] = SMN_ICON_3[n3 + 3];
        byArray[244 + n] = SMN_ICON_3[n3 + 4];
        byArray[245 + n] = SMN_ICON_3[n3 + 5];
        byArray[366 + n] = SMN_ICON_3[n3 + 6];
        byArray[367 + n] = SMN_ICON_3[n3 + 7];
        byArray[488 + n] = SMN_ICON_3[n3 + 8];
        byArray[489 + n] = SMN_ICON_3[n3 + 9];
        byArray[610 + n] = SMN_ICON_3[n3 + 10];
        byArray[611 + n] = SMN_ICON_3[n3 + 11];
        byArray[732 + n] = SMN_ICON_3[n3 + 12];
        byArray[733 + n] = SMN_ICON_3[n3 + 13];
        byArray[854 + n] = SMN_ICON_3[n3 + 14];
        byArray[855 + n] = SMN_ICON_3[n3 + 15];
        byArray[976 + n] = SMN_ICON_3[n3 + 16];
        byArray[977 + n] = SMN_ICON_3[n3 + 17];
    }

    public static void smnDrawChar1(int n, int n2, int n3) {
        byte[] byArray = smnBitmap;
        byArray[n += 122 * n2] = SMN_FONT_1[n3 *= 5];
        byArray[n + 122] = SMN_FONT_1[n3 + 1];
        byArray[n + 244] = SMN_FONT_1[n3 + 2];
        byArray[n + 366] = SMN_FONT_1[n3 + 3];
        byArray[n + 488] = SMN_FONT_1[n3 + 4];
    }

    public static void smnDrawChar2(int n, int n2, int n3) {
        byte[] byArray = smnBitmap;
        byArray[n += 122 * n2] = SMN_FONT_2[n3 *= 5];
        byArray[n + 122] = SMN_FONT_2[n3 + 1];
        byArray[n + 244] = SMN_FONT_2[n3 + 2];
        byArray[n + 366] = SMN_FONT_2[n3 + 3];
        byArray[n + 488] = SMN_FONT_2[n3 + 4];
    }

    public static void smnDrawChar3(int n, int n2, int n3) {
        byte[] byArray = smnBitmap;
        byArray[n += 122 * n2] = SMN_FONT_3[n3 *= 5];
        byArray[n + 122] = SMN_FONT_3[n3 + 1];
        byArray[n + 244] = SMN_FONT_3[n3 + 2];
        byArray[n + 366] = SMN_FONT_3[n3 + 3];
        byArray[n + 488] = SMN_FONT_3[n3 + 4];
    }

    public static void smnDrawString1(int n, int n2, String string) {
        SoundMonitor.smnDrawString1(n, n2, string.toCharArray());
    }

    public static void smnDrawString1(int n, int n2, char[] cArray) {
        byte[] byArray = smnBitmap;
        n += 122 * n2;
        for (char c : cArray) {
            c = (char)(c * 5);
            byArray[n] = SMN_FONT_1[c];
            byArray[n + 122] = SMN_FONT_1[c + '\u0001'];
            byArray[n + 244] = SMN_FONT_1[c + 2];
            byArray[n + 366] = SMN_FONT_1[c + 3];
            byArray[n + 488] = SMN_FONT_1[c + 4];
            ++n;
        }
    }

    public static void smnDrawString2(int n, int n2, String string) {
        SoundMonitor.smnDrawString2(n, n2, string.toCharArray());
    }

    public static void smnDrawString2(int n, int n2, char[] cArray) {
        byte[] byArray = smnBitmap;
        n += 122 * n2;
        for (char c : cArray) {
            c = (char)(c * 5);
            byArray[n] = SMN_FONT_2[c];
            byArray[n + 122] = SMN_FONT_2[c + '\u0001'];
            byArray[n + 244] = SMN_FONT_2[c + 2];
            byArray[n + 366] = SMN_FONT_2[c + 3];
            byArray[n + 488] = SMN_FONT_2[c + 4];
            ++n;
        }
    }

    public static void smnDrawString3(int n, int n2, String string) {
        SoundMonitor.smnDrawString3(n, n2, string.toCharArray());
    }

    public static void smnDrawString3(int n, int n2, char[] cArray) {
        byte[] byArray = smnBitmap;
        n += 122 * n2;
        for (char c : cArray) {
            c = (char)(c * 5);
            byArray[n] = SMN_FONT_3[c];
            byArray[n + 122] = SMN_FONT_3[c + '\u0001'];
            byArray[n + 244] = SMN_FONT_3[c + 2];
            byArray[n + 366] = SMN_FONT_3[c + 3];
            byArray[n + 488] = SMN_FONT_3[c + 4];
            ++n;
        }
    }

    public static void smnDrawSlider(int[] nArray, int[] nArray2) {
        int n;
        byte[] byArray = smnBitmap;
        int n2 = nArray[0];
        int n3 = nArray[1];
        int n4 = nArray[2];
        int n5 = nArray[3];
        int n6 = nArray[4];
        int n7 = n4 + 4;
        int n8 = n + (n7 >> 2);
        for (n = (n2 >> 2) + 122 * n3; n < n8; ++n) {
            byArray[n + 488] = 0;
            byArray[n + 366] = 0;
            byArray[n + 122] = 0;
            byArray[n] = 0;
            byArray[n + 244] = (byte)n5;
        }
        SoundMonitor.smnDrawPattern(n2 + n6, n3 + 2, nArray2);
    }

    public static void smnDrawPattern(int n, int n2, int[] nArray) {
        byte[] byArray = smnBitmap;
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = n3 + nArray[n3];
            int n5 = nArray[n3 + 1] & 3;
            n3 += 2;
            while (n3 < n4) {
                int n6 = n + nArray[n3];
                int n7 = n2 + nArray[n3 + 1];
                int n8 = (~n6 & 3) << 1;
                int n9 = 122 * n7 + (n6 >> 2);
                byArray[n9] = (byte)(byArray[n9] & ~(3 << n8) | n5 << n8);
                n3 += 2;
            }
        }
    }

    static {
        smnWaveLastYPCMLeft = new int[2];
        smnWaveLastYPCMRight = new int[2];
        smnWaveLastYOPMLeft = new int[2];
        smnWaveLastYOPMRight = new int[2];
        SMN_SPECTRUM_MAP = "\u0000\u0001\u0002\u0003\u0005\u0007\t\u000b\r\u000f\u0011\u0013\u0015\u0017\u0019\u001b\u001d\u001f!#$%&'()*+-/13579;=?ACEGIKMOQSUWY[\\]^_".getBytes(XEiJ.ISO_8859_1);
        SMN_SPECTRUM_INTERVAL = new int[]{100, 100, 50, 25, 10, 5};
        smnSpectrumBuffer = new double[6][];
        smnSpectrumX = new double[1024];
        smnSpectrumY = new double[1024];
        smnSpectrumIndex = new int[480];
        smnSpectrumValue = new int[480];
        smnSpectrumWindow = new double[1024];
        SMN_440HZ_PATTERN = new int[]{18, 85, 0, 0, -1, 1, 1, 1, -2, 2, 2, 2, -1, 3, 1, 3, 0, 4};
        SMN_KEY_COLOR = new byte[]{-1, 85, -1, 85, -1, -1, 85, -1, 85, -1, 85, -1};
        smnKey = new int[8];
        SMN_TONE_H1 = "FC SL WA SY SP PD AD PS AS PN".toCharArray();
        SMN_TONE_V0 = "00 00 00 00 00 00 00 00 00 00 00".toCharArray();
        SMN_TONE_H2 = "AR 1R 2R RR 1L TL KS ML T1 T2 AE".toCharArray();
        SMN_TONE_M1 = "M1".toCharArray();
        SMN_TONE_V1 = "00 00 00 00 00 00 00 00 00 00 00".toCharArray();
        SMN_TONE_C1 = "C1".toCharArray();
        SMN_TONE_V2 = "00 00 00 00 00 00 00 00 00 00 00".toCharArray();
        SMN_TONE_M2 = "M2".toCharArray();
        SMN_TONE_V3 = "00 00 00 00 00 00 00 00 00 00 00".toCharArray();
        SMN_TONE_C2 = "C2".toCharArray();
        SMN_TONE_V4 = "00 00 00 00 00 00 00 00 00 00 00".toCharArray();
        SMN_PCM_OSCILLATOR = new char[][]{" 8".toCharArray(), " 4".toCharArray(), " 8".toCharArray(), "16".toCharArray()};
        SMN_PCM_DIVIDER = new char[][]{"1024".toCharArray(), "768 ".toCharArray(), "512 ".toCharArray(), "768 ".toCharArray()};
        SMN_PCM_FREQ = new char[][]{" 7.8".toCharArray(), "10.4".toCharArray(), "15.6".toCharArray(), "10.4".toCharArray(), " 3.9".toCharArray(), " 5.2".toCharArray(), " 7.8".toCharArray(), " 5.2".toCharArray(), " 7.8".toCharArray(), "10.4".toCharArray(), "15.6".toCharArray(), "10.4".toCharArray(), "15.6".toCharArray(), "20.8".toCharArray(), "31.3".toCharArray(), "20.8".toCharArray()};
        SMN_PCM_PLAY = new char[][]{"    ".toCharArray(), "PLAY".toCharArray()};
        SMN_PCM_DATA = new char[][]{"    ".toCharArray(), "DATA".toCharArray()};
        SMN_PCM_LEFT = new char[][]{"    ".toCharArray(), "LEFT".toCharArray()};
        SMN_PCM_RIGHT = new char[][]{"     ".toCharArray(), "RIGHT".toCharArray()};
        SMN_SLIDER_ARRAY = new int[][]{{332, 290, 48, -1, 0}, {388, 290, 32, -1, 0}, {428, 290, 32, -1, 0}, {332, 296, 48, 85, 30}, {388, 296, 32, 85, 30}, {428, 296, 32, 85, 32}, {332, 302, 48, -86, 3}, {388, 302, 32, -86, 30}, {428, 302, 32, -86, 32}, {332, 308, 48, -1, 30}, {388, 308, 32, -1, 3}, {428, 308, 32, -1, 30}};
        SMN_SLIDER_PATTERN = new int[][]{{18, -1, 1, -2, 2, -2, 0, -1, 3, -1, 0, 1, 3, 1, 1, 2, 2, 2, 14, 0, 1, -1, 2, -1, 1, 0, 2, 0, 1, 1, 2, 1}, {26, 85, 1, -2, 2, -2, 0, -1, 1, -1, 2, -1, 3, -1, 0, 1, 1, 1, 2, 1, 3, 1, 1, 2, 2, 2}, {26, -86, 1, -2, 2, -2, 0, -1, 1, -1, 2, -1, 3, -1, 0, 1, 1, 1, 2, 1, 3, 1, 1, 2, 2, 2}, {26, -1, 1, -2, 2, -2, 0, -1, 1, -1, 2, -1, 3, -1, 0, 1, 1, 1, 2, 1, 3, 1, 1, 2, 2, 2}};
        SMN_PAUSE_ICON_3 = "\u0000\u0000\u0000\u0000?\u00ff\u00ff\u00fc0\u0000\u0000\f0\u0000\u0000\f0\u00ff\u00ff\f0\u00ff\u00ff\f0\u00ff\u00ff\f0\u00ff\u00ff\f0\u00ff\u00ff\f0\u00ff\u00ff\f0\u00ff\u00ff\f0\u00ff\u00ff\f0\u0000\u0000\f0\u0000\u0000\f?\u00ff\u00ff\u00fc\u0000\u0000\u0000\u0000".getBytes(XEiJ.ISO_8859_1);
        SMN_PLAY_ICON_3 = "\u0000\u0000\u0000\u0000?\u00ff\u00ff\u00fc0\u0000\u0000\f0\u0000\u0000\f0\u00f0\u0000\f0\u00ff\u0000\f0\u00ff\u00f0\f0\u00ff\u00ff\f0\u00ff\u00ff\f0\u00ff\u00f0\f0\u00ff\u0000\f0\u00f0\u0000\f0\u0000\u0000\f0\u0000\u0000\f?\u00ff\u00ff\u00fc\u0000\u0000\u0000\u0000".getBytes(XEiJ.ISO_8859_1);
        SMN_ZOOM_X1_ICON = "\u0000\u0000\u0000\u0000?\u00ff\u00ff\u00fc0\u0000\u0000\f0\u0000\u0000\f0\u0000\u000f\f0\u0000\u000f\f0\u0000\u000f\f3\u00cf\u000f\f3\u00cf\u000f\f0\u00fc\u000f\f3\u00cf\u000f\f3\u00cf\u000f\f0\u0000\u0000\f0\u0000\u0000\f?\u00ff\u00ff\u00fc\u0000\u0000\u0000\u0000".getBytes(XEiJ.ISO_8859_1);
        SMN_ZOOM_X2_ICON = "\u0000\u0000\u0000\u0000?\u00ff\u00ff\u00fc0\u0000\u0000\f0\u0000\u0000\f0\u0000?\f0\u0000\u0003\u00cc0\u0000\u0003\u00cc3\u00cf\u000f\f3\u00cf\u000f\f0\u00fc<\f3\u00cf<\f3\u00cf?\u00cc0\u0000\u0000\f0\u0000\u0000\f?\u00ff\u00ff\u00fc\u0000\u0000\u0000\u0000".getBytes(XEiJ.ISO_8859_1);
    }
}

