/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import xeij.ComponentFactory;
import xeij.LnF;
import xeij.MemoryMappedDevice;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.ScrollTextArea;
import xeij.XEiJ;

public class PhysicalSpaceMonitor {
    public static JFrame paaFrame;
    public static ScrollTextArea paaBoard;
    public static JTextArea paaTextArea;

    public static void paaInit() {
        paaFrame = null;
    }

    public static void paaStart() {
        if (RestorableFrame.rfmGetOpened("paa")) {
            PhysicalSpaceMonitor.paaOpen();
        }
    }

    public static void paaOpen() {
        if (paaFrame == null) {
            PhysicalSpaceMonitor.paaMake();
        }
        PhysicalSpaceMonitor.paaUpdate();
        XEiJ.pnlExitFullScreen(false);
        paaFrame.setVisible(true);
        XEiJ.dbgVisibleMask |= 0x200;
    }

    public static void paaMake() {
        paaBoard = ComponentFactory.setPreferredSize(ComponentFactory.setFont(new ScrollTextArea(), LnF.lnfMonospacedFont), 550, 300);
        paaBoard.setMargin(new Insets(2, 4, 2, 4));
        paaBoard.setHighlightCursorOn(true);
        paaTextArea = paaBoard.getTextArea();
        paaTextArea.setEditable(false);
        ComponentFactory.addListener(paaTextArea, new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, paaTextArea, false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, paaTextArea, false);
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                switch (actionEvent.getActionCommand()) {
                    case "Update": {
                        PhysicalSpaceMonitor.paaUpdate();
                    }
                }
            }
        };
        paaFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("paa", "Physical space monitor", null, ComponentFactory.createBorderPanel(paaBoard, ComponentFactory.createHorizontalBox(Multilingual.mlnToolTipText(ComponentFactory.createImageButton(XEiJ.createImage(20, 14, "111111111111111111111..................11.......1111.......11......111111.1....11.....11....111....11....11.....111....11....11....1111....11....11............11....11............11.....11....11.....11......111111......11.......1111.......11..................111111111111111111111", LnF.lnfRGB[0], LnF.lnfRGB[12]), "Update", actionListener), "ja", "\u66f4\u65b0"), Box.createHorizontalGlue()))), "ja", "\u7269\u7406\u7a7a\u9593\u30e2\u30cb\u30bf");
        ComponentFactory.addListener(paaFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFFDFF;
            }
        });
    }

    public static void paaUpdate() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Multilingual.mlnJapanese ? "  \u7269\u7406\u30a2\u30c9\u30ec\u30b9       \u30e1\u30e2\u30ea\u30de\u30c3\u30d7\u30c8\u30c7\u30d0\u30a4\u30b9\n" : "Physical address      Memory mapped device\n");
        int n = 0;
        MemoryMappedDevice memoryMappedDevice = MemoryMappedDevice.MMD_NUL;
        MemoryMappedDevice memoryMappedDevice2 = MemoryMappedDevice.MMD_NUL;
        for (int i = 0; i < 0x100000; ++i) {
            MemoryMappedDevice memoryMappedDevice3 = XEiJ.busSuperMap[i];
            MemoryMappedDevice memoryMappedDevice4 = XEiJ.busUserMap[i];
            if (memoryMappedDevice == memoryMappedDevice3 && memoryMappedDevice2 == memoryMappedDevice4) continue;
            int n2 = i << 12;
            if (memoryMappedDevice != MemoryMappedDevice.MMD_NUL) {
                XEiJ.fmtHex8(XEiJ.fmtHex8(stringBuilder, n).append('-'), n2 - 1).append("  ").append(memoryMappedDevice.toString());
                if (memoryMappedDevice2 == MemoryMappedDevice.MMD_NUL) {
                    stringBuilder.append(Multilingual.mlnJapanese ? " [\u30b9\u30fc\u30d1\u30fc\u30d0\u30a4\u30b6]" : " [Supervisor]");
                }
                stringBuilder.append('\n');
            }
            n = n2;
            memoryMappedDevice = memoryMappedDevice3;
            memoryMappedDevice2 = memoryMappedDevice4;
        }
        if (memoryMappedDevice != MemoryMappedDevice.MMD_NUL) {
            XEiJ.fmtHex8(XEiJ.fmtHex8(stringBuilder, n).append('-'), -1).append("  ").append(memoryMappedDevice.toString());
            if (memoryMappedDevice2 == MemoryMappedDevice.MMD_NUL) {
                stringBuilder.append(Multilingual.mlnJapanese ? " [\u30b9\u30fc\u30d1\u30fc\u30d0\u30a4\u30b6]" : " [Supervisor]");
            }
            stringBuilder.append('\n');
        }
        paaTextArea.setText(stringBuilder.toString());
        paaTextArea.setCaretPosition(0);
    }
}

