/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import xeij.ComponentFactory;
import xeij.LnF;
import xeij.MC68060;
import xeij.Multilingual;
import xeij.RestorableFrame;
import xeij.ScrollTextArea;
import xeij.XEiJ;

public class LogicalSpaceMonitor {
    public static JFrame atwFrame;
    public static final ScrollTextArea[] atwBoard;
    public static final JTextArea[] atwTextArea;

    public static void atwInit() {
        atwFrame = null;
    }

    public static void atwStart() {
        if (RestorableFrame.rfmGetOpened("atw")) {
            LogicalSpaceMonitor.atwOpen();
        }
    }

    public static void atwOpen() {
        if (atwFrame == null) {
            LogicalSpaceMonitor.atwMake();
        }
        LogicalSpaceMonitor.atwUpdate();
        XEiJ.pnlExitFullScreen(false);
        atwFrame.setVisible(true);
        XEiJ.dbgVisibleMask |= 0x100;
    }

    public static void atwMake() {
        for (int i = 0; i < 2; ++i) {
            LogicalSpaceMonitor.atwBoard[i] = ComponentFactory.setPreferredSize(ComponentFactory.setFont(new ScrollTextArea(), LnF.lnfMonospacedFont), 550, 250);
            atwBoard[i].setMargin(new Insets(2, 4, 2, 4));
            atwBoard[i].setHighlightCursorOn(true);
            LogicalSpaceMonitor.atwTextArea[i] = atwBoard[i].getTextArea();
            atwTextArea[i].setEditable(false);
        }
        ComponentFactory.addListener(atwTextArea[0], new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, atwTextArea[0], false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, atwTextArea[0], false);
                }
            }
        });
        ComponentFactory.addListener(atwTextArea[1], new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, atwTextArea[1], false);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (XEiJ.mpuTask == null && mouseEvent.isPopupTrigger()) {
                    XEiJ.dbgShowPopup(mouseEvent, atwTextArea[1], false);
                }
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                switch (actionEvent.getActionCommand()) {
                    case "Update": {
                        LogicalSpaceMonitor.atwUpdate();
                    }
                }
            }
        };
        atwFrame = Multilingual.mlnTitle(ComponentFactory.createRestorableSubFrame("atw", "Logical space monitor", null, ComponentFactory.createBorderPanel(ComponentFactory.createVerticalSplitPane(ComponentFactory.createVerticalBox(ComponentFactory.createHorizontalBox(Multilingual.mlnText(ComponentFactory.createLabel("User mode"), "ja", "\u30e6\u30fc\u30b6\u30e2\u30fc\u30c9"), Box.createHorizontalGlue()), atwBoard[0]), ComponentFactory.createVerticalBox(ComponentFactory.createHorizontalBox(Multilingual.mlnText(ComponentFactory.createLabel("Supervisor mode"), "ja", "\u30b9\u30fc\u30d1\u30fc\u30d0\u30a4\u30b6\u30e2\u30fc\u30c9"), Box.createHorizontalGlue()), atwBoard[1])), ComponentFactory.createHorizontalBox(Multilingual.mlnToolTipText(ComponentFactory.createImageButton(XEiJ.createImage(20, 14, "111111111111111111111..................11.......1111.......11......111111.1....11.....11....111....11....11.....111....11....11....1111....11....11............11....11............11.....11....11.....11......111111......11.......1111.......11..................111111111111111111111", LnF.lnfRGB[0], LnF.lnfRGB[12]), "Update", actionListener), "ja", "\u66f4\u65b0"), Box.createHorizontalGlue()))), "ja", "\u8ad6\u7406\u7a7a\u9593\u30e2\u30cb\u30bf");
        ComponentFactory.addListener(atwFrame, new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                XEiJ.dbgVisibleMask &= 0xFFFFFEFF;
            }
        });
    }

    public static void atwUpdate() {
        for (int i = 0; i < 2; ++i) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Multilingual.mlnJapanese ? "  \u8ad6\u7406\u30a2\u30c9\u30ec\u30b9       \u7269\u7406\u30a2\u30c9\u30ec\u30b9\n" : " Logical address   Physical address\n");
            int n2 = 0;
            int n3 = MC68060.mmuTranslatePeek(n2, i, 0);
            int n4 = MC68060.mmuPeekFlags;
            if ((n3 ^ n2) == 1) {
                n3 = 1;
            }
            for (n = MC68060.mmuPageSize; n != 0; n += MC68060.mmuPageSize) {
                int n5 = MC68060.mmuTranslatePeek(n, i, 0);
                int n6 = MC68060.mmuPeekFlags;
                if ((n5 ^ n) == 1) {
                    n5 = 1;
                }
                if (n3 == 1 && n5 == 1 || n3 != 1 && n5 != 1 && n5 - n3 == n - n2 && n4 == n6) continue;
                if (n3 != 1) {
                    XEiJ.fmtHex8(XEiJ.fmtHex8(XEiJ.fmtHex8(XEiJ.fmtHex8(stringBuilder, n2).append('-'), n - 1).append("  "), n3).append('-'), n3 + (n - n2) - 1).append(' ');
                    if ((n4 & 0x80) != 0) {
                        stringBuilder.append(Multilingual.mlnJapanese ? " [\u30b9\u30fc\u30d1\u30fc\u30d0\u30a4\u30b6]" : " [Supervisor]");
                    }
                    if ((n4 & 0x10) != 0) {
                        stringBuilder.append(Multilingual.mlnJapanese ? " [\u4fee\u6b63\u6e08\u307f]" : " [Modified]");
                    }
                    if ((n4 & 8) != 0) {
                        stringBuilder.append(Multilingual.mlnJapanese ? " [\u4f7f\u7528\u6e08\u307f]" : " [Used]");
                    }
                    if ((n4 & 4) != 0) {
                        stringBuilder.append(Multilingual.mlnJapanese ? " [\u66f8\u304d\u8fbc\u307f\u7981\u6b62]" : " [Write-protected]");
                    }
                    stringBuilder.append('\n');
                }
                n2 = n;
                n3 = n5;
                n4 = n6;
            }
            if (n3 != 1) {
                XEiJ.fmtHex8(XEiJ.fmtHex8(XEiJ.fmtHex8(XEiJ.fmtHex8(stringBuilder, n2).append('-'), n - 1).append("  "), n3).append('-'), n3 + (n - n2) - 1).append(' ');
                if ((n4 & 0x80) != 0) {
                    stringBuilder.append(Multilingual.mlnJapanese ? " [\u30b9\u30fc\u30d1\u30fc\u30d0\u30a4\u30b6]" : " [Supervisor]");
                }
                if ((n4 & 0x10) != 0) {
                    stringBuilder.append(Multilingual.mlnJapanese ? " [\u4fee\u6b63\u6e08\u307f]" : " [Modified]");
                }
                if ((n4 & 8) != 0) {
                    stringBuilder.append(Multilingual.mlnJapanese ? " [\u4f7f\u7528\u6e08\u307f]" : " [Used]");
                }
                if ((n4 & 4) != 0) {
                    stringBuilder.append(Multilingual.mlnJapanese ? " [\u66f8\u304d\u8fbc\u307f\u7981\u6b62]" : " [Write-protected]");
                }
                stringBuilder.append('\n');
            }
            atwTextArea[i].setText(stringBuilder.toString());
            atwTextArea[i].setCaretPosition(0);
        }
    }

    static {
        atwBoard = new ScrollTextArea[2];
        atwTextArea = new JTextArea[2];
    }
}

