/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import xeij.PrinterPort;
import xeij.XEiJ;

public class IOInterrupt {
    public static final boolean IOI_DEBUG_TRACE = false;
    public static final int IOI_STATUS = 15319041;
    public static final int IOI_VECTOR = 15319043;
    public static final int IOI_SPC_SIGNAL = 16384;
    public static final int IOI_FDC_SIGNAL = 128;
    public static final int IOI_FDD_SIGNAL = 64;
    public static final int IOI_PRN_SIGNAL = 32;
    public static final int IOI_HDC_SIGNAL = 16;
    public static final int IOI_SPC_REQUEST = 16384;
    public static final int IOI_HDC_REQUEST = 8;
    public static final int IOI_FDC_REQUEST = 4;
    public static final int IOI_FDD_REQUEST = 2;
    public static final int IOI_PRN_REQUEST = 1;
    public static final int IOI_SPC_VECTOR = 108;
    public static final int IOI_FDC_VECTOR = 0;
    public static final int IOI_FDD_VECTOR = 1;
    public static final int IOI_HDC_VECTOR = 2;
    public static final int IOI_PRN_VECTOR = 3;
    public static int ioiEnable;
    public static int ioiInService;
    public static int ioiRequest;
    public static int ioiSignal;
    public static int ioiVector;

    public static void ioiInit() {
    }

    public static void ioiReset() {
        ioiEnable = 16384;
        ioiInService = 0;
        ioiRequest = 0;
        ioiSignal = PrinterPort.prnOnlineOn ? 32 : 0;
        ioiVector = 0;
    }

    public static void ioiSpcFall() {
        if ((ioiSignal & 0x4000) != 0) {
            ioiSignal &= 0xFFFFBFFF;
        }
    }

    public static void ioiFdcFall() {
        if ((ioiSignal & 0x80) != 0) {
            ioiSignal &= 0xFFFFFF7F;
        }
    }

    public static void ioiFddFall() {
        if ((ioiSignal & 0x40) != 0) {
            ioiSignal &= 0xFFFFFFBF;
        }
    }

    public static void ioiHdcFall() {
        if ((ioiSignal & 0x10) != 0) {
            ioiSignal &= 0xFFFFFFEF;
        }
    }

    public static void ioiPrnFall() {
        if ((ioiSignal & 0x20) != 0) {
            ioiSignal &= 0xFFFFFFDF;
        }
    }

    public static void ioiSpcRise() {
        if ((ioiSignal & 0x4000) == 0) {
            ioiSignal |= 0x4000;
            if ((ioiEnable & 0x4000) != 0 && (ioiRequest & 0x4000) == 0) {
                ioiRequest |= 0x4000;
                XEiJ.mpuIRR |= 0x40;
            }
        }
    }

    public static void ioiFdcRise() {
        if ((ioiSignal & 0x80) == 0) {
            ioiSignal |= 0x80;
            if ((ioiEnable & 4) != 0 && (ioiRequest & 4) == 0) {
                ioiRequest |= 4;
                XEiJ.mpuIRR |= 0x40;
            }
        }
    }

    public static void ioiFddRise() {
        if ((ioiSignal & 0x40) == 0) {
            ioiSignal |= 0x40;
            if ((ioiEnable & 2) != 0 && (ioiRequest & 2) == 0) {
                ioiRequest |= 2;
                XEiJ.mpuIRR |= 0x40;
            }
        }
    }

    public static void ioiHdcRise() {
        if ((ioiSignal & 0x10) == 0) {
            ioiSignal |= 0x10;
            if ((ioiEnable & 8) != 0 && (ioiRequest & 8) == 0) {
                ioiRequest |= 8;
                XEiJ.mpuIRR |= 0x40;
            }
        }
    }

    public static void ioiPrnRise() {
        if ((ioiSignal & 0x20) == 0) {
            ioiSignal |= 0x20;
            if ((ioiEnable & 1) != 0 && (ioiRequest & 1) == 0) {
                ioiRequest |= 1;
                XEiJ.mpuIRR |= 0x40;
            }
        }
    }

    public static int ioiAcknowledge() {
        int n = 0;
        if ((ioiRequest & 0x4000) != 0) {
            ioiInService = 16384;
            n = 108;
        } else if ((ioiRequest & 4) != 0) {
            ioiInService = 4;
            n = ioiVector | 0;
        } else if ((ioiRequest & 2) != 0) {
            ioiInService = 2;
            n = ioiVector | 1;
        } else if ((ioiRequest & 8) != 0) {
            ioiInService = 8;
            n = ioiVector | 2;
        } else if ((ioiRequest & 1) != 0) {
            ioiInService = 1;
            n = ioiVector | 3;
        }
        ioiRequest &= ~ioiInService;
        return n;
    }

    public static void ioiDone() {
        ioiInService = 0;
        if (ioiRequest != 0) {
            XEiJ.mpuIRR |= 0x40;
        }
    }

    public static int ioiReadStatus() {
        int n = (ioiSignal | ioiEnable) & 0xFF;
        return n;
    }

    public static int ioiReadVector() {
        int n = ioiVector;
        return n;
    }

    public static void ioiWriteEnable(int n) {
        int n2 = ioiEnable & 0xFFFFFFF0 | n & 0xF;
        int n3 = ioiEnable & ~n2;
        int n4 = ~ioiEnable & n2;
        ioiEnable = n2;
        int n5 = ioiRequest;
        if ((n3 & 4) != 0) {
            n5 &= 0xFFFFFFFB;
        } else if ((n4 & 4) != 0 && (ioiSignal & 0x80) != 0) {
            n5 |= 4;
        }
        if ((n3 & 2) != 0) {
            n5 &= 0xFFFFFFFD;
        } else if ((n4 & 2) != 0 && (ioiSignal & 0x40) != 0) {
            n5 |= 2;
        }
        if ((n3 & 8) != 0) {
            n5 &= 0xFFFFFFF7;
        } else if ((n4 & 8) != 0 && (ioiSignal & 0x10) != 0) {
            n5 |= 8;
        }
        if ((n3 & 1) != 0) {
            n5 &= 0xFFFFFFFE;
        } else if ((n4 & 1) != 0 && (ioiSignal & 0x20) != 0) {
            n5 |= 1;
        }
        if (ioiRequest != n5) {
            ioiRequest = n5;
            XEiJ.mpuIRR |= 0x40;
        }
    }

    public static void ioiWriteVector(int n) {
        ioiVector = n & 0xFC;
    }
}

