/*
 * Decompiled with CFR 0.152.
 */
package xeij;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xeij.ComponentFactory;
import xeij.Joystick;
import xeij.LnF;
import xeij.Multilingual;
import xeij.PPI;
import xeij.Settings;
import xeij.XEiJ;
import xeij.XInput;

public class CyberStickDigital
extends Joystick
implements ActionListener,
ChangeListener,
FocusListener,
XInput.GamepadListener,
KeyListener {
    protected static final int SUP_BIT = 0;
    protected static final int SDOWN_BIT = 1;
    protected static final int SLEFT_BIT = 2;
    protected static final int SRIGHT_BIT = 3;
    protected static final int TUP_BIT = 4;
    protected static final int TDOWN_BIT = 5;
    protected static final int A_BIT = 6;
    protected static final int APRIME_BIT = 7;
    protected static final int B_BIT = 8;
    protected static final int BPRIME_BIT = 9;
    protected static final int C_BIT = 10;
    protected static final int D_BIT = 11;
    protected static final int E1_BIT = 12;
    protected static final int E2_BIT = 13;
    protected static final int SELECT_BIT = 14;
    protected static final int START_BIT = 15;
    protected static final int BUTTONS = 16;
    protected static final int SUP_MASK = 1;
    protected static final int SDOWN_MASK = 2;
    protected static final int SLEFT_MASK = 4;
    protected static final int SRIGHT_MASK = 8;
    protected static final int TUP_MASK = 16;
    protected static final int TDOWN_MASK = 32;
    protected static final int A_MASK = 64;
    protected static final int APRIME_MASK = 128;
    protected static final int B_MASK = 256;
    protected static final int BPRIME_MASK = 512;
    protected static final int C_MASK = 1024;
    protected static final int D_MASK = 2048;
    protected static final int E1_MASK = 4096;
    protected static final int E2_MASK = 8192;
    protected static final int SELECT_MASK = 16384;
    protected static final int START_MASK = 32768;
    protected static final String[] BIT_TO_TEXT = new String[]{"STICK \u2191", "STICK \u2193", "STICK \u2190", "STICK \u2192", "THROTTLE \u2191", "THROTTLE \u2193", "A", "A'", "B", "B'", "C", "D", "E1", "E2", "SELECT", "START"};
    protected static final boolean[] BIT_TO_REPEATABLE = new boolean[]{false, false, false, false, false, false, true, true, true, true, true, true, true, true, false, false};
    protected static final int MAP_CODE = 0;
    protected static final int MAP_REPEAT = 16;
    protected static final int MAP_DELAY = 32;
    protected static final int MAP_INTERVAL = 48;
    protected static final int MAP_LENGTH = 64;
    protected int[] map;
    protected int xinputFocusedButton;
    protected long[] startTimeOf;
    protected int lastButtons;
    protected int keyButtons;
    protected int page;
    protected JTextField[] xinputTextFieldOf = new JTextField[16];
    protected JTextField[] keyTextFieldOf = new JTextField[16];
    protected JCheckBox[] repeatCheckBoxOf = new JCheckBox[16];
    protected SpinnerNumberModel[] delayModelOf = new SpinnerNumberModel[16];
    protected JSpinner[] delaySpinnerOf = new JSpinner[16];
    protected SpinnerNumberModel[] intervalModelOf = new SpinnerNumberModel[16];
    protected JSpinner[] intervalSpinnerOf = new JSpinner[16];
    protected final int[][] defaultMaps = new int[][]{{9699366, 9764904, 9830437, 9895975, 9437217, 9502754, 8847450, 9175126, 9306200, 9240642, 9371715, 8781889, 8912979, 8978500, 8716357, 8650834, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 50, 50, 50, 50, 50, 50, 50, 0, 0, 0, 0, 0, 0, 0, 0, 100, 100, 100, 100, 100, 100, 100, 100, 0, 0}, {0xB40000, 0xB50000, 0xB60000, 0xB70000, 0xB00000, 0xB10000, 0xA70000, 0xAC0000, 0xAE0000, 0xAD0000, 0xAF0000, 0xA60000, 0xA80000, 0xA90000, 0xA50000, 0xA40000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 50, 50, 50, 50, 50, 50, 50, 0, 0, 0, 0, 0, 0, 0, 0, 100, 100, 100, 100, 100, 100, 100, 100, 0, 0}};

    public CyberStickDigital(int n) {
        this.number = n;
        this.id = "cyberstickdigital" + n;
        this.nameEn = "CYBER STICK (digital) #" + n;
        this.nameJa = "\u30b5\u30a4\u30d0\u30fc\u30b9\u30c6\u30a3\u30c3\u30af (\u30c7\u30b8\u30bf\u30eb) #" + n;
        this.map = new int[64];
        int[] nArray = Settings.sgsGetIntArray(this.id);
        if (0 < nArray.length && nArray[0] == -2) {
            for (int i = 0; i < 64; ++i) {
                this.map[i] = i + 1 < nArray.length ? nArray[i + 1] : 0;
            }
        } else {
            System.arraycopy(this.defaultMaps[n - 1], 0, this.map, 0, 64);
        }
        this.xinputFocusedButton = -1;
        this.startTimeOf = new long[16];
        this.reset();
        this.configurationPanel = null;
    }

    @Override
    public void tini() {
        if (Arrays.equals(this.map, this.defaultMaps[this.number - 1])) {
            Settings.sgsPutIntArray(this.id, new int[0]);
        } else {
            int[] nArray = new int[65];
            nArray[0] = -2;
            for (int i = 0; i < 64; ++i) {
                nArray[1 + i] = this.map[i];
            }
            Settings.sgsPutIntArray(this.id, nArray);
        }
    }

    @Override
    public final void reset() {
        this.lastButtons = 0;
        this.keyButtons = 0;
        this.page = 0;
    }

    private void updateText() {
        for (int i = 0; i < 16; ++i) {
            int n;
            Object object;
            int n2 = this.map[0 + i] >>> 16;
            if (n2 == 0) {
                object = Multilingual.mlnJapanese ? "\u306a\u3057" : "none";
            } else {
                n = n2 >> 5 & 3;
                int n3 = n2 & 0x1F;
                object = "#" + n + " " + XInput.BIT_TO_TEXT[n3];
            }
            this.xinputTextFieldOf[i].setText((String)object);
            n = this.map[0 + i] & 0xFFFF;
            object = n == 0 ? (Multilingual.mlnJapanese ? "\u306a\u3057" : "none") : KeyEvent.getKeyText(n);
            this.keyTextFieldOf[i].setText((String)object);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("Reset to default values")) {
            if (Arrays.equals(this.map, this.defaultMaps[this.number - 1])) {
                JOptionPane.showMessageDialog(null, Multilingual.mlnJapanese ? this.nameJa + " \u306e\u8a2d\u5b9a\u306f\u521d\u671f\u5024\u3068\u540c\u3058\u3067\u3059" : this.nameEn + " settings are equals to default values", Multilingual.mlnJapanese ? "\u78ba\u8a8d" : "Confirmation", -1);
                return;
            }
            if (JOptionPane.showConfirmDialog(null, Multilingual.mlnJapanese ? this.nameJa + " \u306e\u8a2d\u5b9a\u3092\u521d\u671f\u5024\u306b\u623b\u3057\u307e\u3059\u304b\uff1f" : "Do you want to reset " + this.nameEn + " settings to default values?", Multilingual.mlnJapanese ? "\u78ba\u8a8d" : "Confirmation", 0, -1) != 0) {
                return;
            }
            System.arraycopy(this.defaultMaps[this.number - 1], 0, this.map, 0, 64);
            this.updateText();
            for (int i = 0; i < 16; ++i) {
                if (!BIT_TO_REPEATABLE[i]) continue;
                this.repeatCheckBoxOf[i].setSelected(this.map[16 + i] != 0);
                this.delayModelOf[i].setValue(Math.max(10, Math.min(1000, this.map[32 + i])));
                this.intervalModelOf[i].setValue(Math.max(10, Math.min(2000, this.map[48 + i])));
            }
        } else if (string.startsWith("Repeat ")) {
            int n = Integer.parseInt(string.substring(7));
            int n2 = this.repeatCheckBoxOf[n].isSelected() ? 1 : 0;
            this.map[16 + n] = n2;
        } else {
            System.out.println("unknown action command " + string);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JSpinner jSpinner = (JSpinner)changeEvent.getSource();
        String string = jSpinner.getName();
        if (string.startsWith("Delay ")) {
            int n = Integer.parseInt(string.substring(6));
            this.map[32 + n] = this.delayModelOf[n].getNumber().intValue();
        } else if (string.startsWith("Interval ")) {
            int n = Integer.parseInt(string.substring(9));
            this.map[48 + n] = this.intervalModelOf[n].getNumber().intValue();
        } else {
            System.out.println("unknown spinner name " + string);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        String string = component.getName();
        char c = string.charAt(0);
        int n = Integer.parseInt(string.substring(1));
        component.setBackground(new Color(LnF.lnfRGB[6]));
        if (c == 'x') {
            this.xinputFocusedButton = n;
            if (PPI.ppiXInput != null) {
                PPI.ppiXInput.addGamepadListener(this);
            }
        } else if (c != 'k') {
            System.out.println("unknown component name " + string);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        String string = component.getName();
        char c = string.charAt(0);
        int n = Integer.parseInt(string.substring(1));
        component.setBackground(null);
        if (c == 'x') {
            if (PPI.ppiXInput != null) {
                PPI.ppiXInput.removeGamepadListeners();
            }
            this.xinputFocusedButton = -1;
        } else if (c != 'k') {
            System.out.println("unknown component name " + string);
        }
    }

    @Override
    public void connected(XInput.Gamepad gamepad) {
    }

    @Override
    public void disconnected(XInput.Gamepad gamepad) {
    }

    @Override
    public void buttonPressed(XInput.Gamepad gamepad, int n) {
        if (n == 0) {
            return;
        }
        if (0 <= this.xinputFocusedButton) {
            int n2 = gamepad.getIndex();
            int n3 = Integer.numberOfTrailingZeros(n);
            int n4 = 0x80 | n2 << 5 | n3;
            int n5 = this.map[0 + this.xinputFocusedButton] & 0xFFFF;
            this.map[0 + this.xinputFocusedButton] = n4 << 16 | n5;
            for (int i = 0; i < 16; ++i) {
                int n6 = this.map[0 + i] >>> 16;
                if (n6 == 0) continue;
                int n7 = this.map[0 + i] & 0xFFFF;
                this.map[0 + i] = (n6 & 0xFFFFFF9F | n2 << 5) << 16 | n7;
            }
            this.updateText();
        }
    }

    @Override
    public void buttonReleased(XInput.Gamepad gamepad, int n) {
    }

    @Override
    public void leftStickMovedX(XInput.Gamepad gamepad) {
    }

    @Override
    public void leftStickMovedY(XInput.Gamepad gamepad) {
    }

    @Override
    public void leftTriggerMoved(XInput.Gamepad gamepad) {
    }

    @Override
    public void rightStickMovedX(XInput.Gamepad gamepad) {
    }

    @Override
    public void rightStickMovedY(XInput.Gamepad gamepad) {
    }

    @Override
    public void rightTriggerMoved(XInput.Gamepad gamepad) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        Component component = keyEvent.getComponent();
        String string = component.getName();
        char c = string.charAt(0);
        int n = Integer.parseInt(string.substring(1));
        int n2 = this.map[0 + n] >>> 16;
        int n3 = this.map[0 + n] & 0xFFFF;
        if (c == 'x') {
            if (keyEvent.getKeyCode() == 27) {
                n2 = 0;
            }
        } else if (c == 'k') {
            n3 = keyEvent.getKeyCode() == 27 ? 0 : keyEvent.getKeyCode();
        } else {
            System.out.println("unknown component name " + string);
        }
        this.map[0 + n] = n2 << 16 | n3;
        this.updateText();
        keyEvent.consume();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        keyEvent.consume();
    }

    @Override
    public JComponent getConfigurationPanel() {
        if (this.configurationPanel != null) {
            return this.configurationPanel;
        }
        for (int i = 0; i < 16; ++i) {
            this.xinputTextFieldOf[i] = ComponentFactory.setEnabled(ComponentFactory.addListener(ComponentFactory.addListener(ComponentFactory.setHorizontalAlignment(ComponentFactory.setName(ComponentFactory.createTextField("", 8), "x" + i), 0), this), this), XEiJ.prgIsWindows);
            this.keyTextFieldOf[i] = ComponentFactory.addListener(ComponentFactory.addListener(ComponentFactory.setHorizontalAlignment(ComponentFactory.setName(ComponentFactory.createTextField("", 8), "k" + i), 0), this), this);
            if (!BIT_TO_REPEATABLE[i]) continue;
            this.repeatCheckBoxOf[i] = ComponentFactory.setText(ComponentFactory.createCheckBox(this.map[16 + i] != 0, "Repeat " + i, this), "");
            this.delayModelOf[i] = new SpinnerNumberModel(Math.max(10, Math.min(1000, this.map[32 + i])), 10, 1000, 10);
            this.delaySpinnerOf[i] = ComponentFactory.setName(ComponentFactory.createNumberSpinner(this.delayModelOf[i], 4, this), "Delay " + i);
            this.intervalModelOf[i] = new SpinnerNumberModel(Math.max(10, Math.min(2000, this.map[48 + i])), 10, 2000, 10);
            this.intervalSpinnerOf[i] = ComponentFactory.setName(ComponentFactory.createNumberSpinner(this.intervalModelOf[i], 4, this), "Interval " + i);
        }
        this.updateText();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(null);
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Button"), "ja", "\u30dc\u30bf\u30f3"));
        arrayList.add(ComponentFactory.createLabel("XInput"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Keyboard"), "ja", "\u30ad\u30fc\u30dc\u30fc\u30c9"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Burst"), "ja", "\u9023\u5c04"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Delay (ms)"), "ja", "\u958b\u59cb (ms)"));
        arrayList.add(Multilingual.mlnText(ComponentFactory.createLabel("Interval (ms)"), "ja", "\u9593\u9694 (ms)"));
        arrayList.add(ComponentFactory.createHorizontalSeparator());
        for (int i = 0; i < 16; ++i) {
            arrayList.add(String.valueOf(1 + i));
            arrayList.add(BIT_TO_TEXT[i]);
            arrayList.add(this.xinputTextFieldOf[i]);
            arrayList.add(this.keyTextFieldOf[i]);
            arrayList.add(BIT_TO_REPEATABLE[i] ? this.repeatCheckBoxOf[i] : null);
            arrayList.add(BIT_TO_REPEATABLE[i] ? this.delaySpinnerOf[i] : null);
            arrayList.add(BIT_TO_REPEATABLE[i] ? this.intervalSpinnerOf[i] : null);
        }
        this.configurationPanel = ComponentFactory.createVerticalBox(Box.createVerticalStrut(5), ComponentFactory.createHorizontalBox(Box.createHorizontalGlue(), Multilingual.mlnText(ComponentFactory.createLabel(this.getNameEn()), "ja", this.getNameJa()), Box.createHorizontalGlue()), Box.createVerticalStrut(5), ComponentFactory.createHorizontalBox(ComponentFactory.createGridPanel(7, 18, "paddingLeft=3,paddingRight=3,center", "", "italic;colSpan=7,widen", "", arrayList.toArray(new Object[0]))), Box.createVerticalStrut(5), ComponentFactory.createHorizontalBox(Box.createHorizontalGlue(), Multilingual.mlnText(ComponentFactory.createButton("Reset to default values", this), "ja", "\u521d\u671f\u5024\u306b\u623b\u3059"), Box.createHorizontalGlue()), Box.createVerticalStrut(5));
        return this.configurationPanel;
    }

    @Override
    public boolean input(KeyEvent keyEvent, boolean bl) {
        int n = keyEvent.getKeyCode();
        for (int i = 0; i < 16; ++i) {
            if (n != (this.map[0 + i] & 0xFFFF)) continue;
            this.keyButtons = bl ? (this.keyButtons |= 1 << i) : (this.keyButtons &= ~(1 << i));
            return true;
        }
        return false;
    }

    @Override
    public void setPin8(int n) {
        this.page = n;
    }

    @Override
    public int readByte() {
        int n;
        int n2;
        int n3;
        int n4 = this.keyButtons;
        int n5 = -1;
        int n6 = 0;
        for (n3 = 0; n3 < 16; ++n3) {
            n2 = this.map[0 + n3] >>> 16;
            if (n2 == 0) continue;
            n = n2 >> 5 & 3;
            int n7 = n2 & 0x1F;
            if (n5 != n) {
                n5 = n;
                int n8 = n6 = PPI.ppiXInput == null ? 0 : PPI.ppiXInput.getButtonMasks(n5);
            }
            if ((n6 & 1 << n7) == 0) continue;
            n4 |= 1 << n3;
        }
        n3 = ~this.lastButtons & n4;
        this.lastButtons = n4;
        n2 = 0;
        for (n = 0; n < 16; ++n) {
            if ((n3 & 1 << n) != 0 && this.map[16 + n] != 0) {
                this.startTimeOf[n] = XEiJ.mpuClockTime + (long)this.map[32 + n] * 1000000000L;
            }
            if ((n4 & 1 << n) == 0 || this.map[16 + n] != 0 && XEiJ.mpuClockTime >= this.startTimeOf[n] && ((int)((XEiJ.mpuClockTime - this.startTimeOf[n]) / ((long)(this.map[48 + n] >> 1) * 1000000000L)) & 1) == 0) continue;
            n2 |= 1 << n;
        }
        return this.page == 0 ? 0xFF & ((n2 & 3) == 1 ? -2 : -1) & ((n2 & 3) == 2 ? -3 : -1) & ((n2 & 0x4000) != 0 ? -4 : -1) & ((n2 & 0xC) == 4 ? -5 : -1) & ((n2 & 0xC) == 8 ? -9 : -1) & ((n2 & 0x8000) != 0 ? -13 : -1) & ((n2 & 0xC0) != 0 ? -33 : -1) & ((n2 & 0x300) != 0 ? -65 : -1) : 0xFF & ((n2 & 0x30) == 16 ? -2 : -1) & ((n2 & 0x30) == 32 ? -3 : -1) & ((n2 & 0x400) != 0 ? -5 : -1) & ((n2 & 0x800) != 0 ? -9 : -1) & ((n2 & 0x1000) != 0 ? -33 : -1) & ((n2 & 0x2000) != 0 ? -65 : -1);
    }
}

